// universum.h			letzte nderung: 14.8.1996

extern int debugflag;
#define DBUG if(debugflag) printf

#include <mathpi.h>

#define XVORCHRISTUS 4800
const double	GRAD=PI/180,		//Umrechnung von Grad in Rad
		AE=1.4959787e11,	//Astronomische Einheit in Meter
	        Gravi=6.672e-11,	//Gravitationskonstante (m/kg/s)
		kgravi=0.01720209895,	//GAUSS-Gravitationskonstante
		clicht=299792500,
		SONNENMASSE=1.9891e30;
const double	Ekl=23.43929111*GRAD;	//Ekliptikneigung in Rad
const double	TAGE=24*60*60.;

class Planet
{
 double sonnenmasse; //bei Monden Masse des umkreisten Planeten
 Planet *planet;     //umkreister Planet oder NULL fr Sonne
public:
 double radius,	//in m
	masse;	//in kg
 char *name;
 double M0,aa,ee,omega,Omega,ii;	//Oskulierende Bahnelemente
   //Einheiten: Winkel: M omega Omega und i in Rad
   //		a in AE,  e ist einheitslos
 double t0,	//Zeitpunkt fr M0 in Tage seit XVORCHRISTUS+1 vor Christus
	t1,M1,	//Momentane Werte
	x,y,z,	//Position
	vx,vy,vz,//Geschwindigkeit
	R,	//Abstand von der Sonne
	U;	//Umlaufzeit in Tagen
 Planet(char*nam,double zeit,double m,double r,	//Werte setzen
	double M,double a,double e,		//alle Winkel in Grad
	double o,double O,double i,Planet *p=NULL);
 void xyz(double t); //xyz-Koordinaten zum Zeitpunkt t berechnen
};

char *t2s(long zeit);
char *d2s(long datum);
char *rad2sdeg(double rad);
char *rad2shou(double rad);
char *machgross(char*);
//long tagedatum(int tag,int monat,int jahr);
//void datum_aus_tagedatum(long tage,int *tag,int *monat,int *jahr);
long local2sternzeit(long zeit,long dat,int zeitzone,long ozeit);
double juldat(long datum,long ortszeit,int zeitzone);
void drehung(double x,double y,double w,double *px,double *py);
inline long idfix(double x) {return long((x<0.0)?x-0.5:x+0.5);}
