/* xguide.cc */
#define VERSION "Version 0.0"
/*
History:
29.12.1999	Erstellung (RPf)

Dieses Programm zeigt Dateien im AmigaGuide-Format unter Unix an.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <ulong.h>

#define MAXARG 2
#define MAXZEIL 120

/*************************** globale Parameter ************************/
char para1[80],para2[80],argflag['Z'+1];

void mystrcpy(char *dest,const char *source)
{
 strncpy(dest,source,80-1);
 dest[80-1]=0;
}

void setflags(char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  argflag[c]=1;}

/** Vordeklarationen: **/

/******************************* Kleinkram ****************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

char *endung(char *s)
{
 char *t= &s[strlen(s)];
 while((t != s) && *--t !='.') ;
 return t;
}

/***************************** Hauptprogramm **************************/
void error(char* s,void* x)
{
 printf("Error in xguide: "); printf(s,x);
 exit(0);
}
void warning(char* s,void* x)
{
 printf("Warning in xguide: "); printf(s,x);
}

int main(int argc,char *argv[])
{
 char zeile[MAXZEIL],str[200];
 int typ= -1;
 FILE *fp;
 int i,j;
 for(para1[0]=para2[0]=0,i=j=1;i<argc;i++)
    if(*argv[i]=='-') setflags(argv[i]);
    else switch(j++)
        {case 1:mystrcpy(para1,argv[i]); break;
         case 2:mystrcpy(para2,argv[i]); break;
        }
 if(j>MAXARG+1 || j==1 || para1[0]=='?')
	{printf("xguide %s\n",VERSION);
	 printf("Anwendung: xguide [-Flags] Datei\n");
	 printf("    Flags: D=debug\n");
	 exit(0);
	}
/*** alle Argumente gelesen ***/
 if(!(fp=fopen(para1,"r"))) error("'%s' nicht gefunden\n",para1);
 getline(fp,zeile,MAXZEIL);
 fclose(fp);
 if(strncmp(zeile,"@DATABASE",9)!=0) warning("'%s' ist keine AmigaGuide-Datei\n",para1);

 if(j==2) sprintf(str,"yless %s %s",para1,para2);//provisorisch
 else sprintf(str,"yless %s",para1);//provisorisch
 if(argflag['D']) printf("system(\"%s\")\n",str);
 system(str);
 return 0;
} /* end of main */
