/* xmultiview.cc */
#define VERSION "Version 0.2"
/*
History:
29.12.1999	Endungen txt, text und guide auch ausgewertet
22.9.1999	auch Test auf Endungen
26.5.1999	Erstellung (RPf)

Dieses Programm ist nicht selbst ein Datei-Anzeigeprogramm,
sondern entscheidet nur welches Anzeigeprogramm fr die
gewnschte Datei benutzt werden soll, und ruft dann dieses
auf.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <ulong.h>

#define MAXARG 1
#define MAXZEIL 120

/************************ Typen und Programmnamen **********************
** Um ein neues Programm zu untersttzen muss hier ein neuer Dateityp
** und der Name des Programms mit dem die Datei verwendet wird
** angefgt werden.
** Weiter unten muss dann natrlich noch auf diesen neuen Dateityp
** geprft werden.
**/
const int
 XV=0, PS=1,IR=2,    UV=3,    XY=4,    EPSV=5,       HTML=6,   TXT=7,     GUIDE=8;
char *progi[]=
{"xv","gv","irshow","uvshow","xyshow","vectmal -qw","showhtml","showtext","showguide"};

/*************************** globale Parameter ************************/
char para1[80],para2[80],argflag['Z'+1];

void setflags(char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  argflag[c]=1;}

/** Vordeklarationen: **/

/******************************* Kleinkram ****************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

char *endung(char *s)
{
 char *t= &s[strlen(s)];
 while((t != s) && *--t !='.') ;
 return t;
}

/***************************** Hauptprogramm **************************/
void error(char* s,void* x)
{
 printf("Error in xmultiview: "); printf(s,x);
 exit(0);
}

int main(int argc,char *argv[])
{
 char zeile[MAXZEIL],str[200];
 int typ= -1;
 FILE *fp;
 int i,j;
 for(para1[0]=para2[0]=0,i=j=1;i<argc;i++)
    if(*argv[i]=='-') setflags(argv[i]);
    else switch(j++)
        {case 1:strcpy(para1,argv[i]); break;
         case 2:strcpy(para2,argv[i]); break;
        }
 if(j>MAXARG+1 || j==1 || para1[0]=='?')
	{printf("xmultiview %s\n",VERSION);
	 printf("Anwendung: xmultiview [-Flags] Datei\n");
	 printf("    Flags: D=debug\n");
	 exit(0);
	}
/*** alle Argumente gelesen ***/
 if(!(fp=fopen(para1,"r"))) error("'%s' nicht gefunden\n",para1);
 getline(fp,zeile,MAXZEIL);

//Auf Dateityp prfen:
//Dateiinhalt untersuchen:
 if(*zeile=='%' && zeile[1]=='!')
   {getline(fp,zeile,MAXZEIL);
    if(strncmp(zeile,"%%Creator: Showit",17)==0) typ=EPSV; else typ=PS;
   }
 else if(strncmp(zeile,"IRTRANS",7)==0) typ=IR;
 else if(strncmp(zeile,"UVOD",4)==0) typ=UV;
 else if(strncmp(zeile,"SPEX2",5)==0) typ=UV;
 else if(strncmp(zeile,"XY  ",4)==0) typ=XY;
 else if(strncmp(zeile,"@DATABASE",9)==0) typ=GUIDE;
 else if(*zeile==0 && zeile[1]==0x4B) typ=IR;
 fclose(fp);
 if(typ<0) //wenn noch kein Erfolg dann Endungen untersuchen:
   {char *endg=endung(para1);
    if(strcmp(endg,".html")==0 || strcmp(endg,".htm")==0) typ=HTML;
    else if(strcmp(endg,".ps")==0 || strcmp(endg,".eps")==0) typ=PS;
    else if(strcmp(endg,".uv")==0) typ=UV;
    else if(strcmp(endg,".ir")==0) typ=IR;
    else if(strcmp(endg,".txt")==0 || strcmp(endg,".text")==0) typ=TXT;
    else if(strcmp(endg,".guide")==0) typ=GUIDE;
   }
 if(typ<0) typ=0;
 sprintf(str,"%s %s",progi[typ],para1);
 if(argflag['D']) printf("system(\"%s\")\n",str);
 system(str);
 return 0;
} /* end of main */
