/* yless.cc			letzte Aenderung: 22.6.2019 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Text in einem x-Fenster anzeigen

History:
20.6.2019       Erstellung (RP)
*/

//#define DEBUG

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <xtekplot1.h>
#define TIEFE 24

int schwarzaufweiss=0; //1=weisser Hintergrund, 0=schwarzer Hintergrund

// Benutzerdefinierte Konstanten:
//#define ULTRAHD //auskommentieren fuer Monitore mit niedrigerer Aufloesung

#ifdef ULTRAHD
//bei 4K-Monitor:
#define FONTNR 5  //als default zu benutzender Font
#define XMAX 1500 //Fensterbreite (850)
#define YMAX 1200 //Fensterhoehe (600)
#define YRAND  10 //Hoehe des oberen Fensterrandes (10)
#else
//wenn nur Fullhd:
#define FONTNR 6  //als default zu benutzender Font
#define XMAX 1050 //Fensterbreite (850)
#define YMAX  700 //Fensterhoehe (600)
#define YRAND   0 //Hoehe des oberen Fensterrandes (10)
#endif

const char *font1="10x20";
const char *font2="12x24";
const char *font3="-adobe-helvetica-bold-o-normal--34-240-100-100-p-182-iso8859-1";
const char *font4="-adobe-helvetica-medium-r-normal--34-240-100-100-p-176-iso8859-1";
const char *font5="-adobe-courier-medium-r-normal--34-240-100-100-m-200-iso8859-1";
const char *font6="-adobe-courier-medium-r-normal--24-240-75-75-m-150-iso8859-1";
const char *font7="-adobe-courier-medium-r-normal--20-140-100-100-m-110-iso8859-1";
const char *fontliste[]= {font1,font2,font3,font4,font5,font6,font7};
const int breitenliste[]={10,   12,   16,   15,   20,   15,   11};
int buchstabenhoehe=20,buchstabenbreite=10;

void buchstabengroesse_ermitteln(const char *fontx)
{
 const char *font=fontx;
 if(font[2]=='x')
  {
   sscanf(font,"%d",&buchstabenbreite);
   sscanf(&font[3],"%d",&buchstabenhoehe);
  }
 else
  {
   while(font[0]!='-' || font[1]!='-')
     if(*font++ == 0)
      {fprintf(stderr,"Fehler: kann Fontgroesse nicht finden\n"); return;}
   font++; font++;
#ifdef DEBUG
   printf("Testpunkt1: \"%s\"\n",font);//test
#endif
   sscanf(font,"%d",&buchstabenhoehe);
   while(*font!=0 && *font++ != '-') {}
   if(*font==0) {buchstabenbreite=buchstabenhoehe*3/4; return;}
   if(fontx==fontliste[FONTNR-1])
    {
#ifdef DEBUG
     printf("Testpunkt2b: breitenliste[%d]=%d\n",
	    FONTNR-1,breitenliste[FONTNR-1]);//test
#endif
     buchstabenbreite=breitenliste[FONTNR-1];
    }
   else
    {
     int druckhoehe,druckbreite; //Druckgroesse in Zehntelpunkten
#ifdef DEBUG
     printf("Testpunkt3: \"%s\"\n",font);//test
#endif
     sscanf(font,"%d",&druckhoehe);
     for(int i=0;i<4;i++) {while(*font!=0 && *font++ != '-') {}}
     if(*font==0) {buchstabenbreite=buchstabenhoehe*3/4; return;}
     sscanf(font,"%d",&druckbreite);
     //buchstabenbreite=(buchstabenhoehe*druckbreite+druckhoehe-1)/druckhoehe;
     buchstabenbreite=(druckbreite+9)/10;
    }
  }
}

/************************* Vordeklarationen ***************************/
void text_zeichnen(const char *txt,const char *font);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}

/************************* Hauptprogramm ******************************/
#define TEXTMAX 4096 //maximale Textgroesse
static char text[TEXTMAX];

int main(int argc,char *argv[])
{
 char quellname[400],userfont[200];
 quellname[0]=userfont[0]=0;
 FILE *fp1;
 int i,j,c;
 int breite,hoehe,tiefe,visklasse;
 double xmin= -0.125,ymin=0.,xmax=1.125,ymax=1.;
 if(argc<=0)
  {j=0;}/* es wurde von WorkBench gestartet */
 else
  {/* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?')
	        {if(argv[i][1]=='f' && i+1<argc) strcpy(userfont,argv[++i]);
		 else setargflags(argv[i]);
		}
	 else	{if(++j==1) strcpy(quellname,argv[i]);
	         //else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j>MAXARG || quellname[0]==0)
	{printf("yless  %s\n",VERSION);
	 printf("Anwendung: yless [-Flags] dateiname.txt\n");
	 printf("  Flags: -fn Font (Beispiel: -fn 12x24)\n");
	 printf("         -w  Weisser Hintergrund\n");
	 exit(0);
	}
 if(argflag['W']) schwarzaufweiss=1;
 //if(argflag['B']) schwarzaufweiss=0;
#ifdef DEBUG
 tek_setdebug(1);//test
#endif
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 setsize(breite,hoehe,tiefe);
 setmenu(1,"File");
 setmenu(1,"Exit",&menu_exit);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */

 if(schwarzaufweiss==1)
  {
   //fuer schwarz auf weiss (default ist weiss auf schwarz):
   if(TIEFE==24)
    {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
   else
    {screenclear(1); color(0);}
  }

 fp1=fopen(quellname,"r");
 if(fp1==NULL)
  {
   sprintf(text,"Datei \"%s\" nicht gefunden.\n",quellname);
  }
 else
  {
   char *s=text;
   for(int i=1;i<TEXTMAX && (c=getc(fp1))!=EOF;i++) {*s++ = c;}
   *s=0;
   fclose(fp1);
  }
 if(userfont[0]!=0) text_zeichnen(text,userfont);
 else               text_zeichnen(text,fontliste[FONTNR-1]);
 term_refresh();
 while(exitflag==0 && waitmenu(1)==0)
	;// auf Benutzereingaben warten
#ifdef DEBUG
 printf("term_exit()\n");//test
#endif
 term_exit();
 return 0;
}/* ende von main */

#define RAND 10

void text_zeichnen(const char *txt,const char *font)
{
 buchstabengroesse_ermitteln(font);
 //int utf8flag=text_auf_utf8_testen(txt);//TODO
 int utf8flag=1; //1 fuer UTF8, 0 fuer normale Codierung (isolatin1)
 int posx=RAND,posy=RAND+buchstabenhoehe; //Cursorposition in Pixel
 const int zeilenlaenge=XMAX-2*RAND;
 int zeilenabstand=buchstabenhoehe*4/3;
 //posy += get_menuleistenhoehe()+buchstabenhoehe+YRAND;
 //posy += buchstabenhoehe+YRAND;
 posy += zeilenabstand+YRAND;
 int bx=buchstabenbreite; //Breite von Buchstaben inkl. Abstand
 itextsize(buchstabenhoehe,buchstabenbreite,font);
#ifdef DEBUG
 printf("Buchstabengroesse: %dx%d\n",buchstabenbreite,buchstabenhoehe);
 printf("Zeilenabstand: %d\n",zeilenabstand);
#endif
 //idrawbox(posx,posy,posx+zeilenlaenge,posy-buchstabenhoehe); //test 1.Zeile
 int ZMAX=zeilenlaenge/bx; //Anzahl Buchstaben in einer Zeile
 char zeile[ZMAX+16];
#ifdef DEBUG
 printf("buchstabenhoehe=%d buchstabenbreite=%d bx=%d\n",
	buchstabenhoehe, buchstabenbreite, bx);
 printf("Anzahl Buchstaben pro Zeile: %d\n",ZMAX);
#endif
 const char *s;
 char *z;
 int i;
 for(z=zeile,s=txt,i=0; i<ZMAX && *s!=0 && *s!='\n'; i++)
  {*z++ = *s++;}
 *z=0; if(*s=='\n') s++;
 if(utf8flag==1) ischrift_utf8(posx,posy,zeile);
 else ischrift(posx,posy,zeile); //Text auf 1.Zeile
 while(*s!=0 && posy<YMAX-zeilenabstand)
  {
   posy += zeilenabstand;
   //idrawbox(posx,posy,posx+zeilenlaenge,posy-buchstabenhoehe); //test
   for(z=zeile,i=0; i<ZMAX && *s!=0 && *s!='\n'; i++)
    {*z++ = *s++;}
   *z=0; if(*s=='\n') s++;
   if(utf8flag==1) ischrift_utf8(posx,posy,zeile);
   else ischrift(posx,posy,zeile); //Text auf aktueller Zeile
  }
}
