/* complexklasse.cc

 Rechnen mit Complexen Zahlen
Anwendung: einfuegen in C++ Programmen
*/

#ifndef COMPLEXKLASSE_CC
#define COMPLEXKLASSE_CC
#include <math.h>
//#include <atan2.cc>
const double PI=4*atan(1.0);
const double ZWEIPI=8*atan(1.0);
const double PIHALBE=2*atan(1.0);

class Complex
{
public:
 double r,i;
 Complex(double a=0,double b=0) {r=a; i=b;}
 Complex operator=(Complex v) {r=v.r; i=v.i; return *this;}
 Complex operator+=(Complex v) {r+=v.r; i+=v.i; return *this;}
 Complex operator-=(Complex v) {r-=v.r; i-=v.i; return *this;}
 Complex operator*=(double z) {r*=z; i*=z; return *this;}
 Complex operator/=(double z) {r/=z; i/=z; return *this;}
 Complex operator*=(Complex v) {return (*this) = (*this)*v;}
 friend Complex operator+(Complex,Complex);
 friend Complex operator-(Complex,Complex);
 friend Complex operator*(Complex,double);
 friend Complex operator*(double,Complex);
 friend Complex operator*(Complex,Complex);
 friend Complex operator/(Complex,double);
 friend Complex operator/(Complex,Complex);
 friend Complex operator-(Complex);
 char* s();
};
char* Complex::s()
{
 char plus; double y;
 static char str[80];
 if(i<0) {plus='-'; y= -i;}
 else  {plus='+'; y=i;}
 sprintf(str,"%lg%c%lgi",r,plus,y);
 return str;
}
Complex operator+(Complex v1,Complex v2)
{
 Complex z; z.r=v1.r+v2.r; z.i=v1.i+v2.i;
 return z;
}
Complex operator-(Complex v1,Complex v2)
{
 Complex z; z.r=v1.r-v2.r; z.i=v1.i-v2.i;
 return z;
}
Complex operator*(Complex v1,double c)
{
 Complex z; z.r=v1.r*c; z.i=v1.i*c;
 return z;
}
Complex operator*(double c,Complex v1)
{
 Complex z; z.r=v1.r*c; z.i=v1.i*c;
 return z;
}
Complex operator*(Complex v1,Complex v2)
{
 Complex z; z.r=v1.r*v2.r-v1.i*v2.i; z.i=v1.r*v2.i+v2.r*v1.i;
 return z;
}
Complex operator/(Complex v1,double c)
{
 Complex z; z.r=v1.r/c; z.i=v1.i/c;
 return z;
}
Complex operator/(Complex v1,Complex v2)
{
 Complex z,d,y;
 d.r=v2.r; d.i= -v2.i;
 y=v2*d;
 z=v1*d/y.r;
 return z;
}
Complex operator-(Complex v1)
{
 Complex z; z.r= -v1.r; z.i= -v1.i;
 return z;
}

double abs(Complex v)				//Betrag
{
 return sqrt(v.r*v.r+v.i*v.i);
}

extern "C" {
Complex csqrt(double,double);
}

Complex sqrt(Complex x)
{
 Complex z; double alfa,c,sc;
 alfa=0.5*atan2(x.i,x.r);
 c=abs(x); sc=sqrt(c);
 z.r=sc*cos(alfa);
 z.i=sc*sin(alfa);
 return z;
}

Complex exp(Complex x)
{
 Complex z;
 double ea=exp(x.r);
 z.r=ea*cos(x.i);
 z.i=ea*sin(x.i);
 return z;
}

Complex complex2euler(Complex x)
{
 Complex z;
 z.r=sqrt(x.r*x.r+x.i*x.i);
 z.i=atan2(x.i,x.r);
 return z;
}

Complex euler2complex(Complex x)
{
 Complex z;
 z.r=x.r*cos(x.i);
 z.i=x.r*sin(x.i);
 return z;
}

Complex powc(Complex z,double x)
{
 z = complex2euler(z);
 z.r = pow(z.r,x);
 z.i *= x;
 if(z.i>=0) {while(z.i >= ZWEIPI) z.i -= ZWEIPI;}
 else      {while(z.i <= -ZWEIPI) z.i += ZWEIPI;}
 return euler2complex(z);
}

Complex cbrt(Complex z) //Kubikwurzel, nur 1.Loesung
{
 double x=1.0/3.0;
 z = complex2euler(z);
 z.r = pow(z.r, x);
 z.i *= x;
 return euler2complex(z);
}

Complex root(Complex z,int n,int k) //nte Wurzel, kte Loesung
{
 double x=1.0/n;
 z = complex2euler(z);
 z.r = pow(z.r, x);
 z.i *= x;
 if(k>0 && k<n) z.i += ZWEIPI*k/n;
 return euler2complex(z);
}

int kubikwurzel(Complex z,Complex loesungen[])
{
 double x=1.0/3.0;
 z = complex2euler(z);
 z.r = pow(z.r, x);
 z.i *= x;
 //if(z.i>=0) {while(z.i >= ZWEIPI) z.i -= ZWEIPI;}
 //else      {while(z.i <= -ZWEIPI) z.i += ZWEIPI;}
 loesungen[0]=euler2complex(z);
 z.i += ZWEIPI/3;
 loesungen[1]=euler2complex(z);
 z.i += ZWEIPI/3;
 loesungen[2]=euler2complex(z);
 return 3;
}
#endif
