/* polynom.cc       letzte Aenderung: 5.4.2022 */
#define VERSION "Version 1.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Rechnen mit Komplexen Zahlen

History:
30.3.2022        Erstellung (RP)
5.4.2022    1.0  
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include "complexklasse.h"

/************************* Vordeklarationen ***************************/


/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 4
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while((c= *s++)!=0)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*********************((**** Kleinkram **((((**************************/
void vertauschen(int *a, int *b)
{
 int h = *a;
 *a = *b;
 *b = h;
}

bool fastgleich(double a,double b,double dd)
{
 if(a==b) return true;
 if(a>10 && b>10) dd *= a; //fuer grosse Zahlen muss dd justiert werden
 else if(a< -10 && b< -10) dd *= -a;
 //if(dd!=1e-7) printf("fastgleich(a=%f, b=%f, dd=%g)\n",a,b,dd);//test
 if(a<b && a >= b-dd) return true;
 return (b<a && b >= a-dd);
}

/************************ eigene Klassen ******************************/
class Stack
{
public:
 Complex xyzt[4], x,y;
 int nte=0,ne=0;
 Stack() {for(int i=0;i<4;i++) xyzt[i]=0.0;}
 void push(Complex a) {
  for(int i=4;--i>0;) xyzt[i]=xyzt[i-1];
  xyzt[0]=a;
 }
 void print();
 void nachruecken() {for(int i=1;i<4-1;i++) xyzt[i]=xyzt[i+1];}
 void add() {xyzt[0] += xyzt[1]; nachruecken();}
 void sub() {xyzt[0] = xyzt[1]-xyzt[0]; nachruecken();}
 void mul() {xyzt[0] *= xyzt[1]; nachruecken();}
 void div() {xyzt[0] = xyzt[1]/xyzt[0]; nachruecken();}
 void eu() {xyzt[0]=complex2euler(xyzt[0]);}
 void ue() {xyzt[0]=euler2complex(xyzt[0]);}
 void sqrt() {y=xyzt[0]; xyzt[0]=powc(xyzt[0], 0.5); nte=2; ne=1;}
 void cbrt() {y=xyzt[0]; xyzt[0]=powc(xyzt[0], 1.0/3.0); nte=3; ne=1;}
 void rt() {ne=0; nte=xyzt[0].r; y=xyzt[1]; pop(); next();}
 void next() {
  if(nte>0)      {xyzt[0] = root(y,nte,ne++);}
  else if(nte<0) {xyzt[0] = 1.0 / root(y,-nte,-ne); ne--;}
  if(ne==nte) ne=0;
 }
 void expe() {xyzt[0]=exp(xyzt[0]);}
 void pow() {xyzt[0] = powc(xyzt[1], xyzt[0].r); nachruecken();}
 //void pow2() {xyzt[0] = powcc(xyzt[1], xyzt[0]);} //TODO: hoch Complex?
 void pop() {xyzt[0]=xyzt[1]; nachruecken();}
 void xchg() {Complex h=xyzt[1]; xyzt[1]=xyzt[0]; xyzt[0]=h;}
};

void Stack::print()
{
 for(int i=4;--i>=0;) printf("%s\n",xyzt[i].s());
}
 
/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 //char quellname[80],zielname[80];
 //quellname[0]=zielname[0]=0;
 //FILE *fp1,*fp2;
 int i=0,j=0,c;
 double a[MAXARG];
 if(argc>0)
  for(j=0,i=1;i<argc;i++)
   {
    if((c= *argv[i])=='?' || (c=='-' && !isdigit(argv[i][1])))
     {setargflags(argv[i]);}
    else if(++j>=1 && j<=MAXARG)
     {sscanf(argv[i],"%lf",&a[j-1]);}
   }
 if(argflag['?'] || j>MAXARG)
  {
   printf("%s  %s\n",argv[0],VERSION);
   printf("Anwendung: %s [-Flags]\n",argv[0]);
   printf("  Flags: v = Testausdrucke\n");
   exit(0);
  }

 Stack stack;
 for(;;)
  {
   char eingabe[1024];
   Complex x;
   stack.print();
   printf("> "); scanf("%s",eingabe);
   if(isdigit(eingabe[0]) || *eingabe=='.' ||
      (eingabe[0]=='-' && (isdigit(eingabe[1]) || eingabe[1]=='.')))
    {
     char ch=0;
     sscanf(eingabe,"%lf%c%lf",&x.r, &ch, &x.i);
     if(ch=='-') x.i = -x.i;
     stack.push(x);
    }
   else if(*eingabe=='+') stack.add();
   else if(*eingabe=='-') stack.sub();
   else if(*eingabe=='*') stack.mul();
   else if(*eingabe=='/') stack.div();
   else if(*eingabe=='x') stack.xchg();
   else if(strncmp(eingabe,"eu",2)==0) stack.eu();
   else if(strncmp(eingabe,"ue",2)==0) stack.ue();
   else if(strncmp(eingabe,"push",4)==0) stack.push(stack.xyzt[0]);
   else if(strncmp(eingabe,"pop",3)==0) stack.pop();
   else if(strncmp(eingabe,"pow",3)==0) stack.pow();
   else if(strncmp(eingabe,"exp",3)==0) stack.expe();
   else if(strncmp(eingabe,"sqrt",4)==0) stack.sqrt();
   else if(strncmp(eingabe,"cbrt",4)==0) stack.cbrt();
   else if(strncmp(eingabe,"rt",2)==0) stack.rt();
   else if(strncmp(eingabe,"ne",2)==0) stack.next();
   else if(strncmp(eingabe,"Pi",2)==0 || strncmp(eingabe,"pi",2)==0)
    {Complex pi(4*atan(1.0)); stack.push(pi);}
   //TODO
   else if(strcmp(eingabe,"quit")==0 || strcmp(eingabe,"exit")==0) break;
   else //if(*eingabe=='?' || *eingabe=='h')
    {
     printf("Zahl eingeben z.B: 12.345\n");
     printf("Komplexe Zahl eingeben: 12.345+6.78i\n");
     printf(" eu = in Eulerform umwandeln\n");
     printf(" ue = von Eulerform zurueckwandeln\n");
     printf(" pop = x von Stack entfernen\n");
     printf(" push = x im Stack verdoppeln\n");
     printf(" xchg = x,y im Stack vertauschen\n");
     printf(" pow = y^x (x ohne Complex-Teil)\n");
     printf(" sqrt = Wurzel(x)\n");
     printf(" cbrt = Kubikwurzel(x)\n");
     printf(" rt = xte Wurzel von y\n");
     printf(" ne = naechste Loesung von xte Wurzel\n");
     printf(" quit = exit = Programm verlassen\n");
    }
  }
 
 return 0;
}// ende von main
