/* polynom.cc       letzte Aenderung: 5.4.2022 */
#define VERSION "Version 0.3"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

Loesung eines Polynoms 5.Grades
Loesungsformeln fuer Polynome bis 4.Grades,
fuer 5.Grad und hoeher ist es unmoeglich eine Loesungsformel zu finden.

History:
29.3.2022        Erstellung (RP)
31.3.2022  0.1   Formeln fuer auch Komplexe Loesungen
3.4.2022   0.2   Rate-Routinen, Parametereingabe mit Textdatei
5.4.2022   0.3   Spezialfall x^n-c0=0

*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "complexklasse.h"

/************************* Vordeklarationen ***************************/

/**************** Routinen zur Parameterauswertung ********************/
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while((c= *s++)!=0)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/
double myabs(double x) {return (x>=0) ? x : -x;}

bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF); // true wenn erfolgreich
}

void vertauschen(int *a, int *b)
{
 int h = *a;
 *a = *b;
 *b = h;
}

bool fastgleich(double a,double b,double dd)
{
 if(a==b) return true;
 if(a>10 && b>10) dd *= a; //fuer grosse Zahlen muss dd justiert werden
 else if(a< -10 && b< -10) dd *= -a;
 //if(dd!=1e-7) printf("fastgleich(a=%f, b=%f, dd=%g)\n",a,b,dd);//test
 if(a<b && a >= b-dd) return true;
 return (b<a && b >= a-dd);
}

bool fastgleich(Complex a,Complex b,double dd)
{
 return fastgleich(a.r,b.r,dd) && fastgleich(a.i,b.i,dd);
}

void rundungsfehler_korrgieren(Complex& x)
{
 const double dd=1e-12;
 if(x.r!=0 && fastgleich(x.r,0.0,dd)) x.r=0;
 if(x.i!=0 && fastgleich(x.i,0.0,dd)) x.i=0;
}

bool cvonbisgleichnull(double c[],int von,int bis,int step=1)
{
 for(int i=von;i<=bis;i+=step)
  {if(c[i]!=0) return false;}
 return true;
}

bool cvonbisnur3teilbar(double c[],int von,int bis)
{
 for(int i=von;i<=bis;i++)
  {if(i/3*3 != i && c[i]!=0) return false;}
 return true;
}

/************************ eigene Klassen ******************************/
#define MAX 9 //maximaler Polynomgrad
#define MAXARG (MAX+1)

double coeff[MAXARG];
double ddzstart=1.0/1024.0; //TODO
double ddz=1e-4; //Parameter fuer loesungen_raten()
double ddy=1e-3; //Parameter fuer loesungen_raten()
double realmin= -2, realmax=2;
double imagmin= -2, imagmax=2;
Complex vermutung;
bool vermutflag=false;

class Polynom
{
public:
 int ordnung;
 double c[MAX+1];
 Polynom(int n) {ordnung=n; for(int i=0;i<MAX+1;i++) c[i]=0;}
 Polynom(int n,double a[])
 {
  ordnung=n;
  for(int i=0;i<=n;i++) c[i]=a[i];
 }
 int loesen(double *loesungen,Complex *complexelsg=NULL,int* pnc=NULL);
 int loesungen_raten(Complex *complexelsg,int nsoll);
 int loesungen_raten_euler(Complex *complexelsg,int nsoll);
 double loesung_zwischen_x1undx2_suchen(double x1,double x2);
 double loesung_vor_x1_suchen(double x1);
 double loesung_nach_x2_suchen(double x2);
 double fun(double x);
 Complex fun(Complex x);
 void ableiten()
 {
  c[0] = c[1];
  for(int i=2;i<=ordnung;i++)
    c[i-1] = i*c[i];
  ordnung--;
 }
};

double Polynom::fun(double x)
{
 double y = c[0], z=1;
 for(int i=1;i<=ordnung;i++) {z *= x; y += c[i]*z;}
 return y;
}

Complex Polynom::fun(Complex x)
{
 //static int test=2;
 Complex y(c[0]), z(1);
 //if(test>0) printf("fun(Complex %s)\n",x.s());//test
 for(int i=1;i<=ordnung;i++) {z *= x; y += c[i]*z;}
 //if(test>0) {printf(" y = %s\n",y.s()); --test;}
 return y;
}

double Polynom::loesung_zwischen_x1undx2_suchen(double x1,double x2)
{
 double y1,y2;
 if(x1==x2) //wenn Grenzen noch nicht gesetzt, Grenzen suchen
  {
   double x0=x1;
   x1= -1; x2=1;
   for(;;)
    {
     y1=fun(x1+x0); y2=fun(x2+x0);
     if(y1<0 && y2>0) break;
     if(y1>0 && y2<0) break;
     x1 *= 2; x2 *=2;
    }
   x1 += x0; x2 += x0;
  }
 //Loesung muss zwischen x1 und x2 sein
 //printf("suche zwischen: x1 = %f und x2 = %f\n",x1,x2);//test
 y1=fun(x1); y2=fun(x2);
 const double dd=1e-9;
 while(!fastgleich(x1,x2,dd))
  {
   double x=(x1+x2)/2;
   double y=fun(x);
   if(y==0) return x;
   if((y1<0 && y>0) || (y1>0 && y<0)) {x2=x; y2=y;}
   else if((y2<0 && y>0) || (y2>0 && y<0)) {x1=x; y1=y;}
   //printf("neues: x1 = %f  x2 = %f\n",x1,x2);//test
  }
 return x1;
}

double Polynom::loesung_vor_x1_suchen(double x1)
{
 //printf("loesung vor x1 = %f suchen\n",x1);//test
 double x2=x1,x0=x1;
 double y2=fun(x2);
 for(x1=1;;)
  {
   double y1=fun(x0-x1);
   if(y1<0 && y2>0) break;
   if(y1>0 && y2<0) break;
   x1 *= 2;
  }
 x1=x0-x1;
 //Loesung muss zwischen x1 und x2 sein
 return loesung_zwischen_x1undx2_suchen(x1,x2);
}

double Polynom::loesung_nach_x2_suchen(double x2)
{
 //printf("loesung nach x2 = %f suchen\n",x2);//test
 double x1=x2,x0=x2;
 double y1=fun(x1);
 for(x2=1;;)
  {
   double y2=fun(x0+x2);
   if(y1<0 && y2>0) break;
   if(y1>0 && y2<0) break;
   x2 *= 2;
  }
 x2=x0+x2;
 //Loesung muss zwischen x1 und x2 sein
 return loesung_zwischen_x1undx2_suchen(x1,x2);
}

bool schonvorhanden(double x,double *loesungen,int nr,double dd)
{
 for(int i=0;i<nr;i++)
  if(fastgleich(x,loesungen[i],dd)) {return true;}
 return false;
}

bool schonvorhanden(Complex z,Complex *lsg,int nc,double dd)
{
 for(int i=0;i<nc;i++)
  if(fastgleich(z,lsg[i],dd)) {return true;}
 return false;
}

int Polynom::loesen(double *loesungen,Complex *complexelsg,int* pnc)
{
 const double dd=1e-8;
 const double ddv=1e-5;
 int n=ordnung;
 if(argflag['V']) printf("Polynom::loesen() ordnung=%d\n",n);//test
 if(n<1) printf("Fehler: n muss groesser gleich 1 sein\n");
 else if(n>MAX) printf("Fehler: n=%d zu gross (auf %d beschraenkt)\n",n,MAX);
 else if(n==1)
  {
   loesungen[0] = -c[0]/c[1];
   return 1;
  }
 else if(n==2)
  {
   double wu=c[1]*c[1]-4*c[2]*c[0];
   if(wu<0.0)
    {
     if(complexelsg!=NULL)
      {
       int nc=0;
       Complex z(wu);
       z=sqrt(z);
       Complex x;
       x=(z-c[1])/(2*c[2]);
       rundungsfehler_korrgieren(x);
       //printf("Complexe Loesung: %s\n",x.s());//test
       complexelsg[nc++]=x;
       x=((-z)-c[1])/(2*c[2]);
       rundungsfehler_korrgieren(x);
       //printf("Complexe Loesung: %s\n",x.s());//test
       complexelsg[nc++]=x;
       *pnc = nc;
      }
     return 0;
    }
   if(pnc!=NULL) *pnc = 0;
   loesungen[0] = (sqrt(wu)-c[1])/(2*c[2]);
   if(wu==0.0) return 1;
   loesungen[1] = (-sqrt(wu)-c[1])/(2*c[2]);
   return 2;
  }
 else if(n==3 && !argflag['D'])
  {//Loesungsformel fuer Kubische Gleichung
   printf("rechnen mit Loesungsformel fuer Kubische Gleichung\n");//test
   int nr=0;//Anzahl reelle Loesungen
   double A,B,C,p,q;
   A=c[2]/c[3];
   B=c[1]/c[3];
   C=c[0]/c[3];
   p = B-A*A/3;
   q = A*A*A*2/27 - A*B/3 + C;
   double p3=p/3; p3=p3*p3*p3;
   double wu= q*q/4+p3;
   if(wu>=0)
    {
     double z,z1,z2;
     z1 = -q/2 + sqrt(wu);
     z2 = -q/2 - sqrt(wu);
     z = cbrt(z1)+cbrt(z2); //dritte Wurzeln ziehen
     double x = z-A/3;
     if(argflag['V']) printf("Loesung ohne Complexe Zahlen gefunden\n");//test
     loesungen[nr++]=x;
    }
   //else //fuer weitere Loesungen sowieso complex rechnen:
    {
     Complex x,z,z1,z2,w(wu);
     int nc=0;//Anzahl complexe Loesungen
     w=powc(w,0.5);
     z1 = -q/2+w;
     z2 = -q/2-w;
     Complex zw1[3],zw2[3];
     int n=kubikwurzel(z1,zw1);
     if(argflag['V'])
      {
       printf(" kubikwurzel liefert %d Loesungen\n",n);//test
       printf("  1.: %s\n",zw1[0].s());//test
       printf("  2.: %s\n",zw1[1].s());//test
       printf("  3.: %s\n",zw1[2].s());//test
      }
     n=kubikwurzel(z2,zw2);
     if(argflag['V'])
      {
       printf(" kubikwurzel liefert %d Loesungen\n",n);//test
       printf("  1.: %s\n",zw2[0].s());//test
       printf("  2.: %s\n",zw2[1].s());//test
       printf("  3.: %s\n",zw2[2].s());//test
      }
     for(int i=0;i<3;i++)
     for(int j=0;j<3;j++)
      {
       z = zw1[i] + zw2[j];
       x = z-A/3;
       if(fastgleich(x.i,0.0,dd))
	{
	 if(!schonvorhanden(x.r,loesungen,nr,ddv)) loesungen[nr++]=x.r;
	 if(argflag['V']) printf("i=%d j=%d: reelle Loesung\n",i,j);//test
	}
       else if(complexelsg!=NULL)
	{
	 if(!schonvorhanden(x,complexelsg,nc,ddv))
	  {
	   Complex t; t=powc(x,3)+x*x*A+x*B+C;
	   if(fastgleich(t.r,0.0,dd) && fastgleich(t.i,0.0,dd))
	    {
	     rundungsfehler_korrgieren(x);
	     //printf("Komplexe Loesung: %s\n",x.s());//test
	     complexelsg[nc++]=x;
	    }
	   else if(argflag['V'])
	    printf("i=%d j=%d falsche Loesung: %s\n",i,j,x.s());//test
	  }
	}
      }
     if(pnc!=NULL) *pnc = nc;
     return nr;
    }
  }
 else if(c[0]!=0 && cvonbisgleichnull(c,1,ordnung-1))
  {//Spezialfall: x^n+c0=0
   Complex x,z; z.r= -c[0]; z.i=0;
   int nr=0,nc=0;
   for(int i=0;i<ordnung;i++)
    {
     x = root(z,ordnung,i);
     rundungsfehler_korrgieren(x);
     if(fastgleich(x.i,0.0,1e-6)) loesungen[nr++] = x.r;
     else if(complexelsg!=NULL) complexelsg[nc++] = x;
    }
   if(pnc!=NULL) *pnc = nc;
   return nr;
  }
 else if((ordnung&1)==0 && cvonbisgleichnull(c,1,ordnung-1,2))
  {//Spezialfall: nur gerade Potenzen
   Polynom p2(ordnung/2);
   for(int i=0;i<=ordnung;i+=2) {p2.c[i/2] = c[i];}
   double loes2[MAX];
   Complex cloes2[MAX];
   int nr2=0,nc2=0;
   if(complexelsg==NULL) nr2=p2.loesen(loes2);
   else  nr2=p2.loesen(loes2,cloes2,&nc2);
   int nr=0,nc=0;
   for(int i=0;i<nr2;i++)
    {
     if(loes2[i]==0) loesungen[nr++]=0;
     else if(loes2[i]>0)
      {
       loesungen[nr++] = sqrt(loes2[i]);
       loesungen[nr++] = -sqrt(loes2[i]);
      }
     else if(complexelsg!=NULL)
      {
       Complex x, z(loes2[i]);
       x = sqrt(z);  rundungsfehler_korrgieren(x);
       complexelsg[nc++] = x;
       x = -sqrt(z);  rundungsfehler_korrgieren(x);
       complexelsg[nc++] = x;
      }
    }
   for(int i=0;i<nc2;i++)
    {
     Complex x, z(cloes2[i]);
     x = sqrt(z);  rundungsfehler_korrgieren(x);
     complexelsg[nc++] = x;
     x = -sqrt(z);  rundungsfehler_korrgieren(x);
     complexelsg[nc++] = x;
    }
   if(pnc!=NULL) *pnc = nc;
   return nr;
  }
 else if((ordnung/3*3==ordnung) && cvonbisnur3teilbar(c,1,ordnung-1))
  {//Spezialfall: nur durch 3 teilbare Potenzen
   Polynom p2(ordnung/3);
   for(int i=0;i<=ordnung;i+=3) {p2.c[i/3] = c[i];}
   double loes2[MAX];
   Complex cloes2[MAX];
   int nr2=0,nc2=0;
   if(complexelsg==NULL) nr2=p2.loesen(loes2);
   else  nr2=p2.loesen(loes2,cloes2,&nc2);
   printf("Spezialfall nur durch 3 teilbare Potenzen, nr2=%d nc2=%d\n",nr2,nc2);//test
   int nr=0,nc=0;
   for(int i=0;i<nr2;i++)
    {
     if(loes2[i]==0) loesungen[nr++]=0;
     else
      {
       Complex x, z(loes2[i]);
       for(int j=0;j<3;j++)
	{
	 x = root(z,3,j);  rundungsfehler_korrgieren(x);
	 if(fastgleich(x.i,0.0,1e-6)) loesungen[nr++] = x.r;
	 else if(complexelsg!=NULL) complexelsg[nc++] = x;
	}
      }
    }
   for(int i=0;i<nc2;i++)
    {
     Complex x, z(cloes2[i]);
     for(int j=0;j<3;j++)
      {
       x = root(z,3,j);  rundungsfehler_korrgieren(x);
       if(fastgleich(x.i,0.0,1e-6)) loesungen[nr++] = x.r;
       else complexelsg[nc++] = x;
      }
    }
   if(pnc!=NULL) *pnc = nc;
   return nr;
  }
 else if(n==4 && !argflag['D'])
  { //Loesungsformel Gleichung 4.Grades
   int nr=0;//Anzahl reelle Loesungen
   int nc=0;//Anzahl complexe Loesungen
   double A=c[4],B=c[3],C=c[2],D=c[1],E=c[0];
   double B2=B*B, B3=B2*B, A2=A*A, A3=A2*A;
   double alfa = -3*B2/(8*A2) + C/A;
   double beta = B3/(8*A3) - B*C/(2*A2) + D/A;
   double gamma = -3*B2*B2/(256*A2*A2) + B2*C/(16*A3) - B*D/(4*A2) + E/A;
   if(argflag['V']) printf("u^4 + alfa*u^2 + beta*u + gamma = 0\n");//test
   if(argflag['V']) printf("  alfa = %f  beta = %f  gamma = %f\n",alfa,beta,gamma);
   double p = -alfa*alfa/12 - gamma;
   double q = -alfa*alfa*alfa/108 + alfa*gamma/3 - beta*beta/8;
   Complex y = -5*alfa/6;
   if(p==0)
    {y -= cbrt(q);} //cbrt=Kubikwurzel
   else
    {
     Complex wu=q*q/4+p*p*p/27;
     wu=sqrt(wu);
     Complex u = cbrt(wu-q/2);
     y += u-p/(3*u);
    }
   Complex alfaplus2y = alfa+2*y;
   Complex w= sqrt(alfaplus2y);
   for(int s= -1;s<=1;s+=2)
   for(int r= -1;r<=1;r+=2)
    {
     //Complex wu= -alfaplus2y - 2*(alfa+s*beta/w); //Variante1
     Complex wu= w*w - 4*(alfa+y+s*beta/(2*w)); //Variante2
     wu=sqrt(wu);
     Complex x = -B/(4*A) + (s*w+r*wu)/2;
     if(fastgleich(x.i,0.0,dd))
      {
       if(!schonvorhanden(x.r,loesungen,nr,ddv))
	loesungen[nr++]=x.r;
      }
     else if(complexelsg!=NULL)
      {
       rundungsfehler_korrgieren(x);
       //printf("Complexe Loesung: %s\n",x.s());//test
       if(!schonvorhanden(x,complexelsg,nc,ddv))
	complexelsg[nc++]=x;
      }
    }
   if(pnc!=NULL) *pnc = nc;
   return nr;
  }
 else //n>=5
  {
   Polynom ableitung(ordnung,c); ableitung.ableiten();
   Polynom ableitung2(ableitung.ordnung,ableitung.c); ableitung2.ableiten();
   double extremx[MAX],extremy[MAX],extrembiegung[MAX];
   double ymin=0,ymax=0;
   int n=ableitung.loesen(extremx);
   printf("Ordnung%d: %d Extrempunkte gefunden:\n",ordnung,n);//test
   int sort[MAX];
   if(n>0)
    {
     for(int i=0;i<n;i++)
      {
       double x=extremx[i];
       double y=fun(x);
       sort[i]=i;
       extremy[i]=y;
       extrembiegung[i]=ableitung2.fun(x);
       if(i==0 || y<ymin) {ymin=y;}
       if(i==0 || y>ymax) {ymax=y;}
      }
     for(int vertauschungen=1; vertauschungen!=0; )
      {
       vertauschungen=0;
       for(int i=0;i<n-1;i++)
	for(int j=i+1;j<n;j++)
	 {
	  if(extremx[sort[j]] < extremx[sort[i]])
	   {vertauschen(&sort[i],&sort[j]); vertauschungen++;}
	 }
      }
     for(int i=0;i<n;i++) //test: sortierte Liste der Extrempunkte drucken
      {
       int k=sort[i];
       printf(" x: %f y: %f  biegung: %f\n",
	      extremx[k],extremy[k],extrembiegung[k]);
      }
     printf("\n");//test
    }
   int nloesungen=0; //Anzahl schon gefundene Loesungen
   if((ordnung&1) && (n==0 || (ymin>0 && ymax>0) || (ymin<0 && ymax<0)))
    {//nur 1 reelle Loesung wenn ordnung ungerade, keine wenn gerade
     double x = loesung_zwischen_x1undx2_suchen(0,0);
     loesungen[nloesungen++] = x;
    }
   int nsoll=ordnung; //es gibt maximal soviele Loesungen
   for(int i=0;i<n;i++) //sortierte Liste nach Loesungen absuchen
    {
     int k=sort[i];
     if(extremy[k]==0)
      {
       if(!schonvorhanden(extremx[k],loesungen,nloesungen,ddv))
	loesungen[nloesungen++] = extremx[k];
       --nsoll;
       if(nsoll==0) printf("Fehler: zu viele Loesungen gefunden\n");//test
      }
    }
   for(int i=1;i<n;i++) //nach Loesungen zwischen Extremwerten suchen
    {
     int k1=sort[i-1], k2=sort[i];
     if((extremy[k1]<0 && extremy[k2]>0) || (extremy[k1]>0 && extremy[k2]<0))
      {
       double x=loesung_zwischen_x1undx2_suchen(extremx[k1],extremx[k2]);
       if(!schonvorhanden(x,loesungen,nloesungen,ddv))
	loesungen[nloesungen++] = x;
      }
    }
   if(n>=1)
    {
     double x1,x2;
     int k=sort[0];
     if(ordnung&1) //bei ungerader Ordnung
      {
       if((c[ordnung]>0 && extremy[k]>0) ||
	  (c[ordnung]<0 && extremy[k]<0))
	{
	 x1=extremx[k];
	 double x=loesung_vor_x1_suchen(x1);
	 if(!schonvorhanden(x,loesungen,nloesungen,ddv))
	  loesungen[nloesungen++] = x;
	}
       k=sort[n-1];
       if((c[ordnung]>0 && extremy[k]<0) ||
	  (c[ordnung]<0 && extremy[k]>0))
	{
	 x2=extremx[k];
	 double x=loesung_nach_x2_suchen(x2);
	 if(!schonvorhanden(x,loesungen,nloesungen,ddv))
	  loesungen[nloesungen++] = x;
	}
      }
     else //bei gerader Ordnung
      {
       if(extremy[k]<0)
	{
	 double x1=extremx[k];
	 double x=loesung_vor_x1_suchen(x1);
	 if(!schonvorhanden(x,loesungen,nloesungen,ddv))
	  loesungen[nloesungen++] = x;
	}
       k=sort[n-1];      
       if(extremy[k]<0)
	{
	 double x2=extremx[k];
	 double x=loesung_nach_x2_suchen(x2);
	 if(!schonvorhanden(x,loesungen,nloesungen,ddv))
	  loesungen[nloesungen++] = x;
	}
      }
    }
   int nc=0;
   if(nloesungen<nsoll && complexelsg!=NULL)
    {
     if(nloesungen!=0)
      {
       printf("bisher %d reelle Loesungen gefunden:\n",nloesungen);
       for(int i=0;i<nloesungen;i++)
	printf("  %f\n",loesungen[i]);
      }
     if(argflag['E'])
      nc=loesungen_raten_euler(complexelsg,nsoll-nloesungen);
     else
      nc=loesungen_raten(complexelsg,nsoll-nloesungen);
    }
   if(nloesungen+nc == nsoll && (complexelsg!=NULL || argflag['V']))
     printf("ordnung%d: alle Loesungen gefunden\n",ordnung);//test
   if(pnc!=NULL) *pnc = nc;
   return nloesungen;
  }
 return 0;
}

void bestenliste_aktualisieren(Complex z,double ay,
			       double *bestay, Complex *bestz,int max)
{
 for(int i=0;i<max;i++) //schon in Bestenliste?
  {if(fastgleich(bestz[i],z,1e-3)) return;}
 for(int i=0;i<max;i++) //mit Bestenliste vergleichen
  if(ay<bestay[i])
   {
    for(int j=max;--j>i;)
     {bestay[j]=bestay[j-1]; bestz[j]=bestz[j-1];}
    bestay[i]=ay; bestz[i]=z;
    return;
   }
}

int Polynom::loesungen_raten(Complex *complexelsg,int nsoll)
{
 const double dd=1e-8;
 printf("loesungen_raten(..,nsoll=%d)\n",nsoll);//test
 int nc=0;//Anzahl Loesungen
 Complex z,y,h;
 double ay, bestay[MAX];
 Complex bestz[MAX];
 for(int i=0;i<MAX;i++) {bestz[i]=0; bestay[i]=1e9;} 
 //weiter oben global definiert: double realmin,realmax,imagmin,imagmax;
 double dz,dstart; //TODO: ddz ddy justieren (oben global)
 for(dz=ddzstart,dstart=0; dz>=ddz; dz*=0.5,dstart=dz/2)
  {printf("dz=%g dstart=%g\n",dz,dstart);//test
 for(z.r=realmin+dstart; z.r<=realmax; z.r+=dz)
  {//printf(" z.r = %f\n",z.r);//test
  for(z.i=imagmin+dstart; z.i<=imagmax; z.i+=dz)
   {
    //if(dz==ddzstart) printf(" z = %s\n",z.s());//test
    y = fun(z);
    ay=abs(y);
    if(ay<ddy)
     {
      if(myabs(z.i)>1e-3) //nur complexe Loesungen beruecksichtigen
       {
	if(!schonvorhanden(z,complexelsg,nc,ddy))
	 {
	  complexelsg[nc++]=z;
	  if(--nsoll==0) return nc;
	  printf("Loesung durch raten gefunden: %s\n",z.s());//test
	 }
       }
     }
    else if(myabs(z.i)>0.1) //nur eindeutig complexe beruecksichtigen
     {
      bestenliste_aktualisieren(z,ay,bestay,bestz,MAX);
     }
   }
  }
  }
 printf("beste gefundene Werte:\n");
 for(int i=0;i<MAX;i++)
  {
   printf(" abs(y) = %f  z = %s\n",bestay[i],bestz[i].s());
   if(bestay[i]>=1e9) break;
  }
 return nc;
}

int Polynom::loesungen_raten_euler(Complex *complexelsg,int nsoll)
{
 const double dd=1e-8;
 printf("loesungen_raten(..,nsoll=%d)\n",nsoll);//test
 int nc=0;//Anzahl Loesungen
 Complex ze,z,y,h;
 double ay, bestay[MAX];
 Complex bestz[MAX];
 for(int i=0;i<MAX;i++) {bestz[i]=0; bestay[i]=1e9;} 
 double dz;
 double rmax=sqrt(realmax*realmax+imagmax*imagmax);
 for(dz=ddzstart; dz>=ddz; dz*=0.5)
  {printf("dz=%g\n",dz);//test
 for(ze.r=dz*0.5; ze.r<=rmax; ze.r+=dz)
  {//printf(" z.r = %f\n",z.r);//test
  for(ze.i=dz*0.5; ze.i<ZWEIPI; ze.i+=dz)
   {
    //if(dz==ddzstart) printf(" z = %s\n",z.s());//test
    z = euler2complex(ze);
    y = fun(z);
    ay=abs(y);
    if(ay<ddy)
     {
      if(myabs(z.i)>1e-3) //nur complexe Loesungen beruecksichtigen
       {
	if(!schonvorhanden(z,complexelsg,nc,ddy))
	 {
	  complexelsg[nc++]=z;
	  if(--nsoll==0) return nc;
	  printf("Loesung durch raten gefunden: %s\n",z.s());//test
	 }
       }
     }
    else if(myabs(z.i)>0.1) //nur eindeutig complexe beruecksichtigen
     {
      bestenliste_aktualisieren(z,ay,bestay,bestz,MAX);
     }
   }
  }
  }
 printf("beste gefundene Werte:\n");
 for(int i=0;i<MAX;i++)
  {
   printf(" abs(y) = %f  z = %s\n",bestay[i],bestz[i].s());
   if(bestay[i]>=1e9) break;
  }
 return nc;
}

int parameter_einlesen(const char *filename)
{
 FILE *fp=fopen(filename,"r");
 if(fp==NULL) return 0;
 int ordnung=0;
 char zeile[80], *s;
 while(getline(fp,zeile,80))
  {
   if(strncmp(zeile,"ordnung:",8)==0)
    {
     sscanf(&zeile[8],"%d",&ordnung);
     if(ordnung>MAX)
      {printf("ordnung auf %d beschraenkt",MAX); fclose(fp); return 0;}
    }
   else if(strncmp(zeile,"koef",4)==0)
    {
     for(s=zeile; *s!=0 && *s!=':'; s++) {}
     if(*s!=':') {printf("Syntaxfehler \"%s\"\n",zeile); fclose(fp); return 0;}
     s++;
     for(int i=0;i<=ordnung;i++)
      {
       while(*s==' ' || *s==',') {s++;}
       sscanf(s,"%lf",&coeff[i]);
       while(*s>' ' && *s!=',') {s++;}
      }
    }
   else if(strncmp(zeile,"realbereich:",12)==0)
    sscanf(&zeile[12],"%lf%*c%lf",&realmin,&realmax);
   else if(strncmp(zeile,"imagbereich:",12)==0)
    sscanf(&zeile[12],"%lf%*c%lf",&imagmin,&imagmax);
   else if(strncmp(zeile,"ddz:",4)==0)
    sscanf(&zeile[4],"%lf",&ddz);
   else if(strncmp(zeile,"ddy:",4)==0)
    sscanf(&zeile[4],"%lf",&ddy);
   else if(strncmp(zeile,"ddzstart:",9)==0)
    sscanf(&zeile[9],"%lf",&ddzstart);
   else if(strncmp(zeile,"vermutung:",10)==0)
    {sscanf(&zeile[10],"%lf%*c%lf",&vermutung.r,&vermutung.i);
     vermutflag=true;
    }
  }
 fclose(fp);
 return ordnung;
}
   
/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[80]; //,zielname[80];
 quellname[0]=0; //zielname[0]=0;
 //FILE *fp1,*fp2;
 int i=0,j=0,c;
 if(argc>0)
  for(j=0,i=1;i<argc;i++)
   {
    if((c= *argv[i])=='?' || (c=='-' && !isdigit(argv[i][1])))
     {setargflags(argv[i]);}
    else if(isalpha(c))
     {strcpy(quellname,argv[i]);}
    else if(++j>=1 && j<=MAXARG)
     {sscanf(argv[i],"%lf",&coeff[j-1]);}
   }
 if(argflag['?'] || j>MAXARG)
  {
   if(j>MAXARG) printf("zu viele Argumente, auf %d beschraenkt\n",MAXARG);
   printf("%s  %s\n",argv[0],VERSION);
   printf("Anwendung: %s [-Flags] [c0 c1 c2 ... c%d]\n",argv[0],MAX);
   printf("  Flags: v = Testausdrucke\n");
   printf("         d = bei 3.-4.Grad ohne Formel rechnen\n");
   printf("         e = Eulerform verwenden fuer Complexe Loesungssuche\n");
   printf("Statt den Parametern c0... kann auch eine Datei angegeben\n");
   printf("werden. Siehe beispiel.txt\n");
   exit(0);
  }
 int ordnung=j-1;
 if(quellname[0]!=0)
  {
   ordnung=parameter_einlesen(quellname);
   printf("von %s eingelesen:\n",quellname);//test
   printf(" ddzstart=%g ddz=%g ddy=%g\n",ddzstart,ddz,ddy);
   printf(" vermutung = %s\n",vermutung.s());
  }
 if(ordnung<1)
  {
   printf("Polynomordnung (hoechste Potenz von x): ");
   scanf("%d",&ordnung);
   if(ordnung>MAX) printf("bisher auf %d beschraenkt, so gesetzt\n",ordnung=MAX);
   for(i=0;i<=ordnung;i++)
    {
     printf("c%d: ",i); scanf("%lf",&coeff[i]);
    }
  }
 Polynom p(ordnung,coeff);
 printf("zu loesendes Polynom:\n");
 int k=0;
 for(i=ordnung;i>=2;i--)
  {
   if(k==0) {printf(" %f*x^%d", p.c[i], i); k++;}
   else if(p.c[i]>0) printf(" + %f*x^%d", p.c[i], i);
   else if(p.c[i]<0) printf(" - %f*x^%d", -p.c[i], i);
  }
 if(p.c[1]>0)
  {
   if(k==0) printf("%f*x", p.c[1]); else printf(" + %f*x", p.c[1]);
   k++;
  }
 else if(p.c[1]<0) {printf(" - %f*x", -p.c[1]); k++;}
 if(p.c[0]>=0) printf(" + %f = 0\n", p.c[0]);
 else          printf(" - %f = 0\n", -p.c[0]);

 if(vermutflag)
  {
   Complex y;
   y = p.fun(vermutung);
   printf("Vermutung: z = %s ",vermutung.s());
   printf(" --> y = %s\n",y.s());
  }

 double loesungen[MAX];
 Complex complexelsg[MAX];
 int n=0,nc=0;
 n=p.loesen(loesungen,complexelsg,&nc);
 if(n==1) printf("1 reelle Loesung gefunden:\n");
 else    printf("%d reelle Loesungen gefunden:\n",n);
 for(i=0;i<n;i++) printf(" %f\n",loesungen[i]);
 if(nc==1) printf("1 complexe Loesung gefunden:\n");
 else    printf("%d complexe Loesungen gefunden:\n",nc);
 for(i=0;i<nc;i++) printf(" %s\n",complexelsg[i].s());
 
 return 0;
}// ende von main
