# -*- coding: utf-8 -*-
from Tkinter import *
import random
import string

# In jeder Tabelle jeweils 3 Namen fuer gleiches Ding
# Weiter unten bei Optionen die zu verwendende Tabelle auswaehlen,
# und eventuell ngleiche setzen falls nur 2 verwendet werden sollen.

zahlen=[  # Einfaches Beispiel mit Zahlen und Namen in Englisch und Deutsch
    "0","zero","null",
    "1","one","eins",
    "2","two","zwei",
    "3","three","drei",
    "4","four","vier",
    "5","five","fünf",
    "6","six","sechs",
    "7","seven","sieben",
    "8","eight","acht",
    "9","nine","neun",
]

aminosaeuren=[  # Beispiel mit 22 Aminosaeuren
       "A","Ala","Alanin",
       "B","Aib","Aminoisobuttersäure",
       "C","Cys","Cystein",
       "D","Asp","Asparaginsäure",
       "E","Glu","Glutaminsäure",
       "F","Phe","Phenylalanin",
       "G","Gly","Glycin",
       "H","His","Histidin",
       "I","Ile","Isoleucin",
       "J","Aha","Azidohomoalanin",
       "K","Lys","Lysin",
       "L","Leu","Leucin",
       "M","Met","Methionin",
       "N","Asn","Asparagin",
       "P","Pro","Prolin",
       "Q","Gln","Glutamin",
       "R","Arg","Arginin",
       "S","Ser","Serin",
       "T","Thr","Threonin",
       "V","Val","Valin",
       "W","Trp","Tryptophan",
       "Y","Tyr","Tyrosin"
]

elemente=[  # Beispiel mit ca. 94 Elementen
       "T", "Tritium","Tritium",      # [0]
       "D", "Deuterium","Deuterium",  # [1]
       "H", "Hydrogen","Wasserstoff", # [2]
       "He","Helium","Helium",
       "Li","Lithium","Lithium",
       "Be","Beryllium","Beryllium",
       "B", "Boron","Bor",
       "C", "Carbon","Kohlenstoff",
       "N", "Nitrogen","Stickstoff",
       "O", "Oxygen","Sauerstoff",
       "F", "Fluorine","Fluor",
       "Ne","Neon","Neon",
       "Na","Sodium","Natrium",
       "Mg","Magnesium","Magnesium",
       "Al","Aluminium","Aluminium",
       "Si","Silicon","Silicium",
       "P", "Phosphorus", "Phosphor",
       "S", "Sulfur","Schwefel",
       "Cl","Chlorine","Chlor",
       "Ar","Argon","Argon",
       "K", "Potassium","Kalium",     # [20]
       "Ca","Calcium","Calcium",
       "Sc","Scandium","Scandium",
       "Ti","Titanium","Titan",
       "V", "Vanadium","Vanadium",
       "Cr","Chromium","Chrom",
       "Mn","Manganese","Mangan",
       "Fe","Iron","Eisen",
       "Co","Cobalt","Cobalt",
       "Ni","Nickel","Nickel",
       "Cu","Copper","Kupfer",        # [30]
       "Zn","Zinc","Zink",
       "Ga","Gallium","Gallium",
       "Ge","Germanium","Germanium",
       "As","Arsenic","Arsen",
       "Se","Selenium","Selen",
       "Br","Bromine", "Brom",
       "Kr","Krypton","Krypton",
       "Rb","Rubidium","Rubidium",
       "Sr","Strontium","Strontium",
       "Y", "Yttrium","Yttrium",      # [40]
       "Zr","Zirconium","Zirconium",
       "Nb","Niobium","Niobium",
       "Mo","Molybdenum","Molybdän",
       "Tc","Technetium","Technetium",
       "Ru","Ruthenium","Ruthenium",
       "Rh","Rhodium","Rhodium",
       "Pd","Palladium","Palladium",
       "Ag","Silver","Silber",
       "Cd","Cadmium","Cadmium",
       "In","Indium","Indium",        # [50]
       "Sn","Tin","Zinn",
       "Sb","Antimony","Antimon",
       "Te","Tellurium","Tellur",
       "I", "Iodine","Iod",
       "Xe","Xenon","Xenon",
       "Cs","Caesium","Cäsium",
       "Ba","Barium","Barium",
       "La","Lanthanum","Lantha",
       "Ce","Cerium","Cer",
       "Pr","Praseodymium","Praseodym", # [60]
       "Nd","Neodymium","Neodym",
# einige Lanthaniden fehlen noch
       "Hf","Hafnium","Hafnium",
       "Ta","Tantalum","Tantal",
       "W", "Tungsten","Wolfram",
       "Re","Rhenium","Rhenium",
       "Os","Osmium","Osmium",
       "Ir","Iridium","Iridium",
       "Pt","Platinum","Platin",
       "Au","Gold","Gold",
       "Hg","Mercury","Quecksilber",
       "Tl","Thallium","Thallium",
       "Pb","Lead","Blei",
       "Bi","Bismuth","Bismut",
       "Po","Polonium","Polonium",
       "At","Astatine","Astat",
       "Rn","Radon","Radon",
       "Fr","Francium","Francium",
       "Ra","Radium","Radium",
       "Ac","Actinium","Actinium",
       "Th","Thorium","Thorium",
       "Pa","Protactinium","Protactinium",
       "U", "Uranium","Uran",
       "Np","Neptunium","Neptunium",
       "Pu","Plutonium","Plutonium",
]

#-------------------------- Optionen ---------------------------
# Die zu verwendende Tabelle auswaehlen:
#dinge=zahlen
dinge=aminosaeuren
#dinge=elemente

# Globale Parameter:
imax=12 # Breite des Spielfelds (z.B. 11, 12)
jmax=6  # Hoehe des Spielfelds, muss durch 3 teilbar sein (z.B. 6, 9)
I80=105 # Breite eines Feldes in Pixel
J80=80  # Hoehe eines Feldes in Pixel

ndingstart=0    # auf mehr als 0 setzen um erste Dinge wegzulassen
ndingende=1000  # kleiner machen um letzte Dinge wegzulassen
ngleiche=3      # jeweils 3 gleiche Objekte verwenden (2 oder 3 erlaubt)

# Beispiel fuer Elemente nur bis Krypton:
#ndingstart=0
#ndingende=20

# Beispiel fuer nur Lanthaniden:
#ndingstart=58
#ndingende=62

#---------------------- Ende der Optionen ----------------------

master = Tk(className="Memory mit Aminosäuren")
w = Canvas(master, width=imax*I80, height=jmax*J80)
w.pack()

global n,n0,punkte,nmax,nklicks
n=0
n0=0
punkte=0
nklicks=0
nmax=imax*jmax/ngleiche # Breite*Hoehe/3

if ndingende>len(dinge)/3: ndingende=len(dinge)/3
nding=ndingende-ndingstart  # Anzahl vorhandene Dinge
print("Anzahl Dinge: "+str(nding))
array1=range(0,nding)
array2=range(0,nding)
array3=range(0,nding)
feld=range(0,imax*jmax)
aufgedeckt=range(0,imax*jmax)

def init_arrays():
    for i in range(0,nding):
        j=i+ndingstart
        array1[i]=dinge[3*j]
        array2[i]=dinge[3*j+1]
        array3[i]=dinge[3*j+2]

def newgame():
    init_arrays()
    for j in range(0,jmax):  # Zeilen
        for i in range(0,imax): # Spalten
            aufgedeckt[j*imax+i]=0
            feld[j*imax+i] = -1
    checkarray=range(0,nding)
    for i in range(0,nding):
        checkarray[i]=0
    for k in range(0,nmax):
        zufall=random.randint(0,nding-1)
        #if k==0: zufall=43 #test
        if k<nding:
            while checkarray[zufall]!=0:
                zufall=random.randint(0,nding-1)
        checkarray[zufall]=1
        i=random.randint(0,imax-1)
        j=random.randint(0,jmax-1)
        while feld[j*imax+i] != -1:
            i=random.randint(0,imax-1)
            j=random.randint(0,jmax-1)
        feld[j*imax+i]=zufall
        i=random.randint(0,imax-1)
        j=random.randint(0,jmax-1)
        while feld[j*imax+i] != -1:
            i=random.randint(0,imax-1)
            j=random.randint(0,jmax-1)
        feld[j*imax+i]=zufall
        if ngleiche==3:
            i=random.randint(0,imax-1)
            j=random.randint(0,jmax-1)
            while feld[j*imax+i] != -1:
                i=random.randint(0,imax-1)
                j=random.randint(0,jmax-1)
            feld[j*imax+i]=zufall

def alle_verdecken():
    k=0
    for j in range(0,jmax):  # 6 Zeilen
        for i in range(0,imax): # 11 Spalten
            if aufgedeckt[k]==0:
                w.create_rectangle(i*I80, j*J80, I80+i*I80, J80+j*J80, fill="gray")
            k+=1

def loesung_zeigen():
    for j in range(0,jmax):  # 6 Zeilen
        #str=""
        for i in range(0,imax): # 11 Spalten
            k=j*imax+i
            w.create_rectangle(i*I80, j*J80, I80+i*I80, J80+j*J80, fill="white") #test
            text_id=w.create_text(i*I80+I80/2,j*J80+J80/2,anchor="center")
            txt3=array3[feld[k]]
            if len(txt3)>15:
                txt4=txt3[14-len(txt3):]
                txt3=txt3[:14]
                txt3=txt3+"-\n"+txt4
            w.itemconfig(text_id, text=array1[feld[k]]+"\n"+array2[feld[k]]+"\n"+txt3)
            #str += string.center(array2[feld[k]], 12)
        #print(str)

def givup():
    loesung_zeigen()
    newgame()

def aufdecken(i,j,k,n):
    #w.create_rectangle(i*I80, j*J80, I80+i*I80, J80+j*J80, fill="white") #test
    aufgedeckt[k]=1
    text_id=w.create_text(i*I80+I80/2,j*J80+J80/2,anchor="center")
    if n==1:   w.itemconfig(text_id, text=array1[feld[k]])
    elif n==2: w.itemconfig(text_id, text=array2[feld[k]])
    else:      w.itemconfig(text_id, text=array3[feld[k]])

def zudecken(k):
    aufgedeckt[k]=0
    i=k%imax
    j=k/imax
    w.create_rectangle(i*I80, j*J80, I80+i*I80, J80+j*J80, fill="gray")

def EventHandler(event):
    global n,n0,punkte,nklicks,k0,k1,k2
    #print("Koordinaten: ",event.x,event.y)
    i=int(event.x/I80)
    j=int(event.y/J80)
    k=j*imax+i
    if (n<4) & (aufgedeckt[k]==0):
        nklicks+=1
        w.create_rectangle(i*I80, j*J80, I80+i*I80, J80+j*J80, fill="white")
        n+=1
        aufdecken(i,j,k,n) # Feld aufdecken
        if n==1:
            k0=k
            n0=feld[k0]
            #print(array1[n0])
        elif n==2:
            k1=k
            n1=feld[k1]
            if n1==n0:
                print(array1[n0]+"="+array2[n1])
                if ngleiche==2:
                    n=0
                    punkte+=1
                    if punkte==nmax:
                        print "Alle geloest, Gratulation!!"
                        print "Anzahl Versuche: "+str(nklicks)
            else:
                #print(array2[n1])
                #print("falsch")
                k2 = -1
                n=4
                verzoegert_zudecken()
        else:
            n=0
            k2=k
            n2=feld[k2]
            if n2==n0:
                print("korrekt: "+array1[n0]+"="+array2[n0]+"="+array3[n0])
                punkte+=1
                if punkte==nmax:
                    print "Alle geloest, Gratulation!!"
                    print "Anzahl Versuche: "+str(nklicks)
            else:
                #print(array3[n2])
                #print("falsch")
                n=4
                verzoegert_zudecken()

w.bind("<Button-1>", EventHandler)

class App:
    def __init__(self, master):
        frame=Frame(master)
        frame.pack()
        self.button=Button(frame, text="Quit", fg="red",
                           command=frame.quit)
        self.button.pack(side=LEFT)
        self.knopf1 = Button(frame, text="givup", command=givup)
        self.knopf1.pack(side=LEFT)
        self.knopf2 = Button(frame, text="help", command=help)
        self.knopf2.pack(side=LEFT)

def change(a=0):
    if a==0:
        loesung_zeigen()
        w.after(5000,change,1)
    else:
        alle_verdecken()

def help():
    loesung_zeigen()
    change()

def verzoegert_zudecken(a=0):
    global k0,k1,k2,n
    if a==0:
        w.after(500,verzoegert_zudecken,1)
    else:
        if k0>=0:
            zudecken(k0)
            k0 = -1
        if k1>=0:
            zudecken(k1)
            k1 = -1
        if k2>=0:
            zudecken(k2)
            k2 = -1
        n=0

app=App(master)
newgame()
change()
master.mainloop()
