/* drehung.cc

Drehung mit Quaternion
*/

#include <stdio.h>
#include <math.h>
#include <xtekplot1.h>
#include "quaternionklasse.cc"

//#define PI (4*atan(1))
//#define GRAD (PI/360)

/****************************** Klassen *******************************/
/** schon in quaternionklasse.cc
class Drehmatrix
{
public:
 double a,b,c, d,e,f, g,h,i;
 Drehmatrix() {a=b=c=d=e=f=g=h=i=0;}
 Drehmatrix(double a0,double b0,double c0,
	    double d0,double e0,double f0,
	    double g0,double h0,double i0)
  {a=a0;b=b0;c=c0;d=d0;e=e0;f=f0;g=g0;h=h0;i=i0;}
};

class Quaternion
{
public:
 double a,b,c,d; //Quaternion = a+b*i+c*j+d*k  mit i^2 = j^2 = k^2 = -1
 Quaternion() {a=b=c=d=0;}
 Quaternion(double a0,double b0,double c0,double d0) {a=a0; b=b0; c=c0; d=d0;}
 void normieren(); //Normierung auf 1
 void normieren2(); //Normierung unter Beibehaltung von a
 Drehmatrix rotationsmatrix();
};

void Quaternion::normieren()
{
 double z=sqrt(a*a+b*b+c*c+d*d);
 a/=z;
 b/=z;
 c/=z;
 d/=z;
}

void Quaternion::normieren2()
{
 double z=sqrt((b*b+c*c+d*d)/(1-a*a));
 b/=z;
 c/=z;
 d/=z;
}

Drehmatrix Quaternion::rotationsmatrix()
{
 Drehmatrix r;
 r.a = a*a+b*b-c*c-d*d;
 r.b = 2*(b*c-a*d);
 r.c = 2*(b*d+a*c);
 r.d = 2*(b*c+a*d);
 r.e = a*a-b*b+c*c-d*d;
 r.f = 2*(c*d-a*b);
 r.g = 2*(b*d-a*c);
 r.h = 2*(c*d+a*b);
 r.i = a*a-b*b-c*c+d*d;
 return r;
}
**/

Vektor3d drehen(Drehmatrix q,Vektor3d v)
{
 Vektor3d r;
 r.x = v.x*q.a+v.y*q.b+v.z*q.c;
 r.y = v.x*q.d+v.y*q.e+v.z*q.f;
 r.z = v.x*q.g+v.y*q.h+v.z*q.i;
 return r;
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}
void menu_res();
void menu_winkel();
void menu_achse();

/*********************** grafische Darstellung  ***********************/
void figur_init();
void figur_zeichnen();
#define XMAX 1024
#define YMAX  820
#define TIEFE 24
static int breite,hoehe,tiefe,visklasse;
static double xmin= -2.5,ymin= -2.0, xmax=2.5,ymax=2.0;
static double winkel=0;
static Vektor3d achse;
static Drehmatrix rotat;

void menu_res()
{
 winkel=0;
 figur_init();
 figur_zeichnen();
}

void rotat_berechnen()
{
 double whalbe=winkel/2;
 double a=cos(whalbe);
 double sinwh=sin(whalbe);
 Quaternion q1(a,achse.x*sinwh,achse.y*sinwh,achse.z*sinwh);
 q1.normieren2();
 rotat=q1.rotationsmatrix();
}

void menu_winkel()
{
 double w=winkel/GRAD;
 int ok=requester_input(1,"Drehwinkel in Grad","%f","%lf",&w);
 if(ok)
  {
   winkel=w*GRAD;
   rotat_berechnen();
  }
}

void menu_achse()
{
 Vektor3d a=achse;
 int ok=requester_input(3,"Drehachse x","%f","%lf",&a.x,
			" y ","%f","%lf",&a.y,
			" z ","%f","%lf",&a.z);
 if(ok)
  {
   achse=a;
   rotat_berechnen();
  }
}

void grafikfenster_oeffnen()
{
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 //maxcol=(1<<TIEFE);
 setsize(breite,hoehe,tiefe);
 setmenu(2,"File", "Settings");
 setmenu(2,"Reset","Winkel ..",menu_res,menu_winkel);
 setmenu(2,"Exit", "Achse ..", menu_exit,menu_achse);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 term_refresh();
}

void projektion(double x1,double y1,double z1,double *x,double *y)
{
 *x = x1+0.35*z1;
 *y = y1+0.35*z1;
}

void linie(double x1,double y1,double z1,double x2,double y2,double z2)
{
 double x,y;
 projektion(x1,y1,z1,&x,&y);
 plot(x,y,PENUP);
 projektion(x2,y2,z2,&x,&y);
 plot(x,y,PENDOWN);
}

void linie(Vektor3d& p1,Vektor3d& p2)
{
 linie(p1.x,p1.y,p1.z,p2.x,p2.y,p2.z);
}

/************************* Hauptprogramm ******************************/
static Vektor3d ecken[8]; //Positionen der Ecken eines Koerpers (8 fuer Wuerfel)

void figur_init()
{
 ecken[0]=0;
 ecken[1]=1;
 ecken[2].x=0; ecken[2].y=1; ecken[2].z=0;
 ecken[3].x=0; ecken[3].y=0; ecken[3].z=1;
 ecken[4].x=1; ecken[4].y=1; ecken[4].z=0;
 ecken[5].x=1; ecken[5].y=0; ecken[5].z=1;
 ecken[6].x=0; ecken[6].y=1; ecken[6].z=1;
 ecken[7].x=1; ecken[7].y=1; ecken[7].z=1;
}

void figur_zeichnen()
{
 inital_new();
 //screenclear(0xFFFFFF);
 screenclear();
 linie(ecken[0],ecken[1]);
 linie(ecken[0],ecken[2]);
 linie(ecken[0],ecken[3]);
 linie(ecken[4],ecken[1]);
 linie(ecken[4],ecken[2]);
 linie(ecken[4],ecken[7]);
 linie(ecken[2],ecken[6]);
 linie(ecken[1],ecken[5]);
 linie(ecken[3],ecken[5]);
 linie(ecken[3],ecken[6]);
 linie(ecken[5],ecken[7]);
 linie(ecken[6],ecken[7]);
 term_refresh();
}

void figur_darstellen()
{
 for(int i=0;i<8;i++) //provi. Eckpunkte auflisten
  printf("%f %f %f\n",ecken[i].x,ecken[i].y,ecken[i].z);
 figur_zeichnen();
}

int main(int argc,char *argv[])
{
 int i;
 figur_init();
 printf("Startposition der Figur:\n");
 grafikfenster_oeffnen();
 figur_darstellen();

 float w=0,b=0,c=0,d=1;
 char janein[40];
 bool qflag=true;
 if(argc==1)
  {
   w=1;
  }
 else if(argc==2)
  {
   sscanf(argv[1],"%f",&w);
  }
 else if(argc==6)
  {
   sscanf(argv[1],"%f",&w);
   sscanf(argv[2],"%f",&b);
   sscanf(argv[3],"%f",&c);
   sscanf(argv[4],"%f",&d);
   sscanf(argv[5],"%s",janein);
   qflag=(janein[0]!='n' && janein[0]!='N');
  }
 else
  {
   printf("Drehwinkel in Grad: "); scanf("%f",&w);
   if(w!=0)
    {
     printf("Drehachse:\n");
     printf(" x: "); scanf("%f",&b);
     printf(" y: "); scanf("%f",&c);
     printf(" z: "); scanf("%f",&d);
     printf("Quaternion verwenden? "); scanf("%s",janein);
     qflag=(janein[0]!='n' && janein[0]!='N');
    }
  }
 winkel=w*GRAD;
 achse=Vektor3d(b,c,d);
 
 if(qflag)
  {
   //Drehung mit Quaternion:
   double whalbe=winkel/2;
   double a=cos(whalbe);
   double sinwh=sin(whalbe);
   Quaternion q1(a,b*sinwh,c*sinwh,d*sinwh);
   q1.normieren2();
   rotat=q1.rotationsmatrix();
   printf("Drehung um Achse %f %f %f\n",q1.b/sinwh,q1.c/sinwh,q1.d/sinwh);
   double w1=2*acos(q1.a); printf("Winkel = %f Grad\n",w1/GRAD);//test
  }
 else
  {
   //Drehung ohne Quaternion:
   double sinw=sin(winkel),cosw=cos(winkel);
   Drehmatrix rx(1,0,0, 0,cosw,-sinw, 0,sinw,cosw); //fuer Drehung um x-Achse
   Drehmatrix ry(cosw,0,sinw, 0,1,0, -sinw,0,cosw); //fuer Drehung um y-Achse
   Drehmatrix rz(cosw,-sinw,0, sinw,cosw,0, 0,0,1); //fuer Drehung um z-Achse
   if(b>c && b>d) {rotat=rx; printf("Drehung um x-Achse\n");}
   else if(c>b && c>d) {rotat=ry; printf("Drehung um y-Achse\n");}
   else {rotat=rz; printf("Drehung um z-Achse\n");}
  }

 for(i=0;i<8;i++)
  {ecken[i] = drehen(rotat,ecken[i]);}
 
 printf("gedrehte Figur:\n");
 figur_darstellen();
 
 while(exitflag==0)
  {waitBOF();		//auf Ende des Bildaufbaus warten
   //oder waitTOF();	//auf Beginn des Bildaufbaus warten
   //oder waitmenu(0);	//nicht warten
   if(winkel!=0)
    {
     for(i=0;i<8;i++)
      {ecken[i] = drehen(rotat,ecken[i]);}
     figur_zeichnen();
    }
  }
 term_exit();
 return 0;
}
