/* quaternionklasse.h */

#ifndef QUATERNIONKLASSE_H
#define QUATERNIONKLASSE_H
#include <stdio.h>
#include <math.h>
#include "vektor3dklasse.h"

//#define PI (4*atan(1))
//#define GRAD (PI/360)

class Drehmatrix
{
public:
 double a,b,c, d,e,f, g,h,i;
 Drehmatrix() {a=b=c=d=e=f=g=h=i=0;}
 Drehmatrix(double a0,double b0,double c0,
	    double d0,double e0,double f0,
	    double g0,double h0,double i0)
  {a=a0;b=b0;c=c0;d=d0;e=e0;f=f0;g=g0;h=h0;i=i0;}
};

class Quaternion
{
public:
 double a,b,c,d; //Quaternion = a+b*i+c*j+d*k  mit i^2 = j^2 = k^2 = -1
 Quaternion() {a=b=c=d=0;}
 Quaternion(double a0) {a=a0; b=c=d=0;}
 Quaternion(double a0,double b0) {a=a0; b=b0; c=d=0;}
 Quaternion(double a0,double b0,double c0,double d0) {a=a0; b=b0; c=c0; d=d0;}
 void normieren(); //Normierung auf 1
 void normieren2(); //Normierung unter Beibehaltung von a
 Drehmatrix rotationsmatrix();
 void drehung_definieren(Vektor3d achse,double winkel);
 Vektor3d vektordrehen(Vektor3d v);
 Vektor3d vektordrehen(Vektor3d v,Vektor3d achse,double winkel);
 Quaternion operator+=(Quaternion v);
 Quaternion operator+=(double x) {a+=x; return *this;}
 Quaternion operator*=(double x) {a*=x; b*=x; c*=x; d*=x; return *this;}
 friend Quaternion operator+(Quaternion v1,Quaternion v2);
 friend Quaternion operator*(Quaternion v1,Quaternion v2);
};
#endif
