// vektorklasse.h

#ifndef VEKTORKLASSE_H
#define VEKTORKLASSE_H
#include <math.h>
#ifndef PI
#define PI 3.14159265358979323846
#endif
#define ZWEIPI (2.*PI)
#define PIHALBE (0.5*PI)
#ifndef GRAD
#define GRAD (PI/180.)
#endif

class vektor
{
public:
 double x,y;
 vektor(double a=0,double b=0) {x=a; y=b;}
 vektor(int n,double w,double a=1.) {x=a*cos(w); y=a*sin(w); if(n<0) y= -y;}
 vektor operator=(vektor v) {x=v.x; y=v.y; return *this;}
 vektor operator+=(vektor v) {x+=v.x; y+=v.y; return *this;}
 vektor operator-=(vektor v) {x-=v.x; y-=v.y; return *this;}
 vektor operator*=(double z) {x*=z; y*=z; return *this;}
 vektor operator/=(double z) {x/=z; y/=z; return *this;}
 friend vektor operator+(vektor,vektor);
 friend vektor operator-(vektor,vektor);
 friend vektor operator*(vektor,double);
 friend vektor operator*(double,vektor);
 friend vektor operator/(vektor,double);
 friend vektor operator-(vektor);
};
#endif
