/* menu.cc */

#include "menu.h"

static char REQ_FONTSTRING[32]="12x16";
static char MENU_FONTSTRING[32]="12x16";
static char scratch[4000];

/****** Kleinkram ******/
void strncpy_nocrlf(char *to,const char *from,int max)
{
 char c;
 while(--max>0 && (c= *from++)!=0)
  if(c!='\r' && c!='\n') *to++ = c;
 *to=0;
}

int enthaelt(const char *s,const char *t)
{ // Testet ob String t in String s enthalten ist. 1=ja 0=nein
 int c;
 const char *s2,*t2;
 while(c= *s++)
  {if(c== *t)
    {for(s2=s,t2= &t[1];(c= *t2++) && c== *s2++;) {}
     if(c==0) return 1;
    }
  }
 return 0;
}

bool myisprint(int c)
{
 if(c>=' ' && c<127) return true; //ASCII-Zeichen
 c &= 0xFF;
 //test auf Umlaute (Ae ae Oe oe Ue ue):
 if(c==0xC4 || c==0xE4 || c==0xD6 || c==0xF6 || c==0xDC || c==0xFC) return true;
 return false;
}

/****** Requester ******/
Requester requester1; //mehr als einer macht vermutlich keinen Sinn

#define BREQ_X (requester1.bigfont*REQ_X)
#define BREQ_Y (requester1.bigfont*REQ_Y)

void Requester::select(int a)
{
 if(a==REQ_PRESELECT)
  {
   switch(preselect)
    {case 1: antwort=REQ_YES; break;
     case 2: antwort=REQ_NO; break;
     case 3: antwort=REQ_CANCEL; break;
     default: return;//keine Reaktion wenn preselect nicht gesetzt
    }
  }
 else antwort=a;
 if(antwort==REQ_YES)
  {
   if(typ==REQ_INPUT)
    for(int i=0;i<ng;i++)
     {
      gadget[i].save(); //Werte vom Eingabestring in UserData kopieren
     }
  }
 reset();
}

void Gadget::save()
{
 if(enthaelt(cstr,"s"))
   strcpy((char*)pdata,eingabetext);
 else
   sscanf(eingabetext,cstr,pdata);
}

void Knopf::zeichnen(const char *text,bool preselect)
{
 int x=x1+BREQ_X, y=y1+BREQ_Y/2;
 glColor3ub(0,0,0); // Schwarzer Rahmen um Knoepfe und auch schwarzer Text
 schrift(x,y,text);
 glBegin(GL_LINE_LOOP);
 glVertex2i(x1, y2);
 glVertex2i(x1, y1);
 glVertex2i(x2, y1);
 glVertex2i(x2, y2);
 glEnd();
 if(preselect)
  {
   int d=4; //4 Pixel Abstand fuer doppelter Rahmen
   glBegin(GL_LINE_LOOP);
   glVertex2i(x1+d, y2-d);
   glVertex2i(x1+d, y1+d);
   glVertex2i(x2-d, y1+d);
   glVertex2i(x2-d, y2-d);
   glEnd();
  }
 glColor3f(0.9*HF,0.9*HF,0.9*HF); // Hellgrauer Hintergrund
 glBegin(GL_QUADS);
 glVertex2i(x1, y2);
 glVertex2i(x1, y1);
 glVertex2i(x2, y1);
 glVertex2i(x2, y2);
 glEnd();
}

void Requester::set(int t,int br,int ho,const char *txt,
		      const char *ja,const char *nein,const char *canc,int pre)
{
 typ=t;
 strcpy(text,txt);
 preselect=1; //automatisch falls pre nicht gesetzt
 if(ja==NULL) strcpy(jatext,"ok"); else strcpy(jatext,ja);
 if(nein==NULL) strcpy(neintext,""); else {strcpy(neintext,nein); preselect=2;}
 if(canc==NULL) strcpy(canceltext,""); else {strcpy(canceltext,canc); preselect=3;}
 if(pre>=0) preselect=pre;
 x1=50; y2=bildhoehe-50; //linke obere Ecke des Requesters //provisorische Werte
 if(y2<ho) y2=bildhoehe;
 if(x1+br>bildbreite) x1=0;
 x2=x1+br; y1=y2-ho; //rechte untere Ecke des Requesters
 if(x2>bildbreite) x2=bildbreite;
 if(y1<0) y1=0;
 antwort=REQ_EMPTY; //noch keine Antwort
 aktiv=true;
}

void schrift_umbruch(int x0,int y0,char *text,int br,int ho)
{
 char *s,*p;
 int x=x0,y=y0;
 for(s=text;;)
  {
   if((p=index(s,'\n'))==NULL && (p-s)<=br) {schrift(x,y,s); break;}
   if(p==NULL)
    {
     p=index(s,0);
     if((p-s)<=br) {schrift(x,y,s); break;}
    }
   else if((p-s)<=br)
    {
     char c= *p; *p = 0; schrift(x,y,s); *p++ = c;
     s=p;
    }
   else
    {
     char c=s[br]; s[br]=0; schrift(x,y,s); s[br]=c;
     s= &s[br];
    }
   x=x0;
   y -= ho;
  }
}

void Requester::zeichnen()
{
 if(*REQ_FONTSTRING==0) sprintf(REQ_FONTSTRING,"%dx%d",REQ_X,REQ_Y);
 textsize(BREQ_X,BREQ_Y,REQ_FONTSTRING);
 glColor3ub(0,0,0); // Schwarze Schrift
 int br = (x2-x1-2*REQ_RAND)/BREQ_X; //Anzahl Zeichen, die pro Zeile platz haben
 int ho=BREQ_Y*4/3; //hoehe der Buchstaben inklusiv Zeilenabstand
 schrift_umbruch(x1+REQ_RAND, y2-BREQ_Y-REQ_RAND, text, br,ho);
 if(*jatext!=0) knopf1.zeichnen(jatext,preselect==1);
 if(*neintext!=0) knopf2.zeichnen(neintext,preselect==2);
 if(*canceltext!=0) knopf3.zeichnen(canceltext,preselect==3);
 if(typ==REQ_INPUT)
  {
   for(int i=0;i<ng;i++) gadget[i].zeichnen();
  }
 glColor3f(0.8*HF, 0.8*HF, 0.8*HF); // Hellgrauer Hintergrund
 glBegin(GL_QUADS);
 glVertex2f(x1, y2);
 glVertex2f(x1, y1);
 glVertex2f(x2, y1);
 glVertex2f(x2, y2);
 glEnd();
}

int strlen_zeile(const char *s,int *nz) //ermittelt Laenge der laengsten Zeile
{				        //und Anzahl Zeilen
 int c,i,n;
 for(i=n=0,*nz=1;(c= *s++);i++)
   if(c=='\n')
     {(*nz)++; if(n<i) n=i;
      i= -1;
     }
 if(n<i) n=i;
 return n;
}

int janeinrequester(const char *text,const char *jatext,const char *neintext)
{
 return janeinrequester3(text,jatext,neintext,NULL);
}

int janeinrequester3(const char *text,const char *jatext,const char *neintext,const char *canceltext)
{
 int breite,hoehe; //Groesse des ganzen Requesters
 int br,ho; //Groesse der Antwortboxen
 int nzeilen, n1=strlen_zeile(text,&nzeilen); //n1=Laenge der laengsten Zeile
 int n2=strlen(jatext), n3=(neintext==NULL)?0:strlen(neintext);
 if(canceltext!=NULL)
  {
   int n4=strlen(canceltext);
   if(n4>n2 && n4>n3) n2=n4;
  }
 br = (((n2>n3) ? n2 : n3) + 2) * BREQ_X;
 ho = 2*BREQ_Y;
 breite=n1*BREQ_X;
 if(breite < 3*br+REQ_RAND) breite=3*br+REQ_RAND;
 if(canceltext!=NULL && breite<4*br+2*REQ_RAND) breite=4*br+2*REQ_RAND;
 breite += 2*REQ_RAND;
 if(nzeilen<2) nzeilen=2;
 hoehe = 3*ho + nzeilen*BREQ_Y*4/3 + 2*REQ_RAND;
 requester1.set(REQ_JANEIN,breite,hoehe,text,jatext,neintext,canceltext);
 int x1,y1;
 if(neintext==NULL) {x1=breite/2;}
 else if(canceltext==NULL) {x1=breite/3;}
 else {x1=breite/4;}
 x1 -= br/2;
 x1 += requester1.x1;
 y1 = requester1.y1+ho;
 requester1.knopf1.set(x1,y1,br,ho);
 if(neintext!=NULL)
  {
   if(canceltext!=NULL) x1 += breite/4;
   else x1 += breite/3;
   requester1.knopf2.set(x1,y1,br,ho);
  }
 if(canceltext!=NULL)
  {
   x1 += breite/4;
   requester1.knopf3.set(x1,y1,br,ho);
  }
 //glutPostRedisplay(); //geht nicht wenn in falschem Thread?
 while(requester1.antwort==REQ_EMPTY) usleep(10000);//warten bis gueltige Antwort
 return requester1.antwort;
}

void Requester::spezial(int c, int x, int y)
{
 if(typ==REQ_INPUT)
  {int i;
   for(i=0;i<ng;i++)
    if(gadget[i].aktiv)
     {gadget[i].spezial(c,x,y); return;}
  }
}

void Requester::key(unsigned char c, int x, int y)
{
 if(c==27)        {select(REQ_CANCEL); return;}
 if(typ==REQ_JANEIN)
  {
   if(c=='\r') {select(REQ_PRESELECT);}
  }
 else //if(typ==REQ_INPUT)
  {
   if(c=='\t' || c=='\r')
    {int i;
     for(i=0;i<ng;i++) if(gadget[i].aktiv) break;
     if(i==ng) gadget[0].aktiv=1;
     else {gadget[i].aktiv=0; gadget[(i+1)%ng].aktiv=1;}
    }
   else
    {int i;
     for(i=0;i<ng;i++)
      if(gadget[i].aktiv)
       {
	gadget[i].key(c,x,y);
	return;
       }
    }
  }
}

void Requester::mausknopf(int button,int state,int x,int y)
{
 if(button==0 && state==0)
  {
   y=bildhoehe-y; //y-Achse konvertieren zu unten nach oben
   klick(x,y);
  }
}

void Requester::klick(int x,int y)
{
 if(knopf1.klick(x,y)) select(REQ_YES);
 else if(knopf2.klick(x,y)) select(REQ_NO);
 else if(knopf3.klick(x,y)) select(REQ_CANCEL);
 else if(typ==REQ_INPUT)
  {
   int i;
   for(i=0;i<ng;i++)
    {if(gadget[i].klick(x,y)) break;}
   if(i!=ng)
    {
     for(int j=0;j<ng;j++)
       gadget[j].aktiv = (j==i)?1:0;
     //glutPostRedisplay(); //sollte schon im Hauptprogramm gemacht werden
    }
  }
}

void Gadget::set(int xa,int ya,int b,int h)
{
 x1=xa; y1=ya; x2=x1+b; y2=y1+h;
 int abst=BREQ_Y/4; //Abstand von Fragetext zu oberem Rand von Eingabefeld
 x3=x1; y3=y1+h+abst; x4=x2; y4=y2+h+abst;
 cursor=strlen(eingabetext);
 aktiv=0;
}

#define PFEIL_LINKS 100
#define PFEIL_RECHTS 102
#define KEY_DEL 111

void Gadget::spezial(int c,int x,int y)
{
 if(c==PFEIL_LINKS) {if(cursor>0) cursor--;}
 else if(c==PFEIL_RECHTS) {if(cursor < (int)strlen(eingabetext)) cursor++;}
 else if(c==KEY_DEL) key(127,x,y);
}

void Gadget::key(char c,int x,int y) //bei Tastendruck wenn aktiv
{
 if(c=='\b' || c==127)
  {if(cursor>0)
    {--cursor;
     for(int i=cursor; eingabetext[i]!=0; i++)
       eingabetext[i]=eingabetext[i+1];
    }
  }
 else if(myisprint(c))
  {
   int i=strlen(eingabetext)+1; 
   if(i<80)
    {
     for(;i>cursor; i--)
       eingabetext[i]=eingabetext[i-1];
     eingabetext[cursor++]=c;
    }
   else {}//bei Ueberlauf keine weiteren Zeichen speichern
  }
}

void cursor_zeichnen(int x,int y,int bx,int hy)
{
 int x1=x, x2=x+bx, y1=y, y2=y1+hy*9/8;
 glBegin(GL_POLYGON);
 glVertex2i(x1, y2);
 glVertex2i(x1, y1);
 glVertex2i(x2, y1);
 glVertex2i(x2, y2);
 glEnd();
}

void Gadget::zeichnen()
{
 glColor3f(0.5*HF, 0.5*HF, 0.5*HF); // Dunkelgrauer Rahmen um gesamtes Gadget
 glBegin(GL_LINE_LOOP);
 glVertex2i(x1, y4);
 glVertex2i(x1, y1);
 glVertex2i(x4, y1);
 glVertex2i(x4, y4);
 glEnd();
 glColor3ub(0,0,0); // Schwarze Schrift
 int x=x1+BREQ_X/2, y=y2+BREQ_Y/2;  schrift(x,y,fragetext);
 y=y1+BREQ_Y/2;  schrift(x,y,eingabetext);
 if(aktiv)
  {
   glColor3f(0.45*HF, 0.7*HF, HF); // hellblauer Cursor
   cursor_zeichnen(x+cursor*BREQ_X,y,BREQ_X,BREQ_Y);
  }
 glColor3f(0.95*HF,0.95*HF,0.95*HF); // fast weisser Hintergrund fuer Eingabefeld
 int xt1=x-BREQ_X/3, yt1=y-BREQ_Y/4, xt2=x2-BREQ_X/3, yt2=y+BREQ_Y*6/4;
 glBegin(GL_QUADS);
 glVertex2i(xt1, yt2);
 glVertex2i(xt1, yt1);
 glVertex2i(xt2, yt1);
 glVertex2i(xt2, yt2);
 glEnd();
 glColor3f(0.85*HF,0.85*HF,0.85*HF); // Hellgrauer Hintergrund
 glBegin(GL_QUADS);
 glVertex2i(x1, y4);
 glVertex2i(x1, y1);
 glVertex2i(x4, y1);
 glVertex2i(x4, y4);
 glEnd();
}

int requester_input(int n,...)
{
 va_list ap;
 va_start(ap,n);
 int i,br=0,breite=0,hoehe=0;
 const char *cstr1,*cstr2;
 const int gadhorabst=2*BREQ_X, gadvertabst=BREQ_Y; //Abstand zwischen Gadgets
 const int gadhoehe=BREQ_Y*4; //Hoehe eines Gadgets
 //printf("requester_input(n=%d,...)\n",n);//test
 if(n>MAXGADS)
  {printf("Fehler: zu viele Eingaben in requester_input(%d...) auf %d begrenzt\n",
	  n,MAXGADS); n=MAXGADS;}
 for(i=0;i<n;i++)
  {
   requester1.gadget[i].fragetext=va_arg(ap,char *); //Fragetext
   cstr1=va_arg(ap,char *); //Control-String um Default-Wert als String auszugeben
   //printf("cstr1=\"%s\"\n",cstr1);//test
   cstr2=va_arg(ap,char *);
   bool umbruchflag=(enthaelt(cstr2,"\n"));
   strncpy_nocrlf(requester1.gadget[i].cstr,cstr2,16); //Control-String um Antwort einzulesen
   requester1.gadget[i].umbruchflag=umbruchflag;
   APTR a;
   requester1.gadget[i].pdata=a=va_arg(ap,APTR); //Zeiger auf einzulesende Daten
   if(enthaelt(cstr1,"s"))
    sprintf(requester1.gadget[i].eingabetext,cstr1,a);
   else if(enthaelt(cstr1,"ld"))
    sprintf(requester1.gadget[i].eingabetext,cstr1,*((long*)a));
   else if(enthaelt(cstr1,"d"))
    sprintf(requester1.gadget[i].eingabetext,cstr1,*((int*)a));
   else	sprintf(requester1.gadget[i].eingabetext,cstr1,*((double*)a));
   //printf("gadget[i].eingabetext=\"%s\"\n",requester1.gadget[i].eingabetext);//test
   int b1=strlen(requester1.gadget[i].eingabetext)+2;
   int b2=strlen(requester1.gadget[i].fragetext)+2;
   br += (b2>b1)?b2:b1;
   if(!(umbruchflag || i==n-1)) br += gadhorabst/BREQ_X;
   if(br>breite) breite=br;
   //printf("i=%d breite=%d\n",i,breite);//test
   if(umbruchflag || i==n-1)
    {
     br=0;
     hoehe += gadhoehe+gadvertabst;
    }
  }
 int maxgadgetbreite=breite*BREQ_X;
 const char *titel="Input-Requester";
 if((int)strlen(titel)+2 > breite) breite=strlen(titel)+2;
 if(breite<26) breite=26;
 breite=(breite+2)*BREQ_X+2*REQ_RAND;
 const int hotitel=3*BREQ_Y;//TODO: ev. noch anpassen
 const int hoknoepfe=4*BREQ_Y;//TODO: ev. noch anpassen
 hoehe += hotitel+hoknoepfe+2*REQ_RAND;
 requester1.ng=n;

 // Zentrierter Titel: TODO: ev. vereinfachen
 static char titelzentriert[80];
 char cstr[80]; int tn=breite/BREQ_X; if(tn>80-2) tn=80-2;
 tn=(tn-strlen(titel))/2+strlen(titel);
 sprintf(cstr,"%%%d.%ds",tn,tn); sprintf(titelzentriert,cstr,titel);
 //printf("titel=\"%s\"\n",titelzentriert);//test
 
 requester1.set(REQ_INPUT,breite,hoehe,titelzentriert,"  ok  ","Cancel",NULL,0);
 int x1,y1;
 int kho=2*BREQ_Y, kbr=(6+2)*BREQ_X; //Knopf-Hoehe und -Breite (6+2=strlen("Cancel")+2)
 x1 = breite/3 - kbr/2;
 x1 += requester1.x1;
 y1 = requester1.y1+BREQ_Y;
 requester1.knopf1.set(x1,y1,kbr,kho);
 x1 += breite/3;
 requester1.knopf2.set(x1,y1,kbr,kho);
 y1 = requester1.y2 - REQ_RAND - BREQ_Y*6;//Position von 1.Gadget
 x1 = requester1.x1+(breite-maxgadgetbreite)/2;
 int x0=x1;
 for(i=0;i<requester1.ng;i++)
  {
   Gadget *pg = &requester1.gadget[i];
   kbr=strlen(pg->fragetext); //Breite von Gadget setzen
   int b=strlen(pg->eingabetext);
   if(b>kbr) kbr=b;
   kbr=(kbr+2)*BREQ_X;
   pg->set(x1,y1,kbr,kho);
   if(pg->umbruchflag)
    {x1=x0; y1 -= gadhoehe+gadvertabst;}
   else {x1 += kbr+gadhorabst;}
  } 
 requester1.gadget[0].aktiv=1;
 //glutPostRedisplay(); //geht nicht wenn in falschem Thread?
 while(requester1.antwort==REQ_EMPTY) usleep(10000);//warten bis gueltige Antwort
 return (requester1.antwort==1)?1:0;
}

//provisorische weitere Requester:
int nachfilenamefragen(const char *fragetext,char *name,int max)
{
 //TODO
 printf("Provisorischer filename-Requester:\n");//test
 /*
 printf("%s\ndefault:\"%s\"\n",fragetext,name);
 printf(    "eingabe: "); scanf("%s",name);
 */
 int ok=requester_input(1,fragetext,"%s","%s",name);
 return ok;
 /*
 char antwort[80];
 const char *s;
 for(s=fragetext;*s==' ';s++) {}
 if(toupper(s[0])=='L')
  {
   printf("soll Datei \"%s\" wirklich geladen werden?",name); scanf("%s",antwort);
  }
 else
  {
   printf("soll wirklich als \"%s\" gespeichert werden?",name); scanf("%s",antwort);
  }
 char c=toupper(antwort[0]);
 if(c=='J' || c=='Y') return 1;
 return 0;
 */
}

/****** Menu ******/
Menubalken menu;

#define BMEN_X (menu.bigfont*MEN_X)
#define BMEN_Y (menu.bigfont*MEN_Y)

static Menu mainmenu[MAXMENU];
static Menu submenu[MAXMENU];

void Menu::settext(const char *t)
{
 char *s=text;
 if(t!=NULL)
  for(int i=1;i<80 && *t!=0;i++) {*s++ = *t++;}
 *s = 0;
}

bool Menubalken::ist_maus_weg(int x,int y)
{
 return (y > 20*BMEN_Y);//provi.
}

void Menubalken::run()
{
 status=0; aktiv=false;
 mainmenu[mark].fun(mark);
}

void Menubalken::runfz()
{
 status=0; aktiv=false;
 fz(1);
}

void Menubalken::aktivieren(int x,int y)
{
 if(menupos[1]==0)
  {
   menupos[0]=REQ_RAND;
   for(int j=0;j<anzahl;j++)
    {
     int n=strlen(mainmenu[j].text);
     if(j+1>=20) {printf("zu viele Menupunkte\n");}//provi.
     else menupos[j+1]=menupos[j]+(n+2)*BMEN_X;
     int maxbr=0;
     for(int k=j+anzahl; mainmenu[k].text[0]!=0; k+=anzahl)
      {int br=strlen(mainmenu[k].text)+1; if(br>maxbr) maxbr=br;}
     menubreite[j]=maxbr*BMEN_X;
    }
  }
 if(y<MBH)
  {
   int j;
   for(j=0;j<anzahl && x>menupos[j+1];j++) {}
   if(j<anzahl) aufklapper=j;
   aktiv=true;
   if(status==0) status=1;
   else if(status>2) status=2;
  }
 else if(status>=2)
  {
   int k=aufklapper;
   int x1=menupos[k], x2=x1+menubreite[k];
   if(x>x1 && x<x2)
    {
     int ho=BMEN_Y*3/2; //Hoehe einer Zeile in einem Menu
     int n=(y-(MBH+1))/ho+1;
     mark=k+n*anzahl; //entsprechender Menupunkt markieren
     if(mainmenu[mark].text[0]!=0) status=3; else status=2;
    }
   else status=2;
  }
}

void Menubalken::klick(int x,int y,int state)
{
 int j;
 //if(requester1.aktiv) return; //bei aktivem Requester nichts im Menu machen
 if(!aktiv)
  {
   aktivieren(x,y);
   return;
  }
 if(state==1) //Mausknopf im Menu losgelassen
  {
   if(status==3 && y>MBH+1)
    {
     //run(); //entsprechender Menupunkt auswaehlen, fun() aufrufen
     start_run=true; //markieren damit es von anderm Thread aufgerufen wird
     usleep(20000); //warten bis es im andern Thread gemacht wurde
    }
  }
 else if(status<=2 || y<=MBH)
  {
   for(j=0;j<anzahl && x>menupos[j+1];j++) {}
   aufklapper=j;
   if(j<anzahl) status=2; //damit wird dann aufgeklapptes Menu gezeichnet
   else status=1;
  }
}

void Menubalken::key(unsigned char c, int x, int y)
{
 //TODO: ev. Menu mit Tasten selektieren
}
void Menubalken::spezial(int n,int x,int y)
{
 //TODO: ev. Menu mit Tasten selektieren
}
void Menubalken::mausknopf(int button,int state,int x,int y)
{
 if(button==0) menu.klick(x,y,state);
 else mausmotion(x,y);
}

void Menubalken::mausmotionpassiv(int x,int y)
{
 mausmotion(x,y);
}

void Menubalken::mausmotion(int x,int y) //von Mausbewegung aufzurufen
{
 //if(requester1.aktiv) return; //bei aktivem Requester nichts im Menu machen
 if(status==0) //wenn Menu inaktiv
  {
   if(y<MBH && anzahl>0) //wenn Maus in Menubalken-Bereich gefahren und Menu vorhanden
     aktivieren(x,y); //Menubalken aktivieren
  }
 else //bei aktivem Menu
  {
   if(ist_maus_weg(x,y)) //Maus weit weg vom Menu?
    deaktivieren();      //ja: Menu zuklappen und Menubalken deaktivieren
   else
    aktivieren(x,y);     //sonst: Menubalken event. neu aktivieren
  }
}

void glColor_menugrau()
{
 glColor3f(0.75*HF, 0.75*HF, 0.75*HF); //hellgrau fuer Menu-Hintergrund
}

void glColor_hellblau()
{
 //glColor3f(0.75*HF, 0.75*HF, HF); // Hellblau
 glColor3f(0.2*HF, 0.65*HF, 0.8*HF); //hellblau fuer selektiertes Menu
}

void Menubalken::anschreiben(int x,int y)
{
 for(int j=0;j<anzahl;j++)
  {
   sprintf(scratch,"%s",mainmenu[j].text);
   glColor3ub(0,0,0); //schwarze Schrift
   schrift(x+menupos[j], y, scratch);
   if(status>=1 && status<=2 && aufklapper==j)
    {//Text von aktivem Menu mit hellblauem Hintergrund
     glColor_hellblau();
     int x1=x+menupos[j], y1=y, x2=x+menupos[j+1]-1, y2=y1+MBH;
     glBegin(GL_QUADS);
     glVertex2i(x1, y2);
     glVertex2i(x1, y1);
     glVertex2i(x2, y1);
     glVertex2i(x2, y2);
     glEnd();
    }
  }
}

//so in xtekplot1:
//static funkzeiger menu_funkfeld[MAXMENU],menu_sub_funkfeld[MAXMENU];
//static int	menu_anzahl=0,menu_i=0,menu_isub=0,menu_k=0,
//		menu_istsub[MAXMENU],menu_sub_ifu[MAXMENU];
//static char	*menu_textfeld[MAXMENU];
//void menu_reset() {menu_anzahl=menu_i=menu_isub=menu_k=0; menubalkenhoehe=0;}

void setmenu(int n,...)
{
 if(n==0) {menu.reset(); return;} //Menu loeschen
// Beispiel:
// setmenu(3,"File","Funktionen",     "Hilfe");	/* Menuleiste */
// setmenu(3,"Quit","erste Funktion", "Über",   /* Menupunkte */
//	      &quit, &erste,	      &ueber);  /* Zeiger auf Funktionen */
// setmenu(2,"Exit","zweite Funktion",&exit,&zweite);
// setmenu(2,NULL,  "dritte Funktion",NULL,&dritte);
 int i,k;
 va_list ap;
 if(menu.imax+n > MAXMENU)
	{printf("maximale Menu-Anzahl ueberschritten\n"); return;}
 va_start(ap,n);
 if(menu.anzahl==0) //bei erstem Aufruf Hauptmenus setzen
  {
   menu.anzahl=n;
   for(i=0;i<n;i++) mainmenu[i].settext(va_arg(ap,char*));
   menu.imax=i;
  }
 else
  {
   for(k=menu.imax,i=0;i<n;i++)
    {
     mainmenu[k++].settext(va_arg(ap,char*));
    }
   for(k=menu.imax,i=0;i<n;i++)
    {
     mainmenu[k++].fun=va_arg(ap,funkzeiger);
     //amigatast.put(k-1,-k);
    }
   for(i=n;i<menu.anzahl;i++)
    {mainmenu[k].settext(""); mainmenu[k++].fun=NULL;}
   menu.imax += menu.anzahl;
   //if(menu_sub_ifu[menu_k]) menu_k++; //??
  }
 va_end(ap);
}

void setsubmenu(int n,...)
{
 printf("setsubmenu(n=%d, ...)  noch nicht ausprogrammiert!\n",n);//test
/** TODO: Submenus setzen
// Beispiel:
// setmenu(3,"File","Funktionen",     "Hilfe");	// Menuleiste
// setmenu(3,"Quit","erste Funktion", "Über", &quit, &erste, &ueber);
// setsubmenu(2,"ohne Speichern","Subpunkt 1",&ohne, &subpunkt1);
// setsubmenu(2,"mit Speichern", "Subpunkt 2",&mit,  &subpunkt2);
// setsubmenu(2,NULL,		 "Subpunkt 3",NULL,  &subpunkt3);
// setmenu(2,"Exit","zweite Funktion",&exit,&zweite);
 int i,k;
 va_list ap;
 if(menu_i+n > MAXMENU)
	{printf("maximale Menu-Anzahl ueberschritten\n"); return;}
 va_start(ap,n);
 menu_sub_ifu[menu_k]++;
 for(k=menu_i,i=0;i<n;i++,k++)
	{menu_textfeld[k]=va_arg(ap,char*); menu_istsub[k]=1;}
 for(k=menu_isub,i=0;i<n;i++)
	{menu_sub_funkfeld[k++]=va_arg(ap,funkzeiger);
	 amigatast.subput(k-1);
	}
 for(i=n;i<menu_anzahl;i++)
	{menu_textfeld[menu_i+i]=NULL; menu_sub_funkfeld[k++]=NULL;
	 menu_istsub[menu_i+i]=1;
	}
 menu_i += menu_anzahl;
 menu_isub += menu_anzahl;
 va_end(ap);
**/
}

void Menubalken::aufgeklapptes_zeichnen()
{
 int k,x1,y1,x2,y2;
 int ho=BMEN_Y*3/2; //Hoehe einer Zeile in einem Menu
 y2=bildhoehe-MBH; //ev. noch -1; ?
 y1=y2-ho;
 x1=menupos[aufklapper];
 x2=x1+menubreite[aufklapper];
 for(k=aufklapper+anzahl; mainmenu[k].text[0]!=0; k+=anzahl)
  {
   glColor3ub(0,0,0); //schwarze Schrift
   schrift(x1+REQ_RAND, y1+3, mainmenu[k].text);
   if(status>=3 && k==mark) glColor_hellblau(); // Hellblau wenn markiert
   else                     glColor_menugrau(); // sonst hellgrauer Hintergrund
   glBegin(GL_QUADS);
   glVertex2i(x1, y2);
   glVertex2i(x1, y1);
   glVertex2i(x2, y1);
   glVertex2i(x2, y2);
   glEnd();
   y1 -= ho;
   y2 -= ho;
  }
}

void Menubalken::mtextsize()
{
 if(*MENU_FONTSTRING==0) sprintf(MENU_FONTSTRING,"%dx%d",MEN_X,MEN_Y);
 textsize(BMEN_X,BMEN_Y,MENU_FONTSTRING);
}

void Menubalken::zeichnen()
{
 double x=REQ_RAND, y=bildhoehe-MBH+3;
 mtextsize();
 if(aktiv && status>=2) aufgeklapptes_zeichnen();
 
 glColor3f(HF,HF,HF); // Weiss fuer oberer Rahmen der Menuleiste
 glBegin(GL_QUADS);
 glVertex2i(0, bildhoehe);
 glVertex2i(0, bildhoehe-2);
 glVertex2i(bildbreite, bildhoehe-2);
 glVertex2i(bildbreite, bildhoehe);
 glVertex2i(0, bildhoehe);
 glVertex2i(0, bildhoehe-MBH);
 glVertex2i(2, bildhoehe-MBH);
 glVertex2i(2, bildhoehe);
 glColor3f(0.4*HF, 0.4*HF, 0.4*HF); // dunkelgrau fuer unteren Rahmen der Menuleiste
 glVertex2i(0, bildhoehe-MBH+2);
 glVertex2i(0, bildhoehe-MBH);
 glVertex2i(bildbreite, bildhoehe-MBH);
 glVertex2i(bildbreite, bildhoehe-MBH+2);
 glVertex2i(bildbreite-2, bildhoehe-MBH+2);
 glVertex2i(bildbreite-2, bildhoehe-MBH);
 glVertex2i(bildbreite, bildhoehe-MBH);
 glVertex2i(bildbreite, bildhoehe-MBH+2);
 glEnd();
 
 glColor3ub(0,0,0); // Schwarze Schrift
 anschreiben(x,y);
 
 glColor_menugrau(); // Hellgraue Menuleiste
 glBegin(GL_QUADS);
 glVertex2i(2, bildhoehe-2);
 glVertex2i(2, bildhoehe-MBH+2);
 glVertex2i(bildbreite-2, bildhoehe-MBH+2);
 glVertex2i(bildbreite-2, bildhoehe-2);
 glEnd();
}

void Menubalken::loop() //muss mit zweitem Thread gestartet werden
{
 while(!stopflag)
  {
   if(start_run==true)
    {
     start_run=false;
     run();
     //glutPostRedisplay(); //geht hier nicht
    }
   if(start_runfz==true)
    {
     start_runfz=false;
     runfz();
    }
   usleep(10000);
  }
}

static void start_loop(int nr)
{
 if(nr==0) glutMainLoop();
 else      menu.loop();
}
		
void Menubalken::startMainLoop()
{
 std::thread menuthread(start_loop,1);
 start_loop(0);
 menuthread.join();
 return;//wird nie erreicht
}
