/* menu.h

Es gibt nur genau 1 Menubalken (menu) und genau 1 Requester (requester1),
mehrere macht wohl keinen Sinn.

Um menu und Requester zu aktivieren muss im Hauptprogramm statt
glutMainLoop(); dann menu.startMainLoop(); aufgerufen werden.

Die folgenden Callback-Funktionen sollten weitergereicht werden:

 glutKeyboardFunc(key);
 glutSpecialFunc(spezial);
 glutMouseFunc(mausknopf);
 glutMotionFunc(mausmotion);
 glutPassiveMotionFunc(mausmotionpassiv);

also z.B. in key(c,x,y) sollte, falls menu.aktiv wahr ist, menu.key(c,x,y) aufgerufen werden.

*/

#ifndef MENU_H
#define MENU_H

#include <iostream>
#include <thread>
#include <unistd.h>
#include <ctype.h>
#include "myfonts.h"
extern int bildbreite,bildhoehe; //Fenstergroesse in Pixeln
const int REQ_X=12, REQ_Y=16; //Fontgroesse fuer alle Requester
const int MEN_X=12, MEN_Y=16; //Fontgroesse fuer Menu
const int REQ_RAND=4; //provi. Rand innerhalb von Requestern
#define MENU_BALKEN_HOEHE 23
#define MBH (menu.bigfont*MENU_BALKEN_HOEHE)
const float HELLIGKEITS_FAKTOR=1.0; //fuer dunkleres Menu auf kleiner 1.0 setzen
#define HF HELLIGKEITS_FAKTOR

class Knopf
{
public:
 int x1,y1,x2,y2; //Viereck unten links und oben rechts in Pixelkoordinaten
 //(x von links nach rechts, y von unten nach oben)
 void set(int xa,int ya,int b,int h) {x1=xa; y1=ya; x2=x1+b; y2=y1+h;}
 void zeichnen(const char *text,bool preselect);
 bool klick(int x,int y) {return (x>x1 && x<x2 && y>y1 && y<y2);}
};

//Requester-Typen:
#define REQ_JANEIN 1
#define REQ_INPUT  2
#define REQ_NACHFILENAMEFRAGEN  3

#define REQ_YES 1
#define REQ_NO  0
#define REQ_CANCEL (-1)
#define REQ_EMPTY  (-2)
#define REQ_PRESELECT 100

#define MAXGADS 20
//typedef char *APTR;
typedef void *APTR;

class Gadget //fuer Eingabefelder
{
public:
 const char *fragetext;
 char eingabetext[80];
 APTR pdata; //Zeiger auf einzugebende Daten
 char cstr[16]; //Controlstring um Daten mit sscanf() zu speichern
 bool umbruchflag;
 int aktiv; //0=nicht aktiv
 int cursor;
 int x1,y1,x2,y2; //Viereck von Eingabefeld unten links und oben rechts in Pixelkoordinaten
 int x3,y3,x4,y4; //Viereck von Feld fuer Fragetext
 //(x von links nach rechts, y von unten nach oben)
 Gadget() {fragetext=NULL; aktiv=0; cursor=0;}
 void set(int xa,int ya,int b,int h);
 void zeichnen();
 bool klick(int x,int y) {return (x>x1 && x<x2 && y>y1 && y<y2);} //in Eingabefeld geklickt?
 void key(char c,int x,int y); //bei Tastendruck wenn aktiv
 void spezial(int c,int x,int y);
 void save();
};

class Requester
{
public:
 bool aktiv;
 int typ;
 char text[4000];
 char jatext[80],neintext[80],canceltext[80];
 Gadget gadget[MAXGADS]; //Gadgets fuer Eingabefelder (bei REQ_INPUT)
 int ng; //Anzahl Gadgets wenn typ==REQ_INPUT
 //Subfenster unten links und oben rechts in Pixelkoordinaten:
 //(x von links nach rechts, y von unten nach oben)
 int x1,y1,x2,y2;
 Knopf knopf1,knopf2,knopf3; //Ja-, Nein-, und Cancel-Box
 int preselect; //1, 2, oder 3: entsprechender Knopf mit Enter auswaehlbar
 int bigfont; //1=normal, 2=doppelt, 3=dreifach so gross wie normal
 int antwort; //-2 = ungueltig, 0=nein, 1=ja, -1=cancel
 Requester() {aktiv=false; typ=0; preselect=0; bigfont=1;}
 void set(int t,int br,int ho,const char *txt,
	  const char *ja=NULL,const char *nein=NULL,const char *canc=NULL,int pre= -1);
 void reset() {aktiv=false;}
 void grosserfont(int n) {bigfont=n;}
 void zeichnen();
 void select(int a);
 void klick(int x,int y);
 //Tasten- und Maus-Ereignisse falls aktiv:
 void key(unsigned char c, int x, int y);
 void spezial(int n,int x,int y);
 void mausknopf(int button,int state,int x,int y);
 void mausmotion(int x,int y) {}//TODO: z.B. copy-paste mit Mittlerer Maustaste
 void mausmotionpassiv(int x,int y) {} //keine Reaktion auf Mausbewegung ohne gedrueckte Taste noetig
};

typedef void (*funkzeiger)(long);

#define MAXMENU 500

class Menu
{
public:
 funkzeiger fun;
 char text[80];
 int isub; //Verweis auf Submenu
 Menu() {fun=NULL; *text=0; isub= -1;}
 void settext(const char *t);
};

class Menubalken
{
public:
 int status; //0=inaktiv (ev. versteckt), 1=Leiste sichtbar, 2=Menu aufgeklappt,
             //3=Maus innerhalb aufgeklapptem Menu, 4=ein Menupunkt wurde ausgewaehlt
 int anzahl; //Anzahl Menus im Menubalken, 0=kein Menu vorhanden
 int imax; //Anzahl Menupunkte im laengsten Menu
 int sub_ifu; //naechste freie Nummer fuer Submenu
 int nzeichen_pro_menu;
 int menupos[20]; //Positionen von maximal 20 Menupunkten
 int menubreite[20]; //Breite in Pixeln fur laengsten Text in jedem Menu
 bool aktiv;
 int aufklapper; //Verweis auf aufgeklapptes Menu, Wert zwischen 0 und anzahl
 int bigfont; //1=normal, 2=doppelt, 3=dreifach so gross wie normal
 int mark; //markierter Menupunkt wenn aufgeklappt und Maus drauf gefahren
 bool start_run,start_runfz;
 int stopflag;
 funkzeiger fz;
 Menubalken() {bigfont=1; anzahl=imax=0; sub_ifu=0; reset();}
 void reset() {status=0; menupos[1]=0; aktiv=false; start_run=start_runfz=false; stopflag=0;}
 void grosserfont(int n) {bigfont=n; menupos[1]=0; status=0; aktiv=false;}
 void mtextsize();
 //bool vorhanden() {return menu.anzahl>0;}
 void anschreiben(int x,int y);
 void aktivieren(int x,int y);
 void deaktivieren() {status=0; aktiv=false;}
 bool ist_maus_weg(int x,int y);
 void klick(int x,int y,int state=0);
 void zeichnen();
 void aufgeklapptes_zeichnen();
 void run();
 void run(funkzeiger z) {fz=z; start_runfz=true; usleep(20000);}
 void runfz();
 void loop();
 void startMainLoop();
 void stop_loop() {stopflag=1;}
 //Tasten- und Maus-Ereignisse falls aktiv:
 void key(unsigned char c, int x, int y);
 void spezial(int n,int x,int y);
 void mausknopf(int button,int state,int x,int y);
 void mausmotion(int x,int y);
 void mausmotionpassiv(int x,int y);
 //void motion(int x,int y) {mausmotion(x,y);}//test
 //void motion2(int x,int y) {mausmotionpassiv(x,y);}//test
};

//Funktionen wie in xtekplot1:
int janeinrequester(const char *text,const char *jatext="ok",const char *neintext=NULL);
int requester_input(int n,...);
int nachfilenamefragen(const char *fragetext,char *name,int max);
void setmenu(int n,...);
void setsubmenu(int n,...);

//Erweiterung gegenueber xtekplot1:
int janeinrequester3(const char *text,const char *jatxt,const char *neintxt,const char *canceltxt);

extern Requester requester1;
extern Menubalken menu;

#endif
