;* bastest.asm
;* Testprogramm fuer RS232-BAS-Wandler
;* Controller: ATmega8
;* Copyright: Freeware
;-----------------------------------------------------------------------------
.include "m8def.inc"		;ATmega8
.equ F_CPU=16000000		;16 MHz Quarz
;.equ F_CPU=  3686400		;3.6864 MHz Quarz (geht nicht)
.equ SRAM_START = 0x60		;Start vom SRAM beim Atmega8

	rjmp main
.org OC1Aaddr
	rjmp timer1_match_A

;-----------------------------------------------------------------------------
; Registerbelegungen:
; r1=0
.def zeilenzaehlerL=r24
.def zeilenzaehlerH=r25
.def zeichen_linien_zaehler=r19
.def textzeilen_zaehler=r20

;-----------------------------------------------------------------------------
; Konstanten:
.equ zeilentotal=312
.equ obereleerzeilen=38
.equ inhaltzeilen=240
.equ untereleerzeilen=zeilentotal-obereleerzeilen-inhaltzeilen
.equ pixelprotextzeile=12
.equ textzeilen=inhaltzeilen/pixelprotextzeile ;=20
.equ zeichenprozeile=27
.equ ANZAHLTEXTBYTES=textzeilen*zeichenprozeile
	
;-----------------------------------------------------------------------------
; Variablen im SRAM:
                .DSEG
textspeicher:	.BYTE ANZAHLTEXTBYTES
	
		.CSEG

;-----------------------------------------------------------------------------
; Tabellen im FLASH:
font6x8:				     ;aus 6x8_horizontal_LSB_1.asm
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	; 0x00
.db 0x70,0x88,0xD8,0x88,0xA8,0x88,0x70,0x00,	; 0x01
.db 0x70,0xF8,0xA8,0xF8,0x88,0xF8,0x70,0x00,	; 0x02
.db 0x00,0x50,0xF8,0xF8,0xF8,0x70,0x20,0x00,	; 0x03
.db 0x00,0x20,0x70,0xF8,0xF8,0x70,0x20,0x00,	; 0x04
.db 0x20,0x70,0x70,0x20,0xF8,0xF8,0x20,0x00,	; 0x05
.db 0x00,0x20,0x70,0xF8,0xF8,0x20,0x70,0x00,	; 0x06
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	; 0x07
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	; 0x08
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	; 0x09
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	; 0x0A
.db 0x00,0xE0,0xC0,0xB0,0x48,0x48,0x30,0x00,	; 0x0B
.db 0x70,0x88,0x88,0x70,0x20,0x70,0x20,0x00,	; 0x0C
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	; 0x0D
.db 0xC0,0xB0,0xD0,0xB0,0xD0,0xD8,0x18,0x00,	; 0x0E
.db 0x00,0xA8,0x70,0xD8,0x70,0xA8,0x00,0x00,	; 0x0F
.db 0x10,0x30,0x70,0xF0,0x70,0x30,0x10,0x00,	; 0x10
.db 0x40,0x60,0x70,0x78,0x70,0x60,0x40,0x00,	; 0x11
.db 0x20,0x70,0xF8,0x20,0xF8,0x70,0x20,0x00,	; 0x12
.db 0x50,0x50,0x50,0x50,0x50,0x00,0x50,0x00,	; 0x13
.db 0xF0,0xA8,0xA8,0xB0,0xA0,0xA0,0xA0,0x00,	; 0x14
.db 0x70,0x88,0x30,0x50,0x60,0x88,0x70,0x00,	; 0x15
.db 0x00,0x00,0x00,0x00,0x00,0x78,0x78,0x00,	; 0x16
.db 0x20,0x70,0xF8,0x20,0xF8,0x70,0x20,0x70,	; 0x17
.db 0x20,0x70,0xF8,0x20,0x20,0x20,0x20,0x00,	; 0x18
.db 0x20,0x20,0x20,0x20,0xF8,0x70,0x20,0x00,	; 0x19
.db 0x00,0x20,0x60,0xF8,0x60,0x20,0x00,0x00,	; 0x1A
.db 0x00,0x20,0x30,0xF8,0x30,0x20,0x00,0x00,	; 0x1B
.db 0x00,0x00,0x00,0x08,0x08,0x08,0xF8,0x00,	; 0x1C
.db 0x00,0x50,0x50,0xF8,0x50,0x50,0x00,0x00,	; 0x1D
.db 0x20,0x20,0x70,0x70,0xF8,0xF8,0x00,0x00,	; 0x1E
.db 0xF8,0xF8,0x70,0x70,0x20,0x20,0x00,0x00,	; 0x1F
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	; 0x20
.db 0x20,0x70,0x70,0x20,0x20,0x00,0x20,0x00,	; 0x21
.db 0xD8,0xD8,0x48,0x00,0x00,0x00,0x00,0x00,	; 0x22
.db 0x00,0x50,0xF8,0x50,0x50,0xF8,0x50,0x00,	; 0x23
.db 0x10,0x70,0x08,0x30,0x40,0x38,0x20,0x00,	; 0x24
.db 0x98,0x98,0x40,0x20,0x10,0xC8,0xC8,0x00,	; 0x25
.db 0x10,0x28,0x28,0x10,0xA8,0x48,0xB0,0x00,	; 0x26
.db 0x30,0x30,0x10,0x00,0x00,0x00,0x00,0x00,	; 0x27
.db 0x20,0x10,0x10,0x10,0x10,0x10,0x20,0x00,	; 0x28
.db 0x10,0x20,0x20,0x20,0x20,0x20,0x10,0x00,	; 0x29
.db 0x00,0x50,0x70,0xF8,0x70,0x50,0x00,0x00,	; 0x2A
.db 0x00,0x20,0x20,0xF8,0x20,0x20,0x00,0x00,	; 0x2B
.db 0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x10,	; 0x2C
.db 0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,	; 0x2D
.db 0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,	; 0x2E
.db 0x00,0x80,0x40,0x20,0x10,0x08,0x00,0x00,	; 0x2F
.db 0x70,0x88,0xC8,0xA8,0x98,0x88,0x70,0x00,	; 0x30
.db 0x20,0x30,0x20,0x20,0x20,0x20,0x70,0x00,	; 0x31
.db 0x70,0x88,0x80,0x60,0x10,0x08,0xF8,0x00,	; 0x32
.db 0x70,0x88,0x80,0x70,0x80,0x88,0x70,0x00,	; 0x33
.db 0x40,0x60,0x50,0x48,0xF8,0x40,0x40,0x00,	; 0x34
.db 0xF8,0x08,0x08,0x78,0x80,0x88,0x70,0x00,	; 0x35
.db 0x60,0x10,0x08,0x78,0x88,0x88,0x70,0x00,	; 0x36
.db 0xF8,0x80,0x40,0x20,0x10,0x10,0x10,0x00,	; 0x37
.db 0x70,0x88,0x88,0x70,0x88,0x88,0x70,0x00,	; 0x38
.db 0x70,0x88,0x88,0xF0,0x80,0x40,0x30,0x00,	; 0x39
.db 0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x00,	; 0x3A
.db 0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x10,	; 0x3B
.db 0x40,0x20,0x10,0x08,0x10,0x20,0x40,0x00,	; 0x3C
.db 0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,	; 0x3D
.db 0x10,0x20,0x40,0x80,0x40,0x20,0x10,0x00,	; 0x3E
.db 0x70,0x88,0x80,0x60,0x20,0x00,0x20,0x00,	; 0x3F
.db 0x70,0x88,0xE8,0xA8,0xE8,0x08,0x70,0x00,	; 0x40
.db 0x70,0x88,0x88,0x88,0xF8,0x88,0x88,0x00,	; 0x41 'A'
.db 0x78,0x88,0x88,0x78,0x88,0x88,0x78,0x00,	; 0x42
.db 0x70,0x88,0x08,0x08,0x08,0x88,0x70,0x00,	; 0x43
.db 0x78,0x88,0x88,0x88,0x88,0x88,0x78,0x00,	; 0x44
.db 0xF8,0x08,0x08,0x78,0x08,0x08,0xF8,0x00,	; 0x45
.db 0xF8,0x08,0x08,0x78,0x08,0x08,0x08,0x00,	; 0x46
.db 0x70,0x88,0x08,0xE8,0x88,0x88,0xF0,0x00,	; 0x47
.db 0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,	; 0x48
.db 0x70,0x20,0x20,0x20,0x20,0x20,0x70,0x00,	; 0x49
.db 0x80,0x80,0x80,0x80,0x88,0x88,0x70,0x00,	; 0x4A
.db 0x88,0x48,0x28,0x18,0x28,0x48,0x88,0x00,	; 0x4B
.db 0x08,0x08,0x08,0x08,0x08,0x08,0xF8,0x00,	; 0x4C 'L'
.db 0x88,0xD8,0xA8,0x88,0x88,0x88,0x88,0x00,	; 0x4D
.db 0x88,0x98,0xA8,0xC8,0x88,0x88,0x88,0x00,	; 0x4E
.db 0x70,0x88,0x88,0x88,0x88,0x88,0x70,0x00,	; 0x4F
.db 0x78,0x88,0x88,0x78,0x08,0x08,0x08,0x00,	; 0x50
.db 0x70,0x88,0x88,0x88,0xA8,0x48,0xB0,0x00,	; 0x51
.db 0x78,0x88,0x88,0x78,0x48,0x88,0x88,0x00,	; 0x52
.db 0x70,0x88,0x08,0x70,0x80,0x88,0x70,0x00,	; 0x53
.db 0xF8,0x20,0x20,0x20,0x20,0x20,0x20,0x00,	; 0x54
.db 0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,	; 0x55
.db 0x88,0x88,0x88,0x88,0x88,0x50,0x20,0x00,	; 0x56
.db 0x88,0x88,0xA8,0xA8,0xA8,0xA8,0x50,0x00,	; 0x57
.db 0x88,0x88,0x50,0x20,0x50,0x88,0x88,0x00,	; 0x58
.db 0x88,0x88,0x88,0x50,0x20,0x20,0x20,0x00,	; 0x59
.db 0x78,0x40,0x20,0x10,0x08,0x08,0x78,0x00,	; 0x5A
.db 0x70,0x10,0x10,0x10,0x10,0x10,0x70,0x00,	; 0x5B
.db 0x00,0x08,0x10,0x20,0x40,0x80,0x00,0x00,	; 0x5C
.db 0x70,0x40,0x40,0x40,0x40,0x40,0x70,0x00,	; 0x5D
.db 0x20,0x50,0x88,0x00,0x00,0x00,0x00,0x00,	; 0x5E
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,	; 0x5F
.db 0x30,0x30,0x20,0x00,0x00,0x00,0x00,0x00,	; 0x60
.db 0x00,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00,	; 0x61
.db 0x08,0x08,0x78,0x88,0x88,0x88,0x78,0x00,	; 0x62
.db 0x00,0x00,0x70,0x88,0x08,0x88,0x70,0x00,	; 0x63
.db 0x80,0x80,0xF0,0x88,0x88,0x88,0xF0,0x00,	; 0x64
.db 0x00,0x00,0x70,0x88,0x78,0x08,0x70,0x00,	; 0x65
.db 0x60,0x10,0x10,0x78,0x10,0x10,0x10,0x00,	; 0x66
.db 0x00,0x00,0xF0,0x88,0x88,0xF0,0x80,0x70,	; 0x67
.db 0x08,0x08,0x38,0x48,0x48,0x48,0x48,0x00,	; 0x68
.db 0x20,0x00,0x20,0x20,0x20,0x20,0x60,0x00,	; 0x69
.db 0x40,0x00,0x60,0x40,0x40,0x40,0x48,0x30,	; 0x6A
.db 0x08,0x08,0x48,0x28,0x18,0x28,0x48,0x00,	; 0x6B
.db 0x20,0x20,0x20,0x20,0x20,0x20,0x60,0x00,	; 0x6C
.db 0x00,0x00,0x58,0xA8,0xA8,0x88,0x88,0x00,	; 0x6D
.db 0x00,0x00,0x38,0x48,0x48,0x48,0x48,0x00,	; 0x6E
.db 0x00,0x00,0x70,0x88,0x88,0x88,0x70,0x00,	; 0x6F
.db 0x00,0x00,0x78,0x88,0x88,0x88,0x78,0x08,	; 0x70
.db 0x00,0x00,0xF0,0x88,0x88,0x88,0xF0,0x80,	; 0x71
.db 0x00,0x00,0x68,0x90,0x10,0x10,0x38,0x00,	; 0x72
.db 0x00,0x00,0x70,0x08,0x70,0x80,0x70,0x00,	; 0x73
.db 0x00,0x10,0x78,0x10,0x10,0x50,0x20,0x00,	; 0x74
.db 0x00,0x00,0x48,0x48,0x48,0x68,0x50,0x00,	; 0x75
.db 0x00,0x00,0x88,0x88,0x88,0x50,0x20,0x00,	; 0x76
.db 0x00,0x00,0x88,0x88,0xA8,0xF8,0x50,0x00,	; 0x77
.db 0x00,0x00,0x48,0x48,0x30,0x48,0x48,0x00,	; 0x78
.db 0x00,0x00,0x48,0x48,0x48,0x70,0x20,0x18,	; 0x79
.db 0x00,0x00,0x78,0x40,0x30,0x08,0x78,0x00,	; 0x7A
.db 0x60,0x10,0x10,0x18,0x10,0x10,0x60,0x00,	; 0x7B
.db 0x20,0x20,0x20,0x00,0x20,0x20,0x20,0x00,	; 0x7C
.db 0x30,0x40,0x40,0xC0,0x40,0x40,0x30,0x00,	; 0x7D
.db 0x50,0x28,0x00,0x00,0x00,0x00,0x00,0x00,	; 0x7E
.db 0x20,0x70,0xD8,0x88,0x88,0xF8,0x00,0x00,	; 0x7F
.db 0x70,0x88,0x08,0x08,0x88,0x70,0x20,0x30,	; 0x80
.db 0x48,0x00,0x48,0x48,0x48,0x68,0x50,0x00,	; 0x81
.db 0xC0,0x00,0x70,0x88,0x78,0x08,0x70,0x00,	; 0x82
.db 0x70,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00,	; 0x83
.db 0x50,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00,	; 0x84
.db 0x30,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00,	; 0x85
.db 0x70,0x50,0x70,0x80,0xF0,0x88,0xF0,0x00,	; 0x86
.db 0x00,0x70,0x88,0x08,0x88,0x70,0x20,0x30,	; 0x87
.db 0x70,0x00,0x70,0x88,0x78,0x08,0x70,0x00,	; 0x88
.db 0x50,0x00,0x70,0x88,0x78,0x08,0x70,0x00,	; 0x89
.db 0x30,0x00,0x70,0x88,0x78,0x08,0x70,0x00,	; 0x8A
.db 0x50,0x00,0x20,0x20,0x20,0x20,0x60,0x00,	; 0x8B
.db 0x70,0x00,0x20,0x20,0x20,0x20,0x60,0x00,	; 0x8C
.db 0x10,0x00,0x20,0x20,0x20,0x20,0x60,0x00,	; 0x8D
.db 0x50,0x00,0x20,0x50,0x88,0xF8,0x88,0x00,	; 0x8E
.db 0x70,0x50,0x70,0xD8,0x88,0xF8,0x88,0x00,	; 0x8F
.db 0xC0,0x00,0xF8,0x08,0x78,0x08,0xF8,0x00,	; 0x90
.db 0x00,0x00,0x78,0xA0,0xF8,0x28,0xF0,0x00,	; 0x91
.db 0xF0,0x28,0x28,0xF8,0x28,0x28,0xE8,0x00,	; 0x92
.db 0x70,0x00,0x30,0x48,0x48,0x48,0x30,0x00,	; 0x93
.db 0x50,0x00,0x30,0x48,0x48,0x48,0x30,0x00,	; 0x94
.db 0x18,0x00,0x30,0x48,0x48,0x48,0x30,0x00,	; 0x95
.db 0x70,0x00,0x48,0x48,0x48,0x68,0x50,0x00,	; 0x96
.db 0x18,0x00,0x48,0x48,0x48,0x68,0x50,0x00,	; 0x97
.db 0x50,0x00,0x48,0x48,0x48,0x70,0x20,0x18,	; 0x98
.db 0x48,0x30,0x48,0x48,0x48,0x48,0x30,0x00,	; 0x99
.db 0x50,0x00,0x48,0x48,0x48,0x48,0x30,0x00,	; 0x9A
.db 0x00,0x00,0x80,0x70,0x68,0x58,0x38,0x04,	; 0x9B
.db 0x60,0x90,0x10,0x78,0x10,0x90,0xE8,0x00,	; 0x9C
.db 0xF0,0xC8,0xA8,0xA8,0xA8,0x98,0x78,0x00,	; 0x9D
.db 0x00,0x88,0x50,0x20,0x50,0x88,0x00,0x00,	; 0x9E
.db 0x40,0xA0,0x20,0x70,0x20,0x20,0x28,0x10,	; 0x9F
.db 0x60,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00,	; 0xA0
.db 0x60,0x00,0x20,0x20,0x20,0x20,0x60,0x00,	; 0xA1
.db 0x60,0x00,0x30,0x48,0x48,0x48,0x30,0x00,	; 0xA2
.db 0x60,0x00,0x48,0x48,0x48,0x68,0x50,0x00,	; 0xA3
.db 0x50,0x28,0x00,0x38,0x48,0x48,0x48,0x00,	; 0xA4
.db 0x50,0x28,0x00,0x48,0x58,0x68,0x48,0x00,	; 0xA5
.db 0x70,0x80,0xF0,0x88,0xF0,0x00,0xF0,0x00,	; 0xA6
.db 0x30,0x48,0x48,0x48,0x30,0x00,0x78,0x00,	; 0xA7
.db 0x20,0x00,0x20,0x30,0x08,0x88,0x70,0x00,	; 0xA8
.db 0x78,0xA4,0xD4,0xB4,0xD4,0x84,0x78,0x00,	; 0xA9
.db 0x00,0x00,0xFC,0x80,0x80,0x00,0x00,0x00,	; 0xAA
.db 0x08,0x48,0x28,0x70,0x88,0x40,0xE0,0x00,	; 0xAB
.db 0x08,0x48,0x28,0xD0,0xA8,0xE0,0x80,0x00,	; 0xAC
.db 0x20,0x00,0x20,0x20,0x70,0x70,0x20,0x00,	; 0xAD
.db 0x00,0x00,0x90,0x48,0x90,0x00,0x00,0x00,	; 0xAE
.db 0x00,0x00,0x48,0x90,0x48,0x00,0x00,0x00,	; 0xAF
.db 0xA8,0x00,0x54,0x00,0xA8,0x00,0x54,0x00,	; 0xB0
.db 0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,	; 0xB1
.db 0x54,0xFC,0xA8,0xFC,0x54,0xFC,0xA8,0xFC,	; 0xB2
.db 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,	; 0xB3
.db 0x20,0x20,0x20,0x3C,0x20,0x20,0x20,0x20,	; 0xB4
.db 0x60,0x00,0x20,0x50,0x88,0xF8,0x88,0x00,	; 0xB5
.db 0x70,0x00,0x20,0x50,0x88,0xF8,0x88,0x00,	; 0xB6
.db 0x30,0x00,0x20,0x50,0x88,0xF8,0x88,0x00,	; 0xB7
.db 0x78,0x84,0xB4,0x94,0xB4,0x84,0x78,0x00,	; 0xB8
.db 0x28,0x2C,0x20,0x2C,0x28,0x28,0x28,0x28,	; 0xB9
.db 0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,	; 0xBA
.db 0x00,0x3C,0x20,0x2C,0x28,0x28,0x28,0x28,	; 0xBB
.db 0x28,0x2C,0x20,0x3C,0x00,0x00,0x00,0x00,	; 0xBC
.db 0x00,0x20,0x70,0x08,0x08,0x70,0x20,0x00,	; 0xBD
.db 0x88,0x50,0x20,0xF8,0x20,0xF8,0x20,0x00,	; 0xBE
.db 0x00,0x00,0x00,0x3C,0x20,0x20,0x20,0x20,	; 0xBF
.db 0x20,0x20,0x20,0xE0,0x00,0x00,0x00,0x00,	; 0xC0
.db 0x20,0x20,0x20,0xFC,0x00,0x00,0x00,0x00,	; 0xC1
.db 0x00,0x00,0x00,0xFC,0x20,0x20,0x20,0x20,	; 0xC2
.db 0x20,0x20,0x20,0xE0,0x20,0x20,0x20,0x20,	; 0xC3
.db 0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,	; 0xC4
.db 0x20,0x20,0x20,0xFC,0x20,0x20,0x20,0x20,	; 0xC5
.db 0xA0,0x50,0x70,0x80,0xF0,0x88,0xF0,0x00,	; 0xC6
.db 0xA0,0x50,0x20,0x50,0x88,0xF8,0x88,0x00,	; 0xC7
.db 0x28,0xE8,0x08,0xF8,0x00,0x00,0x00,0x00,	; 0xC8
.db 0x00,0xF8,0x08,0xE8,0x28,0x28,0x28,0x28,	; 0xC9
.db 0x28,0xEC,0x00,0xFC,0x00,0x00,0x00,0x00,	; 0xCA
.db 0x00,0xFC,0x00,0xEC,0x28,0x28,0x28,0x28,	; 0xCB
.db 0x28,0xE8,0x08,0xE8,0x28,0x28,0x28,0x28,	; 0xCC
.db 0x00,0xFC,0x00,0xFC,0x00,0x00,0x00,0x00,	; 0xCD
.db 0x28,0xEC,0x00,0xEC,0x28,0x28,0x28,0x28,	; 0xCE
.db 0x88,0x70,0x88,0x88,0x88,0x70,0x88,0x00,	; 0xCF
.db 0x30,0x08,0x10,0x20,0x70,0x48,0x30,0x00,	; 0xD0
.db 0x70,0x90,0x90,0xB8,0x90,0x90,0x70,0x00,	; 0xD1
.db 0x70,0x00,0xF8,0x08,0x78,0x08,0xF8,0x00,	; 0xD2
.db 0x50,0x00,0xF8,0x08,0x78,0x08,0xF8,0x00,	; 0xD3
.db 0x30,0x00,0xF8,0x08,0x78,0x08,0xF8,0x00,	; 0xD4
.db 0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00,	; 0xD5
.db 0x60,0x00,0x70,0x20,0x20,0x20,0x70,0x00,	; 0xD6
.db 0x70,0x00,0x70,0x20,0x20,0x20,0x70,0x00,	; 0xD7
.db 0x50,0x00,0x70,0x20,0x20,0x20,0x70,0x00,	; 0xD8
.db 0x20,0x20,0x20,0x3C,0x00,0x00,0x00,0x00,	; 0xD9
.db 0x00,0x00,0x00,0xE0,0x20,0x20,0x20,0x20,	; 0xDA
.db 0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,	; 0xDB
.db 0x00,0x00,0x00,0x00,0xFC,0xFC,0xFC,0xFC,	; 0xDC
.db 0x20,0x20,0x20,0x00,0x20,0x20,0x20,0x00,	; 0xDD
.db 0x30,0x00,0x70,0x20,0x20,0x20,0x70,0x00,	; 0xDE
.db 0xFC,0xFC,0xFC,0xFC,0x00,0x00,0x00,0x00,	; 0xDF
.db 0x60,0x30,0x48,0x48,0x48,0x48,0x30,0x00,	; 0xE0
.db 0x00,0x38,0x48,0x38,0x48,0x48,0x38,0x08,	; 0xE1
.db 0x70,0x30,0x48,0x48,0x48,0x48,0x30,0x00,	; 0xE2
.db 0x18,0x30,0x48,0x48,0x48,0x48,0x30,0x00,	; 0xE3
.db 0x50,0x28,0x00,0x30,0x48,0x48,0x30,0x00,	; 0xE4
.db 0x50,0x28,0x30,0x48,0x48,0x48,0x30,0x00,	; 0xE5
.db 0x00,0x00,0x48,0x48,0x48,0x38,0x08,0x08,	; 0xE6
.db 0x00,0x18,0x08,0x38,0x48,0x38,0x08,0x18,	; 0xE7
.db 0x18,0x08,0x38,0x48,0x48,0x38,0x08,0x18,	; 0xE8
.db 0x60,0x00,0x48,0x48,0x48,0x48,0x30,0x00,	; 0xE9
.db 0x70,0x00,0x48,0x48,0x48,0x48,0x30,0x00,	; 0xEA
.db 0x18,0x00,0x48,0x48,0x48,0x48,0x30,0x00,	; 0xEB
.db 0x60,0x00,0x48,0x48,0x48,0x70,0x20,0x18,	; 0xEC
.db 0x60,0x00,0x88,0x50,0x20,0x20,0x20,0x00,	; 0xED
.db 0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,	; 0xEE
.db 0x30,0x30,0x10,0x00,0x00,0x00,0x00,0x00,	; 0xEF
.db 0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,	; 0xF0
.db 0x00,0x20,0x70,0x20,0x00,0x70,0x00,0x00,	; 0xF1
.db 0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,	; 0xF2
.db 0x0C,0x58,0x2C,0xD0,0xA8,0xE0,0x80,0x00,	; 0xF3
.db 0xF0,0xA8,0xA8,0xB0,0xA0,0xA0,0xA0,0x00,	; 0xF4
.db 0x70,0x88,0x30,0x50,0x60,0x88,0x70,0x00,	; 0xF5
.db 0x00,0x20,0x00,0xF8,0x00,0x20,0x00,0x00,	; 0xF6
.db 0x00,0x00,0x00,0x70,0x60,0x00,0x00,0x00,	; 0xF7
.db 0x30,0x48,0x48,0x30,0x00,0x00,0x00,0x00,	; 0xF8
.db 0x00,0x00,0x00,0x50,0x00,0x00,0x00,0x00,	; 0xF9
.db 0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,	; 0xFA
.db 0x10,0x18,0x10,0x10,0x00,0x00,0x00,0x00,	; 0xFB
.db 0x38,0x10,0x30,0x18,0x00,0x00,0x00,0x00,	; 0xFC
.db 0x18,0x20,0x10,0x38,0x00,0x00,0x00,0x00,	; 0xFD
.db 0x00,0x00,0x78,0x78,0x78,0x78,0x00,0x00,	; 0xFE
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 	; 0xFF

;-----------------------------------------------------------------------------
.equ NormalerCompwert = (F_CPU*64/1000000)-1 ;64 usec fuer Zeilenlaenge

timer1_init:
	push r16
	push r17
	ldi r16, (1<<WGM12)|(1<<CS10)	;CTC-OCR1A-Modus, Prescaler=1
	out TCCR1B, r16
	ldi r16, low(NormalerCompwert)
	ldi r17, high(NormalerCompwert)
	out OCR1AH, r17
	out OCR1AL, r16
	ldi r16, 0		;Startwert des Timers = 0
	out TCNT1H, r16
	out TCNT1L, r16
	ldi r16, 1<<OCIE1A	;Timer1 Interrupts bei Vergleichswert
	out TIMSK, r16
	ldi zeilenzaehlerL, low(312)
	ldi zeilenzaehlerH, high(312)
	pop r17
	pop r16
	ret

timer1_match_A:			;Interrupt-Routine
	push r0
	in r0, SREG
	push r16
	push r17
	push r18

	cbi PORTC, 0		;Start des Synchronimpulses
	sbiw zeilenzaehlerL, 1
	brne ti_L1
	ldi r16, 160
	rcall usecwait		;160 Microsekunden warten = Laenge des Seitensynchronisations-Pulses
	sbi PORTC, 0		;Ende des Synchronpulses
	ldi zeilenzaehlerL, low(312)
	ldi zeilenzaehlerH, high(312)
	rjmp ti_ret
ti_L1:
;	ldi r16, 5
;	rcall usecwait		;5 Microsekunden warten = Laenge des Zeilensynchronisations-Pulses
	ldi r16, 80		;test 80 Ticks = 5Microsekunden
;	ldi r16, 72		;test 72 Ticks = 4.5Microsekunden
	rcall tickswait		;test
	sbi PORTC, 0		;Ende des Synchronpulses
	ldi r16, 144
	rcall tickswait		;9 Microsekunden warten
	ldi r16, low(zeilentotal-obereleerzeilen)
	ldi r17, high(zeilentotal-obereleerzeilen)
	cp r24, r16
	cpc r25, r17
	brcc ti_ret		; Leerzeilen leer lassen
	ldi r16, low(zeilentotal-obereleerzeilen-1)
	ldi r17, high(zeilentotal-obereleerzeilen-1)
	cp r24, r16
	cpc r25, r17
	brne ti_L2
	ldi zeichen_linien_zaehler, 0
	ldi textzeilen_zaehler, 0
	sbi PORTB, 3		;Test: Start einer Linie
	ldi r16, 39		;Linienlaenge 39 Microsekunden
	rcall usecwait
	cbi PORTB, 3		;Ende der Linie
	rjmp ti_ret
ti_L2:
	cpi textzeilen_zaehler, textzeilen ;test: Linie auf letzter Zeile
	brne ti_L2a
	sbi PORTB, 3		;Test: Start einer Linie
	ldi r16, 40
	rcall usecwait
	cbi PORTB, 3		;Ende der Linie
	rjmp ti_L10
ti_L2a:	cpi textzeilen_zaehler, 1
	breq ti_L2b
	rjmp ti_L10
ti_L2b:	cpi zeichen_linien_zaehler, 8 ;groesser gleich 8 ?
	brcc ti_L10		      ;ja-->
	ldi r18, 2	     ;2 mal den folgenden test machen
	ldi r16,'L'		;Test: Zeichen L auf Textzeile 0 ausgeben
test_1:	ldi ZL, low(font6x8<<1)
	ldi ZH, high(font6x8<<1)
	ldi r17, 8		;8 mal zu Z addieren
ti_L3:	add ZL, r16
	adc ZH, r1
	dec r17
	brne ti_L3
;; jetzt zeigt Z hierhin:	.db 0x08,0x08,0x08,0x08,0x08,0x08,0xF8,0x00,	; 0x4C 'L'
	add ZL, zeichen_linien_zaehler
	adc ZH, r1
	lpm r16, Z+
	rol r16
	out PORTB, r16		;Bildpixel auf PB3
	ror r16
	out PORTB, r16		;Bildpixel auf PB3
	ror r16
	out PORTB, r16		;Bildpixel auf PB3
	ror r16
	out PORTB, r16		;Bildpixel auf PB3
	ror r16
	out PORTB, r16		;Bildpixel auf PB3
	ror r16
	out PORTB, r16		;Bildpixel auf PB3
	clr r16
	out PORTB, r16		;Ende des letzten Pixels
	ldi r16,'A'		;zweites: Zeichen A
	dec r18
	brne test_1
ti_L10:	inc zeichen_linien_zaehler
	cpi zeichen_linien_zaehler, 12
	brne ti_L11
	ldi zeichen_linien_zaehler, 0
	inc textzeilen_zaehler
ti_L11:	
	
ti_ret:	pop r18
	pop r17
	pop r16
	out SREG, r0
	pop r0
	reti

;-----------------------------------------------------------------------------
; Hauptprogramm:
main:	ldi r16, low(RAMEND)
        out SPL, r16		; Init Stackpointer L
        ldi r16, high(RAMEND)
        out SPH, r16		; Init Stackpointer H
	clr r1			; r1 global mit 0 belegen
	ldi r16, (1<<3)		; PB3
	out DDRB, r16		; Ausgang fuer Bildinhalt
	ldi r16, (1<<0)		; PC0
	out DDRC, r16		; Ausgang fuer Synchronisations-Pulse
	out PORTC, r16		; Ausgang gesetzt fuer inaktiv
	rcall timer1_init
	ldi r16, (1<<SE)
	out MCUCR, r16
	sei			; Interrupts einschalten

mainloop:
	sleep
	rjmp mainloop

#if F_CPU==16000000
usecwait:			;r16 Microsekunden lang warten (bei 16MHz)
	;; Aufruf (ldi r16,x plus rcall plus ret) braucht schon mal 8 Takte
	rjmp us_L2
us_L1:	nop
	adiw r24, 0		;wie nop mit 2 Takten
	adiw r24, 0
	adiw r24, 0
	adiw r24, 0
us_L2:	adiw r24, 0
	adiw r24, 0
	dec r16
	brne us_L1
us_ret:	ret
#else
usecwait:			;Variante fuer 3.6864MHz (ziemlich ungenau)
	dec r16
	brne us_L1		;bei r16==1 --> 8+2=11 Takte = 2.71us
	ret
us_L1:	cpi r16, 4
	brcs us_ret		;bis r16==4 --> 8+6=14 Takte = 3.80us
	dec r16
	dec r16
	dec r16
us_L2:	nop
	dec r16
	brne us_L2
us_ret:	ret
#endif

tickswait:			;r16 = Anzahl zu wartende Ticks (inklusive ldi und rcall und ret)
	cpi r16, 18		;Minimale Anzahl Ticks: bei weniger stimmts nicht
	brcs tc_ret
	subi r16, 14
	lsr r16
	brcs tc_L1
tc_L1:	lsr r16
	brcc tc_L3
	nop
	nop
tc_L2:	nop
tc_L3:	dec r16
	brne tc_L2
tc_ret:	ret

tickswait17: nop
tickswait16: nop
tickswait15: nop
tickswait14: nop
tickswait13: nop
tickswait12: nop
tickswait11: nop
tickswait10: nop
tickswait9:  nop
tickswait8:  nop
tickswait7:  ret
