;; grafikbas.asm            letzte Aenderung: 16.11.2012
;; Prozessor: Atmega1284P
;; Geht nur mit dem 1284P weil dieser als einziger mehr als 8KB RAM hat.
;; Schaltung: 20MHz-Quarz, PC0 als Sync-Ausgang, PB0 als Signal-Ausgang
;;
;;
;;
;* Copyright: Opensource, Freeware
;-----------------------------------------------------------------------------
;#define VERSION  "0.0" 		;dieses #define geht in avra-1.3.0 nicht

#define BREITBILD		;Version mit 320x256 (auskommentieren fuer 256x256)
#define INTERRUPTVERSION2	;Austesten einer verbesserten Interrupt-Behandlung
;#define INTERLACEMODUS		;zum Austesten (wir haben nicht genug RAM um es wirklich auszunutzen)

.equ F_CPU=20000000		;20 MHz Quarz

.include "m1284Pdef.inc"	;ATmega1284P

.equ LED_PORT=PORTD
.equ LED_DDR=DDRD
.equ LED_ROT=PD4
.equ LED_GRUEN=PD3
.equ LED_GELB=PD2

	rjmp main
.org OC1Aaddr
	rjmp timer1_match_A
.org SPIaddr
	rjmp spi_serial_transfer_complete
.org URXC0addr
	rjmp usart0_rx_complete

;-----------------------------------------------------------------------------
; Registerbelegungen:
; r4=Sicherung von SREG im Interrupt
; r5=0  Global auf 0 gesetzt
; Y (r29:r28) = Zeiger ins RAM auf den Grafikspeicher
.def zeilenzaehlerL=r24
.def zeilenzaehlerH=r25

#ifdef INTERRUPTVERSION2
.def syncstatus=r6
#endif
#ifdef INTERLACEMODUS
.def interlaceflag=r7
#endif

;-----------------------------------------------------------------------------
; Konstanten:
#ifdef BREITBILD
	.equ BYTESPROZEILE=40
#else
	.equ BYTESPROZEILE=32
#endif
.equ zeilentotal=312
.equ obereleerzeilen=38
.equ INHALTZEILEN=256
.equ PIXELPROZEILE=8*BYTESPROZEILE

.equ untereleerzeilen=zeilentotal-obereleerzeilen-INHALTZEILEN
.equ ANZAHLGRAFIKBYTES=INHALTZEILEN*PIXELPROZEILE/8

.equ SERBUFFERSIZE=8		;Fuer rs232-Empfang

;-----------------------------------------------------------------------------
; Variablen im SRAM:
                .DSEG
grafikspeicher:	.BYTE ANZAHLGRAFIKBYTES
serbuffer:	.BYTE SERBUFFERSIZE

		.CSEG

;-----------------------------------------------------------------------------
.equ NormalerCompwert = (F_CPU*64/1000000)-1 ;64 usec fuer Zeilenlaenge
;.equ NormalerCompwert = 1279

timer1_init:
	ldi r16, (1<<WGM12)|(1<<CS10)	;CTC-OCR1A-Modus, Prescaler=1
	sts TCCR1B, r16
	ldi r16, low(NormalerCompwert)
	ldi r17, high(NormalerCompwert)
	sts OCR1AH, r17
	sts OCR1AL, r16
	ldi r16, 0		;Startwert des Timers = 0
	sts TCNT1H, r16
	sts TCNT1L, r16
	ldi r16, 1<<OCIE1A	;Timer1 Interrupts bei Vergleichswert
	sts TIMSK1, r16
	ldi zeilenzaehlerL, low(312-1)
	ldi zeilenzaehlerH, high(312-1)
#ifdef INTERRUPTVERSION2
	clr syncstatus
#endif
#ifdef INTERLACEMODUS
	clr interlaceflag
#endif
	ret

;; Eine Video-Zeile sieht etwa so aus:
;; 5us Sync-Puls, 9us Schwarzschulter, 45us Inhalt, 5us leer --> total 64us
;; 100 Takte      180 Takte            900 Takte    100 Takte          1280 Takte
;; in den 900 Takten haben 256 Pixel mit je 3 Takten platz -> 768. Also noch Rand von 2*66 Takten uebrig
;; also so verwenden:
;; 100 Takte Sync, 246 leer, 768 Bildinhalt, 166 leer

;; Variante mit 320 Punkten auf x-Achse:
;; 3*320 = 960 also 2*30 Takte einsparen. Eventuell so:
;; 80 Takte Sync, 156 leer, 960 Bildinhalt, 84 leer

#ifdef BREITBILD
	.equ SYNC1=80
	.equ LEER1=156
#else
	.equ SYNC1=100
	.equ LEER1=246
#endif
	
timer1_match_A:			;Interrupt-Routine
	cbi PORTC, 0		;Synchronisationspuls starten
	in r4, SREG
	push r16
	push r17
	push r18
	push r19
	push r21

;	sbi LED_PORT, LED_ROT	;Test: rote LED ein
#ifdef INTERRUPTVERSION2
	tst syncstatus
	brne t1_L2
#endif
	adiw zeilenzaehlerL, 1
	ldi r16, low(312)
	ldi r17, high(312)
	cp  zeilenzaehlerL, r16
	cpc zeilenzaehlerH, r17
	brne t1_L1
	ldi zeilenzaehlerL, 0
	ldi zeilenzaehlerH, 0
	ldi YL, low(grafikspeicher)
	ldi YH, high(grafikspeicher)
#ifdef INTERRUPTVERSION2
	ldi r16, 2		;Statt hier 160 usec zu vertroedeln, 2 Interrupts abwarten und nur noch
	mov syncstatus, r16	;beim 3. mal die restlichen 160-2*64=32 usec abwarten
	rjmp t1_ret
t1_L2:	dec syncstatus
	brne t1_ret
	ldi r16, 32-1		;32 - ca. Anzahl schon verbrauchte Microsekunden
	rcall usecwait
	sbi PORTC, 0		;Synchronisationspuls ende
#ifdef INTERLACEMODUS
	ldi r16, 1
	eor interlaceflag, r16
	breq t1_ret
	ldi r16, 6		;Anzahl schon verbrauchte Takte seit Synch. ende
	sts TCNT1H, r5
	sts TCNT1L, r16
#endif
	rjmp t1_ret
#else
	ldi r16, SYNC1-23	;100 - Anzahl Ticks seit Synchronisationspuls start
	rcall tickswait
	ldi r16, 155		;100 Ticks + 155 usec = 160 usec
	rcall usecwait		;160 Microsekunden fuer Seitensynchronisation
	sbi PORTC, 0		;Synchronisationspuls ende
	rjmp t1_ret
#endif
t1_L1:
	rcall zeile_darstellen
t1_ret:
;	cbi LED_PORT, LED_ROT	;Test: rote LED aus
	pop r21
	pop r19
	pop r18
	pop r17
	pop r16
	out SREG, r4
	reti

spi_serial_transfer_complete:
	reti

usart0_rx_complete:
	reti

;-----------------------------------------------------------------------------
; Hauptprogramm:
main:	ldi r16, low(RAMEND)
        out SPL, r16		; Init Stackpointer L
        ldi r16, high(RAMEND)
        out SPH, r16		; Init Stackpointer H
	clr r5			; r5 global mit 0 belegen
	ldi r16, (1<<0)		; PB0
	out DDRB, r16		; Ausgang fuer Bildinhalt
	ldi r16, (1<<0)		; PC0
	out DDRC, r16		; Ausgang fuer Synchronisations-Pulse
	out PORTC, r16		; Ausgang gesetzt fuer inaktiv

	ldi r16, (1<<LED_ROT)|(1<<LED_GRUEN)|(1<<LED_GELB)
	out LED_DDR, r16	; Ausgaenge fuer Test-LEDs
	out LED_PORT, r16	; Test: alle LEDs ein

#ifdef DEBUG1
	ldi r26, low(1000)
	ldi r27, high(1000)
test1:	ldi r24, low(1000)
	ldi r25, high(1000)
test2:	cbi PORTC, 0
	cbi LED_PORT, LED_ROT
	ldi r16, 5
	rcall usecwait
	sbi PORTC, 0
	sbi LED_PORT, LED_ROT
	ldi r16, 5
	rcall usecwait
	sbiw r24, 1
	brne test2
	sbiw r26, 1
	brne test1
#endif

;; testgrafik
	ldi XL, low(grafikspeicher) ;Test: eine Beispiel-Grafik in den Speicher laden
	ldi XH, high(grafikspeicher)
	ldi r16, 0xFF		;Daten fuer eine gerade Linie
	ldi r18, 2*BYTESPROZEILE	;auf 2 Video-Linien, also Liniendicke = 2
m1:	st X+, r16
	dec r18
	brne m1
	ldi r18, 128		;auf naechsten 128 Zeilen eine schraege Linie zeichnen
	ldi r17, 0		;Start mit Byte 0
	ldi r16, 0x01		;und erstes Bit gesetzt
m2:	ldi r19, 0		;Bytes in aktueller Zeile
m2a:	cp r19, r17		;aktuelles Byte?
	brne m3			;nein->
	st X+, r16		;ja: aktuelles Bit setzen
	rjmp m4
m3:	st X+, r5		;nein: alle Bits auf Null setzen
m4:	inc r19
	cpi r19, BYTESPROZEILE	;Zeilenende erreicht?
	brne m2a		;nein->
	lsl r16			;ja: naechste Zeile, Register auf naechstes Bit schieben
	brne m4a
	ldi r16, 0x01		;wenn 0 erreicht, dann wieder erstes Bit setzen
	inc r17			;und auf naechstes Byte erhoehen
m4a:	dec r18
	brne m2
;; noch eine Linie, aber mit kleinerer Steigung:
	ldi r18, 64		;auf naechsten 64 Zeilen eine schraege Linie zeichnen
	ldi r17, 0		;Start mit Byte 0
	ldi r16, 0x03		;und erste 2 Bits gesetzt
	ldi r20, 0x00		;weiteres Byte fuer Ubergang der Bits
ml2:	ldi r19, 0		;Bytes in aktueller Zeile
ml2a:	mov r0, r17
	inc r0
	cp r19, r0		;weiteres Byte aktuell?
	brne ml2b		;nein->
	st X+, r20		;weiteres Byte speichern
	rjmp ml4
ml2b:	cp r19, r17		;aktuelles Byte?
	brne ml3			;nein->
	st X+, r16		;ja: aktuelles Bit setzen
	rjmp ml4
ml3:	st X+, r5		;nein: alle Bits auf Null setzen
ml4:	inc r19
	cpi r19, BYTESPROZEILE	;Zeilenende erreicht?
	brne ml2a		;nein->
	lsl r16			;ja: naechste Zeile, Register auf naechstes Bit schieben
	rol r20			;und eventuell schieben ins weitere Byte
	lsl r16			;zweites mal schieben
	rol r20			;und eventuell schieben ins weitere Byte
	tst r16
	brne ml4a
	mov r16, r20		;wenn r16==0 erreicht, dann Bits wieder vom weiteren Byte uebernehmen
	ldi r20, 0x00		;und weiteres Byte wieder auf Null
	inc r17			;und auf naechstes Byte erhoehen
ml4a:	dec r18
	brne ml2

	ldi r18, 256-2-128-64	;auf den verbleibenden Zeilen eine senkrechte Linie zeichnen
	ldi r16, 0x01
m5:	st X+, r16		;erstes Bit im ersten Byte setzen
	ldi r17, BYTESPROZEILE-2
m6:	st X+, r5		;restliche Bytes der Zeile auf 0
	dec r17
	brne m6
	ldi r17, 0x80		;ausser letztes Byte letztes Bit gesetzt
	st X+, r17		;um eine senkrechte Linie ganz rechts zu zeichnen
	dec r18
	brne m5
;; ende testgrafik

	rcall timer1_init
	sei			; Interrupts einschalten

	out LED_PORT, r5	; Test: alle LEDs aus

mainloop:
	ldi r16, (1<<SE)
	out SMCR, r16
	sleep
	rjmp mainloop
	

;; Eine Video-Zeile sieht etwa so aus:
;; 5us Sync-Puls, 9us Schwarzschulter, 45us Inhalt, 5us leer --> total 64us
;; 100 Takte      180 Takte            900 Takte    100 Takte          1280 Takte
;; in den 900 Takten haben 256 Pixel mit je 3 Takten platz -> 768. Also noch Rand von 2*66 Takten uebrig
;; also so verwenden:
;; 100 Takte Sync, 246 leer, 768 Bildinhalt, 166 leer

;; Variante mit 320 Punkten auf x-Achse:
;; 3*320 = 960 also 2*30 Takte einsparen. Eventuell so:
;; 80 Takte Sync, 160 leer, 960 Bildinhalt, 80 leer

grafikzeile_darstellen:		;Y=Zeiger auf den Grafikspeicher im RAM
	ld r19, Y+
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;2. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;3. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;4. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;5. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;6. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;7. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;8. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;9. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;10. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;11. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;12. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;13. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;14. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;15. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;16. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;17. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;18. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;19. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;20. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;21. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;22. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;23. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;24. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;25. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;26. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;27. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;28. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;29. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;30. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;31. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;32. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
#ifdef BREITBILD
	ld r19, Y+		;33. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;34. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;35. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;36. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;37. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;38. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;39. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
	ld r19, Y+		;40. Byte einlesen
	out PORTB, r19		;1.Bit auf PB0 ausgeben
	nop
	lsr r19
	out PORTB, r19		;2.Bit
	nop
	lsr r19
	out PORTB, r19		;3.Bit
	nop
	lsr r19
	out PORTB, r19		;4.Bit
	nop
	lsr r19
	out PORTB, r19		;5.Bit
	nop
	lsr r19
	out PORTB, r19		;6.Bit
	nop
	lsr r19
	out PORTB, r19		;7.Bit
	nop
	lsr r19
	out PORTB, r19		;8.Bit
#endif
	nop
	clr r19
	out PORTB, r19		;letztes Bit abschliessen
	ret

;; Eine Video-Zeile sieht etwa so aus:
;; 5us Sync-Puls, 9us Schwarzschulter, 45us Inhalt, 5us leer --> total 64us
;; 100 Takte      180 Takte            900 Takte    100 Takte          1280 Takte
;; in den 900 Takten haben 256 Pixel mit je 3 Takten platz -> 768. Also noch Rand von 2*66 Takten uebrig
;; also so verwenden:
;; 100 Takte Sync, 246 leer, 768 Bildinhalt, 166 leer

;; Variante mit 320 Punkten auf x-Achse:
;; 3*320 = 960 also 2*30 Takte einsparen. Eventuell so:
;; 80 Takte Sync, 160 leer, 960 Bildinhalt, 80 leer

zeile_darstellen:
	ldi r16, SYNC1-24	;100 - Takte seit Synchronisationspuls gestartet
	rcall tickswait
	sbi PORTC, 0		;Synchronisationspuls ende
	ldi r16, 38
	cp  zeilenzaehlerL, r16
	cpc zeilenzaehlerH, r5
	brcs zd_ret		;erste 38 Zeilen sind Leerzeilen
	ldi r16, low(38+INHALTZEILEN)
	ldi r17, high(38+INHALTZEILEN)
	cp  zeilenzaehlerL, r16
	cpc zeilenzaehlerH, r17
	brcc zd_ret		;letzte Zeilen sind Leerzeilen
	ldi r16, LEER1-7	;246 - Anzahl Takte von Synchpuls bis zum ersten Bit
	rcall tickswait		;9usec Schwarzschulter + leerer Teil
	rcall grafikzeile_darstellen
zd_ret:	ret

;-----------------------------------------------------------------------------
; Exakte Warteroutinen:
tickswait:			;r16 = Anzahl zu wartende Takte (inklusive ldi und rcall und ret)
	cpi r16, 18		;Minimale Anzahl Ticks: bei weniger stimmts nicht
	brcs ti_ret
	subi r16, 14
	lsr r16
	brcs ti_L1
ti_L1:	lsr r16
	brcc ti_L3
	adiw r24, 0		;statt 2 mal nop
ti_L2:	nop
ti_L3:	dec r16
	brne ti_L2
ti_ret:	ret

tickswait17: nop
tickswait16: nop
tickswait15: nop
tickswait14: nop
tickswait13: nop
tickswait12: nop
tickswait11: nop
tickswait10: nop
tickswait9:  nop
tickswait8:  nop
tickswait7:  ret		;rcall und ret brauchen zusammen 7 Takte

#if (F_CPU==16000000)
us_L1:	adiw r24, 0		;statt 2 mal nop
	adiw r24, 0
	adiw r24, 0
	adiw r24, 0
usecwait:			;r16 = Anzahl Microsekunden warten (bei 16MHz) (inklusive ldi und rcall und ret)
	adiw r24, 0
	adiw r24, 0
	nop
	dec r16
	brne us_L1
	nop
	ret			;ldi und rcall und ret brauchen zusammen 8 Takte
#endif

#if (F_CPU==20000000)
us_L1:	adiw r24, 0
	adiw r24, 0
	adiw r24, 0
	adiw r24, 0
usecwait:			;r16 = Anzahl Microsekunden warten (bei 20MHz) (inklusive ldi und rcall und ret)
	adiw r24, 0
	adiw r24, 0
	adiw r24, 0
	adiw r24, 0
	nop
	dec r16
	brne us_L1
	nop
	ret
#endif
