/*
Unvollstaendiges ARM-Assemlber-Programm
zum finden der optimalen Representation des Wuerfels.

Representation des Wuerfels:
 8 Ecken mit je 3 Orientierungsmoeglichkeiten, 3+2=5 Bits
 12 Kanten mit je 2 Orientierungsmoeglichkeiten, 4+1=5 Bits
 es werden also mindestens (8+12)*5 Bits = 100 Bits = 13 Bytes gebraucht

Singmaster notation der Grundstellung:
    UF UR UB UL DF DR DB DL FR FL BR BL UFR URB UBL ULF DRF DFL DLB DBR
Nr: 0  1  2  3  4  5  6  7  8  9  10 11  0   1   2   3   4   5   6   7
In dieser Stellung sind alle Orientierungen == 0
Andere Kantenorientierungen sind 1,
andere Eckenorientierungen: 1 (fuer rechts) oder 2 (fuer links gedreht)

Nummerierung der Ecken und Kanten in der Abwicklung:
        +---------+
        | 6  6  5 |
Back    | 11   10 |
        |         |
+-------+---------+-------+
|6  11  | 2  2  1 |  10 5 |
|7  L   | 3     1 |  R  5 |  Left  Up  Right
|7  9   | 3  0  0 |  8  4 |
+-------+---------+-------+
        |         |
  Front | 9     8 |
        |         |
        +---------+
        | 5  4  4 |
  Down  | 7     5 |
        | 6  6  7 |
        +---------+

Variante1:
	
r0: Positionen von allen 8 Ecken: 8*3=24 Bits
r1: Orientierungen alle 8 Ecken: 8*2=16 Bits
r2: Positionen von 8 Kanten: 8*4=32 Bits
r3: Positionen von 4 Kanten + Orientierungen alle Kanten: 4*4+12=28 Bits
*/
@ Unterprogramme fuer Variante1:
drehenU:
	mov r4, #0xFF
	add r4, #0xF00	@ r4=0xFFF (12 Bits gesetzt)
	and r5, r0, r4  @ r5=obere 4 Ecken
	lsr r5, #3
	add r5, r0,lsl#9
	and r5, r4
	bic r0, r4
	add r0, r5	@ obere 4 Ecken Positionen sind jetzt entsprechend getauscht
	and r5, r1, #0xFF  @ r5=Orientierungen obere 4 Ecken
	lsr r5, #2
	add r5, r1,lsl#6
	and r5, #0xFF
	bic r1, #0xFF
	add r1, r5	@ obere 4 Ecken Orientierungen jetzt auch entsprechend getauscht
	@ jetzt muessten noch obere 4 Kanten Positionen und Orientierungen getauscht werden
	mov pc, lr
/*
Variante2:
      Ecke 3     Ecke 2     Ecke 1     Ecke 0
r0: 000Q QPPP  000Q QPPP  000Q QPPP  000Q QPPP  (Q=Orientierung, P=Position)

      Ecke 7     Ecke 6     Ecke 5     Ecke 4
r1: 000Q QPPP  000Q QPPP  000Q QPPP  000Q QPPP  (Q=Orientierung, P=Position)

      Kante 3    Kante 2    Kante 1    Kante 0
r2: 000Q PPPP  000Q PPPP  000Q PPPP  000Q PPPP  (Q=Orientierung, P=Position)

      Kante 7    Kante 6    Kante 5    Kante 4
r3: 000Q PPPP  000Q PPPP  000Q PPPP  000Q PPPP  (Q=Orientierung, P=Position)

     Kante 11   Kante 10    Kante 9    Kante 8
r4: 000Q PPPP  000Q PPPP  000Q PPPP  000Q PPPP  (Q=Orientierung, P=Position)
*/

@ Unterprogramme fuer Varainte2:
drehenF:	@ Ecken: 3->0->4->5->3, Kanten: 0->8->4->9->0
		@ Orient:   1  2  1  2             1  1  1  1
	mov r5, r0,lsr#24	@ r5=Ecke3 (unterstes Byte von r5)
	add r5, #0x08		@ Orientierung nach rechts drehen
	cmp r5, #0x18		@ Orientierung >= 3 ?
	subcs r5, #0x18		@ ja: auf Bereich 0..2 bringen
	and r6, r0, #0xFF	@ Ecke0
	bic r0, 0xFF		@ Bits fuer neue Ecke0 ruecksetzen
	add r0, r5		@ Ecke3 --> Ecke0
	cmp r6, #0x08		@ war Orientierung schon nach rechts gedreht?
	subcs r6, #0x08		@ ja: links drehen
	addcc r6, #0x10		@ nein: 2 mal nach rechts drehen
	and r5, r1, #0xFF	@ r5=Ecke4
	bic r1, #0xFF
	add r1, r6		@ Ecke0 --> Ecke4
	@ vorherige Ecke4 drehen

drehenU:
	ror r0, #8
	ror r2, #8
	mov pc, lr
drehenU2:
	ror r0, #16
	ror r2, #16
	mov pc, lr
drehenU3:
	ror r0, #24
	ror r2, #24
	mov pc, lr
drehenD:
	ror r1, #8
	ror r3, #24
	mov pc, lr
drehenD2:
	ror r1, #16
	ror r3, #16
	mov pc, lr
drehenD3:
	ror r1, #24
	ror r3, #8
	mov pc, lr
