/* rubik.cc			letzte Aenderung: 7.5.2015 */
#define VERSION "Version 0.2"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Suche von einfacheren Loesungen fuer den Rubik-Cube

History:
18.4.2015       Erstellung (RP)
1.5.2015   0.1  einigermassen funktionierend
           0.2  Versuch weiterer Optimierungen in drehung()
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <xtekplot1.h>

#define XMAX 1280
#define YMAX 1024
//#define TIEFE 24
#define TIEFE 8

#define SCHWARZAUFWEISS //auskommentieren fuer weiss auf schwarz

/************************* Vordeklarationen ***************************/
typedef unsigned char uint8;
void wuerfel_zeichnen();
void abwicklung_zeichnen(double x0,double y0);
void filldrawbox(double x1,double y1,double x2,double y2);
void pre();
void rel();
void verd();
void mot();
void d3_drawbox(double x1,double y1,double z1,double x2,double y2,double z2);
void d3filldrawbox(double x1,double y1,double z1,double x2,double y2,double z2);
void neuzeichnen();
void stellung_reset();

/************************ Globale Variablen ***************************/
static int exitflag=0;
static double xmin=0,ymin=0,xmax=1280,ymax=1024;
static double kante=80; //Kantenlaenge eines kleinen Wuerfels
const double zf=0.5; //Verkurzung in z-Richtung bei perspektivischer Zeichnung
static double abw_x0=500,abw_y0=30; //Position der Abwicklung
static double per_x0=50,per_y0=50; //Nullpunkt der perspektivischen Darstellung
static int abwickvariante=2;
static FILE *fpziel=NULL;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while((c= *s++)!=0)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** kleinkram ***************************/
bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/** Zufallszahlen **/
double zufall4()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

#include <time.h>
double zufall5(int start=0)
{
 static int flag=1;
 if(flag!=0 || start!=0)
  {time_t t;
   time(&t);
   srand(t);
   flag=0;
  }
 return (1.0 - rand()/(double)RAND_MAX);
}

// Eins von beiden auskommentieren:
inline double zufall() {return zufall4();}
//inline double zufall() {return zufall5();}

void zugdrucken(int c,int n,int nl)
{
 if(n==1) printf("%c",c);
 else if(n==2) printf("%c2",c);
 else printf("%c'",c);
 if(nl!=0) fputc(nl,stdout);
}

void zugdruckenfp(FILE *fp,int c,int n,int nl)
{
 if(n==1) fprintf(fp,"%c",c);
 else if(n==2) fprintf(fp,"%c2",c);
 else fprintf(fp,"%c'",c);
 if(nl!=0) fputc(nl,fp);
}

#if(TIEFE==24)
inline void myrgbcolor(int r,int g,int b) {rgbcolor(r,g,b);}
#else
void myrgbcolor(int r,int g,int b)
{
 setcolor(2,r,g,b);
 color(2);
}
#endif

/******************* Klassen fuer Hauptprogramm ***********************/
class Farbe
{
public:
 int r,g,b;
};

static Farbe farben[6] =
 {
  {0xC0, 0x00, 0x00}, // rot
  {0xFF, 0xFF, 0xFF}, // weiss
  {0xFF, 0x7F, 0x30}, // orange
  {0xFF, 0xFF, 0x00}, // gelb
  {0x00, 0xFF, 0x00}, // gruen
  {0x00, 0x00, 0xFF} // blau
 };

/* moegliche Typen:
#define MITTE 0
#define KANTE 1
#define ECKE  2
*/

class Rub  //kleines Farbiges Quadrat
{
 //int typ; //typ wird nicht wirklich gebraucht
public:
 uint8 farb; //Farbnummer (0 bis 5)
 //void init(int f,int t) {farb=f; typ=t;}
 void init(uint8 f) {farb=f;}
 void zeichnen(double x1,double y1);
 void zeichnen3d(double x1,double y1,double z1);
 bool operator!=(Rub& v) {return (farb!=v.farb);}
};

void Rub::zeichnen(double x1,double y1) //in der Abwicklung zeichnen
{
 myrgbcolor(farben[farb].r,farben[farb].g,farben[farb].b);
 filldrawbox(x1,y1,x1+kante,y1+kante);
}

void Rub::zeichnen3d(double x1,double y1,double z1) //in der Perspektivischen Darstellung zeichnen
{
 double v=2.5*kante;
 myrgbcolor(farben[farb].r,farben[farb].g,farben[farb].b);
 //printf("Rub::zeichnen3d(%f,%f,%f)\n",x1,y1,z1);//test
 if(x1<v && y1<v)
  {
   filldrawbox(per_x0+x1,per_y0+y1,per_x0+x1+kante,per_x0+y1+kante); //Vorderes Quadrat in der Ebene zeichnen
  }
 else if(x1<v)
  {
   d3filldrawbox(x1,y1,z1, x1+kante,y1,z1+kante); //Oberes Quadrat perspektivisch zeichnen
  }
 else
  {
   d3filldrawbox(x1,y1,z1, x1,y1+kante,z1+kante); //Rechtes Quadrat perspektivisch zeichnen
  }
}

static Rub hauptfeld[6*9];
static Rub grundstellung[6*9];

static char seitenbuchstabe[6]={'D','F','U','B','L','R'};

int buchstabe_nach_zahl(char c)
{
 int k;
 for(k=6;seitenbuchstabe[--k]!=c && k!=0;) ;
 return k;
}

void drehung(Rub* feld,char c,int n);

void dateiladen(char *name)
{
 FILE *fp=fopen(name,"r");
 char zeile[200];
 int i,j,k,anz,z[3];
 printf("dateiladen(%s)\n",name);
 if(fpziel!=NULL) fprintf(fpziel,"dateiladen(%s)\n",name);
 if(fp==NULL) {janeinrequester("Datei nicht gefunden."); return;}
 if(!getline(fp,zeile,200)) {printf("Fehler: leere Datei.\n"); fclose(fp); return;}
 if(strncmp(zeile,"D:",2)==0) //eigenes Dateiformat
  for(k=0;k<6;k++)
  {
   if(k!=0)
    {
     if(!getline(fp,zeile,80)) {printf("viel zu wenige Zeilen in Datei.\n"); break;}
     if(zeile[1]!=':' || zeile[0]!=seitenbuchstabe[k])
      {printf("Fehler in Dateiformat: '%s'\n",zeile); break;}
    }
   for(j=0;j<3;j++)
    {
     if(!getline(fp,zeile,80)) {printf("zu wenige Zeilen in Datei.\n"); break;}
     anz=sscanf(zeile,"%d %d %d",&z[0],&z[1],&z[2]);
     if(anz!=3) {printf("Fehler: zu wenige Zahlen gefunden: zeile='%s'\n",zeile); break;}
     for(i=0;i<3;i++)
      {
       hauptfeld[i+k*3+j*18].farb=z[i];
      }
    }
  }
 else if(isupper(zeile[0]) && isupper(zeile[1]))
  {
   /*
Beispiel:
UF UR RD RB LU LF DB DL FR UB DF BL UFR RFD RDB RBU LFU LUB DLB LDF
Erklaerung:
UF UR RD RB = obere 4 Kanten im Gegenuhrzeigersinn, zuerst obere Flaeche
LU LF DB DL = untere 4 Kanten im Uhrzeigersinn, zuerst untere Flaeche
FR UB = vordere Kanten rechts und links, zuerst vordere Flaeche 
DF BL = hintere Kanten rechts und links, zuerst hintere Flaeche
UFR = Ecke oben rechts, Flaechen in Gegenuhrzeigersinn mit Oberer beginnend
RFD RDB RBU = obere Ecken im Gegenuhrz., jeweils mit Oberer Flaeche beginnend
LFU LUB DLB LDF = untere Ecken, unten rechts beginnend, Gegenuhrz.

A solved cube is represented as
UF UR UB UL DF DR DB DL FR FL BR BL UFR URB UBL ULF DRF DFL DLB DBR

unser Nummern-Schema:
   D         F         U         B         L         R
36 37 38  39 40 41  42 43 44  45 46 47  48 49 50  51 52 53
18 19 20  21 22 23  24 25 26  27 28 29  30 31 32  33 34 35
0  1  2   3  4  5   6  7  8   9  10 11  12 13 14  15 16 17
   */
   char *s;
   int uf[12*2]={7,40, 26,33, 43,10, 24,32, 37,4, 20,16, 1,46, 18,13, 23,33, 21,32, 29,35, 27,30};
   int ufr[8*3]={8,41,51, 44,53,11, 42,9,48, 6,50,39, 38,15,5, 36,3,14, 0,12,45, 2,47,17};
   stellung_reset();
   printf("Singmaster-Notation\n");//test
   for(s=zeile,i=0;*s!=0;i++)
    {
     while(isspace(*s)) s++;//Leerstellen ueberlesen
     if(*s==0) break;
     k=buchstabe_nach_zahl(*s++);
     if(i<12*2) j=uf[i]; else j=ufr[i-12*2];
     hauptfeld[j].farb=k;
    }
  }
 else //sonst vermutlich Maneuver-Notation
  {
   char *s;
   int c,n;
   stellung_reset();
   printf("Maneuver-Notation\n");//test
   for(s=zeile;;)
    {
     while(isblank(*s)) s++; //Leerstellen ueberlesen
     if(*s==0) break;
     c = *s++;
     if(*s=='\'') {n=3; s++;}
     else if(*s=='2') {n=2; s++;}
     else n=1;
     drehung(hauptfeld,c,n);
    }
  }
 fclose(fp);
}

void dateispeichern(char *name)
{
 int i,j;
 uint8 k;
 FILE *fp=fopen(name,"w");
 if(fp==NULL) janeinrequester("Konnte Datei nicht oeffnen."); //provi.
 else
  {
   for(k=0;k<6;k++) //entspricht: D F U B L R  odr Farbnummer 0 bis 5
    {
     fprintf(fp,"%c:\n",seitenbuchstabe[k]);
     for(j=0;j<3;j++)
      {
       for(i=0;i<3;i++)
	{
	 fprintf(fp,"%2d",hauptfeld[i+k*3+j*18].farb);
	 if(i==2) fprintf(fp,"\n");
	}
      }
    }
   fclose(fp);
  }
}

void hauptfeld_init()
{
 //int i,j,k,typ;
 int i,j;
 uint8 k;
 for(j=0;j<3;j++)
 for(i=0;i<3;i++)
 for(k=0;k<6;k++) //entspricht: D F U B L R  odr Farbnummer 0 bis 5
  {
   /*
   if(i==1 && j==1) typ=MITTE;
   else if(i==1 || j==1) typ=KANTE;
   else typ=ECKE;
   hauptfeld[i+k*3+j*18].init(k,typ);
   */
   hauptfeld[i+k*3+j*18].init(k);
  }
 for(i=0;i<6*9;i++) grundstellung[i]=hauptfeld[i];
}

void stellung_reset()
{
 for(int i=0;i<6*9;i++) hauptfeld[i]=grundstellung[i];
}

//void ecken_und_kanten_drehen(Rub *feld,Rub *h,int k) //k wegoptimiert
void ecken_und_kanten_drehen(Rub *feld,Rub *h)
{
 //int m=k*3; //wegoptimiert
 //h[m]=feld[m+2]; h[m+36]=feld[m]; h[m+38]=feld[m+36]; h[m+2]=feld[m+38]; //Ecken drehen
 //h[m+1]=feld[m+20]; h[m+18]=feld[m+1]; h[m+37]=feld[m+18]; h[m+20]=feld[m+37]; //Kanten drehen
 h[0]=feld[2]; h[36]=feld[0]; h[38]=feld[36]; h[2]=feld[38]; //Ecken drehen
 h[1]=feld[20]; h[18]=feld[1]; h[37]=feld[18]; h[20]=feld[37]; //Kanten drehen
}

void angrenz_drehen(Rub *feld,Rub *h,int von,int vstep,int nach,int nstep)
{
 /*
 for(int i=0;i<3;i++)
  {
   h[nach] = feld[von];
   von += vstep;
   nach += nstep;
  }
 */
 h[nach] = feld[von];
 h[nach+=nstep] = feld[von+=vstep];
 h[nach+=nstep] = feld[von+=vstep];
}

/* Nummern-Schema:
   D         F         U         B         L         R
36 37 38  39 40 41  42 43 44  45 46 47  48 49 50  51 52 53
18 19 20  21 22 23  24 25 26  27 28 29  30 31 32  33 34 35
0  1  2   3  4  5   6  7  8   9  10 11  12 13 14  15 16 17
 */

void ecken_und_kanten_drehen2(Rub *feld,Rub *h)
{
 h[0]=feld[38]; h[36]=feld[2]; h[38]=feld[0]; h[2]=feld[36]; //Ecken drehen
 h[1]=feld[37]; h[18]=feld[20]; h[37]=feld[1]; h[20]=feld[18]; //Kanten drehen
}

void ecken_und_kanten_drehen3(Rub *feld,Rub *h)
{
 h[0]=feld[36]; h[36]=feld[38]; h[38]=feld[2]; h[2]=feld[0]; //Ecken drehen
 h[1]=feld[18]; h[18]=feld[37]; h[37]=feld[20]; h[20]=feld[1]; //Kanten drehen
}

void angrenz_drehen2(Rub *feld,Rub *h,int von,int vstep,int nach,int nstep)
{
 h[nach] = feld[von];
 h[von]  = feld[nach];
 h[nach+=nstep] = feld[von+=vstep];
 h[von]  = feld[nach];
 h[nach+=nstep] = feld[von+=vstep];
 h[von]  = feld[nach];
}

void drehung(Rub* feld,char c,int n)
{
 Rub h[6*9];
 //int i,k;
 int i;
 //printf("drehung(Rub* feld,%c,%d)\n",c,n);//test
 for(i=0;i<6*9;i++) h[i]=feld[i];
 //for(;n>0;--n)
 if(n==1)
  {
   switch(c)
    {
     case 'D':
      /*
       h[0]=feld[2]; h[36]=feld[0]; h[38]=feld[36]; h[2]=feld[38]; //Ecken drehen
       h[1]=feld[20]; h[18]=feld[1]; h[37]=feld[18]; h[20]=feld[37]; //Kanten drehen
       for(i=45,k=14;i<=47;i++,k--) h[k]=feld[i]; //Angrenzende Felder schieben
       for(i=12,k=3;i<=14;i++,k++) h[k]=feld[i]; //Angrenzende Felder schieben
       for(i=3,k=15;i<=5;i++,k++) h[k]=feld[i]; //Angrenzende Felder schieben
       for(i=15,k=47;i<=17;i++,k--) h[k]=feld[i]; //Angrenzende Felder schieben
      */
       ecken_und_kanten_drehen(feld,h);
       angrenz_drehen(feld,h, 45,1,  14,-1);
       angrenz_drehen(feld,h, 12,1,   3, 1);
       angrenz_drehen(feld,h,  3,1,  15, 1);
       angrenz_drehen(feld,h, 15,1,  47,-1);
       break;
     case 'F':
       //ecken_und_kanten_drehen(feld,h,1); //k wegoptimiert
       ecken_und_kanten_drehen(&feld[1*3],&h[1*3]);
       angrenz_drehen(feld,h,  6,1,  51,-18);
       angrenz_drehen(feld,h, 15,18, 36,1);
       angrenz_drehen(feld,h, 36,1,  50,-18);
       angrenz_drehen(feld,h, 14,18,  6,1);
       break;
     case 'U':
       ecken_und_kanten_drehen(&feld[2*3],&h[2*3]);
       angrenz_drehen(feld,h,  9,1,  53,-1);
       angrenz_drehen(feld,h, 51,1,  39,1);
       angrenz_drehen(feld,h, 39,1,  48,1);
       angrenz_drehen(feld,h, 48,1,  11,-1);
       break;
     case 'B':
       ecken_und_kanten_drehen(&feld[3*3],&h[3*3]);
       angrenz_drehen(feld,h, 42,1,  12,18);
       angrenz_drehen(feld,h, 12,18,  2,-1);
       angrenz_drehen(feld,h,  0,1,  17,18);
       angrenz_drehen(feld,h, 17,18, 44,-1);
       break;
     case 'L':
       ecken_und_kanten_drehen(&feld[4*3],&h[4*3]);
       angrenz_drehen(feld,h,  9,18,  6,18);
       angrenz_drehen(feld,h,  6,18,  3,18);
       angrenz_drehen(feld,h,  3,18,  0,18);
       angrenz_drehen(feld,h,  0,18,  9,18);
       break;
     case 'R':
       ecken_und_kanten_drehen(&feld[5*3],&h[5*3]);
       angrenz_drehen(feld,h, 11,18,  2,18);
       angrenz_drehen(feld,h,  2,18,  5,18);
       angrenz_drehen(feld,h,  5,18,  8,18);
       angrenz_drehen(feld,h,  8,18, 11,18);
       break;
    }
   for(i=0;i<6*9;i++) feld[i]=h[i];
  }
 else if(n==2)
  {
   switch(c)
    {
     case 'D':
       ecken_und_kanten_drehen2(feld,h);
       angrenz_drehen2(feld,h, 45,1,  5,-1);
       angrenz_drehen2(feld,h, 12,1, 15, 1);
       break;
     case 'F':
       ecken_und_kanten_drehen2(&feld[1*3],&h[1*3]);
       angrenz_drehen2(feld,h, 36,1,   8,-1);
       angrenz_drehen2(feld,h, 14,18, 51,-18);
       break;
     case 'U':
       ecken_und_kanten_drehen2(&feld[2*3],&h[2*3]);
       angrenz_drehen2(feld,h, 39,1,  11,-1);
       angrenz_drehen2(feld,h, 48,1,  51,1);
       break;
     case 'B':
       ecken_und_kanten_drehen2(&feld[3*3],&h[3*3]);
       angrenz_drehen2(feld,h, 42,1,  2,-1);
       angrenz_drehen2(feld,h, 12,18, 53,-18);
       break;
     case 'L':
       ecken_und_kanten_drehen2(&feld[4*3],&h[4*3]);
       angrenz_drehen2(feld,h,  3,18,  9,18);
       angrenz_drehen2(feld,h,  0,18,  6,18);
       break;
     case 'R':
       ecken_und_kanten_drehen2(&feld[5*3],&h[5*3]);
       angrenz_drehen2(feld,h, 5,18, 11,18);
       angrenz_drehen2(feld,h, 2,18,  8,18);
       break;
    }
   for(i=0;i<6*9;i++) feld[i]=h[i];
  }
 else //if(n==3)
  {
/* Nummern-Schema:
   D         F         U         B         L         R
36 37 38  39 40 41  42 43 44  45 46 47  48 49 50  51 52 53
18 19 20  21 22 23  24 25 26  27 28 29  30 31 32  33 34 35
0  1  2   3  4  5   6  7  8   9  10 11  12 13 14  15 16 17
 */
   switch(c)
    {
     case 'D':
       ecken_und_kanten_drehen3(feld,h);
       angrenz_drehen(feld,h, 14,-1, 45,1);
       angrenz_drehen(feld,h,  3, 1, 12,1);
       angrenz_drehen(feld,h, 15, 1,  3,1);
       angrenz_drehen(feld,h, 47,-1, 15,1);
       break;
     case 'F':
       ecken_und_kanten_drehen3(&feld[1*3],&h[1*3]);
       angrenz_drehen(feld,h, 51,-18,  6,1);
       angrenz_drehen(feld,h, 36,1,  15,18);
       angrenz_drehen(feld,h, 50,-18, 36,1);
       angrenz_drehen(feld,h,  6,1,  14,18);
       break;
     case 'U':
       ecken_und_kanten_drehen3(&feld[2*3],&h[2*3]);
       angrenz_drehen(feld,h, 53,-1,  9,1);
       angrenz_drehen(feld,h, 39,1,  51,1);
       angrenz_drehen(feld,h, 48,1,  39,1);
       angrenz_drehen(feld,h, 11,-1, 48,1);
       break;
     case 'B':
       ecken_und_kanten_drehen3(&feld[3*3],&h[3*3]);
       angrenz_drehen(feld,h, 12,18, 42,1);
       angrenz_drehen(feld,h,  2,-1, 12,18);
       angrenz_drehen(feld,h, 17,18,  0,1);
       angrenz_drehen(feld,h, 44,-1, 17,18);
       break;
     case 'L':
       ecken_und_kanten_drehen3(&feld[4*3],&h[4*3]);
       angrenz_drehen(feld,h, 6,18,  9,18);
       angrenz_drehen(feld,h, 3,18,  6,18);
       angrenz_drehen(feld,h, 0,18,  3,18);
       angrenz_drehen(feld,h, 9,18,  0,18);
       break;
     case 'R':
       ecken_und_kanten_drehen3(&feld[5*3],&h[5*3]);
       angrenz_drehen(feld,h, 2,18, 11,18);
       angrenz_drehen(feld,h, 5,18,  2,18);
       angrenz_drehen(feld,h, 8,18,  5,18);
       angrenz_drehen(feld,h, 11,18, 8,18);
       break;
    }
   for(i=0;i<6*9;i++) feld[i]=h[i];
  }
}

/********************* weitere Vordeklarationen ***********************/
int bestmov(Rub *feld,int suchtiefe,int *pwert);
int bewertung(Rub *feld);
int zufallszug(Rub *feld);

/************************* Menu Behandlung ****************************/
void menu_exit() {exitflag=1;}

void m_refresh()
{
 inital_new();
#ifdef SCHWARZAUFWEISS
 if(TIEFE==24)  {screenclear(0x7F7F7F); rgbcolor(0x00,0x00,0x00);}
 else           {screenclear(1); color(0);}
#else
 if(TIEFE==24)  {screenclear(0); rgbcolor(0xFF,0xFF,0xFF);}
 else           {screenclear(0); color(1);}
#endif
 wuerfel_zeichnen();
 abwicklung_zeichnen(abw_x0,abw_y0);
 term_refresh();
}

void m_abwicklung()
{
 //int ok=
 requester_input(1,"Abwicklungs-Variante (1 oder 2)","%d","%d",&abwickvariante);
 m_refresh();
}

void m_load()
{
 int ok;
 static char name[200]="test.rubik",filter[80]="*.rubik";
 ok=nachfilenamefragen("Lade Wuerfeldatei",name,200,0,filter);
 if(ok) dateiladen(name);
 m_refresh();
}

void m_save()
{
 int ok;
 static char name[200]="test.rubik",filter[80]="*.rubik";
 ok=nachfilenamefragen("Speichere Wuerfeldatei",name,200,0,filter);
 if(ok) dateispeichern(name);
 m_refresh();
}

void pause()
{
 for(int i=0;i<25;i++) waitBOF();
}

void m_solve()
{
 int i,m,wert,n=0;
 int startflag=1;
 int test=6; //fuer Testausdrucke von Suchtiefe
 static int suchtiefe=20;
 //int ok=requester_input(1,"maximale Suchtiefe","%d","%d",&suchtiefe);
 //if(!ok) {m_refresh(); return;}
 wert=bewertung(hauptfeld);
 for(i=1;i<=suchtiefe && wert!=0;i++)
  {
   if(i>test) {printf("Momentane Suchtiefe: %d\n",i); test=i;}//test
   m=bestmov(hauptfeld,i,&wert);
   drehung(hauptfeld,m&0xFF,m>>8); m_refresh(); //Drehung machen
   pause();
   if(wert==0)
    {
     wert=bewertung(hauptfeld); n++;
     if(startflag) {printf("Loesung: "); startflag=0; if(fpziel!=NULL) fprintf(fpziel,"Loesung: ");}
     zugdrucken(m&0xFF,m>>8,' ');
     if(fpziel!=NULL) zugdruckenfp(fpziel,m&0xFF,m>>8,' ');
     if(i>2) i-=2;
    }
   else {drehung(hauptfeld,m&0xFF,4-(m>>8)); m_refresh();} //Drehung zuruecknehmen
  }
 char str[200];
 if(wert==0)
  {
   printf("\n");
   if(fpziel!=NULL)
    {
     fprintf(fpziel,"\n");
     if(argflag['A']) {m_refresh(); return;}
    }
   sprintf(str,"\nWuefel mit %d Drehungen geloest.\n",n);
  }
 else sprintf(str,"Automatisches Loesen mit %d Suchtiefe nicht geklappt.",suchtiefe);
 printf("%s",str);
 janeinrequester(str);
 m_refresh();
}

static int tut_i=2,tut_status=0;

void tut_zufallszuege()
{
 int j,m,mvorher=0;
 for(j=0;j<tut_i;j++)
  {
   do {m=zufallszug(hauptfeld);}
   while((m&0xFF)==(mvorher&0xFF));
   drehung(hauptfeld,m&0xFF,m>>8); m_refresh(); //Drehung machen
   pause();
  }
 printf("Es wurden %d zufaellige Drehungen gemacht.\n",tut_i);
 printf("Versuchen Sie es wieder zurueckzudrehen.\n");
}

void m_tutspiel()
{
 int ok;
 ok=requester_input(1,"Anzahl Zufallszuege beim Start (0=stoppen)","%d","%d",&tut_i);
 if(ok)
  {
   if(tut_i==0) {tut_status=0; m_refresh(); return;}
   tut_zufallszuege();
   tut_status=1;
  }
 m_refresh();
}

void m_bestmov()
{
 int ok,c,n,m,wert;
 static int suchtiefe=3;
 ok=requester_input(1,"Suchtiefe","%d","%d",&suchtiefe);
 if(ok)
  {
   m=bestmov(hauptfeld,suchtiefe,&wert);
   c=m&0xFF;
   n=m>>8;
   drehung(hauptfeld,c,n);
   if(wert==0) printf("loesbar in %d oder weniger Zuegen\nErster Zug: ",suchtiefe);
   else printf("vermutlich bester Zug: ");
   zugdrucken(m&0xFF,m>>8,'\n');
  }
 m_refresh();
}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 quellname[0]=zielname[0]=0;
 int i,j,c;
 int breite,hoehe,tiefe,visklasse;
 if(argc<=0)
   j=0;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("rubik  %s\n",VERSION);
	 printf("Anwendung: rubik [-flags] [Quelle] [Ziel]\n");
	 printf("  flags: a=automatisch loesen\n");
	 exit(0);
	}
 hauptfeld_init();
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 if(breite*4 > hoehe*5) breite=hoehe*5/4;
 setsize(breite,hoehe,tiefe);
 setmenu(4,"File",   "Edit",  "Spiel",  "Analyse");
 setmenu(4,"Load...","Darstellung der Abwicklung...","Tutorial-Spiel","Bester Zug suchen...",
	 &m_load,&m_abwicklung,&m_tutspiel,&m_bestmov);
 setmenu(2,"Save...","Automatisch loesen",&m_save,&m_solve);
 setmenu(2,"Exit",   "Refresh",&menu_exit,&m_refresh);
 set_funktions(pre,rel,verd,mot);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */

#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0x7F7F7F); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif

 wuerfel_zeichnen();
 abwicklung_zeichnen(abw_x0=500,abw_y0=30);
 term_refresh();

 if(j==2)
  {
   if((fpziel=fopen(zielname,"r"))!=NULL)
    {printf("Zieldatei '%s' schon vorhanden. Nicht gespeichert.\n",zielname); fclose(fpziel); fpziel=NULL;}
   else if((fpziel=fopen(zielname,"w"))==NULL)
    {printf("Kann Zieldatei '%s' nicht oeffnen.\n",zielname);}
   else
    {
     printf("Zieldatei '%s' geoeffnet.\n",zielname);
    }
  }
 if(j>=1)
  {
   dateiladen(quellname);
   m_refresh();
  }
 if(j==2 && fpziel!=NULL && argflag['A'])
  {
   m_solve();
   term_exit();
   fclose(fpziel);
   return 0;
  }

 while(exitflag==0 && waitmenu(0)==0) // auf Benutzereingaben warten
  {
   waitBOF();
   if(tut_status!=0)
    {
     int wert=bewertung(hauptfeld);
     if(wert==0)
      {
       printf("Bravo %d Drehungen geloest.\n",tut_i);
       for(int i=0;i<200;i++) waitBOF(); //kurze Pause
       tut_i++;
       tut_zufallszuege();
      }
    }
  }

 term_exit();
 if(fpziel!=NULL) fclose(fpziel);
 return 0;
}/* ende von main */

void lin(double x0,double y0,double x1,double y1)
{
 plot(x0,y0,PENUP); plot(x1,y1,PENDOWN);
}

void linie(double x0,double y0,double x1,double y1,double x2,double y2)
{
 plot(x0,y0,PENUP); plot(x1,y1,PENDOWN); plot(x2,y2,PENDOWN);
}

void filldrawbox(double x1,double y1,double x2,double y2)
{
 fillbox(x1,y1,x2,y2);
#if(TIEFE==24)
 rgbcolor(0x00,0x00,0x00); // Schwarz fuer Linien
#else
 color(0);
#endif
 drawbox(x1,y1,x2,y2);
}

void mytrapez(double x1,double y1)
{
 double x,y,x2,y2,y3;
 x2=x1+zf*kante;
 for(x=x1,y=y1; x<x2; x+=1,y+=1)
  {
   lin(x,y, x,y+kante);
  }
#if(TIEFE==24)
 rgbcolor(0,0,0); //schwarz
#else
 color(0);
#endif
 y2=y1+kante;
 y3=y2+zf*kante;
 linie(x1,y1, x1,y2, x2,y3);
 linie(x1,y1, x2,y1+zf*kante, x2,y3);
}

void mytrapezy(double x1,double y1)
{
 double x,y,x2,y2,x3;
 y2=y1+zf*kante;
 for(x=x1,y=y1; y<y2; x+=1,y+=1)
  {
   lin(x,y, x+kante,y);
  }
#if(TIEFE==24)
 rgbcolor(0,0,0); //schwarz
#else
 color(0);
#endif
 x2=x1+kante;
 x3=x2+zf*kante;
 linie(x1,y1, x2,y1, x3,y2);
 linie(x1,y1, x1+zf*kante,y2, x3,y2);
}

 /* Test: nur Grundstellung zeichnen
void wuerfel_zeichnen()
{
 int i,j;
 double x0=per_x0, y0=per_y0;
 double x,y,zkante,zk3,s;
 zkante=kante*zf;
 zk3=zkante*3;
 s=kante*3; //Seitenlaenge des grossen Wuerfels
 for(j=0;j<3;j++)
 for(i=0;i<3;i++)
  {
   rgbcolor(0xFF,0xFF,0xFF); // Weiss
   filldrawbox(x0+i*kante,y0+j*kante,x0+(i+1)*kante,y0+(j+1)*kante);
  }
 for(j=0;j<3;j++)
 for(i=0;i<3;i++)
  {
   rgbcolor(0x3F,0x3F,0xFF); // Hell-Blau
   mytrapez(x0+s+i*kante*zf,y0+j*kante+i*kante*zf);
  }
 for(j=0;j<3;j++)
 for(i=0;i<3;i++)
  {
   rgbcolor(0xFF,0x7F,0x3F); // Orange
   mytrapezy(x0+i*kante+j*kante*zf,y0+s+j*kante*zf);
  }
 drawbox(x0,y0,x0+s,y0+s); // ein Quadrat zeichnen
 for(i=0,x=x0,y=y0; i<=3; x+=kante,y+=kante,i++)
  {
   linie(x,y0, x,y0+s, x+zk3,y0+s+zk3);
   linie(x0,y, x0+s,y, x0+s+zk3,y+zk3);
  }
 for(i=1;i<=3;i++)
  {
   linie(x0+i*zkante,   y0+s+i*zkante,
	 x0+i*zkante+s, y0+s+i*zkante,
	 x0+i*zkante+s, y0+i*zkante);
  }
}
*/

void wuerfel_zeichnen()
{
 int i,j;
 double x,y,z,s;

 //Umrisse des grossen Wuerfels zeichnen:
 s=kante*3; //Seitenlaenge des grossen Wurfels
 d3_drawbox(0,0,0, s,s,0); //vorderes Quadrat
 d3_drawbox(s,0,0, s,s,s); //rechtes Quadrat
 d3_drawbox(0,s,0, s,s,s); //oberes Quadrat

 for(j=0; j<3; j++)
 for(i=0; i<3; i++)
   {
    x=i*kante; y=j*kante; //Vorderes Quadrat zeichnen
    hauptfeld[3+i+j*18].zeichnen3d(x,y,0);
    y=j*kante; z=i*kante; //Rechtes Quadrat zeichnen
    hauptfeld[5*3+i+j*18].zeichnen3d(s,y,z);
    z=j*kante; x=i*kante; //Oberes Quadrat zeichnen
    hauptfeld[2*3+i+j*18].zeichnen3d(x,s,z);
   }
}

void abwicklung_zeichnen(double x0,double y0)
{
 double s=3*kante;
 double x,y;
 /* Test: nur Grundstellung zeichnen
 rgbcolor(0x00,0xFF,0x00); // Gruen
 filldrawbox(x0,y0+s, x0+s,y0+2*s); // Left
 rgbcolor(0xC0,0x00,0x00); // Rot
 filldrawbox(x0+s,y0, x0+2*s,y0+s); // Down
 rgbcolor(0xFF,0xFF,0xFF); // Weiss
 filldrawbox(x0+s,y0+s, x0+2*s,y0+2*s); // Front
 rgbcolor(0x00,0x00,0xFF); // Blau
 filldrawbox(x0+2*s,y0+s, x0+3*s,y0+2*s); // Right
 rgbcolor(0xFF,0x7F,0x1F); // Orange
 filldrawbox(x0+s,y0+2*s, x0+2*s,y0+3*s); // Up
 rgbcolor(0xFF,0xFF,0x00); // Gelb
 filldrawbox(x0+s,y0+3*s, x0+2*s,y0+4*s); // Back
 */
 int i,j,k;
 if(abwickvariante==2)
  { //Abwicklung mit Upper in der Mitte des Kreuzes
   for(j=0;j<3;j++)
   for(i=0;i<3;i++)
   for(k=0;k<6;k++) //entspricht: D F U B L R
    {
     if(k<4)
      {
       x=x0+s; y=y0+s*k;
       x += i*kante;
       y += j*kante;
       hauptfeld[i+k*3+j*18].zeichnen(x,y);
      }
     else if(k==4) // L
      {
       x=x0; y=y0+s*3;
       x += j*kante;
       y -= (i+1)*kante;
       hauptfeld[i+k*3+j*18].zeichnen(x,y);
      }
     else //if(k==5) // R
      {
       x=x0+s*3; y=y0+s*2;
       x -= (j+1)*kante;
       y += i*kante;
       hauptfeld[i+k*3+j*18].zeichnen(x,y);
      }
    }
   for(i=0,x=x0+s;i<4;i++) //Umrandung der 4 grossen Vierecke uebereinander
    {
     y=y0+s*i;
     drawbox(x+1,y+1,x+s-1,y+s-1);
    }
   for(i=0,y=y0+s*2;i<3;i+=2) //Umrandung der beiden grossen Vierecke L u. R
    {
     x=x0+s*i;
     drawbox(x+1,y+1,x+s-1,y+s-1);
    }
  }
 else //Abwicklung mit Front in der Mitte des Kreuzes
 {
 for(j=0;j<3;j++)
 for(i=0;i<3;i++)
 for(k=0;k<6;k++) //entspricht: D F U B L R
  {
   if(k<4) {x=x0+s;             y=y0+s*k;}
   else    {x=(k==4)?x0:x0+s*2; y=y0+s;}
   x += i*kante;
   y += j*kante;
   hauptfeld[i+k*3+j*18].zeichnen(x,y);
  }
 for(i=0,x=x0+s;i<4;i++)
  {
   y=y0+s*i;
   drawbox(x+1,y+1,x+s-1,y+s-1);
  }
 for(i=0,y=y0+s;i<3;i+=2)
  {
   x=x0+s*i;
   drawbox(x+1,y+1,x+s-1,y+s-1);
  }
 }
}

void neuzeichnen()
{
 inital_new();
 wuerfel_zeichnen();
 abwicklung_zeichnen(abw_x0,abw_y0);
 term_refresh();
}

void pre()  //wird beim Druecken einer Maustaste aufgerufen (press mouse)
{
 double x,y,x1,x2,y1,y2,y3;
 char c;
 int n;
 n=mausposition(&x,&y);
 if(n&LIMAUS) n=3; //mit Linker Taste nach Links drehen
 else if(n&REMAUS) n=1; //mit rechter Taste nach rechts
 else n=2; //oder mit mittlerer Taste 2 mal nach rechts
 //printf("pre() x=%f y=%f n=%d\n",x,y,n);//test
 if(x<abw_x0 || y<abw_y0) return; //Klicks ausserhalbe der Abwicklung ignorieren
 double s=3*kante;
 if(x>abw_x0+s*3 || y>abw_y0+s*4) return; //Klicks ausserhalbe der Abwicklung ignorieren
 x1=abw_x0+s;
 x2=x1+s;
 y1=abw_y0+s;
 y2=y1+s;
 y3=y2+s;
 if(abwickvariante==2)
  {
   if(x>=x1 && x<=x2)
    {
     if(y<y1) c='D';
     else if(y>y3) c='B';
     else if(y>y2) c='U';
     else c='F';
    }
   else if(y>y3 || y<y2) return;
   else if(x<x1) c='L';
   else c='R';
  }
 else
  {
   if(y<y1 && x>x1 && x<x2) c='D';
   else if(y>y2 && x>x1 && x<x2) c=(y>y3)?'B':'U';
   else if(y>y2 || y<y1) return;
   else if(x<x1) c='L';
   else if(x<x2) c='F';
   else c='R';
  }
 zugdrucken(c,n,'\n');
 drehung(hauptfeld,c,n);
 neuzeichnen();
}

void rel()  //wird beim Loslassen einer Maustaste aufgerufen (release mouse)
{
}
void verd()  //wird z.B. nach Verdeckung des Fensters aufgerufen
{
}
void mot()  //wird beim Bewegen des Mauszeigers aufgerufen (motion of mouse)
{
}

/***************************** 3D-Grafik ******************************/

void projekt(double x,double y,double z,double *xs,double *ys) // Projektion von xyz-Punkten in die xy-Ebene
{
 double A=1500; // Abstand vom Beobachter zum Bildschirm (ev. noch anpassen)
 double vfakt=A/(A+z); // Verkuerzungsfaktor durch Beobachtungsabstand
 double vfakt2=A/(A+z/2); // Verkuerzung von Strecken in z-Richtung
 //double zfx=sqrt(0.5)*cos(alfa); // Perspektivische Verkuerzung in z-Richtung (mit alfa=45 Grad immer 0.5)
 //double zfy=sqrt(0.5)*sin(alfa); // Perspektivische Verkuerzung in z-Richtung (mit alfa=45 Grad immer 0.5)
 const double zfx=0.5, zfy=0.5;
 *xs = per_x0 + x*vfakt + zfx*vfakt2*z;
 *ys = per_y0 + y*vfakt + zfy*vfakt2*z;
}

void d3_drawbox(double x1,double y1,double z1,double x2,double y2,double z2)
{
 double xa,ya,xb,yb,xc,yc,xd,yd; // fuer 4 Eckpunkte
 projekt(x1,y1,z1, &xa,&ya); //Eckpunkt unten links
 projekt(x2,y2,z2, &xb,&yb); //Eckpunkt oben rechts
 if(z1==z2)
  {
   xc=xb; yc=ya; //Eckpunkt unten rechts
   xd=xa; yd=yb; //Eckpunkt oben links
  }
 else if(x1==x2)
  {
   projekt(x1,y1,z2, &xc,&yc); //Eckpunkt unten rechts
   projekt(x1,y2,z1, &xd,&yd); //Eckpunkt oben links
  }
 else if(y1==y2)
  {
   projekt(x2,y1,z1, &xc,&yc); //Eckpunkt unten rechts
   projekt(x1,y1,z2, &xd,&yd); //Eckpunkt oben links
  }
 else
  {
   printf("Fehler in d3_drawbox: Viereck liegt nicht in einer Koordinatenebene:\n");
   printf("  x1=%f y1=%f z1=%f  x2=%f y2=%f z2=%f\n",x1,y1,z1,x2,y2,z2);
   return;
  }
 plot(xa,ya,PENUP); plot(xc,yc,PENDOWN); plot(xb,yb,PENDOWN);
 plot(xd,yd,PENDOWN); plot(xa,ya,PENDOWN);
}

void d3filldrawbox(double x1,double y1,double z1,double x2,double y2,double z2)
{
 //printf("d3filldrawbox(%f,%f,%f, %f,%f,%f)\n",x1,y1,z1,x2,y2,z2);//test
 double xa,ya,xb,yb,xc,yc,xd,yd; // fuer 4 Eckpunkte
 projekt(x1,y1,z1, &xa,&ya); //Eckpunkt unten links
 projekt(x2,y2,z2, &xb,&yb); //Eckpunkt oben rechts
 if(z1==z2)
  {
   for(;ya<yb;ya+=1) lin(xa,ya, xb,ya);
  }
 else if(x1==x2)
  {
   projekt(x1,y1,z2, &xc,&yc); //Eckpunkt unten rechts
   projekt(x1,y2,z1, &xd,&yd); //Eckpunkt oben links
   double d=(yb-yc)/(yd-ya);
   for(;ya<yd;ya+=1,yc+=d) lin(xa,ya, xc,yc);
  }
 else if(y1==y2)
  {
   projekt(x2,y1,z1, &xc,&yc); //Eckpunkt unten rechts
   projekt(x1,y1,z2, &xd,&yd); //Eckpunkt oben links
   double d=(xb-xd)/(xc-xa);
   for(;xa<xc;xa+=1,xd+=d) lin(xa,ya, xd,yd);
  }
 else
  {
   printf("Fehler in d3filldrawbox: Viereck liegt nicht in einer Koordinatenebene:\n");
   printf("  x1=%f y1=%f z1=%f  x2=%f y2=%f z2=%f\n",x1,y1,z1,x2,y2,z2);
   return;
  }

#if(TIEFE==24)
 rgbcolor(0,0,0); //schwarz
#else
 color(0);
#endif
 d3_drawbox(x1,y1,z1, x2,y2,z2);
}

/******************* Unterprogramme fuer Analyse **********************/
/*
 Darstellung eines Zuges in einem int:
   unterste 8 Bits: c=m&0xFF  'D','F','U','B','L', oder 'R'
   9.-10. Bit: n=c>>8  1=rechts, 2=zwei mal, 3=links

 Bewertung der Stellung:
   0=geloester Wuerfel
   hoeherer Wert ist staerker gemischelt

*/
static int moegliche_zuege[18]=
 {'D'+0x100,'F'+0x100,'U'+0x100,'B'+0x100,'L'+0x100,'R'+0x100, //Drehungen nach rechts
  'D'+0x200,'F'+0x200,'U'+0x200,'B'+0x200,'L'+0x200,'R'+0x200, //nach links
  'D'+0x300,'F'+0x300,'U'+0x300,'B'+0x300,'L'+0x300,'R'+0x300  //um 180 Grad drehen
 };

int bewertung(Rub *feld)
{
 int i,wert=0;
 for(i=0;i<6*9;i++)
  if(feld[i]!=grundstellung[i]) wert++;
 return wert;
}

class Spielfeld
{
 Rub feld[6*9];
public:
 Spielfeld(Rub *f) {for(int i=0;i<6*9;i++) feld[i]=f[i];}
 void zug(int m);    //entsprechende Drehung machen
 void invzug(int m); //Inverse Drehung, also zurueckdrehen
 int bewert(); //Bewertung der Stellung, 0=geloest, 1=1 Feld differenz,...
};

int Spielfeld::bewert()
{
 int wert=0;
 for(int i=0;i<6*9;i++)
   if(feld[i].farb!=grundstellung[i].farb) wert++;
 return wert;
}

void Spielfeld::zug(int m)
{
 int n=m>>8;
 drehung(feld,m&0xFF,n);
}

void Spielfeld::invzug(int m)
{
 int n=4-(m>>8);
 drehung(feld,m&0xFF,n);
}

bool gegenueberliegend(uint8 v1,uint8 v2)
{
 //Optimiert durch Tabelle mit gegenueberliegenden Seiten:
 //                     {'B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U'};
 static uint8 tabelle[]={'F','C','U','E','B','G','H','I','J','K','R','M','N','O','P','Q','L','S','T','D'};
 return tabelle[v1-'B']==v2;
}

int bestmov(Spielfeld& feld,int suchtiefe,int *pwert,uint8 vorher,uint8 vorher2)
   //Rueckgabe ist bester Zug, pwert ist Bewertung nach allen Zuegen
   //vorher ist die Seite des letzten Zugs (fuer Optimierungen)
   //vorher2 ist die Seite des vorletzten Zugs
{
 int j,m,bestm=0,wert;
 uint8 v,v2;
 *pwert=feld.bewert();
 for(j=0;j<18 && *pwert!=0;j++)
    {
     m=moegliche_zuege[j];
     if((v=m&0xFF)==vorher) continue; //nochmals gleiche Seite wie gerade zuvor macht keinen Sinn
     if(v==vorher2) continue; //gleiche Seite wie 2 Zuege zuvor wenn es gegenueberliegende Seite war
     feld.zug(m);
     wert=feld.bewert();
     if(wert < *pwert || bestm==0) {*pwert=wert; bestm=m;}
     feld.invzug(m);
    }
 if(*pwert==0) return bestm;//mit 1 Zug geloest
 if(suchtiefe<=1) return bestm;
 for(j=0;j<18 && *pwert!=0;j++)
    {
     m=moegliche_zuege[j];
     if((v=m&0xFF)==vorher) continue; //nochmals gleiche Seite wie gerade zuvor macht keinen Sinn
     if(v==vorher2) continue; //gleiche Seite wie 2 Zuege zuvor wenn es gegenueberliegende Seite war
     feld.zug(m);
     v2 = gegenueberliegend(v,vorher) ? vorher : 0;
     bestmov(feld,suchtiefe-1,&wert,v,v2);
     if(wert < *pwert) {*pwert=wert; bestm=m;}
     feld.invzug(m);
    }
 return bestm;
}

int bestmov(Rub *feld,int suchtiefe,int *pwert)
{
 int m;
 Spielfeld sp(feld);
 m=bestmov(sp,suchtiefe,pwert,0,0);
 //printf("bestmov() --> ");//test
 //zugdrucken(m&0xFF,m>>8,'\n');//test
 return m;
}

int zufallszug(Rub *feld)
{
 int j,m;
 j=int(zufall()*18.0);
 if(j==18) j=17;
 m=moegliche_zuege[j];
 return m;
}
