/* rubik.cc			letzte Aenderung: 16.5.2015 */
#define VERSION "Version 0.4"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Suche von einfacheren Loesungen fuer den Rubik-Cube

History:
18.4.2015       Erstellung (RP)
1.5.2015   0.1  einigermassen funktionierend
           0.2  Versuch weiterer Optimierungen in drehung()
	   0.3  Bessere Representation des Wuerfels fuer Analyse
14.5.15	   0.4  Verwendung mehrerer Prozessorkerne (Threads)

*/
#define MITTHREADS

#ifdef MITTHREADS
#include <thread>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <stdint.h>

#include <xtekplot1.h>

#define XMAX 1280
#define YMAX 1024
//#define TIEFE 24
#define TIEFE 8

#define SCHWARZAUFWEISS //auskommentieren fuer weiss auf schwarz

/************************* Vordeklarationen ***************************/
typedef unsigned char uint8;
void wuerfel_zeichnen();
void abwicklung_zeichnen(double x0,double y0);
void filldrawbox(double x1,double y1,double x2,double y2);
void pre();
void rel();
void verd();
void mot();
void d3_drawbox(double x1,double y1,double z1,double x2,double y2,double z2);
void d3filldrawbox(double x1,double y1,double z1,double x2,double y2,double z2);
void neuzeichnen();
void stellung_reset();

/************************ Globale Variablen ***************************/
static int exitflag=0;
static double xmin=0,ymin=0,xmax=1280,ymax=1024;
static double kante=80; //Kantenlaenge eines kleinen Wuerfels
const double zf=0.5; //Verkurzung in z-Richtung bei perspektivischer Zeichnung
static double abw_x0=500,abw_y0=30; //Position der Abwicklung
static double per_x0=50,per_y0=50; //Nullpunkt der perspektivischen Darstellung
static int abwickvariante=2;
static FILE *fpziel=NULL;
#ifdef MITTHREADS
static volatile int geloestflag=0; //wird gesetzt wenn einer der Threads eine Loesung gefunden hat
#endif
static int thread1flag=0; //bei argflag['A']: wenn gesetzt dann nur mit einzelnem Thread loesen

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while((c= *s++)!=0)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   if(c=='A' && *s=='1') thread1flag=1;
   argflag[c&127]=1;
  }
}

/*************************** kleinkram ***************************/
const char* fuehrende_leerzeichen_loeschen(char *str)
{
 char *v,*z;
 for(v=str;*v==' ';) v++;
 for(z=str;*v!=0;) *z++ = *v++;
 *z=0;
 return str;
}

bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/** Zufallszahlen **/
double zufall4()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

#include <time.h>
double zufall5(int start=0)
{
 static int flag=1;
 if(flag!=0 || start!=0)
  {time_t t;
   time(&t);
   srand(t);
   flag=0;
  }
 return (1.0 - rand()/(double)RAND_MAX);
}

// Eins von beiden auskommentieren:
inline double zufall() {return zufall4();}
//inline double zufall() {return zufall5();}

void zugdrucken(int c,int n,int nl)
{
 if(n==1) printf("%c",c);
 else if(n==2) printf("%c2",c);
 else printf("%c'",c);
 if(nl!=0) fputc(nl,stdout);
}

void zugdruckenfp(FILE *fp,int c,int n,int nl)
{
 if(n==1) fprintf(fp,"%c",c);
 else if(n==2) fprintf(fp,"%c2",c);
 else fprintf(fp,"%c'",c);
 if(nl!=0) fputc(nl,fp);
}

#if(TIEFE==24)
inline void myrgbcolor(int r,int g,int b) {rgbcolor(r,g,b);}
#else
void myrgbcolor(int r,int g,int b)
{
 setcolor(2,r,g,b);
 color(2);
}
#endif

/******************* Klassen fuer Hauptprogramm ***********************/
class Farbe
{
public:
 int r,g,b;
};

static Farbe farben[6] =
 {
  {0xC0, 0x00, 0x00}, // rot
  {0xFF, 0xFF, 0xFF}, // weiss
  {0xFF, 0x7F, 0x30}, // orange
  {0xFF, 0xFF, 0x00}, // gelb
  {0x00, 0xFF, 0x00}, // gruen
  {0x00, 0x00, 0xFF} // blau
 };

/* moegliche Typen:
#define MITTE 0
#define KANTE 1
#define ECKE  2
*/

class Rub  //kleines Farbiges Quadrat
{
 //int typ; //typ wird nicht wirklich gebraucht
public:
 uint8 farb; //Farbnummer (0 bis 5)
 //void init(int f,int t) {farb=f; typ=t;}
 void init(uint8 f) {farb=f;}
 void zeichnen(double x1,double y1);
 void zeichnen3d(double x1,double y1,double z1);
 bool operator!=(Rub& v) {return (farb!=v.farb);}
};

void Rub::zeichnen(double x1,double y1) //in der Abwicklung zeichnen
{
 myrgbcolor(farben[farb].r,farben[farb].g,farben[farb].b);
 filldrawbox(x1,y1,x1+kante,y1+kante);
}

void Rub::zeichnen3d(double x1,double y1,double z1) //in der Perspektivischen Darstellung zeichnen
{
 double v=2.5*kante;
 myrgbcolor(farben[farb].r,farben[farb].g,farben[farb].b);
 //printf("Rub::zeichnen3d(%f,%f,%f)\n",x1,y1,z1);//test
 if(x1<v && y1<v)
  {
   filldrawbox(per_x0+x1,per_y0+y1,per_x0+x1+kante,per_x0+y1+kante); //Vorderes Quadrat in der Ebene zeichnen
  }
 else if(x1<v)
  {
   d3filldrawbox(x1,y1,z1, x1+kante,y1,z1+kante); //Oberes Quadrat perspektivisch zeichnen
  }
 else
  {
   d3filldrawbox(x1,y1,z1, x1,y1+kante,z1+kante); //Rechtes Quadrat perspektivisch zeichnen
  }
}

static Rub hauptfeld[6*9];
static Rub grundstellung[6*9];

static char seitenbuchstabe[6]={'D','F','U','B','L','R'};

int buchstabe_nach_zahl(char c)
{
 int k;
 for(k=6;seitenbuchstabe[--k]!=c && k!=0;) ;
 return k;
}

void drehung(Rub* feld,char c,int n);

void dateiladen(char *name)
{
 FILE *fp=fopen(name,"r");
 char zeile[200];
 int i,j,k,anz,z[3];
 printf("dateiladen(%s)\n",name);
 if(fpziel!=NULL) fprintf(fpziel,"dateiladen(%s)\n",name);
 if(fp==NULL) {janeinrequester("Datei nicht gefunden."); return;}
 if(!getline(fp,zeile,200)) {printf("Fehler: leere Datei.\n"); fclose(fp); return;}
 if(strncmp(zeile,"D:",2)==0) //eigenes Dateiformat
  for(k=0;k<6;k++)
  {
   if(k!=0)
    {
     if(!getline(fp,zeile,80)) {printf("viel zu wenige Zeilen in Datei.\n"); break;}
     if(zeile[1]!=':' || zeile[0]!=seitenbuchstabe[k])
      {printf("Fehler in Dateiformat: '%s'\n",zeile); break;}
    }
   for(j=0;j<3;j++)
    {
     if(!getline(fp,zeile,80)) {printf("zu wenige Zeilen in Datei.\n"); break;}
     anz=sscanf(zeile,"%d %d %d",&z[0],&z[1],&z[2]);
     if(anz!=3) {printf("Fehler: zu wenige Zahlen gefunden: zeile='%s'\n",zeile); break;}
     for(i=0;i<3;i++)
      {
       hauptfeld[i+k*3+j*18].farb=z[i];
      }
    }
  }
 else if(isupper(zeile[0]) && isupper(zeile[1]))
  {
   /*
Beispiel:
UF UR RD RB LU LF DB DL FR UB DF BL UFR RFD RDB RBU LFU LUB DLB LDF
Erklaerung:
UF UR RD RB = obere 4 Kanten im Gegenuhrzeigersinn, zuerst obere Flaeche
LU LF DB DL = untere 4 Kanten im Uhrzeigersinn, zuerst untere Flaeche
FR UB = vordere Kanten rechts und links, zuerst vordere Flaeche 
DF BL = hintere Kanten rechts und links, zuerst hintere Flaeche
UFR = Ecke oben rechts, Flaechen in Gegenuhrzeigersinn mit Oberer beginnend
RFD RDB RBU = obere Ecken im Gegenuhrz., jeweils mit Oberer Flaeche beginnend
LFU LUB DLB LDF = untere Ecken, unten rechts beginnend, Gegenuhrz.

A solved cube is represented as
UF UR UB UL DF DR DB DL FR FL BR BL UFR URB UBL ULF DRF DFL DLB DBR

unser Nummern-Schema:
   D         F         U         B         L         R
36 37 38  39 40 41  42 43 44  45 46 47  48 49 50  51 52 53
18 19 20  21 22 23  24 25 26  27 28 29  30 31 32  33 34 35
0  1  2   3  4  5   6  7  8   9  10 11  12 13 14  15 16 17
   */
   char *s;
   int uf[12*2]={7,40, 26,33, 43,10, 24,32, 37,4, 20,16, 1,46, 18,13, 23,33, 21,32, 29,35, 27,30};
   int ufr[8*3]={8,41,51, 44,53,11, 42,9,48, 6,50,39, 38,15,5, 36,3,14, 0,12,45, 2,47,17};
   stellung_reset();
   printf("Singmaster-Notation\n");//test
   for(s=zeile,i=0;*s!=0;i++)
    {
     while(isspace(*s)) s++;//Leerstellen ueberlesen
     if(*s==0) break;
     k=buchstabe_nach_zahl(*s++);
     if(i<12*2) j=uf[i]; else j=ufr[i-12*2];
     hauptfeld[j].farb=k;
    }
  }
 else //sonst vermutlich Maneuver-Notation
  {
   char *s;
   int c,n;
   stellung_reset();
   printf("Maneuver-Notation\n");//test
   for(s=zeile;;)
    {
     while(isblank(*s)) s++; //Leerstellen ueberlesen
     if(*s==0) break;
     c = *s++;
     if(*s=='\'') {n=3; s++;}
     else if(*s=='2') {n=2; s++;}
     else n=1;
     drehung(hauptfeld,c,n);
    }
  }
 fclose(fp);
}

void dateispeichern(char *name)
{
 int i,j;
 uint8 k;
 FILE *fp=fopen(name,"w");
 if(fp==NULL) {char str[200]; sprintf(str,"Konnte Datei \"%s\" nicht oeffnen.",name); janeinrequester(str);}
 else
  {
   for(k=0;k<6;k++) //entspricht: D F U B L R  odr Farbnummer 0 bis 5
    {
     fprintf(fp,"%c:\n",seitenbuchstabe[k]);
     for(j=0;j<3;j++)
      {
       for(i=0;i<3;i++)
	{
	 fprintf(fp,"%2d",hauptfeld[i+k*3+j*18].farb);
	 if(i==2) fprintf(fp,"\n");
	}
      }
    }
   fclose(fp);
  }
}

void hauptfeld_init()
{
 int i,j;
 uint8 k;
 for(j=0;j<3;j++)
 for(i=0;i<3;i++)
 for(k=0;k<6;k++) //entspricht: D F U B L R  odr Farbnummer 0 bis 5
  {
   hauptfeld[i+k*3+j*18].init(k);
  }
 for(i=0;i<6*9;i++) grundstellung[i]=hauptfeld[i];
}

void stellung_reset()
{
 for(int i=0;i<6*9;i++) hauptfeld[i]=grundstellung[i];
}

void ecken_und_kanten_drehen(Rub *feld,Rub *h)
{
 h[0]=feld[2]; h[36]=feld[0]; h[38]=feld[36]; h[2]=feld[38]; //Ecken drehen
 h[1]=feld[20]; h[18]=feld[1]; h[37]=feld[18]; h[20]=feld[37]; //Kanten drehen
}

void angrenz_drehen(Rub *feld,Rub *h,int von,int vstep,int nach,int nstep)
{
 h[nach] = feld[von];
 h[nach+=nstep] = feld[von+=vstep];
 h[nach+=nstep] = feld[von+=vstep];
}

/* Nummern-Schema:
   D         F         U         B         L         R
36 37 38  39 40 41  42 43 44  45 46 47  48 49 50  51 52 53
18 19 20  21 22 23  24 25 26  27 28 29  30 31 32  33 34 35
0  1  2   3  4  5   6  7  8   9  10 11  12 13 14  15 16 17
 */

void ecken_und_kanten_drehen2(Rub *feld,Rub *h)
{
 h[0]=feld[38]; h[36]=feld[2]; h[38]=feld[0]; h[2]=feld[36]; //Ecken drehen
 h[1]=feld[37]; h[18]=feld[20]; h[37]=feld[1]; h[20]=feld[18]; //Kanten drehen
}

void ecken_und_kanten_drehen3(Rub *feld,Rub *h)
{
 h[0]=feld[36]; h[36]=feld[38]; h[38]=feld[2]; h[2]=feld[0]; //Ecken drehen
 h[1]=feld[18]; h[18]=feld[37]; h[37]=feld[20]; h[20]=feld[1]; //Kanten drehen
}

void angrenz_drehen2(Rub *feld,Rub *h,int von,int vstep,int nach,int nstep)
{
 h[nach] = feld[von];
 h[von]  = feld[nach];
 h[nach+=nstep] = feld[von+=vstep];
 h[von]  = feld[nach];
 h[nach+=nstep] = feld[von+=vstep];
 h[von]  = feld[nach];
}

void drehung(Rub* feld,char c,int n)
{
 Rub h[6*9];
 int i;
 //printf("drehung(Rub* feld,%c,%d)\n",c,n);//test
 for(i=0;i<6*9;i++) h[i]=feld[i];
 if(n==1)
  {
   switch(c)
    {
     case 'D':
       ecken_und_kanten_drehen(feld,h);
       angrenz_drehen(feld,h, 45,1,  14,-1);
       angrenz_drehen(feld,h, 12,1,   3, 1);
       angrenz_drehen(feld,h,  3,1,  15, 1);
       angrenz_drehen(feld,h, 15,1,  47,-1);
       break;
     case 'F':
       ecken_und_kanten_drehen(&feld[1*3],&h[1*3]);
       angrenz_drehen(feld,h,  6,1,  51,-18);
       angrenz_drehen(feld,h, 15,18, 36,1);
       angrenz_drehen(feld,h, 36,1,  50,-18);
       angrenz_drehen(feld,h, 14,18,  6,1);
       break;
     case 'U':
       ecken_und_kanten_drehen(&feld[2*3],&h[2*3]);
       angrenz_drehen(feld,h,  9,1,  53,-1);
       angrenz_drehen(feld,h, 51,1,  39,1);
       angrenz_drehen(feld,h, 39,1,  48,1);
       angrenz_drehen(feld,h, 48,1,  11,-1);
       break;
     case 'B':
       ecken_und_kanten_drehen(&feld[3*3],&h[3*3]);
       angrenz_drehen(feld,h, 42,1,  12,18);
       angrenz_drehen(feld,h, 12,18,  2,-1);
       angrenz_drehen(feld,h,  0,1,  17,18);
       angrenz_drehen(feld,h, 17,18, 44,-1);
       break;
     case 'L':
       ecken_und_kanten_drehen(&feld[4*3],&h[4*3]);
       angrenz_drehen(feld,h,  9,18,  6,18);
       angrenz_drehen(feld,h,  6,18,  3,18);
       angrenz_drehen(feld,h,  3,18,  0,18);
       angrenz_drehen(feld,h,  0,18,  9,18);
       break;
     case 'R':
       ecken_und_kanten_drehen(&feld[5*3],&h[5*3]);
       angrenz_drehen(feld,h, 11,18,  2,18);
       angrenz_drehen(feld,h,  2,18,  5,18);
       angrenz_drehen(feld,h,  5,18,  8,18);
       angrenz_drehen(feld,h,  8,18, 11,18);
       break;
    }
   for(i=0;i<6*9;i++) feld[i]=h[i];
  }
 else if(n==2)
  {
   switch(c)
    {
     case 'D':
       ecken_und_kanten_drehen2(feld,h);
       angrenz_drehen2(feld,h, 45,1,  5,-1);
       angrenz_drehen2(feld,h, 12,1, 15, 1);
       break;
     case 'F':
       ecken_und_kanten_drehen2(&feld[1*3],&h[1*3]);
       angrenz_drehen2(feld,h, 36,1,   8,-1);
       angrenz_drehen2(feld,h, 14,18, 51,-18);
       break;
     case 'U':
       ecken_und_kanten_drehen2(&feld[2*3],&h[2*3]);
       angrenz_drehen2(feld,h, 39,1,  11,-1);
       angrenz_drehen2(feld,h, 48,1,  51,1);
       break;
     case 'B':
       ecken_und_kanten_drehen2(&feld[3*3],&h[3*3]);
       angrenz_drehen2(feld,h, 42,1,  2,-1);
       angrenz_drehen2(feld,h, 12,18, 53,-18);
       break;
     case 'L':
       ecken_und_kanten_drehen2(&feld[4*3],&h[4*3]);
       angrenz_drehen2(feld,h,  3,18,  9,18);
       angrenz_drehen2(feld,h,  0,18,  6,18);
       break;
     case 'R':
       ecken_und_kanten_drehen2(&feld[5*3],&h[5*3]);
       angrenz_drehen2(feld,h, 5,18, 11,18);
       angrenz_drehen2(feld,h, 2,18,  8,18);
       break;
    }
   for(i=0;i<6*9;i++) feld[i]=h[i];
  }
 else //if(n==3)
  {
/* Nummern-Schema:
   D         F         U         B         L         R
36 37 38  39 40 41  42 43 44  45 46 47  48 49 50  51 52 53
18 19 20  21 22 23  24 25 26  27 28 29  30 31 32  33 34 35
0  1  2   3  4  5   6  7  8   9  10 11  12 13 14  15 16 17
 */
   switch(c)
    {
     case 'D':
       ecken_und_kanten_drehen3(feld,h);
       angrenz_drehen(feld,h, 14,-1, 45,1);
       angrenz_drehen(feld,h,  3, 1, 12,1);
       angrenz_drehen(feld,h, 15, 1,  3,1);
       angrenz_drehen(feld,h, 47,-1, 15,1);
       break;
     case 'F':
       ecken_und_kanten_drehen3(&feld[1*3],&h[1*3]);
       angrenz_drehen(feld,h, 51,-18,  6,1);
       angrenz_drehen(feld,h, 36,1,  15,18);
       angrenz_drehen(feld,h, 50,-18, 36,1);
       angrenz_drehen(feld,h,  6,1,  14,18);
       break;
     case 'U':
       ecken_und_kanten_drehen3(&feld[2*3],&h[2*3]);
       angrenz_drehen(feld,h, 53,-1,  9,1);
       angrenz_drehen(feld,h, 39,1,  51,1);
       angrenz_drehen(feld,h, 48,1,  39,1);
       angrenz_drehen(feld,h, 11,-1, 48,1);
       break;
     case 'B':
       ecken_und_kanten_drehen3(&feld[3*3],&h[3*3]);
       angrenz_drehen(feld,h, 12,18, 42,1);
       angrenz_drehen(feld,h,  2,-1, 12,18);
       angrenz_drehen(feld,h, 17,18,  0,1);
       angrenz_drehen(feld,h, 44,-1, 17,18);
       break;
     case 'L':
       ecken_und_kanten_drehen3(&feld[4*3],&h[4*3]);
       angrenz_drehen(feld,h, 6,18,  9,18);
       angrenz_drehen(feld,h, 3,18,  6,18);
       angrenz_drehen(feld,h, 0,18,  3,18);
       angrenz_drehen(feld,h, 9,18,  0,18);
       break;
     case 'R':
       ecken_und_kanten_drehen3(&feld[5*3],&h[5*3]);
       angrenz_drehen(feld,h, 2,18, 11,18);
       angrenz_drehen(feld,h, 5,18,  2,18);
       angrenz_drehen(feld,h, 8,18,  5,18);
       angrenz_drehen(feld,h, 11,18, 8,18);
       break;
    }
   for(i=0;i<6*9;i++) feld[i]=h[i];
  }
}

/*
Bessere Representation des Wuerfels:
 8 Ecken mit je 3 Orientierungsmoeglichkeiten, 3+2=5 Bits
 12 Kanten mit je 2 Orientierungsmoeglichkeiten, 4+1=5 Bits
 es werden also mindestens (8+12)*5 Bits = 100 Bits = 13 Bytes gebraucht

Singmaster notation der Grundstellung:
    UF UR UB UL DF DR DB DL FR FL BR BL UFR URB UBL ULF DRF DFL DLB DBR
Nr: 0  1  2  3  4  5  6  7  8  11  9 10  0   1   2   3   4   5   6   7
(seltsame Nummerierung von FR bis BL ist so damit Rotation des Gesamtwuerfels schneller ist)
In dieser Stellung sind alle Orientierungen == 0
Andere Kantenorientierungen sind 1,
andere Eckenorientierungen: 1 (fuer rechts) oder 2 (fuer links gedreht)

Nummerierung der Ecken und Kanten in der Abwicklung:
        +---------+
        | 6  6  7 |
Back    | 10    9 |
        |         |
+-------+---------+-------+
|6  10  | 2  2  1 |  9  7 |
|7  L   | 3     1 |  R  5 |  Left  Up  Right
|5  11  | 3  0  0 |  8  4 |
+-------+---------+-------+
        |         |
  Front | 11    8 |
        |         |
        +---------+
        | 5  4  4 |
  Down  | 7     5 |
        | 6  6  7 |
        +---------+

Speichern in 32-Bit Registern:

      Ecke 3     Ecke 2     Ecke 1     Ecke 0
r0: 000Q QPPP  000Q QPPP  000Q QPPP  000Q QPPP  (Q=Orientierung, P=Position)

      Ecke 7     Ecke 6     Ecke 5     Ecke 4
r1: 000Q QPPP  000Q QPPP  000Q QPPP  000Q QPPP  (Q=Orientierung, P=Position)

      Kante 3    Kante 2    Kante 1    Kante 0
r2: 000Q PPPP  000Q PPPP  000Q PPPP  000Q PPPP  (Q=Orientierung, P=Position)

      Kante 7    Kante 6    Kante 5    Kante 4
r3: 000Q PPPP  000Q PPPP  000Q PPPP  000Q PPPP  (Q=Orientierung, P=Position)

     Kante 11   Kante 10    Kante 9    Kante 8
r4: 000Q PPPP  000Q PPPP  000Q PPPP  000Q PPPP  (Q=Orientierung, P=Position)
*/

#define uint32 uint32_t
const int D=0,F=1,U=2,B=3,L=4,R=5;

class Wuerfel
{
 uint32 r0,r1,r2,r3,r4;
public:
 char *deep_s; //Zeiger in Loesung fuer deepsearch
 Wuerfel(uint32 a,uint32 b,uint32 c,uint32 d,uint32 e) {r0=a; r1=b; r2=c; r3=d; r4=e;}
 Wuerfel() {r0=r1=r2=r3=r4=0;}
 void init(Rub *feld);
 void orinorm(); //Orientierungen der Ecken normieren
 bool operator==(Wuerfel& v) {orinorm(); return (r0==v.r0 && r1==v.r1 && r2==v.r2 && r3==v.r3 && r4==v.r4);}
 void deepsearch_init(char *s,int len);
 bool deepsearch(int t,int vorher= -1,int vorher2= -1);
 bool orisearch(int t,int vorher= -1,int vorher2= -1);
 bool ecksearch(int t,int vorher= -1,int vorher2= -1);
 bool twosearch(int t,int vorher= -1,int vorher2= -1);
 void drehenz();
 void drehenz2();
 void drehenz3();
 void drehenU();
 void drehenD();
 void drehenF();
 void drehenB();
 void drehenL();
 void drehenR();
 void drehenF2();
 void drehenB2();
 void drehenL2();
 void drehenR2();
 void print() {printf("r0=0x%08X\nr1=0x%08X\nr2=0x%08X\nr3=0x%08X\nr4=0x%08X\n",r0,r1,r2,r3,r4);}//test
 bool origeloest()
  {const uint32 m1=0xF8F8F8F8,m2=0xF0F0F0F0;
   orinorm();
   return ((r0&m1)==0 && (r1&m1)==0 && (r2&m2)==0 && (r3&m2)==0 && (r4&m2)==0);
  }
 bool eckengeloest() {orinorm(); return (r0==0x03020100 && r1==0x07060504);}
 bool geloest()
  {orinorm(); return (r0==0x03020100 && r1==0x07060504 && r2==0x03020100 && r3==0x07060504 && r4==0x0B0A0908);}
};

static Wuerfel geloesterwuerfel(0x03020100, 0x07060504, 0x03020100, 0x07060504, 0x0B0A0908);

uint8_t kant(Rub *r,int c1,int c2)
{
 int a=r[c1].farb;
 int b=r[c2].farb;
 if(a==U)
  {
   switch(b)
    {case F: return 0;
     case R: return 1;
     case B: return 2;
     case L: return 3;
    }
  }
 else if(a==D)
  {
   switch(b)
    {case F: return 4;
     case R: return 5;
     case B: return 6;
     case L: return 7;
    }
  }
 else if(a==F)
  {
   switch(b)
    {case U: return 0x10;
     case D: return 0x14;
     case L: return 11;
     case R: return 8;
    }
  }
 else if(a==B)
  {
   switch(b)
    {case U: return 0x12;
     case D: return 0x16;
     case L: return 10;
     case R: return 9;
    }
  }
 else if(a==L)
  {
   switch(b)
    {case U: return 0x13;
     case D: return 0x17;
     case F: return 0x1B;
     case B: return 0x1A;
    }
  }
 else if(a==R)
  {
   switch(b)
    {case U: return 0x11;
     case D: return 0x15;
     case F: return 0x18;
     case B: return 0x19;
    }
  }
 fprintf(stderr,"Fehler in kant() a=%d b=%d\n",a,b);
 return 0;//Fehler
}

int eck(Rub *r,int c1,int c2,int c3)
{
 int a=r[c1].farb;
 int b=r[c2].farb;
 int c=r[c3].farb;
 if(a==U)
  {
   if(b==F && c==R) return 0;
   if(b==R && c==B) return 1;
   if(b==B && c==L) return 2;
   if(b==L && c==F) return 3;
  }
 else if(a==D)
  {
   if(b==R && c==F) return 4;
   if(b==F && c==L) return 5;
   if(b==L && c==B) return 6;
   if(b==B && c==R) return 7;
  }
 else if(b==U)
  {
   if(c==F && a==R) return 0+(2<<3);
   if(c==R && a==B) return 1+(2<<3);
   if(c==B && a==L) return 2+(2<<3);
   if(c==L && a==F) return 3+(2<<3);
  }
 else if(b==D)
  {
   if(c==R && a==F) return 4+(2<<3);
   if(c==F && a==L) return 5+(2<<3);
   if(c==L && a==B) return 6+(2<<3);
   if(c==B && a==R) return 7+(2<<3);
  }
 else if(c==U)
  {
   if(a==F && b==R) return 0+(1<<3);
   if(a==R && b==B) return 1+(1<<3);
   if(a==B && b==L) return 2+(1<<3);
   if(a==L && b==F) return 3+(1<<3);
  }
 else if(c==D)
  {
   if(a==R && b==F) return 4+(1<<3);
   if(a==F && b==L) return 5+(1<<3);
   if(a==L && b==B) return 6+(1<<3);
   if(a==B && b==R) return 7+(1<<3);
  }
 fprintf(stderr,"Fehler in eck() a=%d b=%d c=%d\n",a,b,c);
 return 0;//Fehler
}

void Wuerfel::init(Rub *feld)
{
 /*
A solved cube is represented as
UF UR UB UL DF DR DB DL FR FL BR BL UFR URB UBL ULF DRF DFL DLB DBR

unser Nummern-Schema:
   D         F         U         B         L         R
36 37 38  39 40 41  42 43 44  45 46 47  48 49 50  51 52 53
18 19 20  21 22 23  24 25 26  27 28 29  30 31 32  33 34 35
0  1  2   3  4  5   6  7  8   9  10 11  12 13 14  15 16 17
   */
 r2 = kant(feld,7,40) + (kant(feld,26,52)<<8) + (kant(feld,43,10)<<16) + (kant(feld,24,49)<<24); //UF UR UB UL
 r3 = kant(feld,37,4) + (kant(feld,20,16)<<8) + (kant(feld,1,46)<<16) + (kant(feld,18,13)<<24); //DF DR DB DL
 r4 = kant(feld,23,33) + (kant(feld,29,35)<<8) + (kant(feld,27,30)<<16) + (kant(feld,21,32)<<24); //FR BR BL FL (andere Reihenfolge als Singmaster!)
 //In Singmaster ist es FR FL BR BL
 //hier die Reihenfolge FR BR BL FL um den Gesamtwuerfel einfacher (schneller) zu drehen
 r0 = eck(feld,8,41,51) + (eck(feld,44,53,11)<<8) +  (eck(feld,42,9,48)<<16) +  (eck(feld,6,50,39)<<24); //UFR URB UBL ULF
 r1 = eck(feld,38,15,5) + (eck(feld,36,3,14)<<8) +  (eck(feld,0,12,45)<<16) +  (eck(feld,2,47,17)<<24); //DRF DFL DLB DBR
}

void Wuerfel::drehenz()
{
 r0 = (r0>>8) + (r0<<24); //in Arm-Assembler ist das ein einziger Befehl (ror)
 r1 = (r1<<8) + (r1>>24); //in andern Assemblern moeglicherweise auch nur 1 Befehl pro Zeile
 r2 = (r2>>8) + (r2<<24);
 r3 = (r3>>8) + (r3<<24);
 r4 = (r4>>8) + (r4<<24);
 r4 ^= 0x10101010; //Orientierungen der mittleren Kanten aendern (in Arm-Assembler mehr als 1 Befehl)
}

void Wuerfel::drehenz2()
{
 r0 = (r0>>16) + (r0<<16); //in Arm-Assembler ist das ein einziger Befehl (ror)
 r1 = (r1>>16) + (r1<<16);
 r2 = (r2>>16) + (r2<<16);
 r3 = (r3>>16) + (r3<<16);
 r4 = (r4>>16) + (r4<<16);
}

void Wuerfel::drehenz3()
{
 r0 = (r0>>24) + (r0<<8); //in Arm-Assembler ist das ein einziger Befehl (ror)
 r1 = (r1<<24) + (r1>>8);
 r2 = (r2>>24) + (r2<<8);
 r3 = (r3>>24) + (r3<<8);
 r4 = (r4>>24) + (r4<<8);
 r4 ^= 0x10101010; //Orientierungen der mittleren Kanten aendern
}

void Wuerfel::drehenU()
{
 r0 = (r0>>8) + (r0<<24); //in Arm-Assembler ist das ein einziger Befehl (ror)
 r2 = (r2>>8) + (r2<<24);
}

void Wuerfel::drehenD()
{
 r1 = (r1>>8) + (r1<<24); //in Arm-Assembler ist das ein einziger Befehl (ror)
 r3 = (r3>>24) + (r3<<8);
}

inline uint8_t orino(uint8_t h) //zu grosse Q-Werte verkleinern
{
 //Variante 1: //ist am schnellsten (mit test9 ueberprueft)
 while(h>=0x18) h-=0x18; //in 3er Schritten korrigieren
 return h;

 //Variante 2:
 /*
 uint8_t q;
 q=(h>>3); //Orientierung
 q %= 3; //Orientierung kann nur 0, 1 oder 2 sein.
 h=(h&7)+(q<<3);
 return h;
 */
 //Variante 3:
 //return (h % 0x18);
}

void Wuerfel::orinorm() //Orientierungen der Ecken normieren
{
 uint8_t h;
 if((h=r0&0xFF) >= 0x18) //Q von Ecke0 zu gross?
  {
   r0 = (r0&0xFFFFFF00) | orino(h);
  }
 if((h=(r0>>8)&0xFF) >= 0x18) //Q von Ecke1 zu gross?
  {
   r0 = (r0&0xFFFF00FF) | (orino(h)<<8);
  }
 if((h=(r0>>16)&0xFF) >= 0x18) //Q von Ecke2 zu gross?
  {
   h=orino(h);
   r0 = (r0&0xFF00FFFF) | (h<<16);
  }
if((h=(r0>>24)&0xFF) >= 0x18) //Q von Ecke3 zu gross?
  {
   h=orino(h);
   r0 = (r0&0x00FFFFFF) | (h<<24);
  }
 if((h=r1&0xFF) >= 0x18) //Q von Ecke4 zu gross?
  {
   r1 = (r1&0xFFFFFF00) | orino(h);
  }
 if((h=(r1>>8)&0xFF) >= 0x18) //Q von Ecke5 zu gross?
  {
   h=orino(h);
   r1 = (r1&0xFFFF00FF) | (h<<8);
  }
 if((h=(r1>>16)&0xFF) >= 0x18) //Q von Ecke6 zu gross?
  {
   h=orino(h);
   r1 = (r1&0xFF00FFFF) | (h<<16);
  }
 if((h=(r1>>24)&0xFF) >= 0x18) //Q von Ecke7 zu gross?
  {
   h=orino(h);
   r1 = (r1&0x00FFFFFF) | (h<<24);
  }
}

void Wuerfel::drehenF()
{
 uint32 h=r0;
 r0 = (r0&0xFFFF00) | (r0>>24) | ((r1&0xFF00)<<16); //Ecke3-->Ecke0, Ecke5-->Ecke3
 r0 += 0x08; //Orientierung neue Ecke0 aendern
 if((r0&0xF8000000)==0) r0 += 0x10000000; else r0 -= 0x08000000; //Orientierung neue Ecke3 aendern
 r1 = (r1&0xFFFF0000) | (h&0xFF) | ((r1&0xFF)<<8); //Ecke0-->Ecke4, Ecke4-->Ecke5
 if((r1&0xF8)==0) r1 += 0x10; else r1 -= 0x08; //Orientierung neue Ecke4 aendern
 r1 += 0x0800; //Orientierung neue Ecke5 aendern
 h=r2;
 r2 = (r2&0xFFFFFF00) | (r4>>24); //Kante11-->Kante0
 r4 = (r4&0x00FFFFFF) | (r3<<24); //Kante4-->Kante11
 r3 = (r3&0xFFFFFF00) | (r4&0xFF); //Kante8-->Kante4
 r4 = (r4&0xFFFFFF00) | (h&0xFF); //Kante0-->Kante8
 r2 ^= 0x10; //Orientierung Kante0 aendern
 r3 ^= 0x10; //Orientierung Kante4 aendern
 r4 ^= 0x10000010; //Orientierung Kante8 und Kante11 aendern
}

void Wuerfel::drehenB()
{
 uint32 h=r0;
 r0 = (r0&0xFF0000FF) | ((r0&0xFF00)<<8) | ((r1>>16)&0xFF00); //Ecke1-->Ecke2, Ecke7-->Ecke1
 r0 += 0x080000; //Orientierung neue Ecke2 aendern
 if((r0&0xF800)==0) r0 += 0x1000; else r0 -= 0x0800; //Orientierung neue Ecke1 aendern
 r1 = (r1&0x0000FFFF) | ((r1&0xFF0000)<<8) | (h&0xFF0000); //Ecke6-->Ecke7, Ecke2-->Ecke6
 if((r1&0xF80000)==0) r1 += 0x100000; else r1 -= 0x080000; //Orientierung neue Ecke6 aendern
 r1 += 0x08000000; //Orientierung neue Ecke7 aendern
 h=r2;
 r2 = (r2&0xFF00FFFF) | ((r4&0xFF00)<<8); //Kante9-->Kante2
 r4 = (r4&0xFFFF00FF) | ((r3>>8)&0xFF00); //Kante6-->Kante9
 r3 = (r3&0xFF00FFFF) | (r4&0xFF0000); //Kante10-->Kante6
 r4 = (r4&0xFF00FFFF) | (h&0xFF0000); //Kante2-->Kante10
 r2 ^= 0x100000; //Orientierung Kante2 aendern
 r3 ^= 0x100000; //Orientierung Kante6 aendern
 r4 ^= 0x101000; //Orientierung Kante9 und Kante10 aendern
}

void Wuerfel::drehenR()
{
 uint32 h=r0;
 r0 = (r0&0xFFFF0000) | ((r0&0xFF)<<8) | (r1&0xFF); //Ecke0-->Ecke1, Ecke4-->Ecke0
 if((r0&0xF8)==0) r0 += 0x10; else r0 -= 0x08; //Orientierung neue Ecke0 aendern
 r0 += 0x0800; //Orientierung neue Ecke1 aendern
 r1 = (r1&0x00FFFF00) | (r1>>24) | ((h&0xFF00)<<16); //Ecke7-->Ecke4, Ecke1-->Ecke7
 r1 += 0x08; //Orientierung neue Ecke4 aendern
 if((r1&0xF8000000)==0) r1 += 0x10000000; else r1 -= 0x08000000; //Orientierung neue Ecke7 aendern
 h=r2;
 r2 = (r2&0xFFFF00FF) | ((r4&0xFF)<<8); //Kante8-->Kante1
 r4 = (r4&0xFFFFFF00) | ((r3>>8)&0xFF); //Kante5-->Kante8
 r3 = (r3&0xFFFF00FF) | (r4&0xFF00); //Kante9-->Kante5
 r4 = (r4&0xFFFF00FF) | (h&0xFF00); //alte Kante1-->Kante9
 //Orientierungen der Kanten bleiben unveraendert
}

void Wuerfel::drehenL()
{
 uint32 h=r0;
 r0 = (r0&0x0000FFFF) | ((r0&0xFF0000)<<8) | (r1&0xFF0000); //Ecke2-->Ecke3, Ecke6-->Ecke2
 if((r0&0xF80000)==0) r0 += 0x100000; else r0 -= 0x080000; //Orientierung neue Ecke2 aendern
 r0 += 0x08000000; //Orientierung neue Ecke3 aendern
 r1 = (r1&0xFF0000FF) | ((r1&0xFF00)<<8) | ((h>>16)&0xFF00); //Ecke5-->Ecke6, Ecke3-->Ecke5
 r1 += 0x080000; //Orientierung neue Ecke6 aendern
 if((r1&0xF800)==0) r1 += 0x1000; else r1 -= 0x0800; //Orientierung neue Ecke5 aendern
 h=r2;
 r2 = (r2&0x00FFFFFF) | ((r4&0xFF0000)<<8); //Kante10-->Kante3
 r4 = (r4&0xFF00FFFF) | ((r3>>8)&0xFF0000); //Kante7-->Kante10
 r3 = (r3&0x00FFFFFF) | (r4&0xFF000000); //Kante11-->Kante7
 r4 = (r4&0x00FFFFFF) | (h&0xFF000000); //alte Kante3-->Kante11
 //Orientierungen der Kanten bleiben unveraendert
}

void Wuerfel::drehenF2()
{
 uint32 h=r0;
 r0 = (r0&0x00FFFF00) | ((r1>>8)&0xFF) | (r1<<24); //Ecke5-->Ecke0, Ecke4-->Ecke3
 r1 = (r1&0xFFFF0000) | ((h&0xFF)<<8)  | (h>>24); //Ecke0-->Ecke5, Ecke3-->Ecke4
 h=r2;
 r2 = (r2&0xFFFFFF00) | (r3&0xFF); //Kante4-->Kante0
 r3 = (r3&0xFFFFFF00) | (h&0xFF); //Kante0-->Kante4
 r4 = (r4&0x00FFFF00) | (r4<<24) | (r4>>24); //Kante11 mit Kante8 vertauschen
}

void Wuerfel::drehenB2()
{
 uint32 h=r0;
 r0 = (r0&0xFF0000FF) | ((r1>>8)&0xFF0000) | ((r1>>8)&0xFF00); //Ecke7-->Ecke2, Ecke6-->Ecke1
 r1 = (r1&0x0000FFFF) | ((h&0xFF0000)<<8)  | ((h&0xFF00)<<8); //Ecke2-->Ecke7, Ecke1-->Ecke6
 h=r2;
 r2 = (r2&0xFF00FFFF) | (r3&0xFF0000); //Kante6-->Kante2
 r3 = (r3&0xFF00FFFF) | (h&0xFF0000); //Kante2-->Kante6
 r4 = (r4&0xFF0000FF) | ((r4&0xFF00)<<8) | ((r4>>8)&0xFF00); //Kante9 mit Kante10 vertauschen
}

void Wuerfel::drehenR2()
{
 uint32 h=r0;
 r0 = (r0&0xFFFF0000) | (r1>>24) | ((r1&0xFF)<<8); //Ecke7-->Ecke0, Ecke4-->Ecke1
 r1 = (r1&0x00FFFF00) | (h<<24) | ((h&0xFF00)>>8); //Ecke0-->Ecke7, Ecke1-->Ecke4
 h=r2;
 r2 = (r2&0xFFFF00FF) | (r3&0xFF00); //Kante5-->Kante1
 r3 = (r3&0xFFFF00FF) | (h&0xFF00); //Kante1-->Kante5
 r4 = (r4&0xFFFF0000) | ((r4&0xFF)<<8) | ((r4>>8)&0xFF); //Kante9 mit Kante8 vertauschen
}

/*
        +---------+
        | 6  6  7 |
Back    | 10    9 |
        |         |
+-------+---------+-------+
|6  10  | 2  2  1 |  9  7 |
|7  L   | 3     1 |  R  5 |  Left  Up  Right
|5  11  | 3  0  0 |  8  4 |
+-------+---------+-------+
        |         |
  Front | 11    8 |
        |         |
        +---------+
        | 5  4  4 |
  Down  | 7     5 |
        | 6  6  7 |
        +---------+
      Ecke 3     Ecke 2     Ecke 1     Ecke 0
r0: 000Q QPPP  000Q QPPP  000Q QPPP  000Q QPPP  (Q=Orientierung, P=Position)
      Ecke 7     Ecke 6     Ecke 5     Ecke 4
r1: 000Q QPPP  000Q QPPP  000Q QPPP  000Q QPPP  (Q=Orientierung, P=Position)
      Kante 3    Kante 2    Kante 1    Kante 0
r2: 000Q PPPP  000Q PPPP  000Q PPPP  000Q PPPP  (Q=Orientierung, P=Position)
      Kante 7    Kante 6    Kante 5    Kante 4
r3: 000Q PPPP  000Q PPPP  000Q PPPP  000Q PPPP  (Q=Orientierung, P=Position)
     Kante 11   Kante 10    Kante 9    Kante 8
r4: 000Q PPPP  000Q PPPP  000Q PPPP  000Q PPPP  (Q=Orientierung, P=Position)
*/

void Wuerfel::drehenL2()
{
 uint32 h=r0;
 r0 = (r0&0x0000FFFF) | ((r1&0xFFFF00)<<8); //Ecke5-->Ecke2, Ecke6-->Ecke3
 r1 = (r1&0xFF0000FF) | ((h>>8)&0xFFFF00); //Ecke2-->Ecke5, Ecke3-->Ecke6
 h=r2;
 r2 = (r2&0x00FFFFFF) | (r3&0xFF000000); //Kante7-->Kante3
 r3 = (r3&0x00FFFFFF) | (h&0xFF000000); //Kante3-->Kante7
 r4 = (r4&0x0000FFFF) | ((r4&0xFF0000)<<8) | ((r4>>8)&0xFF0000); //Kante10 mit Kante11 vertauschen
}

void Wuerfel::deepsearch_init(char *loesung,int len)
{
 for(int i=0;i<len;i++) loesung[i]=' ';
 deep_s = &loesung[len];
 *--deep_s = 0;
 geloestflag=0;
}

//Optimiert durch Tabelle mit gegenueberliegenden Seiten:
//                       D=0,F=1,U=2,B=3,L=4,R=5;
static uint8 gegentabelle[6]={U,  B,  D,  F,  R,  L};

inline bool gegenueber(uint8 v1,uint8 v2)
{
 return (gegentabelle[v1]==v2);
}

bool Wuerfel::deepsearch(int t,int vorher,int vorher2)  //muss mit t>=1 aufgerufen werden
   //vorher ist die Seite des letzten Zugs (fuer Optimierungen)
   //vorher2 ist die Seite des vorletzten Zugs
{
#ifdef MITTHREADS
 if(geloestflag!=0) {*--deep_s = '-';return true;} //Abbruch wenn ein anderer Thread eine Loesung gefunden hat
#endif
 if(--t==0)
  {
   if(vorher!=U && vorher2!=U) {
   drehenU(); if(*this==geloesterwuerfel) {*--deep_s = 'U'; return true;}
   drehenU(); if(*this==geloesterwuerfel) {*--deep_s = '2'; *--deep_s = 'U'; return true;}
   drehenU(); if(*this==geloesterwuerfel) {*--deep_s = '\''; *--deep_s = 'U'; return true;}
   drehenU(); //zurueckdrehen
   } if(vorher!=D && vorher2!=D) {
   drehenD(); if(*this==geloesterwuerfel) {*--deep_s = 'D'; return true;}
   drehenD(); if(*this==geloesterwuerfel) {*--deep_s = '2'; *--deep_s = 'D'; return true;}
   drehenD(); if(*this==geloesterwuerfel) {*--deep_s = '\''; *--deep_s = 'D'; return true;}
   drehenD(); //zurueckdrehen
   } if(vorher!=F && vorher2!=F) {
   drehenF(); if(*this==geloesterwuerfel) {*--deep_s = 'F'; return true;}
   drehenF(); if(*this==geloesterwuerfel) {*--deep_s = '2'; *--deep_s = 'F'; return true;}
   drehenF(); if(*this==geloesterwuerfel) {*--deep_s = '\''; *--deep_s = 'F'; return true;}
   drehenF(); //zurueckdrehen
   } if(vorher!=B && vorher2!=B) {
   drehenB(); if(*this==geloesterwuerfel) {*--deep_s = 'B'; return true;}
   drehenB(); if(*this==geloesterwuerfel) {*--deep_s = '2'; *--deep_s = 'B'; return true;}
   drehenB(); if(*this==geloesterwuerfel) {*--deep_s = '\''; *--deep_s = 'B'; return true;}
   drehenB(); //zurueckdrehen
   } if(vorher!=L && vorher2!=L) {
   drehenL(); if(*this==geloesterwuerfel) {*--deep_s = 'L'; return true;}
   drehenL(); if(*this==geloesterwuerfel) {*--deep_s = '2'; *--deep_s = 'L'; return true;}
   drehenL(); if(*this==geloesterwuerfel) {*--deep_s = '\''; *--deep_s = 'L'; return true;}
   drehenL(); //zurueckdrehen
   } if(vorher!=R && vorher2!=R) {
   drehenR(); if(*this==geloesterwuerfel) {*--deep_s = 'R'; return true;}
   drehenR(); if(*this==geloesterwuerfel) {*--deep_s = '2'; *--deep_s = 'R'; return true;}
   drehenR(); if(*this==geloesterwuerfel) {*--deep_s = '\''; *--deep_s = 'R'; return true;}
   drehenR(); //zurueckdrehen
   }
  }
 else
  {
   int v2;
   if(vorher!=U && vorher2!=U) {
    v2 = gegenueber(U,vorher) ? vorher : -1;
    drehenU(); if(deepsearch(t,U,v2)) {*--deep_s = 'U'; return true;}
    drehenU(); if(deepsearch(t,U,v2)) {*--deep_s = '2'; *--deep_s = 'U'; return true;}
    drehenU(); if(deepsearch(t,U,v2)) {*--deep_s = '\''; *--deep_s = 'U'; return true;}
    drehenU(); //zurueckdrehen
   } if(vorher!=D && vorher2!=D) {
    v2 = gegenueber(D,vorher) ? vorher : -1;
    drehenD(); if(deepsearch(t,D,v2)) {*--deep_s = 'D'; return true;}
    drehenD(); if(deepsearch(t,D,v2)) {*--deep_s = '2'; *--deep_s = 'D'; return true;}
    drehenD(); if(deepsearch(t,D,v2)) {*--deep_s = '\''; *--deep_s = 'D'; return true;}
    drehenD(); //zurueckdrehen
   } if(vorher!=F && vorher2!=F) {
    v2 = gegenueber(F,vorher) ? vorher : -1;
    drehenF(); if(deepsearch(t,F,v2)) {*--deep_s = 'F'; return true;}
    drehenF(); if(deepsearch(t,F,v2)) {*--deep_s = '2'; *--deep_s = 'F'; return true;}
    drehenF(); if(deepsearch(t,F,v2)) {*--deep_s = '\''; *--deep_s = 'F'; return true;}
    drehenF(); //zurueckdrehen
   } if(vorher!=B && vorher2!=B) {
    v2 = gegenueber(B,vorher) ? vorher : -1;
    drehenB(); if(deepsearch(t,B,v2)) {*--deep_s = 'B'; return true;}
    drehenB(); if(deepsearch(t,B,v2)) {*--deep_s = '2'; *--deep_s = 'B'; return true;}
    drehenB(); if(deepsearch(t,B,v2)) {*--deep_s = '\''; *--deep_s = 'B'; return true;}
    drehenB(); //zurueckdrehen
   } if(vorher!=L && vorher2!=L) {
    v2 = gegenueber(L,vorher) ? vorher : -1;
    drehenL(); if(deepsearch(t,L,v2)) {*--deep_s = 'L'; return true;}
    drehenL(); if(deepsearch(t,L,v2)) {*--deep_s = '2'; *--deep_s = 'L'; return true;}
    drehenL(); if(deepsearch(t,L,v2)) {*--deep_s = '\''; *--deep_s = 'L'; return true;}
    drehenL(); //zurueckdrehen
   } if(vorher!=R && vorher2!=R) {
    v2 = gegenueber(R,vorher) ? vorher : -1;
    drehenR(); if(deepsearch(t,R,v2)) {*--deep_s = 'R'; return true;}
    drehenR(); if(deepsearch(t,R,v2)) {*--deep_s = '2'; *--deep_s = 'R'; return true;}
    drehenR(); if(deepsearch(t,R,v2)) {*--deep_s = '\''; *--deep_s = 'R'; return true;}
    drehenR(); //zurueckdrehen
   }
  }
 return false;
}

bool Wuerfel::orisearch(int t,int vorher,int vorher2)  //muss mit t>=1 aufgerufen werden
   //vorher ist die Seite des letzten Zugs (fuer Optimierungen)
   //vorher2 ist die Seite des vorletzten Zugs
{
#ifdef MITTHREADS
 if(geloestflag!=0) {*--deep_s = '-';return true;} //Abbruch wenn ein anderer Thread eine Loesung gefunden hat
#endif
 if(--t==0)
  {
   if(vorher!=U && vorher2!=U) {
   drehenU(); if(origeloest()) {*--deep_s = 'U'; return true;}
   drehenU(); if(origeloest()) {*--deep_s = '2'; *--deep_s = 'U'; return true;}
   drehenU(); if(origeloest()) {*--deep_s = '\''; *--deep_s = 'U'; return true;}
   drehenU(); //zurueckdrehen
   } if(vorher!=D && vorher2!=D) {
   drehenD(); if(origeloest()) {*--deep_s = 'D'; return true;}
   drehenD(); if(origeloest()) {*--deep_s = '2'; *--deep_s = 'D'; return true;}
   drehenD(); if(origeloest()) {*--deep_s = '\''; *--deep_s = 'D'; return true;}
   drehenD(); //zurueckdrehen
   } if(vorher!=F && vorher2!=F) {
   drehenF(); if(origeloest()) {*--deep_s = 'F'; return true;}
   drehenF(); if(origeloest()) {*--deep_s = '2'; *--deep_s = 'F'; return true;}
   drehenF(); if(origeloest()) {*--deep_s = '\''; *--deep_s = 'F'; return true;}
   drehenF(); //zurueckdrehen
   } if(vorher!=B && vorher2!=B) {
   drehenB(); if(origeloest()) {*--deep_s = 'B'; return true;}
   drehenB(); if(origeloest()) {*--deep_s = '2'; *--deep_s = 'B'; return true;}
   drehenB(); if(origeloest()) {*--deep_s = '\''; *--deep_s = 'B'; return true;}
   drehenB(); //zurueckdrehen
   } if(vorher!=L && vorher2!=L) {
   drehenL(); if(origeloest()) {*--deep_s = 'L'; return true;}
   drehenL(); if(origeloest()) {*--deep_s = '2'; *--deep_s = 'L'; return true;}
   drehenL(); if(origeloest()) {*--deep_s = '\''; *--deep_s = 'L'; return true;}
   drehenL(); //zurueckdrehen
   } if(vorher!=R && vorher2!=R) {
   drehenR(); if(origeloest()) {*--deep_s = 'R'; return true;}
   drehenR(); if(origeloest()) {*--deep_s = '2'; *--deep_s = 'R'; return true;}
   drehenR(); if(origeloest()) {*--deep_s = '\''; *--deep_s = 'R'; return true;}
   drehenR(); //zurueckdrehen
   }
  }
 else
  {
   int v2;
   if(vorher!=U && vorher2!=U) {
    v2 = gegenueber(U,vorher) ? vorher : -1;
    drehenU(); if(orisearch(t,U,v2)) {*--deep_s = 'U'; return true;}
    drehenU(); if(orisearch(t,U,v2)) {*--deep_s = '2'; *--deep_s = 'U'; return true;}
    drehenU(); if(orisearch(t,U,v2)) {*--deep_s = '\''; *--deep_s = 'U'; return true;}
    drehenU(); //zurueckdrehen
   } if(vorher!=D && vorher2!=D) {
    v2 = gegenueber(D,vorher) ? vorher : -1;
    drehenD(); if(orisearch(t,D,v2)) {*--deep_s = 'D'; return true;}
    drehenD(); if(orisearch(t,D,v2)) {*--deep_s = '2'; *--deep_s = 'D'; return true;}
    drehenD(); if(orisearch(t,D,v2)) {*--deep_s = '\''; *--deep_s = 'D'; return true;}
    drehenD(); //zurueckdrehen
   } if(vorher!=F && vorher2!=F) {
    v2 = gegenueber(F,vorher) ? vorher : -1;
    drehenF(); if(orisearch(t,F,v2)) {*--deep_s = 'F'; return true;}
    drehenF(); if(orisearch(t,F,v2)) {*--deep_s = '2'; *--deep_s = 'F'; return true;}
    drehenF(); if(orisearch(t,F,v2)) {*--deep_s = '\''; *--deep_s = 'F'; return true;}
    drehenF(); //zurueckdrehen
   } if(vorher!=B && vorher2!=B) {
    v2 = gegenueber(B,vorher) ? vorher : -1;
    drehenB(); if(orisearch(t,B,v2)) {*--deep_s = 'B'; return true;}
    drehenB(); if(orisearch(t,B,v2)) {*--deep_s = '2'; *--deep_s = 'B'; return true;}
    drehenB(); if(orisearch(t,B,v2)) {*--deep_s = '\''; *--deep_s = 'B'; return true;}
    drehenB(); //zurueckdrehen
   } if(vorher!=L && vorher2!=L) {
    v2 = gegenueber(L,vorher) ? vorher : -1;
    drehenL(); if(orisearch(t,L,v2)) {*--deep_s = 'L'; return true;}
    drehenL(); if(orisearch(t,L,v2)) {*--deep_s = '2'; *--deep_s = 'L'; return true;}
    drehenL(); if(orisearch(t,L,v2)) {*--deep_s = '\''; *--deep_s = 'L'; return true;}
    drehenL(); //zurueckdrehen
   } if(vorher!=R && vorher2!=R) {
    v2 = gegenueber(R,vorher) ? vorher : -1;
    drehenR(); if(orisearch(t,R,v2)) {*--deep_s = 'R'; return true;}
    drehenR(); if(orisearch(t,R,v2)) {*--deep_s = '2'; *--deep_s = 'R'; return true;}
    drehenR(); if(orisearch(t,R,v2)) {*--deep_s = '\''; *--deep_s = 'R'; return true;}
    drehenR(); //zurueckdrehen
   }
  }
 return false;
}

bool Wuerfel::ecksearch(int t,int vorher,int vorher2)  //muss mit t>=1 aufgerufen werden
   //vorher ist die Seite des letzten Zugs (fuer Optimierungen)
   //vorher2 ist die Seite des vorletzten Zugs
{
#ifdef MITTHREADS
 if(geloestflag!=0) {*--deep_s = '-';return true;} //Abbruch wenn ein anderer Thread eine Loesung gefunden hat
#endif
 if(--t==0)
  {
   if(vorher!=U && vorher2!=U) {
   drehenU(); if(eckengeloest()) {*--deep_s = 'U'; return true;}
   drehenU(); if(eckengeloest()) {*--deep_s = '2'; *--deep_s = 'U'; return true;}
   drehenU(); if(eckengeloest()) {*--deep_s = '\''; *--deep_s = 'U'; return true;}
   drehenU(); //zurueckdrehen
   } if(vorher!=D && vorher2!=D) {
   drehenD(); if(eckengeloest()) {*--deep_s = 'D'; return true;}
   drehenD(); if(eckengeloest()) {*--deep_s = '2'; *--deep_s = 'D'; return true;}
   drehenD(); if(eckengeloest()) {*--deep_s = '\''; *--deep_s = 'D'; return true;}
   drehenD(); //zurueckdrehen
   } if(vorher!=F && vorher2!=F) {
   drehenF(); if(eckengeloest()) {*--deep_s = 'F'; return true;}
   drehenF(); if(eckengeloest()) {*--deep_s = '2'; *--deep_s = 'F'; return true;}
   drehenF(); if(eckengeloest()) {*--deep_s = '\''; *--deep_s = 'F'; return true;}
   drehenF(); //zurueckdrehen
   } if(vorher!=B && vorher2!=B) {
   drehenB(); if(eckengeloest()) {*--deep_s = 'B'; return true;}
   drehenB(); if(eckengeloest()) {*--deep_s = '2'; *--deep_s = 'B'; return true;}
   drehenB(); if(eckengeloest()) {*--deep_s = '\''; *--deep_s = 'B'; return true;}
   drehenB(); //zurueckdrehen
   } if(vorher!=L && vorher2!=L) {
   drehenL(); if(eckengeloest()) {*--deep_s = 'L'; return true;}
   drehenL(); if(eckengeloest()) {*--deep_s = '2'; *--deep_s = 'L'; return true;}
   drehenL(); if(eckengeloest()) {*--deep_s = '\''; *--deep_s = 'L'; return true;}
   drehenL(); //zurueckdrehen
   } if(vorher!=R && vorher2!=R) {
   drehenR(); if(eckengeloest()) {*--deep_s = 'R'; return true;}
   drehenR(); if(eckengeloest()) {*--deep_s = '2'; *--deep_s = 'R'; return true;}
   drehenR(); if(eckengeloest()) {*--deep_s = '\''; *--deep_s = 'R'; return true;}
   drehenR(); //zurueckdrehen
   }
  }
 else
  {
   int v2;
   if(vorher!=U && vorher2!=U) {
    v2 = gegenueber(U,vorher) ? vorher : -1;
    drehenU(); if(ecksearch(t,U,v2)) {*--deep_s = 'U'; return true;}
    drehenU(); if(ecksearch(t,U,v2)) {*--deep_s = '2'; *--deep_s = 'U'; return true;}
    drehenU(); if(ecksearch(t,U,v2)) {*--deep_s = '\''; *--deep_s = 'U'; return true;}
    drehenU(); //zurueckdrehen
   } if(vorher!=D && vorher2!=D) {
    v2 = gegenueber(D,vorher) ? vorher : -1;
    drehenD(); if(ecksearch(t,D,v2)) {*--deep_s = 'D'; return true;}
    drehenD(); if(ecksearch(t,D,v2)) {*--deep_s = '2'; *--deep_s = 'D'; return true;}
    drehenD(); if(ecksearch(t,D,v2)) {*--deep_s = '\''; *--deep_s = 'D'; return true;}
    drehenD(); //zurueckdrehen
   } if(vorher!=F && vorher2!=F) {
    v2 = gegenueber(F,vorher) ? vorher : -1;
    drehenF(); if(ecksearch(t,F,v2)) {*--deep_s = 'F'; return true;}
    drehenF(); if(ecksearch(t,F,v2)) {*--deep_s = '2'; *--deep_s = 'F'; return true;}
    drehenF(); if(ecksearch(t,F,v2)) {*--deep_s = '\''; *--deep_s = 'F'; return true;}
    drehenF(); //zurueckdrehen
   } if(vorher!=B && vorher2!=B) {
    v2 = gegenueber(B,vorher) ? vorher : -1;
    drehenB(); if(ecksearch(t,B,v2)) {*--deep_s = 'B'; return true;}
    drehenB(); if(ecksearch(t,B,v2)) {*--deep_s = '2'; *--deep_s = 'B'; return true;}
    drehenB(); if(ecksearch(t,B,v2)) {*--deep_s = '\''; *--deep_s = 'B'; return true;}
    drehenB(); //zurueckdrehen
   } if(vorher!=L && vorher2!=L) {
    v2 = gegenueber(L,vorher) ? vorher : -1;
    drehenL(); if(ecksearch(t,L,v2)) {*--deep_s = 'L'; return true;}
    drehenL(); if(ecksearch(t,L,v2)) {*--deep_s = '2'; *--deep_s = 'L'; return true;}
    drehenL(); if(ecksearch(t,L,v2)) {*--deep_s = '\''; *--deep_s = 'L'; return true;}
    drehenL(); //zurueckdrehen
   } if(vorher!=R && vorher2!=R) {
    v2 = gegenueber(R,vorher) ? vorher : -1;
    drehenR(); if(ecksearch(t,R,v2)) {*--deep_s = 'R'; return true;}
    drehenR(); if(ecksearch(t,R,v2)) {*--deep_s = '2'; *--deep_s = 'R'; return true;}
    drehenR(); if(ecksearch(t,R,v2)) {*--deep_s = '\''; *--deep_s = 'R'; return true;}
    drehenR(); //zurueckdrehen
   }
  }
 return false;
}

bool Wuerfel::twosearch(int t,int vorher,int vorher2)  //muss mit t>=1 aufgerufen werden
   //vorher ist die Seite des letzten Zugs (fuer Optimierungen)
   //vorher2 ist die Seite des vorletzten Zugs
{
#ifdef MITTHREADS
 if(geloestflag!=0) {*--deep_s = '-'; return true;} //Abbruch wenn ein anderer Thread eine Loesung gefunden hat
#endif
 if(--t==0)
  {
   if(vorher!=U && vorher2!=U) {
   drehenU(); if(geloest()) {*--deep_s = 'U'; return true;}
   drehenU(); if(geloest()) {*--deep_s = '2'; *--deep_s = 'U'; return true;}
   drehenU(); if(geloest()) {*--deep_s = '\''; *--deep_s = 'U'; return true;}
   drehenU(); //zurueckdrehen
   } if(vorher!=D && vorher2!=D) {
   drehenD(); if(geloest()) {*--deep_s = 'D'; return true;}
   drehenD(); if(geloest()) {*--deep_s = '2'; *--deep_s = 'D'; return true;}
   drehenD(); if(geloest()) {*--deep_s = '\''; *--deep_s = 'D'; return true;}
   drehenD(); //zurueckdrehen
   } if(vorher!=F && vorher2!=F) {
   drehenF2(); if(geloest()) {*--deep_s = '2'; *--deep_s = 'F'; return true;}
   drehenF2(); //zurueckdrehen
   } if(vorher!=B && vorher2!=B) {
   drehenB2(); if(geloest()) {*--deep_s = '2'; *--deep_s = 'B'; return true;}
   drehenB2(); //zurueckdrehen
   } if(vorher!=L && vorher2!=L) {
   drehenL2(); if(geloest()) {*--deep_s = '2'; *--deep_s = 'L'; return true;}
   drehenL2(); //zurueckdrehen
   } if(vorher!=R && vorher2!=R) {
   drehenR2(); if(geloest()) {*--deep_s = '2'; *--deep_s = 'R'; return true;}
   drehenR2(); //zurueckdrehen
   }
  }
 else
  {
   int v2;
   if(vorher!=U && vorher2!=U) {
    v2 = gegenueber(U,vorher) ? vorher : -1;
    drehenU(); if(twosearch(t,U,v2)) {*--deep_s = 'U'; return true;}
    drehenU(); if(twosearch(t,U,v2)) {*--deep_s = '2'; *--deep_s = 'U'; return true;}
    drehenU(); if(twosearch(t,U,v2)) {*--deep_s = '\''; *--deep_s = 'U'; return true;}
    drehenU(); //zurueckdrehen
   } if(vorher!=D && vorher2!=D) {
    v2 = gegenueber(D,vorher) ? vorher : -1;
    drehenD(); if(twosearch(t,D,v2)) {*--deep_s = 'D'; return true;}
    drehenD(); if(twosearch(t,D,v2)) {*--deep_s = '2'; *--deep_s = 'D'; return true;}
    drehenD(); if(twosearch(t,D,v2)) {*--deep_s = '\''; *--deep_s = 'D'; return true;}
    drehenD(); //zurueckdrehen
   } if(vorher!=F && vorher2!=F) {
    v2 = gegenueber(F,vorher) ? vorher : -1;
    drehenF2(); if(twosearch(t,F,v2)) {*--deep_s = '2'; *--deep_s = 'F'; return true;}
    drehenF2(); //zurueckdrehen
   } if(vorher!=B && vorher2!=B) {
    v2 = gegenueber(B,vorher) ? vorher : -1;
    drehenB2(); if(twosearch(t,B,v2)) {*--deep_s = '2'; *--deep_s = 'B'; return true;}
    drehenB2(); //zurueckdrehen
   } if(vorher!=L && vorher2!=L) {
    v2 = gegenueber(L,vorher) ? vorher : -1;
    drehenL2(); if(twosearch(t,L,v2)) {*--deep_s = '2'; *--deep_s = 'L'; return true;}
    drehenL2(); //zurueckdrehen
   } if(vorher!=R && vorher2!=R) {
    v2 = gegenueber(R,vorher) ? vorher : -1;
    drehenR2(); if(twosearch(t,R,v2)) {*--deep_s = '2'; *--deep_s = 'R'; return true;}
    drehenR2(); //zurueckdrehen
   }
  }
 return false;
}

#ifdef MITTHREADS

static bool trueckgabewert[6]; //Rueckgabewerte fuer bis zu 6 Threads
static Wuerfel tw[6]; //ein Wuerfel fuer jeden Thread
static char tloesung[6][40]; //Stringfelder fuer eventuelle Loesungen
//schon weiter oben definiert:
//static volatile int geloestflag=0; //wird gesetzt wenn einer der Threads eine Loesung gefunden hat

void vorbereitung_deepsearch1(Wuerfel w)
{
 int nr;
 for(nr=0;nr<6;nr++)
  {
   tw[nr]=w;
   tw[nr].deepsearch_init(tloesung[nr],40);
  }
 geloestflag=0;
}

bool resultate_deepsearch1(char *loesung)
{
 int nr;
 for(nr=0;nr<6;nr++)
  {
   if(trueckgabewert[nr])
    {
     printf("Loesung gefunden: nr=%d\n",nr);//test
     strcpy(loesung,tloesung[nr]);
     while(++nr<6) {if(trueckgabewert[nr]) printf("Fehler: mehrere Loesungen %d\n",nr);}//test
     return true;
    }
  }
 return false;
}

void erfolgreich(int c1,int c2,int nr)
{
 if(geloestflag==0)
  {
   if(c2!=0) *--tw[nr].deep_s = c2;
   *--tw[nr].deep_s = c1;
   trueckgabewert[nr] = true;
   geloestflag=1;
  }
 else
  {
   *--tw[nr].deep_s = '-';
  }
}

void deepsearch1(int t,int nr)  //muss mit t>=2 aufgerufen werden, nr ist die Nummer des Threads (0 bis 5)
{
 --t;
 //if(t<1) {fprintf(stderr,"Fehler in deepsearch1()\n"); return;}//test
 const int v2=0xFF;
 trueckgabewert[nr]=false;
 if(nr==U)
   {
    tw[nr].drehenU(); if(tw[nr].deepsearch(t,U,v2)) {erfolgreich('U',0,nr); return;}
    if(geloestflag!=0) return; //Abbruch wenn ein anderer Thread eine Loesung gefunden hat
    tw[nr].drehenU(); if(tw[nr].deepsearch(t,U,v2)) {erfolgreich('U','2',nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenU(); if(tw[nr].deepsearch(t,U,v2)) {erfolgreich('U','\'',nr); return;}
   }
 else if(nr==D)
   {
    tw[nr].drehenD(); if(tw[nr].deepsearch(t,D,v2)) {erfolgreich('D',0,nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenD(); if(tw[nr].deepsearch(t,D,v2)) {erfolgreich('D','2',nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenD(); if(tw[nr].deepsearch(t,D,v2)) {erfolgreich('D','\'',nr); return;}
   }
 else if(nr==F)
   {
    tw[nr].drehenF(); if(tw[nr].deepsearch(t,F,v2)) {erfolgreich('F',0,nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenF(); if(tw[nr].deepsearch(t,F,v2)) {erfolgreich('F','2',nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenF(); if(tw[nr].deepsearch(t,F,v2)) {erfolgreich('F','\'',nr); return;}
   }
 else if(nr==B)
   {
    tw[nr].drehenB(); if(tw[nr].deepsearch(t,B,v2)) {erfolgreich('B',0,nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenB(); if(tw[nr].deepsearch(t,B,v2)) {erfolgreich('B','2',nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenB(); if(tw[nr].deepsearch(t,B,v2)) {erfolgreich('B','\'',nr); return;}
   }
 else if(nr==L)
   {
    tw[nr].drehenL(); if(tw[nr].deepsearch(t,L,v2)) {erfolgreich('L',0,nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenL(); if(tw[nr].deepsearch(t,L,v2)) {erfolgreich('L','2',nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenL(); if(tw[nr].deepsearch(t,L,v2)) {erfolgreich('L','\'',nr); return;}
   }
 else //if(nr==R)
   {
    tw[nr].drehenR(); if(tw[nr].deepsearch(t,R,v2)) {erfolgreich('R',0,nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenR(); if(tw[nr].deepsearch(t,R,v2)) {erfolgreich('R','2',nr); return;}
    if(geloestflag!=0) return;
    tw[nr].drehenR(); if(tw[nr].deepsearch(t,R,v2)) {erfolgreich('R','\'',nr); return;}
   }
}

void orisearch1(int t,int nr)  //muss mit t>=2 aufgerufen werden, nr ist die Nummer des Threads (0 bis 5)
{
 --t;
 const int v2=0xFF;
 trueckgabewert[nr]=false;
 if(nr==U)
   {
    tw[nr].drehenU(); if(tw[nr].orisearch(t,U,v2)) {erfolgreich('U',0,nr); return;}
    tw[nr].drehenU(); if(tw[nr].orisearch(t,U,v2)) {erfolgreich('U','2',nr); return;}
    tw[nr].drehenU(); if(tw[nr].orisearch(t,U,v2)) {erfolgreich('U','\'',nr); return;}
   }
 else if(nr==D)
   {
    tw[nr].drehenD(); if(tw[nr].orisearch(t,D,v2)) {erfolgreich('D',0,nr); return;}
    tw[nr].drehenD(); if(tw[nr].orisearch(t,D,v2)) {erfolgreich('D','2',nr); return;}
    tw[nr].drehenD(); if(tw[nr].orisearch(t,D,v2)) {erfolgreich('D','\'',nr); return;}
   }
 else if(nr==F)
   {
    tw[nr].drehenF(); if(tw[nr].orisearch(t,F,v2)) {erfolgreich('F',0,nr); return;}
    tw[nr].drehenF(); if(tw[nr].orisearch(t,F,v2)) {erfolgreich('F','2',nr); return;}
    tw[nr].drehenF(); if(tw[nr].orisearch(t,F,v2)) {erfolgreich('F','\'',nr); return;}
   }
 else if(nr==B)
   {
    tw[nr].drehenB(); if(tw[nr].orisearch(t,B,v2)) {erfolgreich('B',0,nr); return;}
    tw[nr].drehenB(); if(tw[nr].orisearch(t,B,v2)) {erfolgreich('B','2',nr); return;}
    tw[nr].drehenB(); if(tw[nr].orisearch(t,B,v2)) {erfolgreich('B','\'',nr); return;}
   }
 else if(nr==L)
   {
    tw[nr].drehenL(); if(tw[nr].orisearch(t,L,v2)) {erfolgreich('L',0,nr); return;}
    tw[nr].drehenL(); if(tw[nr].orisearch(t,L,v2)) {erfolgreich('L','2',nr); return;}
    tw[nr].drehenL(); if(tw[nr].orisearch(t,L,v2)) {erfolgreich('L','\'',nr); return;}
   }
 else //if(nr==R)
   {
    tw[nr].drehenR(); if(tw[nr].orisearch(t,R,v2)) {erfolgreich('R',0,nr); return;}
    tw[nr].drehenR(); if(tw[nr].orisearch(t,R,v2)) {erfolgreich('R','2',nr); return;}
    tw[nr].drehenR(); if(tw[nr].orisearch(t,R,v2)) {erfolgreich('R','\'',nr); return;}
   }
}

void ecksearch1(int t,int nr)  //muss mit t>=2 aufgerufen werden, nr ist die Nummer des Threads (0 bis 5)
{
 --t;
 const int v2=0xFF;
 trueckgabewert[nr]=false;
 if(nr==U)
   {
    tw[nr].drehenU(); if(tw[nr].ecksearch(t,U,v2)) {erfolgreich('U',0,nr); return;}
    tw[nr].drehenU(); if(tw[nr].ecksearch(t,U,v2)) {erfolgreich('U','2',nr); return;}
    tw[nr].drehenU(); if(tw[nr].ecksearch(t,U,v2)) {erfolgreich('U','\'',nr); return;}
   }
 else if(nr==D)
   {
    tw[nr].drehenD(); if(tw[nr].ecksearch(t,D,v2)) {erfolgreich('D',0,nr); return;}
    tw[nr].drehenD(); if(tw[nr].ecksearch(t,D,v2)) {erfolgreich('D','2',nr); return;}
    tw[nr].drehenD(); if(tw[nr].ecksearch(t,D,v2)) {erfolgreich('D','\'',nr); return;}
   }
 else if(nr==F)
   {
    tw[nr].drehenF(); if(tw[nr].ecksearch(t,F,v2)) {erfolgreich('F',0,nr); return;}
    tw[nr].drehenF(); if(tw[nr].ecksearch(t,F,v2)) {erfolgreich('F','2',nr); return;}
    tw[nr].drehenF(); if(tw[nr].ecksearch(t,F,v2)) {erfolgreich('F','\'',nr); return;}
   }
 else if(nr==B)
   {
    tw[nr].drehenB(); if(tw[nr].ecksearch(t,B,v2)) {erfolgreich('B',0,nr); return;}
    tw[nr].drehenB(); if(tw[nr].ecksearch(t,B,v2)) {erfolgreich('B','2',nr); return;}
    tw[nr].drehenB(); if(tw[nr].ecksearch(t,B,v2)) {erfolgreich('B','\'',nr); return;}
   }
 else if(nr==L)
   {
    tw[nr].drehenL(); if(tw[nr].ecksearch(t,L,v2)) {erfolgreich('L',0,nr); return;}
    tw[nr].drehenL(); if(tw[nr].ecksearch(t,L,v2)) {erfolgreich('L','2',nr); return;}
    tw[nr].drehenL(); if(tw[nr].ecksearch(t,L,v2)) {erfolgreich('L','\'',nr); return;}
   }
 else //if(nr==R)
   {
    tw[nr].drehenR(); if(tw[nr].ecksearch(t,R,v2)) {erfolgreich('R',0,nr); return;}
    tw[nr].drehenR(); if(tw[nr].ecksearch(t,R,v2)) {erfolgreich('R','2',nr); return;}
    tw[nr].drehenR(); if(tw[nr].ecksearch(t,R,v2)) {erfolgreich('R','\'',nr); return;}
   }
}

void twosearch1(int t,int nr)  //muss mit t>=2 aufgerufen werden, nr ist die Nummer des Threads (0 bis 5)
{
 --t;
 const int v2=0xFF;
 trueckgabewert[nr]=false;
 if(nr==U)
   {
    tw[nr].drehenU(); if(tw[nr].twosearch(t,U,v2)) {erfolgreich('U',0,nr); return;}
    tw[nr].drehenU(); if(tw[nr].twosearch(t,U,v2)) {erfolgreich('U','2',nr); return;}
    tw[nr].drehenU(); if(tw[nr].twosearch(t,U,v2)) {erfolgreich('U','\'',nr); return;}
   }
 else if(nr==D)
   {
    tw[nr].drehenD(); if(tw[nr].twosearch(t,D,v2)) {erfolgreich('D',0,nr); return;}
    tw[nr].drehenD(); if(tw[nr].twosearch(t,D,v2)) {erfolgreich('D','2',nr); return;}
    tw[nr].drehenD(); if(tw[nr].twosearch(t,D,v2)) {erfolgreich('D','\'',nr); return;}
   }
 else if(nr==F)
   {
    tw[nr].drehenF2(); if(tw[nr].twosearch(t,F,v2)) {erfolgreich('F','2',nr); return;}
   }
 else if(nr==B)
   {
    tw[nr].drehenB2(); if(tw[nr].twosearch(t,B,v2)) {erfolgreich('B','2',nr); return;}
   }
 else if(nr==L)
   {
    tw[nr].drehenL2(); if(tw[nr].twosearch(t,L,v2)) {erfolgreich('L','2',nr); return;}
   }
 else //if(nr==R)
   {
    tw[nr].drehenR2(); if(tw[nr].twosearch(t,R,v2)) {erfolgreich('R','2',nr); return;}
   }
}
#endif

/********************* weitere Vordeklarationen ***********************/
int bestmov(Rub *feld,int suchtiefe,int *pwert);
int bewertung(Rub *feld);
int zufallszug(Rub *feld);

/************************* Menu Behandlung ****************************/
void menu_exit() {exitflag=1;}

void m_refresh()
{
 inital_new();
#ifdef SCHWARZAUFWEISS
 if(TIEFE==24)  {screenclear(0x7F7F7F); rgbcolor(0x00,0x00,0x00);}
 else           {screenclear(1); color(0);}
#else
 if(TIEFE==24)  {screenclear(0); rgbcolor(0xFF,0xFF,0xFF);}
 else           {screenclear(0); color(1);}
#endif
 wuerfel_zeichnen();
 abwicklung_zeichnen(abw_x0,abw_y0);
 term_refresh();
}

void m_abwicklung()
{
 //int ok=
 requester_input(1,"Abwicklungs-Variante (1 oder 2)","%d","%d",&abwickvariante);
 m_refresh();
}

void m_about()
{
 char str[200];
 sprintf(str,"rubik.cc %s\nDieses Programm ist Opensource-Freeware\nAutor: Rolf Pfister\nwww.rolfp.ch",VERSION);
 janeinrequester(str);
 m_refresh();
}

void m_load()
{
 int ok;
 static char name[200]="test.rubik",filter[80]="*.rubik";
 ok=nachfilenamefragen("Lade Wuerfeldatei",name,200,0,filter);
 if(ok) dateiladen(name);
 m_refresh();
}

void m_save()
{
 int ok;
 static char name[200]="test.rubik",filter[80]="*.rubik";
 ok=nachfilenamefragen("Speichere Wuerfeldatei",name,200,0,filter);
 if(ok) dateispeichern(name);
 m_refresh();
}

void pause1()
{
 for(int i=0;i<25;i++) waitBOF();
}

void m_solve()
{
 int i,m,wert,n=0;
 int startflag=1;
 int test=6; //fuer Testausdrucke von Suchtiefe
 static int suchtiefe=20;
 //int ok=requester_input(1,"maximale Suchtiefe","%d","%d",&suchtiefe);
 //if(!ok) {m_refresh(); return;}
 wert=bewertung(hauptfeld);
 for(i=1;i<=suchtiefe && wert!=0;i++)
  {
   if(i>test) {printf("Momentane Suchtiefe: %d\n",i); test=i;}//test
   m=bestmov(hauptfeld,i,&wert);
   drehung(hauptfeld,m&0xFF,m>>8); m_refresh(); //Drehung machen
   pause1();
   if(wert==0)
    {
     wert=bewertung(hauptfeld); n++;
     if(startflag) {printf("Loesung: "); startflag=0; if(fpziel!=NULL) fprintf(fpziel,"Loesung: ");}
     zugdrucken(m&0xFF,m>>8,' ');
     if(fpziel!=NULL) zugdruckenfp(fpziel,m&0xFF,m>>8,' ');
     if(i>2) i-=2;
    }
   else {drehung(hauptfeld,m&0xFF,4-(m>>8)); m_refresh();} //Drehung zuruecknehmen
  }
 char str[200];
 if(wert==0)
  {
   printf("\n");
   if(fpziel!=NULL)
    {
     fprintf(fpziel,"\n");
     if(argflag['A']) {m_refresh(); return;}
    }
   sprintf(str,"\nWuefel mit %d Drehungen geloest.\n",n);
  }
 else sprintf(str,"Automatisches Loesen mit %d Suchtiefe nicht geklappt.",suchtiefe);
 printf("%s",str);
 janeinrequester(str);
 m_refresh();
}

void m_solvebest1() //ohne Threads loesen
{
 const int maxsuchtiefe=20; //es werden maximal 20 Zuege gebraucht um den 3x3x3-Wuerfel zu loesen
 int i;
 int test=6; //fuer Testausdrucke von Suchtiefe
 bool geloest;
 char loesung[40];
 Wuerfel wuerfel;
 wuerfel.init(hauptfeld);
 //wuerfel.print();//test
 geloest = (wuerfel==geloesterwuerfel);
 if(geloest) {printf("Wuerfel ist schon geloest.\n"); m_refresh(); return;}
 wuerfel.deepsearch_init(loesung,40);
 for(i=1;i<=maxsuchtiefe && !geloest;i++)
  {
   if(i>test) {printf("Momentane Suchtiefe: %d\n",i); test=i;}//test
   geloest=wuerfel.deepsearch(i);
  }
 if(geloest)
  {
   fuehrende_leerzeichen_loeschen(loesung);
   printf("Loesung: %s\n",loesung);
   if(fpziel!=NULL) fprintf(fpziel,"Loesung: %s\n",loesung);
  }
 else fprintf(stderr,"Fehler in m_solvebest1(): keine Loesung gefunden.\n");
 m_refresh();
}

#ifdef MITTHREADS

void m_solvebest()
{
 const int maxsuchtiefe=20; //es werden maximal 20 Zuege gebraucht um den 3x3x3-Wuerfel zu loesen
 int i;
 int test=6; //fuer Testausdrucke von Suchtiefe
 bool geloest;
 char loesung[40];
 Wuerfel wuerfel;
 wuerfel.init(hauptfeld);
 //wuerfel.print();//test
 geloest = (wuerfel==geloesterwuerfel);
 if(geloest) {printf("Wuerfel ist schon geloest.\n"); m_refresh(); return;}
 wuerfel.deepsearch_init(loesung,40);
 for(i=1;i<=maxsuchtiefe && !geloest;i++)
  {
   if(i>test) {printf("Momentane Suchtiefe: %d\n",i); test=i;}//test
   if(i<=6) //fuer kleine Suchtiefe braucht es keine Threads
    {
     geloest=wuerfel.deepsearch(i);
    }
   else //groessere Suchtiefen auf mehrere Threads aufteilen:
    {
     vorbereitung_deepsearch1(wuerfel);
     std::thread t0(deepsearch1,i,0);
     std::thread t1(deepsearch1,i,1);
     std::thread t2(deepsearch1,i,2);
     std::thread t3(deepsearch1,i,3);
     std::thread t4(deepsearch1,i,4);
     //printf("5 Threads gestartet, 6. laeuft in diesem Thread.\n");//test
     deepsearch1(i,5);
     t0.join();
     t1.join();
     t2.join();
     t3.join();
     t4.join();
     //printf("alle Threads fertig.\n");//test
     geloest=resultate_deepsearch1(loesung);
    }
  }
 if(geloest)
  {
   fuehrende_leerzeichen_loeschen(loesung);
   printf("Loesung: %s\n",loesung);
   if(fpziel!=NULL) fprintf(fpziel,"Loesung: %s\n",loesung);
  }
 else fprintf(stderr,"Fehler in m_solvebest(): keine Loesung gefunden.\n");
 m_refresh();
}

#else
void m_solvebest() {m_solvebest1();}
#endif

char *zug_machen(char *s)
{
 int c,n;
 c= *s++;
 if(*s=='\'') {n=3; s++;}
 else if(*s=='2') {n=2; s++;}
 else n=1;
 drehung(hauptfeld,c,n);
 return s;
}

void m_orisolve() //nur Orientierungen loesen
{
 const int maxsuchtiefe=20;
 int i;
 int test=6; //fuer Testausdrucke von Suchtiefe
 bool geloest;
 char loesung[40];
 Wuerfel wuerfel;
 wuerfel.init(hauptfeld);
 //wuerfel.print();//test
 geloest = wuerfel.origeloest();
 if(geloest) {printf("Orientierungen stimmen schon.\n"); m_refresh(); return;}
 wuerfel.deepsearch_init(loesung,40);
 for(i=1;i<=maxsuchtiefe && !geloest;i++)
  {
   if(i>test) {printf("Momentane Suchtiefe: %d\n",i); test=i;}//test
#ifdef MITTHREADS
   if(i<=6) //fuer kleine Suchtiefe braucht es keine Threads
    {
     geloest=wuerfel.orisearch(i);
    }
   else //groessere Suchtiefen auf mehrere Threads aufteilen:
    {
     vorbereitung_deepsearch1(wuerfel);
     std::thread t0(orisearch1,i,0);
     std::thread t1(orisearch1,i,1);
     std::thread t2(orisearch1,i,2);
     std::thread t3(orisearch1,i,3);
     std::thread t4(orisearch1,i,4);
     orisearch1(i,5);
     t0.join();
     t1.join();
     t2.join();
     t3.join();
     t4.join();
     geloest=resultate_deepsearch1(loesung);
    }
#else
   geloest=wuerfel.orisearch(i);
#endif
  }
 if(geloest)
  {
   fuehrende_leerzeichen_loeschen(loesung);
   printf("Loesung fuer Orientierung: %s\n",loesung);
   if(fpziel!=NULL) fprintf(fpziel,"Loesung fuer Orientierung: %s\n",loesung);
   for(char *s=loesung;*s!=0;)
    {
     s=zug_machen(s);
     m_refresh();
     pause1();
    }
  }
 else fprintf(stderr,"Fehler in m_orisolve(): keine Loesung gefunden.\n");
 m_refresh();
}

void m_ecksolve() //nur Ecken loesen
{
 const int maxsuchtiefe=20;
 int i;
 int test=6; //fuer Testausdrucke von Suchtiefe
 bool geloest;
 char loesung[40];
 Wuerfel wuerfel;
 wuerfel.init(hauptfeld);
 //wuerfel.print();//test
 geloest = wuerfel.eckengeloest();
 if(geloest) {printf("Ecken stimmen schon.\n"); m_refresh(); return;}
 wuerfel.deepsearch_init(loesung,40);
 for(i=1;i<=maxsuchtiefe && !geloest;i++)
  {
   if(i>test) {printf("Momentane Suchtiefe: %d\n",i); test=i;}//test
#ifdef MITTHREADS
   if(i<=6) //fuer kleine Suchtiefe braucht es keine Threads
    {
     geloest=wuerfel.ecksearch(i);
    }
   else //groessere Suchtiefen auf mehrere Threads aufteilen:
    {
     vorbereitung_deepsearch1(wuerfel);
     std::thread t0(ecksearch1,i,0);
     std::thread t1(ecksearch1,i,1);
     std::thread t2(ecksearch1,i,2);
     std::thread t3(ecksearch1,i,3);
     std::thread t4(ecksearch1,i,4);
     ecksearch1(i,5);
     t0.join();
     t1.join();
     t2.join();
     t3.join();
     t4.join();
     geloest=resultate_deepsearch1(loesung);
    }
#else
   geloest=wuerfel.ecksearch(i);
#endif
  }
 if(geloest)
  {
   fuehrende_leerzeichen_loeschen(loesung);
   printf("Loesung fuer Ecken: %s\n",loesung);
   if(fpziel!=NULL) fprintf(fpziel,"Loesung fuer Ecken: %s\n",loesung);
   for(char *s=loesung;*s!=0;)
    {
     s=zug_machen(s);
     m_refresh();
     pause1();
    }
  }
 else fprintf(stderr,"Fehler in m_ecksolve(): keine Loesung gefunden.\n");
 m_refresh();
}

void m_twosolve() //2-Stufig loesen
{
 m_orisolve(); //das ist die erste Stufe
 //jetzt sollte es einfacher loesbar sein: Drehungen F, B, L, R, F',B',L' und R' werden nicht mehr benoetigt.
 const int maxsuchtiefe=20;
 int i;
 int test=6; //fuer Testausdrucke von Suchtiefe
 bool geloest;
 char loesung[40];
 Wuerfel wuerfel;
 wuerfel.init(hauptfeld);
 /*
 wuerfel.print();//test
 wuerfel.drehenF2();//test
 printf("drehenF2() gemacht\n");//test
 wuerfel.print();//test
 */
 geloest = (wuerfel==geloesterwuerfel);
 if(geloest) {printf("Schon fertig geloest.\n"); m_refresh(); return;}
 wuerfel.deepsearch_init(loesung,40);
 for(i=1;i<=maxsuchtiefe && !geloest;i++)
  {
   if(i>test) {printf("Momentane Suchtiefe: %d\n",i); test=i;}//test
#ifdef MITTHREADS
   if(i<=8) //fuer kleine Suchtiefe braucht es keine Threads
    {
     geloest=wuerfel.twosearch(i);
    }
   else //groessere Suchtiefen auf mehrere Threads aufteilen:
    {
     vorbereitung_deepsearch1(wuerfel);
     std::thread t0(twosearch1,i,0);
     std::thread t1(twosearch1,i,1);
     std::thread t2(twosearch1,i,2);
     std::thread t3(twosearch1,i,3);
     std::thread t4(twosearch1,i,4);
     twosearch1(i,5);
     t0.join();
     t1.join();
     t2.join();
     t3.join();
     t4.join();
     geloest=resultate_deepsearch1(loesung);
    }
#else
   geloest=wuerfel.twosearch(i);
#endif
  }
 if(geloest)
  {
   fuehrende_leerzeichen_loeschen(loesung);
   printf("Loesung fuer 2.Teil: %s\n",loesung);
   if(fpziel!=NULL) fprintf(fpziel,"Loesung fuer 2.Teil: %s\n",loesung);
   for(char *s=loesung;*s!=0;)
    {
     s=zug_machen(s);
     m_refresh();
     pause1();
    }
  }
 else fprintf(stderr,"Fehler in m_twosolve(): keine Loesung gefunden.\n");
 m_refresh();
}

static int tut_i=2,tut_status=0;

void tut_zufallszuege()
{
 int j,m,mvorher=0;
 for(j=0;j<tut_i;j++)
  {
   do {m=zufallszug(hauptfeld);}
   while((m&0xFF)==(mvorher&0xFF));
   drehung(hauptfeld,m&0xFF,m>>8); m_refresh(); //Drehung machen
   pause1();
  }
 printf("Es wurden %d zufaellige Drehungen gemacht.\n",tut_i);
 printf("Versuchen Sie es wieder zurueckzudrehen.\n");
}

void m_tutspiel()
{
 int ok;
 ok=requester_input(1,"Anzahl Zufallszuege beim Start (0=stoppen)","%d","%d",&tut_i);
 if(ok)
  {
   if(tut_i==0) {tut_status=0; m_refresh(); return;}
   tut_zufallszuege();
   tut_status=1;
  }
 m_refresh();
}

void m_bestmov()
{
 int ok,c,n,m,wert;
 static int suchtiefe=3;
 ok=requester_input(1,"Suchtiefe","%d","%d",&suchtiefe);
 if(ok)
  {
   m=bestmov(hauptfeld,suchtiefe,&wert);
   c=m&0xFF;
   n=m>>8;
   drehung(hauptfeld,c,n);
   if(wert==0) printf("loesbar in %d oder weniger Zuegen\nErster Zug: ",suchtiefe);
   else printf("vermutlich bester Zug: ");
   zugdrucken(m&0xFF,m>>8,'\n');
  }
 m_refresh();
}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 quellname[0]=zielname[0]=0;
 int i,j,c;
 int breite,hoehe,tiefe,visklasse;
 if(argc<=0)
   j=0;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("rubik  %s\n",VERSION);
	 printf("Anwendung: rubik [-flags] [Quelle] [Ziel]\n");
	 printf("  flags: a=automatisch loesen\n");
	 printf("         a1=automatisch loesen, ohne zusaetzliche Threads\n");
	 exit(0);
	}
 hauptfeld_init();
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 if(breite*4 > hoehe*5) breite=hoehe*5/4;
 setsize(breite,hoehe,tiefe);
 setmenu(4,"File",   "Edit",  "Spiel",  "Analyse");
 setmenu(4,"About","Darstellung der Abwicklung...","Tutorial-Spiel","Bester Zug suchen...",
	 &m_about,&m_abwicklung,&m_tutspiel,&m_bestmov);
 setmenu(4,"Load...","Automatisch loesen",NULL,"Optimal loesen",&m_load,&m_solve,NULL,&m_solvebest);
 setmenu(4,"Save...","Refresh",NULL,           "Loesen ohne Threads",&m_save,&m_refresh,NULL,&m_solvebest1);
 setmenu(4,"Exit",   NULL,NULL,                "nur Orientierung loesen",&menu_exit,NULL,NULL,&m_orisolve);
 setmenu(4,NULL,     NULL,NULL,                "nur Ecken loesen",       NULL,      NULL,NULL,&m_ecksolve);
 setmenu(4,NULL,     NULL,NULL,                "Zweistufig loesen",      NULL,      NULL,NULL,&m_twosolve);
 set_funktions(pre,rel,verd,mot);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */

#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0x7F7F7F); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif

 wuerfel_zeichnen();
 abwicklung_zeichnen(abw_x0=500,abw_y0=30);
 term_refresh();

 if(j==2)
  {
   if((fpziel=fopen(zielname,"r"))!=NULL)
    {printf("Zieldatei '%s' schon vorhanden. Nicht gespeichert.\n",zielname); fclose(fpziel); fpziel=NULL;}
   else if((fpziel=fopen(zielname,"w"))==NULL)
    {printf("Kann Zieldatei '%s' nicht oeffnen.\n",zielname);}
   else
    {
     printf("Zieldatei '%s' geoeffnet.\n",zielname);
    }
  }
 if(j>=1)
  {
   dateiladen(quellname);
   m_refresh();
  }
 if(argflag['A'])
  {
   if(fpziel!=NULL)
    {
     if(thread1flag) m_solvebest1();
     else m_solvebest();
     fclose(fpziel);
    }
   else fprintf(stderr,"Fehlende Zieldatei.\n");
   term_exit();
   return 0;
  }

 while(exitflag==0 && waitmenu(0)==0) // auf Benutzereingaben warten
  {
   waitBOF();
   if(tut_status!=0)
    {
     int wert=bewertung(hauptfeld);
     if(wert==0)
      {
       printf("Bravo %d Drehungen geloest.\n",tut_i);
       for(int i=0;i<200;i++) waitBOF(); //kurze Pause
       tut_i++;
       tut_zufallszuege();
      }
    }
  }

 term_exit();
 if(fpziel!=NULL) fclose(fpziel);
 return 0;
}/* ende von main */

void lin(double x0,double y0,double x1,double y1)
{
 plot(x0,y0,PENUP); plot(x1,y1,PENDOWN);
}

void linie(double x0,double y0,double x1,double y1,double x2,double y2)
{
 plot(x0,y0,PENUP); plot(x1,y1,PENDOWN); plot(x2,y2,PENDOWN);
}

void filldrawbox(double x1,double y1,double x2,double y2)
{
 fillbox(x1,y1,x2,y2);
#if(TIEFE==24)
 rgbcolor(0x00,0x00,0x00); // Schwarz fuer Linien
#else
 color(0);
#endif
 drawbox(x1,y1,x2,y2);
}

void mytrapez(double x1,double y1)
{
 double x,y,x2,y2,y3;
 x2=x1+zf*kante;
 for(x=x1,y=y1; x<x2; x+=1,y+=1)
  {
   lin(x,y, x,y+kante);
  }
#if(TIEFE==24)
 rgbcolor(0,0,0); //schwarz
#else
 color(0);
#endif
 y2=y1+kante;
 y3=y2+zf*kante;
 linie(x1,y1, x1,y2, x2,y3);
 linie(x1,y1, x2,y1+zf*kante, x2,y3);
}

void mytrapezy(double x1,double y1)
{
 double x,y,x2,y2,x3;
 y2=y1+zf*kante;
 for(x=x1,y=y1; y<y2; x+=1,y+=1)
  {
   lin(x,y, x+kante,y);
  }
#if(TIEFE==24)
 rgbcolor(0,0,0); //schwarz
#else
 color(0);
#endif
 x2=x1+kante;
 x3=x2+zf*kante;
 linie(x1,y1, x2,y1, x3,y2);
 linie(x1,y1, x1+zf*kante,y2, x3,y2);
}

void wuerfel_zeichnen()
{
 int i,j;
 double x,y,z,s;

 //Umrisse des grossen Wuerfels zeichnen:
 s=kante*3; //Seitenlaenge des grossen Wurfels
 d3_drawbox(0,0,0, s,s,0); //vorderes Quadrat
 d3_drawbox(s,0,0, s,s,s); //rechtes Quadrat
 d3_drawbox(0,s,0, s,s,s); //oberes Quadrat

 for(j=0; j<3; j++)
 for(i=0; i<3; i++)
   {
    x=i*kante; y=j*kante; //Vorderes Quadrat zeichnen
    hauptfeld[3+i+j*18].zeichnen3d(x,y,0);
    y=j*kante; z=i*kante; //Rechtes Quadrat zeichnen
    hauptfeld[5*3+i+j*18].zeichnen3d(s,y,z);
    z=j*kante; x=i*kante; //Oberes Quadrat zeichnen
    hauptfeld[2*3+i+j*18].zeichnen3d(x,s,z);
   }
}

void abwicklung_zeichnen(double x0,double y0)
{
 double s=3*kante;
 double x,y;
 int i,j,k;
 if(abwickvariante==2)
  { //Abwicklung mit Upper in der Mitte des Kreuzes
   for(j=0;j<3;j++)
   for(i=0;i<3;i++)
   for(k=0;k<6;k++) //entspricht: D F U B L R
    {
     if(k<4)
      {
       x=x0+s; y=y0+s*k;
       x += i*kante;
       y += j*kante;
       hauptfeld[i+k*3+j*18].zeichnen(x,y);
      }
     else if(k==4) // L
      {
       x=x0; y=y0+s*3;
       x += j*kante;
       y -= (i+1)*kante;
       hauptfeld[i+k*3+j*18].zeichnen(x,y);
      }
     else //if(k==5) // R
      {
       x=x0+s*3; y=y0+s*2;
       x -= (j+1)*kante;
       y += i*kante;
       hauptfeld[i+k*3+j*18].zeichnen(x,y);
      }
    }
   for(i=0,x=x0+s;i<4;i++) //Umrandung der 4 grossen Vierecke uebereinander
    {
     y=y0+s*i;
     drawbox(x+1,y+1,x+s-1,y+s-1);
    }
   for(i=0,y=y0+s*2;i<3;i+=2) //Umrandung der beiden grossen Vierecke L u. R
    {
     x=x0+s*i;
     drawbox(x+1,y+1,x+s-1,y+s-1);
    }
  }
 else //Abwicklung mit Front in der Mitte des Kreuzes
 {
 for(j=0;j<3;j++)
 for(i=0;i<3;i++)
 for(k=0;k<6;k++) //entspricht: D F U B L R
  {
   if(k<4) {x=x0+s;             y=y0+s*k;}
   else    {x=(k==4)?x0:x0+s*2; y=y0+s;}
   x += i*kante;
   y += j*kante;
   hauptfeld[i+k*3+j*18].zeichnen(x,y);
  }
 for(i=0,x=x0+s;i<4;i++)
  {
   y=y0+s*i;
   drawbox(x+1,y+1,x+s-1,y+s-1);
  }
 for(i=0,y=y0+s;i<3;i+=2)
  {
   x=x0+s*i;
   drawbox(x+1,y+1,x+s-1,y+s-1);
  }
 }
}

void neuzeichnen()
{
 inital_new();
 wuerfel_zeichnen();
 abwicklung_zeichnen(abw_x0,abw_y0);
 term_refresh();
}

void pre()  //wird beim Druecken einer Maustaste aufgerufen (press mouse)
{
 double x,y,x1,x2,y1,y2,y3;
 char c;
 int n;
 n=mausposition(&x,&y);
 if(n&LIMAUS) n=3; //mit Linker Taste nach Links drehen
 else if(n&REMAUS) n=1; //mit rechter Taste nach rechts
 else n=2; //oder mit mittlerer Taste 2 mal nach rechts
 //printf("pre() x=%f y=%f n=%d\n",x,y,n);//test
 if(x<abw_x0 || y<abw_y0) return; //Klicks ausserhalbe der Abwicklung ignorieren
 double s=3*kante;
 if(x>abw_x0+s*3 || y>abw_y0+s*4) return; //Klicks ausserhalbe der Abwicklung ignorieren
 x1=abw_x0+s;
 x2=x1+s;
 y1=abw_y0+s;
 y2=y1+s;
 y3=y2+s;
 if(abwickvariante==2)
  {
   if(x>=x1 && x<=x2)
    {
     if(y<y1) c='D';
     else if(y>y3) c='B';
     else if(y>y2) c='U';
     else c='F';
    }
   else if(y>y3 || y<y2) return;
   else if(x<x1) c='L';
   else c='R';
  }
 else
  {
   if(y<y1 && x>x1 && x<x2) c='D';
   else if(y>y2 && x>x1 && x<x2) c=(y>y3)?'B':'U';
   else if(y>y2 || y<y1) return;
   else if(x<x1) c='L';
   else if(x<x2) c='F';
   else c='R';
  }
 zugdrucken(c,n,'\n');
 drehung(hauptfeld,c,n);
 neuzeichnen();
}

void rel()  //wird beim Loslassen einer Maustaste aufgerufen (release mouse)
{
}
void verd()  //wird z.B. nach Verdeckung des Fensters aufgerufen
{
}
void mot()  //wird beim Bewegen des Mauszeigers aufgerufen (motion of mouse)
{
}

/***************************** 3D-Grafik ******************************/

void projekt(double x,double y,double z,double *xs,double *ys) // Projektion von xyz-Punkten in die xy-Ebene
{
 double A=1500; // Abstand vom Beobachter zum Bildschirm (ev. noch anpassen)
 double vfakt=A/(A+z); // Verkuerzungsfaktor durch Beobachtungsabstand
 double vfakt2=A/(A+z/2); // Verkuerzung von Strecken in z-Richtung
 //double zfx=sqrt(0.5)*cos(alfa); // Perspektivische Verkuerzung in z-Richtung (mit alfa=45 Grad immer 0.5)
 //double zfy=sqrt(0.5)*sin(alfa); // Perspektivische Verkuerzung in z-Richtung (mit alfa=45 Grad immer 0.5)
 const double zfx=0.5, zfy=0.5;
 *xs = per_x0 + x*vfakt + zfx*vfakt2*z;
 *ys = per_y0 + y*vfakt + zfy*vfakt2*z;
}

void d3_drawbox(double x1,double y1,double z1,double x2,double y2,double z2)
{
 double xa,ya,xb,yb,xc,yc,xd,yd; // fuer 4 Eckpunkte
 projekt(x1,y1,z1, &xa,&ya); //Eckpunkt unten links
 projekt(x2,y2,z2, &xb,&yb); //Eckpunkt oben rechts
 if(z1==z2)
  {
   xc=xb; yc=ya; //Eckpunkt unten rechts
   xd=xa; yd=yb; //Eckpunkt oben links
  }
 else if(x1==x2)
  {
   projekt(x1,y1,z2, &xc,&yc); //Eckpunkt unten rechts
   projekt(x1,y2,z1, &xd,&yd); //Eckpunkt oben links
  }
 else if(y1==y2)
  {
   projekt(x2,y1,z1, &xc,&yc); //Eckpunkt unten rechts
   projekt(x1,y1,z2, &xd,&yd); //Eckpunkt oben links
  }
 else
  {
   printf("Fehler in d3_drawbox: Viereck liegt nicht in einer Koordinatenebene:\n");
   printf("  x1=%f y1=%f z1=%f  x2=%f y2=%f z2=%f\n",x1,y1,z1,x2,y2,z2);
   return;
  }
 plot(xa,ya,PENUP); plot(xc,yc,PENDOWN); plot(xb,yb,PENDOWN);
 plot(xd,yd,PENDOWN); plot(xa,ya,PENDOWN);
}

void d3filldrawbox(double x1,double y1,double z1,double x2,double y2,double z2)
{
 //printf("d3filldrawbox(%f,%f,%f, %f,%f,%f)\n",x1,y1,z1,x2,y2,z2);//test
 double xa,ya,xb,yb,xc,yc,xd,yd; // fuer 4 Eckpunkte
 projekt(x1,y1,z1, &xa,&ya); //Eckpunkt unten links
 projekt(x2,y2,z2, &xb,&yb); //Eckpunkt oben rechts
 if(z1==z2)
  {
   for(;ya<yb;ya+=1) lin(xa,ya, xb,ya);
  }
 else if(x1==x2)
  {
   projekt(x1,y1,z2, &xc,&yc); //Eckpunkt unten rechts
   projekt(x1,y2,z1, &xd,&yd); //Eckpunkt oben links
   double d=(yb-yc)/(yd-ya);
   for(;ya<yd;ya+=1,yc+=d) lin(xa,ya, xc,yc);
  }
 else if(y1==y2)
  {
   projekt(x2,y1,z1, &xc,&yc); //Eckpunkt unten rechts
   projekt(x1,y1,z2, &xd,&yd); //Eckpunkt oben links
   double d=(xb-xd)/(xc-xa);
   for(;xa<xc;xa+=1,xd+=d) lin(xa,ya, xd,yd);
  }
 else
  {
   printf("Fehler in d3filldrawbox: Viereck liegt nicht in einer Koordinatenebene:\n");
   printf("  x1=%f y1=%f z1=%f  x2=%f y2=%f z2=%f\n",x1,y1,z1,x2,y2,z2);
   return;
  }

#if(TIEFE==24)
 rgbcolor(0,0,0); //schwarz
#else
 color(0);
#endif
 d3_drawbox(x1,y1,z1, x2,y2,z2);
}

/******************* Unterprogramme fuer Analyse **********************/
/*
 Darstellung eines Zuges in einem int:
   unterste 8 Bits: c=m&0xFF  'D','F','U','B','L', oder 'R'
   9.-10. Bit: n=c>>8  1=rechts, 2=zwei mal, 3=links

 Bewertung der Stellung:
   0=geloester Wuerfel
   hoeherer Wert ist staerker gemischelt

*/
static int moegliche_zuege[18]=
 {'D'+0x100,'F'+0x100,'U'+0x100,'B'+0x100,'L'+0x100,'R'+0x100, //Drehungen nach rechts
  'D'+0x200,'F'+0x200,'U'+0x200,'B'+0x200,'L'+0x200,'R'+0x200, //nach links
  'D'+0x300,'F'+0x300,'U'+0x300,'B'+0x300,'L'+0x300,'R'+0x300  //um 180 Grad drehen
 };

int bewertung(Rub *feld)
{
 int i,wert=0;
 for(i=0;i<6*9;i++)
  if(feld[i]!=grundstellung[i]) wert++;
 return wert;
}

class Spielfeld
{
 Rub feld[6*9];
public:
 Spielfeld(Rub *f) {for(int i=0;i<6*9;i++) feld[i]=f[i];}
 void zug(int m);    //entsprechende Drehung machen
 void invzug(int m); //Inverse Drehung, also zurueckdrehen
 int bewert(); //Bewertung der Stellung, 0=geloest, 1=1 Feld differenz,...
};

int Spielfeld::bewert()
{
 int wert=0;
 for(int i=0;i<6*9;i++)
   if(feld[i].farb!=grundstellung[i].farb) wert++;
 return wert;
}

void Spielfeld::zug(int m)
{
 int n=m>>8;
 drehung(feld,m&0xFF,n);
}

void Spielfeld::invzug(int m)
{
 int n=4-(m>>8);
 drehung(feld,m&0xFF,n);
}

bool gegenueberliegend(uint8 v1,uint8 v2)
{
 //Optimiert durch Tabelle mit gegenueberliegenden Seiten:
 //                     {'B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U'};
 static uint8 tabelle[]={'F','C','U','E','B','G','H','I','J','K','R','M','N','O','P','Q','L','S','T','D'};
 return tabelle[v1-'B']==v2;
}

int bestmov(Spielfeld& feld,int suchtiefe,int *pwert,uint8 vorher,uint8 vorher2)
   //Rueckgabe ist bester Zug, pwert ist Bewertung nach allen Zuegen
   //vorher ist die Seite des letzten Zugs (fuer Optimierungen)
   //vorher2 ist die Seite des vorletzten Zugs
{
 //provi. optimierbar: wird viel schneller sein wenn Klasse Wuerfel verwendet wird
 int j,m,bestm=0,wert;
 uint8 v,v2;
 *pwert=feld.bewert();
 for(j=0;j<18 && *pwert!=0;j++)
    {
     m=moegliche_zuege[j];
     if((v=m&0xFF)==vorher) continue; //nochmals gleiche Seite wie gerade zuvor macht keinen Sinn
     if(v==vorher2) continue; //gleiche Seite wie 2 Zuege zuvor wenn es gegenueberliegende Seite war
     feld.zug(m);
     wert=feld.bewert();
     if(wert < *pwert || bestm==0) {*pwert=wert; bestm=m;}
     feld.invzug(m);
    }
 if(*pwert==0) return bestm;//mit 1 Zug geloest
 if(suchtiefe<=1) return bestm;
 for(j=0;j<18 && *pwert!=0;j++)
    {
     m=moegliche_zuege[j];
     if((v=m&0xFF)==vorher) continue; //nochmals gleiche Seite wie gerade zuvor macht keinen Sinn
     if(v==vorher2) continue; //gleiche Seite wie 2 Zuege zuvor wenn es gegenueberliegende Seite war
     feld.zug(m);
     v2 = gegenueberliegend(v,vorher) ? vorher : 0;
     bestmov(feld,suchtiefe-1,&wert,v,v2);
     if(wert < *pwert) {*pwert=wert; bestm=m;}
     feld.invzug(m);
    }
 return bestm;
}

int bestmov(Rub *feld,int suchtiefe,int *pwert)
{
 int m;
 Spielfeld sp(feld);
 m=bestmov(sp,suchtiefe,pwert,0,0);
 return m;
}

int zufallszug(Rub *feld)
{
 int j,m;
 j=int(zufall()*18.0);
 if(j==18) j=17;
 m=moegliche_zuege[j];
 return m;
}
