;; glcd.asm  Grafik-LCD-Modul ansteuern
;; Anwendung: .include "glcd.asm" im Hauptprogramm

lcd_cmd:	;void lcd_cmd(char cmd)
;	cbi PORTD, 2
	rcall microwait1
lcd_send:	; lcd_send(char data) ;r16=data
	ret

;; GLCD-Port definieren:
.equ LCD_PORT = PORTD
.equ LCD_DDR  = DDRD
.equ DI  = 2
.equ RW  = 3
.equ EN  = 4
.equ CS1 = 5
.equ CS2 = 6
.equ RST = 7
;; GLCD-Datenport:
.equ LCD2_PORT = PORTC
.equ LCD2_PIN  = PINC
.equ LCD2_DDR  = DDRC

;; Daten die in c global mit static definiert sind:
.equ glcd_cs = glcd_datenA	;static char glcd_cs=CS1

lcd_init:
glcd_init:
	push r16
	push r17
	cli
	in r16, LCD_DDR
	ori r16, 0xFC
	out LCD_DDR, r16	;Steuer-Port mindestens obere 6 Bits Ausgaenge
	in r16, LCD_PORT
	andi r16, 3
	ori r16, 0xE0
	out LCD_PORT, r16	;RST,CS1,CS2 auf H; E,R/W,D/I auf L
	sei
	clr r16
	out LCD2_DDR, r16	;Daten-Port auf Eingang
	cbi LCD_PORT, RST	;Reset ausfuehren (RST ist L-aktiv)
	ldi r16, 10
	rcall microwait		;etwa 10usec warten
	sbi LCD_PORT, RST	;RST-Bit wieder auf H
	ldi r16, CS1
	rcall glcd_wait		;auf Bereitschaft von CS1 warten
	ldi r16, CS2
	rcall glcd_wait		;auf Bereitschaft von CS2 warten
	ldi r16, 0x3F
	ldi r17, CS1
	rcall glcd_command	;Display ON
	ldi r16, 0x3F
	ldi r17, CS2
	rcall glcd_command	;Display ON
	clr r16
	rcall glcd_clear
	pop r17
	pop r16
	ret

glcd_wait:		; r16=cs
	push r17	;char a;
	push r18
	mov r18, r16
	clr r16
	out LCD2_DDR, r16	;Daten-Port auf Eingang
	cbi LCD_PORT, DI	;Instruction 
	sbi LCD_PORT, RW	;Read
glcd_wait_1:
	cpi r18, CS1
	brne glcd_1
	cbi LCD_PORT, CS1	;Select CS1
	rjmp glcd_2
glcd_1:	cbi LCD_PORT, CS2	;Select CS2
glcd_2:	sbi LCD_PORT, EN	;Enable
	rcall microwait1
	in r17, LCD2_PIN	;a=LCD2_PIN
	cbi LCD_PORT, EN	;Enable aus
	cpi r18, CS1
	brne glcd_3
	sbi LCD_PORT, CS1	;Select CS1 aus
	rjmp glcd_4
glcd_3:	sbi LCD_PORT, CS2	;Select CS2 aus
glcd_4:	andi r17, 0x80		;while((a & 0x80)!=0);
	brne glcd_wait_1
	pop r18
	pop r17
	ret

glcd_command:		;r16=a, r17=cs (char a,char cs)
	push r17
	push r18		; r18=a
	mov r18, r16
	sts glcd_cs, r17	;glcd_cs=cs
	cbi LCD_PORT, DI	;Instruction
	cbi LCD_PORT, RW	;Write
	ldi r16, 0xFF
	out LCD2_DDR, r16	;Port A auf Ausgang
	out LCD2_PORT, r18	;PORTA=a
;; LCD_PORT &= ~(1<<cs); //Select CS1 oder CS2
	cpi r17, CS1
	brne glcd_5
	cbi LCD_PORT, CS1	;Select CS1
	rjmp glcd_6
glcd_5:	cbi LCD_PORT, CS2	;Select CS2
glcd_6:
	rcall microwait1
	sbi LCD_PORT, EN	;Enable
	rcall microwait1
	cbi LCD_PORT, EN	;Enable aus
;;  LCD_PORT |= (1<<cs); //Select1 aus
	cpi r17, CS1
	brne glcd_7
	cbi LCD_PORT, CS1	;Select CS1
	rjmp glcd_8
glcd_7:	cbi LCD_PORT, CS2	;Select CS2
glcd_8:
	mov r16, r17
	rcall glcd_wait(cs);
	pop r18
	pop r17
	ret

glcd_data:		; r16=a
	push r17
	push r18
	lds r17, glcd_cs	;char cs=glcd_cs;
	sbi LCD_PORT, DI	;Data
	cbi LCD_PORT, RW	;Write
	ldi r18, 0xFF
	out LCD2_DDR, r18	;Port A auf Ausgang
	out LCD2_PORT, r16	;Port A = a
;; LCD_PORT &= ~(1<<cs); //Select1
	cpi r17, CS1
	brne glcd_9
	cbi LCD_PORT, CS1	;Select CS1
	rjmp glc_10
glcd_9:	cbi LCD_PORT, CS2	;Select CS2
glc_10:
	rcall microwait1
	sbi LCD_PORT, EN	;Enable
	rcall microwait1
	cbi LCD_PORT, EN	;Enable aus
;; LCD_PORT |= (1<<cs); //Select1 aus
	cpi r17, CS1
	brne glcd_7
	cbi LCD_PORT, CS1	;Select CS1
	rjmp glcd_8
glcd_7:	cbi LCD_PORT, CS2	;Select CS2
glcd_8:
	mov r16, r17
	rcall glcd_wait(cs);
	pop r18
	pop r17
	ret
