
unsigned char glcd_readdata()
{
 unsigned char a;
 char cs=glcd_cs,i;
 LCD_PORT |= (1<<DI); //Data
 LCD_PORT |= (1<<RW); //Read
 LCD2_DDR=0x00; //Port A auf Eingang
 LCD_PORT &= ~(1<<cs); //Select1
 microwait(1);
 LCD_PORT |= (1<<EN); //sbi(PORTC,4); Enable
 microwait(1);
 a=LCD2_PIN;
 LCD_PORT &= ~(1<<EN); //cbi(PORTC,4);
 LCD_PORT |= (1<<cs); //Select1 aus
 glcd_wait(cs);
 return a;
}

void glcd_clear(char farbe)
{
 char i,x,cs;
 if(farbe!=0) farbe=0xFF;
 //farbe=0x0F;//test: Teststreifen beim Einschalten
 for(cs=CS1;cs<=CS2;cs+=CS2-CS1)
  {glcd_command(0x40,cs); //y-Start
   for(x=0;x<8;x++)
    {glcd_command(0xB8+x,cs); //x-Start
     for(i=0;i<64;i++) glcd_data(farbe);
    }
  }
}

void glcd_init()
{
 cli();
 LCD_DDR |= 0xFC; //PORTC mindestens obere 6 Bits Ausgaenge
 LCD_PORT=(LCD_PORT&3)|0xE0; //RST,CS1,CS2 auf H; E,R/W,D/I auf L
 sei();
 LCD2_DDR=0; //Port A auf Eingang
 LCD_PORT &= ~(1<<RST); //cbi(PORTC,7); Reset ausfuehren
 microwait(10);
 LCD_PORT |= (1<<RST); //sbi(PORTC,7);
 glcd_wait(CS1);
 glcd_wait(CS2);
 glcd_command(0x3F,CS1); //Display ON
 glcd_command(0x3F,CS2); //Display ON
 glcd_clear(0);
}

void glcd_punkt(char x,char y,char farbe)
{
 char cs;
 unsigned char a,maske;
 y=63-y; //if(y>63) y=63; else if(y<0) y=0;
 maske = 1<<(y&7);
 y >>= 3;
 if(x>=64) {cs=CS1; x-=64;}
 else cs=CS2;
 glcd_command(0x40+x,cs); //y-Start
 glcd_command(0xB8+y,cs); //x-Start
 glcd_readdata();//dummy-read
 a=glcd_readdata();
 if(farbe==0) a &= ~maske; //Pixel loeschen
 else if(farbe==1) a |= maske; //Pixel setzen
 else a ^= maske; //bei farbe==2 Pixel umkehren
 glcd_command(0x40+x,cs); //y-Start
 glcd_data(a);
}

const int fontbreite=6, fonthoehe=8;
#include "6x8_vertikal_LSB_1a.h"
/* const char font[128][6]={
...
{0x00,0x00,0x42,0x7F,0x40,0x00},	// 0x31
...
};
*/

static int glcd_x0=0, glcd_y0=0;

void glcd_goto(int row,int col)
{
 //const int x8=(fontbreite+7)/8*8; //auf durch 8 teilbare Zahl aufgerundet
 const int x8=fontbreite; //Variante ohne Rundung
 glcd_x0=(col*x8) & 127; //Breite auf 128 beschraenkt
 glcd_y0=(row*fonthoehe) & 63; //Hoehe auf 64 beschraenkt
}

void glcd_write(char c)
{
 char cs,i;
 int ypage,x;
 ypage=glcd_y0/8;
 //y=glcd_x0&0x07; //untere 3 Bits
 c &= 0x7F;
 if(glcd_x0<64) {cs=CS2; x=glcd_x0&0x3F;}
 else {cs=CS1;  x=(glcd_x0-64)&0x3F;}
 glcd_command(0xB8+ypage,cs); //x-Start (senkrecht auf Display)
 glcd_command(0x40+x,cs); //y-Start (waagrecht auf Display)

 /* Variante mit Aufrundung: * /
 for(i=0;i<fontbreite;i++)
    {glcd_data(font[c][i]);
    }
 for(;i<8;i++)
    {glcd_data(0);
    }
 glcd_x0 += 8;
 /* Variante ohne Aufrundung: */
 for(i=0;i<fontbreite;i++)
    {if(i>0 && glcd_x0+i==64) //Wechsel auf rechte Display-Haelfte
       {glcd_command(0xC0,cs); //Display-Data
	glcd_command(0xB8+ypage,cs=CS1); //x-Start = ypage
	glcd_command(0x40,cs); //y-Start = 0
       }
     glcd_data(font[c][i]);
    }
 glcd_x0 += fontbreite;
 /* */

 glcd_command(0xC0,cs); //Display-Data
 if(glcd_x0==128) glcd_x0=0;
}

void glcd_write1(char c)
{
 char cs,i;
 int ypage,x;
 ypage=glcd_y0/8;
 c &= 0x7F;
 if(glcd_x0<64) {cs=CS2; x=glcd_x0&0x3F;}
 else {cs=CS1;  x=(glcd_x0-64)&0x3F;}
 glcd_command(0xB8+ypage,cs); //x-Start (senkrecht auf Display)
 glcd_command(0x40+x,cs); //y-Start (waagrecht auf Display)
 for(i=0;i<fontbreite;i++)
    {if(i>0 && glcd_x0+i==64) //Wechsel auf rechte Display-Haelfte
       {glcd_command(0xC0,cs); //Display-Data
	glcd_command(0xB8+ypage,cs=CS1); //x-Start = ypage
	glcd_command(0x40,cs); //y-Start = 0
       }
     glcd_data(font[c][i]);
    }
 glcd_x0 += fontbreite;
 glcd_command(0xC0,cs); //Display-Data
 if(glcd_x0==128) glcd_x0=0;
}

void glcd_write(const char *text)
{
 char c;
 while((c= *text++)!=0)
  glcd_write1(c);
}

void glcd_test(char farbe)
{
 unsigned char x,y;
 for(x=0;x<128;x++)
  {if(x<64) y=x; else y=127-x;
   glcd_punkt(x,y,farbe);
  }
}
void glcd_test2()
{
 glcd_goto(4,2);
 glcd_write("123 Hallo Welt");
}
