/* schach.cc			letzte Aenderung: 13.11.2016
 dies ist das Hauptprogramm unter Linux
 ausfuehrlichere Beschreibungen siehe:
   ../avr/schachavr/Liesmich.txt und kartonschach.cc
*/

#define VERSION "Version 1.0"

/*
Uebersetzen unter Unix (Linux):
> make  ;siehe makefile

History:
30.8.2016	 Erstellung (RP)
16.10.2016	 AVR-Variante
27.10.2016       Fehlerkorrekturen
31.10.           auslagerung des Hauptteils in schach-engine.cc
9.11.            spielerzug() ins Hauptprogramm verschoben
13.11.2016  1.0  aktualisierte schach-engine von schachavr uebernommen

*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <ctype.h>
#include <string.h>

/******************** Hauptteil des Programms *************************/
#include "schach-engine.h"

static int8_t spielsuchtiefe=0;

void hilfe()
{
 printf("help oder hilfe eingegeben\n");
#ifdef BAUERNSPIEL
 printf("Provisorische Regeln fuer Bauernspiel:\n");
 printf("Wer zuerst mit einem Bauern die gegenrische Grundlinie erreicht gewinnt.\n");
 printf("Sonst, wenn kein gueltiger Zug mehr moeglich ist, ist unentschieden.\n");
#endif
 printf("Das Eingabeformat ist XN-YM wobei XN die Startposition und YM die Zielposition\n");
 printf("der gezogenen Figur ist. (Das - Zeichen kann auch weggelassen werden)\n");
 printf("Mit Eingabe von '?' kann die momentane Stellung angezeigt werden.\n");
 printf("Bei Rochade wird nur der Koenigszug angegeben.\n");
 printf("Eingabe bei Bauerumwandlung: XNYMZ wobei Z die neue Figur ist.\n");
 printf("Abkuerz. fuer Figuren: T=Turm, L=Laeufer, S=Springer, D=Dame, K=Koenig, B=Bauer.\n");
 printf("Englische Figuren-Abk: R=Turm, B=Laeufer, N=Springer, Q=Dame, K=Koenig, P=Bauer.\n");
}

Zug spielerzug(Brett& brett,uchar farbe)
{
 Zugliste zugliste;
 Zug zug;
 char mzug[80];
 static int8_t startflag=1;
 alle_moeglichen_zuege(brett,farbe,&zugliste,0);
 if(zugliste.istleer()) {zug.von=zug.nach=0; return zug;}//kein Zug mehr moeglich
 for(;;)
  {
   uchar von,nach,i;
   uchar errflag=0;
   printf("Dein Zug: "); scanf("%s",mzug);
   if(mzug[0]=='?') {brett.print(); continue;}
   if(mzug[0]=='h' && (mzug[1]=='e' || mzug[1]=='i')) {hilfe(); continue;}
   for(i=0;mzug[i]!=0;i++) if(islower(mzug[i])) mzug[i] -= 'a'-'A';
   if(mzug[0]<'A' || mzug[0]>'H' || mzug[1]<'1' || mzug[1]>'9') errflag=1;
   else
    {
     for(i=2;i<10 && !isalnum(mzug[i]);i++) {}
     if(mzug[i]<'A' || mzug[i]>'H' || mzug[i+1]<'1' || mzug[i+1]>'9') errflag=1;
     else
      {
       von = mzug[0]-'A' + (mzug[1]-'1')*8;
       nach = mzug[i]-'A' + (mzug[i+1]-'1')*8;
       zug.set(von,nach);
       if(isalpha(mzug[i+2])) //Bauerumwandlung?
	{
	 int c=toupper(mzug[i+2]);
	 switch(c)
	  {case 'D': case 'Q': zug.setpromo(DAME); break;
	   case 'S': case 'N': zug.setpromo(SPRINGER); break;
	   case 'L': case 'B': zug.setpromo(LAEUFER); break;
	   case 'T': case 'R': zug.setpromo(TURM); break;
	  }
	}
       if(zugliste.zugsuchen(zug)==NULL) errflag=2; //ungueltig wenn nicht in Liste vorhanden
      }
    }
   if(errflag==0) break;
   if(errflag!=0 && startflag!=0)
    {
     printf("zum Stellung anzeigen: ? eingeben\n");
     printf("sonst Zug eingeben: Starposition-Zielposition\n");
     --startflag;
    }
   if(errflag==1)
     printf("Eingabefehler - Eingabe-Beispiel: E2-E4 oder ? zum Stellung zeigen\n");
   if(errflag==2) printf("Ungueltiger Zug\n");
  }
 return zug;
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(const char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='T')
    {
     if((c= *s)!=0 && isdigit(c)) {spielsuchtiefe=c-'0'; s++;}
    }
  }
}

/************************* Hauptprogramm ******************************/
void fertig(const char *str); //Vordeklaration

int main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 //FILE *fp1,*fp2;
 int i,j,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
  {// es wurde von WorkBench (GUI, Desktop, ...) gestartet
   j=0;
  }
 else
  {// es wurde von Shell (Terminal, Konsole, ...) gestartet
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j>MAXARG)
	{printf("schach  %s\n",VERSION);
	 printf("Anwendung: schach [-Flags] [Quelle] [Ziel]\n");
	 printf(" Flags: t = Suchtiefe setzen (0 bis 9)\n");
	 printf("        w = Computer hat weiss\n");
	 printf("        b = Computer hat schwarz (black)\n");
	 exit(0);
	}
 if(!argflag['T']) spielsuchtiefe=3;//voreingestellte Suchtiefe

 int computerfarbe,spielerfarbe;
 Zug zug;
 printf("Suchtiefe=%d\n",spielsuchtiefe);//test
 spielbrett.grundstellung();
 if(argflag['W'])
  {
   computerfarbe=WEISS;
   spielerfarbe=SCHWARZ;
  }
 else if(argflag['B'])
  {
   computerfarbe=SCHWARZ;
   spielerfarbe=WEISS;
  }
 else
  {
   zug=besterzug(spielbrett,WEISS,spielsuchtiefe);
   printf("Bester erster Zug: %s\n",zug.print());
   computerfarbe= -1;//test
  }

 if(computerfarbe>=0)
  {
   if(spielerfarbe==WEISS)
    {
     zug=spielerzug(spielbrett,spielerfarbe);
     zug_wirklich_machen(spielbrett,zug);
    }
   for(;;)
    {
     zug=besterzug(spielbrett,computerfarbe,spielsuchtiefe);
     if(zug.von==zug.nach) {fertig("Computer kann keinen Zug mehr machen - Unentschieden"); break;}
     zug_wirklich_machen(spielbrett,zug);
     printf("Computer: %s\n",zug.print());
     if(spielbrett.gewonnen(computerfarbe)) {fertig("Schachmatt - Computer hat gewonnen"); break;}
     zug=spielerzug(spielbrett,spielerfarbe);
     if(zug.von==zug.nach) {fertig("Du kannst keinen Zug mehr machen - Unentschieden"); break;}
     zug_wirklich_machen(spielbrett,zug);
     if(spielbrett.gewonnen(spielerfarbe)) {fertig("Computer ist Schachmatt - Du hast gewonnen"); break;}
    }
  }

 return 0;
}// ende von main

void fertig(const char *str)
{
 spielbrett.print();
 printf("%s\n",str);
}
