/* test1.cc       letzte Aenderung: 8.10.2016
Erster Test fuer Hall-Schaltung
*/
#define VERSION "0.0"
/*
 Prozessor: Atmega1284P, 20MHz Quarz
 Schaltung: schaltung/hall8x8.sch

 Autor: Rolf Pfister
 Copyright: Freeware

 History:
 8.10.2016      Erstellung

*/
//#define TEST1 1
//#define TEST2 1
#define TEST3 1
#define LCDTEST 1

#define F_CPU 20000000UL

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <math.h>
#include <string.h>
#include <ctype.h>
#include <util/delay.h>

//#define DEBUG  //zur Fehlersuche

/**** Vordeklarationen ****/
#define uchar uint8_t
#define uint uint16_t
#define ulong uint32_t

/**** Tastenentprellung ****/
#define PIN_TASTER PINB
void entprell(); //Vordeklaration fuer Tasten-Entprellung - declaration for debouncing function
static volatile char entprelltetasten=0xFF;
static char status1=0xFF,status2=0xFF;
static volatile char tastegedrueckt=0;

void entprell() //Tasten-Entprellung fuer mehrere Tasten unabhaengig voneinander
{               //Debouncing several buttons independent at the same time
 char pin,ung;
 pin = PIN_TASTER;
 //In "ung" diejenigen Bits setzen die ungleich zu status1 oder status2 sind:
 //Set bits to 1 if different to status1 or different to status2:
 ung = (pin^status1) | (status2^status1);
 //Bits so lassen wenn sie in "ung" auf 1 sind, oder gleich wie in "pin" setzen wenn sie in "ung" auf 0 sind:
 //Set bits to previous state when it is 1 in "ung", or set to same as "pin" when it is 0 in "ung":
 entprelltetasten = (entprelltetasten & ung) | (pin & (ung^0xFF));
 status2=status1;
 status1=pin;
 tastegedrueckt |= (entprelltetasten^0xFF);
}

/**** Zeitbehandlung ****/
static volatile uint millisec=0;
static volatile uchar sec=0,min=0,stunden=0,tage=0;

#define Rest1 (F_CPU%1000) //jede Sekunde zu korrigierender Fehler
#define NormalerCompwert (F_CPU/1000-1)

void timer1_init()
{
 TCCR1B = (1<<WGM12)|(1<<CS10); //CTC-OCR1A-Modus, Prescaler=1
 OCR1A = NormalerCompwert;
 TCNT1 = 0; //Startwert des Timers
 TIMSK1 = 1<<OCIE1A; //Timer1 Interrupts bei Vergleichswert
}

ISR(TIMER1_COMPA_vect)
{
 uchar mehr;
 uint ms=millisec;
 if(++ms>=1000-Rest1) mehr=1; else mehr=0;
 sei();
 if(ms==1000)
  {ms=0; mehr=0;
   if(++sec==60)
    {sec=0;
     if(++min==60)
      {min=0;
       if(++stunden==24)
	{stunden=0;
	 ++tage; //neuertag=1;
	}
      }
    }
  }
 //else if((ms&0x0F)==1) {}//etwa alle 16ms
 //else if((ms&0xFF)==0xE7) {}//alle ca 250ms
 millisec=ms;
 OCR1A=NormalerCompwert+mehr;
 if(ms%4==0) entprell(); //Tastenentprellung alle 4 Millisekunden - Debouncing every 4 milliseconds
}

void milliwait(int n) //n Millisekunden warten 1000 >= n >= 1
{
 uint ms;
 cli(); ms=millisec; sei();
 while(ms==millisec) ;//auf 1. Millisekunde warten
 if((ms+=n)>=1000) ms-=1000;
 while(ms!=millisec || ms!=millisec) //zweimal lesen um cli() sei() zu sparen
   ;//auf n. Millisekunde warten
}

void secwait(uchar n) //n Sekunden warten
{
 while(n!=0) {milliwait(1000); --n;}
}

void microwait(uchar n) //mindestens n Microsekunden warten
{
 while(--n!=0) _delay_us(1);
}

/***************************** Timer0 fuer ... ****************************************/
void timer0_init()
{
 TCCR0A = (0<<WGM01)|(0<<WGM00); //Normal-Modus, Interrupt bei Ueberlauf (8 Bit, also Teiler durch 256)
 //TCCR0A = (1<<WGM01)|(0<<WGM00); //CTC-Modus, Interrupt bei Erreichen von OCRA
 //TCCR0B = (1<<CS00); //Takt nicht teilen
 TCCR0B = (1<<CS01); //Takt durch 8teilen
 TCNT0 = 0;
 TIMSK0 = (1<<TOIE0); //Interrupt bei Ueberlauf
 //TIMSK0 = (1<<OCIE0A); //Interrupt bei Erreichen von OCRA
}

ISR(TIMER0_OVF_vect)
{
#ifdef TEST2
 static uint zaehler=0; //Test mit LED an PB5
 static uchar ledstatus=0; //Test mit LED an PB5
 if(++zaehler==9766) //TestLED im 2-Sekundentakt blinken lassen (9765.625 = 1 Sekunde)
  {
   ledstatus ^= 1;
   if(ledstatus==1) PORTB |= (1<<5); //TestLED ein (1 Sek hell)
   else             PORTB &= ~(1<<5); //TestLED aus (1 Sek dunkel)
   zaehler=0;
  }
#endif
}

/*************************** Serielle Schnittstelle ***********************************/
#ifndef F_CPU
#warning "F_CPU war noch nicht definiert, wird nun nachgeholt mit 20000000"
#define F_CPU 20000000UL  // Systemtakt in Hz - Definition als unsigned long
                         // Ohne ergeben sich unten Fehler in der Berechnung
#endif
 
#define BAUD 9600UL      // Baudrate
//#define BAUD 1200UL      //test
 
// Berechnungen
#define UBRR_VAL ((F_CPU+BAUD*8)/(BAUD*16)-1)   // clever runden
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))     // Reale Baudrate
#define BAUD_ERROR ((BAUD_REAL*1000)/BAUD) // Fehler in Promille, 1000=kein Fehler

#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error Systematischer Fehler der Baudrate groesser 1% und damit zu hoch! 
#endif

void uart1_init()
{
 UBRR1 = UBRR_VAL;
#ifdef UART_BASIRGB
 UCSR1B = (1<<RXEN1)|(1<<TXEN1); // UART TX und RX einschalten
#else
 UCSR1B = (1<<RXEN1); // nur UART RX einschalten
#endif
 //UCSR1C = (3<<UCSZ10); // Asynchron 8N1
 UCSR1C = (3<<UCSZ10)|(1<<USBS1); // Asynchron 8N2
}

void uart_putc(unsigned char c)
{
 while (!(UCSR1A & (1<<UDRE1))) ;// warten bis Senden moeglich
 UDR1 = c;                      // sende Zeichen
 milliwait(3);//test
}

unsigned char uart_getc(void)
{
 while (!(UCSR1A & (1<<RXC1))) ;// warten bis Zeichen verfuegbar
 return UDR1; // Zeichen aus UDR an Aufrufer zurueckgeben
}

bool uart_check()
{
 return (UCSR1A & (1<<RXC1)) ;//true wenn Zeichen verfuegbar
}

/********************************** LCD-Modul *****************************************/
#include "lcdmodul2.h"

/********************************** Hauptprogramm *************************************/
int main(void)
{
 uchar i=0,j; //,c,startflag=1;

 // PortA alles Eingaenge fuer A/D-Wandler
 PORTB = 0x1F; //PortB untere 5 Bits Pullups fuer Tasten
 DDRB  = 0x20; //PortB alles Eingaenge ausser 6.Bit fuer LCD-Beleuchtung, oder hier TestLED
 PORTC = 0x00; //PortC alle auf Low fuer inaktiv (N-Chann-Transistoren)
 DDRC  = 0xFF; //PortC alles Ausgaenge
 // PortD wird fuer LCD benutzt

 timer0_init();
 timer1_init();
 sei(); //Interrupt einschalten

#ifdef LCDTEST
 lcd_init();
 PORTB |= (1<<5); //Hintergrundbeleuchung ein
 lcd_goto(1,1); lcd_write("Hallo LCD (16 Z)"); //1.Zeile
 lcd_goto(2,1); lcd_write("2. Zeile "); //2.Zeile
 lcd_goto(3,1); lcd_write("dritte Zeile"); //3.Zeile
 lcd_goto(4,1); lcd_write("letzte Zeile."); //4.Zeile
#endif

 while(1) //Hauptschlaufe
  {
#ifdef TEST1
   milliwait(500);
   PORTB |= (1<<5); //TestLED ein
   milliwait(500);
   PORTB &= ~(1<<5); //TestLED aus
#else
#ifdef TEST3
   static uchar maske=0;
   static int pause=100;
   milliwait(pause);
   if(++i==10) i=0;
   switch(i)
    {
     case 0: PORTC=0; break;//alle Sensoren aus
     case 1: if((maske <<= 1)==0) {maske=1;}
             PORTC=maske; //aktuelle Spalte ein
             break;
     default: //hier sollten noch A/D-Wandlungen gemacht werden
	      break;
    }
   for(j=0;j<5;j++) //5 Tasten pruefen
    {
     uchar m=(1<<j);
     if((tastegedrueckt&m)!=0)
      {
       switch(j)
	{case 0: if(pause>10) pause/=2; break; //obere Taste -> schneller
	 case 1: if(pause<1000) pause*=2; break; //untere Taste -> langsamer
	 case 2: pause=50; break; //rechte Taste -> doppelt so schnell wie am Anfang
	 case 3: pause=200; break; //linke Taste -> halb so schnell wie am Anfang
	 case 4: pause=100; break; //mittlere Taste -> Anfangsgeschwindigkeit
	}
       while((entprelltetasten&m)==0) {} //wait until button released
       tastegedrueckt &= ~m; //reset pressed state for the button
      }
    }
#endif
#endif
  }//Ende Hauptschlaufe
 return 0;//wird nie erreicht
}
