/* test2.cc       letzte Aenderung: 16.10.2016
Alle Hall-Sensoren testen
*/
#define VERSION "0.0"
/*
 Prozessor: Atmega1284P, 20MHz Quarz
 Schaltung: schaltung/hall8x8.sch

 Autor: Rolf Pfister
 Copyright: Freeware

 History:
 8.10.2016      Erstellung (test1.cc), Test ohne Sensoren
 9.10.          Test mit Sensoren

*/
//#define TEST2 1
#define TEST3 1
#define LCDTEST 1

#define F_CPU 20000000UL

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <math.h>
#include <string.h>
#include <ctype.h>
#include <util/delay.h>

//#define DEBUG  //zur Fehlersuche

/**** Vordeklarationen ****/
#define uchar uint8_t
#define uint uint16_t
#define ulong uint32_t

/**** Tastenentprellung ****/
#define PIN_TASTER PINB
void entprell(); //Vordeklaration fuer Tasten-Entprellung - declaration for debouncing function
static volatile char entprelltetasten=0xFF;
static char status1=0xFF,status2=0xFF;
static volatile char tastegedrueckt=0;

void entprell() //Tasten-Entprellung fuer mehrere Tasten unabhaengig voneinander
{               //Debouncing several buttons independent at the same time
 char pin,ung;
 pin = PIN_TASTER;
 //In "ung" diejenigen Bits setzen die ungleich zu status1 oder status2 sind:
 //Set bits to 1 if different to status1 or different to status2:
 ung = (pin^status1) | (status2^status1);
 //Bits so lassen wenn sie in "ung" auf 1 sind, oder gleich wie in "pin" setzen wenn sie in "ung" auf 0 sind:
 //Set bits to previous state when it is 1 in "ung", or set to same as "pin" when it is 0 in "ung":
 entprelltetasten = (entprelltetasten & ung) | (pin & (ung^0xFF));
 status2=status1;
 status1=pin;
 tastegedrueckt |= (entprelltetasten^0xFF);
}

/**** Zeitbehandlung ****/
static volatile uint millisec=0;
static volatile uchar sec=0,min=0,stunden=0,tage=0;

#define Rest1 (F_CPU%1000) //jede Sekunde zu korrigierender Fehler
#define NormalerCompwert (F_CPU/1000-1)

void timer1_init()
{
 TCCR1B = (1<<WGM12)|(1<<CS10); //CTC-OCR1A-Modus, Prescaler=1
 OCR1A = NormalerCompwert;
 TCNT1 = 0; //Startwert des Timers
 TIMSK1 = 1<<OCIE1A; //Timer1 Interrupts bei Vergleichswert
}

ISR(TIMER1_COMPA_vect)
{
 uchar mehr;
 uint ms=millisec;
 if(++ms>=1000-Rest1) mehr=1; else mehr=0;
 sei();
 if(ms==1000)
  {ms=0; mehr=0;
   if(++sec==60)
    {sec=0;
     if(++min==60)
      {min=0;
       if(++stunden==24)
	{stunden=0;
	 ++tage; //neuertag=1;
	}
      }
    }
  }
 else if((ms&0x03)==1) entprell(); //Tastenentprellung alle 4 Millisekunden - Debouncing every 4 milliseconds
 //else if((ms&0x0F)==1) {}//etwa alle 16ms
 //else if((ms&0xFF)==0xE7) {}//alle ca 250ms
 millisec=ms;
 OCR1A=NormalerCompwert+mehr;
}

void milliwait(int n) //n Millisekunden warten 1000 >= n >= 1
{
 uint ms;
 cli(); ms=millisec; sei();
 while(ms==millisec) ;//auf 1. Millisekunde warten
 if((ms+=n)>=1000) ms-=1000;
 while(ms!=millisec || ms!=millisec) //zweimal lesen um cli() sei() zu sparen
   ;//auf n. Millisekunde warten
}

/*
void secwait(uchar n) //n Sekunden warten
{
 while(n!=0) {milliwait(1000); --n;}
}

void microwait(uchar n) //mindestens n Microsekunden warten
{
 while(--n!=0) _delay_us(1);
}
*/

/******************************** AD-Wandler ******************************************/
static volatile uchar adamlaufen=0;
static volatile int messwert=0;

ISR(ADC_vect) //AD-Wandler Interrupt-Routine
{
 uchar c1,c2;
 c1=ADCL;
 c2=ADCH;
 messwert = (c2<<8)+c1;
 adamlaufen=0;
}

void ad_init(uchar adkanal)
{
//Prescaler Beispiel: 2^7=128, 20MHz/128=156.25kHz (muss im Bereich 50-200 liegen)
 //uchar PRESCALER; int pre;
 //for(PRESCALER=1,pre=2*200;  PRESCALER<7 && (F_CPU/1000)>pre;  PRESCALER++, pre *= 2)
 //          {}          //PRESCALER ausrechnen lassen
#define PRESCALER 7  //oder direkt definieren

 adamlaufen=1;

//Fuer Referenzspannung eine der folgenden 4 Varianten benutzen:
 //ADMUX = (0<<REFS0)+adkanal; //Externe Referenz an AREF
 ADMUX = (1<<REFS0)+adkanal; //AVCC als Referenz verwenden
 //ADMUX = (2<<REFS0)+adkanal; //Interne Referenz = 1.1V
 //ADMUX = (3<<REFS0)+adkanal; //Interne Referenz = 2.56V

 ADCSRA = (1<<ADEN)+(1<<ADSC)+(1<<ADIE)+PRESCALER;//Enable+Interruptenable+MessungStarten

 //while(adamlaufen)  ; //erste Wandlung abwarten und verwerfen
 //_delay_ms(1); 
}

void ad_start()
{
 adamlaufen=1;
 ADCSRA |= (1<<ADSC); //Starte AD-Wandlung
}

int ad_lesen()
{
 if(adamlaufen) return 0;
 return messwert;
}

/*
void ad_off()
{
 ADCSRA &= ~(1<<ADEN);
}
*/

//Umrechnungen von Bitwerten auf Millivolt:
//1024 = referenz, somit Bitrauschen = referenz/1024
#define REFERENZ 5000L //Versorgungsspannung (5.0 V) als Referenz
//#define REFERENZ 1100L //Referenzspannung 1.1 V
//#define REFERENZ 2560L //Referenzspannung 2.56 V
#define DU ((REFERENZ+1023)/1024) //REFERENZ/1024 aufgerundet = Ungenauigkeit von AD-Wandler

int mvolt(uint ad) //Messwert umrechnen in Millivolt
{
 return (REFERENZ*ad+512)/1024;
}

/***************************** Timer0 fuer Sensoren auslesen **************************/
static volatile uint sensorfeld[64];

void timer0_init()
{
 TCCR0A = (0<<WGM01)|(0<<WGM00); //Normal-Modus, Interrupt bei Ueberlauf (8 Bit, also Teiler durch 256)
 //TCCR0A = (1<<WGM01)|(0<<WGM00); //CTC-Modus, Interrupt bei Erreichen von OCRA
 //TCCR0B = (1<<CS00); //Takt nicht teilen
 TCCR0B = (1<<CS01); //Takt durch 8teilen
 TCNT0 = 0;
 TIMSK0 = (1<<TOIE0); //Interrupt bei Ueberlauf
 //TIMSK0 = (1<<OCIE0A); //Interrupt bei Erreichen von OCRA
}

ISR(TIMER0_OVF_vect)
{
 // wird alle etwa 0.1 ms aufgerufen (102.4 usec)
 // 9765.625 Aufrufe = 1 Sekunde
#define MAX_ZAEHLER (4*8)
 static uchar zaehler=0;
 if(++zaehler==MAX_ZAEHLER) zaehler=0;
 if((zaehler&0x07)==0) //etwa alle 0.8 ms
  {
   static uchar j=0,maske=0x80;
   static uchar kanal=0;
   uchar cyclus = zaehler>>3;
   switch(cyclus)
    {
     case 1: ad_init(kanal); break;
     case 2: ad_start(); break;
     case 3: sensorfeld[j+kanal]=ad_lesen();
             if(kanal==7) PORTC=0; //wenn letzte Reihe gelesen, Spannung fuer Spalte ausschalten
             break;
     default:
         if(++kanal==8)
	  {
	   kanal=0;
	   j += 8;
	   if(j==64) {j=0; maske=0x80;}
	   else  maske >>= 1;
	   PORTC = maske; //Spannung fuer neue Spalte einschalten
	  }
#ifdef TEST2
	 {static int test2=0;
	  static uchar ledstatus=0;
	  if(++test2==1000) {ledstatus ^= 1; test2=0;}
	  if(ledstatus==1) PORTB |= (1<<5); //TestLED ein
	  else             PORTB &= ~(1<<5); //TestLED aus
	 }
#endif
	 break;
    }
  }
}

/*************************** Serielle Schnittstelle ***********************************/
#ifndef F_CPU
#warning "F_CPU war noch nicht definiert, wird nun nachgeholt mit 20000000"
#define F_CPU 20000000UL  // Systemtakt in Hz - Definition als unsigned long
                         // Ohne ergeben sich unten Fehler in der Berechnung
#endif
 
#define BAUD 9600UL      // Baudrate
//#define BAUD 1200UL      //test
 
// Berechnungen
#define UBRR_VAL ((F_CPU+BAUD*8)/(BAUD*16)-1)   // clever runden
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))     // Reale Baudrate
#define BAUD_ERROR ((BAUD_REAL*1000)/BAUD) // Fehler in Promille, 1000=kein Fehler

#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error Systematischer Fehler der Baudrate groesser 1% und damit zu hoch! 
#endif

void uart1_init()
{
 UBRR1 = UBRR_VAL;
#ifdef UART_BASIRGB
 UCSR1B = (1<<RXEN1)|(1<<TXEN1); // UART TX und RX einschalten
#else
 UCSR1B = (1<<RXEN1); // nur UART RX einschalten
#endif
 //UCSR1C = (3<<UCSZ10); // Asynchron 8N1
 UCSR1C = (3<<UCSZ10)|(1<<USBS1); // Asynchron 8N2
}

void uart_putc(unsigned char c)
{
 while (!(UCSR1A & (1<<UDRE1))) ;// warten bis Senden moeglich
 UDR1 = c;                      // sende Zeichen
 milliwait(3);//test
}

unsigned char uart_getc(void)
{
 while (!(UCSR1A & (1<<RXC1))) ;// warten bis Zeichen verfuegbar
 return UDR1; // Zeichen aus UDR an Aufrufer zurueckgeben
}

bool uart_check()
{
 return (UCSR1A & (1<<RXC1)) ;//true wenn Zeichen verfuegbar
}

/********************************** LCD-Modul *****************************************/
#include "lcdmodul2.h"

void itoa(char *s,int n)
{
 char c,*t;
 int k;
 if(n<0) {*s++ = '-'; n = -n;}
 for(t=s;;)
  {
   if(n<10) {*t++ = n+'0'; break;}
   k = n%10;
   *t++ = k+'0';
   n /= 10;
  }
 *t=0;
 for(--t;t!=s;)
  {
   c = *t;
   *t-- = *s;
   *s = c;
   if(t!=s) s++;
  }
}

void lcd_print1(const char *txt,int n)
{
 char text[22];
 uchar i;
 for(i=0;*txt!=0 && i<15;i++) text[i] = *txt++;
 //sprintf(&text[i],"%d",n);
 itoa(&text[i],n);
 lcd_write(text);
}

#ifdef TEST3
void lcd_print_sensor(uchar j)
{
 lcd_print1("ad[",j); lcd_print1("] ",sensorfeld[j]);
 lcd_print1(" ",mvolt(sensorfeld[j])); lcd_write("mV ");
}
#endif

/********************************** Hauptprogramm *************************************/
int main(void)
{
 uchar j,taste=0; //,c,startflag=1;

 // PortA alles Eingaenge fuer A/D-Wandler
 PORTB = 0x1F; //PortB untere 5 Bits Pullups fuer Tasten
 DDRB  = 0x20; //PortB alles Eingaenge ausser 6.Bit fuer LCD-Beleuchtung, oder hier TestLED
 PORTC = 0x00; //PortC alle auf Low fuer inaktiv (N-Chann-Transistoren)
 DDRC  = 0xFF; //PortC alles Ausgaenge
 // PortD wird fuer LCD benutzt

 timer0_init();
 timer1_init();
 sei(); //Interrupt einschalten

 lcd_init();
 PORTB |= (1<<5); //Hintergrundbeleuchung ein
#ifdef LCDTEST
 lcd_goto(1,1); lcd_write("Hallo LCD (16 Z)"); //1.Zeile
 lcd_goto(2,1); lcd_write("2. Zeile "); //2.Zeile
 lcd_goto(3,1); lcd_write("dritte Zeile"); //3.Zeile
 lcd_goto(4,1); lcd_write("letzte Zeile."); //4.Zeile
#endif

 while(1) //Hauptschlaufe
  {
#ifdef TEST3
   static int pause=500;
   static uchar spalte=0,reihe=0;
   milliwait(pause);
   for(j=0;j<5;j++) //5 Tasten pruefen
    {
     uchar m=(1<<j);
     if((tastegedrueckt&m)!=0)
      {
       switch(j)
	{case 0: taste=1; if(reihe<5) reihe++; break; //obere Taste -> naechste Reihe
	 case 1: taste=2; if(reihe>0) reihe--; break; //untere Taste -> vorherige Reihe
	 case 2: taste=3; if(spalte>0) spalte--; break; //rechte Taste -> vorherige Spalte
	 case 3: taste=4; if(spalte<7) spalte++; break; //linke Taste -> naechste Spalte
	 case 4: taste=5; spalte=reihe=0; break; //mittlere Taste -> erste Spalte und erste Reihe
	}
       while((entprelltetasten&m)==0) {} //wait until button released
       tastegedrueckt &= ~m; //reset pressed state for the button
       lcd_goto(1,1); lcd_print1("Taste: ",taste); lcd_write(" ");
      }
    }
   uchar j0=spalte*8+reihe;
   lcd_goto(2,1); lcd_print_sensor(j0);
   lcd_goto(3,1); lcd_print_sensor(j0+1);
   lcd_goto(4,1); lcd_print_sensor(j0+2);
#endif
  }//Ende Hauptschlaufe
 return 0;//wird nie erreicht
}
