/* lcdmodul2.cc      letzte Aenderung: 30.10.2016
 Version: 0.05
 Prozessor: ATmega8, ATmega328P

 Schaltungs-Beispiel: Obere 6 Bits von PortD mit LCD-Modul verbunden:
  (fuer anderen Port entsprechende #define in lcdmodul2.h anpassen)
  LCD-Modul   PortD
   Pin4: RS   D2
   Pin5: R/W  GND
   Pin6: E    D3
   Pin11:DB4  D4
   Pin12:DB5  D5
   Pin13:DB6  D6
   Pin14:DB7  D7
  diese Anschluesse sind je nach Modul etwas unterschiedlich:
   Pin15:BLA  Beleuchtung +, ueber ca 1kOhm an +5V haengen
   Pin16:BLK  Beleuchtung -, GND
   Pin1: GND
   Pin2: +5V
   Pin3: Kontrast, Mittelabgriff von 4.7kOhm Poti mit 10kOhm nach +5V
   Pin7..10:DB0..DB3 offen oder GND

 Benutzung im Hauptprogramm:
  #include "lcdmodul2.h"
  main()
  {...
   sei();
   lcd_init();
   ...
  }

 oder falls der Port schon vor sei() initialisiert werden soll:
  #include "lcdmodul2.h"
  main()
  {...
   lcd_init1();
   sei();
   lcd_init2();
   ...
  }

 Autor: Rolf Pfister
 Copyright: Freeware
 History:
 1.11.2009	Erstellung
 29.8.2010	Vereinfacht zum allgemeinen Benutzen durch Einfuegen
 13.9.2010	Noch mehr vereinfacht zur Fehlersuche
 1.10.2010	Angepasst fuer Verwendung der unteren 6 Bits eines Ports
 15.10.10       Anpassung fuer Verwendung eines zweiten Ports fuer RS und EN
 26.10.10       Variante zum separat Uebersetzen und dann im Hauptprogramm
                einfuegen mit: #include "lcdmodul.h" statt "lcdmodul.cc"
 31.10.10	Umbenannt nach lcdmodul2.c und lcdmodul2.h (damit auch alte Variante
		in schon aelteren Projekten noch verwendbar)
 26.10.2016     Anpassungen fuer 4-Zeilen-LCD TC1604A-01(R)
 30.10.2016     Version 0.05: lcd_goto() mit int8_t

*/
//schon im Hauptprogramm gemacht:
//#include <avr/io.h>
//#include <avr/interrupt.h>
//#include <stdio.h>
//void milliwait(int n); //n Millisekunden warten

#include <avr/io.h>
#include <avr/interrupt.h>
#include "lcdmodul2.h"

#ifdef MILLIWAIT
void milliwait(int);     //Wartefunktion schon im Hauptprogramm
#else
#include <util/delay.h>  //falls nicht schon im Hauptprogramm
void milliwait(int n)    //Wartefunktion hier einfuegen
{
 while(n>0) {_delay_ms(1); --n;}
}
#endif

void microwait1() //etwa 1 Microsekunde warten
{
/* Das Modul TC1602E-01(R) mit diesem Programm erfolgreich von 1 bis 16MHz
   getestet. Zumindest mit diesem Modul funktioniert es auch ohne dass F_CPU
   definiert ist.
*/
#if F_CPU>=8000000
 __asm__ ("nop");
#if F_CPU>=16000000
 __asm__ ("push r16");
 __asm__ ("pop r16");
 __asm__ ("push r16");
 __asm__ ("pop r16");
#endif
#endif
}

void lcd_4bitsend(char tmp)
{
 //uint8_t tmp_sreg=SREG;//falls der Port auch noch von einer ISR benutzt wird
 //cli();//falls der Port auch noch von einer ISR benutzt wird
#if LCD_DATA==4
 LCD_PORT=(LCD_PORT&0x0F)+tmp;//untere 4 Bits unveraendert lassen
#else
 LCD_PORT=(LCD_PORT&0xF0)+tmp;//Daten untere 4 Bits, obere unveraendert
#endif
 //SREG=tmp_sreg;//falls der Port auch noch von einer ISR benutzt wird
 microwait1();
 LCD_PORT2 |= (1<<LCD_EN);  //sbi(PORTD,3) ;Enable setzen
 microwait1();
 LCD_PORT2 &= ~(1<<LCD_EN); //cbi(PORTD,3) ;Enable loeschen
 microwait1();
}

void lcd_send(unsigned char data)
{
#if LCD_DATA==4
 lcd_4bitsend(data&0xF0); //High-Teil senden
 lcd_4bitsend(data<<4);   //Low-Teil senden
#else
 lcd_4bitsend(data>>4);   //High-Teil senden
 lcd_4bitsend(data&0x0F); //Low-Teil senden
#endif
 milliwait(2);
}

void lcd_cmd(char cmd)
{
 LCD_PORT2 &= ~(1<<LCD_RS);
 lcd_send(cmd);
}

void lcd_clear() {lcd_cmd(0x01); milliwait(5);}
void lcd_home() {lcd_cmd(0x02); milliwait(5);}
void lcd_on() {lcd_cmd(0x0E);}
void lcd_off() {lcd_cmd(0x08);}

void lcd_init1()
{
#if LCD_DATA==4
 LCD_DDR |= 0xF0; //Port D obere 4 Bits auf Ausgang
 LCD_PORT &= 0x0F;//Port D obere 4 Bits auf L
#else
 LCD_DDR |= 0x0F; //untere 4 Bits auf Ausgang
 LCD_PORT &= 0xF0;//untere 4 Bits auf L
#endif
 LCD_DDR2 |= (1<<LCD_RS); //RS auf Ausgang
 LCD_DDR2 |= (1<<LCD_EN); //EN auf Ausgang
 LCD_PORT2 &= ~(1<<LCD_RS); //RS auf L
 LCD_PORT2 &= ~(1<<LCD_EN); //EN auf L
}

void lcd_init2()
{
 milliwait(50); //Warten bis LCD-Controller gebootet hat
#ifdef LCDWARMSTART
 lcd_4bitsend(0x30); //Soft-Reset
 milliwait(5);
 lcd_4bitsend(0x30); //Soft-Reset, 2. mal
 milliwait(1);
 lcd_4bitsend(0x30); //Soft-Reset, 3. mal
 milliwait(5);
#endif
 lcd_4bitsend(0x20); //4-Bit-Modus einschalten
 milliwait(5);

 //Je nach verwendetem Display eine der nachfolgenden Versionen verwenden:

/** alte Version **
 // Funktions-Set: 2 Zeilen, 5*7 Matrix, 4Bit
 lcd_cmd(0x28);
 lcd_off(); //eventuell nicht noetig
 lcd_clear();
 lcd_cmd(0x06); //Entry Mode == Einfuegemodus
 lcd_on();
**/

/** 2-Zeilen-LCD TC1602E-01(R) **
 lcd_cmd(0x28); //Funktions-Set: 2 Zeilen, 5*7 Matrix, 4Bit
 lcd_cmd(0x06); //Entry Mode == Einfuegemodus
 lcd_on();
 lcd_clear();
**/

/** 4-Zeilen-LCD TC1604A-01(R) **/
 lcd_cmd(0x28); //Funktions-Set: 4 Zeilen, 5*7 Matrix, 4Bit
 lcd_cmd(0x06); //Entry Mode == Einfuegemodus
 lcd_on();
 lcd_clear();
/**/

/** 4-Zeilen-LCD EA DIP204-6 **
 lcd_cmd(0x06); //Cursor Auto-increment
 lcd_cmd(0x26); //RE-Bit setzen
 lcd_cmd(0x09); //4-Zeilen-Modus
 lcd_cmd(0x40); //Icon-RAM Adresse auf 0x00 setzen
 for(char i=0;i<16;i++) lcd_write('\0'); //alle Icons aus
 lcd_cmd(0x20); //RE-Bit loeschen
 lcd_off();
 lcd_clear();
 lcd_cmd(0x06);
 lcd_on();
**/
}

void lcd_init()
{
 lcd_init1();
 lcd_init2();
}

void lcd_goto(int8_t row,int8_t col) //row=Zeile, col=Spalte
{

//Je nach verwendetem Display eine der nachfolgenden Versionen verwenden:

/** 2-Zeilen-LCD **
 row--;       //Zaehlung statt bei 1 bei 0 beginnend
 row &= 0x01; //auf 2 Zeilen beschraenkt
 row <<= 6;   //Zeile auf oberste 2 Bits bringen
 col--;
 //col &= 0x0F;      //auf 16 Zeichen Breite beschraenkt
 col &= 0x3F;      //auf 64 Zeichen Breite beschraenkt
 char tmp=row|col; //Adresse bilden
 tmp |= 0x80;      //Cursor setzen
 lcd_cmd(tmp);
**/

/** 4-Zeilen-LCD TC1604A-01(R) **/
 row--;
 row &= 0x03; //nur Zeile 0 bis 3 zulassen
 if(row==2) row=0x10; //Code fuer Zeile3
 else if(row==3) row=0x50; //Code fuer Zeile4
 else row <<= 6;   //0x00 und 0x40 fuer Zeile1 und Zeile2
 col--;
 col &= 0x0F;      //auf 16 Zeichen Breite beschraenkt
 char tmp=row|col; //Adresse bilden
 tmp |= 0x80;      //Cursor setzen
 lcd_cmd(tmp);
/**/

/** 4-Zeilen-LCD EA DIP204-6 **
 row--;
 row &= 0x03; //nur Zeile 0 bis 3 zulassen
 row <<= 5;   //Zeile nach Bit 5 bringen
 col--;
 col &= 0x1F;      //auf 32 Zeichen Breite beschraenkt
 char tmp=row|col; //Adresse bilden
 tmp |= 0x80;      //Cursor setzen
 lcd_cmd(tmp);
**/
}

void lcd_writec(char c)
{
 LCD_PORT2 |= (1<<LCD_RS);
 lcd_send(c);
}

void lcd_write(const char *text)
{
 char c;
 while((c= *text++)!=0)
   lcd_writec(c);
}
