#ifndef SCHACH_ENGINE_H
#define SCHACH_ENGINE_H

//#define AVRSCHACH   //fuer AVR-Variante, sollte im Hauptprogramm definiert werden
//#define BAUERNSPIEL //auskommentieren fuer normales Schach
//#define DEBUG       //im Hauptprogramm machen

#ifdef AVRSCHACH
extern volatile uint adwandler_zufallszahl;
#else
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <ctype.h>
#include <string.h>
typedef unsigned char uchar;

#define lcd_printf printf
#endif

/************** Klassen und Hauptteil des Programms *******************/
#define LEER 0

#define RESERVEBITS 0x38
#define FIGUR  0x07
#define BAUER     1
#define SPRINGER  2
#define LAEUFER   3
#define TURM      4
#define DAME      5
#define KOENIG    6

#define FARBE   0x40
#define WEISS   0
#define SCHWARZ 0x40

#define MOVFLAG 0x80 //bei Bauern fuer en passant, bei Koenig u. Turm fuer Rochade
#define ENPASSFLAG 0x80 //bei Bauern fuer en passant, bei Koenig u. Turm fuer Rochade

#define PROMOBITS  0xC0 //fuer Bauerumwandlung in Zug.nach als Fig-2 zu setzen
#define PROMOFLAG  0x80 //fuer Bauerumwandlung in Zug.von zu setzen
#define IMASK      0x3F //Maske fuer Verwendung von Zug.von und Zug.nach um Promo-Bits auszublenden

#define MAXPUNKTE 32000

#ifdef BAUERNSPIEL
#define MAXBAUERPUNKTE 10000 //fuer Bauernspiel
#else
#define MAXBAUERPUNKTE 900 //fuer Umwandlung von Bauer in Dame
#endif

const int16_t material[6]={100,300,300,500,900,0}; //Werte in Centibauer

class Brett
{
 uchar feld[64]; //Spielbrett von A1 B1 C1 ... G8 H8 als 0 1 2 ... 62 63 nummeriert
public:
 Brett() {clear();}
 void clear() {for(int8_t i=0;i<64;i++) feld[i]=0;}
 void grundstellung();
 void grundstellung960(const char*);
 uchar& operator[](int8_t i) {return feld[i];}
#ifndef AVRSCHACH
 void print();
#endif
 bool gewonnen(uchar farbe);
 int8_t gewonnen_oder_unentschieden(uchar farbe);
 bool istzugmoeglich(uchar farbe);
};

extern Brett spielbrett;

class Zug
{
public:
 uchar von,nach;
 void set(uchar from,uchar to) {von=from; nach=to;}
 void setpromo(uchar fig) {von |= PROMOFLAG; nach = (nach&IMASK) + ((fig-2)<<6);} //fuer Bauernumwandlung
 uchar getpromo() {return (von&PROMOFLAG) ? (nach>>6)+2 : 0;}
 const char *print();
};

class Zugliste
{
 uchar von,nach;
 int16_t bewertung;
 Zugliste *next;
public:
 Zugliste() {next=NULL; von=nach=0; bewertung=0;}
 ~Zugliste() {clear();}
#ifdef AVRSCHACH
 void clear() {if(next!=NULL) {next->clear(); free(next); next=NULL;} von=nach=0;}
#else
 void clear() {if(next!=NULL) {next->clear(); delete[] next; next=NULL;} von=nach=0;}
#endif
 bool istleer() {return von==nach;}
 //bool istleer() {return von==nach && next==NULL;}//test
 void vertauschen(Zugliste *a,Zugliste *b);
 void addsorted(uchar from,uchar to,int16_t wert);
 void add(uchar from,uchar to,Brett& brett,uchar farbe,int8_t suchtiefe);
 void addb(uchar from,uchar to,Brett& brett,uchar farbe,int8_t suchtiefe); //zum Bauern ev. Umwandeln
 Zug getbest(Brett& brett,uchar farbe);
 Zugliste* zugsuchen(Zug zug);
#ifdef DEBUG
 Zugliste* zugsuchen_debug(Zug zug);//test
 void print(const char*);//test
#endif
};

//Vordeklarationen:
int8_t koenigposition(Brett& brett,uchar farbe);
bool isincheck(Brett& brett,uchar farbe);
int16_t stellung_bewerten(Brett& brett,uchar farbe,int8_t suchtiefe);
int16_t zug_bewerten(Brett& brett,uchar farbe,Zug& zug,int8_t suchtiefe);
Zug besterzug(Brett& brett,uchar farbe,int8_t suchtiefe);
void zug_machen(Brett& brett,uchar von,uchar nach,Brett& hilfsbrett);
void alle_moeglichen_zuege(Brett& brett,uchar farbe,Zugliste *zugliste,int8_t suchtiefe);
Zug spielerzug(Brett& brett,uchar farbe);

Zug besterzug(Brett& brett,uchar farbe,int8_t suchtiefe);
void zug_wirklich_machen(Brett& brett,Zug zug);
void fehler_zu_wenig_ram();

#endif
