#ifndef LCDMODUL_H
#define LCDMODUL_H

/******************* Einstellungen machen *******************/
//entweder untere 6 Bits oder obere 6Bits eines Ports verwenden
#define LCD_PORT PORTD
#define LCD_DDR DDRD
#define LCD_DATA 4   //0 fuer 0..3 oder 4 fuer 4..7

//RS, EN auf 2, 3 oder auf 4, 5 setzen:
#define LCD_RS 2
#define LCD_EN 3

//oder RS und EN auf einem anderen Port:
/*
#define LCD_PORT2 PORTB
#define LCD_DDR2 DDRB
#define LCD_RS 3
#define LCD_EN 4
*/

#define LCDWARMSTART  //wenns Probleme gibt beim Einschalten

#ifndef LCD_PORT2
#define LCD_PORT2 LCD_PORT
#define LCD_DDR2 LCD_DDR
#endif

//#define MILLIWAIT   //wenn  void milliwait(int)  schon im Hauptprogramm vorhanden

#ifndef F_CPU
//#define F_CPU 16000000
//#warning F_CPU war nicht definiert, hier nachgeholt mit 16 MHz
#define F_CPU 3686400
#warning F_CPU war nicht definiert, hier nachgeholt mit 3.6864 MHz
#endif
/************* Ende von Einstellungen machen ****************/

void lcd_init();
void lcd_goto(int row,int col); //row=Zeile, col=Spalte
void lcd_cmd(char cmd);
void lcd_writec(char c);
void lcd_write(const char *text);

void lcd_clear();
void lcd_home();
void lcd_on();
void lcd_off();

#endif
