/* softuart.cc       letzte Aenderung: 15.2.2023
Software-UART austesten, ohne Verwendung von Timer und Interrupts

 Version: 0.0
 Prozessor: ATmega8
 Schaltung:
   Senden:    PB5 (TxD)
   Empfangen: PB4 (RxD)

 Autor: Rolf Pfister
 Copyright: Freeware
 History:
 15.2.2023	Erstellung, bisher nur Senden moeglich

Verwendung im Hauptprogramm:
#include <inttypes.h>
#include <avr/io.h>
#include "softuart.cc"

*/
#define HAUPTPROGRAMM  //auskommentieren wenn wie oben eingefuegt

#ifdef HAUPTPROGRAMM
#include <inttypes.h>
#include <avr/io.h>
#define F_CPU 3686400UL
#endif

#include <avr/interrupt.h>  //fuer Definition von cli() und sei()
#include <util/delay.h>

#ifndef F_CPU
#warning "F_CPU war noch nicht definiert, wird nun nachgeholt mit 3686400"
#define F_CPU 3686400UL  // Systemtakt in Hz - Definition als unsigned long
                         // Ohne ergeben sich unten Fehler in der Berechnung
#endif
 
#define BAUDRATE 9600UL      // Baudrate
#define BAUDMICROSEC (1e6/BAUDRATE)

#define SUART_TXD  //senden
//#define SUART_RXD  //empfangen

#ifdef SUART_TXD
 #define SUART_TXD_PORT PORTB
 #define SUART_TXD_DDR  DDRB
 #define SUART_TXD_BIT  PB5
#endif //SUART_TXD 

#ifdef SUART_RXD
 #define SUART_RXD_PORT PORTB
 #define SUART_RXD_PIN  PINB
 #define SUART_RXD_DDR  DDRB
 #define SUART_RXD_BIT  PB4
 static volatile uint16_t inframe;
 static volatile uint8_t inbits, received;
 static volatile uint8_t indata;
#endif //SUART_RXD 

void uart_init()
{
 uint8_t sreg = SREG;
 cli();

#ifdef SUART_RXD
 SUART_RXD_DDR  &= ~(1 << SUART_RXD_BIT);
 SUART_RXD_PORT |=  (1 << SUART_RXD_BIT);
#endif

#ifdef SUART_TXD
 SUART_TXD_PORT |= (1 << SUART_TXD_BIT);
 SUART_TXD_DDR  |= (1 << SUART_TXD_BIT);
#endif

 SREG = sreg;
}

#ifdef SUART_TXD
void uart_putc(char c)
{
 uint8_t sreg = SREG;
 cli();

 // frame = *.P.7.6.5.4.3.2.1.0.S   S=Start(0), P=Stop(1), *=Endemarke(1) 
 uint16_t data = (3 << 9) | (((uint8_t) c) << 1);
 for(; data>1; data >>= 1)
  {
   if(data & 1) SUART_TXD_PORT |=  (1 << SUART_TXD_BIT);
   else         SUART_TXD_PORT &= ~(1 << SUART_TXD_BIT);
   //Verzoegerung mit 10 Takte fuer for-Schlaufe beruecksichtigt:
   _delay_us(BAUDMICROSEC - 10*1e6/F_CPU);
  }

 SREG = sreg;
}

void uart_write(const char *s)
{
 char c;
 while((c= *s++)!=0) uart_putc(c);
}
#endif //SUART_TXD

#ifdef SUART_RXD
char uart_getc(void)
{
 uint8_t sreg = SREG;
 cli();
 
 // frame = *.P.7.6.5.4.3.2.1.0.S   S=Start(0), P=Stop(1), *=Endemarke(1) 
 uint8_t data=0;
 while((SUART_RXD_PIN & (1<<SUART_RXD_BIT))!=0) {}// warte auf Start-Bit
 _delay_us(BAUDMICROSEC/2);
 for(uint8_t i=0;i<9;i++)
  {
   //Verzoegerung mit 10 Takte fuer for-Schlaufe beruecksichtigt:
   _delay_us(BAUDMICROSEC - 10*1e6/F_CPU);
   uint8_t bit = ((SUART_RXD_PIN & (1<<SUART_RXD_BIT))!=0) ? 1 : 0;
   if(i<8) data = (data<<1)+bit;
  }
 
 SREG = sreg;
 return data; //Zeichen an Aufrufer zurueckgeben
}
#endif //SUART_RXD

#ifdef HAUPTPROGRAMM
#include "lcdmodul2.h"
#include <stdio.h>
void lcd_print(int x)
{
 char text[32];
 sprintf(text,"%d  ",x);
 lcd_write(text);
}

int main()
{
 uart_init();
 while(1)
  {
   uart_write("a");
   /*
   uart_write("D2-D4\n");
   secwait(30);
   uart_write("D4-D2\n");
   secwait(30);
   */

#ifdef SUART_RXD
   char c;
   c=uart_getc();
   lcd_goto(1, 1);//1.Zeile
   if(c=='\n') lcd_write("uart_getc() ok  ");
   else        lcd_write("uart_getc() ??  ");
   lcd_goto(2, 1);//2.Zeile
   lcd_print(c);
#endif

  }
 return 0;
}
#endif
