/* softuart.cc       letzte Aenderung: 15.2.2023
Software-UART austesten, mit Verwendung von Timer1

 Version: 0.0
 Prozessor: ATmega8
 Schaltung:
   Senden:    PB5 (TxD)
   Empfangen: PB7 (RxD)

 Autor: Rolf Pfister
 Copyright: Freeware
 History:
 15.2.2023	Erstellung, bisher nur Senden moeglich

Verwendung im Hauptprogramm:
#include <inttypes.h>
#include <avr/io.h>
#include "softuart.cc"

*/
#define HAUPTPROGRAMM  //auskommentieren wenn wie oben eingefuegt

#ifdef HAUPTPROGRAMM
#include <inttypes.h>
#include <avr/io.h>
#define F_CPU 3686400UL
#endif

#include <avr/interrupt.h>

#ifndef F_CPU
#warning "F_CPU war noch nicht definiert, wird nun nachgeholt mit 3686400"
#define F_CPU 3686400UL  // Systemtakt in Hz - Definition als unsigned long
                         // Ohne ergeben sich unten Fehler in der Berechnung
#endif
 
#define BAUDRATE 9600UL      // Baudrate
#define SUART_TXD   //senden
//#define SUART_RXD  //empfangen (geht noch nicht)

#ifdef SUART_TXD
 #define SUART_TXD_PORT PORTB
 #define SUART_TXD_DDR  DDRB
 #define SUART_TXD_BIT  PB5
 static volatile uint16_t outframe;
#endif // SUART_TXD 

#ifdef SUART_RXD
 #define SUART_RXD_PORT PORTB
 #define SUART_RXD_PIN  PINB
 #define SUART_RXD_DDR  DDRB
 #define SUART_RXD_BIT  PB7
 static volatile uint16_t inframe;
 static volatile uint8_t inbits, received;
 #ifdef _FIFO_H_
  #define INBUF_SIZE 4
  static uint8_t inbuf[INBUF_SIZE];
  fifo_t infifo;
 #else // _FIFO_H_ 
  static volatile uint8_t indata;
 #endif // _FIFO_H_ 
#endif // SUART_RXD 

void uart_init()
{
// Initialisierung für einen ATmega8 
// Für andere AVR-Derivate sieht dies vermutlich anders aus: 
// Registernamen ändern sich (zB TIMSK0 anstatt TIMSK, etc). 
 uint8_t tifr = 0;
 uint8_t sreg = SREG;
 cli();

 // Mode #4 für Timer1 
 // und volle MCU clock 
 // IC Noise Cancel 
 // IC on Falling Edge 
 TCCR1A = 0;
 TCCR1B = (1 << WGM12) | (1 << CS10) | (0 << ICES1) | (1 << ICNC1);

 // OutputCompare für gewünschte Timer1 Frequenz 
 OCR1A = (uint16_t) ((uint32_t) F_CPU/BAUDRATE);

#ifdef SUART_RXD
 SUART_RXD_DDR  &= ~(1 << SUART_RXD_BIT);
 SUART_RXD_PORT |=  (1 << SUART_RXD_BIT);
 TIMSK |= (1 << TICIE1);
 tifr  |= (1 << ICF1) | (1 << OCF1B);
#else
 TIMSK &= ~(1 << TICIE1);
#endif // SUART_RXD 

#ifdef SUART_TXD
 tifr |= (1 << OCF1A);
 SUART_TXD_PORT |= (1 << SUART_TXD_BIT);
 SUART_TXD_DDR  |= (1 << SUART_TXD_BIT);
 outframe = 0;
#endif // SUART_TXD 

 TIFR = tifr;
 SREG = sreg;

#ifdef _FIFO_H_
 fifo_init (&infifo,   inbuf, INBUF_SIZE);
#endif // _FIFO_H_
}

#ifdef SUART_TXD
void uart_putc(char c)
{
 do 
  {
   sei(); __asm__("nop"); cli(); // yield(); 
  } while (outframe); //warten bis ev. laufende Sendung abgeschlossen

 // frame = *.P.7.6.5.4.3.2.1.0.S   S=Start(0), P=Stop(1), *=Endemarke(1) 
 outframe = (3 << 9) | (((uint8_t) c) << 1);
 TIMSK |= (1 << OCIE1A);
 TIFR   = (1 << OCF1A);
 sei();
}

void uart_write(const char *s)
{
 char c;
 while((c= *s++)!=0) uart_putc(c);
}

ISR(TIMER1_COMPA_vect)
{
 uint16_t data=outframe;
 if(data & 1) SUART_TXD_PORT |=  (1 << SUART_TXD_BIT);
 else         SUART_TXD_PORT &= ~(1 << SUART_TXD_BIT);
 if(data==1) {TIMSK &= ~(1 << OCIE1A);}
 outframe = data >> 1;
}
#endif //SUART_TXD

#ifdef SUART_RXD
ISR(TIMER1_CAPT_vect)
{
 //das kann gar nicht gehen!!
 uint16_t icr1  = ICR1;
 uint16_t ocr1a = OCR1A;
   
 // Eine halbe Bitzeit zu ICR1 addieren (modulo OCR1A) und nach OCR1B
 uint16_t ocr1b = icr1 + ocr1a/2;
 if (ocr1b >= ocr1a)
  ocr1b -= ocr1a;
 OCR1B = ocr1b;
   
 TIFR = (1 << OCF1B);
 TIMSK = (TIMSK & ~(1 << TICIE1)) | (1 << OCIE1B);
 inframe = 0;
 inbits = 0;
}
#endif //SUART_RXD

bool uart_getcheck()
{
//TODO
 return (UCSRA & (1<<RXC)); //true wenn ein Zeichen verfuegbar
}

char uart_getc(void)
{
//TODO
 while (!(UCSRA & (1<<RXC))) ;// warten bis Zeichen verfuegbar
 return UDR; // Zeichen aus UDR an Aufrufer zurueckgeben
}

#ifdef HAUPTPROGRAMM
int main()
{
 //char c;
 uart_init();
 while(1)
  {
   uart_write("a");
   /*
   uart_write("D2-D4\n");
   secwait(30);
   uart_write("D4-D2\n");
   secwait(30);
   */

#ifdef SUART_RXD
   if(uart_getcheck())
     {c=uart_getc();
      uart_putc(c);
      uart_write(" uart_getc() erfolgreich\n");
     }
#endif

  }
 return 0;
}
#endif
