/* schatten.cc			letzte nderung: 1.2.2009 */
#define VERSION "Version 0.4"
/*
 Kurzbeschreibung: Darstellung des Schattenverlaufs bei Sonnenfinsternissen

History:
15.12.2006	Erstellung (RP)
18.12.  Vers0.1	Erste funktionierende Version (mit Doublebuffering)
26.5.2007  0.2  Hilfe und Menus zum Jahr einstellen eingebaut.
                Start von Grafischer Benutzeroberflaeche
		(aber Testausdrucke gehen dann nicht).
11.11.07   0.3  Groessenanpassung auch an 16:10-Bildschirm
1.2.09     0.4  Problem mit nichtrundem Kreis behoben
                (sx=...; war am falschen Ort)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <xtekplot1.h>
#include <mathpi.h>

#define XMAX 1280
#define YMAX 1024
#define TIEFE 8

const int meerfarbe=4,kontinentfarbe=5,rot=2,ringfarbe=3;

/************************* Vordeklarationen ***************************/
void erdkoordinatendrehen(double xk,double yk,double mu,double d,double *x2,double *y2,double *z2=NULL);
int karte_laden(char *name);

class Bessel
{
 int u1,u4,u5,u6;
 double x[4],y[4],d[4],mu[4],l1[4],l2[4],tanf1,tanf2,jd,mjd,u2,u3;
 double l2talt;
public:
 int jahr,monat,tag;
 Bessel() {l2talt=0;}
 void dateneinlesen(int ja,int mo);
 void zeichnen(double t);
};

class Erdedetails
{
 int j;
public:
 double xk[16000],yk[16000];//Speicher fuer alle Linien
 int nz;//Anzahl Linienzuege
 int nk[8000];//Indexgrenzen
 Erdedetails() {j=nz=0;}
 void liniekopieren(double *x,double *y,int n);
 void zeichnen(double mut,double dt);
};
static Erdedetails erdkarte;

/************************* Men Behandlung ****************************/
static int exitflag=0,nextflag=0,jahr=0,monat=0,alle=0;
void menu_exit() {exitflag=1;}
void m_hilfe()
{
 janeinrequester(
"Es wird der Schatten des Mondes bei Sonnenfinsternissen dargestellt.\n\
Beim Aufruf von einem Terminal kann man das Startjahr mit angeben.\n\
Wird auch noch der Monat mitangegeben, wird nur diese eine Finsternis\n\
dargestellt. Sonst jeweils alle Sonnenfinsternisse ab 1951 bis zum Jahr 2200.\n\
\n\
Die aktuelle Finsternis kann mit einem Mausklick gestoppt werden, um dann\n\
durch Fahren mit der Maus verschiedene Zeitpunkte genauer zu betrachten.");
}
void m_next()
{
 if(++monat==13) {jahr++; monat=1;}
 nextflag=1;
}
void m_set()
{
 int ok;
 ok=requester_input(3," Jahr ","%d","%d",&jahr,
		    " Monat","%d","%d\n",&monat,
		    "automatisch weiter (1=ja, 0=nein)","%d","%d",&alle);
 if(ok) nextflag=1;
}

/************************* Hauptprogramm ******************************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

static char *aktuellerpfad=NULL;

FILE *fopen2(char *name,char *rw)
{
 FILE *fp;
 if(aktuellerpfad!=NULL)
  {char str[strlen(aktuellerpfad)+strlen(name)+2];
   sprintf(str,"%s/%s",aktuellerpfad,name);
   fp=fopen(str,rw);
  }
 else fp=fopen(name,rw);
 return fp;
}

main(int argc,char *argv[])
{
 int maxcol,c,i,j=0;
 int breite,hoehe,tiefe,visklasse;
 const double k=1.5;
 double sx=1.25;
 double xmin= -sx*k,ymin= -k,xmax=sx*k,ymax=k;
 //tek_setdebug(1);//test
 if(argc<=0 || (argc==1 && *argv[0]=='/'))
   {j=0;/* es wurde von WorkBench (Amiga) oder von z.B. KDE (Linux) gestartet */
    if(argc==1)
      {char *s; int n=strlen(argv[0]);
       aktuellerpfad=new char[n+1];
       strcpy(aktuellerpfad,argv[0]);
       for(s= &aktuellerpfad[n];*--s!='/';) ;
       *s=0;
       setenv("PWD",aktuellerpfad,1);
      }
    jahr=1951; alle=1; //Werte bei Start von Grafischer Benutzeroberflaeche
   }
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) sscanf(argv[i],"%d",&jahr);
		 else if(j==2) sscanf(argv[i],"%d",&monat);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("schatten  %s\n",VERSION);
	 printf("Anwendung: schatten Jahr Monat\n");
	 exit(0);
	}
 if(jahr==0) {jahr=2008; monat=8; alle=0;}//naechste als Voreinstellung
 else if(monat==0) alle=1;//alle folgenden zeigen
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 maxcol=(1<<TIEFE);
// setsize(XMAX,YMAX,tiefe);
 if(breite>=XMAX && hoehe>=YMAX) {breite=XMAX; hoehe=YMAX;}
 else if(breite<XMAX && hoehe>=breite*YMAX/XMAX) {hoehe=breite*YMAX/XMAX;}
 else if(hoehe<YMAX) {breite=hoehe*XMAX/YMAX;}
 sx=double(breite)/hoehe; xmax=sx*k; xmin= -xmax;
 setsize(breite,hoehe,tiefe);
 setmenu(2,"File","Hilfe");
 setmenu(2,"Next","Hilfe...",m_next,m_hilfe);
 setmenu(1,"Jahr...",m_set);
 setmenu(1,"Exit",&menu_exit);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 setcolor(meerfarbe,100,150,255);
 Bessel bess;
 double t1,dt=0.05,xmaus,ymaus;
 int maustasten,unterbruch=0;
 karte_laden("gmtkuesten.dat");
 do
  {do
     {bess.dateneinlesen(jahr,monat);
      jahr=bess.jahr; monat=bess.monat;
      for(t1= -3.0,j=0; exitflag==0 && t1<=3.0; t1+=dt,j++)
	{waitBOF();		//auf Ende des Bildaufbaus warten
	 changebuffer(0,1);
	 screenclear();
	 bess.zeichnen(t1);
	 maustasten=mausposition(&xmaus,&ymaus);
	 if(maustasten&LIMAUS) {unterbruch=1; break;}
	}
      if(alle==1 && unterbruch==0) if(++monat==13) {jahr++; monat=1;}
     } while(alle==1 && unterbruch==0 && jahr<2200 && exitflag==0);
   for(nextflag=0; exitflag==0 && waitmenu(0)==0 && nextflag==0;)
     {maustasten=mausposition(&xmaus,&ymaus);
      t1=3.0/xmax*xmaus;
      waitTOF();	//auf Beginn des Bildaufbaus warten
      changebuffer(0,1);
      screenclear();
      bess.zeichnen(t1);
     }
   unterbruch=0;
  } while(exitflag==0);
 term_exit();
 if(aktuellerpfad!=NULL) delete[] aktuellerpfad;
 return 0;
}/* ende von main */

void Bessel::dateneinlesen(int ja,int mo)
{
 FILE *fp;
 int i;
 fp=fopen2("Ecad22.prn","r");
 if(fp==NULL) {printf("Datei mit Besselelementen nicht gefunden.\n"); return;}
 do {
  fscanf(fp,"%d %d %d",&jahr,&monat,&tag);
  fscanf(fp,"%d %lf %lf",&u1,&u2,&u3);
  fscanf(fp,"%lf %d %d %d",&jd,&u4,&u5,&u6); mjd=jd-2400000.5;
  for(i=0;i<4;i++) fscanf(fp,"%lf",&x[i]);
  for(i=0;i<4;i++) fscanf(fp,"%lf",&y[i]);
  for(i=0;i<3;i++) fscanf(fp,"%lf",&d[i]);
  for(i=0;i<2;i++) fscanf(fp,"%lf",&mu[i]);  mu[2]=mu[3]=0.0;
  for(i=0;i<3;i++) fscanf(fp,"%lf",&l1[i]);  l1[3]=0.0;
  for(i=0;i<3;i++) fscanf(fp,"%lf",&l2[i]);  l2[3]=0.0;
  fscanf(fp,"%lf %lf",&tanf1,&tanf2);
 } while(jahr<ja || (jahr==ja && monat<mo));
 fclose(fp);
 printf("%d.%d.%d Besselelemente eingelesen.\n",tag,monat,jahr);
 l2talt=0;
}
double xvont(double *x,double t)
{
 return x[0]+t*(x[1]+t*(x[2]+t*x[3]));
}
double lvont(double *x,double t)
{
 return x[0]+t*(x[1]+t*x[2]);
}
inline double dvont(double *x,double t) {return lvont(x,t);}
double muvont(double *x,double t)
{
 return x[0]+t*x[1];
}
void Bessel::zeichnen(double t)
{
 double xt,yt,l1t,l2t,mut,r2,dt,xk,yk;
 const double erdradius=1.0; //2.0/PI;//provi.
 const double xkoord=8.5*RAD, ykoord=47.5*RAD;//Geographische Koordinaten von Zuerich
 //z.B. am 3.Sep.2081 totale Sofi in Zuerich!
 double std;
 int pen,tg,stu,min;
 char str[80];
 static char *monatname[13]=
 {"","Jan","Feb","Mar","Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Dez"};
 //Datum und Zeit anschreiben:
 tg=tag;
 std=(mjd-long(mjd))*24.0+t;
 if(std<0) {--tg; std+=24.0;}
 else if(std>=24.0) {tg++; std-=24.0;}
 stu=int(std);
 min=int((std-stu)*60);
 color(1);
 sprintf(str,"%2d.%s.%04d  %02d:%02d",tg,monatname[monat],jahr,stu,min);
 schrift(1.0,1.0,str);
 //Erde zeichnen:
 //drawcircle(0.0,0.0,erdradius,erdradius);
 color(meerfarbe); fillcircle(0.0,0.0,erdradius,erdradius); color(1);
 mut=muvont(mu,t)*RAD;
 dt=dvont(d,t)*RAD;
 //Nullmeridian:
 /*for(xk=0,yk=90*RAD,pen=PENUP;yk>= -90*RAD;yk-=5*RAD)
   {erdkoordinatendrehen(xk,yk,mut,dt,&xt,&yt);
    plot(xt,yt,pen); pen=PENDOWN;
   }
 /* */
 erdkoordinatendrehen(xkoord,ykoord,mut,dt,&xt,&yt);
 drawcircle(xt,yt,0.004,0.004); //Zuerich zeichnen
 erdkarte.zeichnen(mut,dt);
 //Halbschatten:
 xt=xvont(x,t); yt=xvont(y,t);
 color(1);
 l1t=lvont(l1,t);
 drawcircle(xt,yt,l1t,l1t);
 //Kernschatten:
 l2t= -lvont(l2,t);
 double a2;
 if((a2=xt*xt+yt*yt)<1.0) //groesserer Schattendurchmesser auf der Erdkugel
   {double r=sqrt(1.0-a2), c2=l2t/tanf2;
    l2t *= (c2+r)/c2;
   }
 if(l2t<0 && l2talt>=0) printf("Ringfoermige Finsternis\n");
 else if(l2t>0 && l2talt<=0) printf("Totale Finsternis\n");
 l2talt=l2t;
 if(l2t<0.005)
   {if(l2t<0) color(ringfarbe);//Farbmarkierung fuer Ringformig
    else color(rot);
    l2t=0.005;//minimaler Kreisradius fuer kleinen Kernschatten
   }
 drawcircle(xt,yt,l2t,l2t);
}

void drehen(double &x,double &y,double w)
{
 double x1=x,y1=y,sinw=sin(w),cosw=cos(w);
 x=cosw*x1-sinw*y1;
 y=sinw*x1+cosw*y1;
}

void erdkoordinatendrehen(double xk,double yk,double mu,double d,double *x2,double *y2,double *z2)
{
 double x,y,z0,z,r=1.0;
// Erdkoordinaten xk,yk auf Erdkugel um d nach unten drehen,
// und um mu nach rechts drehen. Resultate in x2,y2
 xk+=mu; //nach rechts drehen
 z0=r*cos(yk); y=r*sin(yk);//wenn xk gleich 0 waere
 z=z0*cos(xk); x=z0*sin(xk);//auf xk drehen
 *x2=x;//beim nach unten drehen bleibt x unveraendert.
 drehen(z,y,-d);
 *y2=y;
 if(z2!=NULL) *z2=z;
}

/*************************** kleinkram ***************************/
bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n' && c!='\r')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

bool fastgleich(double x,double y,double diff)
{		/* Teste ob x==y innerhalb der Genauigkeit diff */
 double d;
 if(diff<0.) diff= -diff;
 if(x>y) d=x-y; else d=y-x;
 return (d<diff);
}

/***************** Erdedetails *******************/
void Erdedetails::liniekopieren(double *x,double *y,int n)
{
 int i;
 if(nz>=8000 || j+n>=16000)
  {printf("zu wenig Platz in Erdedetails::liniekopieren\n"); return;}
 for(i=0;i<n;i++) {xk[i+j]=x[i]*RAD; yk[i+j]=y[i]*RAD;}
 j+=n;
 nk[nz++]=j;
}
void Erdedetails::zeichnen(double mut,double dt)
{
 int n,i,pen;
 double xt,yt,zt;
 bool fuellflag;
 color(1);
 for(i=0,n=0;n<nz;n++)
  for(pen=PENUP;i<nk[n];i++)
   {erdkoordinatendrehen(xk[i],yk[i],mut,dt,&xt,&yt,&zt);
    if(zt<0) pen=PENUP;
    else {plot(xt,yt,pen); pen=PENDOWN;}
   }
}

int karte_laden(char *name)
{
 //Rckgabewert: -1=Fehler, 0=leere Datei, >1=ok
 char zeile[200],*s;
 FILE *fp;
 const int KUESTE=1;
 int j=0,nz=0,typ=0;
 double xk[1000],yk[1000];
 if(!(fp=fopen2(name,"r")))
   {printf("'%s' nicht gefunden\n",name);
    printf("Diese Datei kann mit GMT so erstellt werden:\n");
    printf("pscoast -Dc -R/-180/180/-90/90 -W -M >%s\n",name);
    return -1;
   }
 while(getline(fp,zeile,200))
   {if(*zeile==';' || *zeile=='#') continue;
    if(*zeile=='>')
      {if(j>0) {erdkarte.liniekopieren(xk,yk,j); nz++;}
       j=0;
       if(strncmp(&zeile[2],"Shore",5)==0) {typ=KUESTE;}
       else {typ=0; printf("unbekanntes Schluesselwort: %s\n",zeile);}
       continue;
      }
    if(typ==KUESTE && j<1000)
      {sscanf(zeile,"%lf %lf",&xk[j],&yk[j]); j++;}
   }
 if(j>0) {erdkarte.liniekopieren(xk,yk,j); nz++;}
 return nz;
}
