/* Showit.cc			letzte Aenderung: 27.4.2009
Linkprozeduren:
;AVAX> cx showit
;AVAX> echo "cp showit.obj [pfister.obj]  von Hand machen !"
@ blink xyshow,[pfister.obj]SHOWIT,xmenu
Linux und MacOSX:
makefile anpassen, dann "make"
*/
char *VERSION="2.91",*versionsdatum="27.4.09";
/*
  HISTORY:
13.6.1994 V2.4	Anpassung an DEC-Alpha Workstation
20.10.94	Lashow fr Hoch- und Tiefstellen von Zeichen in Titeltext
11.11.94	und auch in Achsenbeschriftungstexten
16.11.94	bei mehreren Kurven auch farbige Darstellung am Bildschirm
		(in bildgestrichelt() und Aufruf von setsize(1000,700,4);)
21.11.94	moduszusatz AUTOPLOTEXIT zugefgt
17.1.95		Vermittlerfunktion zu Fortran: SHOW_TOTAL()
21.2.95		FFT optimiert (fft_methode 3 und 4 angefgt, 2 gendert)
24.2.95		PFT und DFT zur Ueberprfung der FFT (fftmethode 5 und 6)
5.5.95		Bei Punkte-Eingabe Maxima suchen (pointsearch)
18.5.95		Abfrage fr zLashow korrigiert
24.5.95	V2.4.13	auch Bei Delta-Eingabe Maxima suchen (dpointsearch)
30.5.95	 2.4.14	Menu Diverses:Integral_Methode und Load_Voreinst. eingefgt
29.4.96 V2.5	3D-Darstellung eingebaut
25.7.96 V2.6	Verwendung von xtekplot1 in UNIX-Version
30.4.97		Anpassungsversuch fuer Henri (Fadenkreuz falsch am Henri)
13.5.97 V2.7	Problem mit Fadenkreuz geloest: drawmode() in xtekplot1
23.5.		in bildgestrichelt() auf gueltiges fpbild getestet
26.5.	V2.8	Fehler bei setrgbcolor() korrigiert, und andre Farben voreing.
		Wenn showit.voreinstellung nicht im aktuellen Verzeichnis ist
		wird jetzt auch im $HOME-Verzeichnis nachgeschaut.
6.1.98		moduszusatz AUTOSAVEEXIT zugefgt
		ab hier geht es nicht mehr auf ZUSE !!
		(Grund unbekannt, mindestens bis 2.6 ging es noch)
2.4.98		neue Funktionen: subtra_divid(), subtra_beer()
21.10.98	Neue Printer-Definitionen
23.2.99		Fehler mit inputstr1() korrigiert, jetzt immer %ld verwenden!
3.3.99	V2.9	neue Smooth-Methode: Polynomanpassung 2. bis 5. Grad
		setsmoothpara() und gewichtmethod sind neu
16.6.99		Anpassung fr Farblaser (Tektronix Phaser)
17.6.99 	Fehlende Zeile bei HPGLPLOTTER, da jetzt fr ein
		PS-Farbdrucker verwendet. (HPGL schon lange nicht mehr aktiv)
		Probleme mit color() nach moveto bei Beschriftung umgangen
		indem color() jetzt vor moveto gemacht wird.
17.9.99		Anpassungen fr MAC
17.10.2002	qgclear durch screenclear ersetzt.
31.3.2003	bei %%!PS-Adobe berflssiges % gelscht
15.1.2007 V2.91	Anpassungen an MacOSX
27.4.2009       Kleine Fehler korrigiert: in bildopen() und textfile_creat()
                jeweils (const char*)

  ANWENDUNG:
	float xmin,ymin,xmax,ymax,feld[]; int npoints,modus;
	showit(&xmin,&ymin,&xmax,&ymax,&npoints,&modus,feld,hilfsfeld);
	/* diese Stelle wird nie erreicht *
	file_exit() {exit(0);}
	file_load() {}
	file_save() {}
	user_prog(fun,p1,p2,p3,p4)  int *fun; POINTER p1,p2,p3,p4;
    benutzbare Unterprogramme:
	new_hfeld(hilfsfeld,&modus);
	lower_window();
	raise_window();
	refresh();
	yskalierung(&faktor);
 weitere Erleuterungen in GRAFIK.TXT
*/

#ifdef MACOSX
#define _POSIX_C_SOURCE 1
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <ulong.h>
#include <showit.h>
#define GRAD 0.01745329252
#define USE_IFF
#define USE_TELLAGR

#ifdef unix
#define UNIX
#define UNIX_OR_MAC
#define UNIX_OR_VAX_OR_ALPHA
#endif
#ifdef MAC
#define UNIX_OR_MAC
#undef USE_IFF
#undef USE_TELLAGR
#endif
#ifdef UNIX_OR_MAC
inline void cfree(void *x) {free(x);}
#endif

#ifdef VAX_OR_ALPHA
#define UNIX_OR_VAX_OR_ALPHA
#define XTEKPLOT_ALT
//#define USE_HPGL
#else
#define XTEKPLOT_1
#endif

#ifdef XTEKPLOT_ALT
#define plot q2plot
#define screenclear qgclear
#else
#define qterm term_refresh
#define qplotsave plotsave
#endif

static int postaktiv=0,lzugflag=0,lzugi=0,packmethode=1,entpackerflag=0,
	   hpglaktiv=0,hpglflag=0,
	   lepsflag=0,pscolorflag=0,
	   istinwarteschlaufe=0;
static double
	alfa_3d=40.*GRAD,	//Winkel bei 3D-Darstellung
	verkuerzung_3d=1.;	//Verkuerzungsfaktor in Zeit-Achse
static int
	flag_3d=0,	//gesetzt wenn Werte fuer 3D-Darstellung vorhanden
	spektcolors=0;	//Anzahl veraenderte Farben
static double   linewidth=0.5;  /* Liniendicke in Postscript */

static double xtab[4],ytab[4];

#ifndef XTEKPLOT_ALT
#ifdef UNIX
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#endif
//static FILE *fpbild=NULL;// schon in xtekplot.cc definiert
//static double psxcal,psycal,psxmin,psymin;
#endif

#define FP fprintf
#define PM packmethode
#define EOJ 24
#define AUTO 0
#define HALBAUTO 0
#define UP 3
#define DOWN 2
#define WURZEL10  3.16227766016838
#define MAXSPECT 16
static char *spename[MAXSPECT]=
	{"Name",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		NULL,NULL,NULL,NULL,NULL,NULL};
static short labeltext_flag=0,anzahl_spenamen=1;
static int xytextflag=0,ohnestrichelung=0;
static int nspektren=1;	/* Anzahl vorhandene Spektren */
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#define ESC 27

#define MODUSZUSATZ_MASK 0xFF00
#define AUTOPLOTEXIT	 0x0100
#define AUTOSAVEEXIT	 0x0200
static int moduszusatz=0;

/********************** Vordeklarationen ***************************/
/* schon in "h:showit.h" */

/* Vordeklarationen von C2CPP erzeugt: */
void pramen(double xmin,double ymin,double xmax,double ymax,double y0);
static void xaxis(double x1,double x2,double y0,double dy,int nx);
#ifdef XTEKPLOT_ALT
int idfix(double x);
#else
long idfix(double x);
#endif
static void s_error(char* problem_string);
static struct descr *machdescr(char* str,struct descr* x);
void ffwrite(char* adr,int size,int n,FILE* fp);
int lzugstart(double* xnull,double* ynull,int it,double dxo,double dxu);
void postpack1(int dx);
void entpacker(int n);
void entpacker1(int n);
void entpackvorbereitung(FILE* fp);
void postpack2(int z);
void entpacker2(int n);
void entpack2vorbereitung(FILE* fp);
void entpacker3(int n);
void entpack3vorbereitung(FILE* fp);
void fragebeschrift(int x,int* strichlang,int* teilung,int* einteilung,int* ter);
void smooth(int n,int wicht);
#ifdef __cplusplus
void printf_system(char* str,char* p1=NULL);
#endif
int getline(FILE* fp,char* s,int lim);
/* Ende der Vordeklarationen von C2CPP */
static void set_new_shmodus();
void subtra_undo();
void spektnr_setzen(char *name,int *nummer);
void spektrum_skalieren(int nr,double f),spektren_skalieren(double f);
float *zeigauf(int spektrumnummer);
static void blowup(double x1,double x2);
static void aufblasen(double x1,double x2,double fak,double add,double sub);
void ymimaxsuchen(float *,float *);
char *inputstr1(char *frage,long alt);
char *inputstr1(char *frage,char *alt);
char *inputstr3(char *frage,long a1,long a2,long a3,long a4=0);
char *inputstr1lf(char *frage,double alt);
int intinputstr1(char *frage,int alt);
double doubinputstr1(char *frage,double alt);
void lzugstop();
void pe_aus();
#ifdef XTEKPLOT_ALT
void show_total();
#endif
void show_previous();
void show_goback();
void flg_schalten(short *);
void number_zoom();
void getintoff();
void peak_getpoint();
void peak_intsave();
void edit_last_saved();
void edit_save_points();
void edit_undo();
void subtra_error();
void subtra_position();
void subtra_stretch();
void subtra_subtract();
void subtra_divid();
void subtra_beer();
//void subtra_calc();
void subtra_swap(int flag);
void subtra_exchange();
void settextpos();
void setsmooth(int n);
int setsmoothpara();
void smooth_help();
void subramp(double x1,double y1,double x2,double y2);
void plotter(int format);
void rohxy_speichern();
void modus_togg(int k);
void modus_1();
void modus_2();
void modus_4();
void modus_5();
void voreinstellungen_lesen(FILE *fp);
void integ_methode();
void load_voreinstellungen();
void save_voreinstellungen();
void setcolors(int autoflag=0);
void fft_start(int inversflag);
void fft_methode();
void show(double x1,double y1,double x2,double y2,int flag);
void fensterposition();
void bewegung(int x,int y);
void bewegung1(), klick1(),klick0();
void fadenkreuz_ein();
void fadenkreuz_aus();
void neuesfadenkreuz(int x,int y);
void fadenkreuz(int x,int y);
void klick(int knopf,int x,int y,int knopfnr);
int integral(double x1,double y1,double x2,double y2);
int differenz(double x1,double y1,double x2,double y2);
void spename_laden();
int requester(char *text,char *jatext="ok",char *neintext=NULL);
int hatlashowzeichen(char **spename,int anzahl);
void lashow_definitionen(FILE *fp);
void minmaxsearch(double &x1,double &y1,double &x2,double &y2);
void eingabe_3d(int autoflag=0);
int tfeld_laden(double x1,double y1,double x2,double y2,
		 double *tfeld,double *dx,double *dy);
void plot3d_init(double x1,double y1,double x2,double y2,int max);
void plot3d(double x,double y,int pen);

const char *showit_voreinst="showit.voreinstellungen";
#ifdef UNIX_OR_MAC
class Voreinst_global
{
public:
 char s[120];
 Voreinst_global() {sprintf(s,"%s/showit.voreinstellungen",getenv("HOME"));}
};
static Voreinst_global voreinst_global;
#define showit_voreinst_global voreinst_global.s
#else /* VAX/ALPHA */
char *showit_voreinst_global="SYS$LOGIN:showit.voreinstellungen";
#endif

#define X0 3
#define Y0 0
static short int_sflag=0,get_sflag=0;
/* fun-Werte in user_prog: */
static int	fun_intsave=1;
static int	fun_integrals=2;
static int	fun_getpoint=3;
static int	fun_getpoints=4;
static int	fun_textladen=5;
static int	fun_getdeltas=6;
#ifndef XTEKPLOT_ALT  /*schon vorhanden wenn XTEKPLOT.CC included wurde*/
static int	ramen_flag=1;		/* Rahmen zeichnen */
    /* ramen_flag: 0=aus  1=normal  2=Achse immer durch 0  3=3D-Darstellung */
#endif
static int	textflag=1,		/* Wenn moeglich beschriften */
		textposflag=0;		/* Text noch nicht positioniert */
static double	yachsenposition,
		xtext,ytext;		/* Position des Textes */

/* Korrektur 9.9.92: Konstanten um den Faktor 12.233 erhoeht */
/* 7000 = BBU+BBXMAX+BBO	9901 = BBL+BBYMAX+BBR */
#define BBXMAX 6804
#define BBYMAX 9225
#define BBU 122
#define BBL 430
#define BBR 240
#define BBO 73
#define BBDY 36
#define BBUCHSTABENBREITE 40
#define SCALEFAKTOR 0.08514
/* der Scalefaktor ist so gewaehlt dass ein Bereich von 0 0 bis 7000 9901   */
/* resultiert. Diese Zahlen lassen sich mit 16 Bit darstellen, ergeben aber */
/* immer noch eine Aufloesung von 600 dpi bei Ausgabe auf einem A3-Blatt.   */
/* Je groesser der Bereich umso besser die Aufloesung,			    */
/* je kleiner der Bereich umso weniger Bits werden bei Distanzen gebraucht. */

#ifdef XTEKPLOT_ALT
#define SHOWIT 1
#include "[pfister.x]xtekplot.cc"
#endif

#ifdef XTEKPLOT_1
#define USE_INTERNAS
//#include <xtekplot1.h>
#define SHOWIT 1
#ifdef MAC
#include <mtekplot1.cc>
#else
#include <xtekplot1.cc>
#endif
#undef USE_INTERNAS
#define fpbild tekplot_fpbild
#define dpy tekplot_dpy
#ifdef win1
#undef win1
#endif
#define win1 tekplot_win
#define gc tekplot_gc
#define rambild tekplot_rambild
#define iffflag tekplot_iffflag
#define postflag tekplot_postflag
#define initalflag tekplot_initalflag
#define rambildflag tekplot_rambildflag
#define refreshflag tekplot_refreshflag
#define winbreite tekplot_breite
#define winhoehe  tekplot_hoehe
#define fenstername tekplot_fenstername
static int fenstername1_len=0;
#define vordergrundfarbe tekplot_vordergrundfarbe
#define hintergrundfarbe tekplot_hintergrundfarbe
#define bildname tekplot_bildname
#define bildname_default tekplot_bildname_default
#endif /*XTEKPLOT_1*/

/************************ HPGL-Routinen **********************************/
#define MAXCOLOR 16
#define MAXCOLMASK 15
static int
 Rot[MAXCOLOR] = {0,255,255, 0, 0,255,  0,255,255,100,100,255,  0,  0,255,100},
 Gruen[MAXCOLOR]={0,255, 0,255,128, 0,  0,255,100,255,100,  0,255,100,100,  0},
 Blau[MAXCOLOR]= {0,255, 0, 0,255,255,255,  0,100,100,255,100,100,255,  0,255};

#ifdef USE_HPGL
static int rel_npu=0,pe_flag=0,rel_flag=0, aktuelle_farbe;
#define HPXL300 1 /* Plottermodell */
#define base 64
#define base_mask 63
#define base_shift 6
#define PE_EIN if(pe_flag==0) {fprintf(fpbild,"PE"); pe_flag=1;}
#define PE_AUS if(pe_flag) {fprintf(fpbild,";\n"); pe_flag=rel_flag=rel_npu=0;}
void pe_aus() {PE_AUS;}

char *base64(int n)
{
 static char str[8];
 char *s;
 if(n<0) n=1+((-n)<<1); else n<<=1;
 for(s=str;n>=base;n>>=base_shift)  *s++ = 63+(n&base_mask);
 if(base==64) *s++ = n+191;  else  *s++ = n+95;
 *s=0;
 return str;
}
char *base64_2(int n1,int n2)
{
 static char str[16];
 char *s;
 if(n1<0) n1=1+((-n1)<<1); else n1<<=1;
 for(s=str;n1>=base;n1>>=base_shift)  *s++ = 63+(n1&base_mask);
 if(base==64) *s++ = n1+191;  else  *s++ = n1+95;
 if(n2<0) n2=1+((-n2)<<1); else n2<<=1;
 for(;n2>=base;n2>>=base_shift)  *s++ = 63+(n2&base_mask);
 if(base==64) *s++ = n2+191;  else  *s++ = n2+95;
 *s=0;
 return str;
}
void hpcolor(int farbe)
{
 PE_EIN;
 fprintf(fpbild,":%s",base64(farbe));
 aktuelle_farbe=farbe;
}
void hpsetcolor(int farbe,int R,int G,int B)
{
 PE_AUS;
 fprintf(fpbild,"PC%d,%d,%d,%d;\n",farbe,R,G,B);
}
#endif /*USE_HPGL*/

/********************** neue Achsenbeschriftung ***************************/
#define SCALEFAKTOR 0.08514
#define MINDESTBUCH 123
#define HPF 0.082 /* Faktor fr Buchstabengrssen mit HPGL */
char *d2s(double x)
{
 char *str,*s;
 str=(char *)calloc(40,1); if(str==NULL) return "ERROR:NO_MEM";
 sprintf(str,"%lf",x);
 for(s=str; *s!=0; s++)  ;
 for(--s; *s=='0'; s--)  ;
 if(*s!='.') ++s;
 *s=0;
 return str;
}

#define TBUCHDEFAULT 184
#define TITABSTDEFAULT 196

static int
	xteilung=20,xter=5,xstrichlang=AUTO,xeinteilung=AUTO,rrand=0,hprand=0,
	yteilung=8,yter=2,ystrichlang=2,yeinteilung=HALBAUTO,
	axrand=0,yaxrand=0, /* zustzlicher Rand fr Achsenbeschriftung */
	xbuch=123,ybuch=123,tbuch=TBUCHDEFAULT,titelabst=TITABSTDEFAULT;
static double
	ramenlinewidth=1.0;
#ifndef XTEKPLOT_ALT
static char *xlabeltext="x-Achse",*ylabeltext="y-Achse";
#endif

/*********************** bildopen bildclose ******************************/
#define ipsxkor (int)psxkor
#define ipsykor (int)psykor

#ifndef XTEKPLOT_1
void FPsetrgbcolor(FILE *fp,int fa)
{
 fprintf(fp,"%lf %lf %lf setrgbcolor %%showitfarbe %d\n",
	 Rot[fa]/255.,Gruen[fa]/255.,Blau[fa]/255.,fa);
}
#endif

void bildopen(const char* name)
{
 FILE *fp,*fp1;
 double x1,y1,x2,y2,dx,dy,laenge,hoehe;
 double ymini,ymaxi,xmini,xmaxi,xstep,ystep,xoffset,yoffset;
 char str[80];
 int n,i;
#ifdef XTEKPLOT_ALT
 if(!inital1flag) {qsave1flag=1; qsaveflag=0; return;}
 x1=PLOTC.xmi; y1=PLOTC.ymi; x2=PLOTC.xma; y2=PLOTC.yma;
#else
 x1=tekplot_xmin; y1=tekplot_ymin; x2=tekplot_xmax; y2=tekplot_ymax;
#endif
 if(iffflag || postflag || hpglflag)
	fpbild=fopen(name,"w");
 else
	{textfile_creat(name);
	 fpbild=fopen(name,"a");
	}
 if((fp=fpbild)==NULL)
	{printf("Fehler beim Oeffnen von '%s'\n",name);
	 qsaveflag=0; return;
	}
#ifdef USE_IFF
 if(iffflag)
	{xminsav=x1; yminsav=y1;
	 xssav=uxmax/(x2-x1); yssav=uymax/(y2-y1);
	 fprintf(fp,"FORM");
	 laenge1=20+laenge2; laenge3=0;
	 ffwrite((char*)&laenge1,4,1,fp);
	 fprintf(fp,"VECTCMAP");
	 ffwrite((char*)&laenge2,4,1,fp);
	 fwrite(rgbtabelle,1,MAXFARB3,fp);
	 bmhd_speichern();
	 fprintf(fp,"VBDY");
	 ffwrite((char*)&laenge3,4,1,fp);
	 ffwrite((char*)&uxmax,2,1,fp); ffwrite((char*)&uymax,2,1,fp);
	 laenge3+=4; laenge1+=4;
	 return;
	}
#endif //USE_IFF
 if(labeltext_flag==0)  spename_laden();
 if(postflag)
   {
    psxcal=BBYMAX/(x2-x1); psxmin=x1;
    psycal=BBXMAX/(y2-y1); psymin=y1;
    axrand=int((xbuch-MINDESTBUCH)*SCALEFAKTOR+0.5);  if(axrand<0) axrand=0;
    yaxrand=int((ybuch-MINDESTBUCH)*SCALEFAKTOR+0.5); if(yaxrand<0) yaxrand=0;
    if(xytextflag)
	 {axrand += int(xbuch*SCALEFAKTOR);
	  yaxrand += int(3*ybuch*SCALEFAKTOR);
	 }
    if(lepsflag) // A4-Seite auf druckbaren Bereich skalieren
	{FP(fp,"save clippath pathbbox");
	 if(rrand||axrand||yaxrand)
	   {FP(fp," %d sub 4 1 roll %d sub 4 1 roll\n",
					rrand+yaxrand*2,rrand+yaxrand/2);
	    FP(fp," %d add 4 1 roll %d add 4 1 roll\n",rrand,rrand+axrand);
	   }
	 FP(fp," 3 index 3 index translate\n");
//	 FP(fp,"exch 4 1 roll exch  sub 0 sub 843 div 3 1 roll\n");
//	 FP(fp,"sub 0. sub 596 div exch scale 0. 0 translate newpath\n");
//	 FP(fp,"/showpage{}def\n");
	 FP(fp,"exch 4 1 roll exch sub 843 div 3 1 roll\n");
	 FP(fp,"sub 596 div exch scale newpath /showpage{}def\n");
	}
    else // eine EPS-Datei erzeugen
	{FP(fp,"%%!PS-Adobe-2.0 EPSF-1.2\n");
	 if(PM==0) FP(fp,"%%%%Creator: Showit-%s\n",VERSION);
	 else FP(fp,"%%%%Creator: Showit-%s (Packer%d)\n",VERSION,PM);
	 if(rrand||axrand||yaxrand)
		FP(fp,"%%%%BoundingBox: %d %d %d %d\n",
			-rrand-axrand,-rrand,596+rrand,843+rrand+yaxrand);
	 else	FP(fp,"%%%%BoundingBox: 0 0 596 843\n");
	 FP(fp,"save\n");
	}
    FP(fp,"/m /moveto load def\n");
    FP(fp,"/d /lineto load def\n");
    FP(fp,"/s /stroke load def\n");
    if(packmethode==0)
	FP(fp,"/dsm {2 copy lineto stroke moveto} bind def\n");
    FP(fp,"/zshow {m dup stringwidth pop 2 div neg 0 rmoveto show} def\n");
    FP(fp,"/yzshow {m dup stringwidth pop neg 0 rmoveto show} def\n");
    FP(fp,"/xmi %lg def /xs %lg def\n",psxmin,psxcal);
    FP(fp,"/ymi %lg def /ys %lg def\n",psymin,psycal);
    FP(fp,"0 843 translate -90 rotate\n");
    FP(fp,"%lf %lf scale %d %d translate\n",SCALEFAKTOR,SCALEFAKTOR,BBL,BBU);
    FP(fp,"%.2lf %lf div setlinewidth\n",linewidth,SCALEFAKTOR);
    if(textflag || xytextflag)
     {if(hatlashowzeichen(spename,anzahl_spenamen)) lashow_definitionen(fp);}
    if(textflag)
     {int fa;
      FP(fp,"/Helvetica findfont %d scalefont setfont\n",tbuch);
      for(i=0,fa=1;i<anzahl_spenamen;i++)
	if(*spename[i]>=' ')
	 {if(pscolorflag && fa<=nspektren)
		{
#ifdef XTEKPLOT_1
		 color(fa);
#else
		 FPsetrgbcolor(fp,fa);
#endif
		 fa=(fa+1)&MAXCOLMASK;
		}
	  if(textposflag) //dieses if-else nach color() gemacht 17.6.99
		FP(fp,"%d %d m\n",ipsxkor(xtext),ipsykor(ytext)-titelabst*i);
	  else	FP(fp,"%d %d m\n",BBYMAX/4,BBXMAX*94/100-titelabst*i);
	  if(*spename[i]=='$') FP(fp,"(%s) %d Lashow\n",&spename[i][1],tbuch);
	  else FP(fp,"(%s) show\n",spename[i]);
     }	 }
#ifdef XTEKPLOT_1
    if(pscolorflag) color(1);
#else
    if(pscolorflag) FPsetrgbcolor(fp,1);
#endif
//  fprintf(fp," %d %d m %d %d d %d %d d %d %d d closepath s\n", -BBL,-BBU,
//	    -BBL,BBXMAX+BBO, BBYMAX+BBR,BBXMAX+BBO, BBYMAX+BBR,-BBU);// test
    if(ramen_flag)
	{ ymini=yachsenposition;}
    else
	{ dy=y2-y1;
	  ystep=rundezahl(dy/4., dy/10.);
	  ymini=rundezahl(y1,y1+ystep);   }
    if(!ramen_flag)
       {FP(fp,"%d %d m %d %d d %d %d d\n", ipsxkor(x1),ipsykor(ymini),
			 ipsxkor(x1),ipsykor(y2), ipsxkor(x2),ipsykor(y2));
	FP(fp,"%d %d d closepath s\n", ipsxkor(x2),ipsykor(ymini));
       }
    postaktiv=1;
    return;
   }
#ifdef USE_HPGL
 if(hpglflag)
   {
#define BBHPU 122
#define BBHPL 500
#define BBHPR 240
#define BBHPO 73
#define HPGLBREITE 11200
#define HPGLHOEHE 8000
    int br,ho;
    axrand=xbuch-MINDESTBUCH;  if(axrand<0) axrand=0;
    yaxrand=ybuch-MINDESTBUCH; if(yaxrand<0) yaxrand=0;
    hprand=int(rrand/SCALEFAKTOR);
    axrand=int(axrand/SCALEFAKTOR); yaxrand=int(yaxrand/SCALEFAKTOR);
    FP(fp,"%c%%-1BBPINPS%d,%d",ESC,HPGLBREITE,HPGLHOEHE);
    br=HPGLBREITE-BBHPL-BBHPR-2*hprand-yaxrand;
    ho=HPGLHOEHE-BBHPU-BBHPO-2*hprand-axrand;
    FP(fp,"NP%dPW;\n",MAXCOLOR);
    for(i=0;i<MAXCOLOR;i++) hpsetcolor(i,Rot[i],Gruen[i],Blau[i]);
    psxcal=br/(x2-x1); psxmin=x1-(BBHPL+hprand+yaxrand)/psxcal;
    psycal=ho/(y2-y1); psymin=y1-(BBHPU+hprand+axrand)/psycal;
    hpglaktiv=1;
    if(textflag)
     {FP(fp,"SD1,21,2,1,3,%lg,4,%lg,7,4SSLO1;\n",tbuch*7/10*HPF,tbuch*HPF);
      if(textposflag) FP(fp,"PU%d,%d",ipsxkor(xtext),ipsykor(ytext));
      else FP(fp,"PU%d,%d",br/4+BBHPL+hprand+yaxrand,
			ho*94/100+BBHPU+hprand+axrand);
      for(i=0;i<anzahl_spenamen;i++) FP(fp,"LB%s\003CP;\n",spename[i]);
     }
    hpcolor(1);
    return;
   }
#endif /*USE_HPGL*/
#ifdef USE_TELLAGR
 if((fp1=fopen("TELLA.INI","r"))!=NULL)
       {printf("TELLA.INI ");
	while(fgets(str,80,fp1))
		fputs(str,fp);
	fclose(fp1);
	printf("eingelesen\n");
	return;
       }
 fprintf(fp,"PAGE LAYOUT IS HRH.\n");
 fprintf(fp,"GEN PLOT.\n");
 fprintf(fp,"NO PAGE BORDER.\n");
 fprintf(fp,"EVERY CURVE SOLID SYMBOL COUNT 0, THICKNESS 0.001.\n");
 fprintf(fp,"NO LEGEND.\n");
 fprintf(fp,"Y DETACH 90.\n");
 fprintf(fp,"X LABEL TEXT '%s'.\n",xlabeltext);
 fprintf(fp,"Y LABEL TEXT '%s'.\n",ylabeltext);
 fprintf(fp,"CROSS OFF.\n");
 fprintf(fp,"MES HEIGHT 0.16, FRAME OFF,\n");
//			0.217=0.5cm ?
 fprintf(fp," UNITS COORDINATE, TEXT '%s'.\n",spename[0]);
 fprintf(fp,"MES X %lg, MESSAGE Y %lg.\n",
		     (3*x1+x2)/4.,     y1+(y2-y1)*0.94);
 fprintf(fp,"MES STYLE TRIPLEX.\n");
 fprintf(fp,"GRACE 10.\n");
 dx=x2-x1;
 xstep=rundezahl(dx/6., dx/20.);
 xmini=rundezahl(x1,x1+xstep);
 n=int((x2-xmini)/xstep);
 xmaxi=xmini+xstep*n;
 dx=xmaxi-xmini;
 if(ramen_flag)
   { ymini=yachsenposition;
     dy=y2-ymini; ystep=rundezahl(dy/4., dy/10.); }
 else
   { dy=y2-y1;
     ystep=rundezahl(dy/4., dy/10.);
     ymini=rundezahl(y1,y1+ystep);   }
 n=int((y2-ymini)/ystep);
 ymaxi=ymini+ystep*n;
 dy=ymaxi-ymini;
 laenge=dx*rundezahl(LMIN/(x2-x1),LMAX/(x2-x1));
 hoehe=dy*rundezahl(HMIN/(y2-y1),HMAX/(y2-y1));
 fprintf(fp,"X AXIS LENGTH %.4lf. *** %.1lfcm ***\n",laenge/INCHX,laenge);
 fprintf(fp,"Y AXIS LENGTH %.4lf. *** %.1lfcm ***\n",hoehe/INCHY,hoehe);
 fprintf(fp,"X MINIMUM %lg MAXIMUM %lg STEP %lg.\n",xmini,xmaxi,xstep);
 fprintf(fp,"Y MINIMUM %lg MAXIMUM %lg STEP %lg.\n",ymini,ymaxi,ystep);
 xoffset=yoffset=0.0;
 if(xmini!=x1)
   fprintf(fp,"Y OFFSET -%lf.\n",yoffset=laenge/INCHX/(xmaxi-xmini)*(xmini-x1));
 if(ymini!=y1 && ramen_flag==0)
   fprintf(fp,"X OFFSET -%lf.\n",xoffset=hoehe/INCHY/(ymaxi-ymini)*(ymini-y1));
 fprintf(fp,"X ORIGIN %.4lf, Y ORIGIN %.4lf.\n",1.00+yoffset,0.65+xoffset);
//				Rand minimal:	2.3cm	     1.5cm
 fprintf(fp,"INPUT DATA.\n");
 if(!ramen_flag)
   fprintf(fp,"'0'\n%lg %lg  %lg %lg  %lg %lg  %lg %lg  %lg %lg\n",
			x1,y1, x1,y2, x2,y2, x2,y1, x1,y1);
 ncurv=1;
#else
 fprintf(fp,"PAGE LAYOUT IS HRH.\n");
 fprintf(fp,"cant create correct TELLAGRAF files.\n");
 ncurv=1;
#endif //USE_TELLAGR
 return;
}

void bildplot(double x,double y,int pen)
{
 static UBYTE farbe=1, npu=0;
 static int ncount=0, npu2=0;
 static UWORD ux,uy,ufeld[512];
 static int dxflag;
 static double xalt,yalt,dxaltu,dxalto,ynull,xnull;
 double dx;
 int h,i,ix,iy;
 char *str;
#define psxkornull(x) idfix((x-xnull)*psxcal)
#define psykornull(y) idfix((y-ynull)*psycal)
 if(postflag)
 {if(packmethode!=0)
   {if(pen==2) /* Linie zeichnen */
     {if(lzugflag)
	{dx=(x-xalt)*psxcal;
	 if(!dxflag) ix=psxkornull(x);
	 iy=psykornull(y);
	 ++lzugi;
	 if((dxflag && (dx<dxaltu||dx>dxalto)) ||
	    (lzugi>200&&(lzugi>1000||abs(iy)>1023||(!dxflag&&abs(ix)>1023)))
	   )	{lzugstop(); lzugi=2;
		 xtab[0]=xalt; ytab[0]=yalt; xtab[1]=x; ytab[1]=y;
		 return;
		}
	 if(dxflag) {if(PM==1) postpack1(psykornull(y));
		     else postpack2(ipsykor(y));
		    }
	 else	{if(PM==1) {postpack1(ix); postpack1(iy);}
		 else {postpack2(ipsxkor(x)); postpack2(ipsykor(y));}
		}
	}
      else
	{xtab[lzugi]=x; ytab[lzugi++]=y;
	 if(lzugi==4)	{dx=(x-xalt)*psxcal;
			 if(dx>=0.){dxalto=dx*1.00000001; dxaltu=dx/1.00000001;}
			 else	   {dxaltu=dx*1.00000001; dxalto=dx/1.00000001;}
			 dxflag=lzugstart(&xnull,&ynull,lzugi,dxalto,dxaltu);
			 lzugflag=1;
	}		}
      xalt=x; yalt=y;
     }
    else /* pen!=2  Stift bewegen */
     {if(lzugi>1) lzugstop();
      xtab[0]=x; ytab[0]=y; lzugi=1;
     }
    return;
   }
  else /* packmethode==0 */
   {if(pen==2) /* Linie zeichnen */
	{if(lzugi>=500) {str="dsm\n"; lzugi=0;}
	 else if(lzugi%5==0) str="d\n";
	 else str="d ";
	 FP(fpbild,"%d %d %s",ipsxkor(x),ipsykor(y),str); lzugi++;
	}
    else /* pen!=2  Stift bewegen */
	{if(lzugi!=0) FP(fpbild,"s\n");
	 FP(fpbild,"%d %d m ",ipsxkor(x),ipsykor(y)); lzugi=lzugflag=1;
	}
    return;
 } }
#ifdef USE_HPGL
 if(hpglflag)
 {static int i0,j0;
  int i,j;
  i=idfix(psxcal*(x-psxmin)); j=idfix(psycal*(y-psymin));
  PE_EIN;
  if(pen!=2) {fprintf(fpbild,"<"); rel_flag=0;}
  if(rel_flag==0) {fprintf(fpbild,"=%s",base64_2(i,j)); rel_flag=1;}
  else fprintf(fpbild,"%s",base64_2(i-i0,j-j0));
  if(++rel_npu>=10) {fprintf(fpbild,"\n"); rel_npu=0;}
  i0=i; j0=j;
  return;
 }
#endif /*USE_HPGL*/
#ifdef USE_IFF
 if(iffflag)
   {/* DEBUG(1,printf("npu=%d npu2=%d\n",npu,npu2)); */
    if(npu>1 && (pen==3 || npu==255))
	{fwrite(&npu,1,1,fpbild); fwrite(&farbe,1,1,fpbild);
	 h=2+npu2+npu2; laenge3+=h; laenge1+=h;
/*	 DEBUG(1,printf("ffwrite(ufeld,2,npu2,fp);\n")); */
	 ffwrite((char*)ufeld,2,npu2,fpbild); npu2=0;
	 ufeld[npu2++]=ux; ufeld[npu2++]=uy; npu=1;
	}
    if(pen==3)
	{//if(pattern==DELETE) farbe=0;
	 //else {farbe=pattern-'`'+1; if(farbe>MAXFARB) farbe=MAXFARB;}
	 farbe=tek_farbe;
	 npu=npu2=0;
	}
    x=(x-xminsav)*xssav;
    y=(y-yminsav)*yssav;
    if(x<=0.) ux=0; else ux=int(x+0.5);
    if(y<=0.) uy=0; else uy=int(y+0.5);
    ufeld[npu2++]=ux;
    ufeld[npu2++]=uy;
/*    DEBUG(1,printf("ux=%d uy=%d\n",ux,uy)); */
    npu++;
    return;
   }
#endif //USE_IFF
/* sonst Tellagraf: */
 if(pen!=2)
	{fprintf(fpbild,"\n\"%d\"\n",ncurv);
	 ncurv++;
	 ncount=0;
	}
 if(ncount==0) fprintf(fpbild,"\n");
 fprintf(fpbild,"%lg %lg ",x,y);
 if(++ncount>=5) ncount=0;
 return;
}

void bildclose()
{
 if(postflag)
	{if(lzugi>1) lzugstop();
	 if(lepsflag) fprintf(fpbild,"\nrestore showpage\n");
	 else	fprintf(fpbild,"\nshowpage\nrestore\n");
	 postaktiv=0; entpackerflag=0;
	}
#ifdef USE_IFF
 else if(iffflag)
	{bildplot(xminsav,yminsav,3);
	 fseek(fpbild,4,0); ffwrite((char*)&laenge1,4,1,fpbild);
	 fseek(fpbild,laenge2+16+sizeof(bmhd)+8,1);
	 ffwrite((char*)&laenge3,4,1,fpbild);
	}
#endif //USE_IFF
#ifdef USE_HPGL
 else if(hpglflag)
	{PE_AUS;
	 fprintf(fpbild,"PUSP0PG;\n");
	 hpglaktiv=0;
	}
#endif
 else
	{fprintf(fpbild,"\nEOD.\n");
	 fprintf(fpbild,"GO.\n");
	}
 fclose(fpbild); fpbild=NULL;
 qsaveflag=0;
 return;
}

/*************************************************************************/
static void yaxis(double y1,double y2,double x0,double dx,int ny)
{
 int iy,iymax;
 double y,ydiff,xlang;
 double y0,dx4;
 if(y2<y1) {y=y1; y1=y2; y2=y;}
/* if(ny<5 && yeinteilung==AUTO) ny=5; else */
 if(ny<1) ny=1;
 else if(ny>10000) ny=10000;
 if(yeinteilung==AUTO)	 {y=(y2-y1)/ny/WURZEL10; ydiff=rundezahl(10.0*y,y);}
 else if(yeinteilung==1) {y=(y2-y1)/ny/1.1; ydiff=rundezahl(1.2*y,y);}
 else ydiff=(y2-y1)/ny;
 if(y1+ydiff>y2)
   {printf(" YAXIS-Error:\ny1=%lf  y2=%lf  x0=%lf  dx=%lf  ny=%d\n",
			   y1,y2,x0,dx,ny);
    ydiff=(y2-y1)/5;
   }
 if(lzugi>1) lzugstop();
 if(postaktiv)
	FP(fpbild,"%.2lf %lf div setlinewidth\n",ramenlinewidth,SCALEFAKTOR);
 else if(hpglaktiv) ;/* provi.*/
 plot(x0,y1,UP);
 if(yeinteilung<=1) y0=y=rundezahl(y1+ydiff,y1);
 else y0=y=y1;
 iymax=int(y2/ydiff);
 for(iy=idfix(y/ydiff); iy<=iymax; iy++)
  {if(ystrichlang==AUTO)
	{if(iy%5==0)	{xlang=dx+dx; if(iy%10==0) xlang+=dx;}
	 else		xlang=dx;
	}
   else if(ystrichlang==1 || (iy%ystrichlang)!=0) xlang=dx*1.5;
   else xlang=dx*3.;
   plot(x0,y,DOWN); plot(x0-xlang,y,DOWN); plot(x0,y,DOWN);
   y+=ydiff;
  }
 plot(x0,y2,DOWN);
 if(postaktiv)
  {if(ystrichlang==1) dx4=dx*2.; else dx4=dx*4.;
   if(lzugi>1) lzugstop();
   FP(fpbild,"/Helvetica findfont %d scalefont setfont\n",ybuch);
   if(ydiff>=1.0)
   {FP(fpbild,"/yd %ld def ",idfix(ydiff));
    FP(fpbild,"%ld 1 %d {dup %d mod 0 eq {yd mul\n",idfix(y0/ydiff),iymax,yter);
   }
   else
   {FP(fpbild,"/yd %ld def ",idfix(1./ydiff));
    FP(fpbild,"%ld 1 %d {dup %d mod 0 eq {yd div\n",idfix(y0/ydiff),iymax,yter);
   }
    FP(fpbild,
        "/yw 1 index def 20 string cvs %lg yw ymi sub ys mul %d sub yzshow}\n",
        (x0-dx4-psxmin)*psxcal, ybuch/4);
   FP(fpbild,"{pop}ifelse}for\n");
   if(xytextflag && ylabeltext!=NULL)
     {if(*ylabeltext=='$')
	{FP(fpbild,"gsave (%s)\n",&ylabeltext[1]);
	 FP(fpbild,"%lg %lg m 90 rotate %d Lashow grestore\n",
	    (x0-dx4-psxmin)*psxcal-3.*ybuch,((y1+y2)/2.-psymin)*psycal,ybuch);
	}
      else
	{FP(fpbild,"gsave (%s)\n",ylabeltext);
	 FP(fpbild,"%lg %lg m 90 rotate show grestore\n",
		(x0-dx4-psxmin)*psxcal-3.*ybuch,((y1+y2)/2.-psymin)*psycal);
     }	}
  }
#ifdef USE_HPGL
 else if(hpglaktiv)
  {double yw=y0;
   int i;
   if(ystrichlang==1) dx4=dx*2.; else dx4=dx*4.;
   pe_aus();
   FP(fpbild,"SD1,21,2,1,3,%lg,4,%lg,7,4SSLO8;\n",ybuch*7/10*HPF,ybuch*HPF);
   for(i=idfix(y0/ydiff);i<=iymax;i++)
     {if(i%yter==0)
	{FP(fpbild,"PU%d,%d",
		idfix((x0-dx4-psxmin)*psxcal),idfix((yw-psymin)*psycal));
	 FP(fpbild,"LB%s\003\n",d2s(yw));
	}
      yw+=ydiff;
     }
   if(xytextflag && ylabeltext!=NULL)
	{FP(fpbild,"PU%d,%d", idfix((x0-dx4-psxmin)*psxcal-3.*ybuch),
			      idfix((y1+y2)/2.*psycal));
	 FP(fpbild,"DI0,1LB%s\003\n",ylabeltext);
	}
  }
#endif /*USE_HPGL*/
}

/**************************** ppramen *********************************/
/* #include "ppramen.c" */

void pramen(double xmin,double ymin,double xmax,double ymax,double y0)
{
 double dy,dy2;
 if(lzugi>1) lzugstop();
 if(postaktiv)
	FP(fpbild,"%.2lf %lf div setlinewidth\n",ramenlinewidth,SCALEFAKTOR);
 plot(xmin,ymin,UP);   plot(xmin,ymax,DOWN);
 plot(xmax,ymax,DOWN); plot(xmax,ymin,DOWN); /* oberer Teil des Rahmens */
 dy=(ymax-ymin)/100.;
 dy2=(y0-ymin)/4.;
 if(ymax>ymin)  {if(dy>dy2) dy=dy2;}
 else		{if(dy<dy2) dy=dy2;}
 xaxis(xmin,xmax,y0,dy,xteilung);
/* if(postaktiv) yaxis(y0,ymax,xmin,(xmax-xmin)/150.,yteilung); */
 if(postaktiv||hpglaktiv) yaxis(ymin,ymax,xmin,(xmax-xmin)/150.,yteilung);
}

static void xaxis(double x1,double x2,double y0,double dy,int nx)
{
 int ix,ixmax;
 double x,xdiff,ylang;
 double x0,dy4;
 if(x2<x1) {x=x1; x1=x2; x2=x;}
/* if(nx<10 && xeinteilung==AUTO) nx=10; else */
 if(nx<1) nx=1;
 else if(nx>10000) nx=10000;
 if(xeinteilung==AUTO)	 {x=(x2-x1)/nx/WURZEL10; xdiff=rundezahl(10.0*x,x);}
 else if(xeinteilung==1) {x=(x2-x1)/nx/1.1; xdiff=rundezahl(1.2*x,x);}
 else xdiff=(x2-x1)/nx;
 if(x1+xdiff>x2)
   {printf(" XAXIS-Error:\nx1=%lf  x2=%lf  y0=%lf  dy=%lf  nx=%d\n",
			   x1,x2,y0,dy,nx);
    xdiff=(x2-x1)/5;
   }
 if(lzugi>1) lzugstop();
 if(postaktiv)
	FP(fpbild,"%.2lf %lf div setlinewidth\n",ramenlinewidth,SCALEFAKTOR);
 plot(x1,y0,UP);
 if(xeinteilung<=1) x0=x=rundezahl(x1+xdiff,x1);
 else x0=x=x1;
 ixmax=int(x2/xdiff);
 for(ix=idfix(x/xdiff); ix<=ixmax; ix++)
  {if(xstrichlang==AUTO)
	{if(ix%5==0)	{ylang=dy+dy; if(ix%10==0) ylang+=ylang;}
	 else		ylang=dy;
	}
   else if(xstrichlang==1 || (ix%xstrichlang)!=0) ylang=dy*1.5;
   else ylang=dy*4.;
   plot(x,y0,DOWN); plot(x,y0-ylang,DOWN); plot(x,y0,DOWN);
   x+=xdiff;
  }
 plot(x2,y0,DOWN);
 if(postaktiv)
  {if(xstrichlang==1) dy4=dy*3.; else dy4=dy*4.;
   if(lzugi>1) lzugstop();
   FP(fpbild,"/Helvetica findfont %d scalefont setfont\n",xbuch);
   if(xdiff>=1.0)
   {FP(fpbild,"/xd %ld def ",idfix(xdiff));
    FP(fpbild,"%ld 1 %d {dup %d mod 0 eq {xd mul\n",idfix(x0/xdiff),ixmax,xter);
   }
   else
   {FP(fpbild,"/xd %ld def ",idfix(1./xdiff));
    FP(fpbild,"%ld 1 %d {dup %d mod 0 eq {xd div\n",idfix(x0/xdiff),ixmax,xter);
   }
    FP(fpbild,
        "/xw 1 index def 20 string cvs xw xmi sub xs mul %lg zshow}\n",
        (y0-dy4-psymin)*psycal-xbuch);
   FP(fpbild,"{pop}ifelse}for\n");
   if(xytextflag && xlabeltext!=NULL)
     {if(*xlabeltext=='$')
	{FP(fpbild,"(%s)\n",&xlabeltext[1]);
	 FP(fpbild,"%lg %lg %d zLashow\n",
	    ((x1+x2)/2.-psxmin)*psxcal,(y0-dy4-psymin)*psycal-2.2*xbuch,xbuch);
	}
      else
	{FP(fpbild,"(%s)\n",xlabeltext);
	 FP(fpbild,"%lg %lg zshow\n",
		((x1+x2)/2.-psxmin)*psxcal,(y0-dy4-psymin)*psycal-2.2*xbuch);
     }	}
  }
#ifdef USE_HPGL
 else if(hpglaktiv)
  {double xw=x0;
   int i;
   if(xstrichlang==1) dy4=dy*3.; else dy4=dy*4.;
   pe_aus();
   FP(fpbild,"SD1,21,2,1,3,%lg,4,%lg,7,4SSLO16;\n",xbuch*7/10*HPF,xbuch*HPF);
   for(i=idfix(x0/xdiff);i<=ixmax;i++)
     {if(i%xter==0)
	{FP(fpbild,"PU%d,%d",
		idfix((xw-psxmin)*psxcal),idfix((y0-dy4-psymin)*psycal));
	 FP(fpbild,"LB%s\003\n",d2s(xw));
	}
      xw+=xdiff;
     }
   if(xytextflag && xlabeltext!=NULL)
	{FP(fpbild,"PU%d,%d",	idfix(((x1+x2)/2.-psxmin)*psxcal),
				idfix((y0-dy4-psymin)*psycal-2.2*xbuch));
	 FP(fpbild,"LB%s\003\n",xlabeltext);
	}
  }
#endif /*USE_HPGL*/
}

#ifndef XTEKPLOT_1
int idfix(double x) // korrekte Rundung
{
 int n;
 if(x>=0.) n=(int)(x+0.5); else n=(int)(x-0.5);
 return n;
}
#endif
/*************************ende ppramen*********************************/

void spename_laden()
{
 char *p;
 int c,i;
 user_prog(&fun_textladen,&spename[0],&xlabeltext,&ylabeltext,NULL);
 for(i=0,p=spename[0]; (c= *p) && i<10; p++)
        if(c=='\n') {*p=0; spename[++i]=p+1;}
 anzahl_spenamen=i+1;
 labeltext_flag=1;
/* printf("Test in spename_laden() :\n");/* test */
/* for(i=0;i<anzahl_spenamen;i++)/* test */
/*      printf("spename[%d]='%s'\n",i,spename[i]);/* test */
 return;
}

void bildgestrichelt(int farbe)
{
 if(tekplot_tiefe>1 && farbe>1) color(farbe);
 if(pscolorflag)
  {if(lzugi>1) lzugstop();
#ifndef XTEKPLOT_1
   farbe &= MAXCOLMASK;
   if(fpbild) FPsetrgbcolor(fpbild,farbe);
#endif
  }
 else if(postflag)
  {if(lzugi>1) lzugstop();
   if(ohnestrichelung==0 && fpbild) fprintf(fpbild,"[35] 0 setdash\n");
  }
#ifdef USE_HPGL
 else if(hpglflag)
  {hpcolor(farbe&MAXCOLMASK);}
#endif
 return;
}

void bildnichtgestrichelt()
{
 if(tekplot_tiefe>1) color(1);
 if(pscolorflag)
  {if(lzugi>1) lzugstop();
#ifndef XTEKPLOT_1
   if(fpbild) FPsetrgbcolor(fpbild,0);
#endif
  }
 else if(postflag)
  {if(lzugi>1) lzugstop();
   if(ohnestrichelung==0 && fpbild) fprintf(fpbild,"[] 0 setdash\n");
  }
#ifdef USE_HPGL
 else if(hpglflag)
  {hpcolor(1);}
#endif
 return;
}

/*************** Behandlung der Linienzuege in Postscript ****************/
static int packzaehler=0,endzeichen='!';
static char *lzugname="lzug",*lzug1name="lzug",*lzug2name="lzug2",
	    *lzug0name="lzug0",*lzug3name="lzug3";

void printfpackmethode(int flg)
{
 switch(packmethode)
	{case 1: if(flg) printf("Es werden 6 Bits in ein ASCI-Byte gepackt\n");
		 lzugname=lzug1name; endzeichen='!'; break;
	 case 2: if(flg) printf("Binaeres speichern\n");
		 lzugname=lzug2name; endzeichen=0xFF; break;
	 case 3: if(flg) printf("Immer 18 Bits in 3 Bytes packen\n");
		 lzugname=lzug3name; endzeichen='!'; break;
	 default: if(flg) printf("0 = nicht packen\n");
		  endzeichen='s';
	}
}

int lzugstart(double* xnull,double* ynull,int it,double dxo,double dxu)
{
 int i,flag;
 double dx;
 packzaehler=0;
 for(flag=1,i=1;i<it-1;i++)
	{dx=(xtab[i]-xtab[i-1])*psxcal; if(dx<dxu || dx>dxo) {flag=0; break;}}
 *xnull=xtab[0]; *ynull=ytab[0];
 if(flag)
	{if((entpackerflag&1)==0) entpacker(1);
	 fprintf(fpbild,"%d %d m %.10lg x%s\n",
		 ipsxkor(xtab[0]),ipsykor(ytab[0]),dx,lzugname);
	 for(i=1;i<it;i++)
		{if(PM==1) postpack1(idfix((ytab[i]- *ynull)*psycal));
		 else postpack2(ipsykor(ytab[i]));
		}
	}
 else	{if((entpackerflag&2)==0) entpacker(2);
	 fprintf(fpbild,"%d %d m %s\n",
			ipsxkor(xtab[0]),ipsykor(ytab[0]),lzugname);
	 for(i=1;i<it;i++)
	    if(PM==1)	{postpack1(idfix((xtab[i]- *xnull)*psxcal));
			 postpack1(idfix((ytab[i]- *ynull)*psycal));
			}
	    else  {postpack2(ipsxkor(xtab[i])); postpack2(ipsykor(ytab[i]));}
	}
 return flag;
}

void lzugstop()
{
 int i;
 if(lzugflag)  {fprintf(fpbild,"%c\n",endzeichen); lzugflag=0;}
 else	{fprintf(fpbild,"%d %d m ",ipsxkor(xtab[0]),ipsykor(ytab[0]));
	 for(i=1;i<lzugi;i++)
		fprintf(fpbild,"%d %d d ",ipsxkor(xtab[i]),ipsykor(ytab[i]));
	 fprintf(fpbild,"s\n");
	}
 lzugi=0;
}

void postpack1(int dx) /* dx oder dy in 2 oder 3 Bytes packen */
{
 int vorz,n1,n2,n3;
 if(dx<0) {vorz=0x20; dx= -dx;} else vorz=0;
/* if(dx>9901) printf("dx=%d vorz=%d\n",dx,vorz);/* test */
 n3=dx&0x3F; n2=(dx>>6)&0x3F; /* in jedes Byte koennen 6 Bits gepackt werden */
 if(dx>0x3FF) /* mehr als 10 Bits ? */
	{n1=(dx>>12)+vorz+0x10; /* Markierung fuer 3 Bytes */
	 fprintf(fpbild,"%c%c%c",n1+'0',n2+'0',n3+'0'); packzaehler+=3;
	}
 else	{fprintf(fpbild,"%c%c",n2+vorz+'0',n3+'0'); packzaehler+=2;
	}
 if(packzaehler>=78) {fprintf(fpbild,"\n"); packzaehler=0;}
}

void entpacker(int n)
{
 switch(packmethode)
  {case 1:entpacker1(n); break;
   case 2:entpacker2(n); break;
   case 3:entpacker3(n); break;
  }
}

void entpacker1(int n)
{
 FILE *fp=fpbild;
 if(entpackerflag==0) entpackvorbereitung(fpbild);
 entpackerflag |= n;
 if(n==1)
  {FP(fp,"/xlzug{curr x0 {1 index add dup rx{y0 add d}{exit}ifelse} loop\n");
   FP(fp," pop pop pop s} bind def\n");
  }
 else
  {FP(fp,"/lzug{curr");
   FP(fp," {rx{x0 add rx pop y0 add d}{exit}ifelse}loop s} bind def\n");
  }
}

void entpackvorbereitung(FILE* fp)
{
 FP(fp,"/curr {currentpoint /y0 exch def /x0 exch def} bind def\n");
 FP(fp,"/rd {currentfile read pop 48 sub} bind def\n");
 FP(fp,"/rd3 {dup 31 and dup 16 ge{15 and 6 bitshift rd add}if\n");
 FP(fp," 6 bitshift rd add exch 32 ge{neg}if} bind def\n");
 FP(fp,"/rx {{rd dup 0 lt{-15 eq{false exit}if}{rd3 true exit}ifelse}");
 FP(fp," loop} bind def\n");
}

void postpack2(int z)
{
 if(PM==2) FP(fpbild,"%c%c",z>>8,z&0xFF);
 else
  {static int zaehl=0;
   FP(fpbild,"%c%c%c",(z>>12)+'0',((z>>6)&0x3F)+'0',(z&0x3F)+'0');
   if(++zaehl>25) {FP(fpbild,"\n"); zaehl=0;}
  }
}

void entpacker2(int n)
{
 FILE *fp=fpbild;
 if(entpackerflag==0) entpack2vorbereitung(fpbild);
 entpackerflag |= n;
 if(n==1)
  {FP(fp,"/curr {currentpoint /y0 exch def /x0 exch def} bind def\n");
   FP(fp,"/xlzug2 {curr x0 {1 index add dup cr dup 255 eq{exit}if\n");
   FP(fp," bs8 cr add d} loop s 4{pop}repeat} bind def\n");
  }
 else
  {FP(fp,"/lzug2 {{cr dup 255 eq{exit}if bs8 cr add\n");
   FP(fp," cr bs8 cr add d} loop s pop} bind def\n");
  }
}

void entpack2vorbereitung(FILE* fp)
{
 FP(fp,"/bs8 {8 bitshift} bind def\n");
 FP(fp,"/cr {currentfile read pop} bind def\n");
}

void entpacker3(int n)
{
 FILE *fp=fpbild;
 if(entpackerflag==0) entpack3vorbereitung(fpbild);
 entpackerflag |= n;
 if(n==1)
  {FP(fp,"/curr {/x0 currentpoint pop def} bind def\n");
   FP(fp,"/xlzug3 {curr x0 {1 index add dup rx{d}{exit}ifelse}loop\n");
   FP(fp," s pop pop pop} bind def\n");
  }
 else
  {FP(fp,"/lzug3 {{rx{rd bs d}{exit}ifelse} loop s} bind def\n");
  }
}

void entpack3vorbereitung(FILE* fp)
{
 FP(fp,"/rd {currentfile read pop 48 sub} bind def\n");
 FP(fp,"/bs {6 bitshift rd add 6 bitshift rd add} bind def\n");
 FP(fp,"/rx {{rd dup 0 lt{-15 eq{false exit}if}{bs true exit}ifelse}");
 FP(fp," loop} bind def\n");
}

/*************************** HAUPTPROGRAMM ******************************/
#define CASE break;case
#define DEFAULT break;default
#define DECLASER	1
#define IBMLASER	2
#define PSPLOTTER	3
#define HPGLPLOTTER	4
#define HPGLDATEI	5
#define IFFDATEI	6
#define TELLDATEI	7
#define PSDATEI		8
#define PSDATEIFARBIG	9
#define ROHXYDATEI	10

static int	npkt,		/* Anzahl Punkte des ganzen Spektrums */
		faden_x = -1,
		faden_y = -1,	/* aktuelle Position des Fadenkreuzes */
		integral_x1,
		integral_y1,	/* aktueller 1.Punkt der Integrierlinie */
		on_x = -1,	/* Wert um Edit-Fadenkreuz festzuhalten */
		shmodus,
/*		nspektren=1,	/* Anzahl vorhandene Spektren */
		smoothNr=5,	/* Anzahl Punkte ueber die geglaettet wird */
		gewichtung=1,	/* Gewichtung, 0=ausgeschaltet */
		gewichtmethod=3,/* Gewichtungsmethode */
#define WICHT_SIMPLE 1	/* Mittlerer Punkt doppelt gewichtet */
#define WICHT_TRIANG 2
#define WICHT_CUBIC  3
#define WICHT_QUINTIC 4
		spektruma=0,
		spektrumb=1;
static int	last_point_i;	/* Index des Letzten veraenderten Punktes */
static double	last_point_y,	/* Alter Wert des letzten veraend. Punktes */
		strepos_faktor,	/* hfeld um soviel gestreckt oder verschoben */
		yskalfakt=1.,	/* y-Skalierungsfaktor */
		blowupfaktor=10.,/* Aufblasefaktor */
		blowupshift=0.,	/* Verschiebung des Aufblasebereichs */
		blowup_x1,blowup_x2; /* Grenzen des Aufblasebereichs */
static int	blowup_all=0,		/* gesetzt: alle Spektren aufblasen */
		txtbr,txtho;	/* Breite und Hoehe des Platzes des Textes */
static float	*zfeld,		/* Zeiger auf Feld der y-Werte */
		*savefeld=NULL,	/* gesichertes Feld */
		*sfeld=NULL,	/* vor Glaettung gesichertes Feld */
		*zhfeld=NULL;	/* Zeiger auf Hilfsfeld */
static short	*penfeld;	/* UP DOWN Feld (noch im Test) */
static float	integralwert=0.,    /* letztes Ergebnis der Integration */
		integralgrenzen[4], /* Grenzwerte x1,y1,x2,y2 */
		xspitze,yspitze,    /* Maximum des integrierten Bereichs */
		xgetpunkt=0.,
		ygetpunkt=0.;	    /* Werte des letzten Get-Punktes */
static double	xmi1,ymi1,xma1,yma1,deltax,  /* Grenzen des Gesamtbildes */
		xmi2,ymi2,xma2,yma2,dx2,dy2, /* Grenzen des aktuellen Bildes */
		last_x1,last_y1,last_x2,last_y2; /* vorherige Werte */
static short	zoom_flg=0,		/* gesetzt: Zoom eingeschaltet */
		xzoom_flg=0,		/* Zoom nur in x-Richtung */
		yzoom_flg=0,		/* Zoom nur in y-Richtung */
		integral_flg=0,		/* Integrieren (>=2 1.Punkt gesetzt) */
		on_flg=0,		/* Edit auf ON geschaltet */
		getdeltas_flg=0,	/* Delta messen (>=2 1.Punkt ges.) */
		getpoint_flg=0,		/* Punkt an USER_PROG senden */
		stretch_flg=0,		/* Streckung in y-Richtung */
		positio_flg=0,		/* Position in y-Richtung aendern */
		subramp_flg=0,		/* Rampe subtrahieren */
		puundin_flg=0,		/* Punkte u Integrals (Knopfnr 2u3) */
		settext_flg=0,		/* Textkasten positionieren */
		blowup_flg=0,		/* Bereich Aufblasen (x-Richt.marki.)*/
		/* :es kann immer nur eines dieser 13 Flags gesetzt sein */
		flag_flg=0,		/* eines der obigen Flags gesetzt */
		change_flag=0,		/* Spektrum geaendert */
		smoot_flag=0,		/* Spektrum geglaettet */
		blowup_flag=0,		/* einen Bereich Aufgeblasen */
		subtr_flag=0,		/* Subtraktion durchgefuert */
		strepos_flag=0,		/* hfeld gestreckt oder verschoben */
		knopf_flag=0,		/* Mausknopf ist gedrueckt */
		fadenkreuzflag=0,	/* Fadenkreuz eingeschaltet */
		subtra_flag=0,		/* Subtra-Funktionen erlaubt */
		swap_flag=0,		/* swap durchgefuehrt */
		showit_gestartet=0;
static int	search_methode=0,	/* Suchmethode fr Punkte-Ausmessung */
		search_radius=6,	/* Suchradius */
		dsearch_methode=0,	/* Suchmethode fr Delta-Ausmessung */
		integral_methode=0;	/* */
#define SIX search_radius
#define SEARCHRADI search_radius
#define SHMODMIN 1
#define SHMODMAX 5

/*********************** neue Menue-Erzeugung **************************/
static long menu_ids[150]; /* Anzahl Menus * Maximale Anzahl Eintrge */
static long modus_ids[4],smooth_ids[5],frame_ids[4],text_ids[3],atext_ids[4],
	    search_ids[4],dsearch_ids[4];
	/* jeweils Anzahl Untermenupunkte (nicht nur Anzahl Umschaltpunkte) */
static char	text_modus_1[]="%q 1 = only one",
		text_modus_2[]="%q 2 = Intmarks",
		text_modus_4[]="%q 4 = two Spektra",
		text_modus_5[]="%q 5 = many Spektra",
		text_smoot_3[]= "%o 3",
		text_smoot_3w[]="%o 3 weighted",
		text_smoot_5[]= "%o 5",
		text_smoot_5w[]="%O 5 weighted",
		text_smoot_n[80]="%o 25 cubic  weighted ",
		text_smoot_help[]="help ...",
		text_frame_off[]="%q Off",
		text_frame_below[]="%Q Axis below",
		text_frame_zero[]="%q Axis always zero",
		text_frame_3d[]="%q 3D View",
		text_text_on[]="%Q ON",
		text_text_off[]="%q OFF",
		text_atext_on[]="%q ON",
		text_atext_off[]="%Q OFF",
		text_search_norm[]="%Q OFF",
		text_search_max[]= "%q Maxima",
		text_search_min[]= "%q Minima",
		text_dsearch_norm[]="%Q OFF",
		text_dsearch_max[]= "%q Maxima",
		text_dsearch_min[]= "%q Minima";
static char
  *txt_smoot[]={text_smoot_3,text_smoot_3w,text_smoot_5,text_smoot_5w,text_smoot_n},
  *txt_frame[]={text_frame_off,text_frame_below,text_frame_zero,text_frame_3d},
  *txt_text[]={text_text_on,text_text_off},
  *txt_atext[]={text_atext_on,text_atext_off},
  *txt_search[]={text_search_norm,text_search_max,text_search_min},
  *txt_dsearch[]={text_dsearch_norm,text_dsearch_max,text_dsearch_min};
static long modus_1_idnr=14;

void dings_umschalten(long id,long *idfeld,int n,int j,char **txt,int o,int O)
{
 int i;
 for(i=0;i<n;i++)  txt[i][1]=(i==j)?O:o;
 if(*idfeld==0) {if(id) getmenuids(id,idfeld); else return;}
 for(i=0;i<n;i++)  changemenu(idfeld[i],txt[i]);
}
/* alle folgenden *_umschalten() Funktionen sollten durch dings_umschalten()
   ersetztbar sein. (ausser modus_umschalten)
*/

void modus_umschalten(int nr)
{
 text_modus_1[1]=text_modus_2[1]=text_modus_4[1]=text_modus_5[1]='q';
 switch(nr)
  {case 1: text_modus_1[1]='Q';
   CASE 2: text_modus_2[1]='Q';
   CASE 4: text_modus_4[1]='Q';
   DEFAULT:text_modus_5[1]='Q';
  }
 if(modus_ids[0]==0)
	{int i,j=modus_1_idnr;
	 if(menu_ids[j]==0)
		{getmenuids(0,menu_ids); if(menu_ids[j]==0) return;}
	 for(i=0;i<4;i++,j+=9) modus_ids[i]=menu_ids[j];
	}
 changemenu(modus_ids[0],text_modus_1);
 changemenu(modus_ids[1],text_modus_2);
 changemenu(modus_ids[2],text_modus_4);
 changemenu(modus_ids[3],text_modus_5);
}

void smooth_umschalten(int nr,long id)
{
 dings_umschalten(id,smooth_ids,5,nr,txt_smoot,'o','O');
}

void setramen_umschalten(int nr,long id)
{
 int flag;
 if(flag=(nr==3 && istinwarteschlaufe)) eingabe_3d();
 dings_umschalten(id,frame_ids,4,ramen_flag=nr,txt_frame,'q','Q');
 if(flag) refresh();
/*alte Variante
 ramen_flag=nr;
 text_frame_off[1]=text_frame_below[1]=text_frame_zero[1]='q';
 switch(nr)
  {case 0: text_frame_off[1]='Q';
   CASE 1: text_frame_below[1]='Q';
   CASE 2: text_frame_zero[1]='Q';
  }
 if(frame_ids[0]==0)
	{if(id==0) return;
	 getmenuids(id,frame_ids);
	}
 changemenu(frame_ids[0],text_frame_off);
 changemenu(frame_ids[1],text_frame_below);
 changemenu(frame_ids[2],text_frame_zero);
*/
}

void textflag_umschalten(int flag,long id)
{
 textflag=flag;
 if(text_ids[0]==0 && id!=0) getmenuids(id,text_ids);
 dings_umschalten(id,&text_ids[1],2,1-flag,txt_text,'q','Q');
/*alte Variante
 textflag=flag;
 if(flag) {text_text_on[1]='Q'; text_text_off[1]='q';}
 else	  {text_text_off[1]='Q'; text_text_on[1]='q';}
 if(text_ids[0]==0)
	{if(id==0) return;
	 getmenuids(id,text_ids);
	}
 changemenu(text_ids[1],text_text_on);
 changemenu(text_ids[2],text_text_off);
*/
}

void xytextflag_umschalten(int flag,long id)
{
 xytextflag=flag;
 dings_umschalten(id,atext_ids,2,1-flag,txt_atext,'q','Q');
/*alte Variante
 xytextflag=flag;
 if(flag) {text_atext_on[1]='Q'; text_atext_off[1]='q';}
 else	  {text_atext_off[1]='Q'; text_atext_on[1]='q';}
 if(atext_ids[0]==0)
	{if(id==0) return;
	 getmenuids(id,atext_ids);
	}
 changemenu(atext_ids[0],text_atext_on);
 changemenu(atext_ids[1],text_atext_off);
*/
}

void search_umsch(long id,int nr)
{
 dings_umschalten(id,search_ids,3,search_methode=nr,txt_search,'q','Q');
}
void dsearch_umsch(long id,int nr)
{
 dings_umschalten(id,dsearch_ids,3,dsearch_methode=nr,txt_dsearch,'q','Q');
}

void k_load(long n) {file_load();}
void k_save()	{file_save();}
void k_show_total()	{show_total();}
void k_show_previ()	{show_previous();}
void k_show_zoom()	{flg_schalten(&zoom_flg);}
void k_show_xzoom()	{flg_schalten(&xzoom_flg);}
void k_show_yzoom()	{flg_schalten(&yzoom_flg);}
void k_show_numzoom() {number_zoom();}
void k_show_goback()	{show_goback();}
void k_show_frame_off(long id) 	{setramen_umschalten(0,id);}
void k_show_frame_yaxisu(long id) {setramen_umschalten(1,id);}
void k_show_frame_yaxis0(long id) {setramen_umschalten(2,id);}
void k_show_frame_3d(long id) {setramen_umschalten(3,id);}
void k_show_text_pos()	{settextpos();}
void k_show_text_on(long id)	{textflag_umschalten(1,id);}
void k_show_text_off(long id)	{textflag_umschalten(0,id);}
void k_show_atext_xyon(long id)  {xytextflag_umschalten(1,id);}
void k_show_atext_xyoff(long id) {xytextflag_umschalten(0,id);}
void k_show_atext_x()
		{char *str;
		 if(labeltext_flag==0)  spename_laden();
		 lower_window();
		 str=inputstr1("(%s) x-AxisText:",xlabeltext);
		 if(*str!=0) xlabeltext=str;
		 raise_window();
		}
void k_show_atext_y()
		{char *str;
		 if(labeltext_flag==0)  spename_laden();
		 lower_window();
		 str=inputstr1("(%s) y-AxisText:",ylabeltext);
		 if(*str!=0) ylabeltext=str;
		 raise_window();
		}
void k_edit_undo()	{edit_undo();}
void k_edit_setpoint()	{flg_schalten(&on_flg);}
void k_edit_savep()	{edit_save_points();}
void k_edit_lasts()	{edit_last_saved();}
void k_smooth()	{if(setsmoothpara()) smooth(smoothNr,gewichtung);}
void k_smooth3(long id) {setsmooth(0); smooth_umschalten(0,id);}
void k_smooth3w(long id) {setsmooth(1);smooth_umschalten(1,id);}
void k_smooth5(long id) {setsmooth(2); smooth_umschalten(2,id);}
void k_smooth5w(long id) {setsmooth(3);smooth_umschalten(3,id);}
void k_smoothn(long id) {setsmooth(4); smooth_umschalten(4,id);}
void k_smoothhelp(long id) {smooth_help();}
void k_blowupfakt()
		{lower_window();
		 blowupfaktor=doubinputstr1(
			"(%.3lf) BlowUpFaktor:",blowupfaktor);
		 raise_window();
		}
void k_blowupshift()
		{char *str;
		 lower_window();
		 blowupshift=doubinputstr1("(%.3lf) BlowUpShift:",blowupshift);
		 str=inputstr1("(%ld) Strichelungen ausschalten ?",
					ohnestrichelung);
		 if(*str!=0)
			{if((isdigit(*str) && *str!='0') ||
			    toupper(*str)=='J')  ohnestrichelung=1;
			 else ohnestrichelung=0;
			}
		 cfree(str);
		 str=inputstr1("(%ld) Alle Spektren aufblasen ?",
					blowup_all);
		 if(*str!=0)
			{if((isdigit(*str) && *str!='0') ||
			    toupper(*str)=='J')  blowup_all=1;
			 else blowup_all=0;
			}
		 cfree(str);
		 raise_window();
		}
void k_blowup()		{flg_schalten(&blowup_flg);}
void k_peak_off()	{getintoff();}
void k_peak_integral()	{int_sflag=0; flg_schalten(&integral_flg);}
void k_peak_intsave()	{peak_intsave();}
void k_peak_integrals()	{int_sflag=1; flg_schalten(&integral_flg);}
void k_peak_getpoint()	{get_sflag=0; flg_schalten(&getpoint_flg);}
void k_peak_getpoints()	{get_sflag=1; flg_schalten(&getpoint_flg);}
void k_peak_getdeltas()	{flg_schalten(&getdeltas_flg);}
void k_peak_pointsearch_norm(long id) {search_umsch(id,0);}
void k_peak_pointsearch_max(long id) {search_umsch(id,1);}
void k_peak_pointsearch_min(long id) {search_umsch(id,2);}
void k_peak_pointsearch_radius()
	{lower_window();
	 search_radius=intinputstr1("(%d) Suchradius:",search_radius);
	 raise_window();
	}
void k_peak_dpointsearch_norm(long id) {dsearch_umsch(id,0);}
void k_peak_dpointsearch_max(long id) {dsearch_umsch(id,1);}
void k_peak_dpointsearch_min(long id) {dsearch_umsch(id,2);}
void k_peak_puundin()	{int_sflag=get_sflag=1; flg_schalten(&puundin_flg);}
void k_peak_puunddelta(){int_sflag=0; get_sflag=1; flg_schalten(&puundin_flg);}
void k_subtra_undo()	{subtra_undo();}
void k_subtra_position(){subtra_position();}
void k_subtra_stretch()	{subtra_stretch();}
void k_subtra_subtract(){subtra_subtract();}
void k_subtra_divid()	{subtra_divid();}
void k_subtra_beer()	{subtra_beer();}
void k_subtra_swap()	{subtra_swap(1);}
void k_subtra_exchange(){subtra_exchange();}
void k_subtra_subramp()	{flg_schalten(&subramp_flg);}
void k_subtra_spektruma(){spektnr_setzen("A",&spektruma);}
void k_subtra_spektrumb(){spektnr_setzen("B",&spektrumb);}
void k_modus1(long id)	{//modus_1_idnr = (id<0) ? -id-1 : id;//test
			 //printf("modus_1_idnr=%ld\n",modus_1_idnr);//test
			 modus_togg(1);
			}
void k_modus2(long id)	{modus_togg(2);}
void k_modus4(long id)	{modus_togg(4);}
void k_modus5(long id)	{modus_togg(5);}
void k_laser()		{plotter(DECLASER); /* DEC Laser  */}
void k_lasereps()	{plotter(IBMLASER); /* IBM Laser  */}
void k_hpdj()		{plotter(PSPLOTTER); /* HP DeskJet, Tektronix Phaser*/}
void k_hp()		{plotter(HPGLPLOTTER);/*HP PaintJet, PS-FarbDrucker */}
void k_hpgl()		{plotter(HPGLDATEI);}
void k_iff()		{plotter(IFFDATEI);}
void k_tellagr()	{plotter(TELLDATEI); /* Tellagraf  */}
void k_postscr()	{plotter(PSDATEI);   /* Postscript */}
void k_postscr2()	{plotter(PSDATEIFARBIG);}
void k_rohxy()		{plotter(ROHXYDATEI); /* XY-Datei */}
void k_setlinewidth()	{lower_window();
			 linewidth=doubinputstr1(
				"(%.2lf) Linewidth:",linewidth);
			 raise_window();
			}
void k_setcolors()	{lower_window(); setcolors(); raise_window();}
void k_strichelung()	{char *str;
			 lower_window();
			 str=inputstr1("(%ld) Strichelungen ausschalten ?",
						ohnestrichelung);
			 if(*str!=0)
				{if((isdigit(*str) && *str!='0') ||
				    toupper(*str)=='J')  ohnestrichelung=1;
				 else ohnestrichelung=0;
				}
			 cfree(str);
			 raise_window();
			}
void k_divers_packmethode()
			{lower_window();
			 PM=intinputstr1("(%ld) Packmethode:",PM);
			 printfpackmethode(1);
			 raise_window();
			}
void k_divers2()
	{fragebeschrift('x',&xstrichlang,&xteilung,&xeinteilung,&xter);}
void k_divers3()
	{fragebeschrift('y',&ystrichlang,&yteilung,&yeinteilung,&yter);}
void k_divers4()
	{lower_window();
	 xbuch=intinputstr1("(%d) Buchstabengrsse x-Achse:",xbuch);
	 ybuch=intinputstr1("(%d) Buchstabengrsse y-Achse:",ybuch);
	 tbuch=intinputstr1("(%d) Buchstabengrsse Titel:",tbuch);
	 titelabst=intinputstr1("(%d) Zeilenabstand in Titel:",titelabst);
	 ramenlinewidth=doubinputstr1(
		"(%.1lf) Achsen-Strichstrke:",ramenlinewidth);
	 raise_window();
	}
void k_divers5()	{lower_window();
			 rrand=intinputstr1("(%d) Grsse des Randes:",rrand);
			 raise_window();
			}
void k_divers_yskal()	{yskalierung(NULL);}
void k_divers_integmethode(){integ_methode();}
void k_divers_loadvoreinst(){load_voreinstellungen();}
void k_divers_voreinst(){save_voreinstellungen();}
void k_fft()		{fft_start(0);}
void k_fftinvers()	{fft_start(1);}
void k_fftmethode()	{fft_methode();}

char *deutsches_menu[]=
{"File",    "Show",	    "Edit",	    "Peak",           "Subtra",
	"Modus",  "Diverses",		 "Fourier",	"Refresh",
 "Load",    "Total",	    "undo",	    "Off",	      "undo",
     text_modus_1,"Packmethode",	 "FFT",		"Refresh",
 "Save",    "Previous",     "Set Point",    "Integral",	      "position (B)",
     text_modus_2,"x-Achsenbeschriftung","FFT Invers",	NULL,
 "Plot  ->","Zoom",	    "Save Points",  "Int-Save",       "stretch (B)",
     text_modus_4,"y-Achsenbeschriftung","FFT Methode ",	NULL,
/** Plot Submenus **/
/* alte Variante:
 "DEC Laser  (LASER)",
 "IBM Laser  (PSLASER)",
 "HP DeskJet (PSCOLOR)",
 "HP PaintJet",
*/
/* neue Variante: */
 "Standard PS-Printer",
 "Standard EPS-Printer",
 "Color PS-Printer",
 "Color EPS-Printer",
 "Postscript EPS Datei",
 "Postscript EPS farbig",
 "HPGL Datei",
 "IFF Datei",
 "Tellagraf Datei",
 "rohe XY-Datei",
 "~~~~~~~~~~~~~~~~~",
 "setlinewidth",
 "set colors",
 "Strichelung",
 "reserve", "reserve", "reserve", "reserve",
/** wieder Hauptmenus **/
 "Exit",    "x-Zoom",	    "Last Saved",   "Integrals", "Subtract (A-B -> A)",
     text_modus_5,"Buchstabengroessen",	 NULL,		NULL,
 NULL,      "y-Zoom",	    "SmoothNr   ->","Get Point", "Divid (A/B -> A)",
	NULL,	  "Randbreite",		 NULL,		NULL,
/** SmoothNr Submenus **/
 text_smoot_3, text_smoot_3w, text_smoot_5, text_smoot_5w,
 text_smoot_n, text_smoot_help, "reserve", "reserve", "reserve",
/** wieder Hauptmenus **/
 NULL,      "Number-Zoom",  "Smooth ...",  "Get Points",   "BeerLambert  -log(A/B) -> A",
	NULL,	  "y-Skalierung",	 NULL,		NULL,
 NULL,      "go bak",	    "blowupFaktor", "Get Deltas",   "exchange (A<->B)",
	NULL,	  "Integral_Methode",	   NULL,	NULL,
 NULL,      "Frame        ->","blowupShift", "Points & Intgs", "swap (B)",
	NULL,	  "Load_Voreinstellungen", NULL,	NULL,
/** Frame Submenus **/
 text_frame_off, text_frame_below, text_frame_zero, text_frame_3d,
 "reserve", "reserve", "reserve", "reserve", "reserve",
/** wieder Hauptmenus **/
#ifdef UNIX_OR_MAC
 NULL,      "Text         ->","blow up",   "Points & Deltas","subramp (A)",
#else
 NULL,      "Text           ->","blow up",   "Points & Deltas","subramp (A)",
#endif
	NULL,	  "Save_Voreinstellungen", NULL,	NULL,
/** Text  Submenus **/
 "Set Position", text_text_on, text_text_off,
 "reserve", "reserve", "reserve", "reserve", "reserve", "reserve",
/** wieder Hauptmenus **/
#ifdef UNIX_OR_MAC
 NULL,      "Axis Text    ->", NULL,	"Points Search   ->", "Spektrum A",
#else
 NULL,      "Axis Text   ->", NULL,	"Points Search   ->", "Spektrum A",
#endif
	NULL,		NULL,		 NULL,		NULL,
/** Axis_Text  Submenus **/
 text_atext_on, text_atext_off, "x-Text", "y-Text",
/** Points Search  Submenus **/
 text_search_norm, text_search_max, text_search_min, "SuchRadius",
 "reserve",
/** wieder Hauptmenus **/
#ifdef UNIX_OR_MAC
 NULL,      NULL,	 NULL,		"Delta Search    ->", "Spektrum B",
#else
 NULL,      NULL,	 NULL,		"Delta Search   ->", "Spektrum B",
#endif
	NULL,		NULL,		 NULL,		NULL,
/** Delta Search  Submenus **/
 text_dsearch_norm, text_dsearch_max, text_dsearch_min, "SuchRadius"
 ,"reserve", "reserve", "reserve", "reserve", "reserve"
};

#define ITX(n) text[i+n]
#define SETMENU i+=9;setmenu

//extern int menu_debug;//test

void menu_start(char *version)
{
 char **text;
 int i=0;
// menu_debug=1;//test
#ifdef XTEKPLOT_ALT
 sprintf((char*)&fenstername[fenstername1_len],"%s ",version);
#else
 //static char fenstname[80];
 //sprintf(fenstername=fenstname," Showit %s ",version);
 sprintf(fenstername," Showit %s ",version);
#endif
 fenstername1_len=strlen((char*)fenstername);
/* if(sprache==DEUTSCH) */
        text=deutsches_menu;
/* else text=english_menu; */
 setmenu(9,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),ITX(7),ITX(8));
 SETMENU(9,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),ITX(7),ITX(8),
	k_load,k_show_total,k_edit_undo,k_peak_off,k_subtra_undo,
	k_modus1,k_divers_packmethode,k_fft,refresh);
 SETMENU(8,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),ITX(7),
	k_save,k_show_previ,k_edit_setpoint,k_peak_integral,k_subtra_position,
	k_modus2,k_divers2,k_fftinvers);
 SETMENU(8,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),ITX(7),
	NULL,k_show_zoom,k_edit_savep,k_peak_intsave,k_subtra_stretch,
	k_modus4,k_divers3,k_fftmethode);
 i+=9;
 setsubmenu(1,ITX(0), k_laser);	//Plot Untermenus
 setsubmenu(1,ITX(1), k_lasereps);
 setsubmenu(1,ITX(2), k_hpdj);
 setsubmenu(1,ITX(3), k_hp);
 setsubmenu(1,ITX(4), k_postscr);
 setsubmenu(1,ITX(5), k_postscr2);
 setsubmenu(1,ITX(6), k_hpgl);
 setsubmenu(1,ITX(7), k_iff);
 setsubmenu(1,ITX(8), k_tellagr);
 setsubmenu(1,ITX(9), k_rohxy);
 setsubmenu(1,ITX(10), NULL);
 setsubmenu(1,ITX(11), k_setlinewidth);
 setsubmenu(1,ITX(12), k_setcolors);
 setsubmenu(1,ITX(13), k_strichelung);
 i+=2*9;
 setmenu(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	file_exit,k_show_xzoom,k_edit_lasts,k_peak_integrals,k_subtra_subtract,
	k_modus5,k_divers4);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,k_show_yzoom,NULL,k_peak_getpoint,k_subtra_divid, NULL,k_divers5);
 i+=9;
 setsubmenu(3,NULL,NULL,ITX(0),NULL,NULL,k_smooth3); //Smootnr Submenu
 setsubmenu(3,NULL,NULL,ITX(1),NULL,NULL,k_smooth3w);
 setsubmenu(3,NULL,NULL,ITX(2),NULL,NULL,k_smooth5);
 setsubmenu(3,NULL,NULL,ITX(3),NULL,NULL,k_smooth5w);
 setsubmenu(3,NULL,NULL,ITX(4),NULL,NULL,k_smoothn);
 setsubmenu(3,NULL,NULL,ITX(5),NULL,NULL,k_smoothhelp);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,k_show_numzoom,k_smooth,k_peak_getpoints,k_subtra_beer,
	NULL,k_divers_yskal);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,k_show_goback,k_blowupfakt,k_peak_getdeltas,k_subtra_exchange,
	NULL,k_divers_integmethode);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,NULL,k_blowupshift,k_peak_puundin,k_subtra_swap,
	NULL,k_divers_loadvoreinst);
 i+=9;
 setsubmenu(2,NULL,ITX(0),NULL,k_show_frame_off);	//Frame Untermenus
 setsubmenu(2,NULL,ITX(1),NULL,k_show_frame_yaxisu);
 setsubmenu(2,NULL,ITX(2),NULL,k_show_frame_yaxis0);
 setsubmenu(2,NULL,ITX(3),NULL,k_show_frame_3d);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,NULL,k_blowup,k_peak_puunddelta,k_subtra_subramp,
	NULL,k_divers_voreinst);
 i+=9;
 setsubmenu(2,NULL,ITX(0),NULL,k_show_text_pos);	//Text Untermenus
 setsubmenu(2,NULL,ITX(1),NULL,k_show_text_on);
 setsubmenu(2,NULL,ITX(2),NULL,k_show_text_off);
 SETMENU(5,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),
	NULL,NULL,NULL,NULL,k_subtra_spektruma);
 i+=9;
//AxisText Untermenus und PointSearch Untermenus
 setsubmenu(4,NULL,ITX(0),NULL,ITX(4),
		NULL,k_show_atext_xyon,NULL,k_peak_pointsearch_norm);
 setsubmenu(4,NULL,ITX(1),NULL,ITX(5),
		NULL,k_show_atext_xyoff,NULL,k_peak_pointsearch_max);
 setsubmenu(4,NULL,ITX(2),NULL,ITX(6),
		NULL,k_show_atext_x,NULL,k_peak_pointsearch_min);
 setsubmenu(4,NULL,ITX(3),NULL,ITX(7),
		NULL,k_show_atext_y,NULL,k_peak_pointsearch_radius);
 SETMENU(5,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),
	 NULL,NULL,NULL,NULL,k_subtra_spektrumb);
 i+=9;
//DeltaPointSearch Untermenus
 setsubmenu(4,NULL,NULL,NULL,ITX(0), NULL,NULL,NULL,k_peak_dpointsearch_norm);
 setsubmenu(4,NULL,NULL,NULL,ITX(1), NULL,NULL,NULL,k_peak_dpointsearch_max);
 setsubmenu(4,NULL,NULL,NULL,ITX(2), NULL,NULL,NULL,k_peak_dpointsearch_min);
 setsubmenu(4,NULL,NULL,NULL,ITX(3), NULL,NULL,NULL,k_peak_pointsearch_radius);
 SETMENU(1,NULL,NULL);
}
/*************************** Ende Menu ***********************************/

void
fragebeschrift(int x,int* strichlang,int* teilung,int* einteilung,int* ter)
{
 lower_window();
 printf("\n  %c-Achse-Beschriftung\n",x);
 printf("  ********************\n");
 printf("(%d) Strichelung-Einteilung:\n",*einteilung);
 printf("   0 = automatisch\n");
 printf("   1 = bei runder Zahl beginnen\n");
 printf("   2 = nichts runden                         Auswahl:");
 scanf("%d",einteilung);
 printf("(%d) Anzahl Markierungen auf %c-Achse:",*teilung,x);
 scanf("%d",teilung);
 printf("(%d) Strichelung-Lngen:\n",*strichlang);
 printf("   0 = automatisch\n");
 printf("   1 = alle Striche gleich lang\n");
 printf("   x = jeder x-te Strich laenger             Auswahl:");
 scanf("%d",strichlang);
 printf("(%d) Jede N-te Markierung beschriften N=",*ter); scanf("%d",ter);
 raise_window();
}
char *inputstr1(char *frage,long alt)
{
 char *str;
 str=(char *)calloc(80,1); if(str==NULL) return NULL;
 printf(frage,alt); getline(stdin,str,80);
 if(str[0]==0) getline(stdin,str,80);
 return str;
}
char *inputstr1(char *frage,char *alt)
{
 char *str;
 str=(char *)calloc(80,1); if(str==NULL) return NULL;
 printf(frage,alt); getline(stdin,str,80);
 if(str[0]==0) getline(stdin,str,80);
 return str;
}
char *inputstr3(char *frage,long a1,long a2,long a3,long a4)
{
 char *str;
 str=(char *)calloc(80,1); if(str==NULL) return NULL;
 printf(frage,a1,a2,a3,a4); getline(stdin,str,80);
 if(str[0]==0) getline(stdin,str,80);
 return str;
}
char *inputstr1lf(char *frage,double alt)
{
 char *str;
 str=(char *)calloc(80,1); if(str==NULL) return NULL;
 printf(frage,alt); getline(stdin,str,80);
 if(str[0]==0) getline(stdin,str,80);
 return str;
}
int intinputstr1(char *frage,int alt)
{
 int neu;
 char *s; s=inputstr1(frage,alt);
 if(*s==0) neu=alt; else sscanf(s,"%d",&neu);
 cfree(s);
 return neu;
}
double doubinputstr1(char *frage,double alt)
{
 double neu;
 char *s; s=inputstr1lf(frage,alt);
 if(*s==0) neu=alt; else sscanf(s,"%lf",&neu);
 cfree(s);
 return neu;
}

float *feldcalloc()
{
 float *p;
 p=(float *)calloc(npkt,sizeof(float));
 if(p==NULL) {printf("zu wenig RAM\n"); exit(2);}
 return p;
}

void showit(float* xmin,float* ymin,float* xmax,float* ymax,
		int* npoints,int* modus,float* feld,float* hfeld)
{
// extern double xmi1,ymi1,xma1,yma1,deltax;
// extern double xmi2,ymi2,xma2,yma2;
// extern int npkt,shmodus;
 int i;
 FILE *fp;
#ifdef XTEKPLOT_1
 set_funktions(klick1,klick0,fensterposition,bewegung1);
#endif
 if( (fp=fopen(showit_voreinst,"r"))!=NULL
     || (fp=fopen(showit_voreinst_global,"r"))!=NULL )
	{voreinstellungen_lesen(fp); fclose(fp);}
 menu_start(VERSION);
// shmodus = *modus;
 shmodus = *modus & ~MODUSZUSATZ_MASK;
 moduszusatz = *modus & MODUSZUSATZ_MASK;
 if(shmodus>=5) {nspektren=shmodus-4; shmodus=5;}
 else if(shmodus==4) nspektren=2;
 else nspektren=1;
 if(shmodus<SHMODMIN || shmodus>SHMODMAX)
	{printf("Fehler: SHOWIT(...MODUS=%d...)\n",shmodus); exit(1);}
 xmi2=xmi1= *xmin; ymi2=ymi1= *ymin; xma2=xma1= *xmax; yma2=yma1= *ymax;
 npkt= *npoints; zfeld=feld; zhfeld=hfeld;
 if(ymi1==yma1) ymimaxsuchen(zfeld,NULL);
 penfeld=(short *)calloc(npkt+1,sizeof(short));
 if(penfeld==NULL) {printf("zu wenig RAM\n"); exit(3);}
 for(i=0;i<=npkt;i++) penfeld[i]=DOWN;
 if(yskalfakt!=1.) {double f=yskalfakt; yskalfakt=1.; spektren_skalieren(f);}
 set_new_shmodus();
 deltax=(xma1-xmi1)/(npkt-1);
 setsize(1000,700,4);
 show_total();
 showit_gestartet=1;
 if(moduszusatz & AUTOPLOTEXIT) {plotter(PSDATEI); file_exit();}
 if(moduszusatz & AUTOSAVEEXIT) {file_save(); file_exit();}
 istinwarteschlaufe=1;
 for(;;) {Delay(1); if(waitmenu(0)!=0) file_exit();}
/* dieses UnterProgramm wird nie verlassen */
}
void ymimaxsuchen(float *pf,float *pf2)
{
 int i;
 ymi1=yma1=0.;
 for(i=0;i<npkt;i++,pf++)
	{if(*pf<ymi1) ymi1= *pf;
	 else if(*pf>yma1) yma1= *pf;
	}
 if(pf2)
  for(i=0;i<npkt;i++,pf2++)
	{if(*pf2<ymi1) ymi1= *pf2;
	 else if(*pf2>yma1) yma1= *pf2;
	}
 ymi2=ymi1; yma2=yma1;
}

void new_hfeld(float *hfeld,int *modus)
{
 int i,nspektren_alt=nspektren;
 float *zh,*zhmax;
 shmodus = *modus;
 if(shmodus>=5) {nspektren=shmodus-4; shmodus=5;}
 else if(shmodus==4) nspektren=2;
 else nspektren=1;
 if(shmodus<SHMODMIN || shmodus>SHMODMAX)
	{printf("Fehler: NEW_HFELD(...MODUS=%d)\n",shmodus);
	 printf("Korrektur: MODUS=%d\n",shmodus=4);
	}
 if(zhfeld!=hfeld)
	zh=zhfeld=hfeld;
 else if(nspektren>nspektren_alt && zhfeld!=NULL)
	zh= &zhfeld[(nspektren_alt-1)*npkt];
 else zh=NULL;
 if(zh && yskalfakt!=1.)
	{zhmax= &zhfeld[(nspektren-1)*npkt];
	 while(zh<zhmax) *zh++ /= yskalfakt;
	}
 set_new_shmodus();
}

static void set_new_shmodus()
{
 int i,j;
 if(shmodus==2 || shmodus==3)
	{if(zhfeld==NULL) {zhfeld=feldcalloc(); shmodus=3;}
	 if(shmodus==3)
		{for(i=0;i<npkt;i++) zhfeld[i]=zfeld[i];
		 shmodus=2;
		}
	}
 subtra_flag=(zhfeld!=NULL && shmodus>=4);
 labeltext_flag=0;
 if(nspektren>1)
  {int neuesb=nspektren-1;
   if(spektrumb!=neuesb)
	{spektrumb=neuesb; swap_flag=subtr_flag=strepos_flag=0;}
  }
 modus_umschalten(shmodus);
}

void modus_togg(int k)
{
 switch(k)
	{case 1:modus_1(); break;
	 case 2:modus_2(); break;
	 case 4:modus_4(); break;
	 case 5:modus_5(); break;
	}
}

void modus_1()
{
 shmodus=1;
 set_new_shmodus(); refresh();
}

void modus_2()
{
/* if(shmodus!=2 && zhfeld!=NULL)  {fragekasten(2); return;} */
 if(shmodus!=2 && zhfeld!=NULL)
	{if(requester("2. Spektrum entfernen ?","ja","nein")==0) return;}
 shmodus=3;
 set_new_shmodus(); refresh();
}

void modus_4()
{
 if(shmodus!=4 && zhfeld==NULL)
	{nspektren=2; shmodus=3; set_new_shmodus();}
 shmodus=4;
 set_new_shmodus(); refresh();
}

void modus_5()
{
 if(shmodus!=5 && zhfeld==NULL)
	{nspektren=2; shmodus=3; set_new_shmodus();}
 if(nspektren<2) nspektren=2;
 shmodus=5;
 set_new_shmodus(); refresh();
}

void voreinstellungen_reset()
{
 xeinteilung=AUTO; xteilung=20; xstrichlang=AUTO; xter=5;
 yeinteilung=HALBAUTO; yteilung=8; ystrichlang=2; yter=2;
 rrand=0;
 packmethode=1;
 xbuch=ybuch=123; ramenlinewidth=1.0;
 tbuch=TBUCHDEFAULT; titelabst=TITABSTDEFAULT;
 linewidth=0.5;
 if(textflag!=1) textflag_umschalten(textflag=1,0L);
 if(xytextflag!=0) xytextflag_umschalten(xytextflag=0,0L);
 if(ramen_flag!=1) setramen_umschalten(ramen_flag=1,0L);
 if(search_methode) search_umsch(0L,search_methode=0);
 search_radius=6;
 if(dsearch_methode) dsearch_umsch(0L,dsearch_methode=0);
 integral_methode=0;
}

void voreinstellungen_lesen(FILE *fp)
{
 char key[80];
 int c;
 spektcolors=0;
 while((c=getc(fp))!=EOF)
  {ungetc(c,fp);
   fscanf(fp,"%s",key);
   if(strcmp(key,"xachse")==0)
	 fscanf(fp,"%d %d %d %d",&xeinteilung,&xteilung,&xstrichlang,&xter);
   else if(strcmp(key,"yachse")==0)
	 fscanf(fp,"%d %d %d %d",&yeinteilung,&yteilung,&ystrichlang,&yter);
   else if(strcmp(key,"randbreite")==0) fscanf(fp,"%d",&rrand);
   else if(strcmp(key,"packmethode")==0)
		{fscanf(fp,"%d",&packmethode); printfpackmethode(0);}
   else if(strcmp(key,"buchstabengroessen")==0)
	  fscanf(fp,"%d %d %lf",&xbuch,&ybuch,&ramenlinewidth);
   else if(strcmp(key,"titelgroessen")==0)
	  fscanf(fp,"%d %d",&tbuch,&titelabst);
   else if(strcmp(key,"setlinewidth")==0) fscanf(fp,"%lf",&linewidth);
   else if(strcmp(key,"textflag")==0)
	  {fscanf(fp,"%d",&textflag); textflag_umschalten(textflag,0L);}
   else if(strcmp(key,"xytextflag")==0)
	  {fscanf(fp,"%d",&xytextflag); xytextflag_umschalten(xytextflag,0L);}
   else if(strcmp(key,"ramenflag")==0)
	  {fscanf(fp,"%d",&ramen_flag); setramen_umschalten(ramen_flag,0L);}
   else if(strcmp(key,"searchmethode")==0)
	  {fscanf(fp,"%d",&search_methode); search_umsch(0L,search_methode);}
   else if(strcmp(key,"searchradius")==0)
	  {fscanf(fp,"%d",&search_radius);}
   else if(strcmp(key,"dsearchmethode")==0)
	  {fscanf(fp,"%d",&dsearch_methode); dsearch_umsch(0L,dsearch_methode);}
   else if(strcmp(key,"integralmethode")==0) fscanf(fp,"%d",&integral_methode);
   else if(strcmp(key,"alfa_3d")==0)
		{int alfa=int(alfa_3d/GRAD+0.5);
		 fscanf(fp,"%d %lf",&alfa,&verkuerzung_3d);
		 alfa_3d=alfa*GRAD;
		 eingabe_3d(1);
		}
   else if(strcmp(key,"spektcolors")==0)
		{int i,n;
		 fscanf(fp,"%d",&n);//Anzahl Farben
		 for(i=1;i<=n;i++) //fuer jede Farbe RGB-Wert einlesen
			fscanf(fp,"%d %d %d",&Rot[i],&Gruen[i],&Blau[i]);
		 spektcolors=n;
		}
   else {printf("unknown keyword in datafile: '%s'\n",key); break;}
  }
}

void save_voreinstellungen()
{
 FILE *fp;
 if((fp=fopen(showit_voreinst,"w"))==NULL)
	{printf("kann '%s' nicht ffnen\n",showit_voreinst); return;}
 fprintf(fp,"xachse %d %d %d %d\n",xeinteilung,xteilung,xstrichlang,xter);
 fprintf(fp,"yachse %d %d %d %d\n",yeinteilung,yteilung,ystrichlang,yter);
 fprintf(fp,"randbreite %d\n",rrand);
 fprintf(fp,"packmethode %d\n",packmethode);
 fprintf(fp,"buchstabengroessen %d %d %lf\n",xbuch,ybuch,ramenlinewidth);
 fprintf(fp,"titelgroessen %d %d\n",tbuch,titelabst);
 fprintf(fp,"setlinewidth %lf\n",linewidth);
 if(textflag!=1) fprintf(fp,"textflag %d\n",textflag);
 if(xytextflag!=0) fprintf(fp,"xytextflag %d\n",xytextflag);
 if(ramen_flag!=1) fprintf(fp,"ramenflag %d\n",ramen_flag);
 if(ramen_flag==3) fprintf(fp,"alfa_3d %d %lf\n",
				int(alfa_3d/GRAD+0.5),verkuerzung_3d);
 if(search_methode!=0) fprintf(fp,"searchmethode %d\n",search_methode);
 if(search_radius!=6) fprintf(fp,"searchradius %d\n",search_radius);
 if(dsearch_methode!=0) fprintf(fp,"dsearchmethode %d\n",dsearch_methode);
 if(integral_methode!=0) fprintf(fp,"integralmethode %d\n",integral_methode);
 if(spektcolors!=0)
		{int i,n=spektcolors;
		 fprintf(fp,"spektcolors %d",n);//Anzahl Farben
		 for(i=1;i<=n;i++) //fuer jede Farbe RGB-Wert schreiben
			{fprintf(fp,"  %d %d %d",Rot[i],Gruen[i],Blau[i]);
			 if((i%4)==0) putc('\n',fp);
			}
		 if((n%4)!=0) putc('\n',fp);
		}
 fclose(fp);
}
void load_voreinstellungen()
{
 FILE *fp;
 char str[80];
 lower_window();
 printf("Load_Voreinst. File:"); scanf("%s",str);
 if((fp=fopen(str,"r"))!=NULL)
	{voreinstellungen_reset(); voreinstellungen_lesen(fp);
	 if(spektcolors) setcolors(1);
	 fclose(fp);
        }
 else	printf("kann '%s' nicht finden\n",str);
 raise_window();
}

void setcolors(int autoflag)
{
 int i,n;
 if(!autoflag)
  {lower_window();
   printf("Farben ndern (255,255,255 = weiss auf Schirm, schwarz auf Papier)\n");
   printf(" Farbe 0 = Beschriftung,  Farbe1 = 1.Spektrum ...\n");
   if((n=nspektren+1)>MAXCOLOR) n=MAXCOLOR;//auf 16 Farben beschraenkt
   if(n-1>spektcolors) spektcolors=n-1;
  }
 else n=MAXCOLOR;
// if(n<3 && shmodus>=3) n=3;//test
 for(i=1;i<n;i++)
	{/*printf("Farbe %d:  R,G,B=? (%d,%d,%d)?",i,Rot[i],Gruen[i],Blau[i]);
	 /*scanf("%d%*c%d%*c%d",&Rot[i],&Gruen[i],&Blau[i]);*/
	 if(!autoflag)
	  {char *s=inputstr3("Farbe %ld:  R,G,B=? (%ld,%ld,%ld)?",
				i,Rot[i],Gruen[i],Blau[i]);
	   sscanf(s,"%d%*c%d%*c%d",&Rot[i],&Gruen[i],&Blau[i]); cfree(s);
	  }
#ifdef USE_HPGL
	 hpsetcolor(i,Rot[i],Gruen[i],Blau[i]);
#endif
	 if(tekplot_tiefe>1)
#ifndef XTEKPLOT_1
		if(Rot[i]==Gruen[i] && Rot[i]==Blau[i] /*&& Higrund==schwarz*/)
			setcolor(i,255-Rot[i],255-Gruen[i],255-Blau[i]);
		else
#endif
			setcolor(i,Rot[i],Gruen[i],Blau[i]);
	}
 if(!autoflag) raise_window();
}

/*************************** Bewegung ************************************/
#ifdef UNIX_OR_VAX_OR_ALPHA
extern uint menubalkenhoehe;
#define XWERT(x) (xmi2+dx2*(x))
#define YWERT(y) (yma2-dy2*((y)-menubalkenhoehe))
#define INVXWERT(x) (((x)-xmi2)/dx2)
#define INVYWERT(y) ((yma2-(y))/dy2+menubalkenhoehe)
#define XWERTD(x) (dx2*(x))
#define INVXWERTD(x) ((x)/dx2)

void klick(int knopf,int x,int y,int knopfnr)
{
 static double x1,y1,x2,y2,h;
// extern int faden_x,faden_y;
 static int igno=1; /* Ignoriere 'Knopf losgelassen' */
 static int fun,erfolg,puuflag=0;
// extern int fun_getpoint,fun_getpoints;
 int i;
 float *pzh;
#ifdef GRABPOINTER
 Cursor cursor=0;
#endif
/* Time time=CurrentTime; */
 if(puundin_flg)
	{puuflag=1;
	 switch(knopfnr)
	   {case 1:flg_schalten(&zoom_flg); break;
	    case 2:flg_schalten(&getpoint_flg); break;
	    case 3:if(int_sflag) flg_schalten(&integral_flg);
		   else flg_schalten(&getdeltas_flg);
		   break;
	    default:printf("Error: knopfnr=%d\n",knopfnr);
	   }
	}
 knopf_flag=knopf;
 if(knopf) /* Knopf gedrueckt */
   {igno=0;
    if(zoom_flg || xzoom_flg || yzoom_flg || blowup_flg)
	{
#ifdef GRABPOINTER
	 /* geht nicht richtig: */
	 if(knopfnr==2)
	   XGrabPointer(dpy,win1,TRUE,0xFFFFFFFF,
		TRUE,FALSE,win1,cursor,CurrentTime);
	 /* :geht nicht richtig */
#endif
	 fadenkreuz(x,y);
	 if(yzoom_flg) x1=xmi2; else x1=XWERT(x);
	 if(xzoom_flg || blowup_flg) y1=ymi2; else y1=YWERT(y);
	}
    else if(on_flg)
	{last_point_i=int((XWERT(x)-xmi1+deltax/2.)/deltax);
	 x1=last_point_i*deltax+xmi1;
	 last_point_y=y1=zfeld[last_point_i];
	 x=int((x1-xmi2+dx2/2.)/dx2);
	 if(x<0)	{x=0; igno=1;}
	 else if(x>tekplot_breite-1) {x=tekplot_breite-1; igno=1;}
	 y=int((yma2-y1+dy2/2.)/dy2+menubalkenhoehe);
	 if(y<0)	{y=0; igno=1;}
	 else if(y>tekplot_hoehe-1) {y=tekplot_hoehe-1; igno=1;}
	 if(igno==0)
		{ on_x=x; /* Fadenkreuz auf x-Wert festhalten */
		  neuesfadenkreuz(x,y); fadenkreuz(x,y); XSync(dpy,0); }
	}
    else if(integral_flg || subramp_flg /*|| getdeltas_flg*/)
	{x1=XWERT(x); y1=YWERT(y); integral_x1=x; integral_y1=y;
	 if(integral_flg)	integral_flg=2;
	 else if(subramp_flg)	subramp_flg=2;
	/* else		  	getdeltas_flg=2;*/
	}
    else if(getdeltas_flg)
	{if(dsearch_methode==0)
		{x1=XWERT(x); y1=YWERT(y); integral_x1=x; integral_y1=y;}
	 else
		{x1=XWERT(x-SEARCHRADI); y1=YWERT(y-SEARCHRADI);
		 x2=XWERT(x+SEARCHRADI); y2=YWERT(y+SEARCHRADI);
		 minmaxsearch(x1,y1,x2,y2);
		 if(dsearch_methode==1) {x1=x2; y1=y2;}//Maximum
		 integral_x1=(int)INVXWERT(x1);
		 integral_y1=(int)INVYWERT(y1);
		}
	 getdeltas_flg=2;
	}
    else if(getpoint_flg)
	{fadenkreuz(x,y);
	 if(search_methode==0)
		{xgetpunkt=XWERT(x); ygetpunkt=YWERT(y);}
	 else	{/* Maximum zwischen x-dx und x+dx suchen */
		 /* wobei dx = (xma2-xmi2)/npkt*(Cursorbreite/2) */
		 x1=XWERT(x-SEARCHRADI); y1=YWERT(y-SEARCHRADI);
		 x2=XWERT(x+SEARCHRADI); y2=YWERT(y+SEARCHRADI);
		 minmaxsearch(x1,y1,x2,y2);
		 if(search_methode==1)	{xgetpunkt=x2; ygetpunkt=y2;}//Maximum
		 else	{xgetpunkt=x1; ygetpunkt=y1;} //Minimum
		}
	 if(get_sflag)	fun=fun_getpoints;
	 else		fun=fun_getpoint;
	 if(get_sflag==0) lower_window();
	 user_prog(&fun,&xgetpunkt,&ygetpunkt,NULL,NULL);
	 if(get_sflag==0) raise_window();
	 if(get_sflag==0) {fadenkreuz_aus(); getpoint_flg=flag_flg=0;}
	}
    else if(stretch_flg || positio_flg)
	{x1=XWERT(x); y1=YWERT(y);}
    else if(settext_flg)
	{fadenkreuz(x,y);
	 xtext=XWERT(x); ytext=YWERT(y);
	 fadenkreuz_aus(); settext_flg=flag_flg=0;
	}
    else
	igno=1;
   }
 else /* Knopf losgelassen */
   {if(igno==0)
	{if(zoom_flg || xzoom_flg || yzoom_flg || blowup_flg)
		{
#ifdef GRABPOINTER
		 if(knopfnr==2) XUnGrabPointer(dpy,CurrentTime);// geht nicht
#endif
		 fadenkreuz_aus();
		 if(xzoom_flg || blowup_flg) y2=yma2; else y2=YWERT(faden_y);
		 if(yzoom_flg) x2=xma2; else x2=XWERT(faden_x);
		 zoom_flg=xzoom_flg=yzoom_flg=flag_flg=0;
		 if(xma1>xmi1)
			{if(x2<x1) {h=x1; x1=x2; x2=h;}
			 if(x1<xmi1) x1=xmi1;
			 if(x2>xma1) x2=xma1;
			}
		 else	{if(x2>x1) {h=x1; x1=x2; x2=h;}
			 if(x1>xmi1) x1=xmi1;
			 if(x2<xma1) x2=xma1;
			}
		 if((y2<y1 && yma1>ymi1) || (y2>y1 && yma1<ymi1))
			{h=y1; y1=y2; y2=h;}
		 if(x1!=x2 && y1!=y2)
			{if(blowup_flg) blowup(x1,x2);
			 else show(x1,y1,x2,y2,1);
			}
		}
	 else if(on_flg)
		{fadenkreuz_aus();
		 y2=YWERT(faden_y);
		 zfeld[last_point_i]=y2; change_flag=1;
		 if(shmodus==2) zhfeld[last_point_i]=y2;
		 show(xmi2,ymi2,xma2,yma2,0);
		 on_x = -1;/* Fadenkreuz frei beweglich */
		 fadenkreuz_ein();
		}
	 else if(integral_flg)
		{x2=XWERT(faden_x); y2=YWERT(faden_y);
		 if(integral_methode==1) y2=y1;//auf Wunsch von Klaus
		 fadenkreuz_aus();
		 erfolg=integral(x1,y1,x2,y2);
		 if(erfolg && int_sflag==0)
		      integral_flg=flag_flg=0;
		 else {if(erfolg) user_prog(&fun_integrals/*&fun_intsave*/,
					    &integralwert,
					    &xspitze,&yspitze,integralgrenzen);
		       integral_flg=flag_flg=1; fadenkreuz_ein();
		      }
		}
	 else if(getdeltas_flg)
		{x2=XWERT(faden_x); y2=YWERT(faden_y);
		 fadenkreuz_aus();
		 erfolg=differenz(x1,y1,x2,y2);
		 if(erfolg) user_prog(&fun_getdeltas,
				      &integralwert,integralgrenzen,NULL,NULL);
		 getdeltas_flg=flag_flg=1; fadenkreuz_ein();
		}
	 else if(stretch_flg)
		{y2=YWERT(faden_y);
		 if((h=y1-ymi2)==0.) strepos_faktor=1.;
		 else strepos_faktor=(y2-ymi2)/h;
		 if(strepos_faktor==0.) strepos_faktor=1.;
		 pzh=zeigauf(spektrumb);
		 for(i=0;i<npkt;i++)
			*pzh++ *= strepos_faktor;
		 strepos_flag=2;
		 show(xmi2,ymi2,xma2,yma2,0);
		}
	 else if(positio_flg)
		{strepos_faktor = YWERT(faden_y) - y1;
		 pzh=zeigauf(spektrumb);
		 for(i=0;i<npkt;i++)
			*pzh++ += strepos_faktor;
		 strepos_flag=1;
		 show(xmi2,ymi2,xma2,yma2,0);
		}
	 else if(subramp_flg)
		{x2=XWERT(faden_x); y2=YWERT(faden_y);
		 fadenkreuz_aus();
		 subramp_flg=flag_flg=0;
		 subramp(x1,y1,x2,y2);
		}
	 igno=1;
	 if(puuflag) {puuflag=0; flg_schalten(&puundin_flg);}
	}
   }
 return;
}

void fensterposition()
{
 int flag;
 if(rambildflag && !initalflag)
	{if(!(flag=refreshflag)) fadenkreuz_aus();
	 XCopyArea(dpy,rambild,win1,gc,0,0,winbreite+1,winhoehe+1,0,0);
	 if(!flag) fadenkreuz_ein();
	}
 XSync(dpy,0);
 /* Hier koennte man auch noch die Positionen von	*/
 /* Menufenster und Grafikfenster aneinander anpassen.	*/
 return;
}

void bewegung(int x,int y)
{
 double xwert,ywert;
 xwert=XWERT(x); ywert=YWERT(y);
 sprintf((char*)&fenstername[fenstername1_len]," x=%lg  y=%lg",xwert,ywert);
 XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8, PropModeReplace,
		 (uchar*)fenstername, strlen((char*)fenstername));
 if(flag_flg)
	{if(on_flg && on_x != -1) neuesfadenkreuz(on_x,y);
	 else	neuesfadenkreuz(x,y);
	 XSync(dpy,0);}
 else	{faden_x=x; faden_y=y;}
 return;
}

void fadenkreuz_ein() //provisorische Version
{
 refreshflag=0; fadenkreuzflag=1;
 if(hintergrundfarbe==1) //sind wir direkt am Henri ?
   {XSetForeground(dpy,gc,1);
    XSetFunction(dpy,gc,GXxor);
   }
 else XSetFunction(dpy,gc,(vordergrundfarbe==0)?GXequiv:GXxor);
 fadenkreuz(faden_x,faden_y);
}

void fadenkreuz_aus()
{
 fadenkreuz(faden_x,faden_y);
 XSetFunction(dpy,gc,GXcopy);
 refreshflag=1; fadenkreuzflag=0;
}

/** richtige Version (geht noch nicht) **
void fadenkreuz_ein()
{
 refreshflag=0; fadenkreuzflag=1;
#ifdef XTEKPLOT_1
 drawmode(COMPLEMENT);
#else
 XSetFunction(dpy,gc,(vordergrundfarbe==0)?GXequiv:GXxor);
#endif
 fadenkreuz(faden_x,faden_y);
}

void fadenkreuz_aus()
{
 fadenkreuz(faden_x,faden_y);
#ifdef XTEKPLOT_1
 drawmode(JAM1);
#else
 XSetFunction(dpy,gc,GXcopy);
#endif
 refreshflag=1; fadenkreuzflag=0;
}
/**/

void neuesfadenkreuz(int x,int y)
{
 fadenkreuz(faden_x,faden_y);
 fadenkreuz(x,y);
}

void fadenkreuz(int x,int y)
{
 if(x<0 || y<0) return;
 faden_x=x; faden_y=y;
 if(zoom_flg || xzoom_flg || yzoom_flg || blowup_flg)
	{if(!yzoom_flg) XDrawLine(dpy,win1,gc,x,menubalkenhoehe,
					x,tekplot_hoehe+menubalkenhoehe);
	 if((!xzoom_flg) && (!blowup_flg))
			XDrawLine(dpy,win1,gc,0,y,tekplot_breite,y);
	}
 else if(on_flg)
	{XDrawLine(dpy,win1,gc,x,y+6,x,y-6); /* Kreuz */
	 XDrawLine(dpy,win1,gc,x-6,y,x+6,y);
	}
 else if(integral_flg)
	{if(integral_flg==3)
		XDrawLine(dpy,win1,gc,integral_x1,integral_y1,x,y);
	 else
		{if(integral_flg==2) integral_flg++;
		 XDrawLine(dpy,win1,gc,x,y+4,x,y-4); /* schraeges Kreuz */
		 XDrawLine(dpy,win1,gc,x-4,y,x+4,y);
		}
	}
 else if(getpoint_flg) /* Viereck */
	{XDrawLine(dpy,win1,gc,x-SIX,y+SIX,x+SIX,y+SIX);
	 XDrawLine(dpy,win1,gc,x+SIX,y+SIX,x+SIX,y-SIX);
	 XDrawLine(dpy,win1,gc,x+SIX,y-SIX,x-SIX,y-SIX);
	 XDrawLine(dpy,win1,gc,x-SIX,y-SIX,x-SIX,y+SIX);
	}
 else if(getdeltas_flg)
	{if(getdeltas_flg==3)
		XDrawLine(dpy,win1,gc,integral_x1,integral_y1,x,y);
	 else
		{if(getdeltas_flg==2) getdeltas_flg++;
		 XDrawLine(dpy,win1,gc,x,y+4,x,y-4); /* schraeges Kreuz */
		 XDrawLine(dpy,win1,gc,x-4,y,x+4,y);
		}
	}
 else if(stretch_flg)
	{XDrawLine(dpy,win1,gc,x,y-12,x,y+12);}
 else if(positio_flg)
	{XDrawLine(dpy,win1,gc,x-12,y,x+12,y);}
 else if(subramp_flg)
	{if(subramp_flg==3)
		XDrawLine(dpy,win1,gc,integral_x1,integral_y1,x,y);
	 else
		{if(subramp_flg==2) subramp_flg++;
		 XDrawLine(dpy,win1,gc,x-8,y+6,x+8,y+6);
		 XDrawLine(dpy,win1,gc,x+8,y+6,x+8,y-4);
		 XDrawLine(dpy,win1,gc,x+8,y-4,x-8,y-8);
		 XDrawLine(dpy,win1,gc,x-8,y-8,x-8,y+6);
		}
	}
 else if(puundin_flg) /* Sechseck */
	{int i,xp[7],yp[7],h=SIX-1,b=SIX/2;
	 xp[0]=xp[5]=xp[6]=x-h; yp[0]=yp[2]=yp[6]=y+b;
	 xp[1]=xp[4]=x; yp[1]=y+h;
	 xp[2]=xp[3]=x+h; yp[3]=yp[5]=y-b;
	 yp[4]=y-h;
	 for(i=0;i<6;i++)
		XDrawLine(dpy,win1,gc,xp[i],yp[i],xp[i+1],yp[i+1]);
/*alte Variante
	 XDrawLine(dpy,win1,gc,x-5,y+3,x,y+5);
	 XDrawLine(dpy,win1,gc,x,y+5,x+4,y+3);
	 XDrawLine(dpy,win1,gc,x+4,y+3,x+4,y-3);
	 XDrawLine(dpy,win1,gc,x+4,y-3,x,y-5);
	 XDrawLine(dpy,win1,gc,x,y-5,x-5,y-3);
	 XDrawLine(dpy,win1,gc,x-5,y-3,x-5,y+3);
*/
	}
 else if(settext_flg) /* Textkasten */
	{y -= 16; /* heisser Punkt liegt 16 Bildpunkte unter der Ecke */
	 XDrawLine(dpy,win1,gc,x-6,y,x+txtbr,y);
	 XDrawLine(dpy,win1,gc,x+txtbr,y,x+txtbr,y+txtho);
	 XDrawLine(dpy,win1,gc,x+txtbr,y+txtho,x,y+txtho);
	 XDrawLine(dpy,win1,gc,x,y+txtho,x,y-6);
	}
 XSync(dpy,0);//test auf MAC
 return;
}

#endif //UNIX_OR_VAX_OR_ALPHA
#ifdef MAC

void klick(int knopf,int x,int y,int knopfnr)
{
}
void fensterposition()
{
}
void bewegung(int x,int y)
{
}
void fadenkreuz_ein()
{
}
void fadenkreuz_aus()
{
}
void neuesfadenkreuz(int x,int y)
{
}
void fadenkreuz(int x,int y)
{
}

#endif

/*********** Programmteile die durch Menuauswahl erreicht werden ***********/
/*
  file_load(), file_save(), file_exit()  und  user_prog(fun,p1,p2,p3,p4)
  muessen vom Anwender im Hauptprogramm definiert werden.
*/

void show_total()
{
// extern double xmi1,ymi1,xma1,yma1;
 show(xmi1,ymi1,xma1,yma1,1);
}

void show_previous()
{
 show(last_x1,last_y1,last_x2,last_y2,1);
}

static void flags_aus()
{
 if(flag_flg)
	{fadenkreuz_aus(); on_x= -1;
	 integral_flg=on_flg=zoom_flg=xzoom_flg=yzoom_flg=getpoint_flg=
	 flag_flg=stretch_flg=positio_flg=subramp_flg=puundin_flg=
	 getdeltas_flg=blowup_flg=0;
	}
}

void flg_schalten(short *flg)
{
 if(*flg)	{fadenkreuz_aus(); *flg=flag_flg=0;}
 else	{flags_aus(); *flg=flag_flg=1; fadenkreuz_ein();}
}

void show_goback()
{
 double delta,xmi,xma,ymi,yma;
 delta=(yma2-ymi2)/2.; yma=yma2+delta; ymi=ymi2-delta;
 delta=(xma2-xmi2)/2.; xma=xma2+delta; xmi=xmi2-delta;
 if(xma1>xmi1)
	{if(xmi<xmi1) xmi=xmi1;
	 if(xma>xma1) xma=xma1;
	}
 else	{if(xmi>xmi1) xmi=xmi1;
	 if(xma<xma1) xma=xma1;
	}
 show(xmi,ymi,xma,yma,1);
}

void edit_undo()
{
 int i;
 if(change_flag)
  {zfeld[last_point_i]=last_point_y;
   if(shmodus==2) zhfeld[last_point_i]=last_point_y;
   change_flag=0;
  }
 else if(smoot_flag)
  {for(i=0;i<npkt;i++)
	zfeld[i]=sfeld[i];
   if(shmodus==2)  for(i=0;i<npkt;i++) zhfeld[i]=zfeld[i];
   smoot_flag=0;
  }
 else if(blowup_flag)
  {if(blowupfaktor==0.) printf("sorry, can't undo with blowupfaktor==0.\n");
   else aufblasen(blowup_x1,blowup_x2,1./blowupfaktor,0.,blowupshift);
   blowup_flag=0;
  }
 else
   return;
 show(xmi2,ymi2,xma2,yma2,0);
}

void edit_save_points()
{
 int i;
 if(savefeld==NULL) savefeld=feldcalloc();
 for(i=0;i<npkt;i++)
	savefeld[i]=zfeld[i];
}

void edit_last_saved()
{
 int i;
 if(savefeld==NULL) return;
 for(i=0;i<npkt;i++)
	{zfeld[i]=savefeld[i];
	 if(shmodus==2) zhfeld[i]=savefeld[i];
	}
 show(xmi2,ymi2,xma2,yma2,0);
}

void peak_intsave()
{
 lower_window();
 user_prog(&fun_intsave,&integralwert,&xspitze,&yspitze,integralgrenzen);
 raise_window();
}

void peak_getpoint()
{
 flg_schalten(&getpoint_flg);
}

void getintoff()
{
 get_sflag=0; int_sflag=0;
 flags_aus();
}

void subtra_undo()
{
 int i;
 float *za,*zb,*zs;
 if(strepos_flag)
   {zb=zeigauf(spektrumb);
    if(strepos_flag==2)
	for(i=0;i<npkt;i++)  *zb++ /= strepos_faktor;
    else
	for(i=0;i<npkt;i++)  *zb++ -= strepos_faktor;
    strepos_flag=0;
    refresh();
   }
 else if(subtr_flag)
   {za=zeigauf(spektruma); zs=sfeld;
    if(shmodus==2 && zhfeld!=NULL)
	for(zb=zeigauf(spektrumb),i=0;i<npkt;i++)  *zb++ = *za++ = *zs++;
    else
	for(i=0;i<npkt;i++)  *za++ = *zs++;
    subtr_flag=0;
    refresh();
   }
 else if(swap_flag)
   {subtra_swap(0);}
}

void subtra_error()
{
 requester("subtra_error: missing spectrum B");//provi.
}

void subtra_position()
{
 if(!subtra_flag) {subtra_error(); return;}
 if(positio_flg) {fadenkreuz_aus(); positio_flg=flag_flg=0;}
 else	{flags_aus(); positio_flg=flag_flg=1; fadenkreuz_ein();}
}

void subtra_stretch()
{
 if(!subtra_flag) {subtra_error(); return;}
 if(stretch_flg) {fadenkreuz_aus(); stretch_flg=flag_flg=0;}
 else	{flags_aus(); stretch_flg=flag_flg=1; fadenkreuz_ein();}
}

void subtra_subtract()
{
 int i;
 float *sf,*zf,*zh;
 if(!subtra_flag) {subtra_error(); return;}
 if(sfeld==NULL) sfeld=feldcalloc();
 for(i=0,sf=sfeld,zf=zeigauf(spektruma),zh=zeigauf(spektrumb);i<npkt;i++)
	{*sf++ = *zf;
	 *zf++ -= *zh++;
	}
 subtr_flag=1; swap_flag=strepos_flag=0;
 refresh();
}

void subtra_divid()
{
 int i;
 float *sf,*zf,*zh,z;
 if(!subtra_flag) {subtra_error(); return;}
 if(sfeld==NULL) sfeld=feldcalloc();
 for(i=0,sf=sfeld,zf=zeigauf(spektruma),zh=zeigauf(spektrumb);i<npkt;i++)
	{*sf++ = *zf;
	 z= *zh++; if(z==0) z=1;
	 *zf++ /= z;
	}
 subtr_flag=1; swap_flag=strepos_flag=0;
 refresh();
}

void subtra_beer()
{
 int i;
 float *sf,*zf,*zh;
 double i0,i1,od;
 const double MAXOD=4.0;
 if(!subtra_flag) {subtra_error(); return;}
 if(sfeld==NULL) sfeld=feldcalloc();
 for(i=0,sf=sfeld,zf=zeigauf(spektruma),zh=zeigauf(spektrumb);i<npkt;i++)
	{i1 = *sf++ = *zf;
	 i0 = *zh++;
	 if(i1==0.0 || (od=i0/i1)<=0.0) od=MAXOD; else od=log10(od);
	 *zf++ = (float)od;
	}
 subtr_flag=1; swap_flag=strepos_flag=0;
 refresh();
}

void subtra_swap(int flag)
{
 int i;
 static double yswap=0.;
 float *zb;
 if(!subtra_flag) {subtra_error(); return;}
 if(flag) yswap=ymi2+yma2;
 for(zb=zeigauf(spektrumb),i=0;i<npkt;i++,zb++)
			*zb = yswap - *zb;
 swap_flag=flag;
 subtr_flag=strepos_flag=0;
 refresh();
}

void subtra_exchange()
{
 double h;
 int i;
 float *za,*zb;
 if(!subtra_flag) {subtra_error(); return;}
 za=zeigauf(spektruma); zb=zeigauf(spektrumb); 
 for(i=0;i<npkt;i++)
	{h = *za;  *za++ = *zb;  *zb++ = h;}
 swap_flag=subtr_flag=strepos_flag=0;
}

void settextpos()
{
 int br,i,c;
 char *s;
 if(labeltext_flag==0)  spename_laden();
 br=0;
 for(i=0;i<anzahl_spenamen;i++)
	if((c=strlen(spename[i]))>br) br=c;
/* txtbr=br*10; txtho=anzahl_spenamen*21; vor Version 2.4.03 */
 txtbr=br*10*tbuch/TBUCHDEFAULT;
 txtho=anzahl_spenamen*21*titelabst/TITABSTDEFAULT;
 flg_schalten(&settext_flg);
 textposflag=1;
}

/************************ show, integral, smooth  usw. ********************/
void show(double x1,double y1,double x2,double y2,int flag)
{			/* flag: wenn gesetzt: letzte Werte speichern */
// extern double xmi1,ymi1,xma1,yma1,deltax, xmi2,ymi2,xma2,yma2,dx2,dy2;
 float *zf,*zhf;
 int i,imin,imax,rflag;
 int flag3d=(ramen_flag==3);
 static int ersteraufruf=1;
 short *pf;
 double x,y,y0,y11;
 if((rflag=fadenkreuzflag)==1) fadenkreuz_aus();
 if(flag) {last_x1=xmi2; last_y1=ymi2; last_x2=xma2; last_y2=yma2;}
 xmi2=x1; ymi2=y1; xma2=x2; yma2=y2;
 if(dpy) screenclear();
 qinital(1,x1,y1,x2,y2);
 if(ersteraufruf) {setcolors(1); ersteraufruf=0;}//test
 if(tekplot_tiefe>1) color(1);/* fr farbige Darstellung am Bildschirm */
 dx2=(x2-x1)/tekplot_breite; dy2=(y2-y1)/tekplot_hoehe;
 imin=int((x1-xmi1)/deltax+0.999); imax=int((x2-xmi1)/deltax+0.001);
 if(flag3d)	//3D-Darstellung ?
	{plot3d_init(x1,y1,x2,y2,imax-imin+1);
	 plot3d(xmi1+deltax*imin,zfeld[imin],UP);
	}
 else	q2plot(xmi1+deltax*imin,zfeld[imin],UP);
 for(pf= &penfeld[imin+1],zf= &zfeld[imin+1],i=imin+1;i<=imax;i++)
	{x=xmi1+deltax*i;
	 if(flag3d) plot3d(x,*zf++,*pf++);
	 else q2plot(x,*zf++,*pf++);
	}
 if(shmodus==2)
   {for(zf= &zfeld[imin],zhf= &zhfeld[imin],i=imin;i<=imax;i++,zf++,zhf++)
     if(*zf != *zhf)
	{x=xmi1+deltax*i; q2plot(x,*zf,3); q2plot(x,*zhf,2);}
   }
 else if(shmodus>=4 && zhfeld!=NULL)
   {int offset,j,n;
    if(shmodus==4) n=2; else n=nspektren;
    if(flag3d)  /* 3D-Darstellung ? */
     {double dx,dy,x3d,y3d,tfeld[MAXCOLOR];
      int farbig=tfeld_laden(x1,y1,x2,y2,tfeld,&dx,&dy);
      for(offset=0,j=2; j<=n; j++,offset+=npkt)
	{if(farbig) bildgestrichelt(j);
	 x3d=dx*tfeld[j-1]; y3d=dy*tfeld[j-1];
	 plot3d(xmi1+deltax*imin+x3d,zhfeld[imin+offset]+y3d,UP);
	 for(zhf= &zhfeld[imin+1+offset],i=imin+1;i<=imax;i++)
	  {x=xmi1+deltax*i + x3d; y= *zhf++ + y3d;
	   plot3d(x,y,DOWN);
	  }
	}
     }
    else /* ohne 3D-Darstellung */
     for(offset=0,j=2; j<=n; j++,offset+=npkt)
	{bildgestrichelt(j);
	 q2plot(xmi1+deltax*imin,zhfeld[imin+offset],UP);
	 for(zhf= &zhfeld[imin+1+offset],i=imin+1;i<=imax;i++)
		{x=xmi1+deltax*i;
		 q2plot(x,*zhf++,DOWN);
		}
	}
    bildnichtgestrichelt();
   }
#ifdef USE_HPGL
 if(hpglflag) hpcolor(0); /* Farbe fuer Beschriftung */
#endif
 if(ramen_flag)
  {if(ramen_flag==2) y0=rundezahl(y1,y2);
   else  y0=rundezahl(y1+(y2-y1)/60.,y1+(y2-y1)/20.);
   yachsenposition=y0;
   y11=y0-(y2-y1)/40.;
   if(y2>y1) {if(y11<y1) y11=y1;}
   else      {if(y11>y1) y11=y1;}
   pramen(x1,y11,x2,y2,y0);
  }
 qterm();
 if(rflag==1) fadenkreuz_ein();
}

void refresh()
{
 show(xmi2,ymi2,xma2,yma2,0);
}

int integral(double x1,double y1,double x2,double y2)
{
 double sum,dy,x;
 int i,imin,imax;
 imin=int((x1-xmi1)/deltax+0.5); imax=int((x2-xmi1)/deltax+0.5);
 if(imax==imin) return 0;
 x1=deltax*imin+xmi1; x2=deltax*imax+xmi1;
 integralgrenzen[0]=x1; integralgrenzen[1]=y1;
 integralgrenzen[2]=x2; integralgrenzen[3]=y2;
 if(shmodus==2)
	{dy=(y2-y1)/(imax-imin); qinital(1,xmi2,ymi2,xma2,yma2);}
 if(imin>imax)
	{i=imax; imax=imin; imin=i;  x=y2; y2=y1; y1=x;}
 yspitze=zfeld[imin]; xspitze=0.;
 sum=(zfeld[imin]+zfeld[imax])/2.;
 for(i=imin+1;i<imax;i++)
	{sum+=zfeld[i];
	 if(zfeld[i]>yspitze) {yspitze=zfeld[i]; xspitze=xmi1+deltax*i;}
	 if(shmodus==2)
		{if(zhfeld[i]==zfeld[i]) zhfeld[i]=(i-imin)*dy+y1;
		 else zhfeld[i]=zfeld[i];/* schon mal markierter Punkt */
		 x=xmi1+deltax*i;
		 q2plot(x,zhfeld[i],3); q2plot(x,zfeld[i],2);
		}
	}
 if(shmodus==2) qterm();
 integralwert = sum = sum*fabs(deltax) - (y1+y2)/2.*fabs(x2-x1);
 sprintf((char*)fenstername," I=%lg  ",sum);
 fenstername1_len=strlen((char*)fenstername);
 XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (uchar*)fenstername, fenstername1_len);
 return 1;
}

int differenz(double x1,double y1,double x2,double y2)
{
 double delta,x;
 int imin,imax;
 if(x1==x2 && y1==y2) return 0;
 imin=int((x1-xmi1)/deltax+0.5); imax=int((x2-xmi1)/deltax+0.5);
 x1=deltax*imin+xmi1; x2=deltax*imax+xmi1;
 integralgrenzen[0]=x1; integralgrenzen[1]=y1;
 integralgrenzen[2]=x2; integralgrenzen[3]=y2;
 if(shmodus==2)
	{qinital(1,xmi2,ymi2,xma2,yma2);}
 if(shmodus==2)
   if(zhfeld[imin]!=zfeld[imin]) /* Wenn schon markiert, */
	{XSetForeground(dpy,gc,hintergrundfarbe);/* Loeschfarbe */
	 zhfeld[imin]=y2; x=xmi1+deltax*imin;
	 q2plot(x,zhfeld[imin],3); q2plot(x,zfeld[imin],2);
	 q2plot(x,zfeld[imin],3);
	 XSetForeground(dpy,gc,vordergrundfarbe);/* wieder Vordergrundfarbe */
	 zhfeld[imin]=zfeld[imin]; /* dann Markierung aufheben. */
	}
   else	{zhfeld[imin]=y2; x=xmi1+deltax*imin;
	 q2plot(x,zhfeld[imin],3); q2plot(x,zfeld[imin],2);
	}
 if(shmodus==2) qterm();
 integralwert = delta = y1-y2;
 sprintf((char*)fenstername," D=%lg  ",delta);
 fenstername1_len=strlen((char*)fenstername);
 XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (uchar*)fenstername, fenstername1_len);
 return 1;
}

void minmaxsearch(double &x1,double &y1,double &x2,double &y2)
{
 double xmin=0.,xmax=0.,ymin,ymax,z;
 int i,imin,imax,maximax=int((xma1-xmi1)/deltax+0.5);
 imin=int((x1-xmi1)/deltax+0.5); imax=int((x2-xmi1)/deltax+0.5);
 if(imin>imax)
	{i=imax; imax=imin; imin=i;  z=x2; x2=x1; x1=z;}
 if(y1>y2) {z=y2; y2=y1; y1=z;}
 if(imin<0) imin=0;
 else if(imin>maximax) imin=maximax;
 if(imax>maximax) imax=maximax;
 ymax=y1; ymin=y2;
 //printf("Test: minmaxsearch() i=%d...%d\n",imin,imax);//test
 for(i=imin;i<=imax;i++)
      if((z=zfeld[i])>=y1 && z<=y2)
	{//printf("zfeld[%d]=%lf x=%lf\n",i,zfeld[i],xmi1+deltax*i);//test
	 //printf("deltax=%lf xmi1=%lf xma1=%lf\n",deltax,xmi1,xma1);//test
	 if(z>ymax) {ymax=z; xmax=xmi1+deltax*i;}
	 if(z<ymin) {ymin=z; xmin=xmi1+deltax*i;}
	}
 x1=xmin; y1=ymin; x2=xmax; y2=ymax; //Rueckgabewerte
}

//Die folgenden Tabellen stammen aus
// Analytical Chemistry, 36,8 (1964) 1627-38

static int quadcub_feld[]={ //fuer quadratisches und kubisches Polynom
  -3, 12, 17, //5
  -2,  3,  6,  7, //7
 -21, 14, 39, 54, 59, //9
 -36,  9, 44, 69, 84, 89, //11
 -11,  0,  9, 16, 21, 24, 25,
 -78,-13, 42, 87,122,147,162,167,
 -21, -6,  7, 18, 27, 34, 39, 42, 43,
-136,-51, 24, 89,144,189,224,249,264,269,
-171,-76,  9, 84,149,204,249,284,309,324,329,
 -42,-21, -2, 15, 30, 43, 54, 63, 70, 75, 78, 79,
-253,-138,-33,62,147,222,287,322,387,422,447,462,467 //25
};
static int quadquint_feld[]={ //fuer Polynome 4. und 5. Ordnung
  5,  -30,   75,  131, //7
   15,  -55,   30,  135, 179,
   18,  -45,  -10,   60, 120, 143,
  110, -198, -160,  110,  390, 600,  677,
 2145,-2860, -2937, -165, 3755,7500,10125,11063, //15
  195, -195,  -260, -117,  135, 415,  660,  825,  883,
  340, -255,  -420, -290,   18,  405,  790, 1110, 1320, 1393,
11628,-6460,-13005,-11220,-3940,6378,17655,28190,36660,42120,44003,
  285, -114,  -285,  -285, -165,  30,  261,  495,  705,  870,  975,1011, //23
 1265, -345, -1122, -1255, -915,-255,  590, 1503, 2385, 3155, 3750,4125,4253
};

class Quadcub
{
 int nmin,nmax,drei; //Bereich der Koeffizienten in Tabelle
 int *feld;
 void intcheck()
	{if(sizeof(int)<4) printf("Fehler: int ist nur %lu Bytes lang\n",
				  sizeof(int));
	 //Compiler-Voreinstellungen auf int=4Bytes umstellen !
	}
public:
 Quadcub(int min,int *f)
	{nmin=min; nmax=25; feld=f; drei=(nmin+1)/2; intcheck();}
 int get(int,int);
};

int Quadcub::get(int zeile,int spalte)
{
 int j,k,i,mitte=(zeile+1)/2;
 if(zeile<nmin || zeile>nmax || (zeile&1)!=1)
  {printf("Fehler in Quadcub::get(%d,%d)\n\
    nur ungerade Werte von %d bis %d erlaubt\n",zeile,spalte,nmin,nmax);
   return 1;
  }
 i=(spalte>mitte)?zeile-spalte:spalte-1;
 j=(zeile-nmin)/2;
 if(j>0) {k=j-1; j=drei*j+(k*(k+1))/2;}
 return feld[j+i];
}

static Quadcub quadcub(5,quadcub_feld), qquint(7,quadquint_feld);
long quadcubic(int zeile,int spalte) {return quadcub.get(zeile,spalte);}
long quadquint(int zeile,int spalte) {return qquint.get(zeile,spalte);}

void smooth(int k,int wicht) // Glaettung ueber n Punkte
			     // wicht=1: Mit Gewichtung nach gewichtmethod
{
 int i,j,m,khalbe,k1halbe,k1,methode;
 double sum;
 long n,wfakt;
 if(sfeld==NULL) sfeld=feldcalloc();
 for(i=0;i<npkt;i++) sfeld[i]=zfeld[i];
 khalbe=k/2; k1halbe=(k-1)/2; k1=k&1;
 methode=(wicht==0)?0:gewichtmethod;
 for(i=0;i<npkt;i++)
   {for(sum=0,n=0,m=1,j=i-k1halbe;j<=i+khalbe;j++,m++)
     if(j>=0 && j<npkt)
       {switch(methode)
	 {case WICHT_SIMPLE: wfakt=(j==i)?2:1; //Mittlerer Punkt gewichtet
	  CASE WICHT_TRIANG: wfakt=(j>i)?(khalbe+1+i-j):(khalbe+k1+j-i);
	  CASE WICHT_CUBIC:  wfakt=quadcubic(k,m); //Polynomanpassung 3.Ord.
	  CASE WICHT_QUINTIC: wfakt=quadquint(k,m);//Polynomanpassung 5.Ord.
	  DEFAULT: wfakt=1; //ohne Gewichtung
	 }
        //if(i==npkt/2) printf("%ld ",wfakt);//test
	sum+=wfakt*double(sfeld[j]); n+=wfakt;
       }
    //if(i==npkt/2 || n==0) printf("\nsum=%lg n=%ld\n",sum,n);//test
    zfeld[i]=sum/n;
   }
 if(shmodus==2)  for(i=0;i<npkt;i++) zhfeld[i]=zfeld[i];
 smoot_flag=1;
 show(xmi2,ymi2,xma2,yma2,0);
}

char *wicht_str(int method)
{
 switch(method)
   {case WICHT_SIMPLE: return "simple";
    case WICHT_TRIANG: return "triang";
    case WICHT_CUBIC:  return "cubic";
    case WICHT_QUINTIC: return "quintic";
   }
 return "unknown";
}

static int altsmoot_n=25,altsmoot_m=WICHT_CUBIC;

void setsmooth(int n)	/* Anzahl Punkte fuer Glaettung einstellen */
{
 if(n==4)
   {smoothNr=altsmoot_n; gewichtung=(altsmoot_m==0)?0:1;
    gewichtmethod=altsmoot_m;
    setsmoothpara();
   }
 else
   {gewichtung=n&1;
    switch(n)
	{case 0: case 1:smoothNr=3; break;
	 case 2: case 3:smoothNr=5; break;
   }	}
}
int setsmoothpara()
{
 int ok,nmin,nmax;
 char gwicht[40];
 if(gewichtung==0)
   strcpy(gwicht,"no");
 else strcpy(gwicht,wicht_str(gewichtmethod));
 ok=requester_input(2,"Anzahl Punkte","%d","%d\n",&smoothNr,
		    "Gewichtung (no simp triang cubic quintic)",
		    "%s","%s",&gwicht);
 if(ok)
   {gewichtung=1; nmin=3; nmax=1000;
    switch(tolower(gwicht[0]))
     {case 's': gewichtmethod=WICHT_SIMPLE;
      CASE 't': gewichtmethod=WICHT_TRIANG;
      CASE 'c': gewichtmethod=WICHT_CUBIC; nmin=5; nmax=25; smoothNr|=1;
      CASE 'q': gewichtmethod=WICHT_QUINTIC; nmin=7; nmax=25; smoothNr|=1;
      CASE 'n': gewichtung=0;
     }
    if(gewichtung && (smoothNr<nmin || smoothNr>nmax))
      {int n=(smoothNr<nmin)?nmin:nmax;
       char str[80];
       sprintf(str,
	       "Anzahl Punkte auf %d gesetzt\n(nur Bereich %d bis %d erlaubt)",
	       n, nmin, nmax);
       ok=janeinrequester(str," ok ","cancel");
       if(ok) smoothNr=n;
      }
   }
 if(ok)
   {sprintf(text_smoot_n,"%%O %d %s weighted",altsmoot_n=smoothNr,
	   (gewichtung!=0)?wicht_str(gewichtmethod):"not");
    altsmoot_m=(gewichtung==0)?0:gewichtmethod;
    if(smooth_ids[4])
      {int n;
       if(smoothNr==3 || smoothNr==5)
	 {n=smoothNr-3; if(gewichtung) n++;}
       else n=4;
       smooth_umschalten(n,smooth_ids[n]);
      }
   }
 return ok;
}
void smooth_help()
{
 janeinrequester("Smooth-Gewichtungs-Methoden:\n\
 no      Es wird jeweils der Durchschnitt aus N Punkten genommen\n\
 simple  Der mittlere Punkt wird doppelt gewichtet\n\
 triang  Die Punkte werden Dreieckfoermig gewichtet\n\
 cubic   Es wird eine Anpassung an ein Polynom 3. Grades gemacht\n\
 quintic Es wird eine Anpassung an ein Polynom 5. Grades gemacht");
}

void subramp(double x1,double y1,double x2,double y2)
{
 double steigung,x;
 int i,flag;
 float *za,*zb,*zs;
 if((x=x2-x1)==0.) return;
 steigung=(y2-y1)/x;
 if(sfeld==NULL) sfeld=feldcalloc();
 zs=sfeld; za=zeigauf(spektruma);
 if(shmodus==2 && zhfeld!=NULL)
   for(zb=zhfeld,i=0;i<npkt;i++)
	{*zs++ = *za;  x=i*deltax+xmi1;
	 *zb++ = *za++ -= y1+steigung*(x-x1);
	}
 else
   for(i=0;i<npkt;i++)
	{*zs++ = *za;  x=i*deltax+xmi1;
	 *za++ -= y1+steigung*(x-x1);
	}
 subtr_flag=1; swap_flag=strepos_flag=0;
 refresh();
}

/*
warte() /* test *
{
 sys$clref(ef2);
 CHECK(sys$setimr(ef2,zeit05,NULL,0,0));
 sys$waitfr(ef2);
}
*/

/**** Behandlung des PLOT-Menupunktes *******/
void qplot_refresh_save(char *s)
{
 qplotsave(s);
 refresh();
 qplotsave("OFF");
}

void plotter(int format)
{
 lepsflag=pscolorflag=0;
 switch(format)
  {/** altes Modell: **
   case DECLASER:
	 qplot_refresh_save("IFF");
	 printf_system("VECT2ILBM %s sys$login:iff.tmp 1560 1120",bildname);
	 printf_system("IFFPLOT sys$login:iff.tmp sys$login:dat.tmp 2");
	 printf_system("LASER/DELETE sys$login:dat.tmp");
	 printf_system(" DEL sys$login:iff.tmp;");
	 printf_system(" DEL %s;",bildname);
   ** :altes Modell **/
#ifdef UNIX_OR_MAC
   case DECLASER: //jetzt neue Printer definiert: Standarddrucker ist Lexmark
	 lepsflag=1;
	 qplot_refresh_save("POST");
	 printf_system("lpr %s",bildname);
   CASE IBMLASER: //auch auf Standarddrucker, aber mit EPS-Unterstuetzung
	 //lepsflag=1; //ueberflssig (17.6.99)
	 qplot_refresh_save("POST");
	 printf_system("eps -s %s",bildname);
   CASE PSPLOTTER: //auf Farbdrucker
	 lepsflag=1; pscolorflag=1;
	 qplot_refresh_save("POST");
	 //printf_system("lpr -l -Pdeskjet %s",bildname);
	 printf_system("lpr -l -Ptektronix %s",bildname);
   CASE HPGLPLOTTER: //auch auf Farbdrucker aber mit eps
	 pscolorflag=1; //korrigiert am 17.6.99 (Zeile hat gefehlt) ??
	 qplot_refresh_save("POST");
	 printf_system("eps -sf %s",bildname);
#else //fuer VAX/ALPHA noch alte Drucker definiert
   case DECLASER: //jetzt auch PostScript
	 lepsflag=1;
	 qplot_refresh_save("POST");
	 printf_system("LASER/DEL %s",bildname);
   CASE IBMLASER:
	 lepsflag=1;
	 qplot_refresh_save("POST");
	 printf_system("PSLASER/DEL %s",bildname);
   CASE PSPLOTTER:
	 lepsflag=1; pscolorflag=1;
	 qplot_refresh_save("POST");
	 printf_system("PSCOLOR/DEL %s",bildname);
   CASE HPGLPLOTTER:
	 qplot_refresh_save("HPGL");
	 printf_system("HPPRINT/DEL %s",bildname);
#endif
   CASE HPGLDATEI:
#ifdef USE_HPGL
	 qplot_refresh_save("HPGL");
	 printf("HPGL Bild als '%s' gespeichert\n",bildname);
#else
	 printf("HPGL wird in dieser Version nicht unterstuetzt\n");
#endif
   CASE IFFDATEI:
#ifdef USE_IFF
	 qplot_refresh_save("IFF");
	 printf("IFF Bild als '%s' gespeichert\n",bildname);
#else
	 printf("IFF wird in dieser Version (noch) nicht unterstuetzt\n");
#endif
   CASE TELLDATEI:
#ifdef USE_TELLAGR
	 qplot_refresh_save("TELL");
	 printf("TELLAGRAF Bild als '%s' gespeichert\n",bildname);
#else
	 printf("TELLAGRAF wird in dieser Version nicht unterstuetzt\n");
#endif
   CASE PSDATEI:
	 qplot_refresh_save("POST");
	 printf("PS Bild als '%s' gespeichert\n",bildname);
   CASE PSDATEIFARBIG:
	 pscolorflag=1;
	 qplot_refresh_save("POST");
	 printf("farbiges PS Bild als '%s' gespeichert\n",bildname);
   CASE ROHXYDATEI:
	 rohxy_speichern(); return;
  }
}

void printf_system(char* str,char* p1)
{
 static char strsys[80];
 sprintf(strsys,str,p1);
 if(str[0]!=' ') printf("%s\n",strsys);
 system(strsys);
}

void rohxy_speichern()
{
// extern double xmi1,ymi1,xma1,yma1,deltax, xmi2,ymi2,xma2,yma2,dx2,dy2;
 int i,imin,imax,rflag;
 double x,y0,y11;
 double x1,y1,x2,y2;
 FILE *fp;
/* char *cstr="  %15.8lg  %15.8lg\n"; */
 char *cstr=" %.9lg\t%.9lg\n";
 if((bildname=getenv("PLOTSAVE"))==NULL) bildname=bildname_default;
 fp=fopen(bildname,"w");
 if(fp==NULL) {printf("kann '%s' nicht oeffnen\n",bildname); return;}
 x1=xmi2; y1=ymi2; x2=xma2; y2=yma2;
 dx2=(x2-x1)/tekplot_breite; dy2=(y2-y1)/tekplot_hoehe;
 imin=int((x1-xmi1)/deltax+0.999); imax=int((x2-xmi1)/deltax+0.001);
 for(i=imin;i<=imax;i++)
	{x=xmi1+deltax*i;
	 fprintf(fp,cstr,x,zfeld[i]);
	}
 if(shmodus>=4 && zhfeld!=NULL)
   {int offset,j,n;
    if(shmodus==4) n=2; else n=nspektren;
    for(offset=0,j=2; j<=n; j++,offset+=npkt)
	{for(i=imin;i<=imax;i++)
		{x=xmi1+deltax*i;
		 fprintf(fp,cstr,x,zhfeld[i+offset]);
		}
	}
   }
 fclose(fp);
 printf("XY-Werte in '%s' gespeichert\n",bildname);
 refresh();
}

/*********************** Pascal Strings ***************************/
struct pascalstring {UWORD n; char s[80];};
#ifdef __cplusplus
extern "C" {
#endif
void pas2cstring(char **ziel,struct pascalstring *pstr)
{
 char *s;
 if(!(s=(char *)calloc(pstr->n+1,1))) return;
 strncpy(s,pstr->s,pstr->n); s[pstr->n]=0;
 *ziel=s;
}

void pascopy(int *n,char *von,char *nach)
{
 int m= *n;
 while(m--) *nach++ = *von++;
}
#ifdef __cplusplus
}
#endif
/************************* kleinkram ******************************/
int getline(FILE* fp,char* s,int lim)
			/* liest eine Textzeile oder maximal lim Zeichen */
{			/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);       /* TRUE wenn erfolgreich, FALSE wenn Fileende */
}


/********************** neu ab Version 2.0 *************************/
void spektnr_setzen(char *name,int *nummer)
{
 lower_window();
 printf("(%d) Nummer von Spektrum %s:",*nummer,name); scanf("%d",nummer);
 raise_window();
}

void yskalierung(float *pfaktor)
{
 double faktor;
 if(pfaktor==NULL || *pfaktor==0.)
	{
	 lower_window();
	 printf("(%lf) y-Skalierung. Faktor:",yskalfakt);
	 scanf("%lf",&faktor);
	 while(faktor==0.)
	   {printf("Null nicht erlaubt! Faktor:"); scanf("%lf",&faktor);}
	 raise_window();
	 spektren_skalieren(faktor);
	 refresh();
	}
 else if(showit_gestartet)
	{spektren_skalieren(*pfaktor);}
 else	yskalfakt= *pfaktor;
}

void spektren_skalieren(double faktor)
{
 int i,imax;
 double f=faktor/yskalfakt;
 if(nspektren<2 && zhfeld!=NULL) imax=2;
 else imax=nspektren;
 for(i=0;i<imax;i++) spektrum_skalieren(i,f);
 ymi2 /= f; ymi1 /= f; yma2 /= f; yma1 /= f;
 yskalfakt=faktor;
}

void spektrum_skalieren(int nr,double fakt)
{
 float *z;
 int i;
 if(nr==0)
	z=zfeld;
 else
	{if(zhfeld==NULL) return;
	 z= &zhfeld[(nr-1)*npkt];
	}
 for(i=0;i<npkt;i++)  *z++ /= fakt;
}

float *zeigauf(int spektrumnummer)
{
 if(spektrumnummer==0 || zhfeld==NULL) return zfeld;
 return &zhfeld[(spektrumnummer-1)*npkt];
}

/********************* Aufblasen ***************************/
static void blowup(double x1,double x2)
{
 blowup_flg=0; blowup_flag=1;
 aufblasen(blowup_x1=x1,blowup_x2=x2,blowupfaktor,blowupshift,0.);
 refresh();
}

static void aufblasen(double x1,double x2,double faktor,
			double shift,double subshift)
{
 float *zf,*zhf;
 double x;
 int i,imin,imax;
 imin=int((x1-xmi1)/deltax+0.5); imax=int((x2-xmi1)/deltax+0.5);
 if(imax==imin) return;
 if(imin>imax) {i=imax; imax=imin; imin=i;}
 if(shift!=0. || subshift!=0.)
  {if(shmodus==2)
      for(zf= &zfeld[imin],zhf= &zhfeld[imin],i=imin;i<imax;i++,zf++,zhf++)
	{*zf = (*zf-subshift)*faktor+shift;
	 *zhf = (*zhf-subshift)*faktor+shift;
	}
   else
     {for(zf= &zfeld[imin],i=imin;i<imax;i++,zf++)
		*zf = (*zf-subshift)*faktor+shift;
      if(blowup_all)
	{int j;
	 for(j=0;j<nspektren-1;j++)
	  for(zf= &zhfeld[j*npkt+imin],i=imin;i<imax;i++,zf++)
		*zf = (*zf-subshift)*faktor+shift;
     }  }
  }
 else
  {if(shmodus==2)
      for(zf= &zfeld[imin],zhf= &zhfeld[imin],i=imin;i<imax;i++)
	{*zf++ *= faktor;
	 *zhf++ *= faktor;
	}
   else
     {for(zf= &zfeld[imin],i=imin;i<imax;i++)
		*zf++ *= faktor;
      if(blowup_all)
	{int j;
	 for(j=0;j<nspektren-1;j++)
	  for(zf= &zhfeld[j*npkt+imin],i=imin;i<imax;i++,zf++)
		*zf++ *= faktor;
     }  }
  }
 if(subshift!=0.) penfeld[imax] = penfeld[imin] = DOWN;
 else if(shift!=0.) penfeld[imax] = penfeld[imin] = UP;
}

/********************* Fouriertransformation ***************************/
#ifndef PI
#define PI 3.141592653589793238
#endif
void bitschuettler(double *rfeld,double *ifeld,int n);
void fft(double *rfeld,double *ifeld,int *pn,int *pinv);
double sq(double x) {return x*x;}
void pft(int nn,double *y,double *a,double *b);
void pft_invers(int nn,double *y,double *a,double *b);
void dft(int nn,int inv,double *a,double *b,double *ya,double *yb);
void feldf2d(int n,float *f,double *d,float *f2=NULL,double *d2=NULL)
{
 if(d2) {if(f2) while(n--) {*d++ = *f++; *d2++ = *f2++;}
	 else	while(n--) {*d++ = *f++; *d2++ = 0.;}
	}
 else while(n--) *d++ = *f++;
}
void feldd2f(int n,double *d,float *f,double *d2=NULL,float *f2=NULL)
{
 if(d2) while(n--) {*f++ = *d++; *f2++ = *d2++;}
 else while(n--) *f++ = *d++;
}
/*void flipfeld(int n,double *f)
{
 double h,*p;
 for(p= &f[n];--p > f;f++) {h= *f; *f= *p; *p=h;}
}*/

int fftmethode=2;

void fft_start(int inversflag)
{
 int n,inv=inversflag,np,i,imin,imax,j;
 static double *rfeld=NULL,*ifeld=NULL;
 imin=int((xmi2-xmi1)/deltax+0.5); imax=int((xma2-xmi1)/deltax+0.5);
 if(imin>imax) {i=imin; imin=imax; imax=i;}
 np=imax-imin;
 if(np==0) return;
 if(shmodus<2 && fftmethode!=2) modus_4();
 if(fftmethode>=5) n=np+2; /*PFT oder DFT*/
 else for(n=4;n<np;n+=n)  ;/*FFT*/
 if(inversflag) printf("Rcktransformation  %d Punkte\n",n);
 else
  {printf("FFT mit %d Punkten von %lf bis %lf  Schrittweite %lf\n",
	n,xmi1+deltax*imin,xmi1+deltax*imax,deltax);
   printf("Umrechnung in Distanzen: Distanz=%lf/(x-%lf)\n",
		n*deltax*deltax, xmi1+deltax*imin);
  }
 if(rfeld==NULL)
  {rfeld=(double*)calloc(n,sizeof(double));
   ifeld=(double*)calloc(n,sizeof(double));
   if(rfeld==NULL || ifeld==NULL)
	{printf("zu wenig Speicher fuer FFT\n");
	 if(rfeld) {cfree(rfeld); rfeld=NULL;}
	 return;
  }	}
 if(fftmethode==6) /*test:DFT (Diskrete FourierTransformation)*/
  {double *afeld=(double*)calloc(n,sizeof(double));
   double *bfeld=(double*)calloc(n,sizeof(double));
   if(n&1) n--;
   feldf2d(n,&zfeld[imin],rfeld,inv?&zhfeld[imin]:(float*)NULL,ifeld);
   dft(n,inv,rfeld,ifeld,afeld,bfeld);
   feldd2f(n,afeld,&zfeld[imin],bfeld,&zhfeld[imin]);
   cfree(afeld); cfree(bfeld);
  }
 else if(fftmethode==5) /*test:PFT (Periodische FourierTransformation)*/
  {double *afeld=(double*)calloc(n,sizeof(double));
   if(n&1) n--;
   feldf2d(n,&zfeld[imin],afeld);
   if(inversflag)
	{feldf2d(n,&zhfeld[imin],ifeld);
	 pft_invers(n,rfeld,afeld,ifeld);
	}
   else	{pft(n,afeld,rfeld,ifeld);
	 feldd2f(n,ifeld,&zhfeld[imin]);
	}
   feldd2f(n,rfeld,&zfeld[imin]);
   cfree(afeld);
  }
 else
 {if(inv)
   {if(fftmethode==2)
	{for(j=0,i=imin;i<imax;i++,j++)
		 if(zfeld[i]==0.) ifeld[j]=rfeld[j]=0.;
	}
    else
	{feldf2d(j=imax-imin,&zfeld[imin],rfeld,&zhfeld[imin],ifeld);
	 for(;j<n;j++) rfeld[j]=ifeld[j]=0.;
	}
    if(fftmethode==2 || fftmethode==4)
	{for(j=n-1,i=1;i<j;i++,j--) /* spiegelkorrektur */
		{rfeld[j]= rfeld[i]; ifeld[j]= -ifeld[i];}
	}
   }
  else
   {feldf2d(j=imax-imin,&zfeld[imin],rfeld,
	    (fftmethode==1) ? &zhfeld[imin] : (float*)NULL, ifeld);
    for(;j<n;j++) rfeld[j]=ifeld[j]=0.;
   }
  fft(rfeld,ifeld,&n,&inv);
  if(fftmethode==2)
	{if(inv) feldd2f(imax-imin,rfeld,&zfeld[imin]);
	 else for(j=0,i=imin;i<imax;i++,j++)
		zfeld[i]=sqrt(sq(rfeld[j])+sq(ifeld[j]));
	}
  else	feldd2f(imax-imin,rfeld,&zfeld[imin],ifeld,&zhfeld[imin]);
 }
 if(fftmethode!=2 || inv) {cfree(rfeld); cfree(ifeld); rfeld=NULL;}
 ymimaxsuchen(zfeld,(fftmethode==2)?(float*)NULL:zhfeld);
 if(shmodus==2) {if(fftmethode==2) modus_1(); else modus_4();}
 else refresh();
}

void fft(double *rfeld,double *ifeld,int *pn,int *pinv)
{
 int n= *pn, inv= *pinv, k,zweik,m;
 //register int i,j;
 int i,j;
 double a,treal,timag,wreal,wimag;
/* if(n>=4) j=n; else j=3;
/* while (j%2==0) j/= 2;	/* n auf die Form 2^k testen */
/* if(j!=1)  { printf("Error: ungueltiges n:%d",n); exit();} */
 bitschuettler(rfeld,ifeld,n);
 for(k=1; k<n; k=zweik)
  {zweik=k+k;
   for (m=0; m<k; m++)
       {wreal= cos(a=m*PI/k);
	wimag= (inv==1) ? sin(a) : -sin(a);
	for (i=m; i<n; i+= zweik)
	  {j=i+k;
	   treal= wreal*rfeld[j] - wimag*ifeld[j];
	   timag= wreal*ifeld[j] + wimag*rfeld[j];
	   rfeld[j]= rfeld[i]-treal; ifeld[j]= ifeld[i]-timag;
	   rfeld[i] += treal; ifeld[i] += timag;
  }    }  }
 if(inv==1)
	for(i=0;i<n;i++) {rfeld[i] /= n; ifeld[i] /= n;}
}

void bitschuettler(double *rfeld,double *ifeld,int n)
{
 //register int m,k,j; double hr,hi;
 int m,k,j; double hr,hi;
 for(j=1;j<n-1;j++)
    {k=0; m=j+n;
     do	{k += k + (m&1);	/* unterstes Bit von m links ins k schieben */
	 m >>= 1;		/* m 1 Bit nach rechts schieben */
	}
     while (m>1);	/* k= Bitreverse(j) */
      if (k<j)	{hr= rfeld[j]; hi= ifeld[j];
		 rfeld[j]= rfeld[k]; ifeld[j]= ifeld[k];
		 rfeld[k]= hr; ifeld[k]= hi;
    }		}
}

void fft_hilfetext()
{
 printf("Fr Distanzmessungen: 2 whlen, korrespondierende Distanzen\n");
 printf("mit bei Transformation angegebener Formel berechnen.\n");
 printf("Fr FFT-Glttung: 2 oder 4 whlen, nach Transformation hochfrequente\n");
 printf("Teile auf 0 setzen (Menu Edit/BlowUp), dann Rcktransformieren.\n");
 printf("fr Rcktransformation muss der gleiche Bereich eingestellt sein.\n");
}
void fft_methode()
{
 char *s; int flag;
 lower_window();
 printf("FFT_Methode:\n");
 printf(" 1  Real und Imag-Teil verwenden (Spektrum 0 u. 1)\n");
 printf(" 2  Eingabe:nur Real  Rueckgabe: Betrag  (imag u. real unsichtbar)\n");
 printf(" 3  FFT-Eingabe:nur Real  Rckgabe:imag und real\n");
 printf(" 4  wie 3 aber mit Spiegelkorrektur bei Rcktransformation\n");
 printf(" 5  PFT verwenden (langsame periodische DFT)\n");
 printf(" 6  DFT verwenden (langsam, nicht periodisch)\n");
 printf(" H  Hilfe\n");
 do
  {flag=0; s=inputstr1("(%ld) FFT_Methode:",fftmethode);
   if(*s!=0)
	{if(!isdigit(*s)) {flag=1; fft_hilfetext();}
	 else sscanf(s,"%d",&fftmethode);
	}
   cfree(s);
  }
 while(flag);
 raise_window();
 if(shmodus<2 && fftmethode!=2) modus_2();
}

/**** PFT = Periodische FourierTransformation ****/
void pft(int nn,double *y,double *a,double *b)
{
 double n2pi,z,*yj,*yi;
 int n,i,Nhalbe=nn/2;
 for(n=0;n<nn;n++)
  {*a=(*(yi=y)+y[nn])/2. + y[Nhalbe]*cos(n2pi=n*PI);
   n2pi/=Nhalbe;
   *b=0.;
   for(yj= &y[nn],i=0;++i<Nhalbe;)
	{*a += (*++yi + *--yj)*cos(z=n2pi*i);
	 *b += (*yi - *yj)*sin(z);
	}
   *a++ /= Nhalbe;
   *b++ /= Nhalbe;
  }
}
void pft_invers(int nn,double *y,double *a,double *b)
{
 double n2pi,z,a0halbe= *a/2.;
 int n,k,Nhalbe=nn/2;
 for(*y=a0halbe,k=0;++k<=nn;) *y += a[k];
 for(n=1;n<nn;n++)
  {n2pi=n*PI/Nhalbe;
   *++y=a0halbe;
   for(k=0;++k<=Nhalbe;)
	{z=k*n2pi;
	 *y += a[k]*cos(z)+b[k]*sin(z);
	}
  }
}

void dft(int nn,int inv,double *a,double *b,double *ya,double *yb)
{
 double m2pi,z,sinz,cosz,*pa,*pb;
 int m,n,Nhalbe=nn/2;
 for(m=0;m<nn;m++)
  {if(inv) m2pi= m*PI/Nhalbe;
   else m2pi= -m*PI/Nhalbe;
   *ya = *a;
   *yb = *b;
   for(pa=a,pb=b,n=0;++n<nn;)
	{z=n*m2pi;
	 *ya += *++pa*(cosz=cos(z)) - *++pb*(sinz=sin(z));
	 *yb += *pa*sinz + *pb*cosz;
	}
   if(inv) {*ya++ /= nn;  *yb++ /= nn;}
   else    {ya++; yb++;}
  }
}

/**********************************************/
void number_zoom()
{
 lower_window();
 xmi2=doubinputstr1("(%lf) xmin:",xmi2);
 xma2=doubinputstr1("(%lf) xmax:",xma2);
 ymi2=doubinputstr1("(%lf) ymin:",ymi2);
 yma2=doubinputstr1("(%lf) ymax:",yma2);
 raise_window();
 refresh();
}

void lower_window() {if(dpy!=NULL) {XLowerWindow(dpy,win1); XSync(dpy,0);}}
void raise_window() {if(dpy!=NULL) {XRaiseWindow(dpy,win1); XSync(dpy,0);}}

/*************************** Requester ***********************************/
#define mydpy1 dpy

#ifndef PIXPROBUCHST_X
#define PIXPROBUCHST_X 6
#define PIXPROBUCHST_Y 8
#endif

int requester(char *text,char *jatext,char *neintext)
{
 int hoehe,breite,ho,br,n1,n2,n3,x,y,x1,y1,x2,y2,x3,y3;
 int x2ul,x2or,y2ul,y2or,x3ul,x3or,y3ul,y3or;/* Grenzen der ja/nein-Boxen */
 int x0=200,y0=20,randbreite=5,fogrund,higrund;
 int i,done,antwort;
 char *name="Requester";
 Window win;
 XEvent event;
 KeySym key;
 GC gc2;
 char txt[10];
 n1=strlen(text); n2=strlen(jatext);
 if(neintext) n3=strlen(neintext); else n3=0;
 br=(n2>n3)?n2:n3;
 i=br+br+6;/* je 2 Buchstaben fuer Rand in Box plus 2 fuer Abstand */
 if(n1>i) i=n1;
 breite=(i+2)*PIXPROBUCHST_X+randbreite+randbreite;
 hoehe=breite*3/4;
 br=(br+2)*PIXPROBUCHST_X;
 ho=2*PIXPROBUCHST_Y;
 x1=(breite-n1*PIXPROBUCHST_X)/2; y1=hoehe/3;
 x2ul=breite/4-br/2; x2or=x2ul+br;
 x3ul=breite*3/4-br/2; x3or=x3ul+br;
 y2ul=y3ul=hoehe*2/3-ho/2; y2or=y3or=hoehe*2/3+ho/2;
 if(!neintext) /* bei nur einer Antwort Box in Mitte */
	{x2ul += breite/4; x2or += breite/4;}
 x2=x2ul+PIXPROBUCHST_X; y2=y3=y2or-PIXPROBUCHST_Y/2;
 x3=x3ul+PIXPROBUCHST_X;
 higrund=WhitePixel(mydpy1,DefaultScreen(mydpy1));
 fogrund=BlackPixel(mydpy1,DefaultScreen(mydpy1));
 win=XCreateSimpleWindow(mydpy1,DefaultRootWindow(mydpy1),
		x0, y0, breite, hoehe, randbreite, fogrund, higrund);
 gc2=XCreateGC(mydpy1,win,0,NULL);
 XSetBackground(mydpy1,gc2,higrund);
 XSetForeground(mydpy1,gc2,fogrund);
 XSelectInput(mydpy1,win, ButtonPressMask|KeyPressMask|ExposureMask);
 XChangeProperty(mydpy1, win, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (UBYTE*)name, strlen((char *)name));
 XMapRaised(mydpy1,win);
 for(done=0;done==0;)
  {XNextEvent(mydpy1,&event);
   if(event.xexpose.window==win) switch(event.type)
   //XWindowEvent(mydpy1,win,ButtonPressMask|KeyPressMask|ExposureMask,&event);
   //switch(event.type)
    {case Expose:
	if(event.xexpose.count==0)
	 {XDrawImageString(mydpy1, win, gc2,x1,y1,text,strlen(text));
	  XDrawImageString(mydpy1, win, gc2,x2,y2,jatext,strlen(jatext));
	  XDrawRectangle(mydpy1,win,gc2,x2ul,y2ul,br,ho);
	  if(neintext)
	    {XDrawImageString(mydpy1,win,gc2,x3,y3,neintext,strlen(neintext));
	     XDrawRectangle(mydpy1,win,gc2,x3ul,y3ul,br,ho);
	 }  }
     CASE ButtonPress:
	x=event.xbutton.x; y=event.xbutton.y;
	if(x>x2ul && x<x2or && y>y2ul && y<y2or) {antwort=1; done=1;}
	else if(x>x3ul && x<x3or && y>y3ul && y<y3or) {antwort=0; done=1;}
     CASE MappingNotify: XRefreshKeyboardMapping(&event.xmapping);
     CASE KeyPress:
	i=XLookupString(&event.xkey,txt,10,&key,0);
	if(i==1 && *txt== *jatext) {antwort=1; done=1;}
	else if(neintext && i==1 && *txt== *neintext) {antwort=0; done=1;}
    }/* end switch */
  }/* Ende der Eventschlaufe */
 XFreeGC(mydpy1,gc2);
 XDestroyWindow(mydpy1,win);
 return antwort;
}

/*********************** Lashow-Erweiterung ******************************/
int hatlashowzeichen(char **spename,int anzahl)
{
 if(textflag)
   for(int i=0;i<anzahl;i++) if(**spename++ == '$') return 1;
 if(xytextflag)
	{if((ylabeltext!=NULL && *ylabeltext=='$')
	    ||(xlabeltext!=NULL && *xlabeltext=='$')) return 1;
	}
 return 0;
}

void lashow_definitionen(FILE *fp)
{
 FP(fp,"/bdef {bind def} bind def\n");
 FP(fp,"/hoch 16#5E def /tief 16#5F def /kauf 16#7B def /kzu 16#7D def\n");
 FP(fp,"/bslash 16#60 def /buf 1 string def /er false def\n");
 FP(fp,"/ghfont {mul rmoveto hfont setfont /er true def /HH 0.7 def} bdef\n");
 FP(fp,"/ho {gsave 0 H 0.5 ghfont} bdef /ti {gsave 0 H -0.3 ghfont} bdef\n");
 FP(fp,"/alte {currentpoint grestore currentpoint exch pop exch pop moveto\n");
 FP(fp,"	/HH 1 def} bdef\n");
 FP(fp,"/csho {buf 0 3 -1 roll put buf show} bdef\n");
 FP(fp,"/cshow {er{dup kauf eq{pop}{csho alte}ifelse /er false def}{csho}ifelse} bdef\n");
 FP(fp,"/xxshow {dup hoch eq{pop ho} {dup tief eq{pop ti}{dup kzu eq{pop alte}\n");
 FP(fp," {dup bslash eq{pop bflg{Symfont /bflg false}{nfont /bflg true}ifelse\n");
 FP(fp,"		def H HH mul scalefont setfont}\n");
 FP(fp," {cshow}ifelse}ifelse}ifelse}ifelse} bdef\n");
 FP(fp,"/Lashow {/H exch def /hfont currentfont 0.7 scalefont def\n");
 FP(fp,"\t/nfont currentfont 1 H div scalefont def /bflg true def /HH 1 def\n");
 FP(fp,"\t0 1 2 index length 1 sub{1 index exch get xxshow}for pop}bdef\n");
 FP(fp,"/zLashow {/H exch def m dup stringwidth pop 2 div neg 0 rmoveto H Lashow} def\n");
}

/******************* Vermittlerfunktionen zu Fortran *********************/
extern "C" {
void SHOW_TOTAL();
}
void SHOW_TOTAL() {show_total();}

/************************** Integral-Methode *****************************/
void integ_methode()
{
 lower_window();
 printf("Integralmethoden:\n");
 printf(" 0 = normal  (2 Grenzpunkte, Flche darunter wird ausgemessen)\n");
 printf(" 1 = fr y-Werte wird nur erster Grenzpunkt verwendet\n");
 integral_methode=intinputstr1("(%d) Auswahl:",integral_methode);
 raise_window();
}

/********************** neu ab Version 2.5 *************************/
/** Dinge fuer Dreidimensionale Darstellung **/
static double
//	alfa_3d=40.*GRAD,	//Winkel bei 3D-Darstellung
//	verkuerzung_3d=1.,	//Verkuerzungsfaktor in Zeit-Achse
	tfeld_3d[MAXCOLOR];	//Position der Spektren auf Zeitachse
static int
//	flag_3d=0,	//ist gesetzt wenn Werte eingegeben wurden
	farbig_3d=0;	//3D auch farbig darstellen

void eingabe_3d(int autoflag)
{
 int alfa,i;
 if(!autoflag)
  {lower_window();
   alfa=intinputstr1("(%d) Winkel in Grad:",int(alfa_3d/GRAD+0.5));
   alfa_3d=alfa*GRAD;
   verkuerzung_3d=doubinputstr1("(%lf) Perspektivische Verkuerzung:",
				verkuerzung_3d);
  }
 if(flag_3d==0) for(i=0;i<MAXCOLOR;i++) tfeld_3d[i]=i;
 if(!autoflag)
  {i=intinputstr1("(%d) Spektren auf Zeitachse neu positionieren ?",0);
   if(i!=0)
    for(i=0;i<nspektren;i++)
	tfeld_3d[i]=doubinputstr1("(%lf) tfeld[i]:",tfeld_3d[i]);
   farbig_3d=intinputstr1("(%d) Farbig darstellen ?",farbig_3d);
   raise_window();
  }
 flag_3d=1;
}

int tfeld_laden(double x1,double y1,double x2,double y2,
		 double *tfeld,double *dx,double *dy)
{
 double fx=(x2-x1)/25., fy=(y2-y1)/20.; //provi.
 double f=verkuerzung_3d;
 int i;
 if(!flag_3d) eingabe_3d();
 for(i=0;i<MAXCOLOR;i++)
	tfeld[i]=tfeld_3d[i];
 *dx=f*fx*cos(alfa_3d); *dy=f*fy*sin(alfa_3d);
 return farbig_3d;
}

class Plot3d
{
public:
 double x0,x,y,dx;
 double *f;
 int max;
 Plot3d() {f=NULL; max=0;}
};
static Plot3d p3d;

void plot3d_init(double x1,double y1,double x2,double y2,int max)
{
 if(max<4000) max=4000;
 if(p3d.max!=0) {delete p3d.f; p3d.max=0;}
 p3d.f=new double[max];
 p3d.max=max;
 p3d.x=p3d.x0=x1; p3d.y=y1;
 for(int i=0;i<max;i++) p3d.f[i]=y1;
 p3d.dx=(x2-x1)/max;
}

void plot3d(double x1,double y1,int pen)
{
 double x0,y0,dx,dy,x,y;
 int i,imax,j;
 if(pen==UP)
  {q2plot(x1,y1,pen);
  }
 else
  {x0=p3d.x; y0=p3d.y; dx=p3d.dx;
   imax=int((x1-x0)/dx+0.5);
   dy=(y1-y0)/imax;
   j=int((x0-p3d.x0)/dx+0.5);
   if(j<0) {printf("Fehler: j=%d imax=%d\n",j,imax);//test
	j=0;}
   for(i=0;i<=imax;i++,j++)
	{if(i==imax) {x=x1; y=y1;}
	 else {x=x0+i*dx; y=y0+i*dy;}
	 if(j>=p3d.max || y<p3d.f[j]) pen=UP;
	 else {p3d.f[j]=y; pen=DOWN;}
	 q2plot(x,y,pen);
	}
  }
 p3d.x=x1; p3d.y=y1;
}

/******************** ab Version 2.6 *********************/
#ifdef XTEKPLOT_1
void bewegung1() {bewegung(tek_mausx,tek_mausy);}
void klick1() {klick(1,tek_mausx,tek_mausy,tekplot_event.xbutton.button);}
void klick0() {klick(0,tek_mausx,tek_mausy,tekplot_event.xbutton.button);}
#endif
