/* solarspiegel2.cc			letzte Aenderung: 6.8.2025 */
#define VERSION "Version 0.0"
/*
Vereinfachte Version von solarspiegel.cc

History:
28.7.2025        Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <xtekplot1.h>
#include "vektor3dklasse.cc"

#define XMAX 1575
#define YMAX 1050
//Verhaeltnis: 1.5:1

#define TIEFE 24
//#define TIEFE 8

#define SCHWARZAUFWEISS //auskommentieren fuer weiss auf schwarz

#ifndef PI
#define PI 3.14159265358979323846
#endif
#define ZWEIPI (2.*PI)
#define PIHALBE (0.5*PI)
#ifndef GRAD
#define GRAD (PI/180.)
#endif

/************************* Vordeklarationen ***************************/
void funktion_zeichnen();
double parabel_funktion(double x);
double parabel_ableitung(double x);
double solar_funktion(double x);
double solar_ableitung(double x);
void solar_funktion_berechnen();

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/***************************** Kleinkram ******************************/
int fastgleich(double x,double y,double diff)
{		/* Teste ob x==y innerhalb der Genauigkeit diff */
 double d;
 if(diff<0.) diff= -diff;
 if(x>y) d=x-y; else d=y-x;
 return (d<diff);
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}
void m_load() {}//TODO
void m_save();
void m_solarfunktion(),m_refresh(),m_strahlpara(),m_animation();//Vordeklarationen

/************************* Hauptprogramm ******************************/
// Globale Variablen:
double xmin= -12.0, ymin= -1.0, xmax=12.0, ymax=15.0; //mit Verhaeltnis 1:1.5 und 1cm Sockel
double Radius=1.5, Hoehe=4.8; //Groesse und Position des Absorbers (Kreis)
double Radius2=1.4; //Fokus-Radius
double a2=1.0/(4*Hoehe),a1=0,a0=0; //Parameter fuer Parabel
double alfamax=10; //maximaler Winkel in Grad zwischen einkommender Strahl und Senkrecht
double alfaakt=0; //aktueller Winkel in Grad zwischen einkommender Strahl und Senkrecht
double strahl_deltax=1.0; //Abstand zwischen den gezeichneten Strahlen
int ableitflag=0; //1=Ableitung auch zeichnen
int numfunktion=1; //1=Parabel, 2=Solarfunktion
int numfunktion2=1; //1=Parabel, 2=Solarfunktion, 3=beide zeichnen
double foliendicke=0.02; //TODO
int folienflag=0; //1=foliendicke addieren, 2=foliendicke subtrahieren //TODO

bool innerhalb_kreis(double x,double y)
{
 y -= Hoehe;
 if(y>Radius || y < -Radius) return false;
 double x1 = sqrt(Radius*Radius-y*y);
 return (x<x1 && x> -x1);
}

void m_parametersetzen()
{
 requester_input(2,"Funktion zeichnen (1=Parabel, 2=Solarfunktion, 3=beide)","%d","%d\n",&numfunktion2,
		   "Ableitung auch zeichnen (0=nein, 1=ja)","%d","%d",&ableitflag
		 );
 if(numfunktion2<1) numfunktion2=1; else if(numfunktion2>3) numfunktion2=3;
 m_refresh();
}

void m_strahlpara()
{
 int ok;
 ok=requester_input(5,"alfa: Abweichung in Grad von Senkrecht","%f","%lf\n",&alfaakt,
		    "alfamax: Maximale Abweichung in Grad","%f","%lf\n",&alfamax,
		    "Abstand zwischen den Strahlen","%f","%lf\n",&strahl_deltax,
		    "Mit zusaetzlicher Foliendicke (0=nein, 1=ja)","%d","%d\n",&folienflag,
		    "Ableitung auch zeichnen (0=nein, 1=ja)","%d","%d",&ableitflag);
 if(ok) m_refresh();
}

void m_animation()
{
 int ok;
 static double dalfa=1,dt=0.25;
 ok=requester_input(4,"alfa Schrittweite in Grad fuer Animation","%f","%lf\n",&dalfa,
		    "Zeitschritt in Sekunden","%f","%lf\n",&dt,
		    "alfamax: Maximale Abweichung in Grad","%f","%lf\n",&alfamax,
		    "Abstand zwischen den Strahlen","%f","%lf\n",&strahl_deltax);
 if(ok)
  {
   for(alfaakt= -alfamax; alfaakt<=alfamax; alfaakt+=dalfa)
    {int nticks=int(dt*50+0.5);
     Delay(nticks);
     m_refresh();
    }
   alfaakt=alfamax;
  }
 m_refresh();
}

void m_parabel()
{
 int ok;
 double fokus=Hoehe, b2=1.0/(4*Hoehe), b1=a1, b0=a0;
 ok=requester_input(2,"Hoehe von Fokuspunkt (0=nein)","%f","%lf\n",&fokus,
		    "oder sonst bisheriges a2","%f","%lf",&b2);
 if(!ok) {m_refresh(); return;}
 if(fokus!=0) b2=1.0/(4*fokus);
 ok=requester_input(3,"a0","%f","%lf",&b0,
		      "a1","%f","%lf",&b1,
		      "a2","%f","%lf",&b2);
 if(ok)
  {a2=b2; a1=b1; a0=b0;
   numfunktion2 |= 1;
   m_refresh();
  }
 //Laenge der Parabel ausmessen:
 double laenge=0,x,y,dx=(xmax-xmin)/1024,dy;
 int i;
 for(i=0,x=xmin; i<1024; x+=dx,i++)
  {
   y = parabel_funktion(x);
   dy = parabel_funktion(x+dx) - y;
   double ds=sqrt(dx*dx+dy*dy);
   laenge += ds;
  }
 printf("Laenge der Parabel: %f cm\n",laenge);
}

void absorber_zeichnen()
{
 rgbcolor(0,0,255); //blau
 drawcircle(0,Hoehe,Radius,Radius);
}

double parabel_funktion(double x)
{
 double y = a2*x*x + a1*x + a0;//Parabel
 if(folienflag==1) y += foliendicke;
 else if(folienflag==2) y -= foliendicke;
 return y;
}

double parabel_ableitung(double x)
{
 double ystrich = a2*2*x + a1; //Ableitung der Parabel
 return ystrich;
}

double funktion(double x) //Funktion y(x)
{
 if(numfunktion==1) return parabel_funktion(x);
 return solar_funktion(x);
}

double ableitung(double x)
{
 if(numfunktion==1) return parabel_ableitung(x);
 return solar_ableitung(x);
}

void funktion_zeichnen()
{
 double x=xmin,dx=(xmax-xmin)/512.0;
 for(int i=0; x<=xmax; x+=dx, i++)
  {
   double y=funktion(x);
   if(y<ymin) y=ymin; else if(y>ymax) y=ymax;
   //printf("i=%d x=%g y=%g\n",i,x,y);//test
   if(i==0) plot(x,y,PENUP);
   else     plot(x,y,PENDOWN);
  }
}

void ableitung_zeichnen()
{
 double x=xmin,dx=(xmax-xmin)/512.0;
 for(int i=0; x<=xmax; x+=dx, i++)
  {
   double y=ableitung(x) + Hoehe;
   if(y<ymin) y=ymin; else if(y>ymax) y=ymax;
   //printf("i=%d x=%g y=%g\n",i,x,y);//test
   if(i==0) plot(x,y,PENUP);
   else     plot(x,y,PENDOWN);
  }
}

vektor spiegelung(vektor ra,double winkel) //ra=Stahl-Richtungsvektor
{// winkel: Neigung der Spiegelgeraden, Bereich -90 ... +90 Grad (aber in RAD)
 ra = vektordrehen(ra,-winkel); //im Uhrzeigersinn drehen
 ra.y = -ra.y; //Spiegelung: y-Richtung umkehren
 ra = vektordrehen(ra,winkel); //im Gegenuhrzeigersinn drehen
 return ra;
}

void strahl_zeichnen(double x0,double alfa)
{
 double x=x0,y=ymax,dx=0,dy=ymax/512.0;
 dx = dy*tan(alfa);
 int pen=PENUP;
 bool weiterflag=true;
 for(y-=dy,x+=dx; y>funktion(x); y-=dy,x+=dx)
  {
   if(x>=xmin)
    {
     if(innerhalb_kreis(x,y)) {weiterflag=false; break;}//fertig wenn Asorber getroffen
     plot(x,y,pen); pen=PENDOWN;
    }
  }
 if(weiterflag==false) return;
#define NEUE_FORMEL
#ifdef NEUE_FORMEL
 //Berechung reflektierter Strahl:
 y = funktion(x);
 vektor richtung(x-x0, y-ymax); //Richtung vom aktuellen Strahl
 int reflex=0; //Nummer der Mehrfachreflexion
 do { //mehrfache Reflexionen beruecksichtigen
 y = funktion(x);
 double steigung=ableitung(x);
 double winkel=atan(steigung);
 richtung = spiegelung(richtung,winkel);
 dx=xmax/512; if(richtung.x<0) dx= -dx;
 double ax = abs(richtung.x);
 double ay = abs(richtung.y);
 if(ay > 4*ax) //wenn steiler Strahl, dann dx verkleinern
  {if(ax==0)
    {dy=fabs(dx); dx=0;}//Spezialfall senkrechter Strahl
   else
    {dx *= ax/ay;  dy = dx*richtung.y/richtung.x;}
  }
 else {dy = dx*richtung.y/richtung.x;}
 if(reflex==0) rgbcolor(255,0,0);
 else if(reflex==1) rgbcolor(200,200,0);//dunkles gelb
 else if(reflex==2) rgbcolor(150,255,0);//helles gruen
 else rgbcolor(255,0,255);//helles violet
 weiterflag=false;
 plot(x,y,PENUP);
 for(x+=dx,y+=dy; x>xmin && x<xmax; x+=dx,y+=dy)
  {
   if(innerhalb_kreis(x,y)) {weiterflag=false; break;}//fertig wenn Absorber getroffen wird
   if(y <= funktion(x)) {weiterflag=true; break;}
   if(y > ymax*0.95) {weiterflag=false; break;}
   plot(x,y,PENDOWN);
  }
 reflex++;
 } while(weiterflag);
 rgbcolor(255,0,0); //naechster Strah wieder rot

#else //sonst alte Formel
 
 //Berechung reflektierter Strahl:
 double ar,br; //Steigung und Achsenabschnitt vom reflektierten Strahl
 int vorzeichen=1;
 double x1,w3,beta;
 if(x>=0) {x1=x; vorzeichen=1;}
 else     {x1= -x; vorzeichen= -1;}
 double steigung=ableitung(x1);
 if(steigung>=0) beta = atan(1.0/steigung);
 else            beta = atan(-1.0/steigung);
 double gamma=2*beta;
 w3=gamma-90*GRAD;
 if(steigung>=0) w3 += alfa*vorzeichen;
 else            w3 -= alfa*vorzeichen;
 dx=xmax/512;
 if(steigung>=0) {ar = -tan(w3);} //Steigung vom reflektierten Strahl
 else            {ar = tan(w3); dx= -dx;}
 br = funktion(x1) - ar*x1; //Achsenabschnitt vom reflektierten Strahl
 //printf("br= %f  ar= %f\n",br,ar);//test
 for(x=x1, x-=dx; x>xmin && x<xmax; x-=dx)
  {
   y=br+ar*x;
   if(innerhalb_kreis(x,y)) {weiterflag=false; break;}//fertig wenn Absorber getroffen wird
   //if(y<=funktion(x)) {weiterflag=true; break;}
   double ddy=(ymax-ymin)/50;//test
   if(y<funktion(x)-ddy) {weiterflag=true; break;}//test
   if(y>ymax*0.95) {weiterflag=false; break;}//TODO
   plot(vorzeichen*x,y,PENDOWN);
  }
 if(weiterflag && x>=0)
  {//weitere Reflexion:
   //printf("x=%f vorzeichen=%d ar=%f\n",x,vorzeichen,ar);//test
   rgbcolor(100,255,0); //gelb oder gruen
   x1=x;
   steigung=ableitung(x1);
   if(steigung>=0)
    {double beta = atan(1.0/steigung);
     double gamma=2*beta;
     double w3=gamma-90*GRAD;
     if(ar<0) alfa = vorzeichen*atan(-1.0/ar);
     else     alfa = -vorzeichen*atan(1.0/ar);
     w3 += alfa*vorzeichen;
     ar = -tan(w3); //Steigung vom reflektierten Strahl
    }
   else
    {double beta = atan(ar) + atan(-steigung);
     double w3 = atan(-steigung)+beta;
     if(w3<=90*GRAD) ar = -tan(w3); //Steigung vom reflektierten Strahl
     else            ar = tan(w3-90*GRAD);
    }
   br = funktion(x1) - ar*x1; //Achsenabschnitt vom reflektierten Strahl
   for(x=x1, x-=dx; x>xmin && x<xmax; x-=dx)
    {
     y=br+ar*x;
     if(innerhalb_kreis(x,y)) break;//fertig wenn Absorber getroffen wird
     if(y<funktion(x)-dy || y>ymax*0.95) break;
     plot(vorzeichen*x,y,PENDOWN);
    }
   rgbcolor(255,0,0); //rot
  }
#endif
}

void strahlen_zeichnen()
{
 double deltax=strahl_deltax, alfa=alfaakt*GRAD;
 rgbcolor(255,0,0); //rot
 double xstart = xmin - tan(alfa)*(ymax-funktion(xmin));
 for(double x=xstart; x<=xmax; x+=deltax)
  {
   strahl_zeichnen(x,alfa);
  }
}

void farbe_schwarzweiss()
{
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss:
 if(TIEFE==24) rgbcolor(0x00,0x00,0x00); else color(0);
#else
 //weiss auf schwarz:
 if(TIEFE==24) rgbcolor(0xFF,0xFF,0xFF); else color(1);
#endif
}

void alles_zeichnen()
{
 drawbox(xmin,ymin,xmax,ymax); // Rahmen zeichnen
 rgbcolor(0,255,255); //Achsen blaugruen
 plot(0,ymin,PENUP); plot(0,ymax,PENDOWN); // y-Achse zeichnen
 plot(xmin,0,PENUP); plot(xmax,0,PENDOWN); // x-Achse zeichnen
 farbe_schwarzweiss();
 numfunktion=numfunktion2;
 if(numfunktion2==1 || numfunktion2==2) funktion_zeichnen();
 else
  {
   numfunktion=2; funktion_zeichnen(); //Solarfunktion schwarz oder weiss zeichnen
   numfunktion=1; rgbcolor(0,0,255); funktion_zeichnen(); //Parabel blau zeichnen
  }
 absorber_zeichnen();
 if(ableitflag) {rgbcolor(0,255,0); ableitung_zeichnen();}
 strahlen_zeichnen();
}

void m_refresh()
{
 inital_new();
 // Bildschirm loeschen:
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss:
 if(TIEFE==24) {rgbcolor(255,255,255); fillbox(xmin,ymin,xmax,ymax); rgbcolor(0,0,0);}
 else          {color(1); fillbox(xmin,ymin,xmax,ymax); color(0);}
#else
 //weiss auf schwarz:
 if(TIEFE==24) {rgbcolor(0,0,0); fillbox(xmin,ymin,xmax,ymax); rgbcolor(255,255,255);}
 else          {color(0); fillbox(xmin,ymin,xmax,ymax); color(1);}
#endif
 
 alles_zeichnen();
 term_refresh();
}

int main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 quellname[0]=zielname[0]=0;
 //FILE *fp1,*fp2;
 int i,j,c; //maxcol,col=0;
 int breite,hoehe,tiefe,visklasse;
 if(argc<=0)
   ;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("solarspiegel  %s\n",VERSION);
	 printf("Anwendung: solarspiegel [Quelle] [Ziel]\n");
	 exit(0);
	}
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 //maxcol=(1<<TIEFE);
 setsize(breite,hoehe,tiefe);
 setmenu(3,"File",    "Parameter",          "Strahlen");
 setmenu(3,"Load ...","Funktion setzen ...","StrahlParameter ...",m_load,m_parametersetzen,m_strahlpara);
 setmenu(3,"Save ...","Parabel anpassen ...","Animation ...",m_save,m_parabel,m_animation);
 setmenu(2,"Exit",    "Solarfunktion ...",menu_exit,m_solarfunktion);
 setmenu(2,NULL,      "refresh",NULL, m_refresh);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 waitBOF();//test
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif

 alles_zeichnen();
 term_refresh();

 while(exitflag==0 && waitmenu(1)==0)
  {}// auf Benutzereingaben warten

 term_exit();
 return 0;
}/* ende von main */

/*********************** Nummerische Funktion *************************/
const int MAXNUM=1024;
double yfeld[MAXNUM+1]; //Werte der Funktion
double ystrich[MAXNUM+1]; //Werte der Ableitung
double yfeld2[MAXNUM+1]; //Funktion mit Foliendicke zusaetztlich
double ystrich2[MAXNUM+1]; //Ableitung mit Foliendicke zusaetztlich
int berechnetflag=0; //gesetzt wenn Funktion zum ersten Mal berechnet

void m_solarfunktion() //Funktion mit Nummerischer Integration berechnen
{
 int ok;
 ok=requester_input(6,"Radius des Absorbers in cm","%f","%lf",&Radius,
		    "Radius von Strahlfokus","%f","%lf",&Radius2,
		    "Absorber-Hoehe (Mittelpunkt)","%f","%lf\n",&Hoehe,
		    "alfamax: Maximale Strahl-Abweichung in Grad","%f","%lf\n",&alfamax,
		    "Foliendicke (beim 3D-Druck beruecksichtigen)","%f","%lf\n",&foliendicke,
		    "Ableitung auch zeichnen (0=nein, 1=ja)","%d","%d",&ableitflag);
 if(ok)
  {
   numfunktion2=numfunktion=2;
   solar_funktion_berechnen();
   m_refresh();
  }
}

void solar_funktion_berechnen()
{
 double x,y,ys, dy=0, dx=(xmax-xmin)/MAXNUM, alfa0=alfamax*GRAD;
 for(int i=0;i<=MAXNUM;i++) {yfeld[i]=ystrich[i]=0;}//test //TODO
 int i = int((Radius2-xmin)/dx+0.5);
 printf("Testpunkt numintegral2()\n");//test
 for(x=Radius2,y=0; i>=MAXNUM/2; x-=dx,y+=dy,i--)
  {// Bereich1: x <= Radius2
   if(y>=Hoehe-Radius2) {y=Hoehe-Radius2; dy=0; ys=0;}
   else
    {double Hminusy=Hoehe-y;
     double c=sqrt(x*x+Hminusy*Hminusy);
     double w1=atan(x/Hminusy);
     double w2=asin(Radius2/c);
     double alfa=w2-w1;
     ys=tan(alfa);  dy=ys*dx;
    }
   ystrich[i] = -ys;  yfeld[i] = y;
   //printf("Teil1: i=%d x=%f y=%f ys=%f\n",i,x,y,ys);//test
  }
 i = int((Radius2-xmin)/dx+0.5);
 for(x=Radius2,y=0; x<=xmax; x+=dx,y+=dy,i++)
  {// Bereich2: alfa1 < alfa0 (Strahlen mit alfa0 treffen direkt auf Absorber)
   double Hminusy=Hoehe-y;
   double c=sqrt(x*x+Hminusy*Hminusy);
   double w1=atan(x/Hminusy);
   double w2=asin(Radius2/c);
   double alfa=w1-w2; //alfa==alfa1
   //printf("w1=%f w2=%f alfa=%f alfa0=%f\n",w1/GRAD,w2/GRAD,alfa/GRAD,alfa0/GRAD);//test
   if(alfa>=alfa0) break;
   ys=tan(alfa);  dy=ys*dx;
   ystrich[i] = ys;  yfeld[i] = y;
   //printf("Teil2: i=%d x=%f y=%f ys=%f\n",i,x,y,ys);//test
  }
 for(; x<=xmax; x+=dx,y+=dy,i++)
  {// Bereich3: Strahlen treffen nicht direkt auf Absorber
   if(i>MAXNUM) {printf("Fehler: i=%d MAXNUM=%d\n",i,MAXNUM); break;}//test
   double Hminusy=Hoehe-y;
   double c=sqrt(x*x+Hminusy*Hminusy);
   double w1=atan(Hminusy/x);
   double w2=asin(Radius2/c);
   double w3=90*GRAD-w1-w2-alfa0;
   double alfa=90*GRAD-w1-w2-w3/2;
   ys=tan(alfa);  dy=ys*dx;
   ystrich[i] = ys;  yfeld[i] = y;
   //printf("Teil3: i=%d x=%f y=%f ys=%f\n",i,x,y,ys);//test
  }
 for(;i<=MAXNUM; y+=dy,i++)
  {
   ystrich[i] = ys;  yfeld[i] = y;
  }
 int j;
 for(j=MAXNUM/2-1,i=MAXNUM/2+1; j>=0; i++,j--)
  {
   yfeld[j] = yfeld[i];
   ystrich[j] = -ystrich[i];
  }
 //Laenge der Kurve ausmessen:
 double laenge=0;
 for(i=0,x=xmin; i<MAXNUM; x+=dx,i++)
  {
   dy = ystrich[i]*dx;
   double ds=sqrt(dx*dx+dy*dy);
   laenge += ds;
  }
 printf("Laenge der Kurve: %f cm\n",laenge);
 berechnetflag=1;
 //Kurve mit zusaetzlicher Foliendicke in yfeld2[] speichern:
 double dicke=foliendicke;
 for(i=0; i<MAXNUM; i++)
  {
   y=yfeld[i];
   dy=yfeld[i+1]-y;
   //double dtest=ystrich[i]*dx;
   //if(!fastgleich(dy,dtest,1e-3)) printf("dy=%f ystrich[%d]*dx=%f\n",dy,i,dtest);//test
   double c=sqrt(dy*dy+dx*dx);
   yfeld2[i] = y + foliendicke*c/dx;
  }
 yfeld2[MAXNUM]=yfeld[MAXNUM]+dicke;
 for(i=0;i<MAXNUM;i++)
  {
   ystrich2[i] = (yfeld2[i+1]-yfeld2[i])/dx;
  }
 ystrich2[MAXNUM] = ystrich2[MAXNUM-1];
}

double solar_funktion(double x)
{
 if(berechnetflag==0) solar_funktion_berechnen();
 int i = int(MAXNUM*(x-xmin)/(xmax-xmin)+0.5);
 if(i<0) i=0; else if(i>MAXNUM) i=MAXNUM;
 if(folienflag==1) return yfeld2[i];
 else if(folienflag==2) return yfeld[i]-foliendicke;
 return yfeld[i];
}

double solar_ableitung(double x)
{
 if(berechnetflag==0) solar_funktion_berechnen();
 int i = int(MAXNUM*(x-xmin)/(xmax-xmin)+0.5);
 if(i<0) i=0; else if(i>MAXNUM) i=MAXNUM;
 if(folienflag) return ystrich2[i];
 return ystrich[i];
}

/***************************** 3D-Drucker *****************************/
// aus stlplotter.cc kopiert
//#include "vektor3dklasse.cc" //schon weiter oben

#define SCHUESSEL 1
#define ROHR      2
int stl_typ=0;
double stl_radius=0, stl_rohrlaenge=0;

double f3d(double x,double y) //Werte in cm
{
 double z,r;
 //z=x+y; //Example1: Schiefe Ebene
 //z=x*x+y*y; //Example2: Parabolspiegel
 if(stl_typ==SCHUESSEL)
  {// fuer Schuessel
   r=sqrt(x*x+y*y);
   if(r>xmax) r=xmax;
   z=funktion(r);
  }
 else
  {// fuer Rohr
   z=funktion(x);
  }
 return z;
}

double scalx=10; //Scaling factor to get millimeters in x-Axis
double scaly=10; //Scaling factor to get millimeters in y-Axis
double scalz=10; //Scaling factor to get millimeters in z-Axis

double gxmin = -15.0, gxmax = 15.0; //Limits for plotted area
double gymin = -15.0, gymax = 15.0; //Limits for plotted area

int nmax=256; //Number of data point in x- and y-axis

double zsocle=5; //Thickness of baseplate in millimeters

void stlplot(FILE *fp); //Vordeklaration

void dreieck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3)
{
 Vektor3d v1,v2,normalenvektor;
 v1=p2-p1;
 v2=p3-p2;
 normalenvektor=vektorkreuzprodukt(v1,v2);
 fprintf(fp," facet normal %.3f %.3f %.3f\n", normalenvektor.x, normalenvektor.y, normalenvektor.z);
 fprintf(fp,"  outer loop\n");
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x*scalx, p1.y*scaly, p1.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p2.x*scalx, p2.y*scaly, p2.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x*scalx, p3.y*scaly, p3.z*scalz);
 fprintf(fp,"  endloop\n");
 fprintf(fp," endfacet\n");
}

void viereck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3,Vektor3d& p4)
{
 Vektor3d v1,v2,normalenvektor;
 v1=p2-p1;
 v2=p3-p2;
 normalenvektor=vektorkreuzprodukt(v1,v2);
 fprintf(fp," facet normal %.3f %.3f %.3f\n", normalenvektor.x, normalenvektor.y, normalenvektor.z);
 fprintf(fp,"  outer loop\n");
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x*scalx, p1.y*scaly, p1.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p2.x*scalx, p2.y*scaly, p2.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x*scalx, p3.y*scaly, p3.z*scalz);
 fprintf(fp,"  endloop\n");
 fprintf(fp,"  outer loop\n");
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x*scalx, p1.y*scaly, p1.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x*scalx, p3.y*scaly, p3.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p4.x*scalx, p4.y*scaly, p4.z*scalz);
 fprintf(fp,"  endloop\n");
 fprintf(fp," endfacet\n");
}

void zweidreiecke(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3,Vektor3d& p4)
{
 dreieck(fp,p1,p2,p3);
 dreieck(fp,p1,p3,p4);
}

void stlplot(FILE *fp)
{
 int jx,jy;
 double x,y,dx,dy,zmin=0;
 Vektor3d p1,p2,p3,p4,q1,q2,q3,q4;
 dy=(gymax-gymin)/nmax;
 dx=(gxmax-gxmin)/nmax;
 fprintf(fp,"solid unnamed\n");
 //Flaeche der Funktion:
 for(jy=0,y=gymin;jy<nmax;jy++,y+=dy)
  {
   for(jx=0,x=gxmin;jx<nmax;jx++,x+=dx)
    {
     p1.x=x;    p1.y=y;    p1.z=f3d(x,y);
     p2.x=x+dx; p2.y=y;    p2.z=f3d(p2.x,p2.y);
     p3.x=x+dx; p3.y=y+dy; p3.z=f3d(p3.x,p3.y);
     p4.x=x;    p4.y=y+dy; p4.z=f3d(p4.x,p4.y);
     zweidreiecke(fp,p1,p2,p3,p4);
     if(p1.z<zmin) zmin=p1.z;
     if(p2.z<zmin) zmin=p2.z;
     if(p3.z<zmin) zmin=p3.z;
     if(p4.z<zmin) zmin=p4.z;
    }
  }
 zmin -= zsocle/scalz;
 //Grundflaeche:
 p1.x=gxmin; p1.y=gymin; p1.z=zmin;
 p2.x=gxmax; p2.y=gymin; p2.z=zmin;
 p3.x=gxmax; p3.y=gymax; p3.z=zmin;
 p4.x=gxmin; p4.y=gymax; p4.z=zmin;
 viereck(fp,p1,p4,p3,p2);
 //vordere Seitenflache in x-z-Ebene:
 y=gymin;
 for(jx=0,x=gxmin;jx<nmax;jx++,x+=dx)
  {
   q1.x=x;    q1.y=y; q1.z=zmin;
   q2.x=x+dx; q2.y=y; q2.z=zmin;
   q3.x=x+dx; q3.y=y; q3.z=f3d(q3.x,q3.y);
   q4.x=x;    q4.y=y; q4.z=f3d(q4.x,q4.y);
   viereck(fp,q1,q2,q3,q4);
  }
 //hintere Seitenflache in x-z-Ebene:
 y=gymax;
 for(jx=0,x=gxmin;jx<nmax;jx++,x+=dx)
  {
   q1.x=x;    q1.y=y; q1.z=zmin;
   q2.x=x+dx; q2.y=y; q2.z=zmin;
   q3.x=x+dx; q3.y=y; q3.z=f3d(q3.x,q3.y);
   q4.x=x;    q4.y=y; q4.z=f3d(q4.x,q4.y);
   viereck(fp,q1,q4,q3,q2);
  }
 //vordere Seitenflache in y-z-Ebene:
 x=gxmax;
 for(jy=0,y=gymin;jy<nmax;jy++,y+=dy)
  {
   q1.x=x; q1.y=y;    q1.z=zmin;
   q2.x=x; q2.y=y+dy; q2.z=zmin;
   q3.x=x; q3.y=y+dy; q3.z=f3d(q3.x,q3.y);
   q4.x=x; q4.y=y;    q4.z=f3d(q4.x,q4.y);
   viereck(fp,q1,q2,q3,q4);
  }
 //hintere Seitenflache in y-z-Ebene:
 x=gxmin;
 for(jy=0,y=gymin;jy<nmax;jy++,y+=dy)
  {
   q1.x=x; q1.y=y;    q1.z=zmin;
   q2.x=x; q2.y=y+dy; q2.z=zmin;
   q3.x=x; q3.y=y+dy; q3.z=f3d(q3.x,q3.y);
   q4.x=x; q4.y=y;    q4.z=f3d(q4.x,q4.y);
   viereck(fp,q1,q4,q3,q2);
  }
 fprintf(fp,"endsolid unnamed\n");
}
/*** fertig aus stlplotter.cc kopiertes. ***/

void m_save()
{
 int ok; double radius=0,rohrlaenge=0,sockel=zsocle/10;
 char filename[200]; strcpy(filename,"neu.stl");
 ok=requester_input(4,"Schuessel-Radius in cm","%f","%lf\n",&radius,
		      "oder Rohr-Laenge in cm","%f","%lf\n",&rohrlaenge,
		      "Sockeldicke in cm","%f","%lf\n",&sockel,
		      "Ausgabedatei","%s","%s",filename);
 if(ok)
  {stl_radius=radius; stl_rohrlaenge=rohrlaenge;
   zsocle = sockel*10; //Sockel in mm
   if(radius!=0)
    {stl_typ=SCHUESSEL; gxmin=gymin= -radius; gxmax=gymax=radius;
     printf("Erstellung einer Schuessel mit Radius=%f\n",radius);
    }
   else if(rohrlaenge!=0)
    {stl_typ=ROHR; gxmin=xmin; gxmax=xmax; gymax=rohrlaenge/2; gymin= -gymax;
     printf("Erstellung eines Rohrspiegels fuer Laenge=%f\n",rohrlaenge);
    }
   printf("erzeugen einer STL-Datei %s\n",filename);//test
   FILE *fp2;
   fp2=fopen(filename,"w");
   if(fp2==NULL) {printf("couldnt create '%s'\n",filename); m_refresh(); return;}
   if(folienflag==1) folienflag=2;
   stlplot(fp2);
   if(folienflag==2) folienflag=1;
   fclose(fp2);
  }
 m_refresh();
}
