/* solarspiegel.cc			letzte Aenderung: 1.8.2025 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Eine Funktion y(x) zeichnen

History:
28.7.2025        Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <xtekplot1.h>

#define XMAX 1575     //1250
#define YMAX 1050     //1000
//Verhaeltnis: 1.5:1  //vorher 1.25:1
#define TIEFE 24
//#define TIEFE 8

#define SCHWARZAUFWEISS //auskommentieren fuer weiss auf schwarz

#ifndef PI
#define PI 3.14159265358979323846
#endif
#define ZWEIPI (2.*PI)
#define PIHALBE (0.5*PI)
#ifndef GRAD
#define GRAD (PI/180.)
#endif

/************************* Vordeklarationen ***************************/
void funktion_zeichnen();
double funktion(double x);
double yfunktion(double x);
double yableitung(double x);
double yfunktion2(double x);
double yableitung2(double x);
void numintegral2();

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}
void m_load() {}//TODO
void m_save() {}//TODO
void m_numintegral(),m_refresh(),m_strahlpara();//Vordeklaration

/************************* Hauptprogramm ******************************/
// Globale Variablen:
//double xmin= -20.0, ymin=0, xmax=20.0, ymax=32.0; //mit Verhaeltnis 1:1.25
double xmin= -12.0, ymin= -1.0, xmax=12.0, ymax=15.0; //mit Verhaeltnis 1:1.5 und 1cm Sockel
double Radius=1.1, Hoehe=4.8; //Groesse und Position des Absorbers (Kreis)
double Radius2=1.0; //Fokus-Radius
double a5=0.0, a4=0.0;
//double a3=0.0, a2=0.065, a1= 0.0, a0=0.0; //Polynomparameter fuer einfache Parabel
double a3=0.002, a2=0.05, a1= -0.2, a0=0.5; //Polynomparameter
double alfamax=10; //maximaler Winkel in Grad zwischen einkommender Strahl und Senkrecht
double alfaakt=0; //aktueller Winkel in Grad zwischen einkommender Strahl und Senkrecht
double strahl_deltax=1.0; //Abstand zwischen den gezeichneten Strahlen
int biparabel=0;//TODO
int ableitflag=1; //1=Ableitung auch zeichnen
int numfunktion=0; //gesetzt wenn Nummerische Funktion verwendet werden soll

bool innerhalb_kreis(double x,double y)
{
 y -= Hoehe;
 if(y>Radius || y < -Radius) return false;
 double x1 = sqrt(Radius*Radius-y*y);
 return (x<x1 && x> -x1);
}

void m_parametersetzen()
{
 int ok;
 ok=requester_input(8,"a0","%f","%lf",&a0,
		      "a1","%f","%lf",&a1,
		      "a2","%f","%lf\n",&a2,
		      "a3","%f","%lf",&a3,
		      "a4","%f","%lf",&a4,
		      "a5","%f","%lf\n",&a5,
		    "Biparabel (0=aus, 1=ein)","%d","%d\n",&biparabel,
		    "Ableitung auch zeichnen (0=nein, 1=ja)","%d","%d",&ableitflag);
 if(ok) m_refresh();
}

void m_strahlpara()
{
 int ok;
 ok=requester_input(4,"alfa: Abweichung in Grad von Senkrecht","%f","%lf\n",&alfaakt,
		    "alfamax: Maximale Abweichung in Grad","%f","%lf\n",&alfamax,
		    "Abstand zwischen den Strahlen","%f","%lf\n",&strahl_deltax,
		    "Ableitung auch zeichnen (0=nein, 1=ja)","%d","%d",&ableitflag);
 if(ok) m_refresh();
}

void m_parabel()
{
 int ok;
 double b2=1.0/(4*Hoehe), b1=0, b0=0;
 ok=requester_input(3,"a0","%f","%lf",&b0,
		      "a1","%f","%lf",&b1,
		      "a2","%f","%lf",&b2);
 if(ok)
  {a2=b2; a1=b1; a0=b0;
   a3=a4=a5=0;
   numfunktion=0;
   m_refresh();
  }
 //test: Laenge der Kurve ausmessen:
 double laenge=0,x,y,dx=(xmax-xmin)/1024,dy;
 int i;
 for(i=0,x=xmin; i<1024; x+=dx,i++)
  {
   y = funktion(x);
   dy = funktion(x+dx) - y;
   double ds=sqrt(dx*dx+dy*dy);
   laenge += ds;
  }
 printf("Laenge der Parabel: %f cm\n",laenge);
}

void m_polynom3()
{
 int ok;
 double b3=0.0005, b2=0.055, b1= -0.2, b0=0.5;
 ok=requester_input(4,"a0","%f","%lf",&b0,
		      "a1","%f","%lf",&b1,
		      "a2","%f","%lf",&b2,
		      "a3","%f","%lf",&b3);
 if(ok)
  {a3=b3; a2=b2; a1=b1; a0=b0;
   a4=a5=0;
   numfunktion=0;
   m_refresh();
  }
}

void m_polynom5()
{
 int ok;
 double b5= -0.000002, b4=0.000, b3=0.003, b2=0.02, b1= 0.01, b0=0.5;
 ok=requester_input(6,"a0","%f","%lf",&b0,
		      "a1","%f","%lf",&b1,
		      "a2","%f","%lf\n",&b2,
		      "a3","%f","%lf",&b3,
		      "a4","%f","%lf",&b4,
		      "a5","%f","%lf",&b5);
 if(ok)
  {a5=b5; a4=b4; a3=b3; a2=b2; a1=b1; a0=b0;
   numfunktion=0;
   m_refresh();
  }
}

void absorber_zeichnen()
{
 rgbcolor(0,0,255); //blau
 drawcircle(0,Hoehe,Radius,Radius);
 //rgbcolor(0,0,0); //schwarz //TODO
}

double funktion(double x) //Funktion y(x)
{
 if(numfunktion==1) return yfunktion(x);
 if(numfunktion==2) return yfunktion2(x);
 if(x<0) x = -x; //Spiegelbildlich auf negativer x-Achse
 if(biparabel!=0) x-=Radius;//TODO
 double x2=x*x, x3=x2*x, x4=x2*x2, x5=x4*x;
 double y = a5*x5 + a4*x4 + a3*x3 + a2*x2 + a1*x + a0; //Polynomfunktion
 return y;
}

double ableitung(double x)
{
 if(numfunktion==1) return yableitung(x);
 if(numfunktion==2) return yableitung2(x);
 int vorzeichen=1;
 if(x<0) {vorzeichen= -1; x = -x;}
 if(biparabel!=0) {x -= Radius*vorzeichen;}//TODO
 double x2=x*x, x3=x2*x, x4=x2*x2;
 double ystrich = (a5*5*x4 + a4*4*x3 + a3*3*x2 + a2*2*x + a1)*vorzeichen;
 return ystrich;
}

void funktion_zeichnen()
{
 double x=xmin,dx=(xmax-xmin)/512.0;
 for(int i=0; x<=xmax; x+=dx, i++)
  {
   double y=funktion(x);
   if(y<ymin) y=ymin; else if(y>ymax) y=ymax;
   //printf("i=%d x=%g y=%g\n",i,x,y);//test
   if(i==0) plot(x,y,PENUP);
   else     plot(x,y,PENDOWN);
  }
}

void ableitung_zeichnen()
{
 double x=xmin,dx=(xmax-xmin)/512.0;
 for(int i=0; x<=xmax; x+=dx, i++)
  {
   double y=ableitung(x) + Hoehe;
   if(y<ymin) y=ymin; else if(y>ymax) y=ymax;
   //printf("i=%d x=%g y=%g\n",i,x,y);//test
   if(i==0) plot(x,y,PENUP);
   else     plot(x,y,PENDOWN);
  }
}

void strahl_zeichnen(double x0,double alfa)
{
 double x=x0,y=ymax,dx=0,dy=ymax/512.0;
 dx = dy*tan(alfa);
 plot(x,y,PENUP);
 bool weiterflag=true;
 for(y-=dy,x+=dx; y>funktion(x); y-=dy,x+=dx)
  {
   if(innerhalb_kreis(x,y)) {weiterflag=false; break;}//fertig wenn Asorber getroffen
   plot(x,y,PENDOWN);
  }
 if(weiterflag==false) return;
 //Berechung reflektierter Strahl:
 int vorzeichen;
 double x1,w3,beta;
 if(x>=0) {x1=x; vorzeichen=1;}
 else     {x1= -x; vorzeichen= -1;}
 double steigung=ableitung(x1);
 if(steigung>=0) beta = atan(1.0/steigung);
 else            beta = atan(-1.0/steigung);
 double gamma=2*beta;
 w3=gamma-90*GRAD;
 if(steigung>=0) w3 += alfa*vorzeichen;
 else            w3 -= alfa*vorzeichen;
 double ar,br;
 dx=xmax/512;
 if(steigung>=0) {ar = -tan(w3);} //Steigung vom reflektierten Strahl
 else            {ar = tan(w3); dx= -dx;}
 br = funktion(x1) - ar*x1; //Achsenabschnitt vom reflektierten Strahl
 //printf("br= %f  ar= %f\n",br,ar);//test
 for(x=x1, x-=dx; x>xmin && x<xmax; x-=dx)
  {
   y=br+ar*x;
   if(innerhalb_kreis(x,y)) {weiterflag=false; break;}//fertig wenn Absorber getroffen wird
   if(y<=funktion(x)) {weiterflag=true; break;}
   if(y>ymax*0.95) {weiterflag=false; break;}//TODO
   plot(vorzeichen*x,y,PENDOWN);
  }
 if(weiterflag && x>=0)
  {//weitere Reflexion:
   //printf("x=%f vorzeichen=%d ar=%f\n",x,vorzeichen,ar);//test
   rgbcolor(100,255,0); //gelb oder gruen
   x1=x;
   steigung=ableitung(x1);
   if(steigung>=0)
    {beta = atan(1.0/steigung);
     gamma=2*beta;
     w3=gamma-90*GRAD;
     if(ar<0) alfa = vorzeichen*atan(-1.0/ar);
     else     alfa = -vorzeichen*atan(1.0/ar);
     w3 += alfa*vorzeichen;
     ar = -tan(w3); //Steigung vom reflektierten Strahl
    }
   else
    {beta = atan(ar) + atan(-steigung);
     w3 = atan(-steigung)+beta;
     if(w3<=90*GRAD) ar = -tan(w3);
     else            ar = tan(w3-90*GRAD);
    }
   br = funktion(x1) - ar*x1; //Achsenabschnitt vom reflektierten Strahl
   for(x=x1, x-=dx; x>xmin && x<xmax; x-=dx)
    {
     y=br+ar*x;
     if(innerhalb_kreis(x,y)) break;//fertig wenn Absorber getroffen wird
     if(y<funktion(x)-dy || y>ymax*0.95) break;
     plot(vorzeichen*x,y,PENDOWN);
    }
   rgbcolor(255,0,0); //rot
  }
}

void strahlen_zeichnen()
{
 double deltax=strahl_deltax, alfa=alfaakt*GRAD;
 rgbcolor(255,0,0); //rot
 for(double x=xmin-1.95*deltax; x<xmax; x+=deltax)
  {
   strahl_zeichnen(x,alfa);
  }
 //rgbcolor(0,0,0); //schwarz //TODO
}

void alles_zeichnen()
{
 drawbox(xmin,ymin,xmax,ymax); // Rahmen zeichnen
 funktion_zeichnen();
 rgbcolor(0,255,255); //blaugruen
 plot(0,ymin,PENUP); plot(0,ymax,PENDOWN); // y-Achse zeichnen
 plot(xmin,0,PENUP); plot(xmax,0,PENDOWN); // x-Achse zeichnen
 absorber_zeichnen();
 if(ableitflag) {rgbcolor(0,255,0); ableitung_zeichnen();}
 strahlen_zeichnen();
}

void m_refresh()
{
 inital_new();
 // Bildschirm loeschen:
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss:
 if(TIEFE==24) {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else          {screenclear(1); color(0);}
#else
 //weiss auf schwarz:
 if(TIEFE==24) {screenclear(0); rgbcolor(0xFF,0xFF,0xFF);}
 else          {screenclear(0); color(1);}
#endif
 
 alles_zeichnen();
 term_refresh();
}

int main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 quellname[0]=zielname[0]=0;
 //FILE *fp1,*fp2;
 int i,j,c; //maxcol,col=0;
 int breite,hoehe,tiefe,visklasse;
 if(argc<=0)
   ;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("solarspiegel  %s\n",VERSION);
	 printf("Anwendung: solarspiegel [Quelle] [Ziel]\n");
	 exit(0);
	}
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 //maxcol=(1<<TIEFE);
 setsize(breite,hoehe,tiefe);
 setmenu(3,"File",    "Parameter",        "Strahlen");
 setmenu(3,"Load ...","setzen ...",       "StrahlParameter ...",m_load,m_parametersetzen,m_strahlpara);
 setmenu(2,"Save ...","Parabel ...",m_save,m_parabel);
 setmenu(2,"Exit",    "Polynom3.Grad ...",menu_exit,m_polynom3);
 setmenu(2,NULL,      "Polynom5.Grad ...",NULL,     m_polynom5);
 setmenu(2,NULL,      "Nummerisches Integral ...",NULL,m_numintegral);
 setmenu(2,NULL,      "refresh",NULL, m_refresh);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 waitBOF();//test
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif

 alles_zeichnen();
 term_refresh();

 while(exitflag==0 && waitmenu(1)==0)
  {}// auf Benutzereingaben warten

 term_exit();
 return 0;
}/* ende von main */

/*********************** Nummerische Funktion *************************/
const int MAXNUM=1024;
double yfeld[MAXNUM+1]; //Werte der Funktion
double ystrich[MAXNUM+1]; //Werte der Ableitung
double yfeld2[MAXNUM+1]; //Werte der Funktion2
double ystrich2[MAXNUM+1]; //Werte der Ableitung von Funktion2

void m_numintegral() //Funktion mit Nummerischer Integration berechnen
{
 int ok;
 int num=numfunktion;
 ok=requester_input(6,"Nummerische Funktion verwenden (0=nein, 1=erste, 2=zweite Variante)","%d","%d\n",&num,
		    "Radius des Absorbers","%f","%lf",&Radius,
		    "Radius von Strahlfokus","%f","%lf",&Radius2,
		    "Absorber-Hoehe (Mittelpunkt)","%f","%lf\n",&Hoehe,
		    "alfamax: Maximale Strahl-Abweichung in Grad","%f","%lf\n",&alfamax,
		    "Ableitung auch zeichnen (0=nein, 1=ja)","%d","%d",&ableitflag);
 if(!ok) {m_refresh(); return;}
 numfunktion=num; if(num==0) {m_refresh(); return;}
 if(num>=2) {numintegral2(); m_refresh(); return;}
 int i; double x,y,dx,dy=0;
 dx=(xmax-xmin)/MAXNUM;
 for(i=0,x=0,y=0; i<=MAXNUM/2; x+=dx,y+=dy,i++)
  {double alfa,ys;
   if(x==0) alfa = asin(Radius2/Hoehe)/2;
   else
    {double w1,w2,w3,gamma;
     double Hminusy=Hoehe-y;
     double A=sqrt(x*x+Hminusy*Hminusy);
     w1 = atan(Hminusy/x);
     w2 = asin(Radius2/A);
     w3 = w1-w2;
     gamma = 90*GRAD-w3;
     alfa = gamma/2;
    }
   ys=tan(alfa);  dy=ys*dx;
   ystrich[MAXNUM/2+i] = ys;
   yfeld[MAXNUM/2+i] = y;
   if(i>0)
    {ystrich[MAXNUM/2-i] = -ys;
     yfeld[MAXNUM/2-i] = y;
    }
  }
 m_refresh();
}

void numintegral2()
{
 double x,y,ys, dy=0, dx=(xmax-xmin)/MAXNUM, alfa0=alfamax*GRAD;
 for(int i=0;i<=MAXNUM;i++) {yfeld2[i]=ystrich2[i]=0;}//test //TODO
 int i = int((Radius2-xmin)/dx+0.5);
 printf("Testpunkt numintegral2()\n");//test
 for(x=Radius2,y=0; i>=MAXNUM/2; x-=dx,y+=dy,i--)
  {// Bereich1: x <= Radius2
   if(y>=Hoehe-Radius2) {y=Hoehe-Radius2; dy=0; ys=0;}
   else
    {double Hminusy=Hoehe-y;
     double c=sqrt(x*x+Hminusy*Hminusy);
     double w1=atan(x/Hminusy);
     double w2=asin(Radius2/c);
     double alfa=w2-w1;
     ys=tan(alfa);  dy=ys*dx;
    }
   ystrich2[i] = ys;  yfeld2[i] = y;
   //printf("Teil1: i=%d x=%f y=%f ys=%f\n",i,x,y,ys);//test
  }
 i = int((Radius2-xmin)/dx+0.5);
 for(x=Radius2,y=0; x<=xmax; x+=dx,y+=dy,i++)
  {// Bereich2: alfa1 < alfa0 (Strahlen mit alfa0 treffen direkt auf Absorber)
   double Hminusy=Hoehe-y;
   double c=sqrt(x*x+Hminusy*Hminusy);
   double w1=atan(x/Hminusy);
   double w2=asin(Radius2/c);
   double alfa=w1-w2; //alfa==alfa1
   //printf("w1=%f w2=%f alfa=%f alfa0=%f\n",w1/GRAD,w2/GRAD,alfa/GRAD,alfa0/GRAD);//test
   if(alfa>=alfa0) break;
   ys=tan(alfa);  dy=ys*dx;
   ystrich2[i] = ys;  yfeld2[i] = y;
   //printf("Teil2: i=%d x=%f y=%f ys=%f\n",i,x,y,ys);//test
  }
 for(; x<=xmax; x+=dx,y+=dy,i++)
  {// Bereich3: Strahlen treffen nicht direkt auf Absorber
   if(i>MAXNUM) {printf("Fehler: i=%d MAXNUM=%d\n",i,MAXNUM); break;}//test
   double Hminusy=Hoehe-y;
   double c=sqrt(x*x+Hminusy*Hminusy);
   double w1=atan(Hminusy/x);
   double w2=asin(Radius2/c);
   double w3=90*GRAD-w1-w2-alfa0;
   double alfa=90*GRAD-w1-w2-w3/2;
   ys=tan(alfa);  dy=ys*dx;
   ystrich2[i] = ys;  yfeld2[i] = y;
   //printf("Teil3: i=%d x=%f y=%f ys=%f\n",i,x,y,ys);//test
  }
 for(;i<=MAXNUM; y+=dy,i++)
  {
   ystrich2[i] = ys;  yfeld2[i] = y;
  }
 int j;
 for(j=MAXNUM/2-1,i=MAXNUM/2+1; j>=0; i++,j--)
  {
   yfeld2[j] = yfeld2[i];
   ystrich2[j] = -ystrich2[i];
  }
 //test: Laenge der Kurve ausmessen:
 double laenge=0;
 for(i=0,x=xmin; i<MAXNUM; x+=dx,i++)
  {
   dy = ystrich2[i]*dx;
   double ds=sqrt(dx*dx+dy*dy);
   laenge += ds;
  }
 printf("Laenge der Kurve: %f cm\n",laenge);
}

double yfunktion(double x)
{
 int i = int(MAXNUM*(x-xmin)/(xmax-xmin)+0.5);
 if(i<0) i=0; else if(i>MAXNUM) i=MAXNUM;
 return yfeld[i];
}

double yableitung(double x)
{
 int i = int(MAXNUM*(x-xmin)/(xmax-xmin)+0.5);
 if(i<0) i=0; else if(i>MAXNUM) i=MAXNUM;
 return ystrich[i];
}

double yfunktion2(double x)
{
 int i = int(MAXNUM*(x-xmin)/(xmax-xmin)+0.5);
 if(i<0) i=0; else if(i>MAXNUM) i=MAXNUM;
 return yfeld2[i];
}

double yableitung2(double x)
{
 int i = int(MAXNUM*(x-xmin)/(xmax-xmin)+0.5);
 if(i<0) i=0; else if(i>MAXNUM) i=MAXNUM;
 return ystrich2[i];
}
