/* stlkugel.cc			letzte Aenderung: 12.10.2013 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: STL-Datei einer oder mehrere ueberlagerte Kugeln erzeugen

History:
7.10.2013	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include "vektor3dklasse.cc"

/************************* Vordeklarationen ***************************/
void unterprog(FILE *fp);
void kugel_merken(Vektor3d& kugelmittelpunkt,double radius);
void kugel_speichern(FILE *fp,Vektor3d& kugelmittelpunkt,double radius);

/************************* Globale Variablen **************************/
static int workbenchflag=0;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/
bool istja(char *s)
{
 int c= *s;
 return (c=='j' || c=='J' || c=='y' || c=='Y');
}

void punkt_eingeben(const char *punktname,double *px,double *py,double *pz)
{
 printf("%s x-Wert: ",punktname); scanf("%lf",px);
 printf("%s y-Wert: ",punktname); scanf("%lf",py);
 printf("%s z-Wert: ",punktname); scanf("%lf",pz);
 printf(" %s = [ %f, %f, %f ]\n\n",punktname,*px,*py,*pz);
}

/************** Klassen und Hauptteil des Programms *******************/

const double scalx=1; //Scaling factor to get millimeters in x-Axis
const double scaly=1; //Scaling factor to get millimeters in y-Axis
const double scalz=1; //Scaling factor to get millimeters in z-Axis
const double ddr=1e-4; //Kleiner Wert um Rundungsfehler zu vermeiden

static int gradstep=20; //provi. grobe Aufloesung zum austesten

class Kugel
{
public:
 Vektor3d pos;
 double radius;
 Kugel() {radius=0; pos.x=pos.y=pos.z=0;}
 void init(Vektor3d& mittelpunkt,double r) {pos=mittelpunkt; radius=r;}
 double getradius() {return radius;}
 bool istinnerhalb(Vektor3d& p);
 bool istausserhalb(Vektor3d& p);
 Vektor3d schnittpunkt(Vektor3d p1,Vektor3d p2);
};

bool Kugel::istinnerhalb(Vektor3d& p)
{
 return (abs(p-pos) < radius-ddr);
}

bool Kugel::istausserhalb(Vektor3d& p)
{
 return (abs(p-pos) > radius+ddr);
}

/** einfache Variante mit Naeherung wenn die Dreiecke klein sind (verglichen mit Radius) ** /
Vektor3d Kugel::schnittpunkt(Vektor3d p1,Vektor3d p2)
{
 double r=radius, a,b;
 Vektor3d v1;
 a = r-abs(p1-pos);
 b = abs(p2-pos)-r;
 v1 = p2-p1;
 v1 *= a/(a+b);
 return (p1+v1);
}
/ **/

/** Exakt gerechnete Variante: **/
Vektor3d Kugel::schnittpunkt(Vektor3d p1,Vektor3d p2) //p1 soll innerhalb der Kugel liegen, p2 ausserhalb der Kugel
{
 double A,a,b,c;
 Vektor3d v,q;           //v=Hilfsvektor, q=gesuchter Schnittpunkt
 p1 -= pos; p2 -= pos; //wir setzen das Koordinatensystem so dass der Kugelmittelpunkt am Nullpunkt ist
 v = p2-p1;
 // Herleitung der Loesungsformel:
 // q = (p2-p1)*A + p1 = v*A + p1   der Punkt q liegt auf der Strecke p1_p2, A muss eine Zahl zwischen 0 und 1 sein
 // r^2 = x^2 + y^2 + z^2           Kugelgleichung
 // q.x = v.x*A + p1.x
 // q.y = v.y*A + p1.y
 // q.z = v.z*A + p1.z
 // Wir haben also 4 Gleichungen mit 4 Unbekannten: A, q.x, q.y, q.z
 // Die letzten 3 Gleichungen in die Kugelgleichung eingesetzt ergibt eine Gleichung mit nur noch einer Unbekannten: A
 // Umformung auf die Form der allgemeinen Quadratischen Gleichung ergibt die Loesung.
 a = v.x*v.x + v.y*v.y + v.z*v.z;
 b = (v.x*p1.x + v.y*p1.y + v.z*p1.z)*2;
 c = p1.x*p1.x + p1.y*p1.y + p1.z*p1.z - radius*radius;
 A = (sqrt(b*b-4*a*c)-b)/(2*a); //allgemeine Loesungsformel fuer Quadratische Gleichung (hier nur positives Resultat sinnvoll)
 q = v*A + p1;
 return (q+pos); //Resultat wieder im vorherigen Koordinatensystem zurueckgeben
}
/** Ende Exakt gerechnete Variante **/

#define MAXKUGELN 20
static Kugel kugel_liste[MAXKUGELN]; //provi. max 20 Kugeln
static int anzahl_kugeln=0; //provi.
static int j_aktuelle_kugel=0;

//void dreieck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3,bool innentestflag=true) //test
// Das innentestflag wird benoetigt wenn in schnittpunkt()-Variante mit Naeherung verwendet wird,
// es duerfen sich dann aber hoechstens jeweils 2 Kugeln ueberlagern.

void dreieck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3)
{
 Vektor3d q1,q2,normalenvektor;
 //if(innentestflag) //test
 for(int j=0;j<anzahl_kugeln;j++)
  {
   if(j!=j_aktuelle_kugel)
    {
     // Es gibt 12 Moeglichkeiten wie ein Dreieck eine Kugel schneiden kann.
     // Begruendung: jeder der 3 Eckpunkte kann innerhalb, ausserhalb oder auf der Kugeloberflaeche liegen,
     // es gibt also total 3^3 = 27 Moeglichkeiten. Davon fallen die Varianten weg wo alle Punkte ausserhalb oder
     // auf der Oberflaeche liegen, also 3^2 = 8 Varianten. Auch die Varianten wo alle punkte innerhalb oder auf
     // der Oberflaeche liegen, also nochmals 3^2 = 8 fallen weg. Wobei wir jetzt die Variante wo alle Punkte auf
     // der Oberflaeche liegen 2 mal gezaehlt haben, also 1 weniger abziehen.
     // Also verbleiben 27-(2*8-1) = 12 Moeglichkeiten.
     // Hier also die entsprechenden if-Abfragen um alle Moeglichkeiten abzudecken.
     if(kugel_liste[j].istinnerhalb(p1))
      {
       if(kugel_liste[j].istausserhalb(p2))
	{
	 if(kugel_liste[j].istausserhalb(p3)) //nur p1 innerhalb, p2 und p3 ausserhalb (1. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p1,p2);
	   q2=kugel_liste[j].schnittpunkt(p1,p3);
	   dreieck(fp,q1,p2,p3);
	   dreieck(fp,q1,p3,q2); return;
	  }
	 else if(kugel_liste[j].istinnerhalb(p3)) //p1 und p3 innerhalb, p2 ausserhalb (2. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p1,p2);
	   q2=kugel_liste[j].schnittpunkt(p3,p2);
	   dreieck(fp,q1,p2,q2); return;
	  }
	 else //p1 innerhalb, p3 auf der Kugeloberflaeche, p2 ausserhalb (3. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p1,p2);
	   dreieck(fp,q1,p2,p3); return;
	  }
	}
       else if(kugel_liste[j].istinnerhalb(p2)) //p1 und p2 innerhalb
	{
	 if(kugel_liste[j].istausserhalb(p3)) //p1 und p2 innerhalb, p3 ausserhalb (4. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p1,p3);
	   q2=kugel_liste[j].schnittpunkt(p2,p3);
	   dreieck(fp,q1,q2,p3); return;
	  }
	 else //alle Dreiecks-Punkte innerhalb der Kugel oder auf der Kugeloberflaeche
	  {
	   return; //ignorieren wenn gesamtes Dreieck innerhalb einer andern Kugel
	  }
	}
       else //p1 innerhalb, p2 auf Kugeloberflaeche
	{
	 if(kugel_liste[j].istausserhalb(p3)) //p1 innerhalb, p2 auf Oberflaeche, p3 ausserhalb (5. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p1,p3);
	   dreieck(fp,q1,p2,p3); return;
	  }
	 else //alle Dreiecks-Punkte innerhalb der Kugel oder auf der Kugeloberflaeche
	  {
	   return; //ignorieren wenn gesamtes Dreieck innerhalb einer andern Kugel
	  }
	}
      } //Ende if istinnerhalb(p1)

     else if(kugel_liste[j].istinnerhalb(p2))
      {
       if(kugel_liste[j].istausserhalb(p1))
	{
	 if(kugel_liste[j].istausserhalb(p3)) //nur p2 innerhalb, p1 und p3 ausserhalb (6. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p2,p1);
	   q2=kugel_liste[j].schnittpunkt(p2,p3);
	   dreieck(fp,p1,q1,q2);
	   dreieck(fp,p1,q2,p3); return;
	  }
	 else if(kugel_liste[j].istinnerhalb(p3)) //p2 und p3 innerhalb, p1 ausserhalb (7. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p2,p1);
	   q2=kugel_liste[j].schnittpunkt(p3,p1);
	   dreieck(fp,p1,q1,q2); return;
	  }
	 else //p2 innerhalb, p3 auf der Kugeloberflaeche, p1 ausserhalb (8. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p2,p1);
	   dreieck(fp,p1,q1,p3); return;
	  }
	}
       else //p2 innerhalb, p1 auf Kugeloberflaeche
	{
	 if(kugel_liste[j].istausserhalb(p3)) //p2 innerhalb, p1 auf Oberflaeche, p3 ausserhalb (9. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p2,p3);
	   dreieck(fp,p1,q1,p3); return;
	  }
	 else //alle Dreiecks-Punkte innerhalb der Kugel oder auf der Kugeloberflaeche
	  {
	   return; //ignorieren wenn gesamtes Dreieck innerhalb einer andern Kugel
	  }
	}
      } //Ende if istinnerhalb(p2)

     else if(kugel_liste[j].istinnerhalb(p3))
      {
       if(kugel_liste[j].istausserhalb(p1))
	{
	 if(kugel_liste[j].istausserhalb(p2)) //p3 innerhalb, p1 und p2 ausserhalb (10. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p3,p1);
	   q2=kugel_liste[j].schnittpunkt(p3,p2);
	   dreieck(fp,p1,p2,q2);
	   dreieck(fp,p1,q2,q1); return;
	  }
	 else //p3 innerhalb, p2 auf Oberflaeche, p1 ausserhalb (11. Moeglichkeit)
	  {
	   q1=kugel_liste[j].schnittpunkt(p3,p1);
	   dreieck(fp,p1,p2,q1); return;
	  }
	}
       else if(kugel_liste[j].istausserhalb(p2)) //p3 innerhalb, p1 auf Oberflaeche, p2 ausserhalb (12. Moeglichkeit)
	{
	 q1=kugel_liste[j].schnittpunkt(p3,p2);
	 dreieck(fp,p1,p2,q1); return;
	}
       else //alle Dreiecks-Punkte innerhalb der Kugel oder auf der Kugeloberflaeche
	{
	 return; //ignorieren wenn gesamtes Dreieck innerhalb einer andern Kugel
	}
      } //Ende if istinnerhalb(p3)
    } //Ende if j!=j_aktuelle_kugel
  } //Ende der for-j-Schlaufe
 q1=p2-p1;
 q2=p3-p2;
 normalenvektor=vektorkreuzprodukt(q1,q2);
 fprintf(fp," facet normal %.3f %.3f %.3f\n", normalenvektor.x, normalenvektor.y, normalenvektor.z);
 fprintf(fp,"  outer loop\n");
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x*scalx, p1.y*scaly, p1.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p2.x*scalx, p2.y*scaly, p2.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x*scalx, p3.y*scaly, p3.z*scalz);
 fprintf(fp,"  endloop\n");
 fprintf(fp," endfacet\n");
}

void viereck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3,Vektor3d& p4)
{
 dreieck(fp,p1,p2,p3);
 dreieck(fp,p1,p3,p4);
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char zielname[80],antw[40];
 FILE *fp2;
 int i,j,c;
 zielname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
   workbenchflag=1;
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(zielname,argv[i]);
	         //else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j>MAXARG)
	{printf("stlkugel  %s\n",VERSION);
	 printf("Anwendung: stlkugel [Ziel.stl]\n");
	 exit(0);
	}
 if(*zielname==0)
  {fp2=stdout;}
 else
  {
   //if(fp2=fopen(zielname,"r")) printf("Datei '%s' schon vorhanden. Ueberschreiben? ",zielname);
   //*antw=0; scanf("%s",&antw);
   //if(antw[0]!=='j' || ...)
   fp2=fopen(zielname,"w");
   if(fp2==NULL) {printf("konnte '%s' nicht erstellen.\n",zielname); exit(0);}
  }
 unterprog(fp2);
 if(*zielname!=0) fclose(fp2);
 return 0;
}/* ende von main */

void unterprog(FILE *fp)
{
 int n,j;
 Vektor3d p1;
 double radius;
 char antw[80];
 for(;;)
  {
   printf("Auswahlmenu:\n");
   printf("1: Help\n");
   printf("2: Koordinaten und Radius einer Kugel eingeben\n");
   printf("3: Schrittweite in Grad eingeben (Voreinstellung %d)\n",gradstep);
   printf("0: Ende\n");
   printf("Auswahl: "); scanf("%d",&n);
   if(n==0) break;
   else if(n==2)
    {
     punkt_eingeben("P1",&p1.x,&p1.y,&p1.z);
     printf("Radius: "); scanf("%lf",&radius);
     kugel_merken(p1,radius);
    }
   else if(n==3)
    {
     int neu;
     printf("Schrittweite in ganzen Grad: "); scanf("%d",&neu);
     gradstep=neu;
     if(gradstep<1) gradstep=1;
     else if(gradstep>30) gradstep=30;
     else while(180/gradstep*gradstep != 180) gradstep++;
     if(gradstep!=neu) printf("auf %d Grad gerundet.\n",gradstep);
    }
   else //n==1 fuer Help
    {
     printf("Jeweils Koordinaten des Kugelmittelpunktes und den Radius der Kugel eingeben.\n");
     printf("Es wird fuer jede Kugel ein solid-endsolid Eintrag in der Datei gespeichert.\n");
    }
  }
 for(j=0;j<anzahl_kugeln;j++)
  {
   j_aktuelle_kugel=j;
   kugel_speichern(fp, kugel_liste[j].pos, kugel_liste[j].getradius());
  }
}

void kugel_merken(Vektor3d& kugelmittelpunkt,double r)
{
 int i=anzahl_kugeln;
 if(i==MAXKUGELN) {fprintf(stderr,"zu viele Kugeln\n"); return;} //provi.
 kugel_liste[i].init(kugelmittelpunkt,r);
 anzahl_kugeln++;
}

void kugel_speichern(FILE *fp,Vektor3d& kugelmittelpunkt,double r)
{
 static int ntekugel=0;
 Vektor3d p1,p2,p3,p4,v1,v2,normalenvektor;
 int    theta0,phi0,dtheta0,dphi0; //Werte in Grad
 double theta, phi, dtheta, dphi, sintheta,sintheta2,costheta2; //Werte in Rad
 ntekugel += 1;
 dtheta0=dphi0=gradstep;
 fprintf(fp,"solid kugel%d\n",ntekugel);
 for(theta0=180;theta0>0;theta0-=dtheta0) //gehe vom Suedpol zum Nordpol in ganzzahligen Schritten
  for(phi0= 0;phi0<360;phi0+=dphi0)       //gehe einmal rundrum
   {
    theta=theta0*GRAD; phi=phi0*GRAD; dtheta=dtheta0*GRAD; dphi=dphi0*GRAD;
    sintheta=sin(theta);
    p1=p2=p3=kugelmittelpunkt;
    //printf("theta = %d Grad = %lf, phi = %d Grad = %lf\n",theta0,theta,phi0,phi);//test
    if(theta0==180)
     { //einzelnes Dreieck am Suedpol
      sintheta2=sin(theta-dtheta);
      costheta2=cos(theta-dtheta);
      p1.z -= r;
      p2.x += r*sintheta2*cos(phi);
      p2.y += r*sintheta2*sin(phi);
      p2.z += r*costheta2;
      p3.x += r*sintheta2*cos(phi+dphi);
      p3.y += r*sintheta2*sin(phi+dphi);
      p3.z = p2.z;
      dreieck(fp,p1,p3,p2);
     }
    else if(theta0==dtheta0)
     { //einzelnes Dreieck am Nordpol
      p1.z += r;
      p2.x += r*sintheta*cos(phi);
      p2.y += r*sintheta*sin(phi);
      p2.z += r*cos(theta);
      p3.x += r*sintheta*cos(phi+dphi);
      p3.y += r*sintheta*sin(phi+dphi);
      p3.z = p2.z;
      dreieck(fp,p1,p2,p3);
     }
    else
     {// wenn nicht am Pol dann jeweils ein Viereck
      // Formeln aus  http://de.wikipedia.org/wiki/Kugelkoordinaten
      sintheta2=sin(theta-dtheta);
      costheta2=cos(theta-dtheta);

      p1.x += r*sintheta*cos(phi);
      p1.y += r*sintheta*sin(phi);
      p1.z += r*cos(theta);

      p2.x += r*sintheta*cos(phi+dphi);
      p2.y += r*sintheta*sin(phi+dphi);
      p2.z = p1.z;

      p3.x += r*sintheta2*cos(phi+dphi);
      p3.y += r*sintheta2*sin(phi+dphi);
      p3.z += r*costheta2;

      p4=kugelmittelpunkt;
      p4.x += r*sintheta2*cos(phi);
      p4.y += r*sintheta2*sin(phi);
      p4.z = p3.z;
      viereck(fp,p1,p2,p3,p4);
     }
   }
 fprintf(fp,"endsolid kugel%d\n",ntekugel);
}
