/* stern.cc			letzte Aenderung: 23.12.2013 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: 5-Zackigen Stern modellieren und speichern als STL-Datei

History:
23.12.2013	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include "vektor3dklasse.cc"

/************************* Vordeklarationen ***************************/
void stern_berechnen(FILE *fp);

/************************* Globale Variablen **************************/
static int workbenchflag=0;
static int anzahldreiecke=0;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/
bool istja(char *s)
{
 int c= *s;
 return (c=='j' || c=='J' || c=='y' || c=='Y');
}

char *ohneletztenpunkt(char *name)  /* die Endung .xxx loeschen */
{
 char c=0,*s; int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='.')
        {--i; --s;}
 if(c=='.') *s='\0';
 return name;
}

char *anhaengen(char *s,const char *t)  /* s + t --> s */
{
 char *p;
 for(p=s;*p!=0;p++) ;
 for(;*p++ = *t++;) ;
 return s;
}

char *endungersetzen(char *neu,const char *name,const char *endung)
{
 strcpy(neu,name); ohneletztenpunkt(neu);
 return anhaengen(neu,endung);
}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

void putint(int n,FILE *fp)
{
 putc(n&0xFF,fp); //als little endian speichern
 putc((n>>8)&0xFF,fp);
 putc((n>>16)&0xFF,fp);
 putc((n>>24)&0xFF,fp);
}

void putfloat(float x,FILE *fp)
{
 union
   {float f;
    char  c[4];
   } u;
 u.f=x;
 for(int i=0;i<4;i++) putc(u.c[i],fp);
}

/************** Klassen und Hauptteil des Programms *******************/

const double scalx=1; //Scaling factor to get millimeters in x-Axis
const double scaly=1; //Scaling factor to get millimeters in y-Axis
const double scalz=1; //Scaling factor to get millimeters in z-Axis
const double ddr=1e-4; //Kleiner Wert um Rundungsfehler zu vermeiden

void dreieck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3)
{
 Vektor3d q1,q2,normalenvektor;
 q1=p2-p1;
 q2=p3-p2;
 anzahldreiecke++;
 normalenvektor=vektorkreuzprodukt(q1,q2);
 if(argflag['B']) //in binaerem Format speichern?
  {
   putfloat(normalenvektor.x,fp);
   putfloat(normalenvektor.y,fp);
   putfloat(normalenvektor.z,fp);
   putfloat(p1.x,fp); putfloat(p1.y,fp); putfloat(p1.z,fp);
   putfloat(p2.x,fp); putfloat(p2.y,fp); putfloat(p2.z,fp);
   putfloat(p3.x,fp); putfloat(p3.y,fp); putfloat(p3.z,fp);
   putc(0,fp); putc(0,fp); //"Attribute byte count" immer auf 0 gesetzt
  }
 else
  {
   fprintf(fp," facet normal %.3f %.3f %.3f\n", normalenvektor.x, normalenvektor.y, normalenvektor.z);
   fprintf(fp,"  outer loop\n");
   fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x*scalx, p1.y*scaly, p1.z*scalz);
   fprintf(fp,"   vertex %.3f %.3f %.3f\n", p2.x*scalx, p2.y*scaly, p2.z*scalz);
   fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x*scalx, p3.y*scaly, p3.z*scalz);
   fprintf(fp,"  endloop\n");
   fprintf(fp," endfacet\n");
  }
}

void viereck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3,Vektor3d& p4)
{
 dreieck(fp,p1,p2,p3);
 dreieck(fp,p1,p3,p4);
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80],antw[40];
 FILE *fp1,*fp2;
 int i,j,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
   workbenchflag=1;
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) /*strcpy(quellname,argv[i]); else if(j==2)*/
	                    strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j<1 || j>MAXARG)
	{printf("stern  %s\n",VERSION);
	 printf("Anwendung: stern Ziel.stl [-Flags]\n");
	 printf("  Flags: b=Binaer speichern\n");
	 printf("         c=mit Loecher fuer LEDs\n");
	 printf("         v=Verbose, mit Testausgaben\n");
	 exit(0);
	}
 if(*zielname==0)
  {
   printf("Datei zum speichern:"); scanf("%s",zielname);
  }
 fp2=fopen(zielname,argflag['B']?"wb":"w");
 if(fp2==NULL) {printf("konnte '%s' nicht erstellen.\n",zielname); exit(0);}
 if(argflag['B'])
  {
   fprintf(fp2,"Binaeres STL-Format "); //Header
   for(int i=0;i<80-20;i++) putc(' ',fp2); //Header total 80 Zeichen lang
   putint(anzahldreiecke,fp2); // Anzahl Dreiecke als little endian speichern (ist aber noch nicht
   // korrekt und muss deshalb am Schluss nochmals geschrieben werden)
  }
 else fprintf(fp2,"solid unnamed\n");

 stern_berechnen(fp2);

 if(argflag['B'])
  {
   int i,c;
   fclose(fp2);
   fp2=fopen(zielname,"r+b");
   if(fp2==NULL) {printf("kann '%s' nicht wiederoeffnen um korrekte Anzahl Dreiecke zu schreiben.\n",zielname); exit(0);}
   for(i=0;i<80;i++) getc(fp2);
   putint(anzahldreiecke,fp2);
   fclose(fp2);
  }
 else
  {
   fprintf(fp2,"endsolid unnamed\n");
   fclose(fp2);
  }
 return 0;
}/* ende von main */

void stern_berechnen(FILE *fp)
{
 Vektor3d p00,p0,p1,p2,p3;
 int i,nzacken=5; //Anzahl Zacken des Sterns
 double L=50,b=15,hoehe=25; //Werte in Millimeter: L=Zackenlaenge, b=Zackenbreite, hoehe=Hoehe in der Mitte
 double d=5,r=2.5,hq=8; //Abstand, Radius und Tiefe fuer Loecher fuer LED
 Vektor3d q0,q1,q2,q3,q4,q5,q6; //Mitte und Eckpunkte von 6-eckigem Loch
 Vektor3d qh0,qh1,qh2,qh3,qh4,qh5,qh6; //Oberer Teil vom Loch
 double a,c,alfa,alfahalbe,beta,w,sinalfa,cosalfa;
 alfa=360*GRAD/nzacken; alfahalbe=alfa*0.5;
 beta=atan(b/L);
 c=b/sin(alfahalbe);
 a=c*cos(alfahalbe);
 sinalfa=sin(alfa);
 cosalfa=cos(alfa);

 p00.x=0;  p00.y=0;  p00.z=0;
 p0.x= 0;  p0.y= 0;  p0.z= hoehe;
 p1.x= a;  p1.y= -b; p1.z= 0;
 p2.x=a+L; p2.y= 0;  p2.z= 0;
 p3.x= a;  p3.y= b;  p3.z= 0;
 if(argflag['C'])
  {
   double rw3=r/2*sqrt(3.0);
   q0.x=a+d; q0.y=0; q0.z=0;
   q1.x=a+d-r;   q1.y=0;   q1.z=0;
   q2.x=a+d-r/2; q2.y=rw3; q2.z=0;
   q3.x=a+d+r/2; q3.y=rw3; q3.z=0;
   q4.x=a+d+r;   q4.y=0;     q4.z=0;
   q5.x=a+d+r/2; q5.y= -rw3; q5.z=0;
   q6.x=a+d-r/2; q6.y= -rw3; q6.z=0;
   if(argflag['V']) printf("q0 bis q6 initialisiert.\n");
  }

 for(i=0;i<nzacken;i++)
  {
   dreieck(fp,p0,p1,p2);
   dreieck(fp,p0,p2,p3);
   dreieck(fp,p00,p3,p1);
   if(argflag['C'])
    {
     dreieck(fp,p3,p2,q3);
     dreieck(fp,p3,q3,q2);
     dreieck(fp,p3,q2,q1);
     dreieck(fp,p3,q1,p1);
     dreieck(fp,q3,p2,q4);
     dreieck(fp,q4,p2,q5);
     dreieck(fp,q5,p2,p1);
     dreieck(fp,q6,q5,p1);
     dreieck(fp,q1,q6,p1);
     qh0=q0; qh0.z=hq;
     qh1=q1; qh1.z=hq;
     qh2=q2; qh2.z=hq;
     qh3=q3; qh3.z=hq;
     qh4=q4; qh4.z=hq;
     qh5=q5; qh5.z=hq;
     qh6=q6; qh6.z=hq;
     viereck(fp,q1,q2,qh2,qh1);
     viereck(fp,q2,q3,qh3,qh2);
     viereck(fp,q3,q4,qh4,qh3);
     viereck(fp,q4,q5,qh5,qh4);
     viereck(fp,q5,q6,qh6,qh5);
     viereck(fp,q6,q1,qh1,qh6);
     dreieck(fp,qh1,qh2,qh0);
     dreieck(fp,qh2,qh3,qh0);
     dreieck(fp,qh3,qh4,qh0);
     dreieck(fp,qh4,qh5,qh0);
     dreieck(fp,qh5,qh6,qh0);
     dreieck(fp,qh6,qh1,qh0);
     q0.drehenxy(sinalfa,cosalfa);
     q1.drehenxy(sinalfa,cosalfa);
     q2.drehenxy(sinalfa,cosalfa);
     q3.drehenxy(sinalfa,cosalfa);
     q4.drehenxy(sinalfa,cosalfa);
     q5.drehenxy(sinalfa,cosalfa);
     q6.drehenxy(sinalfa,cosalfa);
     if(argflag['V']) printf("Loch gemacht.\n");
    }
   else
    {
     dreieck(fp,p3,p2,p1);
     if(argflag['V']) printf("Ohne Loch.\n");
    }
   p1.drehenxy(sinalfa,cosalfa);
   p2.drehenxy(sinalfa,cosalfa);
   p3.drehenxy(sinalfa,cosalfa);
  }
}
