/* stern2mittelteil.cc			letzte Aenderung: 30.12.2013 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: 5-Zackigen Stern modellieren und speichern als STL-Datei

History:
27.12.2013	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include "vektor3dklasse.cc"

/************************* Vordeklarationen ***************************/
void stern_berechnen(FILE *fp);
void stern_spitze_berechnen(FILE *fp);

/************************* Globale Variablen **************************/
static int workbenchflag=0;
static int anzahldreiecke=0;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/
bool istja(char *s)
{
 int c= *s;
 return (c=='j' || c=='J' || c=='y' || c=='Y');
}

char *ohneletztenpunkt(char *name)  /* die Endung .xxx loeschen */
{
 char c=0,*s; int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='.')
        {--i; --s;}
 if(c=='.') *s='\0';
 return name;
}

char *anhaengen(char *s,const char *t)  /* s + t --> s */
{
 char *p;
 for(p=s;*p!=0;p++) ;
 for(;*p++ = *t++;) ;
 return s;
}

char *endungersetzen(char *neu,const char *name,const char *endung)
{
 strcpy(neu,name); ohneletztenpunkt(neu);
 return anhaengen(neu,endung);
}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

void putint(int n,FILE *fp)
{
 putc(n&0xFF,fp); //als little endian speichern
 putc((n>>8)&0xFF,fp);
 putc((n>>16)&0xFF,fp);
 putc((n>>24)&0xFF,fp);
}

void putfloat(float x,FILE *fp)
{
 union
   {float f;
    char  c[4];
   } u;
 u.f=x;
 for(int i=0;i<4;i++) putc(u.c[i],fp);
}

/************** Klassen und Hauptteil des Programms *******************/

const double scalx=1; //Scaling factor to get millimeters in x-Axis
const double scaly=1; //Scaling factor to get millimeters in y-Axis
const double scalz=1; //Scaling factor to get millimeters in z-Axis
const double ddr=1e-4; //Kleiner Wert um Rundungsfehler zu vermeiden

void dreieck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3)
{
 Vektor3d q1,q2,normalenvektor;
 q1=p2-p1;
 q2=p3-p2;
 anzahldreiecke++;
 normalenvektor=vektorkreuzprodukt(q1,q2);
 if(argflag['B']) //in binaerem Format speichern?
  {
   putfloat(normalenvektor.x,fp);
   putfloat(normalenvektor.y,fp);
   putfloat(normalenvektor.z,fp);
   putfloat(p1.x,fp); putfloat(p1.y,fp); putfloat(p1.z,fp);
   putfloat(p2.x,fp); putfloat(p2.y,fp); putfloat(p2.z,fp);
   putfloat(p3.x,fp); putfloat(p3.y,fp); putfloat(p3.z,fp);
   putc(0,fp); putc(0,fp); //"Attribute byte count" immer auf 0 gesetzt
  }
 else
  {
   fprintf(fp," facet normal %.3f %.3f %.3f\n", normalenvektor.x, normalenvektor.y, normalenvektor.z);
   fprintf(fp,"  outer loop\n");
   fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x*scalx, p1.y*scaly, p1.z*scalz);
   fprintf(fp,"   vertex %.3f %.3f %.3f\n", p2.x*scalx, p2.y*scaly, p2.z*scalz);
   fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x*scalx, p3.y*scaly, p3.z*scalz);
   fprintf(fp,"  endloop\n");
   fprintf(fp," endfacet\n");
  }
}

void viereck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3,Vektor3d& p4)
{
 dreieck(fp,p1,p2,p3);
 dreieck(fp,p1,p3,p4);
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80],antw[40];
 FILE *fp1,*fp2;
 int i,j,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
   workbenchflag=1;
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) /*strcpy(quellname,argv[i]); else if(j==2)*/
	                    strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j<1 || j>MAXARG)
	{printf("stern2mittelteil  %s\n",VERSION);
	 printf("Anwendung: stern Ziel.stl [-Flags]\n");
	 printf("  Flags: b=Binaer speichern\n");
	 printf("         k=mit oberer Kappe statt nur Mittelteil\n");
	 printf("         i=gesamtes Ikosaeder statt nur Mittelteil\n");
	 printf("         s=Sternspitze (liegend) berechnen\n");
	 printf("         v=Verbose, mit Testausgaben\n");
	 exit(0);
	}
 if(*zielname==0)
  {
   printf("Datei zum speichern:"); scanf("%s",zielname);
  }
 fp2=fopen(zielname,argflag['B']?"wb":"w");
 if(fp2==NULL) {printf("konnte '%s' nicht erstellen.\n",zielname); exit(0);}
 if(argflag['B'])
  {
   fprintf(fp2,"Binaeres STL-Format "); //Header
   for(int i=0;i<80-20;i++) putc(' ',fp2); //Header total 80 Zeichen lang
   putint(anzahldreiecke,fp2); // Anzahl Dreiecke als little endian speichern (ist aber noch nicht
   // korrekt und muss deshalb am Schluss nochmals geschrieben werden)
  }
 else fprintf(fp2,"solid unnamed\n");

 if(argflag['S']) stern_spitze_berechnen(fp2);
 else stern_berechnen(fp2);

 if(argflag['B'])
  {
   int i,c;
   fclose(fp2);
   fp2=fopen(zielname,"r+b");
   if(fp2==NULL) {printf("kann '%s' nicht wiederoeffnen um korrekte Anzahl Dreiecke zu schreiben.\n",zielname); exit(0);}
   for(i=0;i<80;i++) getc(fp2);
   putint(anzahldreiecke,fp2);
   fclose(fp2);
  }
 else
  {
   fprintf(fp2,"endsolid unnamed\n");
   fclose(fp2);
  }
 return 0;
}/* ende von main */

void stern_berechnen(FILE *fp)
{
 Vektor3d p00,p01,p1,p2,p3,p4;
 int i, n=5; //n=Anzahl Ecken des Fuenfecks
 double L=20; //Werte in Millimeter: L=Kantenlaenge
 double r,h,h2,h3; //r=Radius, h=Hoehe, h2=Hoehe mit Kappe, h3=Hoehe unterer Kappe
 double a,b,c; //Zwischenwerte zum Hoehen ausrechnen
 double alfa,alfahalbe,sinalfa,cosalfa,sinalfahalbe,cosalfahalbe;
 alfa=360*GRAD/n; alfahalbe=alfa*0.5;
 sinalfa=sin(alfa);
 cosalfa=cos(alfa);
 sinalfahalbe=sin(alfahalbe);
 cosalfahalbe=cos(alfahalbe);
 r=L/(2*sin(alfahalbe));
 h=sqrt(0.75)*L;
 a = sqrt(r*r-L*L/4);
 c = L*0.5*sqrt(3.0);
 h3 = -sqrt(c*c-a*a);
 h2 = h - h3;

 p00.x=0;  p00.y=0;  p00.z=0;
 p01.x=0;  p01.y=0;  p01.z=h;
 if(argflag['I'] || argflag['K']) p01.z=h2;
 if(argflag['I']) p00.z=h3;
 if(argflag['V']) printf("h2 = %lf  h3 = %lf\n",h2,h3);
 p1.x= r;  p1.y= 0;  p1.z= 0;
 p2.x=p1.x; p2.y=p1.y; p2.z=h; p2.drehenxy(sinalfahalbe,cosalfahalbe);
 p3.x=p2.x; p3.y = -p2.y; p3.z=h;
 p4=p1;  p4.drehenxy(sinalfa,cosalfa);

 for(i=0;i<n;i++)
  {
   dreieck(fp,p1,p2,p3);
   dreieck(fp,p1,p4,p2);
   dreieck(fp,p1,p4,p00);
   dreieck(fp,p3,p2,p01);
   p1.drehenxy(sinalfa,cosalfa);
   p2.drehenxy(sinalfa,cosalfa);
   p3.drehenxy(sinalfa,cosalfa);
   p4.drehenxy(sinalfa,cosalfa);
  }
}

void stern_spitze_berechnen(FILE *fp)
{
 Vektor3d p0,p1,p2,p3;
 double L=20, L2=40; //Werte in Millimeter: L=Kantenlaenge, L2=lange Kante
 double h,zweidrittelh,H; //h=Hoehe im gleichseitigen Dreieck, H=Hoehe der Spitze

 h=sqrt(3.0)*L/2;
 zweidrittelh=h*2/3;
 H=sqrt(L2*L2-zweidrittelh*zweidrittelh);

 p0.x=0;   p0.y=0;   p0.z=0;
 p1.x=L;   p1.y=0;   p1.z=0;
 p2.x=L/2; p2.y=h;   p2.z=0;
 p3.x=L/2; p3.y=h/3; p3.z=H;

 dreieck(fp,p0,p2,p1);
 dreieck(fp,p0,p1,p3);
 dreieck(fp,p0,p3,p2);
 dreieck(fp,p1,p2,p3);
}
