/* stlplotter.cc			letzte Aenderung: 23.6.2013 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Aus einer Funktion z=f(x,y) eine STL-Datei erzeugen

History:
23.6.2013	Erstellung (RP) (8:04 - 9:03)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include "vektor3dklasse.cc"

/********************* Function to be plotted *************************/
/*
  Funktion die geplottet werden soll.
  Es sollte eine stetige eindeutige Funktion z=f(x,y) sein.

  Uncomment Examples and insert your own function.
 */
double f(double x,double y)
{
 double z,r;
 //z=x+y; //Example1: Schiefe Ebene
 //z=x*x+y*y; //Example2: Parabolspiegel

 /* Example3 */
 double zmax=5, rmin=0.1;
 r=sqrt(x*x+y*y);
 if(r<rmin) r=rmin;
 z = 1.0/r*sin(r);
 if(z>zmax) z=zmax;
 /* End of Example3 */

 return z;
}

double scalx=2; //Scaling factor to get millimeters in x-Axis
double scaly=2; //Scaling factor to get millimeters in y-Axis
double scalz=20; //Scaling factor to get millimeters in z-Axis

double xmin = -15.0, xmax = 15.0; //Limits for plotted area
double ymin = -15.0, ymax = 15.0; //Limits for plotted area

int nmax=30; //Number of data point in x- and y-axis

double zsocle=2; //Thickness of baseplate in millimeters

/************************* Vordeklarationen ***************************/
void stlplot(FILE *fp);

/************************* Globale Variablen **************************/
static int workbenchflag=0;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/
/*
bool istja(char *s)
{
 int c= *s;
 return (c=='j' || c=='J' || c=='y' || c=='Y');
}
*/

/*
void punkt_eingeben(const char *punktname,double *px,double *py,double *pz)
{
 printf("%s x-Wert: ",punktname); scanf("%lf",px);
 printf("%s y-Wert: ",punktname); scanf("%lf",py);
 printf("%s z-Wert: ",punktname); scanf("%lf",pz);
 printf(" %s = [ %f, %f, %f ]\n\n",punktname,*px,*py,*pz);
}
*/

/************** Klassen und Hauptteil des Programms *******************/
void dreieck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3)
{
 Vektor3d v1,v2,normalenvektor;
 v1=p2-p1;
 v2=p3-p2;
 normalenvektor=vektorkreuzprodukt(v1,v2);
 fprintf(fp," facet normal %.3f %.3f %.3f\n", normalenvektor.x, normalenvektor.y, normalenvektor.z);
 fprintf(fp,"  outer loop\n");
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x*scalx, p1.y*scaly, p1.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p2.x*scalx, p2.y*scaly, p2.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x*scalx, p3.y*scaly, p3.z*scalz);
 fprintf(fp,"  endloop\n");
 fprintf(fp," endfacet\n");
}

void viereck(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3,Vektor3d& p4)
{
 Vektor3d v1,v2,normalenvektor;
 v1=p2-p1;
 v2=p3-p2;
 normalenvektor=vektorkreuzprodukt(v1,v2);
 fprintf(fp," facet normal %.3f %.3f %.3f\n", normalenvektor.x, normalenvektor.y, normalenvektor.z);
 fprintf(fp,"  outer loop\n");
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x*scalx, p1.y*scaly, p1.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p2.x*scalx, p2.y*scaly, p2.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x*scalx, p3.y*scaly, p3.z*scalz);
 fprintf(fp,"  endloop\n");
 fprintf(fp,"  outer loop\n");
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x*scalx, p1.y*scaly, p1.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x*scalx, p3.y*scaly, p3.z*scalz);
 fprintf(fp,"   vertex %.3f %.3f %.3f\n", p4.x*scalx, p4.y*scaly, p4.z*scalz);
 fprintf(fp,"  endloop\n");
 fprintf(fp," endfacet\n");
}

void zweidreiecke(FILE *fp,Vektor3d& p1,Vektor3d& p2,Vektor3d& p3,Vektor3d& p4)
{
 dreieck(fp,p1,p2,p3);
 dreieck(fp,p1,p3,p4);
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char zielname[80],antw[40];
 FILE *fp2;
 int i,j,c;
 zielname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
   workbenchflag=1;
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(zielname,argv[i]);
	         //else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j>MAXARG)
	{printf("stlplotter  %s\n",VERSION);
	 printf("Usage: stlplotter [Destination.stl]\n");
	 printf("To use your own function change f(x,y) at beginning\n");
	 printf("and recompile the program.\n");
	 exit(0);
	}
 if(*zielname==0)
  {fp2=stdout;}
 else
  {
   //if(fp2=fopen(zielname,"r")) printf("Datei '%s' schon vorhanden. Ueberschreiben? ",zielname);
   //*antw=0; scanf("%s",&antw);
   //if(antw[0]!=='j' || ...)
   fp2=fopen(zielname,"w");
   if(fp2==NULL) {printf("couldnt create '%s'\n",zielname); exit(0);}
  }
 stlplot(fp2);
 if(*zielname!=0) fclose(fp2);
 return 0;
}/* ende von main */

void stlplot(FILE *fp)
{
 int n,jx,jy;
 double x,y,dx,dy,zmin=0;
 Vektor3d p1,p2,p3,p4,q1,q2,q3,q4;
 char antw[80];
 dy=(ymax-ymin)/nmax;
 dx=(xmax-xmin)/nmax;
 fprintf(fp,"solid unnamed\n");
 //Flaeche der Funktion:
 for(jy=0,y=ymin;jy<nmax;jy++,y+=dy)
  {
   for(jx=0,x=xmin;jx<nmax;jx++,x+=dx)
    {
     p1.x=x;    p1.y=y;    p1.z=f(x,y);
     p2.x=x+dx; p2.y=y;    p2.z=f(p2.x,p2.y);
     p3.x=x+dx; p3.y=y+dy; p3.z=f(p3.x,p3.y);
     p4.x=x;    p4.y=y+dy; p4.z=f(p4.x,p4.y);
     zweidreiecke(fp,p1,p2,p3,p4);
     if(p1.z<zmin) zmin=p1.z;
     if(p2.z<zmin) zmin=p2.z;
     if(p3.z<zmin) zmin=p3.z;
     if(p4.z<zmin) zmin=p4.z;
    }
  }
 zmin -= zsocle/scalz;
 //Grundflaeche:
 p1.x=xmin; p1.y=ymin; p1.z=zmin;
 p2.x=xmax; p2.y=ymin; p2.z=zmin;
 p3.x=xmax; p3.y=ymax; p3.z=zmin;
 p4.x=xmin; p4.y=ymax; p4.z=zmin;
 viereck(fp,p1,p4,p3,p2);
 //vordere Seitenflache in x-z-Ebene:
 y=ymin;
 for(jx=0,x=xmin;jx<nmax;jx++,x+=dx)
  {
   q1.x=x;    q1.y=y; q1.z=zmin;
   q2.x=x+dx; q2.y=y; q2.z=zmin;
   q3.x=x+dx; q3.y=y; q3.z=f(q3.x,q3.y);
   q4.x=x;    q4.y=y; q4.z=f(q4.x,q4.y);
   viereck(fp,q1,q2,q3,q4);
  }
 //hintere Seitenflache in x-z-Ebene:
 y=ymax;
 for(jx=0,x=xmin;jx<nmax;jx++,x+=dx)
  {
   q1.x=x;    q1.y=y; q1.z=zmin;
   q2.x=x+dx; q2.y=y; q2.z=zmin;
   q3.x=x+dx; q3.y=y; q3.z=f(q3.x,q3.y);
   q4.x=x;    q4.y=y; q4.z=f(q4.x,q4.y);
   viereck(fp,q1,q4,q3,q2);
  }
 //vordere Seitenflache in y-z-Ebene:
 x=xmax;
 for(jy=0,y=ymin;jy<nmax;jy++,y+=dy)
  {
   q1.x=x; q1.y=y;    q1.z=zmin;
   q2.x=x; q2.y=y+dy; q2.z=zmin;
   q3.x=x; q3.y=y+dy; q3.z=f(q3.x,q3.y);
   q4.x=x; q4.y=y;    q4.z=f(q4.x,q4.y);
   viereck(fp,q1,q2,q3,q4);
  }
 //hintere Seitenflache in y-z-Ebene:
 x=xmin;
 for(jy=0,y=ymin;jy<nmax;jy++,y+=dy)
  {
   q1.x=x; q1.y=y;    q1.z=zmin;
   q2.x=x; q2.y=y+dy; q2.z=zmin;
   q3.x=x; q3.y=y+dy; q3.z=f(q3.x,q3.y);
   q4.x=x; q4.y=y;    q4.z=f(q4.x,q4.y);
   viereck(fp,q1,q4,q3,q2);
  }
 fprintf(fp,"endsolid unnamed\n");
}
