/* astlprog.cc			letzte Aenderung: 21.6.2013 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: STL-Dateien erzeugen durch Eingabe von xyz-Werten

History:
21.6.2013	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include "vektor3dklasse.cc"

/************************* Vordeklarationen ***************************/
void unterprog(FILE *fp);

/************************* Globale Variablen **************************/
static int workbenchflag=0;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/
bool istja(char *s)
{
 int c= *s;
 return (c=='j' || c=='J' || c=='y' || c=='Y');
}

void punkt_eingeben(const char *punktname,double *px,double *py,double *pz)
{
 printf("%s x-Wert: ",punktname); scanf("%lf",px);
 printf("%s y-Wert: ",punktname); scanf("%lf",py);
 printf("%s z-Wert: ",punktname); scanf("%lf",pz);
 printf(" %s = [ %f, %f, %f ]\n\n",punktname,*px,*py,*pz);
}

/************** Klassen und Hauptteil des Programms *******************/

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char zielname[80],antw[40];
 FILE *fp2;
 int i,j,c;
 zielname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
   workbenchflag=1;
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(zielname,argv[i]);
	         //else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j>MAXARG)
	{printf("stlprog  %s\n",VERSION);
	 printf("Anwendung: stlprog [Ziel.stl]\n");
	 exit(0);
	}
 if(*zielname==0)
  {fp2=stdout;}
 else
  {
   //if(fp2=fopen(zielname,"r")) printf("Datei '%s' schon vorhanden. Ueberschreiben? ",zielname);
   //*antw=0; scanf("%s",&antw);
   //if(antw[0]!=='j' || ...)
   fp2=fopen(zielname,"w");
   if(fp2==NULL) {printf("konnte '%s' nicht erstellen.\n",zielname); exit(0);}
  }
 unterprog(fp2);
 if(*zielname!=0) fclose(fp2);
 return 0;
}/* ende von main */

void unterprog(FILE *fp)
{
 int n,j;
 Vektor3d p1,p2,p3,p4,v1,v2,normalenvektor;
 char antw[80];
 fprintf(fp,"solid unnamed\n");
 for(;;)
  {
   printf("Auswahlmenu:\n");
   printf("1: Help\n");
   printf("3: Dreieck eingeben\n");
   printf("4: Viereck eingeben\n");
   printf("0: Ende\n");
   printf("Auswahl: "); scanf("%d",&n);
   if(n==0) break;
   else if(n==3)
    {
     punkt_eingeben("P1",&p1.x,&p1.y,&p1.z);
     punkt_eingeben("P2",&p2.x,&p2.y,&p2.z);
     punkt_eingeben("P3",&p3.x,&p3.y,&p3.z);
     v1=p2-p1;
     v2=p3-p2;
     normalenvektor=vektorkreuzprodukt(v1,v2);
     fprintf(fp," facet normal %.3f %.3f %.3f\n", normalenvektor.x, normalenvektor.y, normalenvektor.z);
     fprintf(fp,"  outer loop\n");
     fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x, p1.y, p1.z);
     fprintf(fp,"   vertex %.3f %.3f %.3f\n", p2.x, p2.y, p2.z);
     fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x, p3.y, p3.z);
     fprintf(fp,"  endloop\n");
     fprintf(fp," endfacet\n");
    }
   else if(n==4)
    {
     punkt_eingeben("P1",&p1.x,&p1.y,&p1.z);
     punkt_eingeben("P2",&p2.x,&p2.y,&p2.z);
     punkt_eingeben("P3",&p3.x,&p3.y,&p3.z);
     punkt_eingeben("P4",&p4.x,&p4.y,&p4.z);
     v1=p2-p1;
     v2=p3-p2;
     normalenvektor=vektorkreuzprodukt(v1,v2);
     fprintf(fp," facet normal %.3f %.3f %.3f\n", normalenvektor.x, normalenvektor.y, normalenvektor.z);
     fprintf(fp,"  outer loop\n");
     fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x, p1.y, p1.z);
     fprintf(fp,"   vertex %.3f %.3f %.3f\n", p2.x, p2.y, p2.z);
     fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x, p3.y, p3.z);
     fprintf(fp,"  endloop\n");
     fprintf(fp,"  outer loop\n");
     fprintf(fp,"   vertex %.3f %.3f %.3f\n", p1.x, p1.y, p1.z);
     fprintf(fp,"   vertex %.3f %.3f %.3f\n", p3.x, p3.y, p3.z);
     fprintf(fp,"   vertex %.3f %.3f %.3f\n", p4.x, p4.y, p4.z);
      fprintf(fp,"  endloop\n");
     fprintf(fp," endfacet\n");
    }
   else //n==1 fuer Help
    {
     printf("Punkte muessen jeweils von aussen gesehen im Gegenuhrzeigersinn eingegeben werden.\n");
     printf("Wenn in falscher Reihenfolge eingegeben, kann es korrigiert werden indem man die\n");
     printf("STL-Datei editiert und den Normalenvektor umkehrt.\n");
    }
  }
 fprintf(fp,"endsolid unnamed\n");
}
