/* machsudoku.cc			letzte nderung: 1.3.2009 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 automatisches Erstellen von Sudoku-Raetseln

History:
1.3.2009	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/************************* Globale Variablen **************************/
static int feld[9][9], feld2[9][9];
static int zufallstartzahl=0;

/************************* Vordeklarationen ***************************/

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='Z') sscanf(s,"%d",&zufallstartzahl);
  }
}

/*************************** kleinkram ***************************/
double zufall4()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

void init_zufall4(int n)
{
 n=n%10000;
 for(int i=0;i<n;i++) zufall4();
}

int zufall09() //Zufallszahl zwischen 0 und 9 (mit 0, ohne 9)
{
 int n=int(zufall4()*9);
 if(n==9) n=8;
 return n;
}

/************************ sudoku-Routinen ************************/
bool sudokucheck()
{
 int i,j,k,i2,j2,i3,j3,n,ok,flag;
 for(j=0;j<9;j++)
 for(i=0;i<9;i++)
    if((n=feld2[i][j])!=0)
	{for(k=0;k<9;k++)
	        {if(k!=i && feld2[k][j]==n) return false;
		 if(k!=j && feld2[i][k]==n) return false;
		}
	 for(i2=i/3*3,i3=i2+3;i2<i3;i2++)
	  for(j2=j/3*3,j3=j2+3;j2<j3;j2++)
		if((i2!=i || j2!=j) && feld2[i2][j2]==n) return false;
	}
 return true;
}

int sudokuloesungen(int* nloesungen,int max)
{
 int i,j,k,i2,j2,i3,j3,n,ok,flag;
 for(j=0;j<9;j++)
 for(i=0;i<9;i++)
     if(feld2[i][j]==0)
	{for(n=1;n<=9;n++)
	   {flag=0;
	    for(k=0;k<9;k++)
		{if(k!=i && feld2[k][j]==n) {flag=1; break;}
		 if(k!=j && feld2[i][k]==n) {flag=1; break;}
		}
	    if(flag==0)
	      for(i2=i/3*3,i3=i2+3;i2<i3;i2++)
	       for(j2=j/3*3,j3=j2+3;j2<j3;j2++)
		 if((i2!=i || j2!=j) && feld2[i2][j2]==n) {flag=1; break;}
	    if(flag==0)
	     {feld2[i][j]=n;
	      ok=sudokuloesungen(nloesungen,max);
	      if(ok && *nloesungen>=max) return 1;
	      feld2[i][j]=0;
	     }
	   }
	 return 0;
	}
 (*nloesungen)++;
 return 1;
}

void printfeld()
{
 int i,j;
 for(j=0;j<9;j++)
  {for(i=0;i<9;i++)
    {printf("%d",feld[i][j]);
     if(i==8) printf("\n");
     else if(i%3==2) printf("  ");
     else printf(" ");
    }
   if(j%3==2) printf("\n");
  }
}

void feldkopieren(int quelle[][9],int ziel[][9])
{
 int i,j;
 for(j=0;j<9;j++)
  for(i=0;i<9;i++)
    ziel[i][j]=quelle[i][j];
}

int anzahlloesungen(int max)
{
 int n=0;
 feldkopieren(feld,feld2);
 if(sudokucheck()==false) return 0;
 sudokuloesungen(&n,max);
 return n;
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80];
 FILE *fp;
 int i,j,c,k,m=0,n;
 quellname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("machsudoku  %s\n",VERSION);
	 printf("Anwendung: Machsudoku [-Flags] [startstellung] >ziel.txt\n");
	 printf("  Flags: z1234 = Zufallszahl Startzahl\n");
	 exit(0);
	}
 if(*quellname!=0 && (fp=fopen(quellname,"r"))!=NULL)
   {for(j=0;j<9;j++)
       for(i=0;i<9;i++)
	   fscanf(fp,"%d",&feld[i][j]);
    fclose(fp);
   }
 else
   {for(j=0;j<9;j++)
     for(i=0;i<9;i++)
	   feld[i][j]=0;
   }
 init_zufall4(zufallstartzahl);
 while((n=anzahlloesungen(2))>1)
 {for(n=0,m=0;n==0 && m<1000;m++)
   {for(k=0;k<281;k++)
      {if(k<200) {j=zufall09(); i=zufall09();}
       else {j=(k-200)/9; i=(k-200)%9;}
       if(feld[i][j]==0) break;
      }
    for(k=0;k<30;k++)
      {if(k<21) feld[i][j]=zufall09()+1;
       else feld[i][j]=k-20;
       n=anzahlloesungen(2);
       if(n>0) break;
      }
    if(n==0) feld[i][j]=0;
   }
 }
 if(m>1000) printf("Fehler: kein Resultat nach m=%d Durchlaeufen\n",m);//test
 else fprintf(stderr,"Ergebnis nach m=%d Durchlaeufen. n=%d\n",m,n);//test
 printfeld();
 return 0;
}/* ende von main */
