/* Sudoku1.cc			letzte nderung: 1.3.2000 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 automatisches Loesen von Sudoku-Raetseln, nur 1.Loesung

History:
23.2.2006	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/************************* Globale Variablen **************************/
static int feld[9][9], loesungsfeld[9][9];

/************************* Vordeklarationen ***************************/
int sudokuloesen();

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80];
 FILE *fp;
 int i,j,c;
 quellname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("sudoku  %s\n",VERSION);
	 printf("Anwendung: Sudoku startstellung\n");
	 exit(0);
	}
 if(*quellname==0) {printf("Dateiname der Startstellung:"); scanf("%s",quellname);}
 int ok;
 if(fp=fopen(quellname,"r"))
   {for(j=0;j<9;j++)
       for(i=0;i<9;i++)
	   fscanf(fp,"%d",&feld[i][j]);
    fclose(fp);
    ok=sudokuloesen();
    if(ok==0) printf("Es gibt fuer diese Stellung keine Loesung.\n");
    else 
      {printf("Die Loesung:\n");
       for(j=0;j<9;j++)
	{for(i=0;i<9;i++)
	   {printf("%d ",feld[i][j]);
	    if(i==2 || i==5) printf(" ");
	   }
	 printf("\n");
	 if((j+1)%3==0) printf("\n");
	}
      }
   }
 else printf("Datei '%s' nicht gefunden.\n",quellname);
 return 0;
}/* ende von main */

int sudokuloesen()
{
 int i,j,k,i2,j2,n,ok,flag;
 for(j=0;j<9;j++)
 for(i=0;i<9;i++)
     if(feld[i][j]==0)
	{for(n=1;n<=9;n++)
	   {flag=0;
	    for(k=0;k<9;k++)
		{if(k!=i && feld[k][j]==n) {flag=1; break;}
		 if(k!=j && feld[i][k]==n) {flag=1; break;}
		}
	    if(flag==0)
	      for(i2=i/3*3;i2<i/3*3+3;i2++)
	      for(j2=j/3*3;j2<j/3*3+3;j2++)
		if((i2!=i || j2!=j) && feld[i2][j2]==n) {flag=1; break;}
	    if(flag==0)
	     {feld[i][j]=n;
	      ok=sudokuloesen();
	      if(ok) return 1;
	      feld[i][j]=0;
	     }
	   }
	 return 0;
	}
 return 1;
}
