/* printsudoku.cc			letzte nderung: 28.2.2009 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 automatisches Loesen von Sudoku-Raetseln mit total allen Loesungen

History:
28.2.2009	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/************************* Globale Variablen **************************/
static int feld[9][9], loesungsfeld[9][9];

/************************* Vordeklarationen ***************************/
int sudokuloesentotal(int* n);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 FILE *fp;
 int i,j,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
	         else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("printsudoku %s\n",VERSION);
	 printf("Anwendung: printsudoku [-Flags] stellung [test.ps]\n");
	 printf("  Flags: e=EPS-Datei erstellen, (sonst PS-Datei)\n");
	 exit(0);
	}
 if(*quellname==0) {printf("Dateiname der Stellung:"); scanf("%s",quellname);}
 if(*zielname==0) {strcpy(zielname,"test.ps");}
 int ok,n=0;
 if(fp=fopen(quellname,"r"))
   {for(j=0;j<9;j++)
       for(i=0;i<9;i++)
	   fscanf(fp,"%d",&feld[i][j]);
    fclose(fp);
    fp=fopen(zielname,"w");
    if(fp==NULL) {printf("kann %s nicht erstellen.\n",zielname); exit(0);}
    fprintf(fp,"%%!PS-Adobe-2.0 EPSF-1.2\n");
    fprintf(fp,"%%%%Creator: printsudoku 0.0\n");
    if(argflag['E']) fprintf(fp,"%%%%BoundingBox: 140 395 455 705\n");
    else fprintf(fp,"%%%%BoundingBox: 0 0 596 843\n");
    for(int y0=50;y0 > -400;y0-=400) {
    fprintf(fp,"%%Objektbox: 149 419 451 731\n");
    fprintf(fp,"gsave\n");
    fprintf(fp,"0 %d translate\n",y0);
    fprintf(fp,"3 setlinewidth\n");
    fprintf(fp,"150 400 moveto 450 400 lineto\n");
    fprintf(fp,"450 700 lineto\n");
    fprintf(fp,"150 700 lineto\n");
    fprintf(fp,"closepath\n");
    fprintf(fp,"stroke\n");
    fprintf(fp,"150 500 moveto 450 500 lineto stroke\n");
    fprintf(fp,"150 600 moveto 450 600 lineto stroke\n");
    fprintf(fp,"250 400 moveto 250 700 lineto stroke\n");
    fprintf(fp,"350 400 moveto 350 700 lineto stroke\n");
    fprintf(fp,"150 500 moveto 450 500 lineto stroke\n");
    fprintf(fp,"1 setlinewidth\n");
    fprintf(fp,"150 433 moveto 450 433 lineto stroke\n");
    fprintf(fp,"150 467 moveto 450 467 lineto stroke\n");
    fprintf(fp,"150 533 moveto 450 533 lineto stroke\n");
    fprintf(fp,"150 567 moveto 450 567 lineto stroke\n");
    fprintf(fp,"150 633 moveto 450 633 lineto stroke\n");
    fprintf(fp,"150 667 moveto 450 667 lineto stroke\n");
    fprintf(fp,"\n");
    fprintf(fp,"183 400 moveto 183 700 lineto stroke\n");
    fprintf(fp,"217 400 moveto 217 700 lineto stroke\n");
    fprintf(fp,"283 400 moveto 283 700 lineto stroke\n");
    fprintf(fp,"317 400 moveto 317 700 lineto stroke\n");
    fprintf(fp,"383 400 moveto 383 700 lineto stroke\n");
    fprintf(fp,"417 400 moveto 417 700 lineto stroke\n");
    fprintf(fp,"grestore\n");
    fprintf(fp,"%%Objektende\n");
    fprintf(fp,"%%Objektbox: 195 675 202.944 695.232\n");
    fprintf(fp,"save\n");
    fprintf(fp,"0 %d translate\n",y0);
    fprintf(fp,"/Helvetica findfont 30 scalefont setfont\n");
    fprintf(fp,"160 673 translate\n");
    fprintf(fp,"0.825 1 scale\n");
    for(j=0;j<9;j++)
      for(i=0;i<9;i++)
       {if((n=feld[i][j])!=0)
	  fprintf(fp,"%d %d moveto (%d) show\n",40*i,-33*j,n);
       }
    fprintf(fp,"restore\n");
    fprintf(fp,"%%Objektende\n");
    } //ende for-Schlaufe
    if(!argflag['E'])
      {fprintf(fp,"showpage\n"); printf("EPS-Datei");}
    else printf("PS-Datei");
    fclose(fp);
    printf(" '%s' erstellt.\n",zielname);
   }
 else printf("Datei '%s' nicht gefunden.\n",quellname);
 return 0;
}/* ende von main */
