/* sudoku.cc			letzte nderung: 1.3.2009 */
#define VERSION "Version 1.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 automatisches Loesen von Sudoku-Raetseln mit total allen Loesungen

History:
23.2.2006	Erstellung (RP)
1.3.2009   1.0  Option N (Flags) eingefuegt
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/************************* Globale Variablen **************************/
static int feld[9][9], loesungsfeld[9][9];

/************************* Vordeklarationen ***************************/
int sudokuloesentotal(int* n);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80];
 FILE *fp;
 int i,j,c;
 quellname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("sudoku  %s\n",VERSION);
	 printf("Anwendung: Sudoku [-Flags] startstellung\n");
	 printf("  Flags: Q = Quiet, ohne Ausdrucke - nur Anzahl Loesungen\n");
	 printf("         N = nur erste Loesung suchen\n");
	 exit(0);
	}
 if(*quellname==0) {printf("Dateiname der Startstellung:"); scanf("%s",quellname);}
 int ok,n=0;
 if(fp=fopen(quellname,"r"))
   {for(j=0;j<9;j++)
       for(i=0;i<9;i++)
	   fscanf(fp,"%d",&feld[i][j]);
    fclose(fp);
    ok=sudokuloesentotal(&n);
    if(n>0)
     {if(!argflag['N'])
       {if(n==1) printf("Es gibt nur eine einzige Loesung.\n");
	else printf("Es wurden %d Loesungen gefunden.\n",n);
       }
     }
    else printf("Es gibt keine Loesung.\n");
   }
 else printf("Datei '%s' nicht gefunden.\n",quellname);
 return 0;
}/* ende von main */

int sudokuloesentotal(int* nloesungen)
{
 int i,j,k,i2,j2,n,ok,flag;
 for(j=0;j<9;j++)
 for(i=0;i<9;i++)
     if(feld[i][j]==0)
	{for(n=1;n<=9;n++)
	   {flag=0;
	    for(k=0;k<9;k++)
		{if(k!=i && feld[k][j]==n) {flag=1; break;}
		 if(k!=j && feld[i][k]==n) {flag=1; break;}
		}
	    if(flag==0)
	      for(i2=i/3*3;i2<i/3*3+3;i2++)
	      for(j2=j/3*3;j2<j/3*3+3;j2++)
		if((i2!=i || j2!=j) && feld[i2][j2]==n) {flag=1; break;}
	    if(flag==0)
	     {feld[i][j]=n;
	      ok=sudokuloesentotal(nloesungen);
	      if(ok && argflag['N']) return 1;
	      feld[i][j]=0;
	     }
	   }
	 return 0;
	}
 (*nloesungen)++;
 if(!argflag['Q'] || (*nloesungen%1000000)==0)
 {printf("%d. Loesung:\n",*nloesungen);
  for(j=0;j<9;j++)
  {for(i=0;i<9;i++)
     {printf("%2d",feld[i][j]);
      if(i%3==2) printf(" ");
     }
  if(j%3==2) printf("\n\n");
  else printf("\n");
  }
 }
 return 1;
}
