/* zufall_hard.cc

Verwendung: in C-Programm mit so einfuegen:
#include "zufall_hard.cc"

History:
7.11.2009	Aus rndcheck.cc extrahiert

*/

/*********************** Serielle Schnittstelle ***********************/
//#include <stdio.h>
//#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <termios.h>
#include <unistd.h>
static char sername[80]="/dev/ttyS0";
static int baudrate=0;
static int fdr,fdw;

static int baudcodliste[]={50,B50, 75,B75, 110,B110, 134,B134, 150,B150,
   300,B300, 600,B600, 1200,B1200, 1800,B1800, 2400,B2400, 4800,B4800,
   9600,B9600, 19200,B19200, 38400,B38400,
   57600,B57600, 115200,B115200,
   230400,B230400, 460800,B460800, 500000,B500000, 576000,B576000,
   921600,B921600, 1000000,B1000000, 1152000,B1152000, 1500000,B1500000,
   2000000,B2000000, 2500000,B2500000, 3000000,B3000000, 3500000,B3500000,
   4000000,B4000000, 0,0};

int ibaud(int x) //Baudcode in Baudrate umrechnen
{
 int *co,a;
 for(co=baudcodliste;(a= *co++)!=0;co++)
    if(x== *co) return a;
 fprintf(stderr,"Fehler: unbekannter Baudratecode %d\n",x);
 return 0;
}
int baudi(int x) //Baudrate in Baudcode umrechnen
{
 int *co,b,min=0;
 for(co=baudcodliste;(b= *co++)>0;co++)
     if(x==b) return *co;
     else if(x>b) {min= *co;}
 fprintf(stderr,"Warnung: unbekannte Baudrate %d, auf %d abgerundet\n",x,min);
 return min;
}

void noecho(int fd)
{
 struct termios buf;
 if(tcgetattr(fd,&buf)<0)
  {fprintf(stderr,"tcgetattr() Error\n"); return;}
 buf.c_lflag &= ~ECHO;
 if(baudrate!=0)
     {cfsetispeed(&buf,baudi(baudrate));
      cfsetospeed(&buf,baudi(baudrate));
     }
 if(tcsetattr(fd,TCSAFLUSH,&buf)<0)
  {fprintf(stderr,"tcsetattr() Error\n"); return;}
 int a=cfgetispeed(&buf),b=cfgetospeed(&buf);
 fprintf(stderr,"Baudraten: %d %d\n",ibaud(a),ibaud(b));//test
}
void seriell_open()
{
 int mode=0;
 fdr=open(sername,O_RDWR|mode);
 if(fdr<0) {fprintf(stderr,"Fehler: fdr = %d\n",fdr); exit(0);}
	   //wenn dieser Fehler kommt sollte /dev/ttyS0 ueberprueft werden
	   //Zugriffsberechtigung freigeben: chmod a+rw /dev/ttyS0
	   //oder vielleicht /dev/ttyS1
 noecho(fdr);
 fdw=fdr;
}
void seriell_close()
{
 close(fdr);
}
void seriell_readline(char *str,int max)
{
 int i;
 char *s,c;
 for(i=1,s=str;i<max;)
   {read(fdr,&c,1);
    if(c=='\n') break;
    if(c==0) fprintf(stderr,"Null-Zeichen empfangen\n");//test
    else
      {*s++ = c; i++;}
   }
 if(s!=str && s[-1] == '\r') {--s; fprintf(stderr,"CR empfangen\n");}
 *s=0;
}
void seriell_writeline(char *str)
{
 int n=strlen(str);
 char *wbuf=new char[n+3];
 if(argflag['C']) sprintf(wbuf,"%s\r\n",str);
 else sprintf(wbuf,"%s\n",str);
 write(fdw,wbuf,n+1);
 delete wbuf;
}

double zufall_hardware() //Zufallszahl zwischen 0.0 und 1.0 auf nstellen genau
{
 int c=0,c2,i;
 const int nstellen=6;
 const int imax=(nstellen*10+17)/18; // n/log(64) aufgerundet
 double z=0,fak=1.0/64;

 for(i=0;i<imax;i++,fak/=64)
   {do
     {read(fdr,&c,1);  c2=c-0x21;
      //printf("c=0x%02X='%c'\n",c,c);//test
      //if(c2>=63 || c2<0) printf("c=0x%02X='%c'\n",c,c);//test
     }
    while(c2<0 || c2>63);
    z += c2*fak;
   }
 //printf("zufall_hardware() --> %lf\n",z);//test

 if(z>=1.0) fprintf(stderr,"Zufallszahl zu gross: z=%lf\n",z);//test
 return z;
}
