/* Blaues 4-Zeilen-LCD ansteuern        letzte Aenderung: 19.9.2010

 Autor: Rolf Pfister
 Copyright: Freeware
 History:
 19.9.2010	Erstellung aus bahn-0.01.cc,
                defines zum Auswaehlen des Ports angefuegt
		in lcd_goto() korrektur fuer Zeichenposition >16
*/

/**** LCD-Ansteuerung ****/
/*
 PORT   LCD-Pin
 GND    VSS
 +5V    VDD
	RES (L=reset, auf +5V gesetzt)
	RW (H=read, L=write, auf GND gesetzt)
 D2     RS (H=Daten, L=Befehl)
 D3     E (Enable)
 D4..D7 D4..D7
        BLA ueber 470 Ohm auf +5V (Hintergrundbeleuchtung immer ein)
        BLK auf GND gesetzt
	VCI uber 470 Ohm + 2.2kOhm Trimmer nach +5V (Kontrast)
 */

#define LCD_PORT PORTA
#define LCD_DDR DDRA

/** schon im Hauptprogramm:
void milliwait(int n);
char microwait(int n) //etwa n Microsekunden warten
{
 char vx=0;
 while(n>0)
  {vx+=n; --n;}
 return vx;
}
**/

void lcd_send(char data)
{
 char rs=LCD_PORT;
 rs &= 4;
 // High-Teil senden:
 char tmp=data;
 tmp &= 0xF0;
 tmp |= rs;
 LCD_PORT=tmp;
 microwait(1);
 LCD_PORT |= (1<<3); //sbi(PORTD,3);
 microwait(1);
 LCD_PORT &= ~(1<<3); //cbi(PORTD,3);
 // Low-Teil senden:
 tmp=data;
 tmp &= 0x0F;
 tmp <<= 4;
 tmp |= rs;
 LCD_PORT=tmp;
 microwait(1);
 LCD_PORT |= (1<<3); //sbi(LCD_PORT,3);
 microwait(1);
 LCD_PORT &= ~(1<<3); //cbi(LCD_PORT,3);
 milliwait(2);
}

void lcd_cmd(char cmd)
{
 LCD_PORT &= ~(1<<2); //cbi(LCD_PORT,2);
 lcd_send(cmd);
}
void lcd_clear()
{
 lcd_cmd(0x01); milliwait(2);
}
void lcd_home()
{
 lcd_cmd(0x02); milliwait(2);
}
void lcd_on() {lcd_cmd(0x0E);}
void lcd_off() {lcd_cmd(0x08);}

void lcd_write(char c)
{
 LCD_PORT |= (1<<2); //sbi(LCD_PORT,2);
 lcd_send(c);
}
void lcd_write(const char *text)
{
 char c;
 while((c= *text++)!=0)
  lcd_write(c);
}

void lcd_init()
{
 LCD_DDR=0xFC; //Obere 6 Bits auf Ausgang
 LCD_PORT=0;
 milliwait(50); //Warten bis LCD-Controller gebootet hat
 LCD_PORT=0x20; //4-Bit-Modus einschalten
 microwait(1);
 LCD_PORT |= (1<<3); //sbi(LCD_PORT,3); //Enable-Impuls
 microwait(1);
 LCD_PORT &= ~(1<<3); //cbi(LCD_PORT,3);
 milliwait(5);

 // Funktions-Set: 2 Zeilen-Display, 5*7 Matrix, 4Bit
 //lcd_cmd(0x28);

 //speziell fuer das 4-Zeilige Display EA DIP204-6:
 lcd_cmd(0x06); //Cursor Auto-increment
 lcd_cmd(0x26); //RE-Bit setzen
 lcd_cmd(0x09); //4-Zeilen-Modus
 lcd_cmd(0x40); //Icon-RAM Adresse auf 0x00 setzen
 for(char i=0;i<16;i++) lcd_write('\0'); //alle Icons aus
 lcd_cmd(0x20); //RE-Bit loeschen

 lcd_off();
 lcd_clear();
 // Entry Mode
 lcd_cmd(0x06);
 lcd_on();
}

void lcd_goto(int row,int col)
{
 row--;
 row &= 0x03; //nur Zeile 0 bis 3 zulassen
 row <<= 5; //Zeile nach Bit 5 bringen
 col--;
 col &= 0x1F; //nur Bereich 0 bis 31 zulassen
 char tmp=row|col; //Adresse bilden
 tmp |= 0x80; //Cursor setzen
 lcd_cmd(tmp);
}
