/* mgkernf2.c		Version 2.03		letzte Aenderung: 13.4.2012

Molekulargewicht-Berechnung: Allgemeiner Teil zum Einfuegen im Hauptprogramm

Aenderungen:
11.4.2012    Erstellung aus mgkernf.c, das automatisch aus mgkern.c erstellt wurde.
             Versuch zur Optimierung auf wenig RAM-Verbrauch auf Microcontroller
11.4.12      Selten gebrauchte Elemente provisorisch auskommentiert
13.4.12      Tabellen mgtabelle[] und mgtabelle_iso[] in einer zusammgefasst


*/
//#define FLIESSZAHLKLASSE
//#define SUMMENFORMELN

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "mgkern.h"

int klammertest(const char *text)
{
 int k1=0,k2=0,c;
 for(;*text!=0;)
   {c= *text++;
    if(c=='(') k1++; else if(c==')') --k1;
    else if(c=='[') k2++; else if(c==']') --k2;
   }
 if(k1!=0) return k1;
 return k2;
}

#ifdef SUMMENFORMELN
/** Diese Variante fuer Anpassung an Option fuer Summenformelausgabe: **/
#ifdef __cplusplus
struct Abkuerzungen {const char *sym; const char *summenformel;};
#else
struct _Abkuerzungen {const char *sym; const char *summenformel;};
typedef struct _Abkuerzungen Abkuerzungen;
#endif
static Abkuerzungen aminos[]=
 {
  {"Ala", "C3H5NO"}, //'A'
  {"Aib", "C4H7NO"}, //'B'
  {"Cys", "C3H5NOS"}, //'C'
  {"Asp", "C4H5NO3"}, //'D'
  {"Glu", "C5H7NO3"}, //'E'
  {"Phe", "C9H9NO"}, //'F'
  {"Gly", "C2H3NO"}, //'G'
  {"His", "C6H7N3O"}, //H
  {"Ile", "C6H11NO"}, //I
  {"Aha", "C4H6N4O"}, //J
  {"Lys", "C6H12N2O"}, //K
  {"Leu", "C6H11NO"}, //L
  {"Met", "C5H9NOS"}, //M
  {"Asn", "C4H6N2O2"}, //N
  {"Oxx", ""}, //O
  {"Pro", "C5H7NO"}, //P
  {"Gln", "C5H8N2O2"}, //Q
  {"Arg", "C6H12N4O"}, //R
  {"Ser", "C3H5NO2"}, //S
  {"Thr", "C4H7NO2"}, //T
  {"Uxx", ""}, //U
  {"Val", "C5H9NO"}, //V
  {"Trp", "C11H10N2O"}, //W
  {"Xxx", ""},        //'X' 
  {"Tyr", "C9H9NO2"}, //'Y'
  {"Zxx", ""}         //'Z'
 };
#else
/** Einfachere Variante wenn keine Summenformeln gebraucht werden: **/
static const char* aminos[]=
 {
  "Ala", //'A'
  "Aib", //'B'
  "Cys", //'C'
  "Asp", //'D'
  "Glu", //'E'
  "Phe", //'F'
  "Gly", //'G'
  "His", //H
  "Ile", //I
  "Aha", //J
  "Lys", //K
  "Leu", //L
  "Met", //M
  "Asn", //N
  "Oxx", //O
  "Pro", //P
  "Gln", //Q
  "Arg", //R
  "Ser", //S
  "Thr", //T
  "Uxx", //U
  "Val", //V
  "Trp", //W
  "Xxx", //'X' 
  "Tyr", //'Y'
  "Zxx"  //'Z'
 };
#endif

const char *einbuchstaben_auf_dreibuchstaben_abkuerzung_erweitern(int c)
{
 const char *peptid;
#ifdef SUMMENFORMELN
 peptid=aminos[c-'A'].sym;
#else
 peptid=aminos[c-'A'];
#endif
 return peptid;
}

int dreibuchstaben_auf_einbuchstaben_abkuerzung_reduzieren(const char *peptid)
{
 int c;
 for(c='A';c<='Z';c++)
  {
#ifdef SUMMENFORMELN
   if(strcmp(peptid,aminos[c-'A'].sym)==0) return c;
#else
   if(strcmp(peptid,aminos[c-'A'])==0) return c;
#endif
  }
 return 0;
}

void formel_normieren(const char *quelle,char *ziel,int imax,int jmax)
{
 /* Sonderzeichen ~ zum Umschalten auf Kurzschreibweise von Peptidketten
    werden hier entfernt und die Peptide auf die 3-Buchstabenschreibweise
    erweitert. Zudem noch allfaellige Leerzeichen entfernt.
 */
 int i,j,c,modus=0; //modus: 0=normal, 1=PeptidKette
 const char *peptid;
 for(i=1,j=4;i<imax && (c= *quelle++)!=0 && j<jmax;i++)
   {
    if(c & 0x80) {fehler0("Sonderzeichen ignoriert",c);}
    else if(c=='~') {modus ^= 1; *ziel++ = '-'; j++;}
    else if(c==' ' || c=='\n' || c=='\t') ;//Leerzeichen entfernen
    else if(modus==1)
     {
#ifdef SUMMENFORMELN
      peptid = (c>='A' && c<='Z') ? aminos[c-'A'].sym : NULL;
#else
      peptid = (c>='A' && c<='Z') ? aminos[c-'A'] : NULL;
#endif
      if(peptid!=NULL) {*ziel++ = peptid[0]; *ziel++ = peptid[1]; j+=2; c=peptid[2];}
      *ziel++ = c; j++;
     }
    else /*if(modus==normal)*/
      {*ziel++ = c; j++;}
   }
 *ziel=0;
}

inline bool isfirstformelzeichen(char c)
{
 return (isupper(c) || c=='(' || c=='[' || c=='^');
}

bool ist_leer(char c)
{
 return (c=='-' || c=='=' || c=='_');
}

bool isformelzeichen(char c)
{
 return (isfirstformelzeichen(c) || islower(c) || ist_leer(c)
	 || c==')' || c==']');
}

#ifdef __cplusplus
struct mgtab {const char *symbol; const char *wert,*wertiso;};
#else
struct _mgtab {const char *symbol; const char *wert,*wertiso;};
typedef struct _mgtab mgtab;
#endif
mgtab mgtabelle[]=
  {
    {"Ace", "43.04522", "43.018375"}, //Acethyl (H3C-C=O)
    {"Ac", "227.0278",  "227.0278" }, //Actinium
//    {"Ag", "107.8682", "106.90497" },
    {"Ala", "71.0788",  "71.037095"},
//    {"Al",  "26.9815",  "26.9815" }, //Aluminium
    {"Aib", "85.10568", "85.052745"},
    {"Aha","126.11784", "126.05413"},
    {"Arg","156.18748", "156.10108"},
//    {"Ar",  "39.948",  "39.96238"  },
    {"Asn","114.10384", "114.04289"},
    {"Asp","115.08860", "115.026895"},
/*
    {"As",  "74.9216",  "74.9216" },
    {"Am", "243.0614", "243.0614" },
    {"At", "209.9871", "209.9871" },
    {"Au", "196.9665", "196.9665" },
    {"Ba", "137.327", "137.90501" },
    {"Be",   "9.01218",  "9.01218"},
    {"Bi", "208.9804", "208.9804" },
    {"Bk", "247.0703", "247.0703" },
*/
    {"Br",  "79.909",  "78.91835"  },
    {"Boc","101.12526","101.060225"},
    {"Bzl", "91.13258", "91.054775"},
    {"Bu",  "57.11546", "57.070425"}, // Butyl
    {"Ca",  "40.078",   "39.96259" },
    /*
    {"Cd", "112.411", "113.90357" },
    {"Ce", "140.115", "139.90528" },
    {"Cf", "251.0796", "251.0796" },
    */
    {"Cl",  "35.453",  "34.96885" },
    /*
    {"Cm", "247.0703", "247.0703" },
    {"Cp",  "65.0947", "65.039125"}, // Cyclopentadienyl (C5H5)
    {"Cr",  "51.9961",  "51.94051"},
    {"Cs", "132.9051", "132.9051" },
    {"Co",  "58.9332",  "58.9332" },
    {"Cu",  "63.546",  "62.9296"  },
    */
    {"Cys","103.14480","103.009165"},
    /*
    {"Dy", "162.5",   "162.5"    },
    {"Er", "167.26",  "167.26"   },
    {"Es", "252.0829","252.0829" },
    */
    {"Et",  "29.06170", "29.039125"}, // Ethyl
//    {"Eu", "151.965", "151.965"  },
//    {"Fe",  "55.847", "55.93493" },
    {"Fmoc","223.25114","223.075875"}, //Fmoc-Schutzgruppe
    /*
    {"Fm", "257.0951", "257.0951" },
    {"Fr", "223.0197", "223.0197" },
    {"Ga",  "69.723",  "68.92568" },
    {"Gd", "157.25",  "157.25"    },
    {"Ge",  "72.61",   "73.92115" },
    */
    {"Gly", "57.05192", "57.021445"},
    {"Gln","128.13072","128.05854" },
    {"Glu","129.11548","129.042545"},
    /*
    {"He", "4.002602", "4.002604" },
    {"Hf", "178.49",  "179.94681" },
    {"Hg", "200.59",  "201.97063" },
    {"Ho", "164.9303", "164.9303" },
    */
    {"His", "137.14108","137.058885"},
    {"Ile", "113.15944","113.084045"},
    /*
    {"In", "114.82", "114.90407" },
    {"Ir", "192.22", "192.96328" },
    {"Kr", "83.80",   "83.9115"  },
    {"La", "138.9055","138.90606"},
    */
    {"Li", "6.941", "7.016005" },
    /*
    {"Lr", "260.1053", "260.1053"},
    {"Lu", "174.967",  "174.967" },
    */
    {"Leu","113.15944","113.084045"},
    {"Lys","128.17408","128.09494"},
    //    {"Md", "258.0986", "258.0986" },
    {"Met","131.19856","131.040465"}, //Methionin
    {"Me",  "15.03482",  "15.023475"}, //Methyl
    /*
    {"Mg",  "24.305", "23.98505"},
    {"Mn",  "54.938", "54.938"  },
    {"Mo",  "95.94",  "97.90551"},
    */
    {"Mz", "269.27982", "269.092565"}, //Mz-Schutzgruppe
    {"MZ", "269.27982", "269.092565"}, //Mz-Schutzgruppe
    {"Na",  "22.9897", "22.98977" },
    /*
    {"Nb",  "92.90638", "92.90638" },
    {"Nd", "144.24", "141.90748" },
    {"Ne",  "20.1797", "19.99244" },
    {"Ni",  "58.69", "57.93534" },
    {"No", "259.1009", "259.1009" },
    {"Np", "237.0482", "237.0482" },
    {"Os", "190.2", "191.96141" },
    {"Pa", "231.0359", "231.0359" },
    {"Pb", "207.2", "207.97664" },
    {"Pd", "106.42", "105.9032" },
    */
    {"Phe","147.17656","147.068395"}, //Phenylalanin
    {"Ph",  "77.10570", "77.039125"}, //Phenyl (C6H5)
    //    {"Pm", "146.9151", "146.9151" },
    //    {"Po", "208.9824", "208.9824" }, //Polonium
    {"Pro", "97.11668", "97.052745"}, //Prolin
    /*
    {"Pr", "140.9077", "140.9077" }, //Praseodym (Praseodymium)
    {"Pt", "195.08", "194.96482" },
    {"Pu", "244.0642", "244.0642" },
    */
    {"Pz", "239.25354", "239.082015"}, //Pz-Schutzgruppe
    {"PZ", "239.25354", "239.082015"}, //Pz-Schutzgruppe
    /*
    {"Ra", "226.0254", "226.0254" },
    {"Rb",  "85.4678", "84.91171" },
    {"Re", "186.207", "186.95596" },
    {"Rh", "102.9055", "102.9055" },
    {"Rn", "222.0176", "222.0176" },
    {"Ru", "101.07", "101.07" },
    {"Sb", "121.75", "120.90375" },
    {"Sc",  "44.95591", "44.95591"},
    */
    {"Ser", "87.07820", "87.031995"}, //Serin
    {"Se",  "78.96",  "79.91651"   }, //Selen
    {"Si", "28.0855", "27.9769" },
    /*
    {"Sm", "150.36", "150.36" },
    {"Sn", "118.710", "119.90213" },
    {"Sr",  "87.62", "87.90561" },
    {"Ta", "180.9479", "180.9479" },
    {"Tb", "158.9253", "158.9253" },
    {"Tc",  "98.9063", "98.9063" },
    {"Te", "127.60", "129.9067" },
    */
    {"Thr","101.10508", "101.047645"}, //Threonin
    /*
    {"Th", "232.0381", "232.0381" }, //Thorium
    {"Ti",  "47.88", "47.94795" },
    {"Tl", "204.3833", "204.97446" },
    {"Tm", "168.9342", "168.9342" },
    */
    {"Trp","186.21320", "186.07929"},
    {"Tyr","163.17596", "163.063295"}, //Tyrosin
    {"Val", "99.13256", "99.068395"},
    /*
    {"Xe", "131.29", "131.90416" },
    {"Yb", "173.04", "173.93902" },
    {"Zn", "65.39",   "63.92915" },
    {"Zr", "91.224",  "89.90432" },
    */
 //hier koennen noch weitere Abkuerzungen eingefuegt werden

 //Ein-Buchstaben-Abkuerzungen:
    {"B", "10.811", "11.0093" },
    {"C", "12.011", "12.000" },
    {"D", "2.014102", "2.014102"},
    {"F", "18.9984", "18.9984" },
    {"H", "1.00794", "1.007825" },
    {"I", "126.9044", "126.9044"},
    {"J", "126.9044", "126.9044"},
    {"K", "39.0983", "38.9637" },
    {"N", "14.0067", "14.00307"},
    {"O", "15.9994", "15.9949" },
    {"P", "30.9738", "30.9738" },
    {"S", "32.066",  "31.97207"},
    {"T",  "3.01605", "3.01605"},
    {"U", "238.0289", "238.05076"},
    {"V", "50.9415", "50.94398" },
    {"W", "183.85", "183.95099" },
    {"Y", "88.9059", "88.90543" },
    {"Z", "135.14238", "135.044575"}

  };

double mol_weight(char* formel,char** zs,int isoflag) // Berechne Molekulargewicht
{
 // Wenn isoflag gesetzt ist, werden nur haeufigste Isotope verwendet,
 // sonst wird das durchschnittliche Molekulargewicht berechnet.
 int c,klamzu;
 char *s;
 double m, summe=0;

// printf("mol_weight('%s')\n",formel);//test
 while(isformelzeichen(c= *formel) && c!=')' && c!=']')
  {if(c=='(' || c=='[')
	{if(c=='[') klamzu=']'; else klamzu=')';
	 m=mol_weight(++formel,&s,isoflag);
	 formel=s;
	 if(*formel++!=klamzu) {fehler1("fehlende Klammer"); break;}
	}
   else if(c=='^' && isdigit(formel[1]))
        {m=sterndach(formel,&s,isoflag|DACH);
	 formel=s;
	}
   else
        {if(!isupper(c))
		{fehler2("ungueltige Formel:",formel); break;}
         //if(islower(formel[1]) || (formel[1]=='Z' && (c=='P' || c=='M'))) //ist naechster Buchstabe ein Kleinbuchstabe, oder Ausnahmen PZ oder MZ?
	    {uint i; int k;                                                 //ja: Abkuerzung aus der Tabelle auslesen
	     for(i=0,m=0;i<sizeof(mgtabelle)/sizeof(mgtab);i++)
	      {
	       if(mgtabelle[i].symbol[0]==c)
		{k=strlen(mgtabelle[i].symbol);
		 if(strncmp(&mgtabelle[i].symbol[1],&formel[1],k-1)==0)
		   {
#ifdef FLIESSZAHLKLASSE
		    if(isoflag==0)
		      m=Fliesszahl(mgtabelle[i].wert,0);
		    else
		      m=Fliesszahl(mgtabelle[i].wertiso,0);
#else
		    if(isoflag==0)
		      m=double(mgtabelle[i].wert);
		    else
		      m=double(mgtabelle[i].wertiso);
#endif
		    formel+=k; break;
		   }
		}
	      }
	     if(i==1) set_actinium_warnung(); //Fuer Warnung um nicht Acethyl mit Actinium zu verwechseln
	    }
	 /*
	 else
	    {m = (isoflag==0) ? einzelzeichen[c-'A'] : einzelzeichen_iso[c-'A'];   //nein: dann ist es ein Element, das mit nur einem Buchstaben abgekuerzt wird.
	     if(m!=0) formel++;
	    }
	 */
        }
   if(m==0) {fehler2("Unbekannt:",formel); formel++; break;}
   if(isdigit(*formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else c=1;
   summe += c*m;
   while(ist_leer(*formel)) formel++;
  }
 if(c=='*')
  {formel++;
   if(isdigit(c= *formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else if(c=='^')
	{//Trick: z.B. *^13C2 soll 2 schon gezaehlte C als 13C rechnen
	 summe += sterndach(formel,&s,isoflag);
	 formel=s;
	 c=1;
	}
   else	c=1;
   summe += c*mol_weight(formel,&s,isoflag);
   formel=s;
  }
 *zs = formel;
 // printf("summe=%lf  *zs='%s'\n",summe,*zs);//test
 return summe;
}

/******************* Erweiterung fuer Isotope ************************/
/*
 Beispiel: Boc-Ala-Gly-Ala*^13C-Aib-OMe sollte 417.464 (417.227) geben
           (nicht 429.47 (429.23) wie mit alter Version)
 z.B. *^13C2 soll 2 _schon_gezaehlte_ C als 13C rechnen
 (im Gegensatz zu ^13C2 (ohne *) wo das wirklich 2 zusaetzliche C sind)
 Spezialfall Deuterium: z.B. *^D12

 Die Funktion sterndach() soll als Formel etwas in der Form
 "^<Zahl><Atom><Zahl>..." bekommen. (Der Stern wurde schon verarbeitet).
 Als Rueckgabewert soll die Differenzmasse berechnet werden, also markiertes
 minus nicht markiertes. zs soll dann noch die Restformel zurueckgeben.
 Beispiele: ^18O, ^13C6, ^6Li, ^208Pb, ^2H11, ^D11
 Spezialfall Deuterium: statt ^2H11 sollte ^D11 benutzt werden (genauer weil
 Deuterium nicht 2.000 sondern 2.014102 hat).
*/
double sterndach(char* formel,char** zs,int flags)
{
 char atom[3],*s;
 double summe,masse,alt;
 int c,k,anzahl;
 if(formel[0]!='^') fehler1("sterndach-Syntaxfehler");
 if(formel[1]=='D' || formel[1]=='T') //Spezialfall Deuterium u. Tritium
   {atom[0]=formel[1]; atom[1]=0;
    masse=mol_weight(atom,&s,0);
    atom[0]='H';
    k=2;
   }
 else //Normalfall
   {for(masse=0,k=1;(c=formel[k])!=0 && isdigit(c);k++)
          masse=10*masse+c-'0';
    if(masse<=1 || !isupper(formel[k])) fehler1("falsche Isotop-Syntax");
    atom[0]=formel[k++];
    c=formel[k];
    if(islower(c)) k++; else c=0;
    atom[1]=c;
    atom[2]=0;
   }
 for(anzahl=0;(c=formel[k])!=0 && isdigit(c);k++)
    anzahl=10*anzahl+c-'0';
 if(anzahl==0) anzahl=1;
 while(ist_leer(formel[k])) k++;
 *zs = &formel[k];
 alt = mol_weight(atom,&s,flags&ISO);
 if(alt==0 || alt-masse>5 || masse-alt>5) fehler1("Falsches-Isotop");
 if(flags&DACH)
   summe = masse * anzahl;
 else
   summe = (masse - alt) * anzahl;
 return summe;
}

/********************** Fehlermeldungen *************************/
static int errorflag=0;
static int actinium_warnung=0; //fuer Warnung um Actinium nicht mit Acetyl zu verwechseln
static char scratch[120],*errorstring=NULL,*warningstring=NULL;

void error_reset(char *errstr,char *warnstr)
{
 errorflag=0;
 actinium_warnung=0;
 errorstring=errstr;
 warningstring=warnstr;
 if(errorstring!=NULL) *errorstring=0;
 if(warningstring!=NULL) *warningstring=0;
}

void fehler1(const char *text)
{
 if(errorstring!=NULL) strcpy(errorstring,text);
 //else printf("%s\n",text);
 errorflag++;
}

void fehler0(const char *text,int c)
{
 sprintf(scratch,"%s %c",text,c);
 fehler1(scratch);
}

void fehler2(const char *text1,const char *text2)
{
 sprintf(scratch,"%s%s",text1,text2);
 fehler1(scratch);
}

void set_actinium_warnung(void) {actinium_warnung++;}
int  get_actinium_warnung(void) {return actinium_warnung;}

void warnung1(const char *text)
{
 if(warningstring!=NULL) strcpy(warningstring,text);
}

/************************ Hauptaufruf ***************************/
double calculate_mol_weight(const char *formel,int isoflag)
{
 //char normierteformel[800], *s;
 char *normierteformel, *s;
 double result=0;
 int n,max2;
 //error_reset(NULL,NULL); //test
 max2=4*strlen(formel)+1;
 normierteformel=(char*)calloc(max2,1);
 if(normierteformel==NULL)
  {fehler1("zu wenig Speicher"); return result;}
 formel_normieren(formel,normierteformel,strlen(formel)+1,max2);
 n=klammertest(normierteformel);
 if(n<0)
  fehler1("fehlende Klammer auf");
 else if(n>0)
  fehler1("fehlende Klammer zu");
 else
  {
   result=mol_weight(normierteformel,&s,isoflag);
   if(actinium_warnung>0) warnung1("Hinweis: Ac = Actinium, Ace = Acetyl");
  }
 free(normierteformel);
 return result;
}

/*****************Erweiterung fuer Summenformeln *********************/
#ifdef SUMMENFORMELN

const char *getsummenformel_pep(const char *peptid)
{
 int c=dreibuchstaben_auf_einbuchstaben_abkuerzung_reduzieren(peptid);
 return aminos[c-'A'].summenformel;
}

char *getsymbol(const char **zs)  //Symbol auslesen und Zeiger zs entsprechend erhoehen
{
 static char sym[8]; //Abkuerzungen sind hoechstens 4 Zeichen lang, 8 ist also ausreichend
 char *p=sym;
 int c,i;
 const char *s;
 s = *zs;
 //printf("getsymbol('%s')\n",s);//test
 if(!isupper(*s))           //ist erstes Zeichen ein Grossbuchstabe?
   {sym[0]=0; return sym;}  //nein: mit leerem String zurueckkehren
 //printf(" '%c'",*s);//test
 *p++ = c = *s++;  //erster Grossbuchstabe kopieren
 i=1; //bisher 1 Zeichen kopiert
 if((c=='P' || c=='M') && s[0]=='Z' && !islower(s[1])) //Ausnahmen PZ und MZ behandeln
   {*p++ = *s++;}                  
 else
  while((c= *s)!=0 && islower(c))  //solange Kleinbuchstaben folgen
    {
     if(++i<8) *p++ = c;      //diese kopieren (aber maximal 8)
     s++;
    }
 *p = 0;  //den String mit 0 abschliessen
 //printf(" sym[8] = '%s'\n",sym);//test
 *zs = s;
 return sym;
}

int getnumber(const char **zs)
{
 int c,z=0;
 const char *s;
 s = *zs;
 while(isdigit(*s))
  {
   c = *s++;
   z=10*z+c-'0';
  }
 *zs = s;
 return z;
}

const char* elemente[]= //Alle Elemente des Periodensystems bis zum Lr
 {"D","H","He", //Deuterium an Position 0, sonst ist Position jeweils Ordnungsnummer im Periodensystem
  "Li","Be","B", "C", "N", "O", "F", "Ne",
  "Na","Mg","Al","Si","P", "S", "Cl","Ar",
  "K", "Ca","Sc","Ti","V", "Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr",
  "Rb","Sr","Y", "Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I", "Xe",
  "Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf",
                      "Ta","W", "Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn",
  "Fr","Ra","Ac","Th","Pa","U", "Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr", //Lr ist Element Nr=103
  "Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn", //hier noch neue kuenstliche Elemente einfuegen (Cn ist Nr=112)
  "T" //zusaetzlich noch Tritium (Ordnungsnummer hier irrelevant)
 };
//#define ANZAHLELEMENTE 103
//#define ANZAHLELEMENTE 112

const char* getelementsymbol(int nr)
{
 return elemente[nr];
}

int elementnummer(const char *symbol)
{
 int nr;
 const int max=sizeof(elemente)/sizeof(char*);
 if(strcmp(symbol,"J")==0) symbol="I"; //Spezialfall: Jod mit 'J' abgekuerzt statt 'I'
 for(nr=0;nr<max;nr++)
   if(strcmp(symbol,elemente[nr])==0) return nr;
 return -1; //bei Fehler -1 zurueckgeben
}

//Alle Abkuerzungen, die keine Element und keine Standard-Aminsaeuren sind:
static Abkuerzungen summenformeltabelle[]=
 {
  {"Ace", "C2H3O"}, //Acethyl (H3C-C=O)
  {"Bzl", "C7H7"},
  {"Z",   "C8H7O2"},
  {"Boc", "C5H9O2"},
  {"Fmoc", "C15H11O2"},
  {"Me", "CH3"},
  {"Et", "C2H5"},
  {"Bu", "C4H9"},
  {"Ph", "C6H5"},
  {"PZ", "C14H11N2O2"},
  {"Pz", "C14H11N2O2"},
  {"MZ", "C15H13N2O3"},
  {"Mz", "C15H13N2O3"},
  {"Cp", "C5H5"},

  //hier koennen noch weitere Abkuerzungen eingefuegt werden
 };

char *getsummenformel(const char *formel,const char **zs)
{
 const char *s,*sym,*neu;
 char *summenformel=(char*)calloc(400,1);
 char *subformel=NULL;
 int i,c,n,index,z,klamzu;
 int element[120];
 int peptidmodus=0,knummer=0;
 for(i=0;i<120;i++) element[i]=0;
 summenformel[0]=0;
 //if(zs==NULL) printf("getsummenformel('%s',NULL)\n",formel);//test
 //else printf("getsummenformel('%s',zs)\n",formel);//test
 while((c= *formel)!=0 && c!=')' && c!=']' && c!=',')
  {
   if(c=='~') {peptidmodus ^= 1; ++formel; continue;}
   if(ist_leer(c)) {++formel; continue;}
   if(c=='^')
     {//Isotopmarkiertes Atom:
      while((c= *++formel)!=0 && isdigit(c))  ;//provi. Isotopangaben ignorieren
      warnung1("Isotope werden nicht in der Summenformel eingefuegt");
      continue;
     }
   if(c=='*')
     {++formel;
      if((c= *formel)=='^')  //Sterndach-Syntax ("*^") erkannt?
        {                    //ja: Isotop-Markierungen behandeln
	 char tmpstr[8];
	 c = formel[1];
	 if(!isdigit(c))
	  {if(c=='D') ;//H durch D ersetzen
	   else if(c=='T') ;//H durch T ersetzen
	   else {strncpy(tmpstr,formel,4); tmpstr[4]=0; fehler2("Syntaxerror: ",tmpstr);}
	  }
	 while((c= *++formel)!=0 && isdigit(c))  ;//provi. Isotopangaben ignorieren
	 sym=getsymbol(&formel); //provi. Isotop-Atom ignorieren
	 while(isdigit(*formel)) formel++; //provi. auch Anzahl ignorieren
	 warnung1("Isotope werden nicht in der Summenformel eingefuegt");
	 continue;
        }
      else  //Wenn nach dem '*' kein '^' kommt, dann Kristallwasser-Syntax (z.B. Na2SO4*10H2O)
        {
	 knummer = (isdigit(c)) ? getnumber(&formel) : 1;
	 neu=subformel=getsummenformel(formel,&s);
	 formel=s;
	}
     }
   else if(c=='(' || c=='[')
     {
      if(c=='(') klamzu=')'; else klamzu=']';
      neu=subformel=getsummenformel(++formel,&s);
      formel=s;
      if(*formel++ != klamzu) fehler1("Klammerfehler");
      //printf("Summenformel vom Klammernteil='%s' Restformel='%s'\n",neu,formel);//test
     }
   else
     {
      Abkuerzungen *p;
      //const char *stest=formel;//test
      sym=getsymbol(&formel);
      //printf("sym=getsymbol('%s') --> sym='%s' formel='%s'\n",stest,sym,formel);//test
      if(*sym==0) {fehler1("Fehler in getsummenformel() nach getsymbol()"); return summenformel;}
      neu="";
      if(peptidmodus!=0 && strlen(sym)==1 && (c=sym[0])!=0 && isupper(c))
        {
	 neu=aminos[c-'A'].summenformel;
        }
      else
       for(p=aminos,i=0;i<sizeof(aminos)/sizeof(Abkuerzungen);i++,p++)
	{if(strcmp(sym,p->sym)==0) {neu=p->summenformel; break;}
	}
      if(*neu==0)
       for(p=summenformeltabelle,i=0;i<sizeof(summenformeltabelle)/sizeof(Abkuerzungen);i++,p++)
	{if(strcmp(sym,p->sym)==0) {neu=p->summenformel; break;}
	}
      if(*neu==0)
        neu=sym;
      //printf("Summenformel von aktuellem Symbol: '%s'\n",neu);//test
     }
   if(knummer!=0)            {index=knummer; knummer=0;}
   else if(isdigit(*formel)) {index=getnumber(&formel);}
   else                      {index=1;}
   while(*neu!=0)
    {
     s=getsymbol(&neu);
     if(*s==0) fehler2("Fehler in getsymbol(): ",neu);//test
     n = elementnummer(s);
     z = (isdigit(*neu)) ? getnumber(&neu) : 1;
     if(n<0) fehler2("Unbekanntes Element: ",s);
     else    element[n] += z*index;
    }
   if(subformel!=NULL) {free(subformel); subformel=NULL;}
  }
 if(zs!=NULL) *zs=formel;

 //aus der Liste der benutzten Elemente die Summenformel konstuieren:
 char zahltext[40],*st;
 int j;
 for(st=summenformel,i=0,j=6;i<120 && j<400;i++)
  {
   if(element[i]!=0)
    {
     sym=getelementsymbol(i);
     while((c= *sym++)!=0) {*st++ = c; j++;}
     if(element[i]>1)
      {sprintf(zahltext,"%d",element[i]);
       for(sym=zahltext;(c= *sym++)!=0;) {*st++ = c; j++;}
      }
    }
  }
 *st=0;
 if(j>=400) fehler1("Speicher fuer Summenformel zu klein");

 //provi. hier muesste die Summenformel noch alfabetisch nach Elementen sortiert werden
 summesortieren(summenformel);

 return summenformel;
}

/** Summenformel sortieren: **/
const char *getsymbolundzahl(char **zs)   //z.B. 'Na2C15H27' --> sym="Na2" *zs="C15H27"
{
 static char sym[16];
 char *s,*y=sym;
 int c;
 s = *zs; //Zeiger vom zu lesenden String
 *y++ = c = *s++;
 if(c==0) return sym; //bei Aufruf mit leerem String auch wieder leerer String zurueckgeben
 while((c= *s++)!=0 && !isupper(c))
   *y++ = c;
 --s; //zuviel gelesenes zurueckstellen
 *y=0;
 *zs = s; //erhoehter Zeiger speichern
 return sym;
}

void einfuegen(char *puffer,const char *sym)
{
 int c, len1=strlen(puffer), len2=strlen(sym);
 char *p1,*p2;
 for(p1= &puffer[len1], p2=p1+len2, *p2=0; p1!=puffer;) //Inhalt von puffer um len2 nach hinten schieben
   *--p2 = *--p1;
 while((c= *sym++)!=0)
   *puffer++ = c;
}

void einsortieren(char *puffer,const char *sym)
{
 int c,gross,klein;
 gross = sym[0]; //erster Buchstabe muss ein Grossbuchstabe sein
 klein = sym[1]; //weiterer kann ein Kleinbuchstabe sein
 if(!islower(klein)) klein=0; //falls nicht: auf 0 setzen
 for(;;)
  {
   c = *puffer; //Erstes Zeichen der bisherigen Formel
   if(c==0)                //sind wir am Ende des Puffers?
     {while((*puffer++ = *sym++)!=0) ; //ja: hier hineinkopieren, inklusive 0-Zeichen
      return;
     }
   if(c > gross || (c==gross && puffer[1]>klein)) //ist aktuelles Symbol weiter hinten im Alfabet?
      {einfuegen(puffer,sym);                     //ja: neues Symbol hier einfuegen
       return;
      }
   while((c= *++puffer)!=0 && !isupper(c)) ;  //neues Symbol im Puffer suchen
  }
}

void summesortieren(char *summenformel)
{
 char *s1,*s2;
 const char *sym;
 char *puffer=(char*)malloc(strlen(summenformel)+1);
 s1=summenformel;
 s2=puffer;
 *s2=0;
 while(*s1!=0)
  {
   sym=getsymbolundzahl(&s1);
   if(*sym==0) {fehler2("Fehler in summesortieren() s1=",s1); return;}
   einsortieren(puffer,sym);
  }
 strcpy(summenformel,puffer);
 free(puffer);
}
/**/

#endif
