/* mgkernf2.c		Version 2.04		letzte Aenderung: 16.4.2012

Molekulargewicht-Berechnung: Allgemeiner Teil zum Einfuegen im Hauptprogramm

Aenderungen:
11.4.2012    Erstellung aus mgkernf.c, das automatisch aus mgkern.c erstellt wurde.
             Versuch zur Optimierung auf wenig RAM-Verbrauch auf Microcontroller
11.4.12      Selten gebrauchte Elemente provisorisch auskommentiert
13.4.12 2.03 Tabellen mgtabelle[] und mgtabelle_iso[] in einer zusammgefasst
14.4.12 2.04 mgtabelle[] ins FLASH

*/
//#define FLIESSZAHLKLASSE
//#define SUMMENFORMELN

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "mgkern.h"

int klammertest(const char *text)
{
 int k1=0,k2=0,c;
 for(;*text!=0;)
   {c= *text++;
    if(c=='(') k1++; else if(c==')') --k1;
    else if(c=='[') k2++; else if(c==']') --k2;
   }
 if(k1!=0) return k1;
 return k2;
}

#ifdef SUMMENFORMELN
/** Diese Variante fuer Anpassung an Option fuer Summenformelausgabe: **/
#ifdef __cplusplus
struct Abkuerzungen {const char *sym; const char *summenformel;};
#else
struct _Abkuerzungen {const char *sym; const char *summenformel;};
typedef struct _Abkuerzungen Abkuerzungen;
#endif
static Abkuerzungen aminos[]=
 {
  {"Ala", "C3H5NO"}, //'A'
  {"Aib", "C4H7NO"}, //'B'
  {"Cys", "C3H5NOS"}, //'C'
  {"Asp", "C4H5NO3"}, //'D'
  {"Glu", "C5H7NO3"}, //'E'
  {"Phe", "C9H9NO"}, //'F'
  {"Gly", "C2H3NO"}, //'G'
  {"His", "C6H7N3O"}, //H
  {"Ile", "C6H11NO"}, //I
  {"Aha", "C4H6N4O"}, //J
  {"Lys", "C6H12N2O"}, //K
  {"Leu", "C6H11NO"}, //L
  {"Met", "C5H9NOS"}, //M
  {"Asn", "C4H6N2O2"}, //N
  {"Oxx", ""}, //O
  {"Pro", "C5H7NO"}, //P
  {"Gln", "C5H8N2O2"}, //Q
  {"Arg", "C6H12N4O"}, //R
  {"Ser", "C3H5NO2"}, //S
  {"Thr", "C4H7NO2"}, //T
  {"Uxx", ""}, //U
  {"Val", "C5H9NO"}, //V
  {"Trp", "C11H10N2O"}, //W
  {"Xxx", ""},        //'X' 
  {"Tyr", "C9H9NO2"}, //'Y'
  {"Zxx", ""}         //'Z'
 };
#else
/** Einfachere Variante wenn keine Summenformeln gebraucht werden: **/
static const char* aminos[]=
 {
  "Ala", //'A'
  "Aib", //'B'
  "Cys", //'C'
  "Asp", //'D'
  "Glu", //'E'
  "Phe", //'F'
  "Gly", //'G'
  "His", //H
  "Ile", //I
  "Aha", //J
  "Lys", //K
  "Leu", //L
  "Met", //M
  "Asn", //N
  "Oxx", //O
  "Pro", //P
  "Gln", //Q
  "Arg", //R
  "Ser", //S
  "Thr", //T
  "Uxx", //U
  "Val", //V
  "Trp", //W
  "Xxx", //'X' 
  "Tyr", //'Y'
  "Zxx"  //'Z'
 };
#endif

const char *einbuchstaben_auf_dreibuchstaben_abkuerzung_erweitern(int c)
{
 const char *peptid;
#ifdef SUMMENFORMELN
 peptid=aminos[c-'A'].sym;
#else
 peptid=aminos[c-'A'];
#endif
 return peptid;
}

int dreibuchstaben_auf_einbuchstaben_abkuerzung_reduzieren(const char *peptid)
{
 int c;
 for(c='A';c<='Z';c++)
  {
#ifdef SUMMENFORMELN
   if(strcmp(peptid,aminos[c-'A'].sym)==0) return c;
#else
   if(strcmp(peptid,aminos[c-'A'])==0) return c;
#endif
  }
 return 0;
}

void formel_normieren(const char *quelle,char *ziel,int imax,int jmax)
{
 /* Sonderzeichen ~ zum Umschalten auf Kurzschreibweise von Peptidketten
    werden hier entfernt und die Peptide auf die 3-Buchstabenschreibweise
    erweitert. Zudem noch allfaellige Leerzeichen entfernt.
 */
 int i,j,c,modus=0; //modus: 0=normal, 1=PeptidKette
 const char *peptid;
 for(i=1,j=4;i<imax && (c= *quelle++)!=0 && j<jmax;i++)
   {
    if(c & 0x80) {fehler0("Sonderzeichen ignoriert",c);}
    else if(c=='~') {modus ^= 1; *ziel++ = '-'; j++;}
    else if(c==' ' || c=='\n' || c=='\t') ;//Leerzeichen entfernen
    else if(modus==1)
     {
#ifdef SUMMENFORMELN
      peptid = (c>='A' && c<='Z') ? aminos[c-'A'].sym : NULL;
#else
      peptid = (c>='A' && c<='Z') ? aminos[c-'A'] : NULL;
#endif
      if(peptid!=NULL) {*ziel++ = peptid[0]; *ziel++ = peptid[1]; j+=2; c=peptid[2];}
      *ziel++ = c; j++;
     }
    else /*if(modus==normal)*/
      {*ziel++ = c; j++;}
   }
 *ziel=0;
}

inline bool isfirstformelzeichen(char c)
{
 return (isupper(c) || c=='(' || c=='[' || c=='^');
}

bool ist_leer(char c)
{
 return (c=='-' || c=='=' || c=='_');
}

bool isformelzeichen(char c)
{
 return (isfirstformelzeichen(c) || islower(c) || ist_leer(c)
	 || c==')' || c==']');
}

//---- Sachen fuer FLASH-Speicher: ----
#ifdef LCD_SIMULATOR

#define PROGMEM 
#define strlen_P strlen
#define strncmp_P strncmp
char pgm_read_byte(const char* s) {return s[0];}
const char* pgm_read_word(const char** s) {return s[0];}
#define PGM_ADRESSE const char *

#else

#include <avr/pgmspace.h>
#define PGM_ADRESSE uint16_t

#endif

Fliesszahl Fliesszahl_P(PGM_ADRESSE adr)
{
 char str[16];
 char c, *z=str;
 while((c=pgm_read_byte(adr++))!=0)
  *z++ = c;
 *z=0;
 return Fliesszahl(str,0);
}

int mystrlen_P(PGM_ADRESSE adr)
{
 int i=0;
 while(pgm_read_byte(adr++)!=0)
   i++;
 return i;
}

int mystrncmp_P(const char *str,PGM_ADRESSE adr,int k)
{
 int c1=0,c2=0,i;
 for(i=0;i<k && (c1=pgm_read_byte(adr++))!=0 && c1==(c2= *str++);i++)
  ;
 return c2-c1;
}
//---- :Sachen fuer FLASH-Speicher ----


/* Beispiel von www.mikrocontroller.net
const char str1[] PROGMEM = "first_A";
const char str2[] PROGMEM = "second_A";
const char str3[] PROGMEM = "third_A";
 
const char * const strarray1[] PROGMEM = 
{
   str1,
   str2,
   str3
};
*/

//Vorbereitung fuer mgtabelle[] im FLASH:
//Ein-Buchstaben-Abkuerzungen:
const char st0[] PROGMEM = "B"; const char st1[] PROGMEM = "10.811"; const char st2[] PROGMEM = "11.0093" ;
const char st3[] PROGMEM = "C"; const char st4[] PROGMEM = "12.011"; const char st5[] PROGMEM = "12.000" ;
const char st6[] PROGMEM = "D"; const char st7[] PROGMEM = "2.014102"; const char st8[] PROGMEM = "2.014102";
const char st9[] PROGMEM = "F"; const char st10[] PROGMEM = "18.9984"; const char st11[] PROGMEM = "18.9984" ;
const char st12[] PROGMEM = "H"; const char st13[] PROGMEM = "1.00794"; const char st14[] PROGMEM = "1.007825" ;
const char st15[] PROGMEM = "I"; const char st16[] PROGMEM = "126.9044"; const char st17[] PROGMEM = "126.9044";
const char st18[] PROGMEM = "J"; const char st19[] PROGMEM = "126.9044"; const char st20[] PROGMEM = "126.9044";
const char st21[] PROGMEM = "K"; const char st22[] PROGMEM = "39.0983"; const char st23[] PROGMEM = "38.9637" ;
const char st24[] PROGMEM = "N"; const char st25[] PROGMEM = "14.0067"; const char st26[] PROGMEM = "14.00307";
const char st27[] PROGMEM = "O"; const char st28[] PROGMEM = "15.9994"; const char st29[] PROGMEM = "15.9949" ;
const char st30[] PROGMEM = "P"; const char st31[] PROGMEM = "30.9738"; const char st32[] PROGMEM = "30.9738" ;
const char st33[] PROGMEM = "S"; const char st34[] PROGMEM = "32.066"; const char st35[] PROGMEM =  "31.97207";
const char st36[] PROGMEM = "T"; const char st37[] PROGMEM =  "3.01605"; const char st38[] PROGMEM = "3.01605";
const char st39[] PROGMEM = "U"; const char st40[] PROGMEM = "238.0289"; const char st41[] PROGMEM = "238.05076";
const char st42[] PROGMEM = "V"; const char st43[] PROGMEM = "50.9415"; const char st44[] PROGMEM = "50.94398" ;
const char st45[] PROGMEM = "W"; const char st46[] PROGMEM = "183.85"; const char st47[] PROGMEM = "183.95099" ;
const char st48[] PROGMEM = "Y"; const char st49[] PROGMEM = "88.9059"; const char st50[] PROGMEM = "88.90543" ;
const char st51[] PROGMEM = "Z"; const char st52[] PROGMEM = "135.14238"; const char st53[] PROGMEM = "135.044575";

//2-Buchstaben-Abkuerzungen fuer Elemente und meistens 3-Buchstaben fuer andere Abkuerzungen:
const char str0[] PROGMEM = "Ace"; const char str1[] PROGMEM = "43.04522"; const char str2[] PROGMEM = "43.018375";
const char str3[] PROGMEM = "Ac"; const char str4[] PROGMEM = "227.0278"; const char str5[] PROGMEM = "227.0278";
const char str6[] PROGMEM = "Ag"; const char str7[] PROGMEM = "107.8682"; const char str8[] PROGMEM = "106.90497";
const char str9[] PROGMEM = "Ala"; const char str10[] PROGMEM = "71.0788"; const char str11[] PROGMEM =  "71.037095";
const char str12[] PROGMEM = "Al"; const char str13[] PROGMEM =  "26.9815"; const char str14[] PROGMEM =  "26.9815"; //Aluminium
const char str15[] PROGMEM = "Aib"; const char str16[] PROGMEM = "85.10568"; const char str17[] PROGMEM = "85.052745";
const char str18[] PROGMEM = "Aha"; const char str19[] PROGMEM ="126.11784"; const char str20[] PROGMEM = "126.05413";
const char str21[] PROGMEM = "Arg"; const char str22[] PROGMEM ="156.18748"; const char str23[] PROGMEM = "156.10108";
const char str24[] PROGMEM = "Ar"; const char str25[] PROGMEM =  "39.948"; const char str26[] PROGMEM =  "39.96238";
const char str27[] PROGMEM = "Asn"; const char str28[] PROGMEM ="114.10384"; const char str29[] PROGMEM = "114.04289";
const char str30[] PROGMEM = "Asp"; const char str31[] PROGMEM ="115.08860"; const char str32[] PROGMEM = "115.026895";
const char str33[] PROGMEM = "As"; const char str34[] PROGMEM =  "74.9216"; const char str35[] PROGMEM =  "74.9216";
const char str36[] PROGMEM = "Am"; const char str37[] PROGMEM = "243.0614"; const char str38[] PROGMEM = "243.0614";
const char str39[] PROGMEM = "At"; const char str40[] PROGMEM = "209.9871"; const char str41[] PROGMEM = "209.9871";
const char str42[] PROGMEM = "Au"; const char str43[] PROGMEM = "196.9665"; const char str44[] PROGMEM = "196.9665";

const char str45[] PROGMEM = "Ba"; const char str46[] PROGMEM = "137.327"; const char str47[] PROGMEM = "137.90501" ;
const char str48[] PROGMEM = "Be"; const char str49[] PROGMEM =   "9.01218"; const char str50[] PROGMEM =  "9.01218";
const char str51[] PROGMEM = "Bi"; const char str52[] PROGMEM = "208.9804"; const char str53[] PROGMEM = "208.9804" ;
const char str54[] PROGMEM = "Bk"; const char str55[] PROGMEM = "247.0703"; const char str56[] PROGMEM = "247.0703" ;
const char str57[] PROGMEM = "Br"; const char str58[] PROGMEM =  "79.909"; const char str59[] PROGMEM =  "78.91835"  ;
const char str60[] PROGMEM = "Boc"; const char str61[] PROGMEM ="101.12526"; const char str62[] PROGMEM ="101.060225";
const char str63[] PROGMEM = "Bzl"; const char str64[] PROGMEM = "91.13258"; const char str65[] PROGMEM = "91.054775";
const char str66[] PROGMEM = "Bu"; const char str67[] PROGMEM =  "57.11546"; const char str68[] PROGMEM = "57.070425"; // Butyl

const char str69[] PROGMEM = "Ca"; const char str70[] PROGMEM =  "40.078"; const char str71[] PROGMEM =   "39.96259" ;
const char str72[] PROGMEM = "Cd"; const char str73[] PROGMEM = "112.411"; const char str74[] PROGMEM = "113.90357" ;
const char str75[] PROGMEM = "Ce"; const char str76[] PROGMEM = "140.115"; const char str77[] PROGMEM = "139.90528" ;
const char str78[] PROGMEM = "Cf"; const char str79[] PROGMEM = "251.0796"; const char str80[] PROGMEM = "251.0796" ;
const char str81[] PROGMEM = "Cl"; const char str82[] PROGMEM =  "35.453"; const char str83[] PROGMEM =  "34.96885" ;
const char str84[] PROGMEM = "Cm"; const char str85[] PROGMEM = "247.0703"; const char str86[] PROGMEM = "247.0703" ;
const char str87[] PROGMEM = "Cp"; const char str88[] PROGMEM =  "65.0947"; const char str89[] PROGMEM = "65.039125"; // Cyclopentadienyl (C5H5)
const char str90[] PROGMEM = "Cr"; const char str91[] PROGMEM =  "51.9961"; const char str92[] PROGMEM =  "51.94051";
const char str93[] PROGMEM = "Cs"; const char str94[] PROGMEM = "132.9051"; const char str95[] PROGMEM = "132.9051" ;
const char str96[] PROGMEM = "Co"; const char str97[] PROGMEM =  "58.9332"; const char str98[] PROGMEM =  "58.9332" ;
const char str99[] PROGMEM = "Cu"; const char str100[] PROGMEM =  "63.546"; const char str101[] PROGMEM =  "62.9296"  ;
const char str102[] PROGMEM = "Cys"; const char str103[] PROGMEM ="103.14480"; const char str104[] PROGMEM ="103.009165";

const char str105[] PROGMEM = "Dy"; const char str106[] PROGMEM = "162.5"; const char str107[] PROGMEM =   "162.5"    ;

const char str108[] PROGMEM = "Er"; const char str109[] PROGMEM = "167.26"; const char str110[] PROGMEM =  "167.26"   ;
const char str111[] PROGMEM = "Es"; const char str112[] PROGMEM = "252.0829"; const char str113[] PROGMEM ="252.0829" ;
const char str114[] PROGMEM = "Et"; const char str115[] PROGMEM =  "29.06170"; const char str116[] PROGMEM = "29.039125"; // Ethyl
const char str117[] PROGMEM = "Eu"; const char str118[] PROGMEM = "151.965"; const char str119[] PROGMEM = "151.965"  ;

const char str120[] PROGMEM = "Fe"; const char str121[] PROGMEM =  "55.847"; const char str122[] PROGMEM = "55.93493" ;
const char str123[] PROGMEM = "Fmoc"; const char str124[] PROGMEM ="223.25114"; const char str125[] PROGMEM ="223.075875"; //Fmoc-Schutzgruppe
const char str126[] PROGMEM = "Fm"; const char str127[] PROGMEM = "257.0951"; const char str128[] PROGMEM = "257.0951" ;
const char str129[] PROGMEM = "Fr"; const char str130[] PROGMEM = "223.0197"; const char str131[] PROGMEM = "223.0197" ;

const char str132[] PROGMEM = "Ga"; const char str133[] PROGMEM =  "69.723"; const char str134[] PROGMEM =  "68.92568" ;
const char str135[] PROGMEM = "Gd"; const char str136[] PROGMEM = "157.25"; const char str137[] PROGMEM =  "157.25"    ;
const char str138[] PROGMEM = "Ge"; const char str139[] PROGMEM =  "72.61"; const char str140[] PROGMEM =   "73.92115" ;
const char str141[] PROGMEM = "Gly"; const char str142[] PROGMEM = "57.05192"; const char str143[] PROGMEM = "57.021445";
const char str144[] PROGMEM = "Gln"; const char str145[] PROGMEM ="128.13072"; const char str146[] PROGMEM ="128.05854" ;
const char str147[] PROGMEM = "Glu"; const char str148[] PROGMEM ="129.11548"; const char str149[] PROGMEM ="129.042545";

const char str150[] PROGMEM = "He"; const char str151[] PROGMEM = "4.002602"; const char str152[] PROGMEM = "4.002604" ;
const char str153[] PROGMEM = "Hf"; const char str154[] PROGMEM = "178.49"; const char str155[] PROGMEM =  "179.94681" ;
const char str156[] PROGMEM = "Hg"; const char str157[] PROGMEM = "200.59"; const char str158[] PROGMEM =  "201.97063" ;
const char str159[] PROGMEM = "Ho"; const char str160[] PROGMEM = "164.9303"; const char str161[] PROGMEM = "164.9303" ;
const char str162[] PROGMEM = "His"; const char str163[] PROGMEM = "137.14108"; const char str164[] PROGMEM ="137.058885";

const char str165[] PROGMEM = "Ile"; const char str166[] PROGMEM = "113.15944"; const char str167[] PROGMEM ="113.084045";
const char str168[] PROGMEM = "In"; const char str169[] PROGMEM = "114.82"; const char str170[] PROGMEM = "114.90407" ;
const char str171[] PROGMEM = "Ir"; const char str172[] PROGMEM = "192.22"; const char str173[] PROGMEM = "192.96328" ;

const char str174[] PROGMEM = "Kr"; const char str175[] PROGMEM = "83.80"; const char str176[] PROGMEM =   "83.9115"  ;

const char str177[] PROGMEM = "La"; const char str178[] PROGMEM = "138.9055"; const char str179[] PROGMEM ="138.90606";
const char str180[] PROGMEM = "Li"; const char str181[] PROGMEM = "6.941"; const char str182[] PROGMEM = "7.016005" ;
const char str183[] PROGMEM = "Lr"; const char str184[] PROGMEM = "260.1053"; const char str185[] PROGMEM = "260.1053";
const char str186[] PROGMEM = "Lu"; const char str187[] PROGMEM = "174.967"; const char str188[] PROGMEM =  "174.967" ;
const char str189[] PROGMEM = "Leu"; const char str190[] PROGMEM ="113.15944"; const char str191[] PROGMEM ="113.084045";
const char str192[] PROGMEM = "Lys"; const char str193[] PROGMEM ="128.17408"; const char str194[] PROGMEM ="128.09494";

const char str195[] PROGMEM = "Md"; const char str196[] PROGMEM = "258.0986"; const char str197[] PROGMEM = "258.0986" ;
const char str198[] PROGMEM = "Met"; const char str199[] PROGMEM ="131.19856"; const char str200[] PROGMEM ="131.040465"; //Methionin
const char str201[] PROGMEM = "Me"; const char str202[] PROGMEM =  "15.03482"; const char str203[] PROGMEM =  "15.023475"; //Methyl
const char str204[] PROGMEM = "Mg"; const char str205[] PROGMEM =  "24.305"; const char str206[] PROGMEM = "23.98505";
const char str207[] PROGMEM = "Mn"; const char str208[] PROGMEM =  "54.938"; const char str209[] PROGMEM = "54.938"  ;
const char str210[] PROGMEM = "Mo"; const char str211[] PROGMEM =  "95.94"; const char str212[] PROGMEM =  "97.90551";
const char str213[] PROGMEM = "Mz"; const char str214[] PROGMEM = "269.27982"; const char str215[] PROGMEM = "269.092565"; //Mz-Schutzgruppe

const char str216[] PROGMEM = "Na"; const char str217[] PROGMEM =  "22.9897"; const char str218[] PROGMEM = "22.98977" ;
const char str219[] PROGMEM = "Nb"; const char str220[] PROGMEM =  "92.90638"; const char str221[] PROGMEM = "92.90638" ;
const char str222[] PROGMEM = "Nd"; const char str223[] PROGMEM = "144.24"; const char str224[] PROGMEM = "141.90748" ;
const char str225[] PROGMEM = "Ne"; const char str226[] PROGMEM =  "20.1797"; const char str227[] PROGMEM = "19.99244" ;
const char str228[] PROGMEM = "Ni"; const char str229[] PROGMEM =  "58.69"; const char str230[] PROGMEM = "57.93534" ;
const char str231[] PROGMEM = "No"; const char str232[] PROGMEM = "259.1009"; const char str233[] PROGMEM = "259.1009" ;
const char str234[] PROGMEM = "Np"; const char str235[] PROGMEM = "237.0482"; const char str236[] PROGMEM = "237.0482" ;

const char str237[] PROGMEM = "Os"; const char str238[] PROGMEM = "190.2"; const char str239[] PROGMEM = "191.96141" ;

const char str240[] PROGMEM = "Pa"; const char str241[] PROGMEM = "231.0359"; const char str242[] PROGMEM = "231.0359" ;
const char str243[] PROGMEM = "Pb"; const char str244[] PROGMEM = "207.2"; const char str245[] PROGMEM = "207.97664" ;
const char str246[] PROGMEM = "Pd"; const char str247[] PROGMEM = "106.42"; const char str248[] PROGMEM = "105.9032" ;
const char str249[] PROGMEM = "Phe"; const char str250[] PROGMEM ="147.17656"; const char str251[] PROGMEM ="147.068395"; //Phenylalanin
const char str252[] PROGMEM = "Ph"; const char str253[] PROGMEM =  "77.10570"; const char str254[] PROGMEM = "77.039125"; //Phenyl (C6H5)
const char str255[] PROGMEM = "Pm"; const char str256[] PROGMEM = "146.9151"; const char str257[] PROGMEM = "146.9151" ;
const char str258[] PROGMEM = "Po"; const char str259[] PROGMEM = "208.9824"; const char str260[] PROGMEM = "208.9824" ; //Polonium
const char str261[] PROGMEM = "Pro"; const char str262[] PROGMEM = "97.11668"; const char str263[] PROGMEM = "97.052745"; //Prolin
const char str264[] PROGMEM = "Pr"; const char str265[] PROGMEM = "140.9077"; const char str266[] PROGMEM = "140.9077" ; //Praseodym (Praseodymium)
const char str267[] PROGMEM = "Pt"; const char str268[] PROGMEM = "195.08"; const char str269[] PROGMEM = "194.96482" ;
const char str270[] PROGMEM = "Pu"; const char str271[] PROGMEM = "244.0642"; const char str272[] PROGMEM = "244.0642" ;
const char str273[] PROGMEM = "Pz"; const char str274[] PROGMEM = "239.25354"; const char str275[] PROGMEM = "239.082015"; //Pz-Schutzgruppe
const char str276[] PROGMEM = "PZ"; const char str277[] PROGMEM = "239.25354"; const char str278[] PROGMEM = "239.082015"; //Pz-Schutzgruppe (um Verwechslung mit Phosphor+Z-Gruppe auszuschliessen)

const char str279[] PROGMEM = "Ra"; const char str280[] PROGMEM = "226.0254"; const char str281[] PROGMEM = "226.0254" ;
const char str282[] PROGMEM = "Rb"; const char str283[] PROGMEM =  "85.4678"; const char str284[] PROGMEM = "84.91171" ;
const char str285[] PROGMEM = "Re"; const char str286[] PROGMEM = "186.207"; const char str287[] PROGMEM = "186.95596" ;
const char str288[] PROGMEM = "Rh"; const char str289[] PROGMEM = "102.9055"; const char str290[] PROGMEM = "102.9055" ;
const char str291[] PROGMEM = "Rn"; const char str292[] PROGMEM = "222.0176"; const char str293[] PROGMEM = "222.0176" ;
const char str294[] PROGMEM = "Ru"; const char str295[] PROGMEM = "101.07"; const char str296[] PROGMEM = "101.07" ;

const char str297[] PROGMEM = "Sb"; const char str298[] PROGMEM = "121.75"; const char str299[] PROGMEM = "120.90375" ;
const char str300[] PROGMEM = "Sc"; const char str301[] PROGMEM =  "44.95591"; const char str302[] PROGMEM = "44.95591";
const char str303[] PROGMEM = "Ser"; const char str304[] PROGMEM = "87.07820"; const char str305[] PROGMEM = "87.031995"; //Serin
const char str306[] PROGMEM = "Se"; const char str307[] PROGMEM =  "78.96"; const char str308[] PROGMEM =  "79.91651"   ; //Selen
const char str309[] PROGMEM = "Si"; const char str310[] PROGMEM = "28.0855"; const char str311[] PROGMEM = "27.9769" ;
const char str312[] PROGMEM = "Sm"; const char str313[] PROGMEM = "150.36"; const char str314[] PROGMEM = "150.36" ;
const char str315[] PROGMEM = "Sn"; const char str316[] PROGMEM = "118.710"; const char str317[] PROGMEM = "119.90213" ;
const char str318[] PROGMEM = "Sr"; const char str319[] PROGMEM =  "87.62"; const char str320[] PROGMEM = "87.90561" ;

const char str321[] PROGMEM = "Ta"; const char str322[] PROGMEM = "180.9479"; const char str323[] PROGMEM = "180.9479" ;
const char str324[] PROGMEM = "Tb"; const char str325[] PROGMEM = "158.9253"; const char str326[] PROGMEM = "158.9253" ;
const char str327[] PROGMEM = "Tc"; const char str328[] PROGMEM =  "98.9063"; const char str329[] PROGMEM = "98.9063" ;
const char str330[] PROGMEM = "Te"; const char str331[] PROGMEM = "127.60"; const char str332[] PROGMEM = "129.9067" ;
const char str333[] PROGMEM = "Thr"; const char str334[] PROGMEM ="101.10508"; const char str335[] PROGMEM = "101.047645"; //Threonin
const char str336[] PROGMEM = "Th"; const char str337[] PROGMEM = "232.0381"; const char str338[] PROGMEM = "232.0381" ; //Thorium
const char str339[] PROGMEM = "Ti"; const char str340[] PROGMEM =  "47.88"; const char str341[] PROGMEM = "47.94795" ;
const char str342[] PROGMEM = "Tl"; const char str343[] PROGMEM = "204.3833"; const char str344[] PROGMEM = "204.97446" ;
const char str345[] PROGMEM = "Tm"; const char str346[] PROGMEM = "168.9342"; const char str347[] PROGMEM = "168.9342" ;
const char str348[] PROGMEM = "Trp"; const char str349[] PROGMEM ="186.21320"; const char str350[] PROGMEM = "186.07929";
const char str351[] PROGMEM = "Tyr"; const char str352[] PROGMEM ="163.17596"; const char str353[] PROGMEM = "163.063295"; //Tyrosin

const char str354[] PROGMEM = "Val"; const char str355[] PROGMEM = "99.13256"; const char str356[] PROGMEM = "99.068395";
const char str357[] PROGMEM = "Xe"; const char str358[] PROGMEM = "131.29"; const char str359[] PROGMEM = "131.90416" ;
const char str360[] PROGMEM = "Yb"; const char str361[] PROGMEM = "173.04"; const char str362[] PROGMEM = "173.93902" ;
const char str363[] PROGMEM = "Zn"; const char str364[] PROGMEM = "65.39"; const char str365[] PROGMEM =   "63.92915" ;
const char str366[] PROGMEM = "Zr"; const char str367[] PROGMEM = "91.224"; const char str368[] PROGMEM =  "89.90432" ;
 //hier koennten noch weitere Abkuerzungen eingefuegt werden

const char* mgtabelle[] PROGMEM =
  {
   str0, str1, str2, str3, str4, str5, str6, str7, str8, str9,
   str10, str11, str12, str13, str14, str15, str16, str17, str18, str19,
   str20, str21, str22, str23, str24, str25, str26, str27, str28, str29,
   str30, str31, str32, str33, str34, str35, str36, str37, str38, str39,
   str40, str41, str42, str43, str44, str45, str46, str47, str48, str49,
   str50, str51, str52, str53, str54, str55, str56, str57, str58, str59,
   str60, str61, str62, str63, str64, str65, str66, str67, str68, str69,
   str70, str71, str72, str73, str74, str75, str76, str77, str78, str79,
   str80, str81, str82, str83, str84, str85, str86, str87, str88, str89,
   str90, str91, str92, str93, str94, str95, str96, str97, str98, str99,
   str100, str101, str102, str103, str104, str105, str106, str107, str108, str109,
   str110, str111, str112, str113, str114, str115, str116, str117, str118, str119,
   str120, str121, str122, str123, str124, str125, str126, str127, str128, str129,
   str130, str131, str132, str133, str134, str135, str136, str137, str138, str139,
   str140, str141, str142, str143, str144, str145, str146, str147, str148, str149,
   str150, str151, str152, str153, str154, str155, str156, str157, str158, str159,
   str160, str161, str162, str163, str164, str165, str166, str167, str168, str169,
   str170, str171, str172, str173, str174, str175, str176, str177, str178, str179,
   str180, str181, str182, str183, str184, str185, str186, str187, str188, str189,
   str190, str191, str192, str193, str194, str195, str196, str197, str198, str199,
   str200, str201, str202, str203, str204, str205, str206, str207, str208, str209,
   str210, str211, str212, str213, str214, str215, str216, str217, str218, str219,
   str220, str221, str222, str223, str224, str225, str226, str227, str228, str229,
   str230, str231, str232, str233, str234, str235, str236, str237, str238, str239,
   str240, str241, str242, str243, str244, str245, str246, str247, str248, str249,
   str250, str251, str252, str253, str254, str255, str256, str257, str258, str259,
   str260, str261, str262, str263, str264, str265, str266, str267, str268, str269,
   str270, str271, str272, str273, str274, str275, str276, str277, str278, str279,
   str280, str281, str282, str283, str284, str285, str286, str287, str288, str289,
   str290, str291, str292, str293, str294, str295, str296, str297, str298, str299,
   str300, str301, str302, str303, str304, str305, str306, str307, str308, str309,
   str310, str311, str312, str313, str314, str315, str316, str317, str318, str319,
   str320, str321, str322, str323, str324, str325, str326, str327, str328, str329,
   str330, str331, str332, str333, str334, str335, str336, str337, str338, str339,
   str340, str341, str342, str343, str344, str345, str346, str347, str348, str349,
   str350, str351, str352, str353, str354, str355, str356, str357, str358, str359,
   str360, str361, str362, str363, str364, str365, str366, str367, str368, //str369,

   //Einbuchstaben-Abkuerzungen:
   st0, st1, st2, st3, st4, st5, st6, st7, st8, st9,
   st10, st11, st12, st13, st14, st15, st16, st17, st18, st19,
   st20, st21, st22, st23, st24, st25, st26, st27, st28, st29,
   st30, st31, st32, st33, st34, st35, st36, st37, st38, st39,
   st40, st41, st42, st43, st44, st45, st46, st47, st48, st49,
   st50, st51, st52, st53
  };

/* so wird die Tabelle ins RAM geschrieben:
#ifdef __cplusplus
struct mgtab {const char *symbol,*wert,*wertiso;};
#else
struct _mgtab {const char *symbol,*wert,*wertiso;};
typedef struct _mgtab mgtab;
#endif
const mgtab mgtabelle[] = //test
  {
   {"Ace", "43.04522", "43.018375"}, //Acethyl (H3C-C=O)
   {"Ac", "227.0278",  "227.0278" }, //Actinium
//    {"Ag", "107.8682", "106.90497" },
    {"Ala", "71.0788",  "71.037095"},
//    {"Al",  "26.9815",  "26.9815" }, //Aluminium
    {"Aib", "85.10568", "85.052745"},
    {"Aha","126.11784", "126.05413"},
    {"Arg","156.18748", "156.10108"},
//    {"Ar",  "39.948",  "39.96238"  },
    {"Asn","114.10384", "114.04289"},
    {"Asp","115.08860", "115.026895"},
/ *
    {"As",  "74.9216",  "74.9216" },
    {"Am", "243.0614", "243.0614" },
    {"At", "209.9871", "209.9871" },
    {"Au", "196.9665", "196.9665" },
    {"Ba", "137.327", "137.90501" },
    {"Be",   "9.01218",  "9.01218"},
    {"Bi", "208.9804", "208.9804" },
    {"Bk", "247.0703", "247.0703" },
* /
    {"Br",  "79.909",  "78.91835"  },
    {"Boc","101.12526","101.060225"},
    {"Bzl", "91.13258", "91.054775"},
    {"Bu",  "57.11546", "57.070425"}, // Butyl
    {"Ca",  "40.078",   "39.96259" },
    / *
    {"Cd", "112.411", "113.90357" },
    {"Ce", "140.115", "139.90528" },
    {"Cf", "251.0796", "251.0796" },
    * /
    {"Cl",  "35.453",  "34.96885" },
    / *
    {"Cm", "247.0703", "247.0703" },
    {"Cp",  "65.0947", "65.039125"}, // Cyclopentadienyl (C5H5)
    {"Cr",  "51.9961",  "51.94051"},
    {"Cs", "132.9051", "132.9051" },
    {"Co",  "58.9332",  "58.9332" },
    {"Cu",  "63.546",  "62.9296"  },
    * /
    {"Cys","103.14480","103.009165"},
    / *
    {"Dy", "162.5",   "162.5"    },
    {"Er", "167.26",  "167.26"   },
    {"Es", "252.0829","252.0829" },
    * /
    {"Et",  "29.06170", "29.039125"}, // Ethyl
//    {"Eu", "151.965", "151.965"  },
//    {"Fe",  "55.847", "55.93493" },
    {"Fmoc","223.25114","223.075875"}, //Fmoc-Schutzgruppe
    / *
    {"Fm", "257.0951", "257.0951" },
    {"Fr", "223.0197", "223.0197" },
    {"Ga",  "69.723",  "68.92568" },
    {"Gd", "157.25",  "157.25"    },
    {"Ge",  "72.61",   "73.92115" },
    * /
    {"Gly", "57.05192", "57.021445"},
    {"Gln","128.13072","128.05854" },
    {"Glu","129.11548","129.042545"},
    / *
    {"He", "4.002602", "4.002604" },
    {"Hf", "178.49",  "179.94681" },
    {"Hg", "200.59",  "201.97063" },
    {"Ho", "164.9303", "164.9303" },
    * /
    {"His", "137.14108","137.058885"},
    {"Ile", "113.15944","113.084045"},
    / *
    {"In", "114.82", "114.90407" },
    {"Ir", "192.22", "192.96328" },
    {"Kr", "83.80",   "83.9115"  },
    {"La", "138.9055","138.90606"},
    * /
    {"Li", "6.941", "7.016005" },
    / *
    {"Lr", "260.1053", "260.1053"},
    {"Lu", "174.967",  "174.967" },
    * /
    {"Leu","113.15944","113.084045"},
    {"Lys","128.17408","128.09494"},
    //    {"Md", "258.0986", "258.0986" },
    {"Met","131.19856","131.040465"}, //Methionin
    {"Me",  "15.03482",  "15.023475"}, //Methyl
    / *
    {"Mg",  "24.305", "23.98505"},
    {"Mn",  "54.938", "54.938"  },
    {"Mo",  "95.94",  "97.90551"},
    * /
    {"Mz", "269.27982", "269.092565"}, //Mz-Schutzgruppe
    {"MZ", "269.27982", "269.092565"}, //Mz-Schutzgruppe
    {"Na",  "22.9897", "22.98977" },
    / *
    {"Nb",  "92.90638", "92.90638" },
    {"Nd", "144.24", "141.90748" },
    {"Ne",  "20.1797", "19.99244" },
    {"Ni",  "58.69", "57.93534" },
    {"No", "259.1009", "259.1009" },
    {"Np", "237.0482", "237.0482" },
    {"Os", "190.2", "191.96141" },
    {"Pa", "231.0359", "231.0359" },
    {"Pb", "207.2", "207.97664" },
    {"Pd", "106.42", "105.9032" },
    * /
    {"Phe","147.17656","147.068395"}, //Phenylalanin
    {"Ph",  "77.10570", "77.039125"}, //Phenyl (C6H5)
    //    {"Pm", "146.9151", "146.9151" },
    //    {"Po", "208.9824", "208.9824" }, //Polonium
    {"Pro", "97.11668", "97.052745"}, //Prolin
    / *
    {"Pr", "140.9077", "140.9077" }, //Praseodym (Praseodymium)
    {"Pt", "195.08", "194.96482" },
    {"Pu", "244.0642", "244.0642" },
    * /
    {"Pz", "239.25354", "239.082015"}, //Pz-Schutzgruppe
    {"PZ", "239.25354", "239.082015"}, //Pz-Schutzgruppe
    / *
    {"Ra", "226.0254", "226.0254" },
    {"Rb",  "85.4678", "84.91171" },
    {"Re", "186.207", "186.95596" },
    {"Rh", "102.9055", "102.9055" },
    {"Rn", "222.0176", "222.0176" },
    {"Ru", "101.07", "101.07" },
    {"Sb", "121.75", "120.90375" },
    {"Sc",  "44.95591", "44.95591"},
    * /
    {"Ser", "87.07820", "87.031995"}, //Serin
    {"Se",  "78.96",  "79.91651"   }, //Selen
    {"Si", "28.0855", "27.9769" },
    / *
    {"Sm", "150.36", "150.36" },
    {"Sn", "118.710", "119.90213" },
    {"Sr",  "87.62", "87.90561" },
    {"Ta", "180.9479", "180.9479" },
    {"Tb", "158.9253", "158.9253" },
    {"Tc",  "98.9063", "98.9063" },
    {"Te", "127.60", "129.9067" },
    * /
    {"Thr","101.10508", "101.047645"}, //Threonin
    / *
    {"Th", "232.0381", "232.0381" }, //Thorium
    {"Ti",  "47.88", "47.94795" },
    {"Tl", "204.3833", "204.97446" },
    {"Tm", "168.9342", "168.9342" },
    * /
    {"Trp","186.21320", "186.07929"},
    {"Tyr","163.17596", "163.063295"}, //Tyrosin
    {"Val", "99.13256", "99.068395"},
    / *
    {"Xe", "131.29", "131.90416" },
    {"Yb", "173.04", "173.93902" },
    {"Zn", "65.39",   "63.92915" },
    {"Zr", "91.224",  "89.90432" },
    * /
 //hier koennen noch weitere Abkuerzungen eingefuegt werden

 //Ein-Buchstaben-Abkuerzungen:
    {"B", "10.811", "11.0093" },
    {"C", "12.011", "12.000" },
    {"D", "2.014102", "2.014102"},
    {"F", "18.9984", "18.9984" },
    {"H", "1.00794", "1.007825" },
    {"I", "126.9044", "126.9044"},
    {"J", "126.9044", "126.9044"},
    {"K", "39.0983", "38.9637" },
    {"N", "14.0067", "14.00307"},
    {"O", "15.9994", "15.9949" },
    {"P", "30.9738", "30.9738" },
    {"S", "32.066",  "31.97207"},
    {"T",  "3.01605", "3.01605"},
    {"U", "238.0289", "238.05076"},
    {"V", "50.9415", "50.94398" },
    {"W", "183.85", "183.95099" },
    {"Y", "88.9059", "88.90543" },
    {"Z", "135.14238", "135.044575"}

  };
*/

/*
bool vergleichen(uint i,const char* s,int c)
{
 int c2;
 c2 = pgm_read_byte(s);
 //return (c2==c);
 return true;
}
*/

double mol_weight(char* formel,char** zs,int isoflag) // Berechne Molekulargewicht
{
 // Wenn isoflag gesetzt ist, werden nur haeufigste Isotope verwendet,
 // sonst wird das durchschnittliche Molekulargewicht berechnet.
 int c,klamzu;
 char *s;
 double m, summe=0;

// printf("mol_weight('%s')\n",formel);//test
 while(isformelzeichen(c= *formel) && c!=')' && c!=']')
  {if(c=='(' || c=='[')
	{if(c=='[') klamzu=']'; else klamzu=')';
	 m=mol_weight(++formel,&s,isoflag);
	 formel=s;
	 if(*formel++!=klamzu) {fehler1("fehlende Klammer"); break;}
	}
   else if(c=='^' && isdigit(formel[1]))
        {m=sterndach(formel,&s,isoflag|DACH);
	 formel=s;
	}
   else
        {if(!isupper(c))
		{fehler2("ungueltige Formel:",formel); break;}
         //if(islower(formel[1]) || (formel[1]=='Z' && (c=='P' || c=='M'))) //ist naechster Buchstabe ein Kleinbuchstabe, oder Ausnahmen PZ oder MZ?
	    {uint i; int k;                                                 //ja: Abkuerzung aus der Tabelle auslesen
/** mit mgtabelle[] im RAM:
	     for(i=0,m=0;i<sizeof(mgtabelle)/sizeof(mgtab);i++)
	      {
	       if(mgtabelle[i].symbol[0]==c)
	        {k=strlen(mgtabelle[i].symbol);
		 if(strncmp(&formel[1],&mgtabelle[i].symbol[1],k-1)==0)
		   {
#ifdef FLIESSZAHLKLASSE
		    if(isoflag==0)
		      m=Fliesszahl(mgtabelle[i].wert,0);
		    else
		      m=Fliesszahl(mgtabelle[i].wertiso,0);
#else
		    if(isoflag==0)
		      m=double(mgtabelle[i].wert);
		    else
		      m=double(mgtabelle[i].wertiso);
#endif
		    formel+=k; break;
		   }
	        }
	      }
**/
/** mit mgtabelle[] im FLASH: **/
	     for(i=0,m=0;i<sizeof(mgtabelle)/sizeof(const char*);i+=3)
	      {
	       if(pgm_read_byte(pgm_read_word(&mgtabelle[i]))==c)
	       //if(vergleichen(i,mgtabelle[i],c)) //test
	        {k=mystrlen_P(pgm_read_word(&mgtabelle[i]));
		 if(mystrncmp_P(formel,pgm_read_word(&mgtabelle[i]),k)==0
		    //|| (*formel=='C' && i==3) //test
		    )
		   {
		    uint i2 = (isoflag==0) ? i+1 : i+2;
#ifdef FLIESSZAHLKLASSE
		    m=Fliesszahl_P(pgm_read_word(&mgtabelle[i2]));
		    /*
		    if(k==0) m=Fliesszahl("12.0",0);//test
		    else if(k==1) m=Fliesszahl("12.1",0);//test
		    else if(k==2) m=Fliesszahl("12.2",0);//test
		    else if(k==3) m=Fliesszahl("12.3",0);//test
		    else m=Fliesszahl("12.9",0);//test
		    k=1;//test
		    */
#else
		    m=double(pgm_read_word(mgtabelle[i2])); //funktioniert vermutlich nicht
#endif
		    formel+=k; break;
		   }
		 //else {m=Fliesszahl("13.2",0); formel+=1; break;}//test
	        }
	      }
/** :im FLASH **/
	     if(i==1) set_actinium_warnung(); //Fuer Warnung um nicht Acethyl mit Actinium zu verwechseln
	    }
	 /*
	 else
	    {m = (isoflag==0) ? einzelzeichen[c-'A'] : einzelzeichen_iso[c-'A'];   //nein: dann ist es ein Element, das mit nur einem Buchstaben abgekuerzt wird.
	     if(m!=0) formel++;
	    }
	 */
        }
   if(m==0) {fehler2("Unbekannt:",formel); formel++; break;}
   if(isdigit(*formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else c=1;
   summe += c*m;
   while(ist_leer(*formel)) formel++;
  }
 if(c=='*')
  {formel++;
   if(isdigit(c= *formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else if(c=='^')
	{//Trick: z.B. *^13C2 soll 2 schon gezaehlte C als 13C rechnen
	 summe += sterndach(formel,&s,isoflag);
	 formel=s;
	 c=1;
	}
   else	c=1;
   summe += c*mol_weight(formel,&s,isoflag);
   formel=s;
  }
 *zs = formel;
 // printf("summe=%lf  *zs='%s'\n",summe,*zs);//test
 return summe;
}

/******************* Erweiterung fuer Isotope ************************/
/*
 Beispiel: Boc-Ala-Gly-Ala*^13C-Aib-OMe sollte 417.464 (417.227) geben
           (nicht 429.47 (429.23) wie mit alter Version)
 z.B. *^13C2 soll 2 _schon_gezaehlte_ C als 13C rechnen
 (im Gegensatz zu ^13C2 (ohne *) wo das wirklich 2 zusaetzliche C sind)
 Spezialfall Deuterium: z.B. *^D12

 Die Funktion sterndach() soll als Formel etwas in der Form
 "^<Zahl><Atom><Zahl>..." bekommen. (Der Stern wurde schon verarbeitet).
 Als Rueckgabewert soll die Differenzmasse berechnet werden, also markiertes
 minus nicht markiertes. zs soll dann noch die Restformel zurueckgeben.
 Beispiele: ^18O, ^13C6, ^6Li, ^208Pb, ^2H11, ^D11
 Spezialfall Deuterium: statt ^2H11 sollte ^D11 benutzt werden (genauer weil
 Deuterium nicht 2.000 sondern 2.014102 hat).
*/
double sterndach(char* formel,char** zs,int flags)
{
 char atom[3],*s;
 double summe,masse,alt;
 int c,k,anzahl;
 if(formel[0]!='^') fehler1("sterndach-Syntaxfehler");
 if(formel[1]=='D' || formel[1]=='T') //Spezialfall Deuterium u. Tritium
   {atom[0]=formel[1]; atom[1]=0;
    masse=mol_weight(atom,&s,0);
    atom[0]='H';
    k=2;
   }
 else //Normalfall
   {for(masse=0,k=1;(c=formel[k])!=0 && isdigit(c);k++)
          masse=10*masse+c-'0';
    if(masse<=1 || !isupper(formel[k])) fehler1("falsche Isotop-Syntax");
    atom[0]=formel[k++];
    c=formel[k];
    if(islower(c)) k++; else c=0;
    atom[1]=c;
    atom[2]=0;
   }
 for(anzahl=0;(c=formel[k])!=0 && isdigit(c);k++)
    anzahl=10*anzahl+c-'0';
 if(anzahl==0) anzahl=1;
 while(ist_leer(formel[k])) k++;
 *zs = &formel[k];
 alt = mol_weight(atom,&s,flags&ISO);
 if(alt==0 || alt-masse>5 || masse-alt>5) fehler1("Falsches-Isotop");
 if(flags&DACH)
   summe = masse * anzahl;
 else
   summe = (masse - alt) * anzahl;
 return summe;
}

/********************** Fehlermeldungen *************************/
static int errorflag=0;
static int actinium_warnung=0; //fuer Warnung um Actinium nicht mit Acetyl zu verwechseln
static char scratch[120],*errorstring=NULL,*warningstring=NULL;

void error_reset(char *errstr,char *warnstr)
{
 errorflag=0;
 actinium_warnung=0;
 errorstring=errstr;
 warningstring=warnstr;
 if(errorstring!=NULL) *errorstring=0;
 if(warningstring!=NULL) *warningstring=0;
}

void fehler1(const char *text)
{
 if(errorstring!=NULL) strcpy(errorstring,text);
 //else printf("%s\n",text);
 errorflag++;
}

void fehler0(const char *text,int c)
{
 sprintf(scratch,"%s %c",text,c);
 fehler1(scratch);
}

void fehler2(const char *text1,const char *text2)
{
 sprintf(scratch,"%s%s",text1,text2);
 fehler1(scratch);
}

void set_actinium_warnung(void) {actinium_warnung++;}
int  get_actinium_warnung(void) {return actinium_warnung;}

void warnung1(const char *text)
{
 if(warningstring!=NULL) strcpy(warningstring,text);
}

/************************ Hauptaufruf ***************************/
double calculate_mol_weight(const char *formel,int isoflag)
{
 //char normierteformel[800], *s;
 char *normierteformel, *s;
 double result=0;
 int n,max2;
 //error_reset(NULL,NULL); //test
 max2=4*strlen(formel)+1;
 normierteformel=(char*)calloc(max2,1);
 if(normierteformel==NULL)
  {fehler1("zu wenig Speicher"); return result;}
 formel_normieren(formel,normierteformel,strlen(formel)+1,max2);
 n=klammertest(normierteformel);
 if(n<0)
  fehler1("fehlende Klammer auf");
 else if(n>0)
  fehler1("fehlende Klammer zu");
 else
  {
   result=mol_weight(normierteformel,&s,isoflag);
   if(actinium_warnung>0) warnung1("Hinweis: Ac = Actinium, Ace = Acetyl");
  }
 free(normierteformel);
 return result;
}

/*****************Erweiterung fuer Summenformeln *********************/
#ifdef SUMMENFORMELN

const char *getsummenformel_pep(const char *peptid)
{
 int c=dreibuchstaben_auf_einbuchstaben_abkuerzung_reduzieren(peptid);
 return aminos[c-'A'].summenformel;
}

char *getsymbol(const char **zs)  //Symbol auslesen und Zeiger zs entsprechend erhoehen
{
 static char sym[8]; //Abkuerzungen sind hoechstens 4 Zeichen lang, 8 ist also ausreichend
 char *p=sym;
 int c,i;
 const char *s;
 s = *zs;
 //printf("getsymbol('%s')\n",s);//test
 if(!isupper(*s))           //ist erstes Zeichen ein Grossbuchstabe?
   {sym[0]=0; return sym;}  //nein: mit leerem String zurueckkehren
 //printf(" '%c'",*s);//test
 *p++ = c = *s++;  //erster Grossbuchstabe kopieren
 i=1; //bisher 1 Zeichen kopiert
 if((c=='P' || c=='M') && s[0]=='Z' && !islower(s[1])) //Ausnahmen PZ und MZ behandeln
   {*p++ = *s++;}                  
 else
  while((c= *s)!=0 && islower(c))  //solange Kleinbuchstaben folgen
    {
     if(++i<8) *p++ = c;      //diese kopieren (aber maximal 8)
     s++;
    }
 *p = 0;  //den String mit 0 abschliessen
 //printf(" sym[8] = '%s'\n",sym);//test
 *zs = s;
 return sym;
}

int getnumber(const char **zs)
{
 int c,z=0;
 const char *s;
 s = *zs;
 while(isdigit(*s))
  {
   c = *s++;
   z=10*z+c-'0';
  }
 *zs = s;
 return z;
}

const char* elemente[]= //Alle Elemente des Periodensystems bis zum Lr
 {"D","H","He", //Deuterium an Position 0, sonst ist Position jeweils Ordnungsnummer im Periodensystem
  "Li","Be","B", "C", "N", "O", "F", "Ne",
  "Na","Mg","Al","Si","P", "S", "Cl","Ar",
  "K", "Ca","Sc","Ti","V", "Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr",
  "Rb","Sr","Y", "Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I", "Xe",
  "Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf",
                      "Ta","W", "Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn",
  "Fr","Ra","Ac","Th","Pa","U", "Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr", //Lr ist Element Nr=103
  "Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn", //hier noch neue kuenstliche Elemente einfuegen (Cn ist Nr=112)
  "T" //zusaetzlich noch Tritium (Ordnungsnummer hier irrelevant)
 };
//#define ANZAHLELEMENTE 103
//#define ANZAHLELEMENTE 112

const char* getelementsymbol(int nr)
{
 return elemente[nr];
}

int elementnummer(const char *symbol)
{
 int nr;
 const int max=sizeof(elemente)/sizeof(char*);
 if(strcmp(symbol,"J")==0) symbol="I"; //Spezialfall: Jod mit 'J' abgekuerzt statt 'I'
 for(nr=0;nr<max;nr++)
   if(strcmp(symbol,elemente[nr])==0) return nr;
 return -1; //bei Fehler -1 zurueckgeben
}

//Alle Abkuerzungen, die keine Element und keine Standard-Aminsaeuren sind:
static Abkuerzungen summenformeltabelle[]=
 {
  {"Ace", "C2H3O"}, //Acethyl (H3C-C=O)
  {"Bzl", "C7H7"},
  {"Z",   "C8H7O2"},
  {"Boc", "C5H9O2"},
  {"Fmoc", "C15H11O2"},
  {"Me", "CH3"},
  {"Et", "C2H5"},
  {"Bu", "C4H9"},
  {"Ph", "C6H5"},
  {"PZ", "C14H11N2O2"},
  {"Pz", "C14H11N2O2"},
  {"MZ", "C15H13N2O3"},
  {"Mz", "C15H13N2O3"},
  {"Cp", "C5H5"},

  //hier koennen noch weitere Abkuerzungen eingefuegt werden
 };

char *getsummenformel(const char *formel,const char **zs)
{
 const char *s,*sym,*neu;
 char *summenformel=(char*)calloc(400,1);
 char *subformel=NULL;
 int i,c,n,index,z,klamzu;
 int element[120];
 int peptidmodus=0,knummer=0;
 for(i=0;i<120;i++) element[i]=0;
 summenformel[0]=0;
 //if(zs==NULL) printf("getsummenformel('%s',NULL)\n",formel);//test
 //else printf("getsummenformel('%s',zs)\n",formel);//test
 while((c= *formel)!=0 && c!=')' && c!=']' && c!=',')
  {
   if(c=='~') {peptidmodus ^= 1; ++formel; continue;}
   if(ist_leer(c)) {++formel; continue;}
   if(c=='^')
     {//Isotopmarkiertes Atom:
      while((c= *++formel)!=0 && isdigit(c))  ;//provi. Isotopangaben ignorieren
      warnung1("Isotope werden nicht in der Summenformel eingefuegt");
      continue;
     }
   if(c=='*')
     {++formel;
      if((c= *formel)=='^')  //Sterndach-Syntax ("*^") erkannt?
        {                    //ja: Isotop-Markierungen behandeln
	 char tmpstr[8];
	 c = formel[1];
	 if(!isdigit(c))
	  {if(c=='D') ;//H durch D ersetzen
	   else if(c=='T') ;//H durch T ersetzen
	   else {strncpy(tmpstr,formel,4); tmpstr[4]=0; fehler2("Syntaxerror: ",tmpstr);}
	  }
	 while((c= *++formel)!=0 && isdigit(c))  ;//provi. Isotopangaben ignorieren
	 sym=getsymbol(&formel); //provi. Isotop-Atom ignorieren
	 while(isdigit(*formel)) formel++; //provi. auch Anzahl ignorieren
	 warnung1("Isotope werden nicht in der Summenformel eingefuegt");
	 continue;
        }
      else  //Wenn nach dem '*' kein '^' kommt, dann Kristallwasser-Syntax (z.B. Na2SO4*10H2O)
        {
	 knummer = (isdigit(c)) ? getnumber(&formel) : 1;
	 neu=subformel=getsummenformel(formel,&s);
	 formel=s;
	}
     }
   else if(c=='(' || c=='[')
     {
      if(c=='(') klamzu=')'; else klamzu=']';
      neu=subformel=getsummenformel(++formel,&s);
      formel=s;
      if(*formel++ != klamzu) fehler1("Klammerfehler");
      //printf("Summenformel vom Klammernteil='%s' Restformel='%s'\n",neu,formel);//test
     }
   else
     {
      Abkuerzungen *p;
      //const char *stest=formel;//test
      sym=getsymbol(&formel);
      //printf("sym=getsymbol('%s') --> sym='%s' formel='%s'\n",stest,sym,formel);//test
      if(*sym==0) {fehler1("Fehler in getsummenformel() nach getsymbol()"); return summenformel;}
      neu="";
      if(peptidmodus!=0 && strlen(sym)==1 && (c=sym[0])!=0 && isupper(c))
        {
	 neu=aminos[c-'A'].summenformel;
        }
      else
       for(p=aminos,i=0;i<sizeof(aminos)/sizeof(Abkuerzungen);i++,p++)
	{if(strcmp(sym,p->sym)==0) {neu=p->summenformel; break;}
	}
      if(*neu==0)
       for(p=summenformeltabelle,i=0;i<sizeof(summenformeltabelle)/sizeof(Abkuerzungen);i++,p++)
	{if(strcmp(sym,p->sym)==0) {neu=p->summenformel; break;}
	}
      if(*neu==0)
        neu=sym;
      //printf("Summenformel von aktuellem Symbol: '%s'\n",neu);//test
     }
   if(knummer!=0)            {index=knummer; knummer=0;}
   else if(isdigit(*formel)) {index=getnumber(&formel);}
   else                      {index=1;}
   while(*neu!=0)
    {
     s=getsymbol(&neu);
     if(*s==0) fehler2("Fehler in getsymbol(): ",neu);//test
     n = elementnummer(s);
     z = (isdigit(*neu)) ? getnumber(&neu) : 1;
     if(n<0) fehler2("Unbekanntes Element: ",s);
     else    element[n] += z*index;
    }
   if(subformel!=NULL) {free(subformel); subformel=NULL;}
  }
 if(zs!=NULL) *zs=formel;

 //aus der Liste der benutzten Elemente die Summenformel konstuieren:
 char zahltext[40],*st;
 int j;
 for(st=summenformel,i=0,j=6;i<120 && j<400;i++)
  {
   if(element[i]!=0)
    {
     sym=getelementsymbol(i);
     while((c= *sym++)!=0) {*st++ = c; j++;}
     if(element[i]>1)
      {sprintf(zahltext,"%d",element[i]);
       for(sym=zahltext;(c= *sym++)!=0;) {*st++ = c; j++;}
      }
    }
  }
 *st=0;
 if(j>=400) fehler1("Speicher fuer Summenformel zu klein");

 //provi. hier muesste die Summenformel noch alfabetisch nach Elementen sortiert werden
 summesortieren(summenformel);

 return summenformel;
}

/** Summenformel sortieren: **/
const char *getsymbolundzahl(char **zs)   //z.B. 'Na2C15H27' --> sym="Na2" *zs="C15H27"
{
 static char sym[16];
 char *s,*y=sym;
 int c;
 s = *zs; //Zeiger vom zu lesenden String
 *y++ = c = *s++;
 if(c==0) return sym; //bei Aufruf mit leerem String auch wieder leerer String zurueckgeben
 while((c= *s++)!=0 && !isupper(c))
   *y++ = c;
 --s; //zuviel gelesenes zurueckstellen
 *y=0;
 *zs = s; //erhoehter Zeiger speichern
 return sym;
}

void einfuegen(char *puffer,const char *sym)
{
 int c, len1=strlen(puffer), len2=strlen(sym);
 char *p1,*p2;
 for(p1= &puffer[len1], p2=p1+len2, *p2=0; p1!=puffer;) //Inhalt von puffer um len2 nach hinten schieben
   *--p2 = *--p1;
 while((c= *sym++)!=0)
   *puffer++ = c;
}

void einsortieren(char *puffer,const char *sym)
{
 int c,gross,klein;
 gross = sym[0]; //erster Buchstabe muss ein Grossbuchstabe sein
 klein = sym[1]; //weiterer kann ein Kleinbuchstabe sein
 if(!islower(klein)) klein=0; //falls nicht: auf 0 setzen
 for(;;)
  {
   c = *puffer; //Erstes Zeichen der bisherigen Formel
   if(c==0)                //sind wir am Ende des Puffers?
     {while((*puffer++ = *sym++)!=0) ; //ja: hier hineinkopieren, inklusive 0-Zeichen
      return;
     }
   if(c > gross || (c==gross && puffer[1]>klein)) //ist aktuelles Symbol weiter hinten im Alfabet?
      {einfuegen(puffer,sym);                     //ja: neues Symbol hier einfuegen
       return;
      }
   while((c= *++puffer)!=0 && !isupper(c)) ;  //neues Symbol im Puffer suchen
  }
}

void summesortieren(char *summenformel)
{
 char *s1,*s2;
 const char *sym;
 char *puffer=(char*)malloc(strlen(summenformel)+1);
 s1=summenformel;
 s2=puffer;
 *s2=0;
 while(*s1!=0)
  {
   sym=getsymbolundzahl(&s1);
   if(*sym==0) {fehler2("Fehler in summesortieren() s1=",s1); return;}
   einsortieren(puffer,sym);
  }
 strcpy(summenformel,puffer);
 free(puffer);
}
/**/

#endif
