/* doub2fliess.cc			letzte Aenderung: 15.1.2012 */
#define VERSION "Version 0.0"
/*

 Kurzbeschreibung: wandelt double in Flisszahl

History:
15.1.2012	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/************************* Vordeklarationen ***************************/
void unterprog(FILE *fp1,FILE *fp2);

/************************* Globale Variablen **************************/
static int workbenchflag=0;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/
bool istja(char *s)
{
 int c= *s;
 return (c=='j' || c=='J' || c=='y' || c=='Y');
}

/************** Klassen und Hauptteil des Programms *******************/

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 FILE *fp1,*fp2;
 int i,j,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
   workbenchflag=1;
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j>MAXARG)
	{printf("doub2fliess  %s\n",VERSION);
	 printf("Anwendung: doub2fliess Quelle Ziel\n");
	 exit(0);
	}
 if(*quellname==0) {printf("Quellname:"); scanf("%s",quellname);}
 if(*zielname==0)  {printf("Zielname:"); scanf("%s",zielname);}
 if((fp1=fopen(quellname,"r"))==NULL) printf("Kann '%s' nicht oeffnen\n",quellname);
 else if(fp2=fopen(zielname,"w"))
  {printf("Datei '%s' erfolgreich erstellt.\n",zielname);
   unterprog(fp1,fp2);
  }
 else printf("Datei '%s' konnte nicht erstellt werden.\n",zielname);
 if(fp1) fclose(fp1);
 if(fp2) fclose(fp2);
 return 0;
}/* ende von main */

bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

void putline(FILE *fp,const char *s) /* wie fprintf(fp,"%s\n",s)  aber */
{				     /* ohne ein Nullbyte zu schreiben */
 char c;
 while(c= *s++)  putc(c,fp);
 putc('\n',fp);
}

char *textput(char *s,const char *t)
{
 int c;
 while((c= *t++)!=0) *s++ = c;
 return s;
}

bool istfliesszahl(const char *s)
{
 int c,ok=0;
 c= *s++;
 if(c==0 || !isdigit(c)) return false;
 while((c= *s++)!=0)
  {
   if(c=='.') ok++;
   else if(!isdigit(c)) break;
  }
 return ok==1;
}

void unterprog(FILE *fp1,FILE *fp2)
{
 int c,stringflag=0;
 char zeile[400],zeile2[400], *s1,*s2;
 putline(fp2,"/* diese Datei wurde von doub2fliess.cc erstellt */");
 while(getline(fp1,zeile,400))
  {
   for(s1=zeile,s2=zeile2; (c= *s1)!=0; )
    {
     if(stringflag==0 && istfliesszahl(s1))
      {
       s2=textput(s2,"Fliesszahl(\"");
       while(isdigit(c) || c=='.')
	{*s2++ = c; c= *++s1;}
       s2=textput(s2,"\",0)");
      }
     else
      {
       if(c=='"') stringflag ^= 1;
       *s2++ = c;
       s1++;
      }
    }
   *s2=0;
   putline(fp2,zeile2);
  }
}
