/* int48.cc
Rechnen mit 48-Bit-Zahlen
Anwendung: einfgen in C++ Programmen
*/

#ifndef INT48KLASSE_CC
#define INT48KLASSE_CC

typedef unsigned char uint8;

#ifdef LONGMULT
class int96  //Fuer Resultat bei langer Multiplikation von int48
{
public:
 unsigned char uc[12]; //[0]=niederstwertiges ... [11]=hoechstwertiges Byte
 int96(long a=0) {for(uint8 i=0;i<12;i++) {uc[i]=a; a>>=8;}}
 int96& operator<<=(int8 n);
};
#endif

class int48
{
 char uc[6]; //[0]=niederstwertiges ... [5]=hoechstwertiges Byte
public:
 int48(long a=0) {for(int i=0;i<6;i++) {uc[i]=a; a>>=8;}}
 int48& operator=(int48 v) {for(int i=0;i<6;i++) uc[i]=v.uc[i]; return *this;}
 int48& operator+=(int48 v);
 int48& operator-=(int48 v);
 int48& operator*=(int48 z);
 int48& operator/=(int48 z);
 int48& operator%=(int48 z);
 int48& operator++();
 friend int48 operator%(int48 v1,int48 v2);
 friend int48 operator+(int48,int48);
 friend int48 operator-(int48,int48); //Subtraktions-Operator
 friend int48 operator-(int48); //Vorzeichen-Operator
 friend int48 operator*(int48,int48);
 friend int48 operator/(int48,int48);
 friend int48 abs(int48);
 bool operator!=(char z);
 bool operator<=(int48 v);
 bool operator==(char z);
 int48& operator<<=(int8 n);
 int48& operator>>=(int8 n); //nach rechts schieben und als hoechstwertiges Bit 0 setzen
 bool rshift();  //Vorzeichenbehaftet nach rechts schieben, false wenn Resultat 0 ist oder -1 bleibt
 char& operator[](int n) {return uc[n];}
#ifdef TESTSTR
 char *str();
#endif
 void setnegbit() {uc[5] |= 0x80;}
 void clrnegbit() {uc[5] &= ~0x80;}
 bool isnegativ() {return (uc[5]&0x80);}
#ifdef LONGMULT
 friend int96 multu48(int48,int48);
#endif
 //friend long long getlonglong(int48 v);
 int8 getint8() {return uc[0];}
};

/*
long long getlonglong(int48 v)
{
 int8 i=6-1;
 long long result=v.uc[i];
 while(--i>=0)
   result = (result<<8) + (v.uc[i]&0xFF);
 return result;
}
*/

int48& int48::operator++()
{
 uint8 i; int8 c=0xFF;
 for(i=0;c!=0 && i<6;i++)
   {
    if(uc[i]!=c) c=0;
    uc[i]++;
   }
 return (*this);
}

int48& int48::operator+=(int48 v)
{
 int i,c; char cy=0;
 for(i=0;i<6;i++)
   {c = (uc[i]&0xFF) + (v.uc[i]&0xFF) + cy;
    uc[i]=c;
    cy=(c>>8)&1;
   }
 return (*this);
}

int48 operator+(int48 v1,int48 v2)
{
 return v1+=v2;
}

int48& int48::operator-=(int48 v)
{
 v = -v;
 return (*this) += v;
}

int48 operator-(int48 v1,int48 v2)
{
 return v1-=v2;
}

int48 operator-(int48 v1)
{
 int i,c,cy=1;
 for(i=0;i<6;i++) v1.uc[i] = ~v1.uc[i];
 for(i=0;i<6;i++)
   {c = (v1.uc[i]&0xFF) + cy;
    v1.uc[i]=c;
    cy=(c>>8)&1;
   }
 //if(uc[5]&0x80) Ueberlauf_Fehler();
 return v1;
}

int48 abs(int48 v)	//Betrag
{
 if(v.uc[5]&0x80)  v = -v;
 return v;
}

bool int48::operator!=(char z)
{
 int i;
 if(uc[0]!=z) return true;
 if(z<0) z = -1; else z=0;
 for(i=1;i<6;i++)
   if(uc[i]!=z) return true;
 return false;
}

bool int48::operator==(char z)
{
 return !((*this)!=z);
}

bool int48::operator<=(int48 v)
{
 int i;
 if((uc[5]&0x80)==0 && (v.uc[5]&0x80)!=0) return false; //wenn nur v negativ ist: nein
 if(uc[5]&0x80)
   {if((v.uc[5]&0x80)==0) return 1; //wenn *this negativ und v positiv ist: ja
    if(uc[5]!=v.uc[5]) return uc[5]<=v.uc[5];
    for(i=4;i>=0;--i)
      {if(uc[i]!=v.uc[i])
	 return (uc[i]&0xFF) > (v.uc[i]&0xFF);
      }
   }
 else
   for(i=5;i>=0;--i)
     {if(uc[i]!=v.uc[i])
        return (uc[i]&0xFF) < (v.uc[i]&0xFF);
     }
 return true;
}

int48& int48::operator<<=(int8 n)
{
 int i,c,cy=0;
 for(;n>=1;--n)
  {for(i=0;i<6;i++)
     {c=(uc[i]<<1)+cy;
      cy=(uc[i]>>7)&1;
      uc[i]=c;
     }
  }
 return (*this);
}

int48& int48::operator>>=(int8 n)
{
 int i,c,cy=0;
 for(;n>=1;--n)
  {for(i=5;i>=0;--i)
     {c=((uc[i]>>1)&0x7F)+cy;
      cy=(uc[i]&1)<<7;
      uc[i]=c;
     }
  }
 return (*this);
}

bool int48::rshift()  //Vorzeichenbehaftet nach rechts schieben, false wenn Resultat 0 ist oder -1 bleibt
{
 int8 i,c, cy = (uc[5]&0x80);
 bool a1=false,a2=false;
 for(i=6;i>0;)
     {c = ((uc[--i]>>1)&0x7F) + cy;
      //cy = (uc[i]&1)<<7;
      cy = (uc[i]&1) ? 0x80 : 0;
      uc[i] = c;
      if(c!=0) a1=true;
      if((c&0xFF)!=0xFF) a2=true;
     }
 return (a1 || (a2 && cy!=0));
}

int48& int48::operator/=(int48 z)
{
 int neg=0,j;
 int48 result(0),faktor(1);
 if(uc[5]&0x80) //linke Zahl negativ?
   {(*this) = -(*this);  neg=1;} //ja: positiv machen
 if(z.uc[5]&0x80) //rechte Zahl negativ?
   {z = -z;  neg ^= 1;} //ja: positiv machen
 if((*this)!=0 && z!=0)
      {
       for(j=0;(z.uc[5]&0x80)==0 && z<=(*this);j++) //verdoppeln bis Teiler groesser als Zahl ist
         {z<<=1; faktor<<=1;}
       while(--j>=0)
	 {z>>=1; faktor>>=1;
	  if(z<=(*this)) {result += faktor; (*this) -= z;}
	 }
      }
 if(neg) (*this) = -result; //eventuell Vorzeichen setzen
 else    (*this) = result;
 return (*this);
}

int48 operator/(int48 v1,int48 v2)
{
 return v1/=v2;
}

int48& int48::operator%=(int48 z)
{
 bool neg=false;
 if((uc[5]&0x80)!=0) //negativ?
   {(*this) = -(*this);  neg=true;} //ja: positiv machen und Flag setzen
 if((z.uc[5]&0x80)!=0) //z negativ?
  {z = -z;} //ja: positiv machen. Vorzeichen hat keinen Einfluss auf Rest
 int48 result=0,faktor=1;
 int j;
 if((*this)!=0 && z!=0)
      {// Division wie bei operator/=, (*this) enthaelt danach automatisch den Rest
       for(j=0;(z.uc[5]&0x80)==0 && z<=(*this);j++) //verdoppeln bis Teiler groesser als Zahl ist
         {z<<=1; faktor<<=1;}
       while(--j>=0)
	 {z>>=1; faktor>>=1;
	  if(z<=(*this)) {result += faktor; (*this) -= z;}
	 }
      }
 if(neg)  (*this) = -(*this);
 return (*this);
}

int48 operator%(int48 v1,int48 v2)
{
 return v1 %= v2;
}

int48& int48::operator*=(int48 z)
{
 int neg=0;
 int48 result(0);
 if(uc[5]&0x80) //linke Zahl negativ?
   {(*this) = -(*this);  neg=1;} //ja: positiv machen
 if(z.uc[5]&0x80) //rechte Zahl negativ?
   {z = -z;  neg ^= 1;} //ja: positiv machen
 while(z!=0)
   {
    if(z.uc[0]&1) result += (*this);
    z >>= 1;
    (*this) <<= 1;
   }
 if(neg) (*this) = -result; //eventuell Vorzeichen setzen
 else    (*this) = result;
 return (*this);
}

int48 operator*(int48 v1,int48 v2)
{
 return v1 *= v2;
}

#ifdef TESTSTR
static char int48puffer[4*32];
static char int48puffer2[4*40];

char *new_char32()
{
 static uint8 j=0;
 char *s;
 s = &int48puffer[j];
 if((j+=32) == 4*32) j=0;
 return s;
}

char *new_char40()
{
 static uint8 j=0;
 char *s;
 s = &int48puffer2[j];
 if((j+=40) == 4*40) j=0;
 return s;
}

char *int48::str()
{
 //char *txt=new char[32]; //geht so nicht auf AVR
 char *txt=new_char32();
 char puf[32];
 char *s,*t;
 int48 v;
 bool neg=false;
 if(uc[5]&0x80) {v = -(*this); neg=true;}
 else v=(*this);
 for(s=puf;v!=0;v/=10)  *s++ = (v%10)[0]+'0';
 *s = '0';
 while(s!=puf && *s=='0') --s; //fuehrende Nullen unterdruecken
 t=txt;
 if(neg) *t++ = '-';
 while(s!=puf)  *t++ = *s--;
 *t++ = *s;
 *t=0;
 return txt;
}
#endif

#ifdef LONGMULT
int96& int96::operator<<=(int8 n)
{
 uint8 i,c,cy=0;
 while(--n>=0)
  {for(i=0;i<12;i++)
     {c=(uc[i]<<1)+cy;
      cy=(uc[i]>>7)&1;
      uc[i]=c;
     }
  }
 return (*this);
}

int96 multu48(int48 x,int48 z)
{
 int96 result(0),y(0);
 int c;
 uint8 i,cy;
 for(i=0;i<6;i++) y.uc[i]=x[i];
 while(z!=0)
   {
    if(z.uc[0]&1)
      {
       //result += y:
       for(i=0,cy=0;i<12;i++)
	 {
	  c = result.uc[i] + y.uc[i] + cy;
	  result.uc[i] = c;
	  cy = c>>8;
	 }
      }
    z >>= 1;
    y <<= 1;
   }
 return result;
}
#endif

#endif
