/* lcd_treiber.h    letzte Aenderung: 13.12.2011  Einstellungen fuer tarech2: 1.1.2012
Version 0.3

Erklaerungen siehe lcd_treiber.c
*/

//Falls mehrfach eingefuegt, dann nur erstes Mal machen:
#ifndef LCD_TREIBER_H
#define LCD_TREIBER_H

//------------------------------------------------------------------------------
//Hier Einstellungen fuers Zielsystem machen:

// Auswahl des LCD-Moduls:
//Genau eine der folgenden Zeilen nicht auskommentieren,
//oder dann im makefile entsprechend setzen:
//#define LCD_EADOG
//#define LCD_MK3
//#define LCD_SIMULATOR

// Auswahl von Controller und Anschlussvariante:
//Genau eine der folgenden Zeilen nicht auskommentieren,
//oder dann im makefile entsprechend setzen:
//#define ATMEGA644
//#define ATMEGA2560

//------------------------------------------------------------------------------
#ifdef LCD_SIMULATOR
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
#else
#include <avr/io.h>
#include <stdio.h>
#endif

//------------------------------------------------------------------------------
// Auswahl der Ports und Bits fuers EADOGM oder EADOGL:

#ifdef LCD_EADOG

// das EADOG braucht 5 Ports, alles Ausgaenge:

#ifdef ATMEGA644
//hier ein Beispiel fuer eine Schaltung mit dem Atmega644

#define MOSI_PORT PORTB
#define MOSI_DDR  DDRB
#define MOSI_BIT  5

#define SCK_PORT PORTB
#define SCK_DDR  DDRB
#define SCK_BIT  7

#define A0_PORT PORTA
#define A0_DDR  DDRA
#define A0_BIT  0

#define RST_PORT PORTB
#define RST_DDR  DDRB
#define RST_BIT  2

#define CS_PORT PORTA
#define CS_DDR  DDRA
#define CS_BIT  1

//#define HLED_PORT PORTA  //Port fuer Hintergrundbeleuchtung
//#define HLED_DDR  DDRA   //Port fuer Hintergrundbeleuchtung
//#define HLED_BIT  2           //Bit der Hintergrundbeleuchtung

#define HLED_PORT PORTD  //Test mit LED
#define HLED_DDR  DDRD   //Port fuer Hintergrundbeleuchtung
#define HLED_BIT  5      //Bit der Hintergrundbeleuchtung

//Ende ATMEGA644
#endif

#ifdef ATMEGA2560
//hier ein Beispiel fuer eine Schaltung mit dem Atmega2560

#define MOSI_PORT PORTB
#define MOSI_DDR  DDRB
#define MOSI_BIT  2

#define SCK_PORT PORTB
#define SCK_DDR  DDRB
#define SCK_BIT  1

#define A0_PORT PORTB
#define A0_DDR  DDRB
#define A0_BIT  6

#define RST_PORT PORTB
#define RST_DDR  DDRB
#define RST_BIT  5

#define CS_PORT PORTB
#define CS_DDR  DDRB
#define CS_BIT  4

#define HLED_PORT PORTB  //Port fuer Hintergrundbeleuchtung
#define HLED_DDR  DDRB   //Port fuer Hintergrundbeleuchtung
#define HLED_BIT  7      //Bit der Hintergrundbeleuchtung

//Ende ATMEGA2560
#endif

#define SOFTWARE_SPI        //wenn auskommentiert, dann wird Hardware_SPI verwendet
//#define LADUNGSPUMPE_OFF  //wenn am LCD eine externe "Hochspannung" angeschlossen ist

//Ende Einstellungen fuers LCD_EADOG
#endif

//------------------------------------------------------------------------------
// Auswahl der Ports und Bits fuers LCD auf dem MK3:
#ifdef LCD_MK3

// von www.Mikrocontroller-4U.de uebernommen:

#define MK3_DDR_LCDD DDRC	// DDR-Register der LCD-Daten
#define MK3_PORT_LCDD PORTC	// Port der LCD-Daten
#define MK3_PIN_LCDD PINC	// Pin der LCD-Daten

#define MK3_DDR_LCDC DDRA	// DDR-Register der LCD-Control
#define MK3_PORT_LCDC PORTA	// Port der LCD-Control
//#define MK3_PIN_LCDC PINA	// Pin der LCD-Control

#define LCD_PS   0x80		// Mode:       0=Seriell, 1=Parallel
#define LCD_MI   0x40		// Mode:       0=8080   , 1=6800
#define LCD_HB   0x20		// Beleuchtung:0=AUS    , 1=EIN
#define LCD_CLK  0x10           // Clk:        Daten bei Hi-Flanke
#define LCD_WR   0x08           // ReadWrite:  0=Write  , 1=Read
#define LCD_RS   0x04           // C/D:        0=Control, 1=Data
#define LCD_RST  0x02		// Reset:      0=reset  , 1=go
#define LCD_CS   0x01           // ChipSelect: 0=enable , 1=disable

#define HLED_PORT PORTA  //Port fuer Hintergrundbeleuchtung
#define HLED_DDR  DDRA   //Port fuer Hintergrundbeleuchtung
#define HLED_BIT  5      //Bit der Hintergrundbeleuchtung

//Ende Einstellungen fuers LCD_MK3
#endif

//------------------------------------------------------------------------------
// Auswahl der Ports und Bits fuer den LCD-Simulator:
#ifdef LCD_SIMULATOR

#define HLED_PORT PORTD  //Port fuer Hintergrundbeleuchtung
#define HLED_DDR  DDRD   //Port fuer Hintergrundbeleuchtung
#define HLED_BIT  5      //Bit der Hintergrundbeleuchtung

#define YZUSATZ 300   //zusaetzliche Fensterhoehe um ausser LCD noch andere Sachen zu simulieren.
                      //z.B. 100 fuer LEDs, + 200 fuer Tastenmatrix

#ifdef ATMEGA2560
//hier ein Beispiel fuer eine Schaltung mit dem Atmega2560
#define PORT_LED1 PORTD
#define DDR_LED1  DDRD
#define BIT_LED1  5

//Ende ATMEGA2560
#endif

#ifdef ATMEGA644
//hier ein Beispiel fuer eine Schaltung mit dem Atmega644
#define PORT_LED1 PORTD
#define DDR_LED1  DDRD
#define BIT_LED1  5
#define PORT_LED2 PORTD
#define DDR_LED2  DDRD
#define BIT_LED2  6

//Ende ATMEGA644
#endif

//Ende Einstellungen fuer LCD_SIMULATOR
#endif

//------------------------------------------------------------------------------
// Auswahl von hoeheren Funktionen:

#define LINIENZEICHNEN   //zum Zeichnen von geraden Linien und Vierecken
#define FIGURENFUELLEN   //zum Fuellen von z.B. Vierecken

#define FONTTABELLE      //fuer Schrift auf dem Grafik-LCD
#define UTF8ZEICHEN      //einige UTF8-Zeichen im Zeichensatz einfuegen
                         //(in glcd_print() und glcd_printc() benutzt)

// Von einigen LCDs (z.B. EADOG) koennen keine Daten zurueckgelesen werden.
// Es braucht deshalb ein Abbild vom Bildinhalt im RAM:
#define BILDPUFFER 1 //Anzahl Abbildungen des Bildspeichers im RAM (0 bis 2)
//Achtung: wenn nicht gebraucht nicht auskommentieren, sondern auf 0 setzen.

// Weitere Anmerkungen zum Bildpuffer:
// Wenn auf 0 gesetzt, dann sind Linien zeichnen ohne andere Pixel zu veraendern
// nicht moeglich. Auch koennen Texte dann nur an durch 8 teilbaren y-Positionen
// stehen. Fuer Animationen kann es Sinn machen den Wert 2 zu verwenden. Dann
// kann man in den zweiten Bildspeicher speichern waehrend der erste noch
// dargestellt wird.

//------------------------------------------------------------------------------
// Wartefunktionen:

// Hier die Namen der eigenen Wartefunktionen eintragen:
//#define MICROWAIT mymicrowait
#define MILLIWAIT milliwait
// Wenn diese beiden Zeilen auskommentiert sind,
// dann werden die Funktionen aus <util/delay.h> benutzt.

#ifdef MICROWAIT
void MICROWAIT(uint16_t n);  // Etwa n Microsekunden warten
#endif
#ifdef MILLIWAIT
void MILLIWAIT(uint n);  // Mindestens n Millisekunden warten
#endif

//Ende der Grundeinstellungen.
//------------------------------------------------------------------------------

#ifndef uchar
typedef unsigned char uchar;
#endif
#ifndef uint
typedef unsigned int  uint;
typedef unsigned long ulong;
#endif

#ifndef __cplusplus
typedef int8_t bool;
#define false 0
#define true (0xFF)
#endif

//------------------------------------------------------------------------------
// Feste Werte: (Dieser Treiber unterstuetzt bisher nur Displays mit 128x64)
#define LCD_MAXY 64  	// Anzahl der Pixel in Y-Richtung (0...63)
#define LCD_MAXX 128 	// Anzahl der Pixel in X-Richtung (0...127)

// Prototypen der verwendbaren Funktionen:
void glcd_init();           // LCD initialisieren
void glcd_clear();          // Loeschen des LCD
void glcd_licht(bool on);   // Hintergrundlicht Ein/Aus-Schalten (true=ein, false=aus)
void lcdSendCmd(uchar c);   // Kommando ans LCD senden
void lcdSendData(uchar c);  // Daten ans LCD senden
void lcdSendDataCur(uchar); // Daten senden und Cursor erhoehen
void glcd_cursor(uint8_t x,uint8_t y); // Setzen des Cursors (x horizontal 0..127, y vertikal 0..63)
uchar lcdReadData();        // Liest ein Byte von Cursor-Position aus
void glcd_off();            // LCD-Modul ganz ausschalten (danach wieder mit glcd_init() einschalten?)

#define WHITE 0  //Weisses Pixel
#define BLACK 1  //Schwarzes Pixel

#ifdef LINIENZEICHNEN
// Erlaubte Werte fuer Zeichnungsmodus:
#define JAM0  0      //Pixel auf 0 setzen, oder wenn eine Farbe gesetzt das Gegenteil
#define JAM1  1      //Pixel auf 1 setzen, oder wenn eine Farbe gesetzt dann diese
#define JAM2  2      //reserviert fuer Farb-LCDs
#define COMPLEMENT 3 //Pixelfabe umkehren

// Alternative Namen fuer Zeichnungsmodus:
#define MODE_NORMAL JAM1
#define MODE_REVERS JAM0
#define MODE_TOGGLE COMPLEMENT

void glcd_drawmode(int8_t mode);           //Zeichnungsmodus setzen: JAM0, JAM1, oder COMPLEMENT
#define glcd_moveto glcd_cursor
void glcd_lineto(uint8_t x,uint8_t y);     //Linie vom aktuellen Cursor bis zur neuen Position zeichnen, ohne letzter Punkt
void glcd_lineto_last(uint8_t x,uint8_t y);//Linie vom aktuellen Cursor bis zur neuen Position inklusive letzter Punkt
void glcd_setzepunkt(uint8_t x,uint8_t y); //Einzelner Grafik-Punkt setzen
void glcd_drawbox(uint8_t x1,uint8_t y1,uint8_t x2,uint8_t y2); //Viereck zeichnen
#ifdef FIGURENFUELLEN
void glcd_fillbox(uint8_t x1,uint8_t y1,uint8_t x2,uint8_t y2); //gefuelltes Viereck zeichnen
#endif
#endif

#ifdef FONTTABELLE
void glcd_print(const char *str);  // Text an aktueller Cursor-Position ausgeben
void glcd_printc(uchar c);         // Einzelnes Zeichen an aktueller Cursor-Position ausgeben
void setze_zeilenabstand(uint8_t); // Zeilenabstand bei mehrzeiligen Texten
void glcd_printb(uchar c);  // Schreibe ein Byte eines Buchstabens (von glcd_printc() benutzt)
                            // Oder allgemeiner: wie lcdSendData() aber auch benutzbar mit y-Positionen
                            // die nicht durch 8 teilbar sind.
#endif

//Ende von LCD_TREIBER_H
#endif
