/* lcdsim.cc			letzte Aenderung: 12.1.2012 */
//#define VERSION "Version 0.2"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Simulation eines Grakif-LCDs 128x64

 Installation:
Fuer den Simulator muss xtekplot1 installiert werden:
xtekplot1.tar.gz downloaden von hier
http://www.rolfp.ch/xtekplot/
oder von hier
http://www.pci.uzh.ch/pfister/dist/get.html#tekplot

 Anwendung:
Im zu testenden Programm die Zeile
#include <avr/io.h>
ersetzen durch folgende Zeilen:
//-------------------
#ifdef LCD_SIMULATOR
#include "lcdsim.cc"
#else
#include <avr/io.h>
#endif
//-------------------
Dann uebersetzen mit
> c++ -I$h $h/xtekplot1.o -lm -lX11 -L/usr/X11R6/lib -DLCD_SIMULATOR beispiel.c -o beispiel
oder uebers makefile mit
> make simulator1

History:
8.12.2011       Erstellung (RP)
18.12.11        Ports definiert
30.12.11        #ifdef PIN_SIMULATION #ifdef TASTEN_SIMULATION
12.1.2012       Uhr-Simulation verbessert

*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <xtekplot1.h>

#define MILLIWAIT milliwait
#ifndef LCD_SIMULATOR
#define LCD_SIMULATOR
#endif
//Ports vom Atmega2560 fuer den Simulator:
static int PORTA=0,PORTB=0,PORTC=0,PORTD=0,PORTE=0,PORTF=0,PORTG=0,PORTH=0,PORTJ=0,PORTK=0,PORTL=0;
static int DDRA=0,DDRB=0,DDRC=0,DDRD=0,DDRE=0,DDRF=0,DDRG=0,DDRH=0,DDRJ=0,DDRK=0,DDRL=0;
static int PINA=0,PINB=0,PINC=0,PIND=0,PINE=0,PINF=0,PING=0,PINH=0,PINJ=0,PINK=0,PINL=0;
#define ANZAHLPORTS 11

#include "lcd_treiber.h"
#include "lcd_treiber.c"

static int SIM_PORT[ANZAHLPORTS],SIM_DDR[ANZAHLPORTS],SIM_PIN[ANZAHLPORTS];
void ports_simulieren(); //im Anwenderprogramm zu definieren (abhaengig von konkreter Schaltung)
#ifdef PIN_SIMULATION
void PIN_simulation();   //im Anwenderprogramm zu definieren (abhaengig von konkreter Schaltung)
#endif

void port_aktualisieren(int i)
{
 switch(i)
  {
   case 0: SIM_PORT[i]=PORTA; SIM_DDR[i]=DDRA; break;
   case 1: SIM_PORT[i]=PORTB; SIM_DDR[i]=DDRB; break;
   case 2: SIM_PORT[i]=PORTC; SIM_DDR[i]=DDRC; break;
   case 3: SIM_PORT[i]=PORTD; SIM_DDR[i]=DDRD; break;
   case 4: SIM_PORT[i]=PORTE; SIM_DDR[i]=DDRE; break;
   case 5: SIM_PORT[i]=PORTF; SIM_DDR[i]=DDRF; break;
   case 6: SIM_PORT[i]=PORTG; SIM_DDR[i]=DDRG; break;
   case 7: SIM_PORT[i]=PORTH; SIM_DDR[i]=DDRH; break;
   case 8: SIM_PORT[i]=PORTJ; SIM_DDR[i]=DDRJ; break;
   case 9: SIM_PORT[i]=PORTK; SIM_DDR[i]=DDRK; break;
   case 10:SIM_PORT[i]=PORTL; SIM_DDR[i]=DDRL; break;
  }
 ports_simulieren(); //Abhaengig von konkreter Schaltung die PORTS simulieren
}

void ports_check()
{
 int i= -1;
 i++; if(SIM_PORT[i]!=PORTA || SIM_DDR[i]!=DDRA) port_aktualisieren(i);
 i++; if(SIM_PORT[i]!=PORTB || SIM_DDR[i]!=DDRB) port_aktualisieren(i);
 i++; if(SIM_PORT[i]!=PORTC || SIM_DDR[i]!=DDRC) port_aktualisieren(i);
 i++; if(SIM_PORT[i]!=PORTD || SIM_DDR[i]!=DDRD) port_aktualisieren(i);
 i++; if(SIM_PORT[i]!=PORTE || SIM_DDR[i]!=DDRE) port_aktualisieren(i);
 i++; if(SIM_PORT[i]!=PORTF || SIM_DDR[i]!=DDRF) port_aktualisieren(i);
 i++; if(SIM_PORT[i]!=PORTG || SIM_DDR[i]!=DDRG) port_aktualisieren(i);
 i++; if(SIM_PORT[i]!=PORTH || SIM_DDR[i]!=DDRH) port_aktualisieren(i);
 i++; if(SIM_PORT[i]!=PORTJ || SIM_DDR[i]!=DDRJ) port_aktualisieren(i);
 i++; if(SIM_PORT[i]!=PORTK || SIM_DDR[i]!=DDRK) port_aktualisieren(i);
 i++; if(SIM_PORT[i]!=PORTL || SIM_DDR[i]!=DDRL) port_aktualisieren(i);
#ifdef PIN_SIMULATION
 PIN_simulation();
#endif
}

#ifdef TASTEN_SIMULATION
void tastendruck_simulation();
#endif
#ifdef UHR_SIMULATION
void UHR_SIMULATION();
#endif
#ifdef ZEITERHOEHEN_SIMULATION
void ZEITERHOEHEN_SIMULATION(int);
#endif

void milliwait(uint n) //etwa n Millisekunden warten
{
 //printf("milliwait(%d)\n",n);//test
#ifdef UHR_SIMULATION
 if(n>999) UHR_SIMULATION();
#ifdef ZEITERHOEHEN_SIMULATION
 else ZEITERHOEHEN_SIMULATION(n);
#endif
#endif
#ifdef TASTEN_SIMULATION
 tastendruck_simulation();
 //if(n>6) n-=6; else n=1; //ev. Zeitverbrauch beruecksichtigen
#endif
 ports_check();
 if(n<=1) return;//test
 const uint nmax=1000/25; //1000/50 bei 50 Hz Bildwiderhohlrate
 while(true)
  {waitTOF();
   waitmenu(0);                         //falls im menu 'exit' gewaehlt wurde,
   if(exitflag) {term_exit(); exit(0);} //dann Programm verlassen.
   if(n<nmax) break;
   n-=nmax;
  }
}

/************************* Vordeklarationen ***************************/
void rasterzeichnen();
void simprog(); // Auf dem LCD zu simulierendes Unterprogramm

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while((c= *s++)!=0)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 int i,j,c;
 if(argc<=0)
   ;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{//if(++j==1) strcpy(quellname,argv[i]);
		 //else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("lcdsim  %s\n",VERSION);
	 printf("Anwendung: lcdsim\n");
	 exit(0);
	}

 printf("XMAX=%d YMAX=%d\n",XMAX,YMAX);//test

 glcd_init();	// Grafik-LCD initialisieren 
 simprog();
 rasterzeichnen();

 while(exitflag==0 && waitmenu(1)==0)
	;// auf Benutzereingaben warten
 term_exit();
 return 0;
}/* ende von main */

//------------------------------------------------------------------------------
// Weitere Hardware simulieren
//Interrupt-Routinen vom Atmega2560 im Simulator vorlaeufig ignorieren:
#define ISR void SIMULATOR_ISR
#define TIMER1_COMPA_vect void* TIMER1_COMPA_vect

void twi_init() {} //I2C-Initialisierung ignorieren
void sei() {} //Interruptfreigabe ignorieren
void cli() {} //Interrupt stop ignorieren

//------------------------------------------------------------------------------
// Simulierte LEDs darstellen:
void led_simulieren(int lednr,int einaus)
{
 double x1=XMAX/64.0*lednr, y1 = -1 - 50.0/8, r1=2.0, r2=r1-1.0/8;
 if(einaus==0) color(0);
 fillcircle(x1,y1,r2,r2);
 if(einaus==0) color(1);
 drawcircle(x1,y1,r1,r1);
}

//------------------------------------------------------------------------------
// Simulierte Tastatur darstellen:
#ifdef TASTEN_SIMULATION
//static int tasten_d=5*8,tasten_x1=10*8,tasten_y1=512+120;
static int tasten_d=7*8,tasten_x1=45*8,tasten_y1=512+4*8;
static int tasten_x2=tasten_x1+6*tasten_d, tasten_y2=tasten_y1+5*tasten_d;

#ifdef TASTEN_BESCHRIFTUNG
void strsplit(const char *text,int c2,char *text1,char *text2)
{
 int c;
 while((c= *text++)!=0 && c!=c2) *text1++ = c;
 *text1=0;
 while(*text==c2) text++;
 while((c= *text++)!=0 && c!=c2) *text2++ = c;
 *text2=0;
}
#endif

void tastenmatrix_zeichnen()
{
 int d=tasten_d;
 idrawbox(tasten_x1,tasten_y1,tasten_x2,tasten_y2);
 for(int y=tasten_y1+d;y<tasten_y2;y+=d)
  {moveto(tasten_x1,y); lineto(tasten_x2,y);}
 for(int x=tasten_x1+d;x<tasten_x2;x+=d)
  {moveto(x,tasten_y1); lineto(x,tasten_y2);}
#ifdef TASTEN_BESCHRIFTUNG
 itextsize(d*2/8,d*3/8);
 setcolor(4,150,150,255); //hellblau
 setcolor(6,255,180,50); //goldgelb
 int k=0,d1,n;
 char text1[16],text2[16];
 for(int y=tasten_y1;y<tasten_y2;y+=d)
 for(int x=tasten_x1;x<tasten_x2;x+=d)
  {
   d1 = strlen(tasten_text[k])>2 ? d/8 : d/4;
   if(k==0) color(6); //goldgelb
   else if(k==1) color(4); //hellblau
   else if(k==2) color(2); //rot
   else color(1);
   ischrift(x+d1,y+d*11/16,tasten_text[k++]);
  }
 n=itextsize(d*2/15,d*3/15);
 //printf("itextsize() --> %d\n",n);//test
 k=0;
 for(int y=tasten_y1;y<tasten_y2;y+=d)
 for(int x=tasten_x1;x<tasten_x2;x+=d)
  {
   n=strlen(tasten_textgoldblue[k]);
   if(n>0)
    {strsplit(tasten_textgoldblue[k],' ',text1,text2);
     d1 = d/12;
     color(6); //2=rot, 3=gruen, 4=blau, 6=gelb
     ischrift(x+d1,y+d*3/12,text1);
     color(4); //2=rot, 3=gruen, 4=blau, 6=gelb
     d1 = strlen(text2)>3 ? d*5/12 : d*7/12;
     ischrift(x+d1,y+d*3/12,text2);
    }
   n=strlen(tasten_textgreenred[k]);
   if(n>0)
    {strsplit(tasten_textgreenred[k],' ',text1,text2);
     d1 = d/12;
     color(3); //2=rot, 3=gruen, 4=blau, 6=gelb
     ischrift(x+d1,y+d*11/12,text1);
     color(2); //2=rot, 3=gruen, 4=blau, 6=gelb
     n=strlen(text2);
     d1 = n>4 ? d/12 : (n>3 ? d*5/12 : d*7/12);
     ischrift(x+d1,y+d*11/12,text2);
    }
   k++;
  }
 color(1);
#endif
}
#endif

//------------------------------------------------------------------------------
void ports_simulieren() //Abhaengig von konkreter Schaltung die PORTS simulieren
{
 //Simulation von bis zu 3 LED's:
#ifdef PORT_LED1
 if((PORT_LED1&(1<<BIT_LED1))!=0 && (DDR_LED1&(1<<BIT_LED1))!=0) led_simulieren(1,1);
 else led_simulieren(1,0);
#endif
#ifdef PORT_LED2
 if((PORT_LED2&(1<<BIT_LED2))!=0 && (DDR_LED2&(1<<BIT_LED2))!=0) led_simulieren(2,1);
 else led_simulieren(2,0);
#endif
#ifdef PORT_LED3
 if((PORT_LED3&(1<<BIT_LED3))!=0 && (DDR_LED3&(1<<BIT_LED3))!=0) led_simulieren(3,1);
 else led_simulieren(3,0);
#endif

#ifdef TASTEN_SIMULATION
 //Simulation einer Tastenmatrix:
 tastenmatrix_zeichnen();
#endif
}

#define main main_avr
int main_avr();

void simprog() // Das Unterprogramm welches auf simuliertem LCD getestet werden soll
{
 main_avr();
}
