/* matrixsim.cc     Simulator fuer eine Matrixtastatur
letzte Aenderung: 30.12.2011

Anwendung im Hauptprogramm:
---------------------------
#define PORT_MATRIXOUT PORTE //Mit Spalten verbundener Port
#define DDR_MATRIXOUT  DDRE
#define PORT_MATRIXIN  PORTF //Mit Reihen verbundener Port
#define PIN_MATRIXIN   PINF
#define DDR_MATRIXIN   DDRF
#define NREIHEN 5            //Groesse der Matrix
#define NSPALTEN 6
#include "matrixsim.cc"
---------------------------
*/

static int matrixtasten[NREIHEN*NSPALTEN];

void matrix_init()
{
 for(int j=0;j<NSPALTEN;j++)
   for(int i=0,imalnspalten=0;i<NREIHEN;i++,imalnspalten+=NSPALTEN)
     matrixtasten[imalnspalten+j]=1;  //0=gedrueckt, 1=losgelassen
}

void PIN_simulation()
{
 int pin=0xFF;
 for(int j=0,jmaske=1;j<NSPALTEN;j++,jmaske<<=1)
  for(int i=0,maske=1;i<NREIHEN;i++,maske<<=1)
   {
    if(matrixtasten[i*NSPALTEN+j]==0 && (PORT_MATRIXOUT&jmaske)==0 && (DDR_MATRIXOUT&jmaske)!=0)
                     //wenn Taste gedrueck und PORT-Bit auf 0 und DDR-Bit auf 1 gesetzt sind,
     {
      pin &= ~maske; //dann Bit auf 0 setzen
     }
   }
 PIN_MATRIXIN=pin;
}

void tastendruck_simulation()
{
 int n,d=tasten_d;
 int x,y,x3,y3;
 //printf("tastendruck_simulation()\n");//test
 n=imausposition(&x,&y);
 //printf(" n=%d x=%d y=%d\n",n,x,y);//test
 if(n==LIMAUS) //linke Maustaste gedrueckt?
  {
   for(int j=0;j<NSPALTEN;j++)
    for(int i=0;i<NREIHEN;i++) //Testen ob innerhalb Tastenfeld und wenn ja welche Taste
     {
      x3=tasten_x1+j*d;
      y3=tasten_y1+i*d;
      if(x>x3 && x<x3+d && y>y3 && y<y3+d)
       {
	matrixtasten[i*NSPALTEN+j]=0;
       }
      else
        matrixtasten[i*NSPALTEN+j]=1;
     }
  }
 else matrix_init(); //Maustaste nicht gedrueckt --> alle Tasten losgelassen
}
